-- Created by: Black Book
-- Discord: Black Book / Rebel Anarchy
-- Version: 1.01 ( Presets fixed to accurate numbers )

local presets = {
    -- Default values:
    -- { 2,       4,     11,         16,       20,         30,    50,      66 }
    -- { toddler, child, adolescent, teenager, youngadult, adult, midaged, senior} 
    Teenager = { 2, 4, 11, 16, 8500, 9000, 9500, 10000 }, -- set this if you have a teenager character
    YoungAdult = { 2, 4, 11, 16, 20, 9000, 9500, 10000 }, -- set this is you have a young adult character
    Adult =      { 2, 4, 11, 16, 20, 30, 9500, 10000 }, -- set this if you have an adult character
    MiddleAged = { 2, 4, 11, 16, 20, 30, 50, 10000 }, -- set this if you have an middleaged character
}

return {
    EnableDebugLogging = false, -- Keep this at false.
    
    ModifyAgingData = true,
    TargetMaxAge = 10000, -- Set as high as you want / not sure what kind of effects it has.

    -- You have to set the preset strictly to the age of your character to prevent weird age shifts from happening.
    SelectedGrowthAgesPreset = "YoungAdult", -- "Senior" / "MiddleAged" / "Adult" / "YoungAdult"
    GrowthAgesPresets = presets, 
    TargetGrowingStepElement = 244, -- Still being researched why the maximum value is 244.

    ModifyTimeConfig = true,
    TargetTimeScaleFast = 10.0,
    TargetTimeScaleVeryFast = 100.0,
    TargetMaxTimeScale = 100.0 -- I suggest using a lower number like 50 if your pc can't handle it.
}