---@meta

---@class FAppleARKitCamera
---@field TrackingQuality EARTrackingQuality
---@field TrackingQualityReason EARTrackingQualityReason
---@field Transform FTransform
---@field orientation FQuat
---@field Translation FVector
---@field ImageResolution FVector2D
---@field FocalLength FVector2D
---@field PrincipalPoint FVector2D
local FAppleARKitCamera = {}



---@class FAppleARKitFrame
local FAppleARKitFrame = {}


---@class FAppleARKitLightEstimate
---@field bIsValid boolean
---@field AmbientIntensity float
---@field AmbientColorTemperatureKelvin float
local FAppleARKitLightEstimate = {}



---@class UARKitCameraOverlayMaterialLoader : UObject
---@field DefaultCameraOverlayMaterial UMaterialInterface
---@field DepthOcclusionOverlayMaterial UMaterialInterface
---@field MatteOcclusionOverlayMaterial UMaterialInterface
---@field SceneDepthOcclusionMaterial UMaterialInterface
---@field SceneDepthColorationMaterial UMaterialInterface
local UARKitCameraOverlayMaterialLoader = {}



---@class UARKitGeoTrackingSupport : UARGeoTrackingSupport
local UARKitGeoTrackingSupport = {}


---@class UARKitMeshGeometry : UARMeshGeometry
local UARKitMeshGeometry = {}


---@class UAppleARKitCameraVideoTexture : UARTextureCameraImage
local UAppleARKitCameraVideoTexture = {}


---@class UAppleARKitEnvironmentCaptureProbe : UAREnvironmentCaptureProbe
---@field ARKitEnvironmentTexture UAppleARKitEnvironmentCaptureProbeTexture
local UAppleARKitEnvironmentCaptureProbe = {}



---@class UAppleARKitEnvironmentCaptureProbeTexture : UAREnvironmentCaptureProbeTexture
local UAppleARKitEnvironmentCaptureProbeTexture = {}


---@class UAppleARKitOcclusionTexture : UARTexture
local UAppleARKitOcclusionTexture = {}


---@class UAppleARKitSettings : UObject
---@field bRequireARKitSupport boolean
---@field FaceTrackingLogDir FString
---@field LivelinkTrackingTypes TArray<ELivelinkTrackingType>
---@field bFaceTrackingLogData boolean
---@field bFaceTrackingWriteEachFrame boolean
---@field FaceTrackingFileWriterType EARFaceTrackingFileWriterType
---@field bShouldWriteCameraImagePerFrame boolean
---@field WrittenCameraImageScale float
---@field WrittenCameraImageQuality int32
---@field WrittenCameraImageRotation ETextureRotationDirection
---@field LiveLinkPublishingPort int32
---@field DefaultFaceTrackingLiveLinkSubjectName FName
---@field DefaultPoseTrackingLiveLinkSubjectName FName
---@field DefaultFaceTrackingDirection EARFaceTrackingDirection
---@field bAdjustThreadPrioritiesDuringARSession boolean
---@field GameThreadPriorityOverride int32
---@field RenderThreadPriorityOverride int32
---@field ARKitTimecodeProvider FString
local UAppleARKitSettings = {}



---@class UAppleARKitTextureCameraDepth : UARTextureCameraDepth
local UAppleARKitTextureCameraDepth = {}


---@class UAppleARKitTextureCameraImage : UARTextureCameraImage
local UAppleARKitTextureCameraImage = {}


---@class UAppleARKitTimecodeProvider : UTimecodeProvider
local UAppleARKitTimecodeProvider = {}


---@class UDEPRECATED_MaterialExpressionARKitPassthroughCamera : UMaterialExpression
---@field Coordinates FExpressionInput
---@field ConstCoordinate uint32
---@field TextureType EARKitTextureType
local UDEPRECATED_MaterialExpressionARKitPassthroughCamera = {}



