---@meta

---@class FAnimNode_BlendStack : FAnimNode_BlendStack_Standalone
---@field AnimationAsset UAnimationAsset
---@field AnimationTime float
---@field bLoop boolean
---@field bMirrored boolean
---@field WantedPlayRate float
---@field BlendTime float
---@field MaxAnimationDeltaTime float
---@field BlendProfile UBlendProfile
---@field BlendOption EAlphaBlendOption
---@field BlendParameters FVector
---@field MirrorDataTable UMirrorDataTable
---@field bUseInertialBlend boolean
---@field bResetOnBecomingRelevant boolean
local FAnimNode_BlendStack = {}



---@class FAnimNode_BlendStackInput : FAnimNode_Base
---@field SampleIndex int32
---@field BlendStackAllocationIndex int32
---@field bOverridePlayRate boolean
---@field PlayRate float
local FAnimNode_BlendStackInput = {}



---@class FAnimNode_BlendStack_Standalone : FAnimNode_AssetPlayerBase
---@field PerSampleGraphPoseLinks TArray<FPoseLink>
---@field AnimPlayers TArray<FBlendStackAnimPlayer>
---@field bShouldFilterNotifies boolean
---@field MaxActiveBlends int32
---@field bStoreBlendedPose boolean
---@field NotifyRecencyTimeOut float
---@field MaxBlendInTimeToOverrideAnimation float
---@field PlayerDepthBlendInTimeMultiplier float
local FAnimNode_BlendStack_Standalone = {}



---@class FBlendStackAnimNodeReference : FAnimNodeReference
local FBlendStackAnimNodeReference = {}


---@class FBlendStackAnimPlayer
---@field SequencePlayerNode FAnimNode_SequencePlayer_Standalone
---@field BlendSpacePlayerNode FAnimNode_BlendSpacePlayer_Standalone
---@field MirrorNode FAnimNode_Mirror_Standalone
local FBlendStackAnimPlayer = {}



---@class FBlendStackInputAnimNodeReference : FAnimNodeReference
local FBlendStackInputAnimNodeReference = {}


---@class UBlendStackAnimNodeLibrary : UBlueprintFunctionLibrary
local UBlendStackAnimNodeLibrary = {}

---@param Node FAnimNodeReference
---@return float
function UBlendStackAnimNodeLibrary:GetCurrentBlendStackAnimAssetTime(Node) end
---@param Node FAnimNodeReference
---@return UAnimationAsset
function UBlendStackAnimNodeLibrary:GetCurrentBlendStackAnimAsset(Node) end
---@param BlendStackNode FBlendStackAnimNodeReference
function UBlendStackAnimNodeLibrary:ForceBlendNextUpdate(BlendStackNode) end
---@param Node FAnimNodeReference
---@param BlendStackNode FBlendStackAnimNodeReference
---@param Result boolean
function UBlendStackAnimNodeLibrary:ConvertToBlendStackNodePure(Node, BlendStackNode, Result) end
---@param Node FAnimNodeReference
---@param Result EAnimNodeReferenceConversionResult
---@return FBlendStackAnimNodeReference
function UBlendStackAnimNodeLibrary:ConvertToBlendStackNode(Node, Result) end
---@param Context FAnimUpdateContext
---@param BlendStackNode FBlendStackAnimNodeReference
---@param AnimationAsset UAnimationAsset
---@param AnimationTime float
---@param bLoop boolean
---@param bMirrored boolean
---@param BlendTime float
---@param BlendParameters FVector
---@param WantedPlayRate float
---@param ActivationDelay float
function UBlendStackAnimNodeLibrary:BlendTo(Context, BlendStackNode, AnimationAsset, AnimationTime, bLoop, bMirrored, BlendTime, BlendParameters, WantedPlayRate, ActivationDelay) end


---@class UBlendStackInputAnimNodeLibrary : UBlueprintFunctionLibrary
local UBlendStackInputAnimNodeLibrary = {}

---@param BlendStackInputNode FBlendStackInputAnimNodeReference
---@param AnimationAsset UAnimationAsset
---@param AccumulatedTime float
function UBlendStackInputAnimNodeLibrary:GetProperties(BlendStackInputNode, AnimationAsset, AccumulatedTime) end
---@param Node FAnimNodeReference
---@param BlendStackInputNode FBlendStackInputAnimNodeReference
---@param Result boolean
function UBlendStackInputAnimNodeLibrary:ConvertToBlendStackInputNodePure(Node, BlendStackInputNode, Result) end
---@param Node FAnimNodeReference
---@param Result EAnimNodeReferenceConversionResult
---@return FBlendStackInputAnimNodeReference
function UBlendStackInputAnimNodeLibrary:ConvertToBlendStackInputNode(Node, Result) end


