---@meta

---@class AB1AIController : AAIController
local AB1AIController = {}


---@class AB1AirborneObject : AB1GameObject
---@field AirborneHeight float
local AB1AirborneObject = {}



---@class AB1AppearanceCharacter : AB1Character
---@field FemaleIdleAnims TMap<EB1BodyAgeType, FB1AppearanceAnimationList>
---@field MaleIdleAnims TMap<EB1BodyAgeType, FB1AppearanceAnimationList>
---@field FemaleBodyCustomizePose TMap<EB1BodyAgeType, TSoftObjectPtr<UAnimSequence>>
---@field MaleBodyCustomizePose TMap<EB1BodyAgeType, TSoftObjectPtr<UAnimSequence>>
---@field FemaleFaceCustomizePose TMap<EB1BodyAgeType, TSoftObjectPtr<UAnimSequence>>
---@field MaleFaceCustomizePose TMap<EB1BodyAgeType, TSoftObjectPtr<UAnimSequence>>
---@field FemaleHandCustomizePose TMap<EB1BodyAgeType, TSoftObjectPtr<UAnimSequence>>
---@field MaleHandCustomizePose TMap<EB1BodyAgeType, TSoftObjectPtr<UAnimSequence>>
---@field FemaleWristCustomizePose TMap<EB1BodyAgeType, TSoftObjectPtr<UAnimSequence>>
---@field MaleWristCustomizePose TMap<EB1BodyAgeType, TSoftObjectPtr<UAnimSequence>>
---@field LevelNameForLevelSequence TArray<FName>
---@field FemaleLevelSequence FName
---@field MaleLevelSequence FName
---@field ChildLevelSequence FName
---@field LevelSequenceInfoListWhenEnteringTraitSelectMode TArray<FB1TraitSelectModeLevelSequenceInfo>
---@field LevelSequenceInfoListWhenExitingTraitSelectMode TArray<FB1TraitSelectModeLevelSequenceInfo>
---@field FaceCustomizePhysics TSoftObjectPtr<UPhysicsAsset>
---@field FaceCustomizePhysicsGroup TSoftObjectPtr<UPhysicsAsset>
---@field FaceCustomizePhysicsDetail TSoftObjectPtr<UPhysicsAsset>
---@field FaceHighlightMaterial TSoftObjectPtr<UMaterialInterface>
---@field FaceHighlightData TArray<FB1FaceModifierHighlight>
---@field FaceMaskBlack TSoftObjectPtr<UTexture>
---@field BodyCustomizePhysics TMap<EB1BodyAgeType, TSoftObjectPtr<UPhysicsAsset>>
---@field FemaleBodyHighlightData TArray<FB1BodyModifierHighlight>
---@field MaleBodyHighlightData TArray<FB1BodyModifierHighlight>
---@field FemaleBodyHighlightTable TMap<FName, FB1BodyModifierHighlight>
---@field MaleBodyHighlightTable TMap<FName, FB1BodyModifierHighlight>
---@field FaceHighlightTable TMap<FName, FB1FaceModifierHighlight>
---@field BodyHighlightMaterials TMap<EB1AppearanceParts, TSoftObjectPtr<UMaterialInterface>>
---@field GizmoBP TSoftClassPtr<AB1GizmoActor>
---@field DetailDotMesh TSoftObjectPtr<UStaticMesh>
---@field GroupDotMesh TSoftObjectPtr<UStaticMesh>
---@field GizmoDraggingUnit float
---@field GizmoMovingSpeed float
---@field DotDefaultIntensity float
---@field DotDimmedIntensity float
---@field ChangeTabDotFadeOutTime float
---@field HoveredDotFadeTime float
---@field MirrorDotShowRange float
---@field DotShowRange float
---@field RotationAndScaleAxisShowRange float
---@field GizmoMouseHoverScale float
---@field GizmoActors TArray<AB1GizmoActor>
---@field PrintedAccessoryGizmoActors TMap<EB1GizmoAxisType, AB1GizmoActor>
---@field DetailDots TArray<UB1CharacterCustomizeDotComponent>
---@field GroupDots TArray<UB1CharacterCustomizeDotComponent>
---@field CachedFaceDataAsset UB1FaceShapeCustomizeDataAsset
---@field CachedBodyDataAsset UB1BodyShapeCustomizeDataAsset
---@field CachedHighlightMasks TMap<FName, UTexture>
---@field DefaultFacePhysics UPhysicsAsset
---@field DefaultBodyPhysics UPhysicsAsset
---@field TransformAnchor AActor
---@field SaveManager UB1CustomizeDataManager
local AB1AppearanceCharacter = {}



---@class AB1BookObject : AB1CarriableObject
local AB1BookObject = {}


---@class AB1BuildModeAirborne : AB1BuildModeFurniture
local AB1BuildModeAirborne = {}


---@class AB1BuildModeCeilObject : AB1BuildModeFurniture
local AB1BuildModeCeilObject = {}


---@class AB1BuildModeDoor : AB1BuildModeFurniture
local AB1BuildModeDoor = {}


---@class AB1BuildModeFence : AB1BuildModeFurniture
---@field PositiveColor FLinearColor
---@field NagativeColor FLinearColor
local AB1BuildModeFence = {}



---@class AB1BuildModeFloorObject : AB1BuildModeFurniture
local AB1BuildModeFloorObject = {}


---@class AB1BuildModeFurniture : AActor
---@field OverlappedISMComponent UInstancedStaticMeshComponent
---@field DeletionCandidateISMComponent UInstancedStaticMeshComponent
---@field OverlappedISlotSMComponent UInstancedStaticMeshComponent
---@field BuildPointISMComponent UInstancedStaticMeshComponent
local AB1BuildModeFurniture = {}



---@class AB1BuildModeGate : AB1BuildModeFurniture
local AB1BuildModeGate = {}


---@class AB1BuildModeLadder : AB1BuildModeSnappedFurniture
local AB1BuildModeLadder = {}


---@class AB1BuildModePawn : ADefaultPawn
---@field BuildModeFurniture AB1BuildModeFurniture
---@field ConstructingWallCursor AB1ConstructingWalls
---@field RoomShaper AB1ShapingRoom
---@field MovingWallCursor AB1MovingWalls
---@field MovingFenceCursor AB1MovingFence
---@field LastSavedSiteAssets UDataTable
local AB1BuildModePawn = {}



---@class AB1BuildModePillar : AB1BuildModeFurniture
local AB1BuildModePillar = {}


---@class AB1BuildModePrinted : AB1BuildModeFurniture
local AB1BuildModePrinted = {}


---@class AB1BuildModeRoof : AB1BuildModeFurniture
local AB1BuildModeRoof = {}


---@class AB1BuildModeSceneCaptureStudio : AActor
local AB1BuildModeSceneCaptureStudio = {}


---@class AB1BuildModeSitePreset : AB1BuildModeFurniture
local AB1BuildModeSitePreset = {}


---@class AB1BuildModeSnappedFurniture : AB1BuildModeFurniture
local AB1BuildModeSnappedFurniture = {}


---@class AB1BuildModeStairs : AB1BuildModeSnappedFurniture
local AB1BuildModeStairs = {}


---@class AB1BuildModeWallObject : AB1BuildModeFurniture
local AB1BuildModeWallObject = {}


---@class AB1BuildModeWindow : AB1BuildModeFurniture
local AB1BuildModeWindow = {}


---@class AB1CameraTargetActor : AActor
---@field SpringArmComponent USpringArmComponent
---@field GameCamera UCameraComponent
local AB1CameraTargetActor = {}



---@class AB1CameraVolume : AActor
---@field BoxComponent UBoxComponent
---@field TargetCameraMode EB1CameraModeType
---@field bIgnoreClickOutsideBounds boolean
---@field Priority float
---@field CameraModeVolume FB1CameraModeVolume
local AB1CameraVolume = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1CameraVolume:OnEndOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1CameraVolume:OnBeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end


---@class AB1CarriableObject : AB1GameObject
---@field CarryPointComponent USceneComponent
local AB1CarriableObject = {}



---@class AB1ChangingFloorHeight : AB1MovingFloorBase
local AB1ChangingFloorHeight = {}


---@class AB1Character : ACharacter
---@field EntityID FB1EntityId
---@field FamilyId FB1EntityId
---@field VehicleOwnershipData FB1VehicleOwnershipData
---@field AttachParentId FB1EntityId
---@field AttachChildId FB1EntityId
---@field AppearanceComponent UB1AppearanceComponent
---@field AgingComponent UB1AgingComponent
---@field PlayerLightingChannels FLightingChannels
---@field CharacterLightingChannels FLightingChannels
---@field MainInterval float
---@field GoBackHomeGuideLimitTime float
local AB1Character = {}

---@return boolean
function AB1Character:IsInFlooredSpaceAnyway() end
---@return boolean
function AB1Character:IsInCoveredSpaceAnyway() end
---@return boolean
function AB1Character:IsInClosedSpaceAnyway() end
---@return float
function AB1Character:GetCharacterCullDistance() end
---@return AB1PlayerState
function AB1Character:GetB1PlayerState() end
---@param InCharacterAttribute FB1CharacterAttribute
function AB1Character:ChangeAppearance(InCharacterAttribute) end


---@class AB1CharacterDestIndicator : AActor
---@field NiagaraComponent UNiagaraComponent
---@field Threshold float
---@field OffsetLocation FVector
local AB1CharacterDestIndicator = {}



---@class AB1CharacterSpawnActor : AB1SpawnActorBase
local AB1CharacterSpawnActor = {}


---@class AB1CharacterStartEffect : AActor
---@field NiagaraComponent UNiagaraComponent
---@field OffsetMale FVector
---@field OffsetFemale FVector
---@field LifetimeSec float
local AB1CharacterStartEffect = {}



---@class AB1CinemaCharacter : AB1Character
---@field PresetId FName
---@field AppearanceSetting FB1AppearanceSetting
local AB1CinemaCharacter = {}

---@param InType EB1CinemaCharacterType
---@param bCopyOutFit boolean
function AB1CinemaCharacter:RequestCopyCharacter(InType, bCopyOutFit) end
---@param InOutfitId FName
function AB1CinemaCharacter:RequestChangeOutfit(InOutfitId) end


---@class AB1ConstructingWalls : AActor
---@field PositiveColor FLinearColor
---@field NagativeColor FLinearColor
---@field BaseWallUnitWidth float
---@field BaseWallUnitHeight float
---@field OverlappedISMComponent UInstancedStaticMeshComponent
---@field LockISMComponent UInstancedStaticMeshComponent
local AB1ConstructingWalls = {}



---@class AB1ConvertedISMActor : AActor
local AB1ConvertedISMActor = {}


---@class AB1CustomizeLevel : AB1LevelScriptActor
local AB1CustomizeLevel = {}


---@class AB1DoorObject : AB1GameObject
---@field InvisibleBlockingWallComponent UBoxComponent
---@field DoorTemplateId FName
---@field DoorDirectionFX UNiagaraComponent
---@field DoorToggleCheckBoxComponent UBoxComponent
---@field DoorMeshComponent UStaticMeshComponent
---@field DoorSound TWeakObjectPtr<UAudioComponent>
---@field CachedPossessCharacter TWeakObjectPtr<AB1Character>
---@field DevelopersPermissionsMessageId FName
local AB1DoorObject = {}

---@param InDataCacheGroup EB1CharacterDataCacheGroup
---@param InCharacterDataCacheType EB1CharacterDataCacheType
function AB1DoorObject:UpdateDataCacheData(InDataCacheGroup, InCharacterDataCacheType) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1DoorObject:OnEndOverlapDoorToggle(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function AB1DoorObject:OnBeginOverlapDoorToggle(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class AB1DraggingFence : AActor
---@field MovingSpeed float
---@field PositiveColor FLinearColor
---@field NagativeColor FLinearColor
---@field Opacity float
local AB1DraggingFence = {}



---@class AB1DraggingWall : AB1WallsSilhouette
---@field MovingSpeed float
local AB1DraggingWall = {}



---@class AB1DustyFloorGameObject : AB1GameObject
local AB1DustyFloorGameObject = {}


---@class AB1ElevatingWalls : AActor
local AB1ElevatingWalls = {}


---@class AB1ElevatorActor : AB1LocatorActor
---@field TeleportLinkedElevatorActor AB1ElevatorActor
---@field BlockingWallComponent UStaticMeshComponent
---@field OpenCheckBoxComponent UBoxComponent
---@field TeleportCheckBoxComponent UBoxComponent
---@field TeleportPointComponent USceneComponent
---@field ObjectLocation USceneComponent
local AB1ElevatorActor = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1ElevatorActor:OnTeleportCheckBox_BeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
function AB1ElevatorActor:OnOpenDoor() end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1ElevatorActor:OnOpenCheckBox_EndOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1ElevatorActor:OnOpenCheckBox_BeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
function AB1ElevatorActor:OnCloseDoor() end
---@param InDestination FVector
function AB1ElevatorActor:OnArrived(InDestination) end


---@class AB1ElevatorBox : AActor
local AB1ElevatorBox = {}


---@class AB1EnvironmentAudioVolumeActor : AActor
---@field AudioColorMapInfos TArray<FB1EnvironmentAudioColorMapInfo>
---@field CurrentPixelLocation FVector2D
---@field MapWidthCenti int32
---@field MapHeightCenti int32
---@field PixelPerUnitCenti float
---@field SoundscapePalette USoundscapePalette
---@field AffectGamePlayTag FGameplayTag
---@field DebugRenderIndex int32
local AB1EnvironmentAudioVolumeActor = {}



---@class AB1FenceBaseObject : AB1GameObject
local AB1FenceBaseObject = {}


---@class AB1Fireworks : AActor
---@field AnimMontage UAnimMontage
---@field LoopBehavior EB1FireworksLoopState
---@field EventHour TArray<int32>
---@field LoopCount int32
---@field StopHour TArray<int32>
local AB1Fireworks = {}



---@class AB1FloorObjects : AActor
---@field FloorComponent UB1FloorComponent
---@field PoolWaterMeshesTemplate UDynamicMeshComponent
local AB1FloorObjects = {}



---@class AB1FoodObject : AB1CarriableObject
---@field StaticMeshCompList TArray<UStaticMeshComponent>
local AB1FoodObject = {}



---@class AB1FoundationMold : AB1WallDecoObjectBase
---@field MoldLineFrag FB1FoundationMoldFrag
---@field MoldSideFrag FB1FoundationMoldFrag
---@field MoldInnerCBFrag FB1FoundationMoldFrag
---@field MoldOuterCBFrag FB1FoundationMoldFrag
---@field MoldInnerD2Frag FB1FoundationMoldFrag
---@field MoldOuterD2Frag FB1FoundationMoldFrag
---@field MaxDrawDistance float
local AB1FoundationMold = {}



---@class AB1FoundationObjects : AActor
local AB1FoundationObjects = {}


---@class AB1FxObjectActor : AActor
local AB1FxObjectActor = {}


---@class AB1GableRoofObject : AB1RoofObject
---@field WallMeshComponent UInstancedStaticMeshComponent
---@field SlopeMeshComponent UInstancedStaticMeshComponent
---@field SlopeRidgeMeshComponent UInstancedStaticMeshComponent
---@field RoofFloorMeshComponent UInstancedStaticMeshComponent
---@field FramePartsCount int32
---@field WallSize FVector
---@field CrackTolerance float
---@field WallThickness float
---@field SlopeThickness float
---@field FloorThickness float
---@field ExtendedLeftSlopeWidth float
---@field ExtendedRightSlopeWidth float
---@field ExtendedSlopeHeight float
---@field CurrentAccessorySet FName
---@field AccessorySet TMap<FName, FB1GableRoofFragSet>
local AB1GableRoofObject = {}



---@class AB1GameLevel : AB1LevelScriptActor
local AB1GameLevel = {}


---@class AB1GameModeBase : AGameModeBase
---@field DebugActor AB1GameObjectDebugActor
local AB1GameModeBase = {}



---@class AB1GameObject : AB1GameObjectBase
---@field MeshRootComponent USceneComponent
---@field PrintedMeshComponent UStaticMeshComponent
---@field ObjectDataTableId FName
---@field PrintedMeshId FString
---@field PrintedMeshOffset FVector
---@field IsCameraCollision boolean
---@field CustomizeComponent UB1GameObjectCustomizeComponent
---@field EntityID FB1EntityId
---@field ParentSiteId FName
---@field InteracteeComponent UB1InteracteeComponent
---@field LookAtComponent UB1LookAtComponent
---@field StateComponent UB1StateComponent
---@field ObjectAreaBoxComponent UB1ObjectAreaBoxComponent
---@field AnimNotifySounds TArray<TWeakObjectPtr<UAudioComponent>>
---@field ObjectStateSound TWeakObjectPtr<UAudioComponent>
---@field SubMaterialComponent UB1SubMaterialComponent
---@field UROComponent UB1GameObjectUROComponent
---@field Quality EB1Quality
---@field Price int64
---@field CustomName FText
local AB1GameObject = {}

---@param AnimMontage UAnimMontage
---@param bInterrupted boolean
function AB1GameObject:OnMontageEnded(AnimMontage, bInterrupted) end
---@param AnimMontage UAnimMontage
---@param bInterrupted boolean
function AB1GameObject:OnMontageBlendingOut(AnimMontage, bInterrupted) end
function AB1GameObject:InitializeInConstruction() end
---@return FString
function AB1GameObject:GetDebugString() end


---@class AB1GameObjectDebugActor : AActor
---@field Characters TArray<TWeakObjectPtr<AB1Player>>
---@field GameObjects TArray<TWeakObjectPtr<AB1GameObject>>
---@field Vehicles TArray<TWeakObjectPtr<AB1VehiclePawn>>
local AB1GameObjectDebugActor = {}



---@class AB1GameObject_Skeletal : AB1GameObject
---@field IdleMontages TArray<UAnimMontage>
---@field SkeletalMeshComponent USkeletalMeshComponent
local AB1GameObject_Skeletal = {}



---@class AB1GameState : AGameStateBase
local AB1GameState = {}


---@class AB1GarageDoorObject : AB1DoorObject
local AB1GarageDoorObject = {}


---@class AB1GateObject : AB1DoorObject
---@field LogicalGridX int32
local AB1GateObject = {}



---@class AB1GenerateMotionCharacter : AB1Character
---@field PositionPawn AActor
---@field FemaleIdleAnims TMap<EB1BodyAgeType, FB1GenerateMotionIdleAnimData>
---@field MaleIdleAnims TMap<EB1BodyAgeType, FB1GenerateMotionIdleAnimData>
local AB1GenerateMotionCharacter = {}



---@class AB1GizmoActor : AActor
---@field MovingSpeedMap TMap<EB1GizmoTransformType, float>
---@field ScaleLimit FVector2D
---@field ScaleFactor float
---@field OverScaleRatio float
---@field NonOverScaleRatio float
---@field GizmoColorSet FB1GizmoColorSet
---@field OutlineThickness float
---@field OutlineScaleLimit FVector2D
local AB1GizmoActor = {}



---@class AB1HalfGableRoofObject : AB1RoofObject
---@field WallMeshComponent UInstancedStaticMeshComponent
---@field WallRectMeshComponent UInstancedStaticMeshComponent
---@field SlopeMeshComponent UInstancedStaticMeshComponent
---@field RoofFloorMeshComponent UInstancedStaticMeshComponent
---@field FramePartsCount int32
---@field WallSize FVector
---@field CrackTolerance float
---@field WallThickness float
---@field SlopeThickness float
---@field FloorThickness float
---@field ExtendedSlopeWidth float
---@field ExtendedSlopeHeight float
---@field CurrentAccessorySet FName
---@field AccessorySet TMap<FName, FB1HalfGableRoofFragSet>
local AB1HalfGableRoofObject = {}



---@class AB1HalfHipRoofObject : AB1RoofObject
---@field FramePartsCount int32
---@field WallSize FVector
---@field FloorThickness float
---@field WallThickness float
---@field SlopeThickness float
---@field ExtendedSlopeWidth float
---@field ExtendedSlopeHeight float
---@field CurrentAccessorySet FName
---@field AccessorySet TMap<FName, FB1HalfHipRoofFragSet>
---@field TestVal FVector
---@field RoofFloorMeshComponent UInstancedStaticMeshComponent
---@field WallMeshComponent UInstancedStaticMeshComponent
---@field WallRectMeshComponent UInstancedStaticMeshComponent
---@field SlopeRightMeshComponent UInstancedStaticMeshComponent
---@field SlopeLeftMeshComponent UInstancedStaticMeshComponent
---@field SlopeRectMeshComponent UInstancedStaticMeshComponent
---@field SlopePeakMeshComponent UInstancedStaticMeshComponent
local AB1HalfHipRoofObject = {}



---@class AB1HalfWallCover : AB1WallDecoObjectBase
---@field Base25Cover TSoftObjectPtr<UStaticMesh>
---@field Base50Cover TSoftObjectPtr<UStaticMesh>
---@field Base100Cover TSoftObjectPtr<UStaticMesh>
---@field Corner2Cover TSoftObjectPtr<UStaticMesh>
---@field CornerD2Cover TSoftObjectPtr<UStaticMesh>
---@field CornerD3Cover TSoftObjectPtr<UStaticMesh>
---@field Corner4Cover TSoftObjectPtr<UStaticMesh>
---@field HoverColor FLinearColor
---@field SelectedColor FLinearColor
---@field BrushedColor FLinearColor
---@field LineThickness float
local AB1HalfWallCover = {}



---@class AB1HalfWallRailing : AB1WallDecoObjectBase
---@field BasePillarMesh TSoftObjectPtr<UStaticMesh>
---@field BaseRailingMesh TSoftObjectPtr<UStaticMesh>
---@field Base100FloorMesh TSoftObjectPtr<UStaticMesh>
---@field Corner2Cover TSoftObjectPtr<UStaticMesh>
---@field CornerD2Cover TSoftObjectPtr<UStaticMesh>
---@field CornerD3Cover TSoftObjectPtr<UStaticMesh>
---@field Corner4Cover TSoftObjectPtr<UStaticMesh>
---@field HoverColor FLinearColor
---@field SelectedColor FLinearColor
---@field BrushedColor FLinearColor
---@field LineThickness float
local AB1HalfWallRailing = {}



---@class AB1HipRoofObject : AB1RoofObject
---@field FramePartsCount int32
---@field WallSize FVector
---@field FloorThickness float
---@field SlopeThickness float
---@field ExtendedSlopeHeight float
---@field CurrentAccessorySet FName
---@field AccessorySet TMap<FName, FB1HipRoofFragSet>
---@field RoofFloorMeshComponent UInstancedStaticMeshComponent
---@field SlopeLeftMeshComponent UInstancedStaticMeshComponent
---@field SlopeRightMeshComponent UInstancedStaticMeshComponent
---@field SlopeRectMeshComponent UInstancedStaticMeshComponent
---@field SlopeRidgeMeshComponent UInstancedStaticMeshComponent
local AB1HipRoofObject = {}



---@class AB1ISMActor : AActor
local AB1ISMActor = {}


---@class AB1ImageTo3DCaptureStudio : AActor
---@field CaptureObject AB1GameObject
---@field CameraWheelSpeed float
---@field CameraMoveSpeed float
---@field RollPitchYaw FVector
local AB1ImageTo3DCaptureStudio = {}



---@class AB1IntroLevel : AB1LevelScriptActor
---@field WidgetClass TSubclassOf<UB1IntroWidget>
---@field MaxWaitingSec float
---@field NextLevel TSoftObjectPtr<UWorld>
---@field WaitedLoadingSubLevelNameList TArray<FName>
local AB1IntroLevel = {}



---@class AB1LadderObject : AB1GameObject
---@field StepMeshName FName
---@field TopMeshName FName
---@field BottomMeshName FName
---@field TopSize FVector
---@field StepSize FVector
---@field BottomSize FVector
---@field HoleBoxSize FVector
---@field BuiltAreaSize FVector
---@field LadderHeight float
---@field HoleBoxComponent UBoxComponent
---@field AttachedFloor int32
---@field AttachedWall int64
---@field AttachType EB1LadderAttach
local AB1LadderObject = {}



---@class AB1LevelScriptActor : ALevelScriptActor
---@field MediaSoundActor AActor
local AB1LevelScriptActor = {}



---@class AB1LevelSequenceViewTargetPawn : ADefaultPawn
local AB1LevelSequenceViewTargetPawn = {}


---@class AB1LobbyCalendarActor : AActor
---@field Settings FB1LobbyCalendarSettings
local AB1LobbyCalendarActor = {}

---@param InQuotationIndexX int32
---@param InQuotationIndexY int32
---@param InColor FLinearColor
function AB1LobbyCalendarActor:SetQuotation(InQuotationIndexX, InQuotationIndexY, InColor) end
---@param InMonth int32
---@param InColor FLinearColor
function AB1LobbyCalendarActor:SetMonth(InMonth, InColor) end
---@param InDay int32
---@param InColor FLinearColor
function AB1LobbyCalendarActor:SetDay(InDay, InColor) end


---@class AB1LobbyGalleryActor : AActor
---@field OpenDelayTime float
local AB1LobbyGalleryActor = {}

function AB1LobbyGalleryActor:LevelSequenceEnded() end


---@class AB1LocatorActor : AActor
---@field SiteId FName
---@field ObjectId FName
local AB1LocatorActor = {}



---@class AB1LocatorElevatorActor : AB1GameObject
local AB1LocatorElevatorActor = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1LocatorElevatorActor:OnTeleportCheckBox_BeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end


---@class AB1MainMenuGameState : AGameStateBase
local AB1MainMenuGameState = {}


---@class AB1MainMenuLevel : AB1LevelScriptActor
---@field GameConfigDataAsset FSoftObjectPath
---@field MainViewTarget AActor
local AB1MainMenuLevel = {}

function AB1MainMenuLevel:OnTraitSelectSettingLoaded() end
function AB1MainMenuLevel:IntroEnded() end


---@class AB1Mannequin : AActor
---@field Mesh USkeletalMeshComponentBudgeted
---@field IdleAnim UAnimMontage
---@field Events TArray<FB1MannequinAnimEvent>
local AB1Mannequin = {}



---@class AB1ManualCullVolume : AVolume
---@field CullDistanceForWallFloor float
---@field CullDistanceForPCGVolume float
---@field CullDistanceForLevelActor float
local AB1ManualCullVolume = {}



---@class AB1MapPawn : APawn
---@field PostProcessMaterial UMaterialInstanceDynamic
---@field PostProcess_CurveFloat UCurveFloat
local AB1MapPawn = {}



---@class AB1MeshMatchDebugger : AActor
local AB1MeshMatchDebugger = {}


---@class AB1MeshSpawnActor : AB1SpawnActorBase
---@field SpawnerBoundBoxComponent UBoxComponent
---@field BoundBoxLimit UBoxComponent
---@field DefaultMeshIdList TArray<FName>
---@field MeshCullDistance float
---@field PaddingX float
---@field MeshSpawnDescription TArray<FB1MeshSpawnDescription>
---@field MeshList TArray<TWeakObjectPtr<UMeshComponent>>
---@field OverrideMeshList TArray<UMeshComponent>
local AB1MeshSpawnActor = {}



---@class AB1MovingFence : AActor
---@field FenceObjectClass TSoftClassPtr<AB1FenceBaseObject>
---@field PositiveColor FLinearColor
---@field NagativeColor FLinearColor
---@field Opacity float
local AB1MovingFence = {}



---@class AB1MovingFloorBase : AActor
---@field BaseLineColor FLinearColor
---@field LimitLineColor FLinearColor
---@field ChangingColor FLinearColor
---@field LineThickness float
local AB1MovingFloorBase = {}



---@class AB1MovingHouse : AB1MovingWalls
local AB1MovingHouse = {}


---@class AB1MovingRoom : AB1MovingWalls
local AB1MovingRoom = {}


---@class AB1MovingSiteArea : AB1MovingWalls
---@field OwnerSiteAreaLineColor FLinearColor
---@field OwnerSiteLineThickness float
---@field MovingSiteLineColor FLinearColor
---@field MovingSiteLineThickness float
---@field WallLinePositiveColor FLinearColor
---@field WallLineNagativeColor FLinearColor
---@field MovingSiteLineComponent ULineBatchComponent
---@field OwnerSiteLineComponent ULineBatchComponent
---@field LockedObjectsComponent UInstancedStaticMeshComponent
---@field WithdrawObjectsComponent UInstancedStaticMeshComponent
---@field LockedWallObjects AB1WallObjects
---@field WithdrawWallObjects AB1WallObjects
local AB1MovingSiteArea = {}



---@class AB1MovingWalls : AB1WallsSilhouette
local AB1MovingWalls = {}


---@class AB1NightModeActor : AActor
---@field TransitionDuration float
---@field Presets TArray<FB1NightModePreset>
---@field DirectionalLight ADirectionalLight
---@field ExponentialHeightFog AExponentialHeightFog
---@field SkyLight ASkyLight
---@field PostProcessVolume APostProcessVolume
---@field Dome AStaticMeshActor
---@field Sun AStaticMeshActor
---@field MaterialParameterCollection UMaterialParameterCollection
local AB1NightModeActor = {}



---@class AB1OffSiteSpawnActor : AActor
---@field ObjectDtId FB1TableRowName
local AB1OffSiteSpawnActor = {}



---@class AB1OpeningLevel : AB1LevelScriptActor
---@field WaitedLoadingSubLevelNameList TArray<FName>
local AB1OpeningLevel = {}



---@class AB1ParkingPlaceActor : AActor
---@field SiteId FName
---@field VehicleEnterCheckVolume UBoxComponent
---@field bIsVehicleEntered boolean
local AB1ParkingPlaceActor = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1ParkingPlaceActor:OnEndOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function AB1ParkingPlaceActor:OnBeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class AB1PathPoint : AActor
---@field PathPointComponent USceneComponent
---@field MapModeCameraVolumeComponent UBoxComponent
---@field PointType FName
---@field CameraModeVolume FB1CameraModeVolume
local AB1PathPoint = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1PathPoint:CameraVoulme_OnEndOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1PathPoint:CameraVoulme_OnBeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end


---@class AB1PhotoModePawn : ADefaultPawn
---@field CopyCharacterObjectClass TSoftClassPtr<AB1Character>
---@field CameraMoveCurveFloat UCurveFloat
---@field CameraMoveSpeed float
---@field CameraZoomInOutSpeed float
---@field CameraFollowSpeed float
---@field CameraSiteAreaMoveSpeed float
---@field CharacterZoomDistance float
---@field SiteZoomDistance float
---@field InGameCameraPitchLimits FVector2D
---@field InGameCameraHeightLimits FVector2D
---@field InGameCameraPivotHeightLimits FVector2D
---@field InGameCameraDistanceLimits FVector2D
---@field InGameCameraPivotMovementDistanceLimits FVector2D
---@field CustomizeSceneCameraPitchLimits FVector2D
---@field CustomizeSceneCameraHeightLimits FVector2D
---@field CustomizeSceneCameraDistanceLimits FVector2D
---@field InGameCameraHeightOffset float
---@field InGameCameraPlayCamBoomOffset float
---@field SiteCameraHeightOffset float
local AB1PhotoModePawn = {}



---@class AB1PhysicsActor : AActor
---@field StaticMesh UStaticMeshComponent
local AB1PhysicsActor = {}



---@class AB1PillarHeight : AActor
---@field AdjustingHeightMaterial UMaterialInstanceDynamic
---@field PillarObjectClass TSoftClassPtr<AB1PillarObject>
---@field PillarMaterial TSoftObjectPtr<UMaterialInterface>
---@field PositiveColor FLinearColor
---@field NagativeColor FLinearColor
---@field Opacity float
local AB1PillarHeight = {}



---@class AB1PillarObject : AB1GameObject
---@field MinimumHeight float
---@field MaximumHeight float
---@field InitHeight float
---@field PillarObjectType EB1PillarObjectType
---@field StartTilingValue float
---@field UpdateTilingValue float
---@field BottomMeshComponent UInstancedStaticMeshComponent
---@field MiddleMeshComponent UInstancedStaticMeshComponent
---@field TopMeshComponent UInstancedStaticMeshComponent
local AB1PillarObject = {}



---@class AB1Player : AB1Character
---@field GroundClickFX UNiagaraSystem
---@field PlayerSelectedFxffset FVector
---@field PlayerControlledFX UNiagaraSystem
---@field PlayerAutonomyFX UNiagaraSystem
---@field VisitWaitFX UNiagaraSystem
---@field SleepFX UNiagaraSystem
---@field B1PlayerController AB1PlayerController
---@field InteracteeComponent UB1InteracteeComponent
---@field PlayerSelectedFxComponent UNiagaraComponent
---@field VisitFxComponent UNiagaraComponent
---@field SleepFxComponent UNiagaraComponent
local AB1Player = {}

---@param InTouchedComponent UPrimitiveComponent
function AB1Player:OnActorEndCursorOver(InTouchedComponent) end
---@param InTouchedComponent UPrimitiveComponent
function AB1Player:OnActorBeginCursorOver(InTouchedComponent) end
---@return FString
function AB1Player:GetDebugString() end


---@class AB1PlayerCameraManager2 : APlayerCameraManager
---@field BaseTargetBoneRelativeZ float
---@field TargetBoneName FName
---@field DefaultDepthOfFieldSettingData FB1DepthOfFieldSettingData
---@field AltViewTarget AActor
---@field SavedMainViewTarget AActor
---@field TopViewFollowInterpSpeed float
---@field CollisionPivotComponent USceneComponent
---@field CollisionMeshComponent UStaticMeshComponent
---@field CollisionMesh UStaticMesh
---@field CameraCollisionEnable boolean
---@field CollisionEnable boolean
---@field CollisionTags TArray<FName>
---@field bCollisionDynamicDistance boolean
---@field CollisionMaxDistance float
---@field CollisionScale FVector
---@field CollisionDistanceOffset float
---@field CameraBlendStack TArray<FB1ActiveCamera>
---@field CameraModeInstances TArray<FB1CameraModeInstance>
---@field DistanceToHideCharacter float
---@field ProbeSize float
---@field CameraCollisionComponent UB1CameraCollisionComponent
---@field PresetOptionController FB1CameraPresetOptionController
---@field CurLevelSequenceViewTarget AActor
local AB1PlayerCameraManager2 = {}

---@param MinPitch float
---@param MaxPitch float
function AB1PlayerCameraManager2:SetViewPitchLimits(MinPitch, MaxPitch) end
---@param bNewUsingAltCamera boolean
function AB1PlayerCameraManager2:SetUsingAlternateCamera(bNewUsingAltCamera) end
---@param NewDebugCameraStyle EDebugCameraStyle
function AB1PlayerCameraManager2:SetDebugCameraStyle(NewDebugCameraStyle) end
---@param IsEnable boolean
---@param UniScale float
function AB1PlayerCameraManager2:SetCameraCollisionDebug(IsEnable, UniScale) end
---@param alpha float
function AB1PlayerCameraManager2:SetCameraCollisionAlpha(alpha) end
---@param IsEnable boolean
function AB1PlayerCameraManager2:SetCameraCollision(IsEnable) end
function AB1PlayerCameraManager2:ResetViewPitchLimits() end
---@return boolean
function AB1PlayerCameraManager2:IsUsingAlternateCamera() end
---@return boolean
function AB1PlayerCameraManager2:IsCameraCollision() end
---@return EB1CameraModeType
function AB1PlayerCameraManager2:GetCurrentCameraModeType() end
---@return UB1CameraMode
function AB1PlayerCameraManager2:GetCurrentCameraMode() end
---@return TArray<UPrimitiveComponent>
function AB1PlayerCameraManager2:GetCameraOverlapComponents() end
---@param NewAltCameraMode TSubclassOf<UB1CameraMode>
---@param NewAltViewTarget AActor
---@param NewAltCameraTransitionTime float
function AB1PlayerCameraManager2:ConfigureAlternateCamera(NewAltCameraMode, NewAltViewTarget, NewAltCameraTransitionTime) end
function AB1PlayerCameraManager2:ClearAlternateCamera() end


---@class AB1PlayerController : APlayerController
---@field InputMappingContext UInputMappingContext
---@field WASDAction UInputAction
---@field QEAction UInputAction
---@field DeleteAction UInputAction
---@field ZAction UInputAction
---@field CAction UInputAction
---@field UAction UInputAction
---@field LeftShiftAction UInputAction
---@field LeftCtrlAction UInputAction
---@field LeftAltAction UInputAction
---@field ESCAction UInputAction
---@field UndoAction UInputAction
---@field RedoAction UInputAction
---@field SwitchFreeCameraMode UInputAction
---@field MouseLeftClickAction UInputAction
---@field MouseRightClickAction UInputAction
---@field MouseWheelClickAction UInputAction
---@field MouseMove UInputAction
---@field MouseWheelUpDown UInputAction
---@field ToggleCheat UInputAction
---@field PauseAction UInputAction
---@field ToggleZoiInformationDisplayAction UInputAction
---@field ToggleMap UInputAction
---@field SpaceBarPressedAction UInputAction
---@field StoredCameraMode EB1CameraModeType
---@field ZoiInformationDisplayer AB1ZoiInformationDisplayer
local AB1PlayerController = {}

---@param InLock boolean
function AB1PlayerController:SetLockCameraMode(InLock) end
---@param InActor AActor
---@param InTag FName
function AB1PlayerController:RemoveLineCullingActor(InActor, InTag) end
function AB1PlayerController:OnPostFirstPossessedAvatar__DelegateSignature() end
---@param InOldPawn APawn
---@param InNewPawn APawn
function AB1PlayerController:OnPossessedPawnChangedFunction(InOldPawn, InNewPawn) end
---@return FB1EntityId
function AB1PlayerController:GetCharacterHouseholdId() end
---@return FB1EntityId
function AB1PlayerController:GetCharacterEntityId() end
---@return AB1PlayerState
function AB1PlayerController:GetB1PlayerState() end
---@return AB1Player
function AB1PlayerController:GetB1Player() end
---@return UB1CheatManager
function AB1PlayerController:GetB1CheatManage() end
---@return AB1Character
function AB1PlayerController:GetB1Character() end
---@param InCameraModeType EB1CameraModeType
---@param InIsbIsTransition boolean
---@param InOpenCameraWidget boolean
function AB1PlayerController:ChangeCameraMode(InCameraModeType, InIsbIsTransition, InOpenCameraWidget) end
---@param InActor AActor
---@param InTag FName
function AB1PlayerController:AppendLineCullingActor(InActor, InTag) end


---@class AB1PlayerState : APlayerState
local AB1PlayerState = {}


---@class AB1PointStickFence : AB1FenceBaseObject
---@field SelectedColor FLinearColor
---@field HoverColor FLinearColor
---@field LineThickness float
local AB1PointStickFence = {}



---@class AB1PolygonalRoofObject : AB1RoofObject
---@field WallSize FVector
---@field SlopeHeight float
---@field SlopeDepth float
---@field ExtendedSlopeHeight float
---@field bUseCustomEavesMeshSize boolean
---@field EavesWidth float
---@field EavesHeight float
---@field NumberOfSides int32
---@field Radius float
---@field SlopeTopLeftMeshComponent UInstancedStaticMeshComponent
---@field SlopeTopRightMeshComponent UInstancedStaticMeshComponent
---@field SlopeBottomCenterMeshComponent UInstancedStaticMeshComponent
---@field SlopeBottomLeftMeshComponent UInstancedStaticMeshComponent
---@field SlopeBottomRightMeshComponent UInstancedStaticMeshComponent
---@field EavesMeshComponent UInstancedStaticMeshComponent
local AB1PolygonalRoofObject = {}



---@class AB1Portal : AB1PathPoint
---@field BoxComponent UBoxComponent
local AB1Portal = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1Portal:BeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end


---@class AB1PortalObject : AB1GameObject
---@field Offset float
---@field TargetPortal AB1PortalObject
local AB1PortalObject = {}



---@class AB1PostProcessVolume : APostProcessVolume
---@field TargetType EB1PostProcessTargetType
---@field DistanceLimit float
local AB1PostProcessVolume = {}



---@class AB1PrintedObject : AB1GameObject
---@field StaticMeshComponent UStaticMeshComponent
---@field ExceptionBoxPath FSoftObjectPath
local AB1PrintedObject = {}



---@class AB1PsoLevel : AB1LevelScriptActor
---@field WidgetClass TSubclassOf<UB1PsoWidget>
---@field MinWaitingSec float
---@field NextLevel TSoftObjectPtr<UWorld>
local AB1PsoLevel = {}



---@class AB1RelationshipCrowdManageActor : AActor
---@field Spawners TArray<AB1RelationshipCrowdSpawnActor>
local AB1RelationshipCrowdManageActor = {}



---@class AB1RelationshipCrowdSpawnActor : AActor
local AB1RelationshipCrowdSpawnActor = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function AB1RelationshipCrowdSpawnActor:OnComponentBeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class AB1RoofExtend : AActor
---@field RoofObjectClass TSoftClassPtr<AB1RoofObject>
---@field RoofMaterial TSoftObjectPtr<UMaterialInterface>
---@field MovingSpeed float
---@field PositiveColor FLinearColor
---@field NagativeColor FLinearColor
---@field Opacity float
local AB1RoofExtend = {}



---@class AB1RoofObject : AB1GameObject
---@field BaseMesh UStaticMeshComponent
---@field MinSize float
---@field AccessoryMeshes TMap<FString, UInstancedStaticMeshComponent>
local AB1RoofObject = {}



---@class AB1RoomCaptureCamera : AActor
---@field CaptureWallBP TSoftClassPtr<AB1WallObjects>
---@field CaptureFloorBP TSoftClassPtr<AB1FloorObjects>
---@field CaptureFoundationBP TSoftClassPtr<AB1FoundationObjects>
---@field CameraMoveSpeed float
---@field CameraZoomSpeed float
---@field CameraRotateSpeed float
---@field DefaultYawPitch FVector2D
---@field DefaultCameraDistance float
---@field DefaultCameraDistanceWeight float
---@field YawLimit FVector2D
---@field Background UStaticMeshComponent
local AB1RoomCaptureCamera = {}



---@class AB1SceneCapture2D : ASceneCapture2D
---@field SceneCaptureTarget APawn
---@field SceneCaptureMaterial UMaterialInterface
---@field AttachBoneName FName
---@field DefaultRenderingTimeToCapture float
local AB1SceneCapture2D = {}

---@param Actor AActor
function AB1SceneCapture2D:SetSceneCaptureTarget(Actor) end
---@param ResultMaterial UMaterialInterface
function AB1SceneCapture2D:OnCaptureScene(ResultMaterial) end
---@param bFollowBone boolean
---@param TimeToCapture float
function AB1SceneCapture2D:CaptureScene(bFollowBone, TimeToCapture) end


---@class AB1SceneCaptureMarker : AActor
---@field CaptureActor APawn
local AB1SceneCaptureMarker = {}



---@class AB1ServiceSpawnActor : AB1SpawnActorBase
---@field Index int16
local AB1ServiceSpawnActor = {}



---@class AB1ShapingPool : AB1ShapingRoom
local AB1ShapingPool = {}


---@class AB1ShapingRoom : AActor
---@field CursorMesh UStaticMesh
---@field VertexMesh UStaticMesh
---@field EdgeMesh UStaticMesh
---@field CursorComponent UStaticMeshComponent
---@field VerticesComponent UInstancedStaticMeshComponent
---@field EdgesComponent UInstancedStaticMeshComponent
local AB1ShapingRoom = {}



---@class AB1SharedServiceSpawnGroupActor : AActor
local AB1SharedServiceSpawnGroupActor = {}


---@class AB1SiteArea : AActor
---@field SiteId FName
---@field FamilyId FName
---@field CompanyId FName
---@field Location FVector
---@field Rotation FRotator
---@field Size FVector
---@field bShowMinimapIcon boolean
---@field WallObjectClass TSoftClassPtr<AB1WallObjects>
---@field FoundationObjectClass TSoftClassPtr<AB1FoundationObjects>
---@field GridScale FIntVector2
---@field SiteExtent FVector2D
---@field GridCollisionMeshComponent UDynamicMeshComponent
---@field GridDecalMeshComponent UDecalComponent
---@field SiteSizeDecalMeshComponent UDecalComponent
---@field MaxGridDrawDistance float
---@field UseGridOutline boolean
---@field CullGridOutline boolean
---@field GridOutlineColor FLinearColor
---@field GridOutlineThickness float
---@field UsePresetRestriction boolean
---@field BoundCeilingData TArray<FB1SiteAreaBoundCeilingData>
---@field FloorObjectClass TSoftClassPtr<AB1FloorObjects>
---@field SiteZBound FVector2D
---@field FloorLevelLimit FIntVector2
---@field bFirstFloorLocked boolean
---@field FirstFloorIsGround boolean
---@field GroundSetting FB1SiteAreaGroundSetting
---@field CamLimitRadius float
---@field CamLimitHeight FVector2D
---@field bUseAltGridMesh boolean
---@field GridCollisionMaterial TSoftObjectPtr<UMaterialInterface>
---@field GridDecalMaterial TSoftObjectPtr<UMaterialInterface>
---@field SiteSizeDecalMaterial TSoftObjectPtr<UMaterialInterface>
---@field EmptySitePPMaterial TSoftObjectPtr<UMaterialInstance>
---@field SiteAreaPathFindingComponent UB1SiteAreaPathFindingComponent
---@field UseDevLock boolean
---@field WallObjects AB1WallObjects
---@field FloorObjects AB1FloorObjects
---@field FoundationObjects AB1FoundationObjects
---@field UnableBuildModeEntityIdList TSet<FB1EntityId>
local AB1SiteArea = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1SiteArea:OnEndOverlapDoNotBuildBox(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function AB1SiteArea:OnBeginOverlapDoNotBuildBox(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class AB1SlotPreviewActor : AActor
---@field PreviewStaticMeshComponent UStaticMeshComponent
---@field PreviewSkeletalMeshComponent USkeletalMeshComponent
---@field PreviewNiagaraComponent UNiagaraComponent
---@field PreviewParticleSystemComponent UParticleSystemComponent
---@field ParentSlotName FName
local AB1SlotPreviewActor = {}



---@class AB1SootGameObject : AB1GameObject
---@field DecalDelay float
local AB1SootGameObject = {}

---@param bImmediate boolean
function AB1SootGameObject:ShowDecal(bImmediate) end


---@class AB1SpawnActorBase : AActor
---@field EntityID FB1EntityId
---@field SpawnerActorType EB1SpawnerType
local AB1SpawnActorBase = {}



---@class AB1StairsObject : AB1GameObject
---@field StairsRise float
---@field StairsSpaceHeight float
---@field StepUnitWidth int32
---@field StepUnitGoing float
---@field StepUnitRise float
---@field StepHeight float
---@field StringerHeight float
---@field LandingDepth int32
---@field LandingFloorHeight float
---@field LandingSlabHeight float
---@field Design TArray<FB1StairsFlightDef>
---@field AttachedFloor int32
---@field AttachedWall int64
---@field AttachType EB1StairsAttach
---@field AttachDirection EB1StairsAttachDirection
---@field EnterCheckBoxDisallowVertices TArray<FVector>
---@field Flights TArray<FB1StairsFlight>
---@field StepMeshes UInstancedStaticMeshComponent
---@field StringerMeshes UInstancedStaticMeshComponent
---@field HandrailMeshes UInstancedStaticMeshComponent
---@field SpandrelMeshes UInstancedStaticMeshComponent
---@field NewelMeshes UInstancedStaticMeshComponent
---@field BalusterMeshes UInstancedStaticMeshComponent
---@field LandingFloorMeshes UInstancedStaticMeshComponent
---@field LandingSlabMeshes UInstancedStaticMeshComponent
---@field LandingBalusterMeshes UInstancedStaticMeshComponent
---@field LandingWallMeshes UInstancedStaticMeshComponent
---@field BottomLanding UBoxComponent
---@field TopCheckBox UBoxComponent
---@field BottomCheckBox UBoxComponent
local AB1StairsObject = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1StairsObject:OnStairTopEnterCheckBoxComponent_BeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1StairsObject:OnStairBottomEnterCheckBox_BeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end


---@class AB1StreamingSourceActor : AActor
---@field StreamingSourceComponent UWorldPartitionStreamingSourceComponent
local AB1StreamingSourceActor = {}



---@class AB1StudioCharacter : AB1Character
local AB1StudioCharacter = {}


---@class AB1StudioFXObject : AB1GameObject
---@field FXNiagaraObjectClass TSubclassOf<UB1FXNiagaraObject>
local AB1StudioFXObject = {}



---@class AB1StudioMannequin : AB1GameObject
---@field CharacterObjectClass TSoftClassPtr<AB1Character>
local AB1StudioMannequin = {}



---@class AB1TopViewPawn : ADefaultPawn
local AB1TopViewPawn = {}


---@class AB1TrafficLightActor : AActor
---@field InstancedStaticMeshComponents TArray<UInstancedStaticMeshComponent>
local AB1TrafficLightActor = {}



---@class AB1TraitSelectLobbyPostitActor : ANiagaraActor
local AB1TraitSelectLobbyPostitActor = {}

---@param bPrevSelected boolean
---@param CategoryIndex int32
---@param TraitIndex int32
---@param L10NIndex int32
function AB1TraitSelectLobbyPostitActor:OnUnselected(bPrevSelected, CategoryIndex, TraitIndex, L10NIndex) end
---@param bPrevSelected boolean
---@param CategoryIndex int32
---@param TraitIndex int32
---@param L10NIndex int32
function AB1TraitSelectLobbyPostitActor:OnSelected(bPrevSelected, CategoryIndex, TraitIndex, L10NIndex) end
---@param CategoryIndex int32
---@param TraitIndex int32
---@param L10NIndex int32
function AB1TraitSelectLobbyPostitActor:OnAlreadySelected(CategoryIndex, TraitIndex, L10NIndex) end


---@class AB1TraitSelectPawn : ADefaultPawn
local AB1TraitSelectPawn = {}


---@class AB1TraitSelectSetting : AActor
---@field TraitCamera TSoftObjectPtr<AActor>
local AB1TraitSelectSetting = {}



---@class AB1TraitSelectionActor : AActor
---@field CapsuleComponent UCapsuleComponent
---@field TraitWidgetPosComponent UCapsuleComponent
---@field MinMoveRange float
---@field MaxMoveRange float
---@field MoveSpeed float
---@field bFixedPoint boolean
local AB1TraitSelectionActor = {}

---@param InState EB1TraitPointState
function AB1TraitSelectionActor:OnChangeState(InState) end


---@class AB1TraitSelectionCenterActor : AActor
---@field FxSystemList TMap<int32, FB1TraitSelectFXObject>
local AB1TraitSelectionCenterActor = {}



---@class AB1TraitSelectionLineActor : AActor
---@field ActorBegin AActor
---@field ActorEnd AActor
---@field MeshComponent UStaticMeshComponent
local AB1TraitSelectionLineActor = {}

---@param bInActive boolean
function AB1TraitSelectionLineActor:OnChangeActive(bInActive) end


---@class AB1TransformStairs : AActor
---@field StairsObjectClass TSoftClassPtr<AB1StairsObject>
---@field StairsMaterial TSoftObjectPtr<UMaterialInterface>
---@field MovingSpeed float
---@field PositiveColor FLinearColor
---@field NagativeColor FLinearColor
---@field Opacity float
local AB1TransformStairs = {}



---@class AB1UltraDynamicSky : AActor
---@field bIsForceConstTimeMode boolean
local AB1UltraDynamicSky = {}

---@param InGlobalIlluminationQuality int32
function AB1UltraDynamicSky:UpdateSkyLight(InGlobalIlluminationQuality) end
---@param InBrightness float
function AB1UltraDynamicSky:SetNightBrightness(InBrightness) end
---@param InTOD float
function AB1UltraDynamicSky:SetForceConstTimeOfDay(InTOD) end
---@param bIsForceConst boolean
function AB1UltraDynamicSky:SetForceConstTimeMode(bIsForceConst) end
function AB1UltraDynamicSky:ResetPropertyCache() end
function AB1UltraDynamicSky:PostBeginPlay() end


---@class AB1UltraDynamicWeather : AActor
local AB1UltraDynamicWeather = {}


---@class AB1UltraDynamicWeatherControl : AActor
---@field UDW AActor
---@field UDS AActor
local AB1UltraDynamicWeatherControl = {}

---@param Path FSoftObjectPath
---@param TransitionTime float
function AB1UltraDynamicWeatherControl:SetWeatherSetting(Path, TransitionTime) end


---@class AB1VATObjectPositionMarkerActor : AActor
---@field SceneComponent USceneComponent
---@field RegionType FName
---@field SpawnBluePrint TSoftClassPtr<AActor>
local AB1VATObjectPositionMarkerActor = {}



---@class AB1VehiclePawn : APawn
---@field OwnerId FB1EntityId
---@field EntityID FB1EntityId
---@field ColorId FName
---@field ColorLookUp float
---@field SimulationTransform FTransform
---@field VehicleDynamicData FB1VehicleDynamicData
---@field VehicleDtId FName
---@field TemplateId FName
---@field MaxSeatNum int32
---@field SimulationDriverMeshId FName
---@field DrivableVehicleComponent UB1DrivableVehicleComponent
---@field VehicleMovementComponent UB1VehicleMovementComponent
---@field VehicleWheelComponent UB1VehicleWheelComponent
---@field InteracteeComponent UB1InteracteeComponent
---@field CachedVehicleRepresentationComponent UB1VehicleRepresentationComponent
---@field BoxComponent UBoxComponent
---@field AudioPivotScene USceneComponent
---@field InteractionPivotScene USceneComponent
---@field AudioComponent UAudioComponent
---@field SimulationDriverMeshComponent UStaticMeshComponent
---@field LightFlag EB1VehicleLight
local AB1VehiclePawn = {}

---@return FString
function AB1VehiclePawn:GetDebugString() end


---@class AB1VehicleStation : AActor
---@field EntityID FB1EntityId
---@field ParentSiteArea AB1SiteArea
---@field SpawnProtectionVolume UBoxComponent
---@field VehicleSpawnPoint USceneComponent
---@field CurrentSpawnVehicle AB1GameObject
local AB1VehicleStation = {}

---@param InMoveActorList TArray<TWeakObjectPtr<AB1Character>>
function AB1VehicleStation:OnFocusArrivalFinish(InMoveActorList) end
---@param InMoveActorList TArray<TWeakObjectPtr<AB1Character>>
function AB1VehicleStation:DespawnAndMovingActors(InMoveActorList) end


---@class AB1VehicleVisualizeActor : AActor
---@field InstancedStaticMeshComponents TArray<UInstancedStaticMeshComponent>
---@field RegisteredVehicles TSet<AB1VehiclePawn>
---@field VisibleVehicles TSet<AB1VehiclePawn>
local AB1VehicleVisualizeActor = {}



---@class AB1WallCornerActor : AActor
---@field MainColor FLinearColor
---@field HoverMainColor FLinearColor
---@field HiddenColor FLinearColor
---@field HoverHiddenColor FLinearColor
local AB1WallCornerActor = {}



---@class AB1WallDecoObjectBase : AActor
local AB1WallDecoObjectBase = {}


---@class AB1WallObjects : AActor
local AB1WallObjects = {}


---@class AB1WallsSilhouette : AActor
---@field WallObjectClass TSoftClassPtr<AB1WallObjects>
---@field WallPositiveColor FLinearColor
---@field WallNagativeColor FLinearColor
---@field WallOpacity float
---@field WallObjects AB1WallObjects
---@field OverlappedISMComponent UInstancedStaticMeshComponent
---@field LockISMComponent UInstancedStaticMeshComponent
local AB1WallsSilhouette = {}



---@class AB1WebBrowserActor : AActor
local AB1WebBrowserActor = {}

function AB1WebBrowserActor:StopWebBrowser() end
---@param InURL FString
function AB1WebBrowserActor:OpenURL(InURL) end


---@class AB1WindowObject : AB1GameObject
---@field MaskMesh TSoftObjectPtr<UStaticMesh>
---@field MaskPolygon TArray<FVector2D>
local AB1WindowObject = {}



---@class AB1ZoiInformationDisplayer : AActor
---@field DisplayIntervalMode UB1ZoiInformationIntervalMode
---@field DisplayAllMode UB1ZoiInformationAllMode
---@field SphereComponent USphereComponent
local AB1ZoiInformationDisplayer = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function AB1ZoiInformationDisplayer:OnLeaveRadius(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function AB1ZoiInformationDisplayer:OnEnterRadius(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class ACharacterBudgeted : ACharacter
local ACharacterBudgeted = {}


---@class AHoverDronePawn : AHoverDronePawnBase
---@field bAllowSpeedChange boolean
local AHoverDronePawn = {}

---@param bOnOff boolean
function AHoverDronePawn:SetAllowSpeedChange(bOnOff) end
---@return boolean
function AHoverDronePawn:IsMaintainingConstantAltitude() end
---@return int32
function AHoverDronePawn:GetDroneSpeedIndex() end
---@return float
function AHoverDronePawn:GetAltitude() end


---@class AHoverDronePawnBase : ADefaultPawn
---@field CameraComponent UCameraComponent
local AHoverDronePawnBase = {}



---@class AHoverDroneSpeedLimitBox : AVolume
---@field MaxAllowedSpeedIndex int32
local AHoverDroneSpeedLimitBox = {}



---@class FAccelerationInterpolatorFloat
---@field AccelerationParams FAccelerationInterpolatorParams
local FAccelerationInterpolatorFloat = {}



---@class FAccelerationInterpolatorParams
---@field Acceleration float
---@field MinDeceleration float
---@field MaxSpeed float
local FAccelerationInterpolatorParams = {}



---@class FAccelerationInterpolatorRotator
---@field AccelerationParams FAccelerationInterpolatorParams
local FAccelerationInterpolatorRotator = {}



---@class FAccelerationInterpolatorVector
---@field AccelerationParams FAccelerationInterpolatorParams
local FAccelerationInterpolatorVector = {}



---@class FAccountInfo
---@field AccountId FString
---@field ItemType FString
local FAccountInfo = {}



---@class FAnimNode_B1VmcBones : FAnimNode_SkeletalControlBase
---@field VrmMapping UB1VmcVrmMapping
---@field Port int32
---@field bIsInitialized boolean
---@field BoneMappingSkeletonToVMC TMap<FName, FName>
---@field InitialBones TArray<FTransform>
---@field BoneReferences TArray<FBoneReference>
---@field PrevVrmMapping UB1VmcVrmMapping
local FAnimNode_B1VmcBones = {}



---@class FAnimNode_B1VmcMorph : FAnimNode_Base
---@field SourcePose FPoseLink
---@field VrmMapping UB1VmcVrmMapping
---@field Port int32
local FAnimNode_B1VmcMorph = {}



---@class FAssetCategorySet
---@field Categories TSet<EB1AssetCategory>
local FAssetCategorySet = {}



---@class FAtlasMaterialKey
---@field GroupIdx int32
---@field MergeMeshNum int32
local FAtlasMaterialKey = {}



---@class FB1AccessoryComponents
---@field SocketMeshComponents TArray<FB1AccessorySocketMesh>
local FB1AccessoryComponents = {}



---@class FB1AccessorySocketMesh
---@field SocketName FName
---@field MeshComponent UStaticMeshComponent
local FB1AccessorySocketMesh = {}



---@class FB1AccumulateAudioData
---@field PlayAudioComponent UAudioComponent
---@field PlayTime float
local FB1AccumulateAudioData = {}



---@class FB1ActionTakePictureParam
local FB1ActionTakePictureParam = {}


---@class FB1ActiveCamera
---@field Camera UB1CameraMode
---@field ViewTarget AActor
local FB1ActiveCamera = {}



---@class FB1AdditionalBoneModifier
---@field bone FBoneReference
---@field Translation FVector
local FB1AdditionalBoneModifier = {}



---@class FB1AffectSoundCacheData
local FB1AffectSoundCacheData = {}


---@class FB1AlertMessageData
---@field Theme FName
---@field Title FText
---@field Desc FText
---@field Link FText
---@field Hour int32
---@field Minute int32
---@field CurrentTime int64
---@field IconR TSoftObjectPtr<UTexture2D>
---@field IconL TSoftObjectPtr<UTexture2D>
---@field IconCaution TSoftObjectPtr<UObject>
---@field LinkUIType EB1UIType
local FB1AlertMessageData = {}



---@class FB1AlertMessageSaveData
---@field Theme FName
---@field Title FText
---@field Desc FText
---@field Link FText
---@field Hour int32
---@field Minute int32
---@field CurrentTime int64
---@field BinaryIconR TArray<uint8>
---@field BinaryIconL TArray<uint8>
---@field BinaryIconCaution TArray<uint8>
---@field LinkUIType uint8
local FB1AlertMessageSaveData = {}



---@class FB1AlertParam
---@field UIType EB1UIType
---@field TitleText FText
---@field ContentText FText
---@field duration float
---@field LinkText FText
---@field LinkUIType EB1UIType
local FB1AlertParam = {}



---@class FB1AnimDelegateParam
local FB1AnimDelegateParam = {}


---@class FB1AnimNode_AdjustFeet : FAnimNode_SkeletalControlBase
---@field PelvisBone FBoneReference
---@field PelvisSpringInterp FB1SpringInterp
---@field IKFootRootBone FBoneReference
---@field LeftFootData FB1FootData
---@field RightFootData FB1FootData
---@field FeetRadius float
---@field TraceLength float
---@field GroundOffset float
---@field WalkableFloorAngle float
---@field TraceInterval uint32
---@field FeetPinningDeltaLimit float
---@field BoneModifiers TArray<FB1AdditionalBoneModifier>
local FB1AnimNode_AdjustFeet = {}



---@class FB1AnimNode_BoneGroupTransform : FAnimNode_Base
---@field Source FPoseLink
local FB1AnimNode_BoneGroupTransform = {}



---@class FB1AnimNode_EyeLookAt : FAnimNode_Base
---@field Source FPoseLink
---@field LeftEyeBone FBoneReference
---@field RightEyeBone FBoneReference
---@field AdditiveRotation FRotator
---@field RotationLimit FRotator
local FB1AnimNode_EyeLookAt = {}



---@class FB1AnimNode_LayeredBoneBlend : FAnimNode_LayeredBoneBlend
---@field PoseDiffAdders TArray<FB1PoseDiffAdder>
local FB1AnimNode_LayeredBoneBlend = {}



---@class FB1AnimNode_RandomPlayer : FAnimNode_AssetPlayerRelevancyBase
---@field Entries TArray<FB1RandomPlayerSequenceEntry>
---@field DefaultAnim UAnimSequenceBase
---@field DefaultAnimStartTime float
---@field bDisableRandomPlay boolean
---@field bUseDefaultAnimForBridge boolean
---@field bPlayBridgeOnStart boolean
---@field MinBridgeLoopCount int32
---@field MaxBridgeLoopCount int32
---@field bStartFromMatchingPose boolean
---@field PlayData TArray<FB1RandomAnimPlayData>
---@field BlendWeight float
local FB1AnimNode_RandomPlayer = {}



---@class FB1AnimNode_RigidBody : FAnimNode_RigidBody
---@field B1OverridePhysicsAsset UPhysicsAsset
local FB1AnimNode_RigidBody = {}



---@class FB1AnimNode_SequencePlayer : FAnimNode_SequencePlayer
---@field UseResetAnimTimeOnStart boolean
---@field bNeedResetAnimTime boolean
---@field bBlendWithNewAnim boolean
---@field PlayData TArray<FB1AnimPlayData>
local FB1AnimNode_SequencePlayer = {}



---@class FB1AnimNode_TwoBoneIK : FAnimNode_TwoBoneIK
local FB1AnimNode_TwoBoneIK = {}


---@class FB1AnimNode_V2MPlayer : FAnimNode_Base
local FB1AnimNode_V2MPlayer = {}


---@class FB1AnimPlayData
---@field Sequence UAnimSequenceBase
local FB1AnimPlayData = {}



---@class FB1AnimToTexMeshInfo
local FB1AnimToTexMeshInfo = {}


---@class FB1AppearanceAnimationData
---@field Animation TSoftObjectPtr<UAnimSequence>
---@field Name FString
---@field PoseType EB1PoseType
local FB1AppearanceAnimationData = {}



---@class FB1AppearanceAnimationList
---@field Animations TArray<FB1AppearanceAnimationData>
local FB1AppearanceAnimationList = {}



---@class FB1AppearanceComponents
---@field MeshComponents TArray<USkeletalMeshComponent>
local FB1AppearanceComponents = {}



---@class FB1AutoSuggestedItem
---@field Nickname FString
---@field IconTexture UTexture2D
---@field AccountId FString
---@field ProfileURL FString
local FB1AutoSuggestedItem = {}



---@class FB1AvoidanceHandler
local FB1AvoidanceHandler = {}


---@class FB1BodyModifierHighlight
---@field PartsMask TMap<EB1AppearanceParts, TSoftObjectPtr<UTexture2D>>
---@field MouseAxis EB1FaceAxisFlag
local FB1BodyModifierHighlight = {}



---@class FB1BoneAdjust
local FB1BoneAdjust = {}


---@class FB1BonePostProcessAnimInstanceProxy : FAnimInstanceProxy
local FB1BonePostProcessAnimInstanceProxy = {}


---@class FB1BuildCustomizeColorPaletteEntrySaveData
---@field Image_color FLinearColor
local FB1BuildCustomizeColorPaletteEntrySaveData = {}



---@class FB1BuildModeRoomPreset
---@field WallEdgeKeys TArray<int64>
---@field WallHeight float
---@field Icon TSoftObjectPtr<UObject>
---@field Price int64
---@field DisplayNameTextId FString
---@field DescriptionTextId FString
local FB1BuildModeRoomPreset = {}



---@class FB1CameraCloseUpFocus
---@field Center FVector
---@field Rotation FRotator
---@field Distance float
---@field AxialMinDistance float
---@field AxialMaxDistance float
---@field MaxPanExtent FVector
---@field MinPanExtent FVector
---@field MinViewHeight float
---@field MaxViewHeight float
---@field FOV float
---@field BoneName FName
---@field bEnableDOF boolean
---@field DepthOfFieldSensorWidth float
---@field DepthOfFieldSqueezeFactor float
---@field DepthOfFieldDepthBlurAmount float
---@field DepthOfFieldDepthBlurRadius float
---@field LevelSequenceFocusEnter TArray<FB1CameraCloseUpLevelSequenceInfo>
---@field LevelSequenceFocusExit TArray<FB1CameraCloseUpLevelSequenceInfo>
local FB1CameraCloseUpFocus = {}



---@class FB1CameraCloseUpHeighOffset
---@field FemaleCameraHeightOffset TMap<EB1BodyAgeType, float>
---@field MaleCameraHeightOffset TMap<EB1BodyAgeType, float>
local FB1CameraCloseUpHeighOffset = {}



---@class FB1CameraCloseUpInput
local FB1CameraCloseUpInput = {}


---@class FB1CameraCloseUpLevelSequenceInfo
---@field LevelSequenceId FName
---@field GenderType EB1GenderType
---@field AgeType EB1BodyAgeType
local FB1CameraCloseUpLevelSequenceInfo = {}



---@class FB1CameraModeInstance
---@field CameraModeClass TSubclassOf<UB1CameraMode>
---@field ViewTarget AActor
---@field CameraMode UB1CameraMode
---@field CineCameraComponent UCineCameraComponent
local FB1CameraModeInstance = {}



---@class FB1CameraOptionValue
local FB1CameraOptionValue = {}


---@class FB1CameraPresetOptionController
---@field InitialAOIntensity float
---@field InitialAORadius float
---@field DynamicSkyPostProcessComponent UPostProcessComponent
local FB1CameraPresetOptionController = {}



---@class FB1CameraRotationSetting
---@field RotationRangeX float
---@field bReverseX boolean
---@field RotationRangeY float
---@field bReverseY boolean
---@field Speed float
---@field CurveFloat UCurveFloat
local FB1CameraRotationSetting = {}



---@class FB1CameraSaveData
---@field CameraInfo FMinimalViewInfo
---@field ViewTargetLocation FVector
---@field ViewTargetRotation FRotator
---@field FollowCameraToPivot FTransform
---@field PawnDistance float
---@field POVRelativeRotation FRotator
---@field CameraMode EB1CameraModeType
local FB1CameraSaveData = {}



---@class FB1CameraTransitionParam
---@field BlendTime float
---@field StartBlendDistance float
---@field TargetBlendDistance float
---@field StartBlendPos FVector
---@field TargetBlendPos FVector
---@field StartBlendRot FRotator
---@field TargetBlendRot FRotator
---@field TargetEntityId FB1EntityId
---@field BlendType EEasingFunc::Type
local FB1CameraTransitionParam = {}



---@class FB1CharacterAnimInstanceProxy : FAnimInstanceProxy
local FB1CharacterAnimInstanceProxy = {}


---@class FB1CharacterCacheSaveData
---@field EntityID FB1EntityId
---@field PortraitGrowthStep EB1GrowthStep
local FB1CharacterCacheSaveData = {}



---@class FB1CharacterCustomizationCategoryWidget_ButtonStyle
---@field TextColor FSlateColor
local FB1CharacterCustomizationCategoryWidget_ButtonStyle = {}



---@class FB1CharacterCustomizationCategoryWidget_ButtonStyles
---@field Normal FB1CharacterCustomizationCategoryWidget_ButtonStyle
---@field Selected FB1CharacterCustomizationCategoryWidget_ButtonStyle
---@field Disabled FB1CharacterCustomizationCategoryWidget_ButtonStyle
local FB1CharacterCustomizationCategoryWidget_ButtonStyles = {}



---@class FB1CharacterCustomizationStudioViewModel
---@field StudioBGListDatas TArray<UB1CharacterCustomizeStudioBGListEntryData>
local FB1CharacterCustomizationStudioViewModel = {}



---@class FB1CharacterCustomizeFilterTagNames
local FB1CharacterCustomizeFilterTagNames = {}


---@class FB1CharacterGarmentStableDiffusionInfo
local FB1CharacterGarmentStableDiffusionInfo = {}


---@class FB1CharacterLocomotionData
---@field IdleRandomAnims TArray<FB1RandomPlayerSequenceEntry>
---@field WalkStartAnims TMap<EB1Anim_Direction, UAnimSequenceBase>
---@field WalkAnim UAnimSequenceBase
---@field WalkRandomAnims TArray<FB1RandomPlayerSequenceEntry>
---@field WalkSlopeAnims TMap<EB1Anim_Slope, UAnimSequenceBase>
---@field MinWalkLoopCount int32
---@field MaxWalkLoopCount int32
---@field WalkStop_Block UAnimSequenceBase
---@field WalkStop_LF UAnimSequenceBase
---@field WalkStop_RF UAnimSequenceBase
---@field WalkToJog_LF UAnimSequenceBase
---@field WalkToJog_RF UAnimSequenceBase
---@field WalkTurn_LF TMap<EB1Anim_Direction, UAnimSequenceBase>
---@field WalkTurn_RF TMap<EB1Anim_Direction, UAnimSequenceBase>
---@field JogAnim UAnimSequenceBase
---@field JogStartAnims TMap<EB1Anim_Direction, UAnimSequenceBase>
---@field JogStop_Block UAnimSequenceBase
---@field JogStop UAnimSequenceBase
---@field JogToWalk_LF UAnimSequenceBase
---@field JogToWalk_RF UAnimSequenceBase
---@field JogTurn_LF TMap<EB1Anim_Direction, UAnimSequenceBase>
---@field JogTurn_RF TMap<EB1Anim_Direction, UAnimSequenceBase>
---@field TurnStops TMap<EB1Anim_TurnStop, UAnimMontage>
---@field TurnInPlaces TMap<EB1Anim_TurnStop, UAnimMontage>
---@field OneSteps TMap<EB1Anim_OneStep, UAnimMontage>
local FB1CharacterLocomotionData = {}



---@class FB1CharacterSpotLightParams
---@field Location FVector
---@field Rotation FRotator
---@field IntensityUnits ELightUnits
---@field Intensity float
---@field LightColor FLinearColor
---@field AttenuationRadius float
---@field InnerConeAngle float
---@field OuterConeAngle float
---@field SourceRadius float
---@field SoftSourceRadius float
local FB1CharacterSpotLightParams = {}



---@class FB1ChatHistoryWidgetSettings
---@field SelfEntryWidgetClass TSubclassOf<UB1ChatHistoryEntryWidget>
---@field OtherEntryWidgetClass TSubclassOf<UB1ChatHistoryEntryWidget>
local FB1ChatHistoryWidgetSettings = {}



---@class FB1CityBalanceReportListEntryData
---@field ID FName
---@field Icon TSoftObjectPtr<UTexture2D>
---@field Title FText
---@field SubList TMap<FName, FB1CityBalanceReportSubListData>
local FB1CityBalanceReportListEntryData = {}



---@class FB1CityBalanceReportSubListData
---@field DescriptionText FText
---@field Count int32
local FB1CityBalanceReportSubListData = {}



---@class FB1CityBalanceReportSubListEntryData
---@field Title FText
---@field Item FText
local FB1CityBalanceReportSubListEntryData = {}



---@class FB1CitySelectCityButtonWidget_Setting
---@field MapId FName
---@field Description FB1CitySelectDescriptionWidget_Setting
local FB1CitySelectCityButtonWidget_Setting = {}



---@class FB1CitySelectDescriptionWidget_Setting
---@field Image TSoftObjectPtr<UObject>
---@field bButtonEnabled boolean
local FB1CitySelectDescriptionWidget_Setting = {}



---@class FB1CitySelectPortraitWidget_FaceFocusAnimationSetting
---@field DelayTimeSec float
---@field PlayTimeSec float
---@field CircleSizeRatioStart float
---@field FaceFocusOffset FVector2D
local FB1CitySelectPortraitWidget_FaceFocusAnimationSetting = {}



---@class FB1CitySelectPortraitWidget_PortraitMoveAnimationSetting
---@field DelayTimeSec float
---@field PlayTimeSec float
---@field Speed float
local FB1CitySelectPortraitWidget_PortraitMoveAnimationSetting = {}



---@class FB1CitySelectPortraitWidget_Setting
---@field FaceFocusAnimation FB1CitySelectPortraitWidget_FaceFocusAnimationSetting
---@field PortraitMoveAnimation FB1CitySelectPortraitWidget_PortraitMoveAnimationSetting
local FB1CitySelectPortraitWidget_Setting = {}



---@class FB1CollisionInfo
---@field eCameraCollisionType EB1CameraCollisionType
---@field IsDecoCollision boolean
---@field CollisionBox FBox
---@field StaticMeshComps TArray<UStaticMeshComponent>
---@field DecoMeshComps TArray<UPrimitiveComponent>
---@field B1GameObject TWeakObjectPtr<AB1GameObject>
local FB1CollisionInfo = {}



---@class FB1CommonButtonTextSetting
---@field bTextSlotLayoutOverride boolean
---@field TextSlotLayoutBox FB1CommonButtonTextSlotLayoutBox
---@field bTextWrapOverride boolean
---@field TextWarp FB1CommonButtonTextWrap
local FB1CommonButtonTextSetting = {}



---@class FB1CommonButtonTextSlotLayoutBox
---@field Size FSlateChildSize
---@field Padding FMargin
---@field HorizontalAlignment EHorizontalAlignment
---@field VerticalAlignment EVerticalAlignment
local FB1CommonButtonTextSlotLayoutBox = {}



---@class FB1CommonButtonTextWrap
---@field AutoWrapText boolean
---@field WrapTextAt float
local FB1CommonButtonTextWrap = {}



---@class FB1CraftingNamingWidgetVM
---@field Icon TSoftObjectPtr<UObject>
---@field RecipeId FName
---@field NamingTextId FText
---@field DefaultTitle FText
---@field DefaultContent FText
local FB1CraftingNamingWidgetVM = {}



---@class FB1CurveBlendDescription
---@field bIsEnabled boolean
---@field alpha float
---@field CurveMap TMap<FName, float>
local FB1CurveBlendDescription = {}



---@class FB1CustomizedFamily
---@field FamilyMembers TArray<FB1InstancedCharacter>
local FB1CustomizedFamily = {}



---@class FB1DRMInfo
---@field Delay float
local FB1DRMInfo = {}



---@class FB1DecoInfo
local FB1DecoInfo = {}


---@class FB1DelaySpeechBubbleData
local FB1DelaySpeechBubbleData = {}


---@class FB1DepthOfFieldTransitionData
---@field From float
---@field To float
---@field SettingData FB1DepthOfFieldSettingData
local FB1DepthOfFieldTransitionData = {}



---@class FB1DreamBubbleData
---@field Widget UB1CommonDreamBubbleWidget
local FB1DreamBubbleData = {}



---@class FB1DummyClassForUHT
local FB1DummyClassForUHT = {}


---@class FB1EntityInfo
---@field Type EB2EntityType
---@field Actor AActor
local FB1EntityInfo = {}



---@class FB1EnvironmentAudioColorMapInfo
---@field AudioColorMapTexture TSoftObjectPtr<UTexture2D>
---@field CurrentVolume float
---@field DesireVolume float
local FB1EnvironmentAudioColorMapInfo = {}



---@class FB1EnvironmentEditCityBalanceSliderListEntryData
---@field ID FName
---@field Title FText
---@field Description FText
---@field SliderValue float
local FB1EnvironmentEditCityBalanceSliderListEntryData = {}



---@class FB1EnvironmentEditEntryData
---@field GroupId FName
---@field ID FName
---@field DecorationId FName
---@field ToolTipText FText
---@field Icon TSoftObjectPtr<UTexture2D>
---@field bIsSelect boolean
---@field bIsGalleryFile boolean
---@field GalleryPathKey FString
---@field bIsYoutubeFile boolean
---@field YoutubeKey FString
---@field bIsMultiSelectable boolean
---@field bDeletable boolean
---@field bColorChangeable boolean
---@field SelectIndex int32
local FB1EnvironmentEditEntryData = {}



---@class FB1EyeRefractiveOriginCustomData
---@field ScleraCornerDarkColor FLinearColor
---@field EyeColor1 FLinearColor
---@field EyeColor2 FLinearColor
---@field PupilScale float
---@field IrisConcavityScale float
---@field IrisBrightness float
---@field IrisSaturation float
---@field IrisUVRadius float
---@field ScaleIrisWithinMask float
---@field ScleraBrightness float
---@field ScleraPower float
---@field ScleraRotate float
---@field VeinsPower float
---@field VeinsRotate float
---@field IrisColorBalance float
---@field IrisColorBalanceSmoothness float
---@field LimbusDarkAmount float
---@field RadialStructuralBlendSwitch float
local FB1EyeRefractiveOriginCustomData = {}



---@class FB1EyeRefractiveOriginDataMaps : FB1MaterialOriginDataMaps
---@field EyeRefractiveMIDMaps TMap<FAtlasMaterialKey, UMaterialInstanceDynamic>
---@field OriginCustomDataMap TMap<FOriginMaterialMapKey, FB1EyeRefractiveOriginCustomData>
---@field OriginTextureMap TMap<FOriginMaterialMapKey, FB1EyeRefractiveOriginTextureData>
local FB1EyeRefractiveOriginDataMaps = {}



---@class FB1EyeRefractiveOriginTextureData
---@field IrisMaskMap UTexture
local FB1EyeRefractiveOriginTextureData = {}



---@class FB1FXHandle
---@field NiagaraComponent TWeakObjectPtr<UNiagaraComponent>
---@field AudioComponent TWeakObjectPtr<UAudioComponent>
local FB1FXHandle = {}



---@class FB1FaceModifierHighlight
---@field MaskTexture TSoftObjectPtr<UTexture2D>
---@field GizmoBones TArray<FName>
---@field GizmoOffset FVector
---@field GizmoRotation FRotator
---@field bFaceGroup boolean
local FB1FaceModifierHighlight = {}



---@class FB1FamilySaveData
---@field FamilyId int64
---@field InventoryId int64
---@field SiteAreaName FName
---@field FamilyName FText
---@field Description FText
---@field HouseholdMemberIds TArray<int64>
---@field CurrencyMap TMap<FName, int64>
---@field bIsApplyNonPlayFamilyScheduleEdit boolean
local FB1FamilySaveData = {}



---@class FB1FamilySelectData
local FB1FamilySelectData = {}


---@class FB1FireworksFXEvent
---@field FXObject TSubclassOf<UB1FXObject>
---@field NiagaraSystem UNiagaraSystem
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field QuatOffset FQuat
---@field Scale FVector
---@field bAttached boolean
---@field StartTime float
local FB1FireworksFXEvent = {}



---@class FB1FootData
---@field IKFootBone FBoneReference
---@field FKFootBone FBoneReference
---@field FootOffsetSpringInterp FB1SpringInterp
---@field FootNormalSpringInterp FB1SpringInterp
---@field FootPinningCurveName FName
local FB1FootData = {}



---@class FB1FoundationMoldFrag
---@field MeshPartsName FString
---@field MeshAsset TSoftObjectPtr<UStaticMesh>
---@field Materials TArray<TSoftObjectPtr<UMaterialInterface>>
---@field CornerMargin float
---@field Offset FVector
---@field Rotation FVector
local FB1FoundationMoldFrag = {}



---@class FB1GableRoofFragSet
---@field FragSizeBasis float
---@field MainRidge TArray<FB1RoofFrag>
---@field MainRidgeDeco TArray<FB1RoofFrag>
---@field Verge TArray<FB1RoofFrag>
---@field VergeRidge TArray<FB1RoofFrag>
---@field MainVergeDeco TArray<FB1RoofFrag>
---@field Eaves TArray<FB1RoofFrag>
---@field EavesRidge TArray<FB1RoofFrag>
---@field WallDeco TArray<FB1RoofFrag>
local FB1GableRoofFragSet = {}



---@class FB1GalleryDataAppearance
---@field AppearanceSetting FB1AppearanceSetting
local FB1GalleryDataAppearance = {}



---@class FB1GalleryErrorInfo
---@field code int32
---@field Message FString
local FB1GalleryErrorInfo = {}



---@class FB1GalleryErrorResponse
---@field jsonrpc FString
---@field ID int32
---@field Error FB1GalleryErrorInfo
local FB1GalleryErrorResponse = {}



---@class FB1GalleryMetaData
---@field Tags TArray<FString>
---@field SystemTags TArray<FString>
---@field StringData TMap<FString, FString>
---@field DoubleData TMap<FString, double>
local FB1GalleryMetaData = {}



---@class FB1GalleryRoomObjectData
---@field GameObjectData FB1GameObjectData
---@field ChildrenGameObjectData TArray<FB1GameObjectData>
local FB1GalleryRoomObjectData = {}



---@class FB1GalleryRoomObjectDatas
---@field Objects TArray<FB1GalleryRoomObjectData>
local FB1GalleryRoomObjectDatas = {}



---@class FB1GalleryToastMessageInfo
---@field GalleryRequestInterfaces TArray<TScriptInterface<IB1GalleryRequestInterface>>
local FB1GalleryToastMessageInfo = {}



---@class FB1GameObjectData
---@field TableId FString
---@field RelativeLocation FVector
---@field RelativeRotation FVector
---@field Scale FVector
---@field ParentSlotIndex int32
---@field FloorLevel int32
---@field ObjectBoundCenter FVector
---@field ObjectBoundExtends FVector
---@field GameObjectSaveData FB1GameObjectSaveData
local FB1GameObjectData = {}



---@class FB1GameObjectSaveData : FB1ObjectSaveData
---@field ObjectDataTableId FName
---@field ObjectFName FName
---@field IsDevLocked boolean
---@field FloorLevel int32
---@field ChildCharId int64
---@field AuthorName FString
---@field GalleryPathKey FString
---@field PrintedMeshId FString
---@field PrintedMeshOffset FVector
---@field CustomizeData TArray<FB1ObjectCustomizeSaveData>
---@field ObjectSlotInfo FB1ObjectSlotSaveData
---@field DoorObjectData FB1DoorObjectSaveData
---@field StairsObjectData FB1StairsObjectSaveData
---@field RoofObjectData FB1RoofObjectSaveData
---@field PillarObjectData FB1PillarObjectSaveData
---@field FenceObjectData FB1FenceObjectSaveData
---@field LadderObjectData FB1LadderObjectSaveData
---@field PrintedObjectData FB1PrintedObjectSaveData
---@field StudioMannequinObjectData FB1StudioMannequinObjectSaveData
---@field ObjectMetaData FB1GameObjectMetaSaveData
---@field AssembledAssetHash int64
local FB1GameObjectSaveData = {}



---@class FB1GameOptionDynamicData
---@field Type EB1GameOption
---@field RestoreValue FString
---@field ChangedValue FString
---@field bForcedSetOption boolean
local FB1GameOptionDynamicData = {}



---@class FB1GameOptionSelectionData
---@field DisplayName FText
---@field OptionValue FName
---@field bEnabled boolean
---@field bIsTemporary boolean
local FB1GameOptionSelectionData = {}



---@class FB1GameOptionValue
local FB1GameOptionValue = {}


---@class FB1GarmentComponentSection
local FB1GarmentComponentSection = {}


---@class FB1GarmentOriginCustomData
---@field CustomR FLinearColor
---@field CustomG FLinearColor
---@field CustomB FLinearColor
---@field CustomColorIntensity float
local FB1GarmentOriginCustomData = {}



---@class FB1GarmentOriginDataMaps : FB1MaterialOriginDataMaps
---@field GarmentMIDMaps TMap<FAtlasMaterialKey, UMaterialInstanceDynamic>
---@field OriginCustomDataMap TMap<FOriginMaterialMapKey, FB1GarmentOriginCustomData>
---@field OriginTextureMap TMap<FOriginMaterialMapKey, FB1GarmentOriginTextureData>
local FB1GarmentOriginDataMaps = {}



---@class FB1GarmentOriginTextureData
---@field RGBMaskTexture UTexture
---@field BaseColorTexture UTexture
---@field ARMMapTexture UTexture
---@field NormalTexture UTexture
local FB1GarmentOriginTextureData = {}



---@class FB1GarmentWhiteSkeletalMesh
---@field WhiteSkeletalMesh USkeletalMesh
---@field ID FString
---@field MeshDependency FString
---@field MaterialDependencies TSet<UMaterialInterface>
---@field Thumbnail UTexture2D
---@field AssetCategory EB1AssetCategory
---@field TableName FString
local FB1GarmentWhiteSkeletalMesh = {}



---@class FB1GarmentWhiteStaticMesh
---@field WhiteStaticMesh UStaticMesh
---@field ID FString
---@field MeshDependency FString
---@field MaterialDependencies TSet<UMaterialInterface>
---@field Thumbnail UTexture2D
---@field AssetCategory EB1AssetCategory
---@field TableName FString
local FB1GarmentWhiteStaticMesh = {}



---@class FB1GenerateMotionIdleAnimData
---@field Animation TSoftObjectPtr<UAnimSequence>
local FB1GenerateMotionIdleAnimData = {}



---@class FB1GeneratedFileMetaData
---@field StringData TMap<FString, FString>
---@field DoubleData TMap<FString, double>
local FB1GeneratedFileMetaData = {}



---@class FB1GeneratedFileThumbnailData
local FB1GeneratedFileThumbnailData = {}


---@class FB1HairAnimInstanceProxy : FAnimInstanceProxy
local FB1HairAnimInstanceProxy = {}


---@class FB1HairCardOriginCustomData
---@field TipColor FLinearColor
---@field Specular float
---@field Roughness float
---@field HairCutBlend float
---@field WhiteDNA float
---@field PixelDepthOffset float
---@field Scatter float
---@field EdgeMaskContrast float
---@field EdgeMaskMin float
---@field LODOverwrite float
local FB1HairCardOriginCustomData = {}



---@class FB1HairCardOriginDataMaps : FB1MaterialOriginDataMaps
---@field HairCardMIDMaps TMap<FAtlasMaterialKey, UMaterialInstanceDynamic>
---@field OriginCustomDataMap TMap<FOriginMaterialMapKey, FB1HairCardOriginCustomData>
---@field OriginTextureMap TMap<FOriginMaterialMapKey, FB1HairCardOriginTextureData>
local FB1HairCardOriginDataMaps = {}



---@class FB1HairCardOriginTextureData
---@field DIROMapTexture UTexture
---@field FlowMapTexture UTexture
local FB1HairCardOriginTextureData = {}



---@class FB1HalfGableRoofFragSet
---@field FragSizeBasis float
---@field MainRidge TArray<FB1RoofFrag>
---@field Verge TArray<FB1RoofFrag>
---@field Eaves TArray<FB1RoofFrag>
---@field EavesRidge TArray<FB1RoofFrag>
local FB1HalfGableRoofFragSet = {}



---@class FB1HalfHipRoofFragSet
---@field FragSizeBasis float
---@field MainRidge TArray<FB1RoofFrag>
---@field SlopeRidge TArray<FB1RoofFrag>
---@field SlopeDeco TArray<FB1RoofFrag>
---@field Verge TArray<FB1RoofFrag>
---@field CenterVerge TArray<FB1RoofFrag>
---@field VergeDeco TArray<FB1RoofFrag>
---@field VergeCenterDeco TArray<FB1RoofFrag>
---@field Eaves TArray<FB1RoofFrag>
---@field EavesRidge TArray<FB1RoofFrag>
---@field VergeEavesRidge TArray<FB1RoofFrag>
local FB1HalfHipRoofFragSet = {}



---@class FB1HipRoofFragSet
---@field FragSizeBasis float
---@field MainRidge TArray<FB1RoofFrag>
---@field MainRidgeCenterDeco TArray<FB1RoofFrag>
---@field MainRidgeSideDeco TArray<FB1RoofFrag>
---@field Verge TArray<FB1RoofFrag>
---@field Eaves TArray<FB1RoofFrag>
---@field EavesRidge TArray<FB1RoofFrag>
local FB1HipRoofFragSet = {}



---@class FB1IdList
local FB1IdList = {}


---@class FB1ImageTo3DFile
---@field FileVersion int32
---@field AuthorName FString
---@field PrintedMesh UStaticMesh
---@field FolderPath FString
---@field ImageTo3DName FString
---@field MetaData FB1ImageTo3DMetaData
---@field ThumbnailData FB1ImageTo3DThumbnailData
---@field GlbData TArray<uint8>
---@field OriginalTexture UTexture2D
local FB1ImageTo3DFile = {}



---@class FB1ImageTo3DMetaData
---@field PivotLocation FVector
---@field PivotRotation FVector
---@field PrintedMeshExtent FVector
---@field StringData TMap<FString, FString>
local FB1ImageTo3DMetaData = {}



---@class FB1ImageTo3DThumbnailData
local FB1ImageTo3DThumbnailData = {}


---@class FB1InstancedCharacter
---@field Texture UTexture
---@field CharacterAttributeId FName
local FB1InstancedCharacter = {}



---@class FB1InstancedFamily
local FB1InstancedFamily = {}


---@class FB1JobGradeRequirementInfo
local FB1JobGradeRequirementInfo = {}


---@class FB1LevelSequenceInstance
local FB1LevelSequenceInstance = {}


---@class FB1LevelSequencePlayParam
local FB1LevelSequencePlayParam = {}


---@class FB1LoadGroup
local FB1LoadGroup = {}


---@class FB1LobbyCalendarElement
---@field MeshComponent UMeshComponent
---@field MaterialInstanceDynamic UMaterialInstanceDynamic
local FB1LobbyCalendarElement = {}



---@class FB1LobbyCalendarPreviewData
local FB1LobbyCalendarPreviewData = {}


---@class FB1LobbyCalendarSettings
---@field MonthColor FLinearColor
---@field DefaultDayColor FLinearColor
---@field OverrideDayColorMap TMap<EB1DayOfWeek, FLinearColor>
---@field QuotationColor FLinearColor
---@field QuotationNum int32
---@field QuotationNumX int32
---@field QuotationNumY int32
---@field QuotationIndexOffsetByLanguageMap TMap<FString, int32>
local FB1LobbyCalendarSettings = {}



---@class FB1LogAccountLogin : FB1LogBase
---@field fb1logaccountloginname FString
---@field account_id int64
---@field character_id int64
---@field platform FString
local FB1LogAccountLogin = {}



---@class FB1LogAccountLogout : FB1LogBase
---@field fb1logaccountlogoutname FString
---@field account_id int64
---@field character_id int64
local FB1LogAccountLogout = {}



---@class FB1LogBase
---@field fb1logbasename FString
---@field _b1_id int64
---@field _ts FString
local FB1LogBase = {}



---@class FB1LogCharacter : FB1LogCharacterDigest
---@field fb1logcharactername FString
---@field Items TMap<FName, FB1LogItem>
local FB1LogCharacter = {}



---@class FB1LogCharacterDigest
---@field fb1logcharacterdigestname FString
---@field object_id int64
---@field character_name FString
---@field family_id int64
local FB1LogCharacterDigest = {}



---@class FB1LogCharacterInfo
---@field fb1logcharacterinfoname FString
---@field account_id int64
---@field account_name FString
---@field Level int32
---@field outfit_type FString
---@field crew_id int64
local FB1LogCharacterInfo = {}



---@class FB1LogClientGameStatus : FB1LogBase
---@field fb1logclientgamestatusname FString
---@field game_accuntid int64
local FB1LogClientGameStatus = {}



---@class FB1LogConstructionAddOnAttach : FB1LogBase
---@field fb1logconstructionaddonattachname FString
---@field Position FString
---@field addon_key FString
---@field addon_materials TArray<FB1LogItem>
local FB1LogConstructionAddOnAttach = {}



---@class FB1LogConstructionEnd : FB1LogBase
---@field fb1logconstructionendname FString
---@field inside_structure boolean
local FB1LogConstructionEnd = {}



---@class FB1LogCurrencyTransfer : FB1LogBase
---@field fb1logcurrencytransfername FString
---@field currency_type FName
---@field Amount int64
---@field balance int64
---@field Reason FName
local FB1LogCurrencyTransfer = {}



---@class FB1LogDamage
---@field fb1logdamagename FString
---@field damage_type FString
---@field damage_causer_name FName
---@field damage_causer_info FName
---@field damage_value int64
---@field damage_part FString
---@field damage_distance float
---@field is_penetrated_wall boolean
local FB1LogDamage = {}



---@class FB1LogFPS
---@field fb1logfpsname FString
---@field Min float
---@field Max float
---@field avg float
---@field curr float
local FB1LogFPS = {}



---@class FB1LogGameEnd : FB1LogBase
---@field fb1loggameendname FString
---@field Characters TArray<FB1LogCharacterDigest>
local FB1LogGameEnd = {}



---@class FB1LogGameStart : FB1LogBase
---@field fb1loggamestartname FString
---@field server_name FString
---@field map_name FString
---@field Success boolean
---@field use_backend_api boolean
local FB1LogGameStart = {}



---@class FB1LogItem : FB1LogItemDigest
---@field fb1logitemname FString
---@field durability float
---@field current_max_durability float
---@field stored_items TArray<FB1LogItemDigest>
---@field Parts TMap<FName, FB1LogItemDigest>
---@field ammos TArray<FString>
---@field fuel_type FName
---@field fuel_amount int32
local FB1LogItem = {}



---@class FB1LogItemCraft : FB1LogBase
---@field fb1logitemcraftname FString
---@field recipe_key FString
---@field material_items TArray<FB1LogItem>
---@field result_items TArray<FB1LogItem>
local FB1LogItemCraft = {}



---@class FB1LogItemDigest
---@field fb1logitemdigestname FString
---@field item_id int64
---@field item_backend_id FString
---@field item_key FName
---@field Count int64
local FB1LogItemDigest = {}



---@class FB1LogItemDrop : FB1LogBase
---@field fb1logitemdropname FString
local FB1LogItemDrop = {}



---@class FB1LogItemEquip : FB1LogBase
---@field fb1logitemequipname FString
---@field slot_key FString
local FB1LogItemEquip = {}



---@class FB1LogItemPickUp : FB1LogBase
---@field fb1logitempickupname FString
local FB1LogItemPickUp = {}



---@class FB1LogItemSpawn : FB1LogBase
---@field fb1logitemspawnname FString
local FB1LogItemSpawn = {}



---@class FB1LogItemTransfer : FB1LogBase
---@field fb1logitemtransfername FString
---@field old_inventory_id int64
---@field old_inventory_type FString
---@field new_inventory_id int64
---@field new_inventory_type FString
local FB1LogItemTransfer = {}



---@class FB1LogLocation
---@field fb1loglocationname FString
---@field X float
---@field Y float
---@field Z float
local FB1LogLocation = {}



---@class FB1LogMissionComplete : FB1LogBase
---@field fb1logmissioncompletename FString
---@field mission_id FName
---@field reward_exps int32
local FB1LogMissionComplete = {}



---@class FB1LogMissionCompleteMapEntry
---@field fb1logmissioncompletemapentryname FString
---@field type_id FName
---@field Value int32
local FB1LogMissionCompleteMapEntry = {}



---@class FB1LogMissionObjectInteraction : FB1LogBase
---@field fb1logmissionobjectinteractionname FString
---@field mission_id FName
---@field mission_object_id FName
---@field complete_index int32
---@field remain_interaction_count int32
local FB1LogMissionObjectInteraction = {}



---@class FB1LogMissionProgress : FB1LogBase
---@field fb1logmissionprogressname FString
---@field mission_id FName
---@field mission_condition_index int32
local FB1LogMissionProgress = {}



---@class FB1LogMissionStart : FB1LogBase
---@field fb1logmissionstartname FString
---@field mission_id FName
local FB1LogMissionStart = {}



---@class FB1LogModItem : FB1LogBase
---@field fb1logmoditemname FString
---@field slot_key FString
local FB1LogModItem = {}



---@class FB1LogModVehicle : FB1LogBase
---@field fb1logmodvehiclename FString
---@field slot_key FString
local FB1LogModVehicle = {}



---@class FB1LogObject
---@field fb1logobjectname FString
---@field bp_name_1 FString
local FB1LogObject = {}



---@class FB1LogPlayerAttack : FB1LogBase
---@field fb1logplayerattackname FString
---@field attack_id int64
---@field attack_type FString
local FB1LogPlayerAttack = {}



---@class FB1LogPlayerEnterWorld : FB1LogBase
---@field fb1logplayerenterworldname FString
---@field entry_point FString
local FB1LogPlayerEnterWorld = {}



---@class FB1LogPlayerKill : FB1LogBase
---@field fb1logplayerkillname FString
---@field dbno_id int64
---@field attack_id int64
local FB1LogPlayerKill = {}



---@class FB1LogPlayerLeaveShip : FB1LogBase
---@field fb1logplayerleaveshipname FString
---@field seat_index int64
local FB1LogPlayerLeaveShip = {}



---@class FB1LogPlayerLeaveVehicle : FB1LogBase
---@field fb1logplayerleavevehiclename FString
---@field seat_index int64
local FB1LogPlayerLeaveVehicle = {}



---@class FB1LogPlayerMakeGroggy : FB1LogBase
---@field fb1logplayermakegroggyname FString
---@field dbno_id int64
---@field attack_id int64
local FB1LogPlayerMakeGroggy = {}



---@class FB1LogPlayerPosition : FB1LogBase
---@field fb1logplayerpositionname FString
---@field session_time float
local FB1LogPlayerPosition = {}



---@class FB1LogPlayerRevive : FB1LogBase
---@field fb1logplayerrevivename FString
---@field dbno_id int64
local FB1LogPlayerRevive = {}



---@class FB1LogPlayerRideShip : FB1LogBase
---@field fb1logplayerrideshipname FString
---@field seat_index int64
local FB1LogPlayerRideShip = {}



---@class FB1LogPlayerRideVehicle : FB1LogBase
---@field fb1logplayerridevehiclename FString
---@field seat_index int64
local FB1LogPlayerRideVehicle = {}



---@class FB1LogPlayerTakeDamage : FB1LogBase
---@field fb1logplayertakedamagename FString
---@field attack_id int64
local FB1LogPlayerTakeDamage = {}



---@class FB1LogPlayerUseItem : FB1LogBase
---@field fb1logplayeruseitemname FString
---@field Reason FName
local FB1LogPlayerUseItem = {}



---@class FB1LogReturnResult : FB1LogBase
---@field fb1logreturnresultname FString
---@field result_id int64
---@field crew_id int64
---@field Characters TArray<FB1LogCharacterDigest>
---@field Vehicles TArray<FB1LogVehicle>
local FB1LogReturnResult = {}



---@class FB1LogServerCrashed : FB1LogBase
---@field fb1logservercrashedname FString
local FB1LogServerCrashed = {}



---@class FB1LogServerEnded : FB1LogBase
---@field fb1logserverendedname FString
local FB1LogServerEnded = {}



---@class FB1LogServerGameStatus : FB1LogBase
---@field fb1logservergamestatusname FString
---@field active_user int64
---@field active_squad int64
---@field npc_human_count int64
---@field npc_animal_count int64
local FB1LogServerGameStatus = {}



---@class FB1LogShip : FB1LogShipDigest
---@field fb1logshipname FString
---@field owner_squad_id int64
---@field passengers TArray<FB1LogCharacterDigest>
---@field container_items TArray<FB1LogItemDigest>
---@field container_vehicles TArray<FB1LogVehicleDigest>
local FB1LogShip = {}



---@class FB1LogShipCalled : FB1LogBase
---@field fb1logshipcalledname FString
---@field ship_type FString
local FB1LogShipCalled = {}



---@class FB1LogShipDigest
---@field fb1logshipdigestname FString
---@field ship_id int64
---@field ship_type FString
---@field ship_direction FString
local FB1LogShipDigest = {}



---@class FB1LogShipExpired : FB1LogBase
---@field fb1logshipexpiredname FString
local FB1LogShipExpired = {}



---@class FB1LogShipSpawned : FB1LogBase
---@field fb1logshipspawnedname FString
local FB1LogShipSpawned = {}



---@class FB1LogStructure
---@field fb1logstructurename FString
---@field structure_id int64
---@field structure_key FString
---@field structure_name FString
---@field structure_type FString
---@field install_type FString
---@field durability float
---@field max_durability float
---@field addons TMap<FString, FB1LogStructureAddOn>
local FB1LogStructure = {}



---@class FB1LogStructureAddOn
---@field fb1logstructureaddonname FString
---@field addon_id int64
---@field addon_key FString
---@field addon_name FString
---@field addon_type FString
---@field durability float
---@field max_durability float
local FB1LogStructureAddOn = {}



---@class FB1LogStructureDestroyed : FB1LogBase
---@field fb1logstructuredestroyedname FString
---@field attack_id int64
local FB1LogStructureDestroyed = {}



---@class FB1LogStructureTakeDamge : FB1LogBase
---@field fb1logstructuretakedamgename FString
---@field attack_id int64
local FB1LogStructureTakeDamge = {}



---@class FB1LogVehicle : FB1LogVehicleDigest
---@field fb1logvehiclename FString
---@field passengers TArray<FB1LogCharacterDigest>
---@field container_items TArray<FB1LogItemDigest>
---@field Parts FB1LogVehicleParts
local FB1LogVehicle = {}



---@class FB1LogVehicleAttachCustom : FB1LogBase
---@field fb1logvehicleattachcustomname FString
---@field part_type FString
---@field part_custom_type FString
---@field attached_custom FString
local FB1LogVehicleAttachCustom = {}



---@class FB1LogVehicleAttachPart : FB1LogBase
---@field fb1logvehicleattachpartname FString
---@field part_type FString
local FB1LogVehicleAttachPart = {}



---@class FB1LogVehicleDetachCustom : FB1LogBase
---@field fb1logvehicledetachcustomname FString
---@field part_type FString
---@field part_custom_type FString
---@field detached_custom FString
local FB1LogVehicleDetachCustom = {}



---@class FB1LogVehicleDetachPart : FB1LogBase
---@field fb1logvehicledetachpartname FString
---@field part_type FString
local FB1LogVehicleDetachPart = {}



---@class FB1LogVehicleDigest
---@field fb1logvehicledigestname FString
---@field vehicle_id int64
---@field vehicle_backend_id FString
---@field vehicle_key FName
---@field owner_squad_id int64
---@field licensed_account_id int64
local FB1LogVehicleDigest = {}



---@class FB1LogVehicleEquipMount : FB1LogBase
---@field fb1logvehicleequipmountname FString
local FB1LogVehicleEquipMount = {}



---@class FB1LogVehicleOwnerChange : FB1LogBase
---@field fb1logvehicleownerchangename FString
---@field old_owner_squad_id int64
---@field new_owner_squad_id int64
local FB1LogVehicleOwnerChange = {}



---@class FB1LogVehicleParts
---@field fb1logvehiclepartsname FString
---@field Chassis TMap<FString, FString>
---@field Body TMap<FString, FString>
---@field Powertrain TMap<FString, FString>
---@field FrameAttachment TMap<FString, FString>
---@field Unibody TMap<FString, FString>
local FB1LogVehicleParts = {}



---@class FB1LogVehicleRepairPart : FB1LogBase
---@field fb1logvehiclerepairpartname FString
---@field part_type FString
---@field part_custom_type FString
---@field hit_point_type FString
---@field add_durability int32
---@field new_durability int32
---@field tool_item_decresed_durability int32
local FB1LogVehicleRepairPart = {}



---@class FB1LogVehicleSpawn : FB1LogBase
---@field fb1logvehiclespawnname FString
local FB1LogVehicleSpawn = {}



---@class FB1LogVehicleStandUp : FB1LogBase
---@field fb1logvehiclestandupname FString
local FB1LogVehicleStandUp = {}



---@class FB1LogVehicleTakeDamage : FB1LogBase
---@field fb1logvehicletakedamagename FString
---@field attack_id int64
local FB1LogVehicleTakeDamage = {}



---@class FB1MannequinAnimEvent
---@field AnimMontage UAnimMontage
---@field Hour int32
---@field LoopCount int32
local FB1MannequinAnimEvent = {}



---@class FB1MaterialOriginDataMaps
---@field OriginMaterialsMap TMap<FOriginMaterialMapKey, UMaterialInterface>
local FB1MaterialOriginDataMaps = {}



---@class FB1MaterialParameters
---@field ScalarParameterValues TArray<FScalarParameterValue>
---@field VectorParameterValues TArray<FVectorParameterValue>
---@field DoubleVectorParameterValues TArray<FDoubleVectorParameterValue>
---@field TextureParameterValues TArray<FTextureParameterValue>
---@field RuntimeVirtualTextureParameterValues TArray<FRuntimeVirtualTextureParameterValue>
---@field SparseVolumeTextureParameterValues TArray<FSparseVolumeTextureParameterValue>
---@field FontParameterValues TArray<FFontParameterValue>
local FB1MaterialParameters = {}



---@class FB1MeshColorChangeRequest
---@field SlotNames TArray<FName>
---@field Color FLinearColor
---@field ApplyColorParameterName FName
local FB1MeshColorChangeRequest = {}



---@class FB1ModKitAssetData
---@field Thumbnail UTexture2D
local FB1ModKitAssetData = {}



---@class FB1ModKitAssetDataWrapper
---@field AssetsData TArray<FB1ModKitAssetData>
local FB1ModKitAssetDataWrapper = {}



---@class FB1ModKitAssetWrapper
---@field AssetList TArray<UB1ModKitAssetListEntryData>
local FB1ModKitAssetWrapper = {}



---@class FB1MontagesForCache
---@field assets TSet<UAnimMontage>
local FB1MontagesForCache = {}



---@class FB1MorphTargetData
---@field Name FName
---@field LODInfos TArray<FB1MorphTargetLODInfo>
local FB1MorphTargetData = {}



---@class FB1MorphTargetDelta
---@field PositionDelta FVector3f
---@field TangentZDelta FVector3f
---@field SourceIdx uint32
local FB1MorphTargetDelta = {}



---@class FB1MorphTargetLODInfo
---@field Vertices TArray<FB1MorphTargetDelta>
local FB1MorphTargetLODInfo = {}



---@class FB1NightModePreset
---@field From_Hour int32
---@field To_Hour int32
---@field DirectionalLight FB1NightMode_DirectionalLight
---@field ExponentialHeightFog FB1NightMode_ExponentialHeightFog
---@field SkyLight FB1NightMode_SkyLight
---@field PostProcess FB1NightMode_PostProcess
---@field Dome FB1NightMode_Dome
---@field Sun FB1NightMode_Sun
---@field ScalarParameters TMap<FName, float>
---@field VectorParameters TMap<FName, FLinearColor>
local FB1NightModePreset = {}



---@class FB1NightMode_DirectionalLight
---@field Rotator FRotator
---@field SourceAngle float
---@field bUseTemperature boolean
---@field Temperature float
---@field Intensity float
---@field IndirectLightingIntensity float
local FB1NightMode_DirectionalLight = {}



---@class FB1NightMode_Dome
---@field Material UMaterialInstance
local FB1NightMode_Dome = {}



---@class FB1NightMode_ExponentialHeightFog
---@field FogDensity float
---@field FogHeightFalloff float
---@field StartDistance float
---@field bEnableVolumetricFog boolean
---@field InscatteringColor FLinearColor
---@field DirectionalInscatteringExponent float
local FB1NightMode_ExponentialHeightFog = {}



---@class FB1NightMode_PostProcess
---@field AutoExposureBias float
---@field LocalExposureHighlightContrastScale float
---@field LocalExposureShadowContrastScale float
local FB1NightMode_PostProcess = {}



---@class FB1NightMode_SkyLight
---@field SourceType ESkyLightSourceType
---@field Intensity float
---@field IndirectLightingIntensity float
---@field LightColor FLinearColor
local FB1NightMode_SkyLight = {}



---@class FB1NightMode_Sun
---@field Transform FTransform
---@field Material UMaterialInstance
local FB1NightMode_Sun = {}



---@class FB1ObjectMeshInfo
---@field MComp UMeshComponent
---@field ISMComp UInstancedStaticMeshComponent
---@field Index int32
local FB1ObjectMeshInfo = {}



---@class FB1ObjectSaveData
---@field ObjectId int64
---@field Location FVector
---@field Rotator FRotator
---@field Scale FVector
---@field AttachParentObjectId int64
local FB1ObjectSaveData = {}



---@class FB1ObjectSlotSaveData
---@field SlotState TMap<FName, FB1SlotStateSaveData>
---@field UseSlotCompanyIdOnly int64
---@field UseSlotEmployeeObjectIdOnly int64
---@field UseSlotSchedulerIdOnly int64
local FB1ObjectSlotSaveData = {}



---@class FB1ObjectSoundCacheData
local FB1ObjectSoundCacheData = {}


---@class FB1ObjectWhiteListData
---@field ID FString
---@field GameObject UBlueprint
---@field MaterialDependencies TSet<UMaterialInterface>
---@field MeshDependencies TArray<FString>
---@field Thumbnail UTexture2D
---@field ObjectTag FGameplayTag
local FB1ObjectWhiteListData = {}



---@class FB1OriginalMaterialCustomizeParams
local FB1OriginalMaterialCustomizeParams = {}


---@class FB1OscElement
local FB1OscElement = {}


---@class FB1OscMessage
local FB1OscMessage = {}


---@class FB1OverlapInfo
---@field Type EB1CameraCollisionType
---@field OverlappingComp UPrimitiveComponent
---@field BodyIndexs TArray<int32>
---@field IsDecoCollision boolean
local FB1OverlapInfo = {}



---@class FB1PartsColorDataList
---@field PartsColorDataMap TMap<FB1EnvironmentPartsKey, FLinearColor>
local FB1PartsColorDataList = {}



---@class FB1PlayAnimMontageParam
---@field RandomEntries TArray<FB1RandomMontageEntry>
local FB1PlayAnimMontageParam = {}



---@class FB1PlayLog : FTableRowBase
---@field SelfEntityId FB1EntityId
---@field TargetEntityId FB1EntityId
---@field InteractionId FName
---@field log FString
local FB1PlayLog = {}



---@class FB1PlayerActionQueueRemoveAreaWidget_Setting
---@field WidgetStates TMap<EB1PlayerActionQueueRemoveAreaWidget_State, FB1PlayerActionQueueRemoveAreaWidget_WidgetState>
local FB1PlayerActionQueueRemoveAreaWidget_Setting = {}



---@class FB1PlayerActionQueueRemoveAreaWidget_WidgetState
---@field RootAlpha float
---@field TextAreaAlpha float
---@field BgColor FLinearColor
---@field PlayTime float
local FB1PlayerActionQueueRemoveAreaWidget_WidgetState = {}



---@class FB1PlayerActionQueueWidget_Preview
---@field ActionItemNum int32
local FB1PlayerActionQueueWidget_Preview = {}



---@class FB1PlayerActionQueueWidget_Setting
---@field ActionItemClass TSubclassOf<UB1PlayerActionItemWidget>
---@field ItemSpacing float
local FB1PlayerActionQueueWidget_Setting = {}



---@class FB1PlayerDesireGaugeWidget_Setting
---@field WidgetOptions TMap<EB1PlayerDesirePhase, FB1PlayerDesireGaugeWidget_WidgetOption>
local FB1PlayerDesireGaugeWidget_Setting = {}



---@class FB1PlayerDesireGaugeWidget_WidgetOption
---@field GaugeBarColor FLinearColor
---@field GaugeBgColor FLinearColor
local FB1PlayerDesireGaugeWidget_WidgetOption = {}



---@class FB1PlayerDesireWidget_Setting
---@field WidgetOptions TMap<EB1PlayerDesirePhase, FB1PlayerDesireWidget_WidgetOptions>
local FB1PlayerDesireWidget_Setting = {}



---@class FB1PlayerDesireWidget_WidgetOptions
---@field ButtonBgColor FLinearColor
local FB1PlayerDesireWidget_WidgetOptions = {}



---@class FB1PlayerNaviData
local FB1PlayerNaviData = {}


---@class FB1PlayerSpawnCompletedContent
local FB1PlayerSpawnCompletedContent = {}


---@class FB1PlayerSpawnParameterSaveData
---@field ObjectId int64
---@field FamilyId int64
---@field Transform FTransform
---@field bIsAutonomousAction boolean
---@field bAddFamilyMember boolean
---@field bIsNewBorn boolean
---@field PlayerTag EB1PlayerTag
---@field NpcId FName
---@field PostType EB1PostPlayerSpawn
---@field PostParameter FB1PostSpawnParameter
local FB1PlayerSpawnParameterSaveData = {}



---@class FB1PoolEntry
---@field WallIcon TSoftObjectPtr<UObject>
---@field DisplayNameTextId FString
---@field DescriptionTextId FString
local FB1PoolEntry = {}



---@class FB1PoseDiffAdder
---@field ParentBone FBoneReference
---@field ParentAxis EB1RotationAxis
---@field TargetBone FBoneReference
---@field TargetAxis EB1RotationAxis
---@field Weight float
---@field Offset float
local FB1PoseDiffAdder = {}



---@class FB1PrintedAccessoryObjectTooltipEntryData
---@field Thumbnail TSoftObjectPtr<UTexture2D>
---@field bIsCanvasItem boolean
local FB1PrintedAccessoryObjectTooltipEntryData = {}



---@class FB1ProbActorList
---@field ProbSpawnList TArray<AActor>
local FB1ProbActorList = {}



---@class FB1ProbSpawnInfo
---@field ID FName
---@field SpawnBluePrint TSoftClassPtr<AActor>
---@field FXObject UClass
---@field SpawnTransform FTransform
local FB1ProbSpawnInfo = {}



---@class FB1ProbSpawnInfoList
---@field ProbSpawnInfoList TArray<FB1ProbSpawnInfo>
local FB1ProbSpawnInfoList = {}



---@class FB1RandomAnimPlayData
---@field Entry FB1RandomPlayerSequenceEntry
local FB1RandomAnimPlayData = {}



---@class FB1RandomMontageEntry
local FB1RandomMontageEntry = {}


---@class FB1RandomPlayerSequenceEntry
---@field Sequence UAnimSequenceBase
---@field ChanceToPlay float
---@field MinLoopCount int32
---@field MaxLoopCount int32
---@field PlayRate float
---@field BlendIn FAlphaBlend
local FB1RandomPlayerSequenceEntry = {}



---@class FB1RelationshipEffectState
local FB1RelationshipEffectState = {}


---@class FB1ReplacedMeshInfo
---@field OriginMesh TSoftObjectPtr<UStaticMesh>
---@field ReplacedMesh TSoftObjectPtr<UStaticMesh>
local FB1ReplacedMeshInfo = {}



---@class FB1RoofFrag
---@field ComponentName FString
---@field MeshPartsName FString
---@field MeshAsset TSoftObjectPtr<UStaticMesh>
---@field Materials TArray<TSoftObjectPtr<UMaterialInterface>>
---@field Margin FVector
---@field MarginRate FVector
---@field Offset FVector
---@field OffsetRate FVector
---@field Rotation FVector
local FB1RoofFrag = {}



---@class FB1RoomSerializeData
---@field Walls TArray<int64>
---@field RoomDescription TArray<int32>
---@field WallHeight float
---@field CustomWallData TArray<FB1SiteAreaCustomWallSaveData>
---@field CustomWallDecoData TArray<FB1SiteAreaCustomWallDecoSaveData>
---@field CustomRoomBottomFloorData TArray<FB1SiteAreaCustomBottomFloorSaveData>
---@field CustomBottomFloorData TArray<FB1SiteAreaCustomBottomFloorSaveData>
---@field CustomRoomCeilFloorData TArray<FB1SiteAreaCustomBottomFloorSaveData>
---@field CustomCeilFloorData TArray<FB1SiteAreaCustomBottomFloorSaveData>
local FB1RoomSerializeData = {}



---@class FB1SaveLoadThumbnailDataStruct
local FB1SaveLoadThumbnailDataStruct = {}


---@class FB1SavePresetTypeSelectionData
---@field DisplayName FText
---@field OptionValue FName
local FB1SavePresetTypeSelectionData = {}



---@class FB1SaveSlotData
---@field InstanceId int32
---@field SaveType EB1SaveType
---@field SaveSlotName FString
---@field GameVersion int32
---@field MapId FName
---@field LevelName FName
---@field SiteId FName
---@field SaveTime FDateTime
---@field LastPlayCharacterObjectId int64
---@field LastPlayCharacterFirstName FString
---@field LastPlayCharacterLastName FString
---@field LastObjectId int64
---@field LastFamilyId int64
---@field LastInventoryId int64
---@field LastCompanyId int64
---@field LastSchedulerId int64
local FB1SaveSlotData = {}



---@class FB1SceneSetting
---@field CameraMode EB1CameraModeType
---@field InputInterfaceClass TSubclassOf<APawn>
---@field bHidePlayer boolean
---@field bHideHud boolean
---@field bPauseGame boolean
---@field IgnorePendingSceneBeginInputTransition boolean
---@field bSetPos boolean
---@field StartPos FVector
---@field StartRot FRotator
---@field InputInterface APawn
local FB1SceneSetting = {}



---@class FB1SeasonOverrideMaterialInfo
---@field OverridMaterial TSoftObjectPtr<UMaterialInterface>
---@field OverridSlotNameList TArray<FName>
local FB1SeasonOverrideMaterialInfo = {}



---@class FB1SeasonOverrideMeshInfo
---@field OverridMesh TSoftObjectPtr<UStaticMesh>
---@field OverridMaterialInfoList TArray<FB1SeasonOverrideMaterialInfo>
---@field bResetToDefaultMaterial boolean
local FB1SeasonOverrideMeshInfo = {}



---@class FB1SelectedFloorData
local FB1SelectedFloorData = {}


---@class FB1SimplePoseData
---@field Time float
---@field Positions TArray<FVector>
local FB1SimplePoseData = {}



---@class FB1SiteAreaBoundCeilingData
---@field Border TArray<FVector2D>
---@field LocationZ float
local FB1SiteAreaBoundCeilingData = {}



---@class FB1SiteAreaGroundSetting
---@field UseDynamicGround boolean
---@field DynamicGroundScale FVector
---@field DynamicGroundOffset FVector
---@field GroundMesh TSoftObjectPtr<UStaticMesh>
---@field GroundMaterial TSoftObjectPtr<UMaterialInterface>
local FB1SiteAreaGroundSetting = {}



---@class FB1SiteAreaInstanceId
---@field MeshName FName
---@field MaterialParameters TArray<FB1MaterialParameters>
---@field Materials TArray<TWeakObjectPtr<UMaterialInterface>>
local FB1SiteAreaInstanceId = {}



---@class FB1SiteAreaSaveData
---@field ObjectId int64
---@field LevelName FName
---@field SiteAreaName FName
---@field AttachedGameObjectIds TArray<int64>
---@field SiteDtId FName
---@field OwnerFamilyId int64
---@field OwnerCompanyId int64
---@field bTakeOffShoes boolean
---@field VisitorIds TArray<int64>
---@field OverrideSiteName FText
---@field OverrideDescription FText
---@field OverrideImageKey FString
---@field SavedBuiltData FB1SiteAreaBuiltSaveData
---@field PathFindingData FB1SiteAreaPathFindingSaveData
local FB1SiteAreaSaveData = {}



---@class FB1SiteInfo
local FB1SiteInfo = {}


---@class FB1SiteInfoButtonV2WidgetSetting
---@field FamilyLoveArrowAngleMin float
---@field FamilyLoveArrowAngleMax float
---@field CleanlinessAngleMin float
---@field CleanlinessAngleMax float
local FB1SiteInfoButtonV2WidgetSetting = {}



---@class FB1SiteInfoUIData
local FB1SiteInfoUIData = {}


---@class FB1SkillGaugeColor
---@field MaxValue int32
---@field MainColor FColor
---@field GradientColor FColor
local FB1SkillGaugeColor = {}



---@class FB1SkillUIData
local FB1SkillUIData = {}


---@class FB1SlotStateSaveData
---@field SlotOccupyingReasons TArray<EB1SlotOccupyingReason>
---@field ObjectId int64
local FB1SlotStateSaveData = {}



---@class FB1SpawnedVATMeshInfo
local FB1SpawnedVATMeshInfo = {}


---@class FB1SpeechBubbleObjectData
---@field SpeechBubbleWidget UB1SpeechBubbleWidget
local FB1SpeechBubbleObjectData = {}



---@class FB1SpringInterp
---@field Strength float
local FB1SpringInterp = {}



---@class FB1StableDiffusionHandle
---@field StableDiffusion UStableDiffusion
---@field Param FB1StableDiffusionRequestParam
local FB1StableDiffusionHandle = {}



---@class FB1StableDiffusionRequestParam
---@field prompt FString
local FB1StableDiffusionRequestParam = {}



---@class FB1StableDiffusionSaveData
---@field SDId int64
---@field FilePath FString
---@field Roughness float
---@field Metallic float
local FB1StableDiffusionSaveData = {}



---@class FB1StatLocomotionData
---@field IdleRandomAnims TArray<FB1RandomPlayerSequenceEntry>
---@field WalkAnims TArray<FB1RandomPlayerSequenceEntry>
---@field MinNormalWalkTime float
---@field MaxNormalWalkTime float
local FB1StatLocomotionData = {}



---@class FB1StateVariationArray
---@field StateVariations TArray<FB1StateVariation>
local FB1StateVariationArray = {}



---@class FB1SubMaterials
---@field SlotMaterials TMap<FName, UMaterialInterface>
local FB1SubMaterials = {}



---@class FB1TargetWallEntry
local FB1TargetWallEntry = {}


---@class FB1TimeControllerWidget_AnimationSetting
---@field ButtonBgMoveTimeSec float
local FB1TimeControllerWidget_AnimationSetting = {}



---@class FB1TimeControllerWidget_Setting
---@field AnimationSetting FB1TimeControllerWidget_AnimationSetting
---@field TimeScaleChangeDelay float
---@field TimeScaleSpeed1 float
---@field TimeScaleSpeed2 float
---@field TimeScaleSpeed3 float
---@field TimeScaleSpeed4 float
local FB1TimeControllerWidget_Setting = {}



---@class FB1ToastInfo
local FB1ToastInfo = {}


---@class FB1TopMenuWidget_MenuSetting
---@field bIsToggle boolean
---@field OpenAnimation FName
---@field CloseAnimation FName
local FB1TopMenuWidget_MenuSetting = {}



---@class FB1TopMenuWidget_MenuState
local FB1TopMenuWidget_MenuState = {}


---@class FB1TopMenuWidget_Setting
---@field MenuSettingMap TMap<EB1TopMenuCategory, FB1TopMenuWidget_MenuSetting>
local FB1TopMenuWidget_Setting = {}



---@class FB1TrafficLightActorWarpper
---@field TrafficLightActors TArray<AB1TrafficLightActor>
local FB1TrafficLightActorWarpper = {}



---@class FB1TrafficLightInstanceCustomData
---@field PackedParam1 float
local FB1TrafficLightInstanceCustomData = {}



---@class FB1TraitSelectCategoryInfo
---@field Key FName
---@field DisplayName FText
---@field CategoryFloatingTextWidget UB1TraitSelectFloatingText
---@field SubTextList TMap<FName, FB1TraitSelectNodeInfo>
local FB1TraitSelectCategoryInfo = {}



---@class FB1TraitSelectFXObject
---@field FxSystemList TArray<TSubclassOf<UB1FXObject>>
local FB1TraitSelectFXObject = {}



---@class FB1TraitSelectModeLevelSequenceInfo
---@field LevelSequenceId FName
---@field GenderType EB1GenderType
---@field AgeType EB1BodyAgeType
local FB1TraitSelectModeLevelSequenceInfo = {}



---@class FB1TraitSelectNodeInfo
---@field Key FName
---@field OppositeKey FName
---@field FloatingTextWidget UB1TraitSelectFloatingText
---@field OppositeFloatingTextWidget UB1TraitSelectFloatingText
local FB1TraitSelectNodeInfo = {}



---@class FB1UICustomizationSubWidgetInfo
---@field bHasSubWidget boolean
---@field SubWidgetId FName
local FB1UICustomizationSubWidgetInfo = {}



---@class FB1UserCustomAssembleObject
---@field Hash int64
---@field TemplateId FName
---@field PartsIndex00 int32
---@field PartsIndex01 int32
---@field PartsIndex02 int32
---@field IconData TArray<FColor>
local FB1UserCustomAssembleObject = {}



---@class FB1UserCustomizedData
---@field AssembledObjects TArray<FB1UserCustomAssembleObject>
---@field BuildCustomizeColorPalettes TArray<FB1BuildCustomizeColorPaletteEntrySaveData>
local FB1UserCustomizedData = {}



---@class FB1UserImportDataDialogParam
---@field Title FString
---@field OpenPath FString
---@field SubCategory FString
local FB1UserImportDataDialogParam = {}



---@class FB1V2MAnimInstanceProxy : FAnimInstanceProxy
local FB1V2MAnimInstanceProxy = {}


---@class FB1VariantListItemData
local FB1VariantListItemData = {}


---@class FB1VehicleManagementUICategoryData
---@field CategoryType EB1VehicleManagementCategory
---@field ButtonImage TSoftObjectPtr<UTexture2D>
---@field TabButtonString FText
---@field DetailButtonString FText
---@field SubtitleString FText
local FB1VehicleManagementUICategoryData = {}



---@class FB1VmcBlendShape
---@field Meshes TArray<FB1VmcBlendShapeMesh>
---@field Clips TArray<FB1VmcBlendShapeClip>
local FB1VmcBlendShape = {}



---@class FB1VmcBlendShapeClip
---@field Name FName
---@field States TArray<FB1VmcBlendShapeMeshState>
local FB1VmcBlendShapeClip = {}



---@class FB1VmcBlendShapeMesh
---@field Name FName
---@field Targets TArray<FName>
local FB1VmcBlendShapeMesh = {}



---@class FB1VmcBlendShapeMeshState
---@field Name FName
---@field Targets TArray<FB1VmcBlendShapeState>
local FB1VmcBlendShapeMeshState = {}



---@class FB1VmcBlendShapeState
---@field Index int32
---@field Weight float
local FB1VmcBlendShapeState = {}



---@class FB1VmcBoneMapping
---@field Hips FName
---@field LeftUpperLeg FName
---@field RightUpperLeg FName
---@field LeftLowerLeg FName
---@field RightLowerLeg FName
---@field LeftFoot FName
---@field RightFoot FName
---@field spine FName
---@field Chest FName
---@field Neck FName
---@field Head FName
---@field LeftShoulder FName
---@field RightShoulder FName
---@field LeftUpperArm FName
---@field RightUpperArm FName
---@field LeftLowerArm FName
---@field RightLowerArm FName
---@field LeftHand FName
---@field RightHand FName
---@field LeftToes FName
---@field RightToes FName
---@field LeftEye FName
---@field RightEye FName
---@field Jaw FName
---@field LeftThumbProximal FName
---@field LeftThumbIntermediate FName
---@field LeftThumbDistal FName
---@field LeftIndexProximal FName
---@field LeftIndexIntermediate FName
---@field LeftIndexDistal FName
---@field LeftMiddleProximal FName
---@field LeftMiddleIntermediate FName
---@field LeftMiddleDistal FName
---@field LeftRingProximal FName
---@field LeftRingIntermediate FName
---@field LeftRingDistal FName
---@field LeftLittleProximal FName
---@field LeftLittleIntermediate FName
---@field LeftLittleDistal FName
---@field RightThumbProximal FName
---@field RightThumbIntermediate FName
---@field RightThumbDistal FName
---@field RightIndexProximal FName
---@field RightIndexIntermediate FName
---@field RightIndexDistal FName
---@field RightMiddleProximal FName
---@field RightMiddleIntermediate FName
---@field RightMiddleDistal FName
---@field RightRingProximal FName
---@field RightRingIntermediate FName
---@field RightRingDistal FName
---@field RightLittleProximal FName
---@field RightLittleIntermediate FName
---@field RightLittleDistal FName
local FB1VmcBoneMapping = {}



---@class FB1VmcVrmMappingData
---@field BoneMapping FB1VmcBoneMapping
---@field BlendShape FB1VmcBlendShape
local FB1VmcVrmMappingData = {}



---@class FB1WallSelectEntry
local FB1WallSelectEntry = {}


---@class FB1WeatherDisplayWidget_AnimationSetting
---@field WeatherIcon FB1WeatherDisplayWidget_WeatherIconAnimationSetting
local FB1WeatherDisplayWidget_AnimationSetting = {}



---@class FB1WeatherDisplayWidget_DaySetting
---@field DayStartHour int32
---@field DayStartMinute int32
---@field NightStartHour int32
---@field NightStartMinute int32
---@field DayIcon TSoftObjectPtr<UObject>
---@field DayColor FLinearColor
---@field NightIcon TSoftObjectPtr<UObject>
---@field NightColor FLinearColor
local FB1WeatherDisplayWidget_DaySetting = {}



---@class FB1WeatherDisplayWidget_Setting
---@field AnimationSetting FB1WeatherDisplayWidget_AnimationSetting
---@field DaySetting FB1WeatherDisplayWidget_DaySetting
local FB1WeatherDisplayWidget_Setting = {}



---@class FB1WeatherDisplayWidget_WeatherIconAnimationSetting
---@field PlayTimeSec float
---@field CurrentIcon FB1WeatherDisplayWidget_WeatherIconWidgetAnimationSetting
---@field NextIcon FB1WeatherDisplayWidget_WeatherIconWidgetAnimationSetting
local FB1WeatherDisplayWidget_WeatherIconAnimationSetting = {}



---@class FB1WeatherDisplayWidget_WeatherIconWidgetAnimationSetting
---@field TranslationFrom FVector2D
---@field TranslationTo FVector2D
---@field OpacityFrom float
---@field OpacityTo float
local FB1WeatherDisplayWidget_WeatherIconWidgetAnimationSetting = {}



---@class FB1WeatherMaterialData
---@field MaterialParameterCollection UMaterialParameterCollection
---@field MaterialControlCurves TMap<FName, UCurveFloat>
local FB1WeatherMaterialData = {}



---@class FB1WidgetAnimationData
---@field WidgetAnimationName FName
---@field PlayMode EUMGSequencePlayMode::Type
local FB1WidgetAnimationData = {}



---@class FB1WidgetAnimationSetting
---@field Opening FB1WidgetAnimationData
---@field Closing FB1WidgetAnimationData
---@field Hover FB1WidgetAnimationData
---@field Unhover FB1WidgetAnimationData
---@field Selected FB1WidgetAnimationData
---@field Unselected FB1WidgetAnimationData
---@field Press FB1WidgetAnimationData
---@field Release FB1WidgetAnimationData
---@field SubWidgetOpening FB1WidgetAnimationData
---@field SubWidgetClosing FB1WidgetAnimationData
local FB1WidgetAnimationSetting = {}



---@class FB1WidgetCustomizationSetting
---@field bIsCustomizationWidget boolean
---@field WidgetId FName
---@field Size FIntVector2
---@field PositionType EB1UICustomizationPositionType
---@field Position FVector2D
---@field GridPosition FIntPoint
---@field HorizontalAlignment EHorizontalAlignment
---@field VerticalAlignment EVerticalAlignment
---@field Offset FVector2D
---@field bCanBeDragged boolean
---@field WidgetType EB1UICustomizationWidgetType
---@field SubWidgetInfo FB1UICustomizationSubWidgetInfo
---@field bVisible boolean
local FB1WidgetCustomizationSetting = {}



---@class FB1WorldMaterialTextureReplaceInfo
---@field SpriteTextureList TArray<TSoftObjectPtr<UTexture2D>>
local FB1WorldMaterialTextureReplaceInfo = {}



---@class FB1WorldMesh
---@field MeshReplaceMap TMap<uint32, FB1ReplacedMeshInfo>
local FB1WorldMesh = {}



---@class FB1WorldMeshColorChangeRequestList
---@field MeshReplaceMaterialList TMap<int32, FB1MeshColorChangeRequest>
local FB1WorldMeshColorChangeRequestList = {}



---@class FB1WorldMeshReplaceMaterialData
---@field OverrideMaterialList TArray<TSoftObjectPtr<UMaterialInterface>>
local FB1WorldMeshReplaceMaterialData = {}



---@class FB1WorldMeshReplaceMaterialDataList
---@field MeshReplaceMaterialList TMap<uint32, FB1WorldMeshReplaceMaterialData>
local FB1WorldMeshReplaceMaterialDataList = {}



---@class FB1WorldSaveData
---@field WorldManagerSpawnCharacterMap TMap<int64, FVector>
---@field WorldManagerSpawnStoryCharacterMap TMap<int64, FVector>
---@field MeshReplaceSelectionIdList TMap<FName, FB1MeshReplaceSelectionList>
---@field WorldPartsColorDataList TMap<FName, FB1PartsColorDataList>
---@field YoutubeSelect TMap<FName, FString>
---@field WorldAnimalSpawnCountValue TMap<FName, FB1WorldDecorationSpawnCountDataList>
---@field WorldStabilitySelectionList TMap<FName, FB1StabilitySelectionList>
---@field WorldProbSpawnSelectionList TMap<FName, FB1StabilitySelectionList>
---@field WorldDataLayerRuntimeStateList TMap<FName, EDataLayerRuntimeState>
local FB1WorldSaveData = {}



---@class FB1YoutubeDetailInfo
---@field Title FString
---@field Thumbnail UTexture2D
local FB1YoutubeDetailInfo = {}



---@class FB1YoutubeInfo
---@field ID FString
---@field URL FString
---@field thumbnailUrl FString
---@field bIsUserImport boolean
local FB1YoutubeInfo = {}



---@class FB1ZoiInformationWidgetItem
---@field Widget UB1ZoiInformationWidget
local FB1ZoiInformationWidgetItem = {}



---@class FCollisionBox
---@field Transform FTransform
---@field Box FBox
local FCollisionBox = {}



---@class FCritDampSpringInterpolatorRotator
---@field NaturalFrequency float
local FCritDampSpringInterpolatorRotator = {}



---@class FCritDampSpringInterpolatorVector
---@field NaturalFrequency float
local FCritDampSpringInterpolatorVector = {}



---@class FDefaultMaterialInfo
---@field DefaultMaterials TArray<UMaterialInterface>
local FDefaultMaterialInfo = {}



---@class FDoubleIIRInterpolatorFloat
---@field PrimaryInterpSpeed float
---@field IntermediateInterpSpeed float
local FDoubleIIRInterpolatorFloat = {}



---@class FDoubleIIRInterpolatorRotator
---@field PrimaryInterpSpeed float
---@field IntermediateInterpSpeed float
local FDoubleIIRInterpolatorRotator = {}



---@class FDoubleIIRInterpolatorVector
---@field PrimaryInterpSpeed float
---@field IntermediateInterpSpeed float
local FDoubleIIRInterpolatorVector = {}



---@class FDroneSpeedParameters
---@field LinearAccelScale float
---@field LinearDecelScale float
---@field RotAccelScale float
---@field RotDecelScale float
---@field MaxRotSpeedScale float
---@field HoverThrustScale float
local FDroneSpeedParameters = {}



---@class FGalleryComponentItem
---@field ItemType FString
---@field thumbnailUrl FString
local FGalleryComponentItem = {}



---@class FGalleryData
---@field OriginalAuthorAccountInfos TArray<FAccountInfo>
---@field CanvasAccountId FString
---@field Title FString
---@field Thumbnail FString
---@field LikeCount int32
---@field downloadCount int32
---@field HashTags FString
---@field CreateTime FString
---@field Desc FString
---@field ImageUrls FString
---@field ContributorIds TArray<FString>
---@field CanvasComponentItems TArray<FGalleryComponentItem>
---@field CommentCount int32
---@field Meta FString
local FGalleryData = {}



---@class FIIRInterpolatorFloat
---@field InterpSpeed float
local FIIRInterpolatorFloat = {}



---@class FIIRInterpolatorRotator
---@field InterpSpeed float
local FIIRInterpolatorRotator = {}



---@class FIIRInterpolatorVector
---@field InterpSpeed float
local FIIRInterpolatorVector = {}



---@class FMainNotificationData
---@field NotificationList TArray<FNotificationData>
---@field LastEvaluatedKey FString
local FMainNotificationData = {}



---@class FNotificationData
---@field Read boolean
---@field Parameters FNotificationParameters
---@field NotifyType FString
---@field NotificationId FString
---@field FromAccountId FString
local FNotificationData = {}



---@class FNotificationParameters
---@field AccountId FString
---@field CanvasItemId FString
---@field MilestoneThreshold FString
---@field RankingDateKey FString
---@field Period FString
---@field Category FString
---@field RepresentativeImage FString
---@field CanvasId FString
---@field Rank FString
---@field Day FString
---@field RestrictionId FString
---@field TargetId FString
---@field RestrictionDate FString
---@field RestrictionType FString
---@field ReasonCategory FString
---@field RestrictionEndDate FString
---@field RestrictionPeriod FString
---@field RestrictionReleaseDate FString
---@field ReasonMemo FString
---@field CreatedDate FString
---@field status FString
---@field TargetOwner FString
---@field TargetString FString
local FNotificationParameters = {}



---@class FOriginMaterialInfo
---@field Materials TArray<FSkeletalMaterial>
local FOriginMaterialInfo = {}



---@class FOriginMaterialMapKey
---@field MeshName FName
---@field MaterialIndex int32
local FOriginMaterialMapKey = {}



---@class FPenetrationAvoidanceRay
---@field AdjustmentRot FRotator
---@field WorldWeight float
---@field Radius float
---@field TraceInterval int32
---@field FramesUntilNextTrace int32
---@field bEnabled boolean
---@field bPrimaryRay boolean
local FPenetrationAvoidanceRay = {}



---@class FRestrictionData
---@field RestrictionId FString
---@field TargetId FString
---@field TargetOwner FString
---@field RestrictionDate FString
---@field RestrictionType FString
---@field ReasonCategory FString
---@field RestrictionEndDate int64
---@field RestrictionPeriod int64
---@field RestrictionReleaseDate int64
---@field ReasonMemo FString
local FRestrictionData = {}



---@class FRestrictionDataInfo
---@field RestrictionInfos TArray<FRestrictionData>
---@field NotificationInfos TArray<FMainNotificationData>
local FRestrictionDataInfo = {}



---@class IB1ActorInterface : IInterface
local IB1ActorInterface = {}


---@class IB1ComponentInterface : IInterface
local IB1ComponentInterface = {}


---@class IB1GalleryRequestInterface : IInterface
local IB1GalleryRequestInterface = {}


---@class IB1GameOptionInterface : IInterface
local IB1GameOptionInterface = {}

---@param GlobalIlluminationQuality int32
function IB1GameOptionInterface:ReceiveGameOptionChanged(GlobalIlluminationQuality) end


---@class IB1InputInterface : IInterface
local IB1InputInterface = {}


---@class IB1ObjectCustomizeUIInterface : IInterface
local IB1ObjectCustomizeUIInterface = {}


---@class IB1SubDepthUIInterface : IInterface
local IB1SubDepthUIInterface = {}


---@class IB1UIHandlerInterface : IInterface
local IB1UIHandlerInterface = {}


---@class UB13DObjectTooltipListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_Image_Icon UB1Image
---@field BW_Image_CanvasIcon UB1Image
local UB13DObjectTooltipListEntryWidget = {}



---@class UB13DObjectTooltipWidget : UB1TooltipWidgetBase
---@field BW_WrapBox_List UB1WrapBox
---@field ObjectTooltipEntryWidgetClass TSubclassOf<UB13DObjectTooltipListEntryWidget>
local UB13DObjectTooltipWidget = {}



---@class UB1AIMotionNamingPopup : UB1UserWidgetBase
---@field BW_WidgetSwitcher_Thumnail UB1WidgetSwitcher
---@field BW_Image_Thumbnail UB1Image
---@field BW_EditableTextBox_MotionName UB1EditableTextBox
---@field BW_Image_TitleError UB1Image
---@field BW_Text_Num UB1TextBlock
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Save UB1CommonButtonWidget
local UB1AIMotionNamingPopup = {}

---@param InText FText
function UB1AIMotionNamingPopup:BW_EditableTextBox_MotionName_OnTextChanged(InText) end


---@class UB1AIMotionPlayerWidget : UB1UserWidgetBase
---@field BW_Button_Pause UB1Button
---@field BW_Button_Play UB1Button
local UB1AIMotionPlayerWidget = {}



---@class UB1AIMotionWidget : UB1UserWidgetBase
---@field BW_WBP_Title UB1CommonTitleWidget
---@field BW_WBP__GenerateMotion UB1GenerateMotionWidget
---@field BW_WBP_Player UB1AIMotionPlayerWidget
local UB1AIMotionWidget = {}



---@class UB1AIReasonWidget : UB1UserWidgetBase
---@field BW_Button_AutonomyToggle UB1Button
---@field BW_WidgetSwitcher_AutonomyToggle UB1WidgetSwitcher
---@field BW_Button_Edit UB1Button
local UB1AIReasonWidget = {}

function UB1AIReasonWidget:ToggleButtonClicked() end
function UB1AIReasonWidget:OnClickEditButton() end


---@class UB1AccumulateAudioSubsystem : UTickableWorldSubsystem
---@field AccumulatePlayAudioDatas TMap<FName, FB1AccumulateAudioData>
local UB1AccumulateAudioSubsystem = {}



---@class UB1ActionTimeTrackingComponent : UActorComponent
local UB1ActionTimeTrackingComponent = {}


---@class UB1ActorComponentUtils : UObject
local UB1ActorComponentUtils = {}


---@class UB1AdditionalMetaData : UAnimMetaData
---@field bInitialized boolean
---@field NotifyAnims TArray<UAnimSequenceBase>
local UB1AdditionalMetaData = {}



---@class UB1AgingComponent : UActorComponent
---@field LastUpdatedAge int32
---@field GrowthStep EB1GrowthStep
---@field PrevGrowthStep EB1GrowthStep
---@field CachedAppearanceComponent UB1AppearanceComponent
local UB1AgingComponent = {}



---@class UB1AlertMessageListEntryWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_Theme UB1WidgetSwitcher
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Desc UB1TextBlock
---@field BW_RichText_Title UB1RichTextBlock
---@field BW_RichText_Desc UB1RichTextBlock
---@field BW_Text_Link UB1TextBlock
---@field BW_Text_Time UB1TextBlock
---@field BW_Image_Portrait UB1Image
---@field BW_Image_DescIcon UB1Image
---@field BW_Image_UnderLine UB1Image
---@field BW_Image_Caution UB1Image
---@field BW_Button_Link UB1Button
---@field BW_Button_Delete UB1Button
---@field BW_Button_Message UB1Button
---@field AlertMessageData FB1AlertMessageData
local UB1AlertMessageListEntryWidget = {}



---@class UB1AlertMessageListWidget : UB1UserWidgetBase
---@field BW_AlertList UB1VerticalBox
---@field BW_Button_Open UB1Button
---@field BW_Button_Close UB1Button
---@field BW_ScrollBox_AlertList UB1ScrollBox
---@field SlotWidgetClass TSubclassOf<UUserWidget>
local UB1AlertMessageListWidget = {}



---@class UB1AlertMessageManager : UB1ManagerBase
local UB1AlertMessageManager = {}


---@class UB1AmbitionEntryData : UObject
local UB1AmbitionEntryData = {}


---@class UB1AmbitionIconWidget : UB1UserListEntryWidgetBase
---@field Image_Goal UB1Image
---@field Image_GoalBg UB1Image
---@field Image_GoalBg_shadow UB1Image
---@field Image_Selected_Line UB1Image
---@field Text_GoalName UB1TextBlock
local UB1AmbitionIconWidget = {}



---@class UB1AmbitionLevelEntryData : UObject
local UB1AmbitionLevelEntryData = {}


---@class UB1AmbitionLevelWidget : UB1UserListEntryWidgetBase
---@field Text_AmbitionLevel UB1TextBlock
---@field BW_Image_Complete UB1Image
---@field BW_Button_MissionLevel_bg_1 UB1Image
local UB1AmbitionLevelWidget = {}



---@class UB1AmbitionMissionTabWidget : UB1UserWidgetBase
---@field BW_Text_SubTabTitle UB1TextBlock
---@field BW_Text_SubTabTitle_Complete UB1TextBlock
---@field BW_Button_SubTab UB1Button
---@field BW_Image_SelectedLine UB1Image
local UB1AmbitionMissionTabWidget = {}

function UB1AmbitionMissionTabWidget:OnMissionTabButtonClicked() end


---@class UB1AmbitionPopupWidget : UB1PopupWidgetBase
---@field BW_Text_AmbitionTitle UB1TextBlock
---@field BW_Text_AmbitionDesc UB1TextBlock
---@field BW_WBP_Button_Confirm UB1CommonButtonWidget
---@field BW_Image_Icon UB1Image
---@field BW_Image_BG UB1Image
---@field BW_Image_BGGlow UB1Image
---@field BW_Image_Glow UB1Image
---@field BW_Image_OuterCircle UB1Image
---@field BW_Image_InnerCircle UB1Image
---@field BW_Image_Sparkle_0 UB1Image
---@field BW_Image_Sparkle_1 UB1Image
---@field BW_Image_Sparkle_2 UB1Image
---@field BW_Image_Sparkle_3 UB1Image
---@field BW_Image_Sparkle_4 UB1Image
---@field BW_Image_Sparkle_5 UB1Image
---@field BW_Image_Sparkle_6 UB1Image
---@field BW_Image_Sparkle_7 UB1Image
---@field BW_Image_BGComplete UB1Image
---@field BW_Image_BGCompleteDot UB1Image
local UB1AmbitionPopupWidget = {}



---@class UB1AmbitionRewardWidget : UB1UserWidgetBase
---@field Text_CompleteLinkTraitID UB1TextBlock
---@field Text_Desc UB1TextBlock
local UB1AmbitionRewardWidget = {}



---@class UB1AmbitionUIHandler : UB1AmbitionUIHandlerBase
local UB1AmbitionUIHandler = {}


---@class UB1AmbitionUIHandlerBase : UB1UIHandlerBase
local UB1AmbitionUIHandlerBase = {}


---@class UB1AmbitionWidget : UB1UserWidgetBase
---@field Image_Goal UB1Image
---@field BW_Text_AmbitionName UB1TextBlock
---@field Text_GoalName UB1TextBlock
---@field Button_GoalChange UB1CommonButtonWidget
---@field ListView_AmbitionLevel UB1ListView
---@field ListView_MissionList UB1ListView
---@field WidgetSwitcher_SlotBG UB1WidgetSwitcher
---@field BW_Image_ChildLock UB1Image
---@field bIsCatOperatorWidget boolean
local UB1AmbitionWidget = {}



---@class UB1AnimInstance : UAnimInstance
---@field SourceRetargetMeshComponent USkeletalMeshComponent
---@field CurrentRetargeter UIKRetargeter
---@field bRetargeting boolean
---@field RandomLoopEntries TArray<FB1RandomMontageEntry>
local UB1AnimInstance = {}



---@class UB1AnimNotifyState_AttachDetachActor : UAnimNotifyState
---@field SocketName FName
---@field ActorClass UClass
---@field ActorTag FName
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
local UB1AnimNotifyState_AttachDetachActor = {}



---@class UB1AnimNotifyState_AttachDetachMesh : UAnimNotifyState
---@field SocketName FName
---@field StaticMesh UStaticMesh
---@field bDeleteOnlySelfCreatedMesh boolean
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
local UB1AnimNotifyState_AttachDetachMesh = {}



---@class UB1AnimNotifyState_AttachTemporaryMesh : UAnimNotifyState
---@field SocketName FName
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
---@field TemporaryMeshActor AStaticMeshActor
local UB1AnimNotifyState_AttachTemporaryMesh = {}



---@class UB1AnimNotifyState_BodyFit : UAnimNotifyState
---@field ChainBone EB1ChainBoneType
---@field TargetSocket FName
---@field BlendIn float
---@field BlendOut float
---@field Weight float
local UB1AnimNotifyState_BodyFit = {}



---@class UB1AnimNotifyState_CharacterPlayAudio : UAnimNotifyState
---@field GameObjectSoundId FName
---@field SoundNotifyId FName
---@field SocketType EB1GameObjectAttachSocketType
local UB1AnimNotifyState_CharacterPlayAudio = {}



---@class UB1AnimNotifyState_GameObjectSound : UAnimNotifyState
---@field GameObjectStateType EB1GameObjectStateType
---@field ObjectSoundId FName
---@field CommandType EB1GameObjectSoundCommandType
---@field SocketType EB1GameObjectAttachSocketType
local UB1AnimNotifyState_GameObjectSound = {}



---@class UB1AnimNotifyState_HideOriginMesh : UAnimNotifyState
---@field HideMeshComponentTag FName
local UB1AnimNotifyState_HideOriginMesh = {}



---@class UB1AnimNotifyState_PlayAnim : UAnimNotifyState
---@field BeginAnimInfo FB1PlayAnimInfo
---@field EndAnimInfo FB1PlayAnimInfo
local UB1AnimNotifyState_PlayAnim = {}



---@class UB1AnimNotifyState_PlayVATAnim : UAnimNotifyState
---@field SocketName FName
---@field StaticMesh UStaticMesh
---@field bAttached boolean
---@field bSync boolean
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
---@field AnimName FName
local UB1AnimNotifyState_PlayVATAnim = {}



---@class UB1AnimNotifyState_RunScript : UAnimNotifyState
local UB1AnimNotifyState_RunScript = {}


---@class UB1AnimNotifyState_TimedFXObject : UAnimNotifyState
---@field FXObject TSubclassOf<UB1FXObject>
local UB1AnimNotifyState_TimedFXObject = {}



---@class UB1AnimNotifyState_VoiceDream : UAnimNotifyState
local UB1AnimNotifyState_VoiceDream = {}


---@class UB1AnimNotifyState_VoiceIdle : UAnimNotifyState
---@field VoiceResourceId FName
local UB1AnimNotifyState_VoiceIdle = {}



---@class UB1AnimNotifyState_VoiceInteraction : UAnimNotifyState
---@field VoiceResourceId FName
local UB1AnimNotifyState_VoiceInteraction = {}



---@class UB1AnimNotifyState_VoiceTalk : UAnimNotifyState
---@field VoiceSourceType EB1TalkVoiceSourceType
local UB1AnimNotifyState_VoiceTalk = {}



---@class UB1AnimNotify_AttachActor : UAnimNotify
---@field SocketName FName
---@field ActorClass UClass
---@field ActorTag FName
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
local UB1AnimNotify_AttachActor = {}



---@class UB1AnimNotify_AttachMesh : UAnimNotify
---@field SocketName FName
---@field StaticMesh UStaticMesh
---@field bDeleteOnlySelfCreatedMesh boolean
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
local UB1AnimNotify_AttachMesh = {}



---@class UB1AnimNotify_CameraOffset : UAnimNotify
---@field LocationOffset FVector
local UB1AnimNotify_CameraOffset = {}



---@class UB1AnimNotify_ChangeMaterialParam : UAnimNotify
---@field Target EB1BaseObject
---@field MaterialSlotName FName
---@field ParameterName FName
---@field ParameterType EB1MaterialParamType
---@field ScalarValue float
---@field ColorValue FLinearColor
---@field TextureValue TSoftObjectPtr<UTexture>
local UB1AnimNotify_ChangeMaterialParam = {}



---@class UB1AnimNotify_ChangeState : UAnimNotify
---@field Target EB1BaseObject
---@field ChangedStateGroupName FName
---@field ChangeStateName FName
local UB1AnimNotify_ChangeState = {}



---@class UB1AnimNotify_DetachActor : UAnimNotify
---@field ActorTag FName
local UB1AnimNotify_DetachActor = {}



---@class UB1AnimNotify_DetachMesh : UAnimNotify
---@field SocketName FName
local UB1AnimNotify_DetachMesh = {}



---@class UB1AnimNotify_EnterVehicle : UAnimNotify
---@field VehicleSeat FName
local UB1AnimNotify_EnterVehicle = {}



---@class UB1AnimNotify_ExitVehicle : UAnimNotify
---@field VehicleSeat FName
local UB1AnimNotify_ExitVehicle = {}



---@class UB1AnimNotify_FootSteps : UAnimNotify
---@field PrintSocketName FName
---@field OptionalSoundId FName
---@field TraceChannel ECollisionChannel
---@field EndTraceLocationOffset FVector
---@field VolumeMultiplier float
---@field PitchMultiplier float
---@field bFollow boolean
local UB1AnimNotify_FootSteps = {}



---@class UB1AnimNotify_GameObjectSound : UAnimNotify
---@field GameObjectStateType EB1GameObjectStateType
---@field ObjectSoundId FName
---@field CommandType EB1GameObjectSoundCommandType
---@field SocketType EB1GameObjectAttachSocketType
local UB1AnimNotify_GameObjectSound = {}



---@class UB1AnimNotify_LadderRightStep : UAnimNotify
local UB1AnimNotify_LadderRightStep = {}


---@class UB1AnimNotify_LoopEnd : UAnimNotify
local UB1AnimNotify_LoopEnd = {}


---@class UB1AnimNotify_LoopStart : UAnimNotify
local UB1AnimNotify_LoopStart = {}


---@class UB1AnimNotify_PauseRightGrab : UAnimNotifyState
local UB1AnimNotify_PauseRightGrab = {}


---@class UB1AnimNotify_PlayAnim : UAnimNotify
---@field GameObjectAnimId FName
---@field TargetGameObjectType EB1TargetObjectType
---@field AnimStartSection EB1LoopAnimSection
---@field CharacterAnimId FName
---@field bForcePlayAnim boolean
---@field Conditions TArray<FB1PlayAnimCondition>
local UB1AnimNotify_PlayAnim = {}



---@class UB1AnimNotify_PlayFXObject : UAnimNotify
---@field FXObject TSubclassOf<UB1FXObject>
---@field IsPlayerOnlyEffect boolean
local UB1AnimNotify_PlayFXObject = {}



---@class UB1AnimNotify_PlayObjectSlotFX : UAnimNotify
---@field Target EB1BaseObject
---@field SlotName FName
local UB1AnimNotify_PlayObjectSlotFX = {}



---@class UB1AnimNotify_PlayStaticMeshAnim : UAnimNotify
---@field Info FB1PlayStaticAnimInfo
local UB1AnimNotify_PlayStaticMeshAnim = {}



---@class UB1AnimNotify_Portrait : UAnimNotify
local UB1AnimNotify_Portrait = {}


---@class UB1AnimNotify_RunScript : UAnimNotify
local UB1AnimNotify_RunScript = {}


---@class UB1AnimPlayerComponent : UActorComponent
local UB1AnimPlayerComponent = {}


---@class UB1AnimToTexComponent : UActorComponent
---@field SkeletalMeshComponent UB1DummySkeletalMeshComponent
---@field Animation UAnimSequence
---@field ActiveAnimNotifyState TArray<FAnimNotifyEvent>
---@field ActiveAnimNotifyEventReference TArray<FAnimNotifyEventReference>
local UB1AnimToTexComponent = {}

function UB1AnimToTexComponent:StopAnimSquence() end
---@param InAnimName FName
---@param InStartTime float
function UB1AnimToTexComponent:PlayAnimSequence(InAnimName, InStartTime) end


---@class UB1AnimationManager : UB1ManagerBase
---@field CachedAnimAssets TArray<UAnimSequenceBase>
---@field HourlyCachedMotages TArray<FB1MontagesForCache>
---@field AnimToTexMap TMap<FName, UAnimToTextureDataAsset>
local UB1AnimationManager = {}



---@class UB1AppearanceComponent : UActorComponent
---@field NamedComponents TMap<FName, USceneComponent>
---@field AppearanceSetting FB1AppearanceSetting
---@field GarmentMeshComponents TMap<EB1GarmentType, FB1AppearanceComponents>
---@field GarmentMeshSectionTable TMap<FName, FB1GarmentComponentSection>
---@field AccessoryComponents TMap<FName, FB1AccessoryComponents>
---@field PrintedAccessoryComponents TArray<FB1AccessoryComponents>
---@field HairDitheringWeight float
---@field BodyMassCurve UCurveFloat
---@field AgingYoungerMorphCurve UCurveFloat
---@field AgingOlderMorphCurve UCurveFloat
---@field AgingMaterialCurve UCurveFloat
---@field AgingScatteringCurve UCurveFloat
---@field AppliedShoesType EB1ShoesType
---@field bAlwaysEnablePhysics boolean
---@field bUseEmissive boolean
---@field bPlayChangeCostumeFx boolean
---@field bImmediateChangeMeshVisible boolean
---@field FaceBakedMaterial UMaterialInstanceDynamic
---@field OriginGarmentDataMaps FB1GarmentOriginDataMaps
---@field OriginHairCardDataMaps FB1HairCardOriginDataMaps
---@field OriginEyeRefractiveDataMaps FB1EyeRefractiveOriginDataMaps
---@field MergedBodyMesh USkeletalMesh
---@field MergedHeadMesh USkeletalMesh
---@field MergedFaceHairMesh USkeletalMesh
---@field MergedGarmentMesh USkeletalMesh
---@field PendingRefreshCount int32
local UB1AppearanceComponent = {}

---@param PresetId FName
---@param bRefreshMesh boolean
---@return boolean
function UB1AppearanceComponent:ApplyPreset(PresetId, bRefreshMesh) end


---@class UB1AppearanceGalleryUploadUIHandler : UB1GalleryUploadUIHandler
local UB1AppearanceGalleryUploadUIHandler = {}


---@class UB1AssetUserData : UAssetUserData
local UB1AssetUserData = {}


---@class UB1AssetUserDataFunctionLibrary : UBlueprintFunctionLibrary
local UB1AssetUserDataFunctionLibrary = {}

---@param Object TScriptInterface<IInterface_AssetUserData>
---@param ClassType TSubclassOf<UAssetUserData>
function UB1AssetUserDataFunctionLibrary:RemoveAssetUserData(Object, ClassType) end
---@param Object TScriptInterface<IInterface_AssetUserData>
---@return TArray<UAssetUserData>
function UB1AssetUserDataFunctionLibrary:GetAssetUserDataArray(Object) end
---@param Object TScriptInterface<IInterface_AssetUserData>
---@param ClassType TSubclassOf<UAssetUserData>
---@return UAssetUserData
function UB1AssetUserDataFunctionLibrary:GetAssetUserData(Object, ClassType) end
---@param Object TScriptInterface<IInterface_AssetUserData>
---@param ClassType TSubclassOf<UAssetUserData>
---@return UAssetUserData
function UB1AssetUserDataFunctionLibrary:AddAssetUserData(Object, ClassType) end


---@class UB1AsyncLoadManager : UB1ManagerBase
local UB1AsyncLoadManager = {}


---@class UB1AttachMeshComponent : UActorComponent
---@field AttachMeshMap TMap<FName, ASkeletalMeshActor>
---@field CachedTemporaryMeshId FName
local UB1AttachMeshComponent = {}



---@class UB1AudioManager : UB1ManagerBase
---@field SoundCacheMap TMap<FString, UMetaSoundSource>
---@field PausableAudioComponents TArray<UAudioComponent>
---@field CachedLoadingAudioComponent UAudioComponent
local UB1AudioManager = {}



---@class UB1AudioModulationSubsystem : UWorldSubsystem
local UB1AudioModulationSubsystem = {}


---@class UB1AudioVolumeSubsystem : UAudioEngineSubsystem
local UB1AudioVolumeSubsystem = {}


---@class UB1AuxRenderingSubsystem : UWorldSubsystem
local UB1AuxRenderingSubsystem = {}


---@class UB1AuxScalabilitySubsystem : UWorldSubsystem
local UB1AuxScalabilitySubsystem = {}


---@class UB1AvoidanceManager : UB1ManagerBase
local UB1AvoidanceManager = {}


---@class UB1BGMAudioComponent : UObject
---@field PlayAudioComponent UAudioComponent
---@field DiscardAudioComponent UAudioComponent
local UB1BGMAudioComponent = {}

function UB1BGMAudioComponent:OnStopBGM() end


---@class UB1BGMAudioSubsystem : UGameInstanceSubsystem
---@field MasterBGMAudioComponent UAudioComponent
---@field BGMAudioComponentArray TArray<UB1BGMAudioComponent>
local UB1BGMAudioSubsystem = {}



---@class UB1BannerListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Button_Select UB1Button
local UB1BannerListEntryWidget = {}



---@class UB1BlockInputWidget : UB1UserWidgetBase
local UB1BlockInputWidget = {}


---@class UB1BodyTrackingUIHandler : UB1UIHandlerBase
---@field BodyTrackingWidget UB1BodyTrackingWidget
local UB1BodyTrackingUIHandler = {}

function UB1BodyTrackingUIHandler:Refresh() end


---@class UB1BodyTrackingWidget : UB1UserWidgetBase
---@field BW_Text_IPAddress UB1TextBlock
---@field BW_Button_IPAddress_Show UB1Button
---@field BW_Button_Close UB1Button
---@field BW_WidgetSwitcher UB1WidgetSwitcher
---@field BW_Button_BodyTracking_Enable UB1Button
---@field BW_Button_BodyTracking_Disable UB1Button
---@field BW_WBP_Button_Left UB1CommonButtonWidget
---@field BW_WBP_Button_Right UB1CommonButtonWidget
---@field BW_WBP_Button_OpenManualFolder UB1CommonButtonWidget
---@field BW_WBP_VerticalBox_SetupBox UB1VerticalBox
local UB1BodyTrackingWidget = {}

function UB1BodyTrackingWidget:OnClickedShowIPAddressButton() end
function UB1BodyTrackingWidget:OnClickedRightButton() end
function UB1BodyTrackingWidget:OnClickedOpenManualFolder() end
function UB1BodyTrackingWidget:OnClickedLeftButton() end
function UB1BodyTrackingWidget:OnClickedCloseButton() end
function UB1BodyTrackingWidget:OnClickedBodyTrackingEnableButton() end
function UB1BodyTrackingWidget:OnClickedBodyTrackingDisableButton() end


---@class UB1BonePostProcessAnimInstance : UB1AnimInstance
---@field BoneAdjustArray TArray<FB1BoneAdjust>
---@field AdditiveBones TArray<FB1AdditiveBoneData>
---@field AdditiveFaceBones TArray<FB1AdditiveBoneData>
---@field BodyFitAlpha_Hand_L float
---@field BodyFitAlpha_Hand_R float
local UB1BonePostProcessAnimInstance = {}



---@class UB1BubbleChatWidget : UUserWidget
---@field Text UTextBlock
local UB1BubbleChatWidget = {}



---@class UB1BubbleChatWidgetComponent : UWidgetComponent
---@field BubbleChatWidget UB1BubbleChatWidget
local UB1BubbleChatWidgetComponent = {}



---@class UB1BuffComponent : UActorComponent
---@field BuffMap TMap<FName, FB1Buff>
---@field BuffTagMap TMap<FName, int32>
local UB1BuffComponent = {}



---@class UB1Build3DPrinterCreatingObjectWidget : UB1UserWidgetBase
local UB1Build3DPrinterCreatingObjectWidget = {}


---@class UB1Build3DPrinterInputNameWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_NameArea UB1WidgetSwitcher
---@field BW_Button_Edit UB1Button
---@field BW_Button_Edit_1 UB1Button
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Num_Title UB1TextBlock
---@field BW_EditableTextBox_Title UB1EditableTextBox
---@field BW_Image_TitleError UB1Image
---@field BW_Text_Num_Content UB1TextBlock
---@field BW_MultiLineEditableTextBox_Content UB1MultiLineEditableTextBox
---@field BW_Image_ContentError UB1Image
---@field BW_Text_ObjectName UB1TextBlock
---@field BW_Text_ObjectContent UB1TextBlock
local UB1Build3DPrinterInputNameWidget = {}

---@param InText FText
function UB1Build3DPrinterInputNameWidget:BW_MultiLineEditableTextBox_Content_OnTextChanged(InText) end
---@param InText FText
function UB1Build3DPrinterInputNameWidget:BW_EditableTextBox_Title_OnTextChanged(InText) end


---@class UB1Build3DPrinterObjectAreaWidget : UB1UserWidgetBase
---@field BW_Image_Object UB1Image
---@field BW_CheckBox_Option_0 UB1CheckBox
---@field BW_CheckBox_Option_1 UB1CheckBox
---@field BW_CheckBox_Option_2 UB1CheckBox
---@field BW_CheckBox_Option_3 UB1CheckBox
---@field BW_CheckBox_Option_4 UB1CheckBox
---@field BW_CheckBox_Option_5 UB1CheckBox
---@field BW_Text_Otion_0 UB1TextBlock
---@field BW_Text_Otion_1 UB1TextBlock
---@field BW_Text_Otion_2 UB1TextBlock
---@field BW_Text_Otion_3 UB1TextBlock
---@field BW_Text_Otion_4 UB1TextBlock
---@field BW_Text_Otion_5 UB1TextBlock
---@field BW_CanvasPanel_Grid UB1CanvasPanel
---@field BW_WBP_3DPrinterSort UB1Build3DPrinterSortWidget
---@field BW_WidgetSwitcher_SelectEffect UB1WidgetSwitcher
---@field BW_Image_BG_Light_0 UB1Image
---@field BW_Image_BG_Light_1 UB1Image
---@field BW_Image_BG_Light_2 UB1Image
---@field BW_Image_BG_Light_3 UB1Image
---@field BW_Image_RedLine UB1Image
---@field BW_WBP_BuildCameraGuide UB1BuildCameraGuide
local UB1Build3DPrinterObjectAreaWidget = {}



---@class UB1Build3DPrinterRotateLocationModeWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_ModeTitle UB1WidgetSwitcher
---@field BW_ProgressBar_X UB1ProgressBar
---@field BW_ProgressBar_Y UB1ProgressBar
---@field BW_ProgressBar_Z UB1ProgressBar
---@field BW_Slider_X UB1Slider
---@field BW_Slider_Y UB1Slider
---@field BW_Slider_Z UB1Slider
---@field BW_Text_X UB1TextBlock
---@field BW_Text_Y UB1TextBlock
---@field BW_Text_Z UB1TextBlock
local UB1Build3DPrinterRotateLocationModeWidget = {}



---@class UB1Build3DPrinterSortWidget : UB1UserWidgetBase
---@field BW_CheckBox_Option_0 UB1CheckBox
---@field BW_CheckBox_Option_1 UB1CheckBox
---@field BW_CheckBox_Option_2 UB1CheckBox
---@field BW_CheckBox_Option_3 UB1CheckBox
---@field BW_Text_Option_0 UB1TextBlock
---@field BW_Text_Option_1 UB1TextBlock
---@field BW_Text_Option_2 UB1TextBlock
---@field BW_Text_Option_3 UB1TextBlock
---@field BW_Text_Option_4 UB1TextBlock
---@field BW_Text_Option_5 UB1TextBlock
---@field BW_Text_Option_6 UB1TextBlock
---@field BW_Text_Option_7 UB1TextBlock
local UB1Build3DPrinterSortWidget = {}



---@class UB1Build3DPrinterSymmetricModeWidget : UB1UserWidgetBase
---@field BW_Button_ManualModeToggle UB1Button
---@field BW_WidgetSwitcher_ManualMode UB1WidgetSwitcher
local UB1Build3DPrinterSymmetricModeWidget = {}



---@class UB1Build3DPrinterWidget : UB1UserWidgetBase
---@field BW_WBP_Common_Title UB1CommonTitleWidget
---@field BW_WidgetSwitcher_Area UB1WidgetSwitcher
---@field BW_WidgetSwitcher_Button UB1WidgetSwitcher
---@field BW_Button_Select UB1Button
---@field BW_WBP_Build_SymmetricMode_1 UB1Build3DPrinterSymmetricModeWidget
---@field BW_WBP_Build_ObjectArea UB1Build3DPrinterObjectAreaWidget
---@field BW_WidgetSwitcher_ContentTitle UB1WidgetSwitcher
---@field BW_WidgetSwitcher_Mode UB1WidgetSwitcher
---@field BW_WBP_Build_SymmetricMode UB1Build3DPrinterSymmetricModeWidget
---@field BW_WBP_Build_RotationMode UB1Build3DPrinterRotateLocationModeWidget
---@field BW_Image_Object UB1Image
---@field BW_InputName UB1Build3DPrinterInputNameWidget
---@field BW_Button_Begin UB1CommonButtonWidget
---@field BW_Button_Recreate UB1CommonButtonWidget
---@field BW_Button_Next01 UB1CommonButtonWidget
---@field BW_Button_Back UB1CommonButtonWidget
---@field BW_Button_Next02 UB1CommonButtonWidget
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_OK UB1CommonButtonWidget
---@field BW_WBP_Build_CreatingObject UB1Build3DPrinterCreatingObjectWidget
---@field BW_Button_OK_2 UB1CommonButtonWidget
---@field BP_CaptureStudio TSoftClassPtr<AB1ImageTo3DCaptureStudio>
---@field CaptureStudio AB1ImageTo3DCaptureStudio
---@field CaptureObject AActor
local UB1Build3DPrinterWidget = {}



---@class UB1BuildCameraGuide : UB1UserWidgetBase
---@field B1KeyImageMoveForward UB1KeyImage
---@field B1KeyImageMoveLeft UB1KeyImage
---@field B1KeyImageMoveRight UB1KeyImage
---@field B1KeyImageMoveBackward UB1KeyImage
---@field B1KeyImageMoveCameraUp UB1KeyImage
---@field B1KeyImageMoveCameraDown UB1KeyImage
local UB1BuildCameraGuide = {}



---@class UB1BuildCategoryButton : UB1UserWidgetBase
---@field Button_Category UB1Button
---@field Image_Icon UB1Image
---@field BW_Text_name UB1TextBlock
---@field FilterCategoryName FName
---@field IconTexture TSoftObjectPtr<UObject>
local UB1BuildCategoryButton = {}

---@param InSelected boolean
function UB1BuildCategoryButton:OnFilterCategorySelected(InSelected) end


---@class UB1BuildCategoryPanel : UB1UserWidgetBase
---@field BW_WidgetSwitcher_Category UB1WidgetSwitcher
---@field BW_Title_TextBlock UB1TextBlock
---@field BW_CanvasPanel_Button UB1CanvasPanel
---@field BW_Button_OpenClosed UB1Button
---@field WBP_CustomShapeButton_Studio UB1CustomShapeButton
local UB1BuildCategoryPanel = {}



---@class UB1BuildCategoryTooltipWidget : UB1TooltipWidgetBase
---@field BW_Iamge UB1Image
local UB1BuildCategoryTooltipWidget = {}



---@class UB1BuildCategoryWidget : UB1UserWidgetBase
---@field BW_Button_Category UB1Button
---@field BW_Image_Icon UB1Image
---@field FilterCategoryName FName
---@field IconTexture UTexture
---@field VisibleButton boolean
---@field WidgetIndex int32
local UB1BuildCategoryWidget = {}

---@param InSelected boolean
function UB1BuildCategoryWidget:OnCategoryWidgetSelected(InSelected) end


---@class UB1BuildCustomizeAIMaterialGroup : UB1UserWidgetBase
---@field B1TileView_AIMaterials UB1TileView
---@field AITextureButton UB1Button
---@field LocalTextureButton UB1Button
---@field BW_DeleteButton UB1Button
---@field TextureCategoryCombo UB1ComboBoxString
---@field BW_DeleteCompleteButton UB1Button
---@field BW_DeleteModeCancel UB1Button
---@field BW_WidgetSwitcher_Mode UB1WidgetSwitcher
local UB1BuildCustomizeAIMaterialGroup = {}



---@class UB1BuildCustomizeAIMaterialGroupEntry : UB1UserListEntryWidgetBase
---@field Image_Material UB1Image
---@field image_stroke UB1Image
---@field image_check UB1Image
---@field image_add UB1Image
---@field image_close UB1Image
---@field image_loading UB1Image
---@field Canvas_Panel_Delete UB1CanvasPanel
---@field Button_Click UB1Button
---@field BW_CheckBox_Delete UB1CheckBox
local UB1BuildCustomizeAIMaterialGroupEntry = {}



---@class UB1BuildCustomizeAIMaterialGroupObject : UObject
local UB1BuildCustomizeAIMaterialGroupObject = {}


---@class UB1BuildCustomizeAssembleCategoryData : UObject
local UB1BuildCustomizeAssembleCategoryData = {}


---@class UB1BuildCustomizeAssembleCategoryWidget : UB1UserListEntryWidgetBase
---@field Image_Icon UB1Image
---@field Button UB1Button
---@field AnimIdle UWidgetAnimation
---@field AnimHover UWidgetAnimation
---@field AnimSelected UWidgetAnimation
---@field Anim_Released UWidgetAnimation
local UB1BuildCustomizeAssembleCategoryWidget = {}



---@class UB1BuildCustomizeAssemblePartsEntryData : UObject
local UB1BuildCustomizeAssemblePartsEntryData = {}


---@class UB1BuildCustomizeAssemblePartsWidget : UB1UserListEntryWidgetBase
---@field Image_Icon UB1Image
---@field Button UB1Button
---@field AnimIdle UWidgetAnimation
---@field AnimHover UWidgetAnimation
---@field AnimSelected UWidgetAnimation
---@field AnimRelease UWidgetAnimation
local UB1BuildCustomizeAssemblePartsWidget = {}



---@class UB1BuildCustomizeAssembleWidget : UB1UserWidgetBase
---@field WBP_Common_Title UB1CommonTitleWidget
---@field WBP_Parts_ItemList UUserWidget
---@field B1Image_AssembledIcon UB1Image
---@field WBP_Arrow_200_left UUserWidget
---@field WBP_Arrow_200_right UUserWidget
---@field WBP_Funiture_CategoryList UUserWidget
---@field WBP_Build_Customize_Hierarchy UB1BuildCustomizePartsWidget
---@field WBP_Complete_Button UB1CommonButtonWidget
---@field AnimIn UWidgetAnimation
---@field AnimOut UWidgetAnimation
---@field CaptureStudio TSoftClassPtr<AB1BuildModeSceneCaptureStudio>
---@field RotateSpeed float
---@field CaptureStudioActor AB1BuildModeSceneCaptureStudio
---@field CaptureActor AB1GameObject
local UB1BuildCustomizeAssembleWidget = {}



---@class UB1BuildCustomizeCategoryBar : UB1UserWidgetBase
---@field Button_Wall UB1BuildCategoryButton
---@field Button_Bottom UB1BuildCategoryButton
---@field Button_Ceil UB1BuildCategoryButton
---@field Button_Window UB1BuildCategoryButton
---@field Button_Door UB1BuildCategoryButton
---@field Button_Stairs UB1BuildCategoryButton
---@field Button_Deco UB1BuildCategoryButton
---@field Button_Molding UB1BuildCategoryButton
---@field Button_Pillar UB1BuildCategoryButton
---@field Button_Roof UB1BuildCategoryButton
local UB1BuildCustomizeCategoryBar = {}



---@class UB1BuildCustomizeColorPalette : UB1UserWidgetBase
---@field WBP_ColorPalette_Slot_0 UB1BuildCustomizeColorPaletteEntry
---@field WBP_ColorPalette_Slot_1 UB1BuildCustomizeColorPaletteEntry
---@field WBP_ColorPalette_Slot_2 UB1BuildCustomizeColorPaletteEntry
---@field WBP_ColorPalette_Slot_3 UB1BuildCustomizeColorPaletteEntry
---@field WBP_ColorPalette_Slot_4 UB1BuildCustomizeColorPaletteEntry
---@field WBP_ColorPalette_Slot_5 UB1BuildCustomizeColorPaletteEntry
---@field WBP_ColorPalette_Slot_6 UB1BuildCustomizeColorPaletteEntry
---@field WBP_ColorPalette_Slot_7 UB1BuildCustomizeColorPaletteEntry
---@field WBP_ColorPalette_Slot_8 UB1BuildCustomizeColorPaletteEntry
---@field WBP_ColorPalette_Slot_9 UB1BuildCustomizeColorPaletteEntry
---@field BW_WidgetSwitcher_Mode UB1WidgetSwitcher
---@field BW_Button_DeleteMode UB1Button
---@field BW_Button_DeleteModeCancel UB1Button
---@field BW_Button_DeleteModeComplete UB1Button
local UB1BuildCustomizeColorPalette = {}



---@class UB1BuildCustomizeColorPaletteEntry : UB1UserWidgetBase
---@field Image_color UB1Image
---@field Image_plus UB1Image
---@field Button_Add UB1Button
---@field BW_CheckBox_Delete UB1CheckBox
local UB1BuildCustomizeColorPaletteEntry = {}

---@param InSelect boolean
function UB1BuildCustomizeColorPaletteEntry:SelectEntry(InSelect) end
---@return boolean
function UB1BuildCustomizeColorPaletteEntry:IsSelectedEntry() end


---@class UB1BuildCustomizeCommonSlider : UB1CharacterBodySliderWidget
---@field BW_EditableText_Value UB1EditableText
---@field BW_TextWidgetSwitcher UB1WidgetSwitcher
local UB1BuildCustomizeCommonSlider = {}

---@param InText FText
function UB1BuildCustomizeCommonSlider:EditableText_Value_OnTextChanged(InText) end


---@class UB1BuildCustomizeMaterialGroup : UB1UserWidgetBase
---@field B1TileView_Materials UB1TileView
---@field Text_name UB1TextBlock
local UB1BuildCustomizeMaterialGroup = {}



---@class UB1BuildCustomizeMaterialGroupEntry : UB1UserListEntryWidgetBase
---@field image_stroke UB1Image
---@field Image_Material UB1Image
---@field Image_PreMaterial UB1Image
---@field Button_Click UB1Button
---@field Anim_Idle UWidgetAnimation
---@field Anim_Selected UWidgetAnimation
local UB1BuildCustomizeMaterialGroupEntry = {}



---@class UB1BuildCustomizeMaterialGroupObject : UObject
local UB1BuildCustomizeMaterialGroupObject = {}


---@class UB1BuildCustomizeMenuWidget : UB1UserWidgetBase
---@field Button_Move UB1Button
---@field Button_TurnLeft UB1Button
---@field Button_TurnRight UB1Button
---@field Button_ChangeWallHeight UB1Button
---@field BW_Button_WallWhole UB1Button
---@field BW_Button_WallRailing UB1Button
---@field BW_Button_ShapeEdit UB1Button
---@field Button_Edit UB1Button
---@field Button_Copy UB1Button
---@field Button_Save_Room UB1Button
---@field Button_Save_Furniture UB1Button
---@field B1SizeBox_SaveBasicPreset UB1SizeBox
---@field Button_Save_BasicPreset UB1Button
---@field Button_Trash UB1Button
---@field Button_PermissionEdit UB1Button
---@field B1SizeBox_Lock UB1SizeBox
---@field B1SizeBox_PermissionEdit UB1SizeBox
---@field Button_Lock UB1Button
---@field BW_SizeBox_PaintLock UB1SizeBox
---@field BW_Button_PaintLock UB1Button
---@field BW_Image_Tail UB1Image
---@field B1HorizontalBox UB1HorizontalBox
---@field BW_Button_CharacterCustomize UB1CommonButtonWidget
---@field BW_Button_CharacterCustomizeEdit UB1CommonButtonWidget
---@field BW_Button_Bag UB1Button
---@field BW_Button_FacialAndPose UB1Button
---@field BW_Button_Complete UB1Button
---@field Anim_Open UWidgetAnimation
local UB1BuildCustomizeMenuWidget = {}



---@class UB1BuildCustomizeModeWidget : UB1UserWidgetBase
---@field WBP_Common_Title UB1CommonTitleWidget
---@field WBP_Build_Customize_v2 UB1BuildCustomizeWidget
---@field WBP_Build_Customize_v3 UB1BuildShowStructureWidget
---@field WBP_Common_TextInput UB1BuildCustomizeTextInputWidget
---@field Button_Complete UB1CommonButtonWidget
---@field WidgetSwitcher_GuideText UB1WidgetSwitcher
---@field BW_WBP_DayNight_Slider UB1DayNightSilderWidget
local UB1BuildCustomizeModeWidget = {}

function UB1BuildCustomizeModeWidget:HandlePostCommandAction() end
function UB1BuildCustomizeModeWidget:HandleCompleted() end
function UB1BuildCustomizeModeWidget:HandleClose() end


---@class UB1BuildCustomizePartsListEntry : UB1UserListEntryWidgetBase
---@field BW_Image_Selected UB1Image
---@field Text_Parts UB1TextBlock
---@field Button UB1Button
local UB1BuildCustomizePartsListEntry = {}

---@param InSelected boolean
function UB1BuildCustomizePartsListEntry:Select(InSelected) end
function UB1BuildCustomizePartsListEntry:Idle() end


---@class UB1BuildCustomizePartsListObject : UObject
local UB1BuildCustomizePartsListObject = {}


---@class UB1BuildCustomizePartsWidget : UB1UserWidgetBase
---@field Text_titleName UB1TextBlock
---@field TileView_PartList UB1TileView
local UB1BuildCustomizePartsWidget = {}



---@class UB1BuildCustomizePatternGroup : UB1UserWidgetBase
---@field B1TileView_Patterns UB1TileView
local UB1BuildCustomizePatternGroup = {}



---@class UB1BuildCustomizePatternGroupEntry : UB1UserListEntryWidgetBase
---@field Image_Pattern UB1Image
---@field image_stroke UB1Image
---@field image_check UB1Image
---@field image_add UB1Image
---@field image_close UB1Image
---@field image_loading UB1Image
---@field Canvas_Panel_Delete UB1CanvasPanel
---@field Button_Click UB1Button
local UB1BuildCustomizePatternGroupEntry = {}



---@class UB1BuildCustomizePatternGroupObject : UObject
local UB1BuildCustomizePatternGroupObject = {}


---@class UB1BuildCustomizeShapeEntry : UB1UserListEntryWidgetBase
---@field BW_Image_Thumbnail UB1Image
---@field BW_CheckIconPanel UB1CanvasPanel
---@field BW_Button UB1Button
---@field BW_Image_Galley UB1Image
local UB1BuildCustomizeShapeEntry = {}



---@class UB1BuildCustomizeShapeEntryData : UObject
---@field Icon TSoftObjectPtr<UObject>
local UB1BuildCustomizeShapeEntryData = {}



---@class UB1BuildCustomizeShapeListWidget : UB1UserWidgetBase
---@field BW_TileView_Shape UB1TileView
local UB1BuildCustomizeShapeListWidget = {}



---@class UB1BuildCustomizeTextInputWidget : UB1UserWidgetBase
local UB1BuildCustomizeTextInputWidget = {}


---@class UB1BuildCustomizeWidget : UB1UserWidgetBase
---@field CanvasPanel_TabType UB1CanvasPanel
---@field WBP_Build_Customize_Hierarchy UB1BuildCustomizePartsWidget
---@field WBP_ColorPicker UB1ColorPickerWidget
---@field WBP_ColorPalette UB1BuildCustomizeColorPalette
---@field B1HorizontalBox_ListGroup UB1HorizontalBox
---@field PreMaterialListGroup UB1BuildCustomizeMaterialGroup
---@field MaterialListGroup UB1BuildCustomizeMaterialGroup
---@field AIMaterialListGroup UB1BuildCustomizeAIMaterialGroup
---@field WBP_Common_Slider_build_customize_0 UB1BuildCustomizeCommonSlider
---@field WBP_Common_Slider_build_customize_1 UB1BuildCustomizeCommonSlider
---@field WBP_Common_Slider_build_customize_2 UB1BuildCustomizeCommonSlider
---@field WBP_Common_Slider_build_customize_3 UB1BuildCustomizeCommonSlider
---@field WBP_Common_Slider_build_customize_4 UB1BuildCustomizeCommonSlider
---@field WBP_Common_Slider_build_customize_5 UB1BuildCustomizeCommonSlider
---@field WBP_Common_Slider_build_customize_6 UB1BuildCustomizeCommonSlider
---@field WBP_Build_Button_Tool_FlipH UB1CustomizeButtonTool
---@field WBP_Build_Button_Tool_FlipV UB1CustomizeButtonTool
---@field WBP_StableDiffusion_Simple UB1SDRequestWidget
---@field WBP_StableDiffusion_Simple_Result UB1SDResultWidget
---@field BW_WidgetSwitcher_Tab UB1WidgetSwitcher
---@field BW_Button_Shape UB1Button
---@field BW_Button_ColorAndMaterial UB1Button
---@field BW_WBP_ShapeListGroup UB1BuildCustomizeShapeListWidget
---@field BW_WBP_Brush UB1BuildModeToolbarButton
---@field BW_WBP_BrushPlus UB1BuildModeToolbarButton
---@field BW_WBP_BrushMinus UB1BuildModeToolbarButton
---@field BW_WBP_BrushAll UB1BuildModeToolbarButton
---@field BW_WBP_Spuit UB1BuildModeToolbarButton
---@field BW_WBP_Init UB1BuildModeToolbarButton
---@field BW_Button_Complete UB1Button
---@field MaterialDefaultIcon TSoftObjectPtr<UObject>
---@field MeshDefaultIcon TSoftObjectPtr<UObject>
---@field SliderNames TMap<FName, FText>
---@field BW_WidgetSwitcher_3dShapeList UB1WidgetSwitcher
---@field BW_WBP_3DShapeListGroup UB1BuildCustomizeShapeListWidget
---@field BW_WidgetSwitcher_ShapeProperty UB1WidgetSwitcher
---@field BW_WBP_Slider_Size UB1BuildCustomizeCommonSlider
---@field BW_WBP_Slider_X UB1BuildCustomizeCommonSlider
---@field BW_WBP_Slider_Y UB1BuildCustomizeCommonSlider
---@field BW_WBP_Slider_Z UB1BuildCustomizeCommonSlider
local UB1BuildCustomizeWidget = {}

---@param InShow boolean
function UB1BuildCustomizeWidget:ShowSliderSection(InShow) end
---@param InShow boolean
function UB1BuildCustomizeWidget:ShowColorSection(InShow) end
function UB1BuildCustomizeWidget:OnLocalMaterialAddClicked() end
function UB1BuildCustomizeWidget:OnEndChangeSlider() end
function UB1BuildCustomizeWidget:OnEndChangeScaleSlider() end
function UB1BuildCustomizeWidget:OnEndChangeOffsetSlider() end
---@param InValue float
function UB1BuildCustomizeWidget:OnChangeSpecular(InValue) end
---@param InValue float
function UB1BuildCustomizeWidget:OnChangeScaleSlider(InValue) end
---@param InValue float
function UB1BuildCustomizeWidget:OnChangeRoughnessInt(InValue) end
---@param InValue float
function UB1BuildCustomizeWidget:OnChangePatternScale(InValue) end
---@param InValue float
function UB1BuildCustomizeWidget:OnChangePatternOffsetY(InValue) end
---@param InValue float
function UB1BuildCustomizeWidget:OnChangePatternOffsetX(InValue) end
---@param InValue float
function UB1BuildCustomizeWidget:OnChangeOpacity(InValue) end
---@param InValue float
function UB1BuildCustomizeWidget:OnChangeOffsetSlider(InValue) end
---@param InValue float
function UB1BuildCustomizeWidget:OnChangeMetallic(InValue) end
---@param InValue float
function UB1BuildCustomizeWidget:OnChangeEmisMulti(InValue) end
function UB1BuildCustomizeWidget:OnBeginChangeSlider() end
function UB1BuildCustomizeWidget:OnBeginChangeScaleSlider() end
function UB1BuildCustomizeWidget:OnBeginChangeOffsetSlider() end
function UB1BuildCustomizeWidget:OnAIMaterialDeleteModeCompleteClicked() end
function UB1BuildCustomizeWidget:OnAIMaterialDeleteModeClicked() end
function UB1BuildCustomizeWidget:OnAIMaterialDeleteModeCancelClicked() end
function UB1BuildCustomizeWidget:OnAIMaterialAddClicked() end
function UB1BuildCustomizeWidget:HandleSelectShape() end
function UB1BuildCustomizeWidget:HandleSelectPrintedShape() end
function UB1BuildCustomizeWidget:HandleSelectMaterial() end
function UB1BuildCustomizeWidget:HandleSelectCustomizeType() end
---@param IsEnter boolean
function UB1BuildCustomizeWidget:HandleEnterCustomizeMaterial(IsEnter) end
function UB1BuildCustomizeWidget:HandleClickSpuit() end
function UB1BuildCustomizeWidget:HandleClickComplete() end
function UB1BuildCustomizeWidget:HandleClickBrushPlus() end
function UB1BuildCustomizeWidget:HandleClickBrushMinus() end
function UB1BuildCustomizeWidget:HandleClickBrushAll() end
function UB1BuildCustomizeWidget:HandleClickBrush() end
function UB1BuildCustomizeWidget:HandleChangedSelectMode() end


---@class UB1BuildDefaultPresetAssetBase : UB1DataAssetBase
---@field MetaData FB1GalleryMetaData
---@field ThumbnailCompressedData TArray<uint8>
---@field DisplayNameTextId FString
---@field DescriptionTextId FString
---@field ThumbnailImage TSoftObjectPtr<UTexture2D>
local UB1BuildDefaultPresetAssetBase = {}



---@class UB1BuildGalleryUploadUIHandler : UB1GalleryUploadUIHandler
local UB1BuildGalleryUploadUIHandler = {}


---@class UB1BuildGizmoHideWidget : UB1UserWidgetBase
---@field BW_Hide UB1Button
---@field BW_Image_Tail UB1Image
---@field Anim_Open UWidgetAnimation
local UB1BuildGizmoHideWidget = {}



---@class UB1BuildKeyGuideWidget : UB1UserWidgetBase
---@field GuideCanvas UB1CanvasPanel
---@field WBP_Common_Currency UB1CurrencyWidget
---@field WidgetSwitcher_Type UB1WidgetSwitcher
---@field B1HorizontalBox_Alt UWidget
---@field B1HorizontalBox_Shift UWidget
---@field B1HorizontalBox_Rotate UWidget
---@field B1HorizontalBox_RotateSide UWidget
---@field B1HorizontalBox_Esc UWidget
---@field B1HorizontalBox_Del UWidget
---@field B1HorizontalBox_Desc UWidget
---@field B1TextBlock_Del UB1TextBlock
---@field B1TextBlock_Desc UB1TextBlock
---@field B1HorizontalBox_WallDesc UWidget
---@field B1TextBlock_WallDesc UB1TextBlock
---@field B1KeyImageLeftMicroRotation UB1KeyImage
---@field B1KeyImageRightMicroRotation UB1KeyImage
local UB1BuildKeyGuideWidget = {}



---@class UB1BuildModeDataAsset : UB1DataAssetBase
---@field BoxMesh TSoftObjectPtr<UStaticMesh>
---@field BoxMaterial TSoftObjectPtr<UMaterialInterface>
---@field BoxGuageMaterial TSoftObjectPtr<UMaterialInterface>
---@field ArrowMesh TSoftObjectPtr<UStaticMesh>
---@field BuildAreaMesh TSoftObjectPtr<UStaticMesh>
---@field BuildStartPointMesh TSoftObjectPtr<UStaticMesh>
---@field BuildStartPointMaterial TSoftObjectPtr<UMaterialInterface>
---@field BuildStartPointScale FVector
---@field BuildFinishFXClass TSubclassOf<UB1FXNiagaraObject>
---@field SlotDisableMesh TSoftObjectPtr<UStaticMesh>
---@field BuildAlpha float
---@field BuildEnableColor FLinearColor
---@field BuildDisableColor FLinearColor
---@field BuildWallOverlappedObjectColor FLinearColor
---@field GizmoBP TSoftClassPtr<AB1GizmoActor>
---@field WallCornerActorBP TSoftClassPtr<AB1WallCornerActor>
---@field ConstructingWallsBP TSoftClassPtr<AB1ConstructingWalls>
---@field DraggingWallBP TSoftClassPtr<AB1DraggingWall>
---@field ShapingRoomBP TSoftClassPtr<AB1ShapingRoom>
---@field MovingRoomBP TSoftClassPtr<AB1MovingRoom>
---@field MovingHouseBP TSoftClassPtr<AB1MovingHouse>
---@field MovingSiteAreaBP TSoftClassPtr<AB1MovingSiteArea>
---@field MovingFenceBP TSoftClassPtr<AB1MovingFence>
---@field DraggingFenceBP TSoftClassPtr<AB1DraggingFence>
---@field TransformStairsBP TSoftClassPtr<AB1TransformStairs>
---@field RoofExtendBP TSoftClassPtr<AB1RoofExtend>
---@field PillarHeightBP TSoftClassPtr<AB1PillarHeight>
---@field FloorHeightBP TSoftClassPtr<AB1ChangingFloorHeight>
---@field WallEntries TArray<FB1WallEntry>
---@field WallElevatingOutlineColor FLinearColor
---@field WallElevatingOutlineThickness float
---@field WallElevatingColor FLinearColor
---@field WallElevatingThickness float
---@field WallElevatingDraggingUnit float
---@field DefaulHalfWallCover FName
---@field DefaulHalfWallRailing FName
---@field DefaulFoundationMold FName
---@field PoolEntry FB1PoolEntry
---@field RequireSpaceOffsetRadius float
---@field RoofMaxHeight float
---@field RoofMinHeight float
---@field RoofMaxEavesHeight float
---@field AllowedFloorDistance float
---@field BuildAreaArrowDistance float
---@field ObjectRotationInputUnitMap TMap<EB1RotationInputType, float>
---@field RoomPresetData TMap<FName, FB1BuildModeRoomPreset>
---@field PlatformPresetData TMap<FName, FB1BuildModeRoomPreset>
---@field DefaultRoomPresetData TArray<TSoftObjectPtr<UB1BuildDefaultPresetAssetBase>>
---@field FreeLocationSiteIds TArray<FName>
---@field NonPlaceableSiteIds TArray<FName>
---@field Shape3DScaleSlider TMap<FName, float>
---@field Shape3DOffsetSlider TMap<FName, float>
---@field SystemObjectFilters TArray<FName>
---@field BedObjectFilters TArray<FName>
---@field ToiletObjectFilters TArray<FName>
---@field CurtainObjectFilters TArray<FName>
---@field CanNotCustomizeShapeObjectFilters TArray<FName>
---@field BuildWorldAlertOpeningTimer float
---@field BuildWorldAlertClosingTimer float
---@field MyTextureDefaultRoughness double
---@field MyTextureDefaultMetalic double
local UB1BuildModeDataAsset = {}



---@class UB1BuildModeStylingButton : UB1UserWidgetBase
---@field Button UB1Button
local UB1BuildModeStylingButton = {}

---@param InOn boolean
function UB1BuildModeStylingButton:On(InOn) end


---@class UB1BuildModeTextDataAsset : UB1DataAssetBase
---@field BuildMode_KeyGuide_Desc_Disable_ColorId FName
---@field BuildMode_KeyGuide_FurnitureErrorTypeMap TMap<EB1FurnitureBuildErrorType, FString>
---@field BuildMode_Wall_KeyGuide_OutOfSite FString
---@field BuildMode_Wall_KeyGuide_Overlapped FString
---@field BuildMode_Wall_KeyGuide_CantBuildBox FString
---@field BuildMode_Wall_KeyGuide_CantMerge FString
---@field BuildMode_Wall_KeyGuide_FloorLevelLimit FString
---@field BuildMode_CanNotEdit_Tooltip FString
---@field BuildMode_CanNotMove_Tooltip FString
---@field BuildMode_CanNotDelete_Tooltip FString
---@field BuildMode_CanNotCopy_Tooltip FString
---@field BuildMode_CanNotSave_Tooltip FString
---@field BuildMode_DeleteFail_Message FString
---@field BuildMode_BuyObject_Fail_NotEnoughGold_Message FString
---@field BuildMode_PutInventoryByCustomize_Message FString
---@field BuildMode_PresetInstallFail_AlreadyInstalled FString
---@field BuildMode_NeedScreenShotForGalleryItem FString
---@field BuildMode_NeedNameForGalleryItem FString
---@field BuildMode_FailToSaveGalleryRoom FString
---@field BuildMode_KeyGuide_SelectionIsNotRoom FString
---@field BuildMode_KeyGuide_InValidSelectionAddOrDel FString
---@field BuildMode_NoticeNvidiaDriver FString
---@field BuildMode_NoticeTimeout FString
---@field BuildMode_NotEnoughSiteSize FString
---@field BuildMode_RestrictPresetSite FString
---@field BuildMode_SaveRestrictObjectIncluded FString
---@field BuildMode_ExceedSiteLevelLimit FString
---@field BuildMode_NeedSameTargetForSpuit FString
---@field BuildMode_HammerAll_Popup_Id FName
---@field BuildMode_Preset_Popup_Id FName
---@field BuildMode_Preset_List_Title FString
---@field BuildMode_MyRooms_List_Title FString
---@field CanBuyTextColor FLinearColor
---@field CanNotBuyTextColor FLinearColor
---@field BuildMode_SavePresetWidgetDesc_Site FString
---@field BuildMode_SavePresetWidgetDesc_Room FString
---@field BuildMode_SavePresetWidgetDesc_Object FString
---@field BuildMode_SavePresetWidgetSaved_Site FString
---@field BuildMode_SavePresetWidgetSaved_Room FString
---@field BuildMode_SavePresetWidgetSaved_Object FString
---@field EditPublicSite_DimmedOpacity float
local UB1BuildModeTextDataAsset = {}



---@class UB1BuildModeToolbarButton : UB1UserWidgetBase
---@field BW_Button UB1Button
---@field Image_Icon UB1Image
---@field IconBrush FSlateBrush
local UB1BuildModeToolbarButton = {}

---@param InSelected boolean
function UB1BuildModeToolbarButton:OnSelectButton(InSelected) end
---@param InEnable boolean
function UB1BuildModeToolbarButton:OnEnableButton(InEnable) end
---@return boolean
function UB1BuildModeToolbarButton:IsSelected() end


---@class UB1BuildModeToolbarPanel : UB1UserWidgetBase
---@field WBP_Build_Toolbar UB1BuildModeToolbarWidget
---@field WBP_Build_KeyGuide UB1BuildKeyGuideWidget
local UB1BuildModeToolbarPanel = {}



---@class UB1BuildModeToolbarWidget : UB1UserWidgetBase
---@field WBP_Build_StylingMode_Toggle UB1BuildModeStylingButton
---@field WBP_Undo UB1BuildModeToolbarButton
---@field WBP_Redo UB1BuildModeToolbarButton
---@field WBP_Save_Site UB1BuildModeToolbarButton
---@field WBP_UpperFloor UB1BuildModeToolbarButton
---@field WBP_DownFloor UB1BuildModeToolbarButton
---@field WBP_FloorPlan UB1BuildModeToolbarButton
---@field WBP_HUD_WireframeButton_v2 UB1ToggleWireframeWidget
---@field WBP_Select UB1BuildModeToolbarButton
---@field BW_WBP_SelectAll UB1BuildModeToolbarButton
---@field WBP_Hammer UB1BuildModeToolbarButton
---@field WBP_HammerAll UB1BuildModeToolbarButton
---@field WBP_Trash UB1BuildModeToolbarButton
---@field WBP_Reset UB1BuildModeToolbarButton
---@field BW_WBP_Info UB1BuildModeToolbarButton
---@field BW_WBP_MoveHouse UB1BuildModeToolbarButton
---@field BW_WBP_MoveLand UB1BuildModeToolbarButton
---@field BW_WBP_Bug UB1BuildModeToolbarButton
---@field WidgetSwitcher_Grid UB1WidgetSwitcher
---@field WBP_GridOn UB1BuildModeToolbarButton
---@field WBP_GridOff UB1BuildModeToolbarButton
---@field WidgetSwitcher_Snap UB1WidgetSwitcher
---@field WBP_SnapOn UB1BuildModeToolbarButton
---@field WBP_SnapOff UB1BuildModeToolbarButton
---@field BW_WidgetSwitcher_Studio UB1WidgetSwitcher
---@field BW_CutSceneStudio_HorizontalBox UB1HorizontalBox
---@field BW_Button_PhotoMode UB1CommonButtonWidget
---@field BW_Button_CutScenePreview UB1CommonButtonWidget
---@field BW_WBP_SaveAlert UB1UserWidgetBase
local UB1BuildModeToolbarWidget = {}

---@param IsEnter boolean
function UB1BuildModeToolbarWidget:HandleEnterCustomizeMode(IsEnter) end
function UB1BuildModeToolbarWidget:HandleCommandAction() end
---@param InIndex int32
function UB1BuildModeToolbarWidget:HandleClickWireMode(InIndex) end
function UB1BuildModeToolbarWidget:HandleClickUpperFloor() end
function UB1BuildModeToolbarWidget:HandleClickUndo() end
function UB1BuildModeToolbarWidget:HandleClickSiteReset() end
function UB1BuildModeToolbarWidget:HandleClickSiteInfo() end
function UB1BuildModeToolbarWidget:HandleClickSingleBrush() end
function UB1BuildModeToolbarWidget:HandleClickSelectMode() end
function UB1BuildModeToolbarWidget:HandleClickSelectAllMode() end
function UB1BuildModeToolbarWidget:HandleClickSaveSite() end
function UB1BuildModeToolbarWidget:HandleClickRedo() end
function UB1BuildModeToolbarWidget:HandleClickOpenBuildBugPopup() end
function UB1BuildModeToolbarWidget:HandleClickMultiBrush() end
function UB1BuildModeToolbarWidget:HandleClickMoveStie() end
function UB1BuildModeToolbarWidget:HandleClickMoveHouse() end
function UB1BuildModeToolbarWidget:HandleClickHammerMode() end
function UB1BuildModeToolbarWidget:HandleClickHammerAllMode() end
function UB1BuildModeToolbarWidget:HandleClickEnterStylizeMode() end
function UB1BuildModeToolbarWidget:HandleClickDownFloor() end
function UB1BuildModeToolbarWidget:HandleClickBrushDel() end
function UB1BuildModeToolbarWidget:HandleClickBrushAdd() end
function UB1BuildModeToolbarWidget:HandleChangedSelectMode() end
---@param InIsEnter boolean
function UB1BuildModeToolbarWidget:EnterBrushMode(InIsEnter) end


---@class UB1BuildModeWidget : UB1UserWidgetBase
---@field WBP_Common_Title UB1CommonTitleWidget
---@field WBP_Build_FurnitureList UB1ObjectListWidget
---@field WBP_Build_Menu_v2 UB1BuildCustomizeMenuWidget
---@field WBP_Build_Menu_v3 UB1BuildShowStructureWidget
---@field WBP_Build_Gizmo_Hide UB1BuildGizmoHideWidget
---@field WBP_Build_FunitureShapeCustomize UB1BuildCustomizeAssembleWidget
---@field WBP_Build_PresetSavePopup UB1BuildSavePresetWidget
---@field Text_Guide UB1TextBlock
---@field WBP_Build_KeyGuide UB1BuildKeyGuideWidget
---@field BW_WBP_MotionList UB1PhotoModeMotionListWidget
---@field BW_WBP_CharacterSelectPopup UB1StudioCharacterSelectWidget
---@field BW_WBP_DayNight_Slider UB1DayNightSilderWidget
local UB1BuildModeWidget = {}

function UB1BuildModeWidget:OnClose() end


---@class UB1BuildObjestStateInfoEntryVM : UObject
local UB1BuildObjestStateInfoEntryVM = {}


---@class UB1BuildObjestStateInfoEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Content UB1TextBlock
local UB1BuildObjestStateInfoEntryWidget = {}



---@class UB1BuildPresetListEntry : UB1UserListEntryWidgetBase
---@field Image_Preset UB1Image
---@field Image_Icon_Gold UB1Image
---@field BW_Text_Gold UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Button_Click UB1Button
---@field BW_Button_Delete UB1Button
---@field BW_CheckBox_Delete UB1CheckBox
---@field BW_Button_Gallery UB1Button
---@field BW_WidgetSwitcher_Loading UB1WidgetSwitcher
---@field BW_CanvasPanel_Download UB1CanvasPanel
---@field BW_CanvasPanel_LoadingThumbnail UB1CanvasPanel
---@field PresetTableId FName
---@field AssetTable UDataTable
---@field EntryData UB1BuildPresetListEntryData
local UB1BuildPresetListEntry = {}



---@class UB1BuildPresetListEntryData : UObject
---@field PresetTableId FName
---@field Image_Preset TSoftObjectPtr<UObject>
---@field AssetTable UDataTable
local UB1BuildPresetListEntryData = {}



---@class UB1BuildPresetTooltipWidget : UB1TooltipWidgetBase
---@field Image_Preset UB1Image
---@field Text_Title UB1TextBlock
---@field Text_Desc UB1TextBlock
---@field OverlayInfoPreset UB1Overlay
---@field Image_BG_1 UB1Image
---@field B1HorizontalBox_0 UB1HorizontalBox
---@field Text_BedNum UB1TextBlock
---@field Text_ToiletNum UB1TextBlock
---@field Image_Icon_Gold UB1Image
---@field Text_Gold UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_HorizontalBox_NickName UB1HorizontalBox
---@field BW_Text_NickName UB1TextBlock
---@field BW_Button_Gallery UB1Button
local UB1BuildPresetTooltipWidget = {}



---@class UB1BuildProgressComponent : UActorComponent
---@field MeshOutLineSceneComp USceneComponent
---@field MeshOutLineComponent UStaticMeshComponent
---@field GuageSceneComponent USceneComponent
---@field GuageComponent UStaticMeshComponent
---@field ArrowComponent UStaticMeshComponent
---@field BuildAreaMeshComponentList TArray<UStaticMeshComponent>
---@field BuildAreaBoxComponentList TArray<UBoxComponent>
---@field BuildProgressIconUserWidget UB1BuildProgressIconWidget
local UB1BuildProgressComponent = {}



---@class UB1BuildProgressIconWidget : UB1UserWidgetBase
---@field Icon_Canvas UB1CanvasPanel
---@field WBP_Common_CircularGauge UB1GaugeWidget
---@field Button_Cancel UB1Button
local UB1BuildProgressIconWidget = {}

function UB1BuildProgressIconWidget:OnClickedCancelButton() end


---@class UB1BuildRegisterRoomWidget : UB1UserWidgetBase
---@field WBP_Common_Title UB1CommonTitleWidget
---@field WBP_Complete_Button UB1CommonButtonWidget
---@field B1Image_ScreenShot UB1Image
---@field BW_Button_Indicator0 UB1Button
---@field BW_Button_Indicator1 UB1Button
---@field BW_Button_Indicator2 UB1Button
---@field BW_Button_Indicator3 UB1Button
---@field BW_Button_Indicator4 UB1Button
---@field BW_Button_Indicator5 UB1Button
---@field WBP_WireFrameButton UB1ToggleWireframeWidget
---@field BW_Button_ShotLeft UB1Button
---@field BW_Button_Shot UB1Button
---@field BW_Button_ShotRight UB1Button
---@field BW_Button_DeleteShot UB1Button
---@field B1EditableText_ItemName UB1EditableText
---@field B1ComboBoxString_SubCategory UB1ComboBoxString
---@field Image_Icon_Gold UB1Image
---@field B1Text_Price UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
---@field B1Text_Size UB1TextBlock
---@field B1EditableText_Tags UB1EditableText
---@field B1EditableText_RoomDesc UB1MultiLineEditableText
---@field AnimIn UWidgetAnimation
---@field AnimOut UWidgetAnimation
---@field CaptureCamBP TSoftClassPtr<AB1RoomCaptureCamera>
---@field CaptureObject AB1RoomCaptureCamera
---@field ShotMaterial UMaterial
local UB1BuildRegisterRoomWidget = {}

function UB1BuildRegisterRoomWidget:HandleComplete() end
---@param InModeIndex int32
function UB1BuildRegisterRoomWidget:HandleClickWireMode(InModeIndex) end
function UB1BuildRegisterRoomWidget:HandleClickShotRight() end
function UB1BuildRegisterRoomWidget:HandleClickShotLeft() end
---@param InShotIndex int32
function UB1BuildRegisterRoomWidget:HandleClickShotIndicator(InShotIndex) end
function UB1BuildRegisterRoomWidget:HandleClickShotDelete() end
function UB1BuildRegisterRoomWidget:HandleClickShot() end
function UB1BuildRegisterRoomWidget:HandleChangeSubCategory() end
function UB1BuildRegisterRoomWidget:HandleBackToMode() end


---@class UB1BuildSavePresetInfoWidget : UB1UserWidgetBase
---@field BW_HorizontalBox_SiteInfo UB1HorizontalBox
---@field BW_ComboBoxKey_BedNum UB1ComboBoxKey
---@field BW_ComboBoxKey_ToiletNum UB1ComboBoxKey
---@field BW_HorizontalBox_Type UB1HorizontalBox
---@field BW_ComboBoxKey_Type UB1ComboBoxKey
---@field BW_HorizontalBox_Category UB1HorizontalBox
---@field BW_Text_Category UB1TextBlock
---@field BW_HorizontalBox_Price UB1HorizontalBox
---@field WBP_Common_Currency UB1CurrencyWidget
---@field BW_HorizontalBox_Size UB1HorizontalBox
---@field BW_HorizontalBox_Height UB1HorizontalBox
---@field BW_Text_Size UB1TextBlock
---@field BW_Text_Height UB1TextBlock
---@field BW_Text_Bed UB1TextBlock
---@field BW_Text_Toilet UB1TextBlock
local UB1BuildSavePresetInfoWidget = {}

---@param CreatedWidget UUserWidget
---@param ItemName FName
function UB1BuildSavePresetInfoWidget:OnGenerateItemWidget(CreatedWidget, ItemName) end
---@param CreatedWidget UUserWidget
---@param ItemName FName
function UB1BuildSavePresetInfoWidget:OnGenerateContentWidget(CreatedWidget, ItemName) end
---@param InName FName
---@param InSelectionType ESelectInfo::Type
function UB1BuildSavePresetInfoWidget:OnComboBoxKeyTypeSelectionChanged(InName, InSelectionType) end


---@class UB1BuildSavePresetWidget : UB1UserWidgetBase
---@field BW_Button_GalleryUpload UB1CommonButtonWidget
---@field BW_Button_Save UB1CommonButtonWidget
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Image_ScreenShot UB1Image
---@field B1GridPanel_0 UB1GridPanel
---@field BW_Button_Wall UB1ToggleWireframeWidget
---@field BW_EditableTextBox_Title UB1EditableTextBox
---@field BW_Text_Num_Title UB1TextBlock
---@field BW_MultiLineEditableTextBox_Content UB1MultiLineEditableTextBox
---@field BW_Text_Num_Content UB1TextBlock
---@field BW_WBP_Build_PresetSavePopup_Info UB1BuildSavePresetInfoWidget
---@field Text_Preset UB1TextBlock
---@field Anim_Open UWidgetAnimation
---@field CaptureCamBP TSoftClassPtr<AB1RoomCaptureCamera>
---@field BW_SizeBox_Stairs UB1SizeBox
---@field BW_WidgetSwitcher_DownStairs UB1WidgetSwitcher
---@field BW_Button_DownStairs UB1Button
---@field BW_WidgetSwitcher_UpStairs UB1WidgetSwitcher
---@field BW_Button_UpStairs UB1Button
---@field BW_Image_TitleError UB1Image
---@field BW_Image_ContentError UB1Image
---@field Text_Required_2 UB1TextBlock
---@field BW_Image_ThumbnailError UB1Image
---@field BW_TextBlock_ThumbnailError UB1TextBlock
---@field CaptureObject AB1RoomCaptureCamera
---@field ShotMaterial UMaterial
local UB1BuildSavePresetWidget = {}

---@param InText FText
function UB1BuildSavePresetWidget:HandleTitleTextChanged(InText) end
---@param InText FText
function UB1BuildSavePresetWidget:HandleContentTextChanged(InText) end
function UB1BuildSavePresetWidget:HandleComplete() end
---@param InModeIndex int32
function UB1BuildSavePresetWidget:HandleClickWireMode(InModeIndex) end
function UB1BuildSavePresetWidget:HandleBackToMode() end


---@class UB1BuildSearchBox : UB1UserWidgetBase
---@field BW_Image_BG_Selected UB1Image
---@field BW_EditableTextBox_SearchBox UB1EditableTextBox
---@field BW_Button_Search UB1Button
---@field BW_Button_Erase UB1Button
---@field BW_VerticalBox_AutoComplete UB1VerticalBox
---@field BW_Text_Category UB1TextBlock
---@field BW_ListView_Category UB1ListView
---@field BW_Image_Line UB1Image
---@field BW_ListView_Name UB1ListView
local UB1BuildSearchBox = {}

---@param InText FText
---@param InCommitMethod ETextCommit::Type
function UB1BuildSearchBox:HandleOnTextCommitted(InText, InCommitMethod) end
---@param InText FText
function UB1BuildSearchBox:HandleOnSearchBoxTextChanged(InText) end


---@class UB1BuildSearchBoxCategoryData : UObject
---@field Mode FText
---@field Category FText
---@field MiddleCategory FText
---@field SubCategory FText
---@field SearchCategory FName
local UB1BuildSearchBoxCategoryData = {}



---@class UB1BuildSearchBoxCategoryEntry : UB1UserListEntryWidgetBase
---@field BW_Button_Category UB1Button
---@field BW_RichText_Catergory UB1RichTextBlock
---@field BW_RichText_Catergory_Main UB1RichTextBlock
---@field BW_Image_ArrowMiddle UB1Image
---@field BW_RichText_Catergory_Middle UB1RichTextBlock
---@field BW_Image_ArrowSub UB1Image
---@field BW_RichText_Catergory_Sub UB1RichTextBlock
---@field SearchCategory FName
local UB1BuildSearchBoxCategoryEntry = {}



---@class UB1BuildSearchBoxNameData : UObject
---@field NameTitle FText
---@field SearchKeyword FString
---@field NameCategory FName
local UB1BuildSearchBoxNameData = {}



---@class UB1BuildSearchBoxNameEntry : UB1UserListEntryWidgetBase
---@field BW_Button_Name UB1Button
---@field BW_RichText_Title UB1RichTextBlock
local UB1BuildSearchBoxNameEntry = {}



---@class UB1BuildShowStructureWidget : UB1UserWidgetBase
---@field BW_Image_Tail UB1Image
---@field BW_Button_Revert UB1Button
---@field BW_WidgetSwitcher_Guide UB1WidgetSwitcher
---@field Anim_Open UWidgetAnimation
local UB1BuildShowStructureWidget = {}



---@class UB1BuildSkillInfoEntryVM : UObject
local UB1BuildSkillInfoEntryVM = {}


---@class UB1BuildSkillInfoEntryWidget : UB1UserListEntryWidgetBase
---@field BW_WidgetSwitcher_Lock UB1WidgetSwitcher
---@field BW_Text_Lock UB1TextBlock
local UB1BuildSkillInfoEntryWidget = {}



---@class UB1BuildWeatheringInfoEntryVM : UObject
local UB1BuildWeatheringInfoEntryVM = {}


---@class UB1BuildWeatheringInfoEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_Info UB1TextBlock
local UB1BuildWeatheringInfoEntryWidget = {}



---@class UB1CameraCollisionComponent : UActorComponent
---@field CameraCollisionBox UBoxComponent
---@field CameraCollisionMesh UStaticMeshComponent
---@field UpdateTick float
---@field MaxAlpha float
---@field CameraManager AB1PlayerCameraManager2
---@field OverlappingMap TMap<UPrimitiveComponent, FB1CollisionInfo>
---@field DeltaTick float
---@field CollisionDistance float
---@field eCameraModeType EB1CameraModeType
---@field RenderStateDirtyComps TSet<UPrimitiveComponent>
---@field PrevCollisionMeshScale FVector
local UB1CameraCollisionComponent = {}

---@param OverlappedComp UPrimitiveComponent
---@param Other AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UB1CameraCollisionComponent:OnMeshComponentEndOverlap(OverlappedComp, Other, OtherComp, OtherBodyIndex) end
---@param OverlappedComp UPrimitiveComponent
---@param Other AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UB1CameraCollisionComponent:OnMeshComponentBeginOverlap(OverlappedComp, Other, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end
---@param OverlappedComp UPrimitiveComponent
---@param Other AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UB1CameraCollisionComponent:OnBoxComponentEndOverlap(OverlappedComp, Other, OtherComp, OtherBodyIndex) end
---@param OverlappedComp UPrimitiveComponent
---@param Other AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UB1CameraCollisionComponent:OnBoxComponentBeginOverlap(OverlappedComp, Other, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class UB1CameraCollisionUserData : UAssetUserData
---@field MaxAlpha float
local UB1CameraCollisionUserData = {}



---@class UB1CameraMode : UObject
---@field PlayerCamera AB1PlayerCameraManager2
---@field TransitionInTime float
---@field TransitionParams FViewTargetTransitionParams
---@field CollisionEnable boolean
---@field bCollisionDynamicDistance boolean
---@field CollisionMaxDistance float
---@field CollisionScale FVector
---@field CollisionDistanceOffset float
---@field CollisionTags TArray<FName>
---@field FOV float
---@field CameraLagMaxTimeStep float
---@field bUseCineCam boolean
---@field bUseCineCamSettings boolean
---@field bOverrideFilmback boolean
---@field CineCam_FilmbackOverride FCameraFilmbackSettings
---@field CineCam_CurrentFocalLength float
---@field CineCam_CurrentAperture float
---@field CineCam_FocusDistanceAdjustment float
---@field CineCam_DisplayOnly_FOV float
---@field BlockingActors TArray<AActor>
---@field bUseCustomFocusDistance boolean
---@field bOverrideViewPitchMinAndMax boolean
---@field ViewPitchMinOverride float
---@field ViewPitchMaxOverride float
---@field bShowFov boolean
local UB1CameraMode = {}

function UB1CameraMode:ResetToDefaultSettings() end
---@param ViewTarget AActor
---@param ViewToWorld FTransform
---@return float
function UB1CameraMode:GetCustomFocusDistance(ViewTarget, ViewToWorld) end


---@class UB1CameraModeBase : UObject
local UB1CameraModeBase = {}


---@class UB1CameraMode_AppearanceView : UB1CameraModeBase
local UB1CameraMode_AppearanceView = {}


---@class UB1CameraMode_BuildView : UB1CameraMode
---@field CameraInOutSpeed float
---@field CameraDistanceLimits FVector2D
local UB1CameraMode_BuildView = {}



---@class UB1CameraMode_CCTV : UB1CameraMode
local UB1CameraMode_CCTV = {}


---@class UB1CameraMode_CloseUp : UB1CameraMode_Studio
local UB1CameraMode_CloseUp = {}


---@class UB1CameraMode_Follow : UB1CameraMode
---@field PivotToViewTarget FTransform
---@field PivotLocXInterpolator FDoubleIIRInterpolatorFloat
---@field PivotLocYInterpolator FDoubleIIRInterpolatorFloat
---@field PivotLocZInterpolator FDoubleIIRInterpolatorFloat
---@field XYDeltaToInterpolateSpeed_CurveFloat UCurveFloat
---@field ZDeltaToInterpolateSpeed_CurveFloat UCurveFloat
---@field PivotRotInterpolator FDoubleIIRInterpolatorRotator
---@field PivotPitchLimits FVector2D
---@field PivotYawLimits FVector2D
---@field CameraToPivot FTransform
---@field CameraInOutSpeed float
---@field CameraDistanceLimits FVector2D
---@field CameraToPivotTranslationInterpolator FDoubleIIRInterpolatorVector
---@field CameraToPivot_PitchAdjustmentCurve UCurveVector
---@field CameraToPivot_PitchAdjustmentCurveScale float
---@field CameraToPivot_SpeedAdjustmentCurve UCurveVector
---@field CameraToPivot_SpeedAdjustmentCurveScale float
---@field CameraToPivot_SpeedAdjustment_SpeedRange FVector2D
---@field MouseSensitivityYaw float
---@field MouseSensitivityPitch float
---@field AutoFollowMode ECameraAutoFollowMode
---@field LazyAutoFollowPitchLimits FVector2D
---@field bAllowLazyAutoFollowPitchControl boolean
---@field LazyFollowLaziness float
---@field LazyFollowDelayAfterUserControl float
---@field LookatOffsetLocal FVector
---@field LookatWorldSpaceInterpolator FIIRInterpolatorVector
---@field bUseLookatPoint boolean
---@field bDoPredictiveLookat boolean
---@field PredictiveLookatTime float
---@field CameraPenetrationAvoidanceRays TArray<FPenetrationAvoidanceRay>
---@field SafeLocPenetrationAvoidanceRays TArray<FPenetrationAvoidanceRay>
---@field SafeLocationOffset FVector
---@field SafeLocationInterpolator FIIRInterpolatorVector
---@field bValidateSafeLoc boolean
---@field bPreventCameraPenetration boolean
---@field bDoPredictiveAvoidance boolean
---@field PenetrationBlendInTime float
---@field PenetrationHardBlockedBlendInTime float
---@field PenetrationBlendOutTime float
---@field LastSafeLocationLocal FVector
---@field LastPenetrationBlockedPct float
---@field bDrawDebugPivot boolean
---@field bDrawDebugLookat boolean
---@field bDrawDebugSafeLoc boolean
---@field bDrawDebugPenetrationAvoidance boolean
---@field DepthOfFieldSensorWidth_CurveFloat UCurveFloat
---@field DepthOfFieldSqueezeFactor_CurveFloat UCurveFloat
---@field DepthOfFieldFocalDistance_CurveFloat UCurveFloat
---@field DepthOfFieldDepthBlurAmount_CurveFloat UCurveFloat
---@field DepthOfFieldDepthBlurRadius_CurveFloat UCurveFloat
local UB1CameraMode_Follow = {}



---@class UB1CameraMode_Free : UB1CameraMode
---@field DroneTiltInterpolator FIIRInterpolatorRotator
---@field DroneTiltInterpSpeed_Accel float
---@field DroneTiltInterpSpeed_Decel float
---@field TiltUpVector FVector
---@field bEnableTiltLimits boolean
---@field TiltLimits FRotator
---@field bCeilingVisible boolean
local UB1CameraMode_Free = {}



---@class UB1CameraMode_GenerateMotion : UB1CameraMode_Studio
local UB1CameraMode_GenerateMotion = {}


---@class UB1CameraMode_LevelSequence : UB1CameraMode
local UB1CameraMode_LevelSequence = {}


---@class UB1CameraMode_Map : UB1CameraMode
---@field CameraInOutSpeed float
---@field CameraDistanceLimits FVector2D
---@field BlendType_ChangeCameraPosition EEasingFunc::Type
---@field BlendTime_ChangeCameraPosition float
local UB1CameraMode_Map = {}



---@class UB1CameraMode_PhotoMode : UB1CameraMode
---@field Center FVector
---@field Rotation FRotator
---@field Distance float
local UB1CameraMode_PhotoMode = {}



---@class UB1CameraMode_QuarterView : UB1CameraModeBase
local UB1CameraMode_QuarterView = {}


---@class UB1CameraMode_ShoulderView : UB1CameraModeBase
local UB1CameraMode_ShoulderView = {}


---@class UB1CameraMode_Studio : UB1CameraMode
---@field FocusData TMap<EB1CloseUpFocusType, FB1CameraCloseUpFocus>
---@field FocusType EB1CloseUpFocusType
---@field RotateSpeed float
---@field AxialMoveSpeed float
---@field PanMoveSpeed float
---@field DOF float
---@field CameraZoomSpeed float
---@field CameraHeightLimitHigh float
---@field CameraHeightLimitLow float
---@field Epsilon float
---@field CameraHeightOffset TMap<EB1CloseUpFocusType, FB1CameraCloseUpHeighOffset>
local UB1CameraMode_Studio = {}

function UB1CameraMode_Studio:UpdateViewOrigin() end


---@class UB1CameraMode_Top : UB1CameraMode
---@field CameraInOutSpeed float
---@field CameraInOutSpeed_CurveFloat UCurveFloat
---@field CameraRelativePitch_CurveFloat UCurveFloat
---@field CameraAxisSpeedMultiplier_CurveFloat UCurveFloat
---@field XYDeltaToInterpolateSpeed_CurveFloat UCurveFloat
---@field ZDeltaToInterpolateSpeed_CurveFloat UCurveFloat
---@field CameraDistanceLimits FVector2D
---@field CameraPitchLimits FVector2D
local UB1CameraMode_Top = {}



---@class UB1CameraMode_TraitSelect : UB1CameraMode
local UB1CameraMode_TraitSelect = {}


---@class UB1CameraMode_Vehicle : UB1CameraMode
---@field RestoreCameraRotator FRotator
---@field ThirdPersonCameraPitchLimits FVector2D
---@field CameraHeight FVector
---@field CameraDistanceLimit FVector2D
---@field IndoorCameraYawLimits FVector2D
---@field IndoorCameraPitchLimits FVector2D
local UB1CameraMode_Vehicle = {}



---@class UB1CameraRotationComponent : UActorComponent
---@field Setting FB1CameraRotationSetting
local UB1CameraRotationComponent = {}



---@class UB1CaptureViewportWidget : UB1UserWidgetBase
---@field BW_Image_BG UB1Image
local UB1CaptureViewportWidget = {}



---@class UB1CatOperatorAmbitionUIHandler : UB1AmbitionUIHandlerBase
local UB1CatOperatorAmbitionUIHandler = {}


---@class UB1CatOperatorChangeWidgetBase : UB1UserWidgetBase
local UB1CatOperatorChangeWidgetBase = {}


---@class UB1CatOperatorFamilyEntryWidget : UB1UserWidgetBase
---@field BW_Button_Portrait UB1Button
---@field BW_WBP_Portrait UB1PlayerPortraitWidget
---@field Anim_Selected UWidgetAnimation
local UB1CatOperatorFamilyEntryWidget = {}



---@class UB1CatOperatorFamilyWidget : UB1UserWidgetBase
---@field BW_DynamicEntryBox UB1DynamicEntryBox
local UB1CatOperatorFamilyWidget = {}



---@class UB1CatOperatorHopeLifeWidget : UB1UserWidgetBase
---@field BW_Image_HopeLife UB1Image
---@field BW_WidgetSwitcher_Desc UB1WidgetSwitcher
---@field BW_Text_HopeLifeDesc UB1TextBlock
---@field BW_Button_HopeLifeChange UB1CommonButtonWidget
local UB1CatOperatorHopeLifeWidget = {}



---@class UB1CatOperatorHopeUIHandler : UB1HopeUIHandlerBase
local UB1CatOperatorHopeUIHandler = {}


---@class UB1CatOperatorHopeWidget : UB1HopeWidget
local UB1CatOperatorHopeWidget = {}


---@class UB1CatOperatorPlayerSkillEntryVM : UObject
local UB1CatOperatorPlayerSkillEntryVM = {}


---@class UB1CatOperatorSelectedPlayerInfoWidget : UB1UserWidgetBase
---@field BW_Text_FamilyName UB1TextBlock
---@field BW_Text_name UB1TextBlock
---@field BW_Text_GrowthStep UB1TextBlock
---@field BW_Text_Gender UB1TextBlock
---@field BW_Button_Edit UB1CommonButtonWidget
---@field WBP_CatShop_Btn UB1CommonButtonWidget
---@field BW_Image_CompanyIcon UB1Image
---@field BW_Text_JobName UB1TextBlock
---@field BW_Text_Karma UB1TextBlock
---@field WBP_CatOperator_SelectedPlayerInfo_Slider UB1CatOperatorSliderWidget
---@field BW_Text_Education UB1TextBlock
---@field BW_Text_Education_Key UB1TextBlock
---@field BW_SizeBox_Education UB1SizeBox
---@field BW_WBP_NewMarker UB1UserWidgetBase
---@field GameplayTagToWidget TMap<FGameplayTag, UB1UserWidgetBase>
local UB1CatOperatorSelectedPlayerInfoWidget = {}



---@class UB1CatOperatorSliderWidget : UB1CommonSliderWidget
---@field BW_WidgetSwitcher_UpDown UB1WidgetSwitcher
local UB1CatOperatorSliderWidget = {}



---@class UB1CatOperatorTraitDetailWidget : UB1TraitDetailInfoWidgetBase
local UB1CatOperatorTraitDetailWidget = {}


---@class UB1CatOperatorUIHandler : UB1UIHandlerBase
---@field CatOperatorWidget UB1CatOperatorWidget
local UB1CatOperatorUIHandler = {}



---@class UB1CatOperatorWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Widget_ContentArea UWidget
---@field WBP_CatOperator_SelectedPlayerInfo UB1CatOperatorSelectedPlayerInfoWidget
local UB1CatOperatorWidget = {}



---@class UB1CatPopupWidget : UB1PopupWidgetBase
---@field B1HorizontalBox_btn UB1HorizontalBox
---@field BW_Image_Cat UB1Image
local UB1CatPopupWidget = {}



---@class UB1CatShopBuyResultWidget : UB1UserWidgetBase
---@field Image_Icon UB1Image
local UB1CatShopBuyResultWidget = {}

function UB1CatShopBuyResultWidget:OnFinishAnim() end


---@class UB1CatShopListEntryWidget : UB1UserWidgetBase
---@field Text_name UB1TextBlock
---@field Text_description UB1TextBlock
---@field Text_price UB1TextBlock
---@field Image_bg_hover UB1Image
---@field Image_Icon UB1Image
---@field Button_Click UB1Button
local UB1CatShopListEntryWidget = {}



---@class UB1CatShopUIHandler : UB1UIHandlerBase
local UB1CatShopUIHandler = {}


---@class UB1CatShopWidget : UB1UserWidgetBase
---@field CatShopPoint UB1TextBlock
---@field ProductList UB1DynamicEntryBox
---@field BW_Button_Close UB1Button
---@field bIsCatOperatorWidget boolean
local UB1CatShopWidget = {}



---@class UB1CatTalkBannerWidget : UB1UserWidgetBase
---@field BW_Image_Profile UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_WBP_CatTalkBannerSmall UWidget
---@field BW_Text_ProfileMessage UB1TextBlock
---@field BW_WBP_Button UB1CommonButtonWidget
local UB1CatTalkBannerWidget = {}



---@class UB1CatTalkBlankWidget : UB1UserWidgetBase
---@field BW_WBP_Button UB1CommonButtonWidget
local UB1CatTalkBlankWidget = {}



---@class UB1CatTalkMenuButtonWidget : UB1CommonButtonWidget
---@field BW_Image_Profile UB1Image
---@field BW_Widget_VideoCall UWidget
local UB1CatTalkMenuButtonWidget = {}



---@class UB1CatTalkMenuGroupListEntryWidget : UB1UserWidgetBase
---@field BW_Text_GroupName UB1TextBlock
---@field BW_DynamicEntryBox UB1DynamicEntryBox
local UB1CatTalkMenuGroupListEntryWidget = {}



---@class UB1CatTalkMenuGroupListWidget : UB1UserWidgetBase
---@field BW_DynamicEntryBox UB1DynamicEntryBox
local UB1CatTalkMenuGroupListWidget = {}



---@class UB1CatTalkMenuListEntryData : UObject
---@field Children TArray<UB1CatTalkMenuListEntryData>
local UB1CatTalkMenuListEntryData = {}



---@class UB1CatTalkMenuListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_WidgetSwitcher_Menu UB1WidgetSwitcher
---@field BW_Image_Arrow_0 UB1Image
---@field BW_Text_name_0 UB1TextBlock
---@field BW_Image_Arrow_1 UB1Image
---@field BW_Text_name_1 UB1TextBlock
---@field BW_Image_Profile UB1Image
---@field BW_Text_name_2 UB1TextBlock
local UB1CatTalkMenuListEntryWidget = {}



---@class UB1CatTalkMenuWidget : UB1UserWidgetBase
---@field BW_TreeView UB1TreeView
local UB1CatTalkMenuWidget = {}

---@param Item UObject
---@param bExpanded boolean
function UB1CatTalkMenuWidget:OnItemExpansionChanged(Item, bExpanded) end
---@param Item UObject
---@param OutChildren TArray<UObject>
function UB1CatTalkMenuWidget:OnGetItemChildren(Item, OutChildren) end


---@class UB1CatTalkTutorialWidget : UB1UserWidgetBase
---@field BW_ListView_Tutorial UB1ListView
local UB1CatTalkTutorialWidget = {}



---@class UB1CatTalkUIHandler : UB1UIHandlerBase
local UB1CatTalkUIHandler = {}


---@class UB1CatTalkWidget : UB1UserWidgetBase
---@field BW_WBP_CatTalkMenu UB1CatTalkMenuWidget
---@field BW_WBP_CatTalkBanner UB1CatTalkBannerWidget
---@field BW_WBP_Button_Escape UB1CommonButtonWidget
---@field BW_WBP_Button_Cheat UB1CommonButtonWidget
---@field BW_WBP_Button_Support UB1CommonButtonWidget
---@field BW_Button_CatTalkNotification UB1CommonButtonWidget
---@field BW_WidgetSwitcher_Content UB1WidgetSwitcher
---@field BW_WBP_ChatbotTalk UB1ChatbotTalkWidget
---@field BW_WBP_NpcTalk UB1NpcTalkWidget
---@field BW_WBP_CatTalk_Tutorial UB1CatTalkTutorialWidget
---@field BW_WBP_Blank_BuildWorld UWidget
---@field BW_Overlay_PsyCat UB1Overlay
---@field DummyItemForPsycatTalk UB1CatTalkMenuListEntryData
local UB1CatTalkWidget = {}



---@class UB1CeilingModeEnterButton : UB1UserWidgetBase
---@field B1Button UB1Button
local UB1CeilingModeEnterButton = {}



---@class UB1ChangableScheduleSiteVM : UObject
local UB1ChangableScheduleSiteVM = {}


---@class UB1ChangeAmbitionWidget : UB1CatOperatorChangeWidgetBase
---@field TileView_GoalList UB1TileView
---@field Text_GoalName UB1TextBlock
---@field Text_IsPlayingAmbition UB1TextBlock
---@field Button_ChangeGoal UB1CommonButtonWidget
---@field Button_Close UB1Button
---@field Image_Goal UB1Image
---@field Image_GoalBg UB1Image
---@field ListView_AmbitionLevel UB1ListView
---@field ListView_MissionList UB1ListView
---@field BW_Box_MissionTabs UB1HorizontalBox
---@field BW_Text_Complete UB1TextBlock
---@field BW_Text_DescTextid UB1TextBlock
---@field MissionTabWidgetClass TSubclassOf<UUserWidget>
local UB1ChangeAmbitionWidget = {}

---@param InAmbitionItemId FName
function UB1ChangeAmbitionWidget:OnClickedAmbitionMissionTab(InAmbitionItemId) end


---@class UB1ChangeFreeCameraGuideWidget : UB1UserWidgetBase
---@field BW_Text_Guide UB1TextBlock
---@field Timer_DisplayWidgetDuration FTimerHandle
local UB1ChangeFreeCameraGuideWidget = {}

function UB1ChangeFreeCameraGuideWidget:HideGuideWidget() end


---@class UB1CharacterAnimInstance : UB1AnimInstance
---@field StateSequence EAnim_StateSequence
---@field bStateBlended boolean
---@field Character AB1Character
---@field bHasVelocity boolean
---@field Speed float
---@field Velocity FVector
---@field InputVector FVector
---@field LeanAmount FVector2D
---@field InputDirection EB1Anim_Direction
---@field InputVectorRotationRate float
---@field VelocityRotationRate float
---@field LocalVelocityDirectionAngle float
---@field DisplacementSpeed float
---@field LocomotionState EB1LocomotionState
---@field StartAnimType EB1StartAnimType
---@field TimeInLocomotionState float
---@field bDisableRandomWalk boolean
---@field bIsPlayingStatAnim boolean
---@field bIsGrappedBaby boolean
---@field bIsSlope boolean
---@field bIsJogToWalk boolean
---@field bIsWalkToJog boolean
---@field bIsWalkStart boolean
---@field bIsJogStart boolean
---@field bIsWalkCycle boolean
---@field bIsJogCycle boolean
---@field bIsTurnMove boolean
---@field bIsPivot boolean
---@field bIsStops boolean
---@field bIsApplyLookAtWeight boolean
---@field UpperBodyLookAt FVector2D
---@field HeadLookAt FVector2D
---@field bUseSlotLayer boolean
---@field bHasSlotSnapshot boolean
---@field SlotLayerWeight float
---@field SlotSnapshotWeight float
---@field SlotLayerBlendSpeed float
---@field bEnableDebugInfo boolean
---@field LeanAngle float
---@field CardinalDirectionDeadZone float
---@field RootYawOffsetAngleClamp FVector2D
---@field SmoothRotationRateOutRange90 FVector2D
---@field SmoothRotationRateOutRange180 FVector2D
---@field PoseSearchBones TArray<FBoneReference>
---@field WalkLeanCurve UCurveFloat
---@field JogLeanCurve UCurveFloat
---@field LocomotionData FB1CharacterLocomotionData
---@field StatLocomotionDatas TArray<FB1StatLocomotionData>
---@field WalkAnim UAnimSequenceBase
---@field WalkSlopeAnim UAnimSequenceBase
---@field WalkStartAnim UAnimSequenceBase
---@field JogAnim UAnimSequenceBase
---@field JogStartAnim UAnimSequenceBase
---@field StopAnim UAnimSequenceBase
---@field JogToWalkAnim UAnimSequenceBase
---@field WalkToJogAnim UAnimSequenceBase
---@field TurnMoveAnim UAnimSequenceBase
---@field AnimStartTime float
---@field IdleAnims TArray<FB1RandomPlayerSequenceEntry>
---@field WalkRandomAnims TArray<FB1RandomPlayerSequenceEntry>
---@field MinWalkLoopCount int32
---@field MaxWalkLoopCount int32
---@field bStartFromMatchingPose boolean
---@field bLiveLinkEnabled boolean
---@field LiveLinkSubjectName FLiveLinkSubjectName
---@field LiveLinkHeadRotation FRotator
---@field FootIKAlpha float
---@field BestPoseTime float
local UB1CharacterAnimInstance = {}

function UB1CharacterAnimInstance:OnTurnState() end
function UB1CharacterAnimInstance:OnStartState() end
function UB1CharacterAnimInstance:OnPivotState() end
function UB1CharacterAnimInstance:OnIdleState() end
function UB1CharacterAnimInstance:OnFinishState() end
function UB1CharacterAnimInstance:OnCycleState() end
function UB1CharacterAnimInstance:OnCycleBlended() end


---@class UB1CharacterAttributeBlueprintLibrary : UBlueprintFunctionLibrary
local UB1CharacterAttributeBlueprintLibrary = {}

---@param InSeedName FName
---@return FB1CharacterAttribute
function UB1CharacterAttributeBlueprintLibrary:CreateArbitraryCharacterWithAccessoryAttribute(InSeedName) end
---@return FB1CharacterAttribute
function UB1CharacterAttributeBlueprintLibrary:CreateArbitraryCharacterAttribute() end


---@class UB1CharacterBodySliderWidget : UB1UserWidgetBase
---@field Slider_Value USlider
---@field ProgressBar_Value UProgressBar
---@field Text_value UB1TextBlock
---@field Button_input UB1Button
---@field BW_SizeBox UB1SizeBox
---@field Text_name UB1TextBlock
---@field TitleText FText
---@field Size FVector2D
local UB1CharacterBodySliderWidget = {}

---@param InValue float
function UB1CharacterBodySliderWidget:Slider_Value_OnValueChanged(InValue) end
function UB1CharacterBodySliderWidget:Slider_Value_OnMouseCaptureEnd() end
function UB1CharacterBodySliderWidget:Slider_Value_OnMouseCaptureBegin() end


---@class UB1CharacterCustomizationBodyAdjustmentWidget : UB1UserWidgetBase
---@field BW_WBP_Muscle UB1CharacterBodySliderWidget
---@field BW_WBP_Fat UB1CharacterBodySliderWidget
---@field BW_WBP_FaceFat UB1CharacterBodySliderWidget
---@field BW_VerticalBox_BodyHair UWidget
---@field BW_WBP_BodyHairChest UB1CharacterBodySliderWidget
---@field BW_WBP_BodyHairArm UB1CharacterBodySliderWidget
---@field BW_WBP_BodyHairLeg UB1CharacterBodySliderWidget
---@field BW_WBP_BodyHairColor UB1CommonTextColorPickerWidget
---@field BW_WBP_BodyHairColorPopup UB1CommonTextColorPickerPopupWidget
---@field BW_Button_Reset UB1Button
---@field BW_WidgetSwitcher_Category UB1WidgetSwitcher
---@field BW_WBP_CommonWarning UB1UserWidgetBase
---@field BW_VerticalBox_Body UB1VerticalBox
local UB1CharacterCustomizationBodyAdjustmentWidget = {}

function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_Muscle_OnValueChanged() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_Muscle_OnMouseCaptureEnd() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_Muscle_OnMouseCaptureBegin() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_Fat_OnValueChanged() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_Fat_OnMouseCaptureEnd() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_Fat_OnMouseCaptureBegin() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_FaceFat_OnValueChanged() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_FaceFat_OnMouseCaptureEnd() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_FaceFat_OnMouseCaptureBegin() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_BodyHairLeg_OnValueChanged() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_BodyHairLeg_OnMouseCaptureEnd() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_BodyHairLeg_OnMouseCaptureBegin() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_BodyHairChest_OnValueChanged() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_BodyHairChest_OnMouseCaptureEnd() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_BodyHairChest_OnMouseCaptureBegin() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_BodyHairArm_OnValueChanged() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_BodyHairArm_OnMouseCaptureEnd() end
function UB1CharacterCustomizationBodyAdjustmentWidget:BW_WBP_BodyHairArm_OnMouseCaptureBegin() end


---@class UB1CharacterCustomizationBodyPointWidget : UB1UserWidgetBase
---@field BW_Button UB1Button
local UB1CharacterCustomizationBodyPointWidget = {}



---@class UB1CharacterCustomizationBodyWidget : UB1CharacterCustomizationContentWidgetBase
---@field BW_Text_Guide UB1TextBlock
local UB1CharacterCustomizationBodyWidget = {}



---@class UB1CharacterCustomizationCategoryWidget : UB1UserWidgetBase
---@field BW_Button_Preset UB1Button
---@field BW_Button_Face UB1Button
---@field BW_Button_Body UB1Button
---@field BW_Button_Costume UB1Button
---@field BW_Button_CostumeEdit UB1Button
---@field BW_Button_Accessory UB1Button
---@field BW_WBP_CostumeEditCategory UB1CharacterCustomizeCostumeEditCategoryWidget
---@field BW_Image_Selection UWidget
---@field BW_SizeBox_Preset UB1SizeBox
---@field BW_SizeBox_Body UB1SizeBox
---@field BW_SizeBox_CostumeEdit UB1SizeBox
---@field BW_WBP_NewMarker_AllPreset UB1UserWidgetBase
---@field BW_WBP_NewMarker_Face UB1UserWidgetBase
---@field BW_WBP_NewMarker_Body UB1UserWidgetBase
---@field BW_WBP_NewMarker_Costume UB1UserWidgetBase
---@field BW_WBP_NewMarker_CostumeEdit UB1UserWidgetBase
---@field BW_WBP_NewMarker_Accessory UB1UserWidgetBase
---@field ButtonStyles FB1CharacterCustomizationCategoryWidget_ButtonStyles
---@field SelectionUpdateTimeDelay double
---@field GameplayTagToWidget TMap<FGameplayTag, UB1UserWidgetBase>
local UB1CharacterCustomizationCategoryWidget = {}



---@class UB1CharacterCustomizationColorChangeWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_PartsVerticalBox UWidget
---@field BW_Text_GarmentName UB1TextBlock
---@field BW_PartsButton_0 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_1 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_2 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_3 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_4 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_5 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_6 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_7 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_8 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_9 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_10 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_11 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_12 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_13 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_14 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_15 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_16 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_17 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_18 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_19 UB1CharacterCustomizationPartsButtonWidget
---@field BW_WBP_ColorPicker UB1ColorPickerWidget
---@field BW_WBP_ColorPalette UB1BuildCustomizeColorPalette
---@field BW_Button_Reset UB1CommonButtonWidget
---@field BW_Widget_Separator UWidget
---@field BW_DynamicEntryBox_Slider UB1DynamicEntryBox
---@field BW_CheckBox_MatchBodyHairColor UB1CheckBox
---@field BW_Widget_TabRoot UWidget
---@field Button_Color UB1Button
---@field Button_AITexture UB1Button
---@field WidgetSwitcher_Tab UB1WidgetSwitcher
---@field WBP_CharacterCustomize_AIMaterialListGroup UB1BuildCustomizeAIMaterialGroup
---@field BW_VerticalBox_ColorPreset UB1VerticalBox
---@field BW_DynamicEntryBox_ColorPreset UB1DynamicEntryBox
---@field WBP_StableDiffusion_Simple UB1SDRequestWidget
---@field WBP_StableDiffusion_Simple_Result UB1SDResultWidget
---@field SliderNames TMap<FName, FText>
---@field SliderSize FVector2D
local UB1CharacterCustomizationColorChangeWidget = {}

function UB1CharacterCustomizationColorChangeWidget:OnLocalMaterialAddClicked() end
function UB1CharacterCustomizationColorChangeWidget:OnAIMaterialDeleteModeCompleteClicked() end
function UB1CharacterCustomizationColorChangeWidget:OnAIMaterialDeleteModeClicked() end
function UB1CharacterCustomizationColorChangeWidget:OnAIMaterialDeleteModeCancelClicked() end
function UB1CharacterCustomizationColorChangeWidget:OnAIMaterialAddClicked() end


---@class UB1CharacterCustomizationContentWidgetBase : UB1UserWidgetBase
local UB1CharacterCustomizationContentWidgetBase = {}


---@class UB1CharacterCustomizationCostumeEditListEntryData : UObject
local UB1CharacterCustomizationCostumeEditListEntryData = {}


---@class UB1CharacterCustomizationCostumeEditListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_Image_Icon UB1Image
---@field BW_Button_AITexture UB1Button
---@field BW_Button_Color UB1Button
---@field BW_Overlay_SelectedState UB1Overlay
---@field BW_Button_Deselect UB1CommonButtonWidget
---@field BW_Button_Gallery UB1Button
---@field BW_WBP_NewMarker UB1UserWidgetBase
local UB1CharacterCustomizationCostumeEditListEntryWidget = {}



---@class UB1CharacterCustomizationCostumeEditWidget : UB1CharacterCustomizationContentWidgetBase
---@field BW_Canvas_BodyPointRoot UB1CanvasPanel
---@field BW_WBP_List UB1CostumeEditListWidget
---@field BodyPointWidgetClass TSubclassOf<UB1CharacterCustomizationBodyPointWidget>
---@field ListWidgetOffset FVector2D
---@field ListWidgetScreenPadding FMargin
---@field HorizontalCenterRatio float
---@field BodyPointWidgets TArray<UB1CharacterCustomizationBodyPointWidget>
---@field LineColor FLinearColor
---@field LineWidth float
---@field LinePaddingLeft float
---@field LinePaddingTop float
local UB1CharacterCustomizationCostumeEditWidget = {}



---@class UB1CharacterCustomizationCostumeWidget : UB1CharacterCustomizationContentWidgetBase
---@field BW_WBP_List_Costume UB1CharacterCustomizationListWidget
local UB1CharacterCustomizationCostumeWidget = {}



---@class UB1CharacterCustomizationFaceWidget : UB1CharacterCustomizationContentWidgetBase
---@field BW_Button_Face UB1Button
---@field BW_Button_Makeup UB1Button
---@field BW_Button_Hair UB1Button
---@field BW_Button_Accessory UB1Button
---@field BW_Button_Skin UB1Button
---@field BW_Button_SkinFeatures UB1Button
---@field BW_Button_Eyes UB1Button
---@field BW_Button_FaceControllerToggle UB1Button
---@field BW_WidgetSwitcher_Toggle UB1WidgetSwitcher
---@field BW_CheckBox_Symmetry UB1CheckBox
---@field BW_WBP_CharacterCustomizeFaceEditTab UB1CustomizeFaceEditTabWidget
---@field BW_GridPanel_Face UB1GridPanel
---@field BW_Overlay_SymmetryMode UB1Overlay
---@field BW_WBP_NewMarker_FacePreset UB1UserWidgetBase
---@field BW_WBP_NewMarker_Hair UB1UserWidgetBase
---@field BW_WBP_NewMarker_Skin UB1UserWidgetBase
---@field BW_WBP_NewMarker_SkinFeatures UB1UserWidgetBase
---@field BW_WBP_NewMarker_Eyes UB1UserWidgetBase
---@field BW_WBP_NewMarker_MakeUp UB1UserWidgetBase
---@field GameplayTagToWidget TMap<FGameplayTag, UB1UserWidgetBase>
local UB1CharacterCustomizationFaceWidget = {}



---@class UB1CharacterCustomizationGenderEditWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_GenderType_Male UB1CommonFilterListEntryTempWidget
---@field BW_GenderType_Female UB1CommonFilterListEntryTempWidget
---@field BW_GenderType_NonBinary UB1CommonFilterListEntryTempWidget
---@field BW_RomanticOrientation UB1CommonFilterListEntryTempWidget
---@field BW_RomanceTargets_Male UB1CommonFilterListEntryTempWidget
---@field BW_RomanceTargets_Female UB1CommonFilterListEntryTempWidget
---@field BW_RomanceTargets_NonBinary UB1CommonFilterListEntryTempWidget
local UB1CharacterCustomizationGenderEditWidget = {}



---@class UB1CharacterCustomizationItemMainCategoryListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_Image_Icon UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_Button_SubCategoryList UB1Button
---@field BW_WBP_NewMarker UB1UserWidgetBase
local UB1CharacterCustomizationItemMainCategoryListEntryWidget = {}



---@class UB1CharacterCustomizationItemMainCategoryListItem : UObject
local UB1CharacterCustomizationItemMainCategoryListItem = {}


---@class UB1CharacterCustomizationListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_WidgetSwitcher UB1WidgetSwitcher
---@field BW_Widget_Default UWidget
---@field BW_Widget_CostumeEditButton UWidget
---@field BW_Widget_SavePreset UWidget
---@field BW_Button_SavePreset UB1Button
---@field BW_Button_Deselect UB1CommonButtonWidget
---@field BW_Button_Gallery UB1Button
---@field BW_Button_Color UB1Button
---@field BW_Button_AITexture UB1Button
---@field BW_SetDelete_Button UB1Button
---@field BW_CheckBox_Delete UB1CheckBox
---@field BW_Widget_SelectedState UWidget
---@field BW_Image_Icon UB1Image
---@field BW_CanvasPanel_Download UWidget
---@field BW_SizeBox_ObjectQuantity UB1SizeBox
---@field BW_Text_Number UB1TextBlock
---@field BW_Image_ObjectQuantity UB1Image
---@field BW_WBP_NewMarker UB1UserWidgetBase
---@field BW_WidgetSwitcher_Loading UB1WidgetSwitcher
---@field BW_CanvasPanel_LoadingThumbnail UB1CanvasPanel
local UB1CharacterCustomizationListEntryWidget = {}



---@class UB1CharacterCustomizationListItemData : UObject
local UB1CharacterCustomizationListItemData = {}


---@class UB1CharacterCustomizationListWidget : UB1UserWidgetBase
---@field BW_WBP_SkinFeatures UB1SkinFeaturesWidget
---@field BW_Text_Title UB1TextBlock
---@field BW_Button_Close UB1Button
---@field BW_CheckBox_ShowOnlyColorable UB1CheckBox
---@field BW_Button_RemoveAll UB1Button
---@field BW_Widget_ToolbarRoot UWidget
---@field BW_WidgetSwitcher_Toolbar UB1WidgetSwitcher
---@field BW_Widget_ToolbarMode UWidget
---@field BW_Button_DeleteMode UB1Button
---@field BW_Button_SortingMode UB1Button
---@field BW_Image_Filter UB1Image
---@field BW_Button_FilterMode UB1Button
---@field BW_Widget_DeleteMode UWidget
---@field BW_Button_DeleteModeCancel UB1Button
---@field BW_Button_DeleteModeComplete UB1Button
---@field BW_Widget_GalleryMode UWidget
---@field BW_Button_GalleryModeComplete UB1Button
---@field BW_Button_RemoveMakeup UB1Button
---@field BW_WBP_Filter_v2 UB1CommonFilterWidget
---@field BW_WBP_Sort UB1CommonSortWidget
---@field BW_ScrollBox UB1ScrollBox
---@field BW_TileView UB1TileView
---@field BW_ListView_ItemMainCategory UB1ListView
---@field BW_WBP_ColorChange UB1CharacterCustomizationColorChangeWidget
---@field BW_WBP_ColorChangeSkin UB1CommonTextColorPickerPopupWidget
---@field BW_WidgetSwitcher_ColorChange UB1WidgetSwitcher
---@field BW_WBP_CommonWarning UB1UserWidgetBase
---@field BW_Image_Banner UB1Image
---@field BW_Overlay_OutfitCategory UB1Overlay
---@field BW_WBP_Everyday UB1OutfitCategoryEntryWidget
---@field BW_WBP_Formal UB1OutfitCategoryEntryWidget
---@field BW_WBP_School UB1OutfitCategoryEntryWidget
---@field BW_WBP_Sleep UB1OutfitCategoryEntryWidget
---@field BW_WBP_Party UB1OutfitCategoryEntryWidget
---@field BW_WBP_Sports UB1OutfitCategoryEntryWidget
---@field BW_WBP_Swimwear UB1OutfitCategoryEntryWidget
---@field BW_WBP_Summer UB1OutfitCategoryEntryWidget
---@field BW_WBP_Winter UB1OutfitCategoryEntryWidget
---@field BW_WidgetSwitcher_List UB1WidgetSwitcher
---@field BW_WBP_Body UB1CharacterCustomizationBodyAdjustmentWidget
---@field CategoryTag FGameplayTag
---@field TitleText FText
---@field ListItems TArray<UB1CharacterCustomizationListItemData>
---@field SelectedItems TSet<UB1CharacterCustomizationListEntryWidget>
---@field CachedCostumePresetFilterDataList TArray<UB1CommonFilterEntryData>
---@field CachedCostumeFilterDataList TArray<UB1CommonFilterEntryData>
---@field SelectedCostumePresetTagDataMap TMap<FName, FB1CharacterCustomizeFilterTagNames>
---@field SelectedCostumeTagDataMap TMap<FName, FB1CharacterCustomizeFilterTagNames>
local UB1CharacterCustomizationListWidget = {}



---@class UB1CharacterCustomizationNameEditWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_Name UB1WidgetSwitcher
---@field BW_WidgetSwitcher_FullName UB1WidgetSwitcher
---@field BW_Text_FullName UB1TextBlock
---@field BW_Button_Edit UB1Button
---@field BW_Panel_NameAreaLeft UPanelWidget
---@field BW_Panel_NameAreaRight UPanelWidget
---@field BW_Widget_FirstNameRoot UWidget
---@field BW_Widget_LastNameRoot UWidget
---@field BW_Image_ErrorBG_FirstName UB1Image
---@field BW_Image_ErrorBG_LastName UB1Image
---@field BW_EditableTextBox_FirstName UB1EditableTextBox
---@field BW_EditableTextBox_LastName UB1EditableTextBox
---@field BW_Button_Complete UB1Button
---@field BW_Text_Error_Over UWidget
---@field BW_Text_Error_SpecialCase UWidget
---@field BW_Button_RandomFirstName UB1CommonButtonWidget
---@field BW_Button_RandomLastName UB1CommonButtonWidget
local UB1CharacterCustomizationNameEditWidget = {}

---@param InText FText
---@param InCommitMethod ETextCommit::Type
function UB1CharacterCustomizationNameEditWidget:OnTextCommitted(InText, InCommitMethod) end
---@param InText FText
function UB1CharacterCustomizationNameEditWidget:OnTextChanged(InText) end


---@class UB1CharacterCustomizationPartsButtonWidget : UB1UserWidgetBase
---@field BW_Button UB1Button
---@field BW_Image_Color UB1Image
---@field BW_Text UB1TextBlock
---@field DefaultTexture UTexture2D
---@field ButtonLabel FText
local UB1CharacterCustomizationPartsButtonWidget = {}



---@class UB1CharacterCustomizationPresetTooltip : UB1TooltipWidgetBase
---@field BW_Image_Preset UB1Image
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_NickName UB1TextBlock
---@field BW_Button_Gallery UB1Button
local UB1CharacterCustomizationPresetTooltip = {}



---@class UB1CharacterCustomizationPresetWidget : UB1CharacterCustomizationContentWidgetBase
local UB1CharacterCustomizationPresetWidget = {}


---@class UB1CharacterCustomizationSavePreset : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Text_PresetName UB1TextBlock
---@field BW_Button_GalleryUpload UB1CommonButtonWidget
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Save UB1CommonButtonWidget
---@field BW_Common_Loading UUserWidget
---@field ResultMessageTime float
---@field Thumbnail UTexture2D
local UB1CharacterCustomizationSavePreset = {}



---@class UB1CharacterCustomizationSexSelectWidget : UB1UserWidgetBase
---@field BW_Button_Male UB1CommonButtonWidget
---@field BW_Button_Female UB1CommonButtonWidget
---@field BW_Button_GenderEdit UB1Button
local UB1CharacterCustomizationSexSelectWidget = {}



---@class UB1CharacterCustomizationSubCategoryListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_Image_Icon UB1Image
---@field BW_Text_name UB1TextBlock
local UB1CharacterCustomizationSubCategoryListEntryWidget = {}



---@class UB1CharacterCustomizationSubCategoryListItem : UObject
local UB1CharacterCustomizationSubCategoryListItem = {}


---@class UB1CharacterCustomizationSubCategoryListWidget : UB1UserWidgetBase
---@field BW_Text_CategoryName UB1TextBlock
---@field BW_Button_CategoryName UB1Button
---@field BW_TileView UB1TileView
local UB1CharacterCustomizationSubCategoryListWidget = {}



---@class UB1CharacterCustomizationWidget : UB1UserWidgetBase
---@field BW_WBP_CommonTitle UB1CommonTitleWidget
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Description UB1TextBlock
---@field BW_WBP_NameEdit UB1CharacterCustomizationNameEditWidget
---@field BW_WBP_SexSelect UB1CharacterCustomizationSexSelectWidget
---@field BW_WBP_GenderEditPopup UB1CharacterCustomizationGenderEditWidget
---@field BW_WBP_CharacterCustomize_AgeSelect UB1CharacterCustomizeAgeSelectWidget
---@field BW_TextSpinBox_FacialExpression UB1CommonTextSpinBoxWidget
---@field BW_TextSpinBox_Pose UB1CommonTextSpinBoxWidget
---@field BW_Button_RotateLeft UB1Button
---@field BW_Button_RotateRight UB1Button
---@field BW_WBP_TopMenu UB1CharacterCustomizeTopMenuWidget
---@field BW_Button_Apply UB1CommonButtonWidget
---@field BW_Button_StudioOpen UB1Button
---@field BW_Button_StudioClose UB1Button
---@field BW_Button_Reset_PoseAndFacial UB1Button
---@field BW_Button_Reset_BG UB1Button
---@field BW_Button_Reset_Light_All UB1Button
---@field BW_Button_Reset_Light1 UB1Button
---@field BW_Button_Reset_Light2 UB1Button
---@field BW_Button_Reset_Light3 UB1Button
---@field BW_WBP_BGColor UB1CommonTextColorPickerWidget
---@field BW_WBP_Light1_X UB1CharacterBodySliderWidget
---@field BW_WBP_Light1_Y UB1CharacterBodySliderWidget
---@field BW_WBP_Light1_Color UB1CommonTextColorPickerWidget
---@field BW_WBP_Light2_X UB1CharacterBodySliderWidget
---@field BW_WBP_Light2_Y UB1CharacterBodySliderWidget
---@field BW_WBP_Light2_Color UB1CommonTextColorPickerWidget
---@field BW_WBP_Light3_X UB1CharacterBodySliderWidget
---@field BW_WBP_Light3_Y UB1CharacterBodySliderWidget
---@field BW_WBP_Light3_Color UB1CommonTextColorPickerWidget
---@field BW_WBP_ColorChange UB1CommonTextColorPickerPopupWidget
---@field BW_TileView_BG UB1TileView
---@field BW_CheckBox_UIHide UB1CheckBox
---@field BW_Button_AllPreset UB1Button
---@field BW_Button_Face UB1Button
---@field BW_Button_Body UB1Button
---@field BW_Button_Costume UB1Button
---@field BW_Button_CostumeEdit UB1Button
---@field BW_Button_Accessory UB1Button
---@field BW_Button_GalleryUpload UB1CommonButtonWidget
---@field BW_WBP_CommonWarning UB1UserWidgetBase
---@field BW_WBP_CommonWarning_1 UB1UserWidgetBase
---@field BW_VerticalBox_SliderGroup UB1VerticalBox
---@field BW_SizeBox_Trait UB1SizeBox
---@field BW_SizeBox_HopeLife UB1SizeBox
---@field BW_HorizontalBox_StudioGuide UB1HorizontalBox
---@field BW_WidgetSwitcher_HopeLife UB1WidgetSwitcher
---@field BW_Text_HopeLife UB1TextBlock
---@field BW_Button_HopeLifeEdit UB1Button
---@field BW_Image_HighLight UB1Image
---@field BW_WidgetSwitcher_HopeLifeDesc UB1WidgetSwitcher
---@field BW_Overlay_EditIcon UB1Overlay
---@field BW_Image_Edit_HighLight UB1Image
---@field BW_WBP_NewMarker_AllPreset UB1UserWidgetBase
---@field BW_WBP_NewMarker_Face UB1UserWidgetBase
---@field BW_WBP_NewMarker_Body UB1UserWidgetBase
---@field BW_WBP_NewMarker_Costume UB1UserWidgetBase
---@field BW_WBP_NewMarker_CostumeEdit UB1UserWidgetBase
---@field BW_WBP_NewMarker_Accessory UB1UserWidgetBase
---@field GameplayTagToWidget TMap<FGameplayTag, UB1UserWidgetBase>
local UB1CharacterCustomizationWidget = {}



---@class UB1CharacterCustomizeAccWidget : UB1CharacterCustomizationContentWidgetBase
---@field BW_WBP_List_Accessory UB1CharacterCustomizationListWidget
local UB1CharacterCustomizeAccWidget = {}



---@class UB1CharacterCustomizeAgeSelectEntryWidget : UB1UserWidgetBase
---@field BW_Button_Age UB1Button
---@field BW_Image_Age UB1Image
---@field Anim_Selected UWidgetAnimation
---@field ButtonImage TSoftObjectPtr<UTexture2D>
---@field GrowthStep EB1GrowthStep
local UB1CharacterCustomizeAgeSelectEntryWidget = {}



---@class UB1CharacterCustomizeAgeSelectWidget : UB1UserWidgetBase
---@field BW_Text_Age UB1TextBlock
---@field BW_Widget_ButtonArea UB1HorizontalBox
local UB1CharacterCustomizeAgeSelectWidget = {}



---@class UB1CharacterCustomizeCostumeEditCategoryWidget : UB1UserWidgetBase
---@field BW_Button_Shirts UB1Button
---@field BW_Button_Pants UB1Button
---@field BW_Button_Skirt UB1Button
---@field BW_Button_Necklace UB1Button
---@field BW_Button_Watch UB1Button
---@field BW_Button_Complete UB1Button
---@field BW_Button_Color UB1Button
---@field BW_Button_3D UB1Button
---@field BW_WBP_ColorChange UB1CharacterCustomizationColorChangeWidget
---@field CategoryTypeToWidgetMap TMap<EB1CharacterCustomizeCostumeEditCategoryType, UB1Button>
local UB1CharacterCustomizeCostumeEditCategoryWidget = {}



---@class UB1CharacterCustomizeDotComponent : UStaticMeshComponent
local UB1CharacterCustomizeDotComponent = {}


---@class UB1CharacterCustomizeEquippedListEntryWidget : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_WidgetSwitcher_Hide UB1WidgetSwitcher
---@field BW_Button_Hide UB1Button
---@field BW_Button_Deselect UB1Button
---@field BW_Button_Select UB1Button
local UB1CharacterCustomizeEquippedListEntryWidget = {}



---@class UB1CharacterCustomizeEquippedListWidget : UB1UserWidgetBase
---@field BW_DynamicEntryBox_EquippedList UB1DynamicEntryBox
local UB1CharacterCustomizeEquippedListWidget = {}



---@class UB1CharacterCustomizeStudioBGListEntryData : UObject
local UB1CharacterCustomizeStudioBGListEntryData = {}


---@class UB1CharacterCustomizeStudioBGListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_Image_BG UB1Image
local UB1CharacterCustomizeStudioBGListEntryWidget = {}



---@class UB1CharacterCustomizeTopMenuFilterWidget : UB1UserWidgetBase
---@field BW_Button_Filter UB1Button
---@field BW_Text_name UB1TextBlock
---@field FilterNameText FText
---@field FilterType EB1FilterType
local UB1CharacterCustomizeTopMenuFilterWidget = {}



---@class UB1CharacterCustomizeTopMenuWidget : UB1UserWidgetBase
---@field BW_Button_Filter UB1Button
---@field BW_Button_PhotoMode UB1Button
---@field BW_Button_FacialCapture UB1Button
---@field BW_Button_BodyTracking UB1Button
---@field BW_Button_Undo UB1Button
---@field BW_Button_Redo UB1Button
---@field BW_WBP_Realistic UB1CharacterCustomizeTopMenuFilterWidget
---@field BW_WBP_Cartoon UB1CharacterCustomizeTopMenuFilterWidget
---@field BW_WBP_TiltedShift UB1CharacterCustomizeTopMenuFilterWidget
---@field BW_WBP_Screentone UB1CharacterCustomizeTopMenuFilterWidget
---@field BW_WBP_Pixel UB1CharacterCustomizeTopMenuFilterWidget
---@field BW_WBP_FishEye UB1CharacterCustomizeTopMenuFilterWidget
---@field BW_WBP_Note UB1CharacterCustomizeTopMenuFilterWidget
---@field BW_WBP_Posterize UB1CharacterCustomizeTopMenuFilterWidget
---@field BW_WBP_Dust UB1CharacterCustomizeTopMenuFilterWidget
---@field FilterTypeToWidgetMap TMap<EB1FilterType, UB1CharacterCustomizeTopMenuFilterWidget>
local UB1CharacterCustomizeTopMenuWidget = {}



---@class UB1CharacterCustomizeUIHandler : UB1UIHandlerBase
local UB1CharacterCustomizeUIHandler = {}


---@class UB1CharacterManagerSubsystem : UTickableWorldSubsystem
---@field ManagedCharacters TArray<AB1Character>
---@field ManagedMovementComponents TArray<UB1CharacterMovementComponent>
local UB1CharacterManagerSubsystem = {}



---@class UB1CharacterMenuUIHandler : UB1UIHandlerBase
---@field ChracterMenuWidget UB1CharacterMenuWidget
local UB1CharacterMenuUIHandler = {}



---@class UB1CharacterMenuWidget : UB1UserWidgetBase
---@field B1Button_Relationship UB1Button
---@field B1Button_Skill UB1Button
---@field Overlay UOverlay
local UB1CharacterMenuWidget = {}

function UB1CharacterMenuWidget:Open() end
function UB1CharacterMenuWidget:OnClickedSkillButton() end
function UB1CharacterMenuWidget:OnClickedRelationshipButton() end
function UB1CharacterMenuWidget:Close() end


---@class UB1CharacterMeshSubsystem : UWorldSubsystem
---@field StandardMaterialPaths TArray<FSoftObjectPath>
---@field HairCardMaterialPaths TArray<FSoftObjectPath>
---@field EyeRefractiveMaterialPaths TArray<FSoftObjectPath>
---@field FallbackIdleAnimPaths TArray<FSoftObjectPath>
---@field OptiStandardGarmentMaterials TArray<UMaterial>
---@field OptiHairCardMaterials TArray<UMaterial>
---@field OptiEyeRefractiveMaterials TArray<UMaterial>
---@field FallbackBabyIdleAnimSeq UAnimSequenceBase
---@field FallbackChildIdleAnimSeq UAnimSequenceBase
---@field FallbackFemaleIdleAnimSeq UAnimSequenceBase
---@field FallbackMaleIdleAnimSeq UAnimSequenceBase
local UB1CharacterMeshSubsystem = {}



---@class UB1CharacterMovementComponent : UCharacterMovementComponent
---@field MinHorizontalSurfaceSlideAngle float
---@field MinHorizontalSurfaceSlideAngleCharacter float
local UB1CharacterMovementComponent = {}



---@class UB1CharacterSpotLightComponent : USpotLightComponent
---@field DayParam FB1CharacterSpotLightParams
---@field NightParam FB1CharacterSpotLightParams
---@field IndoorParam FB1CharacterSpotLightParams
---@field DayTimeStart int32
---@field DayTimeEnd int32
local UB1CharacterSpotLightComponent = {}



---@class UB1CharacterThumbnailCaptureManager : UB1ManagerBase
local UB1CharacterThumbnailCaptureManager = {}


---@class UB1ChatHistoryEntryWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_Typing UB1WidgetSwitcher
---@field BW_Image_Profile UB1Image
---@field BW_RichText_Message UB1RichTextBlock
---@field BW_Widget_LinkArea UWidget
---@field BW_Button_Link UB1Button
---@field BW_Text_Link UB1TextBlock
local UB1ChatHistoryEntryWidget = {}



---@class UB1ChatHistoryWidget : UB1UserWidgetBase
---@field BW_Panel_EntryArea UB1VerticalBox
---@field Settings FB1ChatHistoryWidgetSettings
local UB1ChatHistoryWidget = {}



---@class UB1ChatWidget : UB1UserWidgetBase
---@field InputTextBox UEditableTextBox
local UB1ChatWidget = {}

---@param Text FText
---@param CommitMethod ETextCommit::Type
function UB1ChatWidget:OnInputTextCommitted(Text, CommitMethod) end


---@class UB1ChatbotTalkWidget : UB1UserWidgetBase
---@field BW_Panel_ChatHistory UB1ScrollBox
---@field BW_WBP_ChatHistory UB1ChatHistoryWidget
---@field BW_Text_Input UB1EditableText
---@field BW_Button_Send UB1Button
local UB1ChatbotTalkWidget = {}

---@param InText FText
---@param InCommitMethod ETextCommit::Type
function UB1ChatbotTalkWidget:BW_Text_Input_OnTextCommitted(InText, InCommitMethod) end


---@class UB1CheatListEntryWidget : UB1UserWidgetBase
---@field BW_Text UB1TextBlock
---@field BW_Button UB1Button
---@field BW_Image UB1Image
---@field BW_Slider UB1Slider
local UB1CheatListEntryWidget = {}



---@class UB1CheatManager : UCheatManager
local UB1CheatManager = {}

---@param InLocationStr FString
function UB1CheatManager:B1WalkToStr(InLocationStr) end
---@param InX float
---@param InY float
---@param InZ float
---@param InSelfObjectId FString
function UB1CheatManager:B1WalkTo(InX, InY, InZ, InSelfObjectId) end
function UB1CheatManager:B1VmcSystemEnable() end
function UB1CheatManager:B1VmcSystemDisable() end
function UB1CheatManager:B1VmcEnableCharacter() end
function UB1CheatManager:B1VmcDisableCharacter() end
function UB1CheatManager:B1VehicleSpawn() end
function UB1CheatManager:B1VehicleDespawn() end
---@param InUse boolean
function UB1CheatManager:B1Vehicle_UseHandBrake(InUse) end
function UB1CheatManager:B1UpdateAndSaveSiteAreaGridInfoAll() end
function UB1CheatManager:B1UpdateAndSaveSiteAreaGridInfo() end
---@param bOn boolean
function UB1CheatManager:B1Trait_DebugDetail(bOn) end
---@param SelfEntityId int64
---@param TargetEntityId int64
---@param InteractionBagId FName
function UB1CheatManager:B1ToSim_RequestInteraction(SelfEntityId, TargetEntityId, InteractionBagId) end
---@param Value float
function UB1CheatManager:B1TopViewWheelSpeedMultiply(Value) end
function UB1CheatManager:B1ToggleUI() end
function UB1CheatManager:B1ToggleReportUI() end
---@param InPostProcessVolumeName FString
function UB1CheatManager:B1TogglePostProcessVolume(InPostProcessVolumeName) end
---@param InMessage FString
---@param InLifeTime float
function UB1CheatManager:B1ToastEnqueue(InMessage, InLifeTime) end
---@param Speed int32
function UB1CheatManager:B1Time_SetTimeSpeed(Speed) end
---@param InReason FString
function UB1CheatManager:B1Time_RemovePauseReason(InReason) end
---@param InRealTimeForOneMinute int32
function UB1CheatManager:B1Time_RealSecondsToIngameMinuteRatio(InRealTimeForOneMinute) end
---@param InDay int32
---@param InHour int32
---@param InMinute int32
function UB1CheatManager:B1Time_AddTime(InDay, InHour, InMinute) end
---@param InReason FString
function UB1CheatManager:B1Time_AddPauseReason(InReason) end
---@param InTextId FString
function UB1CheatManager:B1TextId(InTextId) end
function UB1CheatManager:B1TeleportUnderCursor() end
---@param X float
---@param Y float
---@param Z float
---@param Yaw float
---@param SelfObjectId FString
function UB1CheatManager:B1TeleportRotate(X, Y, Z, Yaw, SelfObjectId) end
---@param InObjectId int64
---@param InStateGroupName FName
---@param InStateName FName
function UB1CheatManager:B1State_SetObjectState(InObjectId, InStateGroupName, InStateName) end
---@param InMapId FName
function UB1CheatManager:B1StartLevel(InMapId) end
---@param InSpeechBubbleId FName
function UB1CheatManager:B1SpeechBubble(InSpeechBubbleId) end
function UB1CheatManager:B1SpectateMode() end
---@param InShow boolean
function UB1CheatManager:B1ShowWallShadowMeshes(InShow) end
---@param bShow boolean
function UB1CheatManager:B1ShowTransparentWall(bShow) end
---@param bEnabled boolean
function UB1CheatManager:B1ShowPlayerMarker(bEnabled) end
function UB1CheatManager:B1ShowGameOption() end
---@param InEmotionId FName
function UB1CheatManager:B1ShowEmotionTooltipForce(InEmotionId) end
function UB1CheatManager:B1ShowBodyTrackingWidget() end
---@param AssetName FString
function UB1CheatManager:B1SetWeather(AssetName) end
---@param bInEnable boolean
---@param InMode int32
function UB1CheatManager:B1SetVisibleMesh(bInEnable, InMode) end
---@param InType FString
---@param InVisibility boolean
function UB1CheatManager:B1SetVisibilityAllConstructionByType(InType, InVisibility) end
---@param InModuleIndex int32
---@param InStairsType int32
function UB1CheatManager:B1SetStairsType(InModuleIndex, InStairsType) end
---@param InShadowQuality int32
function UB1CheatManager:B1SetShadowQuality(InShadowQuality) end
---@param bInEnable boolean
---@param InMode int32
function UB1CheatManager:B1SetRegisteredMesh(bInEnable, InMode) end
---@param Name FName
function UB1CheatManager:B1SetFacialExpression(Name) end
---@param MessageId FName
function UB1CheatManager:B1SetDoorPermissionMessage(MessageId) end
---@param InLanguage FString
function UB1CheatManager:B1SetCulture(InLanguage) end
---@param InMinTime int32
---@param InMaxTime int32
function UB1CheatManager:B1SetCrowdAutonomyTimeRange(InMinTime, InMaxTime) end
---@param InKey FString
---@param InValue FString
function UB1CheatManager:B1Sentry_AddTag(InKey, InValue) end
---@param InSenderId int64
---@param InReceiverId int64
---@param InRelationshipGiftDtId FName
function UB1CheatManager:B1SendGiftBox(InSenderId, InReceiverId, InRelationshipGiftDtId) end
---@param InAlertMessageId FName
function UB1CheatManager:B1SendDefaultPreferenceAlertMessage(InAlertMessageId) end
---@param InAlertType FName
function UB1CheatManager:B1SendDefaultAlertMessage(InAlertType) end
---@param SceneType int32
function UB1CheatManager:B1Scene_Push(SceneType) end
function UB1CheatManager:B1Scene_Pop() end
---@param InSaveSlotName FString
function UB1CheatManager:B1SaveSlot(InSaveSlotName) end
---@param InAssetName FString
function UB1CheatManager:B1SaveSitePreset(InAssetName) end
function UB1CheatManager:B1SaveNewDLDFile() end
---@param InAssetName FName
function UB1CheatManager:B1SaveCurrentRoomPreset(InAssetName) end
function UB1CheatManager:B1SaveCurrentRoom() end
---@param InAssetName FName
function UB1CheatManager:B1SaveCurrentPlatformPreset(InAssetName) end
function UB1CheatManager:B1RunStoredExcelCmd() end
function UB1CheatManager:B1ResetWeeklySchedule() end
function UB1CheatManager:B1ResetTodaySchedule() end
---@param InDayOfWeek int32
function UB1CheatManager:B1ResetDailySchedule(InDayOfWeek) end
function UB1CheatManager:B1RescueCharacter() end
function UB1CheatManager:B1ReportMetricJson() end
function UB1CheatManager:B1ReportMetric() end
---@param InObjectId int64
function UB1CheatManager:B1RemoveFamilyMemberByObjectId(InObjectId) end
---@param InFragmentId FName
function UB1CheatManager:B1RemoveDoorPermission(InFragmentId) end
---@param InFragmentId FName
---@param InConditionIndex int32
function UB1CheatManager:B1RemoveDoorCondition(InFragmentId, InConditionIndex) end
function UB1CheatManager:B1ReloadMod() end
---@param InFilename FString
function UB1CheatManager:B1ReloadDT(InFilename) end
function UB1CheatManager:B1ReleaseCache() end
---@param bDisable boolean
function UB1CheatManager:B1Relationship_StatDecayDisable(bDisable) end
---@param InVehicleDtId FName
function UB1CheatManager:B1RegisterNewVehicle(InVehicleDtId) end
function UB1CheatManager:B1RefreshSaveLoadList() end
function UB1CheatManager:B1ReduceLevelInstance() end
function UB1CheatManager:B1PSOCachesToSharedFolder() end
function UB1CheatManager:B1PrintWidgetState() end
function UB1CheatManager:B1PrintView() end
function UB1CheatManager:B1PrintSaveLoadConfig() end
function UB1CheatManager:B1PrintResolutions() end
function UB1CheatManager:B1PrintMonitorDevices() end
---@param InLOD uint8
function UB1CheatManager:B1PrintLODOfSites(InLOD) end
function UB1CheatManager:B1PrintInteractionConsumeCurrencyInfo() end
function UB1CheatManager:B1PrintGPUDevices() end
function UB1CheatManager:B1PrintAllSitesLODState() end
---@param InEntityId int64
function UB1CheatManager:B1PossessEntity(InEntityId) end
---@param InObjectId int64
function UB1CheatManager:B1Possess(InObjectId) end
---@param InVideoPlayerId FName
function UB1CheatManager:B1PlayVideoPlayer(InVideoPlayerId) end
---@param InStatName FName
---@param InAddValue float
function UB1CheatManager:B1PlayRelationshipScoreWidgetEffect(InStatName, InAddValue) end
---@param InLevelSequenceId FName
function UB1CheatManager:B1PlayLevelSequence(InLevelSequenceId) end
---@param IsEnable boolean
function UB1CheatManager:B1PackedLevelComponentDebug(IsEnable) end
---@param InWidgetName FString
function UB1CheatManager:B1OpenWidget(InWidgetName) end
---@param InURL FString
function UB1CheatManager:B1OpenSighWebBrowser(InURL) end
function UB1CheatManager:B1OpenSaveLoadWidget() end
function UB1CheatManager:B1OpenSaveAsWidget() end
---@param InEntityId int64
---@param InkeywordStr FString
function UB1CheatManager:B1OpenLogCustom(InEntityId, InkeywordStr) end
---@param InEntityId int64
function UB1CheatManager:B1OpenLogCompany(InEntityId) end
---@param InEntityId int64
function UB1CheatManager:B1OpenLog(InEntityId) end
---@param InIp FString
function UB1CheatManager:B1OpenLevel(InIp) end
---@param InPopupName FName
function UB1CheatManager:B1OpenCommonPopup(InPopupName) end
function UB1CheatManager:B1OpenCheatWiki() end
function UB1CheatManager:B1OpaqueBackgroundToggle() end
---@param bVisible boolean
function UB1CheatManager:B1OpaqueBackground(bVisible) end
---@param InMissionId int64
---@param IsComplete boolean
function UB1CheatManager:B1MissionCompleteByMissionId(InMissionId, IsComplete) end
---@param InMissionDtId FName
---@param IsComplete boolean
function UB1CheatManager:B1MissionCompleteByMissionDtId(InMissionDtId, IsComplete) end
function UB1CheatManager:B1MapMode() end
function UB1CheatManager:B1LogRunid() end
function UB1CheatManager:B1Loc() end
function UB1CheatManager:B1LobbyFirstTime() end
---@param InIndex int32
function UB1CheatManager:B1LobbyCalendarQuotation(InIndex) end
---@param InMonth int32
function UB1CheatManager:B1LobbyCalendarMonth(InMonth) end
---@param InDay int32
function UB1CheatManager:B1LobbyCalendarDay(InDay) end
---@param InPresetDataId FString
function UB1CheatManager:B1LoadSitePresetByDataId(InPresetDataId) end
---@param InPresetName FString
function UB1CheatManager:B1LoadSitePreset(InPresetName) end
---@param InAssetReference FName
function UB1CheatManager:B1LoadImage(InAssetReference) end
---@param bInIsReset boolean
function UB1CheatManager:B1ImportUserInputTextureFromPNG(bInIsReset) end
---@param InCheatLevel int32
---@param bIgnore boolean
function UB1CheatManager:B1IgnoreObjectPermission(InCheatLevel, bIgnore) end
---@param bInHide boolean
function UB1CheatManager:B1HideTrafficLightActor(bInHide) end
---@param bInHide boolean
function UB1CheatManager:B1HidePCGVolume(bInHide) end
---@param bInHide boolean
function UB1CheatManager:B1HidePackedLevelActor(bInHide) end
---@param bInHide boolean
function UB1CheatManager:B1HideFloor(bInHide) end
---@param bHidden boolean
function UB1CheatManager:B1HideAllStaticMeshComponents(bHidden) end
function UB1CheatManager:B1GetCursorWorldLocation() end
---@param IsEnable boolean
function UB1CheatManager:B1GameObjectSubMaterialDebug(IsEnable) end
function UB1CheatManager:B1GalleryAlertToast() end
function UB1CheatManager:B1FreeCameraLoc() end
---@param InLocAndRot FString
function UB1CheatManager:B1FreeCamera(InLocAndRot) end
---@param InLightType FName
---@param bOn boolean
function UB1CheatManager:B1ForceUpdateVehicleLightFlag(InLightType, bOn) end
---@param Value float
function UB1CheatManager:B1FollowViewWheelSpeedMultiply(Value) end
---@param Value float
function UB1CheatManager:B1FollowViewMouseSensitivityRate(Value) end
function UB1CheatManager:B1FlushCurrentCharStatLog() end
function UB1CheatManager:B1FamilyTreeTest() end
function UB1CheatManager:B1FamilyTreeSave() end
function UB1CheatManager:B1FamilyTreeLoad() end
function UB1CheatManager:B1FamilyMove() end
function UB1CheatManager:B1ExportVATObjectPosition() end
---@param Filename FString
function UB1CheatManager:B1ExportToGLTF(Filename) end
---@param InOwnerEntityId int64
---@param InPartnerEntityId int64
---@param InChildNum int64
function UB1CheatManager:B1ExportChildAppearanceSetting(InOwnerEntityId, InPartnerEntityId, InChildNum) end
function UB1CheatManager:B1ExportAppearanceSetting() end
---@param InFromCurrencyId FName
---@param InToCurrencyId FName
---@param InValue double
function UB1CheatManager:B1ExchangeCurrencyDebug(InFromCurrencyId, InToCurrencyId, InValue) end
---@param InCurrencyId FName
function UB1CheatManager:B1ExchangeAllCurrencyTo(InCurrencyId) end
---@param Cmd FString
function UB1CheatManager:B1ExcelCmd(Cmd) end
---@param bEnable boolean
function UB1CheatManager:B1EnableStreamingSource(bEnable) end
---@param bEnable boolean
function UB1CheatManager:B1EnableInGameLoading(bEnable) end
function UB1CheatManager:B1DRMCheckImmediately() end
function UB1CheatManager:B1DramaWidget() end
function UB1CheatManager:B1DLD_VideoToMotion() end
---@param InText FString
---@param InSpeakerId int32
---@param InEmotionId int32
function UB1CheatManager:B1DLD_TTS(InText, InSpeakerId, InEmotionId) end
function UB1CheatManager:B1DLD_CompleteVideoToMotion() end
function UB1CheatManager:B1DLD_CancelVideoToMotion() end
---@param bExceptPlayer boolean
function UB1CheatManager:B1DestroyAllSkeletalMeshes(bExceptPlayer) end
---@param InObjectIds FString
function UB1CheatManager:B1DestroyAllCharacterWithoutObjects(InObjectIds) end
function UB1CheatManager:B1DespawnAllGameObjects() end
---@param InType FString
function UB1CheatManager:B1DespawnAllConstructionByType(InType) end
function UB1CheatManager:B1DespawnAllConstruction() end
---@param PresetId FName
function UB1CheatManager:B1Custom_UsePreset(PresetId) end
---@param Type FName
---@param GarmentAssetPath FString
function UB1CheatManager:B1Custom_UseCustomGarment(Type, GarmentAssetPath) end
---@param bEnable boolean
function UB1CheatManager:B1Custom_TestMousePicking(bEnable) end
---@param bEnable boolean
function UB1CheatManager:B1Custom_TestMeshMasking(bEnable) end
function UB1CheatManager:B1Custom_TestMakeUpBake() end
---@param bEnable boolean
function UB1CheatManager:B1Custom_TestFaceCustomize(bEnable) end
---@param InTimeToNextAge float
function UB1CheatManager:B1Custom_StartAppearanceAging(InTimeToNextAge) end
---@param bUndressed boolean
function UB1CheatManager:B1Custom_SetUndressed(bUndressed) end
---@param BodySkinColorId FName
function UB1CheatManager:B1Custom_SetSkinColor(BodySkinColorId) end
---@param ChannelIndex int32
---@param RGB FString
function UB1CheatManager:B1Custom_SetNailColor(ChannelIndex, RGB) end
---@param MakeupParts FName
---@param Channel EB1MakeupChannel
---@param Index int32
---@param Value float
function UB1CheatManager:B1Custom_SetMakeupValue(MakeupParts, Channel, Index, Value) end
---@param MakeupParts FName
---@param Channel EB1MakeupChannel
---@param RGB FString
function UB1CheatManager:B1Custom_SetMakeupColor(MakeupParts, Channel, RGB) end
---@param MakeupParts FName
---@param MakeupId FName
function UB1CheatManager:B1Custom_SetMakeup(MakeupParts, MakeupId) end
---@param IrisSize float
---@param PupilSize float
---@param IrisColorBalance float
---@param IrisColorBalanceSmoothness float
function UB1CheatManager:B1Custom_SetIrisSize(IrisSize, PupilSize, IrisColorBalance, IrisColorBalanceSmoothness) end
---@param IrisPresetId FName
function UB1CheatManager:B1Custom_SetIrisPreset(IrisPresetId) end
---@param IrisColor FString
---@param IrisRimColor FString
function UB1CheatManager:B1Custom_SetIrisColor(IrisColor, IrisRimColor) end
---@param GreyingGene float
function UB1CheatManager:B1Custom_SetHairGreyingGene(GreyingGene) end
---@param CutRatio float
function UB1CheatManager:B1Custom_SetHairCut(CutRatio) end
---@param PartsName FName
---@param ChannelIndex int32
---@param RGB FString
function UB1CheatManager:B1Custom_SetGarmentColor(PartsName, ChannelIndex, RGB) end
---@param GroupName FName
---@param Value float
function UB1CheatManager:B1Custom_SetFaceShapeForName(GroupName, Value) end
---@param GroupIndex int32
---@param Value float
function UB1CheatManager:B1Custom_SetFaceShape(GroupIndex, Value) end
---@param FaceHairType FName
---@param RGB FString
function UB1CheatManager:B1Custom_SetFaceHairColor(FaceHairType, RGB) end
---@param FaceHairType FName
---@param FaceHairId FName
function UB1CheatManager:B1Custom_SetFaceHair(FaceHairType, FaceHairId) end
---@param AccessoryType FName
---@param AccessoryId FName
---@param AccessoryMeshId FName
function UB1CheatManager:B1Custom_SetAccessory(AccessoryType, AccessoryId, AccessoryMeshId) end
---@param SlotName FString
function UB1CheatManager:B1Custom_SaveData(SlotName) end
---@param Type FName
---@param PartId FName
function UB1CheatManager:B1Custom_RemoveGarmentPart(Type, PartId) end
---@param bEnable boolean
function UB1CheatManager:B1Custom_PlayIdleAnim(bEnable) end
function UB1CheatManager:B1Custom_NewData() end
---@param Type FString
function UB1CheatManager:B1Custom_ListData(Type) end
function UB1CheatManager:B1Custom_FixDataTable() end
---@param PresetId FString
function UB1CheatManager:B1Custom_ExportPreset(PresetId) end
function UB1CheatManager:B1Custom_DiscardData() end
---@param Type FName
---@param MeshId FName
function UB1CheatManager:B1Custom_ChangeGarmentMeshId(Type, MeshId) end
---@param HeadId FName
function UB1CheatManager:B1Custom_ChangeBaseHead(HeadId) end
---@param HairId FName
function UB1CheatManager:B1Custom_ChangeBaseHair(HairId) end
---@param InAge int32
function UB1CheatManager:B1Custom_ChangeAppearanceAge(InAge) end
---@param InOwnerEntityId int64
---@param InPartnerEntityId int64
---@param InGenderTypeStr FString
---@param InBodyTypeAge FString
function UB1CheatManager:B1Custom_ApplyGeneticAppearance(InOwnerEntityId, InPartnerEntityId, InGenderTypeStr, InBodyTypeAge) end
---@param Type FName
---@param PartId FName
function UB1CheatManager:B1Custom_AddGarmentPart(Type, PartId) end
---@param InIndex int32
function UB1CheatManager:B1CrashTest(InIndex) end
function UB1CheatManager:B1CopyMyLocEndpoint() end
function UB1CheatManager:B1CopyMyLoc() end
function UB1CheatManager:B1CompleteRandomPreferenceMission() end
---@param InWidgetName FString
function UB1CheatManager:B1CloseWidget(InWidgetName) end
function UB1CheatManager:B1ClearMetric() end
function UB1CheatManager:B1ClearDoorAllPermission() end
function UB1CheatManager:B1ClearCursor() end
function UB1CheatManager:B1ClearAllWallShadows() end
function UB1CheatManager:B1ClearAllPaintedWalls() end
---@param InSiteId FName
function UB1CheatManager:B1CheckoutAndSaveDefaultSpecificSite(InSiteId) end
function UB1CheatManager:B1CheckoutAndSaveDefaultSite() end
function UB1CheatManager:B1CheckNPrintObjectCullState() end
function UB1CheatManager:B1CheatWidget_RefreshTraitData() end
function UB1CheatManager:B1CheatWidget_RefreshTeleportSiteAreaData() end
function UB1CheatManager:B1CheatWidget_RefreshMissionData() end
function UB1CheatManager:B1CheatWidget_RefreshAgingData() end
---@param InVoiceId FName
function UB1CheatManager:B1ChangeVoice(InVoiceId) end
---@param InSpeed float
function UB1CheatManager:B1ChangeVehicleParam_SteeringRestoreSpeed(InSpeed) end
---@param InSeconds float
function UB1CheatManager:B1ChangeVehicleParam_SteeringDecelerationTime(InSeconds) end
---@param InDecelerationRate float
function UB1CheatManager:B1ChangeVehicleParam_SteeringDecelerationRate(InDecelerationRate) end
---@param InSeconds float
function UB1CheatManager:B1ChangeVehicleParam_MaxWheelRotateTime(InSeconds) end
---@param InSeconds float
function UB1CheatManager:B1ChangeVehicleParam_MaxWheelReturnRotateTime(InSeconds) end
---@param InMaxSpeed float
function UB1CheatManager:B1ChangeVehicleParam_MaxSpeed(InMaxSpeed) end
---@param InMaxAngle float
function UB1CheatManager:B1ChangeVehicleParam_MaxAngle(InMaxAngle) end
---@param InSpeed float
function UB1CheatManager:B1ChangeVehicleParam_AccelerationRestoreSpeed(InSpeed) end
---@param InEntityId int64
---@param InFloorLevel int32
function UB1CheatManager:B1ChangeObjectFloorLevel(InEntityId, InFloorLevel) end
---@param InTagName FName
---@param OffsetX float
---@param OffsetY float
function UB1CheatManager:B1ChangeLineCullingTagOffset(InTagName, OffsetX, OffsetY) end
---@param InTagName FName
---@param DirX float
---@param DirY float
function UB1CheatManager:B1ChangeLineCullingTagDirection(InTagName, DirX, DirY) end
---@param InGenderTypeStr FString
function UB1CheatManager:B1ChangeGender(InGenderTypeStr) end
---@param InCount int32
function UB1CheatManager:B1ChangeFamilyMemberMany(InCount) end
---@param InHouseholdId int64
function UB1CheatManager:B1ChangeFamily(InHouseholdId) end
---@param InCurrencyId FName
---@return boolean
function UB1CheatManager:B1ChangeCurrentMapCurrency(InCurrencyId) end
---@param InCurrencyId FName
function UB1CheatManager:B1ChangeCurrencyAndExchange(InCurrencyId) end
---@param InId FName
function UB1CheatManager:B1ChangeCityEdit(InId) end
---@param Type int32
function UB1CheatManager:B1ChangeCharacterNameFormatOption(Type) end
---@param Name FString
function UB1CheatManager:B1ChangeCharacter(Name) end
---@param Index int32
function UB1CheatManager:B1ChangeAvatar(Index) end
---@param InAge int32
function UB1CheatManager:B1ChangeAge(InAge) end
---@param IsEnable boolean
function UB1CheatManager:B1CameraCollisionEnable(IsEnable) end
---@param IsEnable boolean
---@param UniScale float
function UB1CheatManager:B1CameraCollisionDebug(IsEnable, UniScale) end
---@param alpha float
function UB1CheatManager:B1CameraCollisionAlpha(alpha) end
---@param Index int32
---@param IsSet boolean
function UB1CheatManager:B1CameraBookmark(Index, IsSet) end
function UB1CheatManager:B1BuildWorldTest() end
---@param InEnable boolean
function UB1CheatManager:B1BuildModeEnableWallSnap(InEnable) end
function UB1CheatManager:B1Autonomy_ToggleAutonomySystem() end
---@param bEnable boolean
function UB1CheatManager:B1Autonomy_EnableAutonomySystem(bEnable) end
---@param Enable int32
function UB1CheatManager:B1ApplyRagDoll(Enable) end
function UB1CheatManager:B1Anim_ToggleDebugInfo() end
---@param InModuleIndex int32
---@param InCount int32
function UB1CheatManager:B1AddStairsSize(InModuleIndex, InCount) end
---@param InSelfId int64
---@param InTargetId int64
---@param InInteractionBagId FName
function UB1CheatManager:B1AddSelfTargetInteraction(InSelfId, InTargetId, InInteractionBagId) end
---@param InteractionId FName
function UB1CheatManager:B1AddSelfInteraction(InteractionId) end
---@param InMessage FString
function UB1CheatManager:B1AddPsycatMessage(InMessage) end
---@param InObjectId int64
function UB1CheatManager:B1AddFamilyMemberByObjectId(InObjectId) end
---@param Name FString
function UB1CheatManager:B1AddFamilyMember(Name) end
---@param PresetId FName
function UB1CheatManager:B1AddDoorPermissionThroughPreset(PresetId) end
---@param InFragmentId FName
function UB1CheatManager:B1AddDoorPermission(InFragmentId) end


---@class UB1CheatWidget : UB1UserWidgetBase
---@field BW_HorizontalBox UB1HorizontalBox
---@field SlotWidgetClass TSubclassOf<UUserWidget>
---@field SlotPadding FVector2D
local UB1CheatWidget = {}



---@class UB1CheckItemEntryData : UObject
local UB1CheckItemEntryData = {}


---@class UB1CheckListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Button_CheckToggle UB1Button
---@field BW_Image_Check UB1Image
---@field BW_Text_CheckName UB1TextBlock
---@field Anim_Deselect UWidgetAnimation
---@field Anim_Select UWidgetAnimation
local UB1CheckListEntryWidget = {}



---@class UB1CheckListWidget : UB1UserWidgetBase
---@field BW_ListView_CheckList UB1ListView
---@field BW_Button_Close UB1Button
local UB1CheckListWidget = {}



---@class UB1ChoiceCardPopupWidget : UB1PopupWidgetBase
---@field BW_Image_BG_Color UB1Image
---@field BW_WBP_Portrait UB1PlayerPortraitWidget
---@field BW_Text_name UB1TextBlock
---@field BW_Image_Icon UB1Image
---@field BW_WidgetSwitcher_Button UB1WidgetSwitcher
---@field BW_Button_1 UB1Button
---@field BW_Button_2 UB1Button
---@field BW_ButtonText_1 UB1TextBlock
---@field BW_ButtonText_2 UB1TextBlock
---@field BW_WBP_ButtonConfirm UB1CommonButtonWidget
---@field BW_WidgetSwitcher_Desc UB1WidgetSwitcher
---@field BW_RichText_Title_Result UB1RichTextBlock
---@field BW_RichText_Desc_Result UB1RichTextBlock
---@field Anim_Result UWidgetAnimation
local UB1ChoiceCardPopupWidget = {}

function UB1ChoiceCardPopupWidget:OnFinishedResultAnimation() end


---@class UB1ChoiceCardUIHandler : UB1UIHandlerBase
local UB1ChoiceCardUIHandler = {}

function UB1ChoiceCardUIHandler:OnCloseChoiceCardPopup() end
---@param bIsPositive boolean
function UB1ChoiceCardUIHandler:OnAnswerSelected(bIsPositive) end


---@class UB1CityBalanceGraphListEntry : UB1UserListEntryWidgetBase
---@field BW_WidgetSwitcher_ChangeGraphType UB1WidgetSwitcher
---@field BW_ProgressBar_Graph UB1ProgressBar
local UB1CityBalanceGraphListEntry = {}



---@class UB1CityBalanceGraphListEntryInfo : UObject
---@field OriginValue int32
---@field Value float
---@field bIsGridLine boolean
local UB1CityBalanceGraphListEntryInfo = {}



---@class UB1CityBalanceGraphWidget : UB1UserWidgetBase
---@field BW_Text_Num UB1TextBlock
---@field BW_Image_Up UB1Image
---@field BW_Image_Down UB1Image
---@field BW_Text_ItemTitle UB1TextBlock
---@field BW_Graph_List UB1ListView
---@field BW_Text_Max UB1TextBlock
---@field BW_Image_Line_Max UB1Image
---@field ID FName
local UB1CityBalanceGraphWidget = {}



---@class UB1CityBalanceReportListEntryWidget : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Text_Title UB1TextBlock
---@field WBP_EnvironmentEcit_CityBalance_ReportItem UB1CityBalanceReportSubListEntryWidget
---@field BW_Button_More UB1Button
---@field BW_VerticalBox_SubReportItem UB1VerticalBox
---@field SubInfoList TArray<UB1CityBalanceReportSubListEntryWidget>
---@field Data FB1CityBalanceReportListEntryData
local UB1CityBalanceReportListEntryWidget = {}

function UB1CityBalanceReportListEntryWidget:OnClickedButton() end


---@class UB1CityBalanceReportSubListEntryWidget : UB1UserWidgetBase
---@field BW_Text_ItemTitle UB1TextBlock
---@field BW_Text_ItemNum UB1TextBlock
---@field Data FB1CityBalanceReportSubListEntryData
local UB1CityBalanceReportSubListEntryWidget = {}



---@class UB1CitySelectCityButtonWidget : UB1UserWidgetBase
---@field BW_Text_CityName UB1TextBlock
---@field BW_Button_City UB1Button
---@field Anim_Open UWidgetAnimation
---@field Anim_Hover UWidgetAnimation
---@field Anim_Select UWidgetAnimation
---@field Setting FB1CitySelectCityButtonWidget_Setting
local UB1CitySelectCityButtonWidget = {}

---@return boolean
function UB1CitySelectCityButtonWidget:IsSelected() end


---@class UB1CitySelectDescriptionWidget : UB1UserWidgetBase
---@field BW_Image UB1Image
---@field BW_Text_Explanation UB1TextBlock
---@field BW_Button_Confirm UB1Button
local UB1CitySelectDescriptionWidget = {}



---@class UB1CitySelectPortraitWidget : UB1UserWidgetBase
---@field Setting FB1CitySelectPortraitWidget_Setting
---@field BW_Widget_Root UWidget
---@field BW_Image_Portrait UB1Image
---@field BW_Image_ScreenShot UB1Image
local UB1CitySelectPortraitWidget = {}



---@class UB1CitySelectWidget : UB1UserWidgetBase
---@field BW_Button_Back UB1Button
---@field BW_WBP_Portrait UB1CitySelectPortraitWidget
---@field Anim_CityText0 UWidgetAnimation
---@field Anim_CityText1 UWidgetAnimation
---@field Anim_CityText2 UWidgetAnimation
local UB1CitySelectWidget = {}

---@param InName FName
function UB1CitySelectWidget:SetSelectedCity(InName) end


---@class UB1CleanlinessWidget : UB1UserWidgetBase
---@field BW_ProgressBar_CleanlinessNegative UB1ProgressBar
---@field BW_ProgressBar_CleanlinessPositive UB1ProgressBar
local UB1CleanlinessWidget = {}



---@class UB1ClothWeatheringComponent : UActorComponent
local UB1ClothWeatheringComponent = {}


---@class UB1CollisionLibrary : UBlueprintFunctionLibrary
local UB1CollisionLibrary = {}

---@param InStaticMeshComponents TArray<UStaticMeshComponent>
---@param OutMergedBox FCollisionBox
---@return boolean
function UB1CollisionLibrary:MergeBoxCollisions(InStaticMeshComponents, OutMergedBox) end


---@class UB1ColorPaletteEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_Image_Color UB1Image
local UB1ColorPaletteEntryWidget = {}



---@class UB1ColorPaletteItem : UObject
local UB1ColorPaletteItem = {}


---@class UB1ColorPaletteWidget : UB1UserWidgetBase
---@field BW_TileView UB1TileView
local UB1ColorPaletteWidget = {}



---@class UB1ColorPickerWidget : UB1UserWidgetBase
---@field B1Button_OriginColor UB1Button
---@field ColorText UB1EditableText
local UB1ColorPickerWidget = {}

---@param InColor FLinearColor
function UB1ColorPickerWidget:UpdateOriginalColor(InColor) end
---@param InColor FLinearColor
function UB1ColorPickerWidget:UpdateCurrentColor(InColor) end
function UB1ColorPickerWidget:OnEndChangeColor() end
---@param InText FText
---@param InCommitMethod ETextCommit::Type
function UB1ColorPickerWidget:OnColorTextCommitted(InText, InCommitMethod) end
---@param InColor FLinearColor
function UB1ColorPickerWidget:OnChangeColor(InColor) end
function UB1ColorPickerWidget:OnBeginChangeColor() end
---@return FLinearColor
function UB1ColorPickerWidget:GetPickerColor() end
function UB1ColorPickerWidget:B1Button_OriginColor_OnClicked() end


---@class UB1CommonButtonWidget : UB1UserWidgetBase
---@field OnClicked FB1CommonButtonWidgetOnClicked
---@field BW_SizeBox_Button UB1SizeBox
---@field BW_Image_DimmedBG UB1Image
---@field BW_Button UB1Button
---@field BW_Widget_TextContainer UWidget
---@field BW_Text UB1TextBlock
---@field BW_RichText UB1RichTextBlock
---@field BW_Image_Icon UB1Image
---@field WBP_Mobile_AppIcon_Alert UB1MobileAppAlertIconWidget
---@field B1Image_alert UB1Image
---@field ButtonType EB1ButtonType
---@field CommonText FText
---@field AlertText FText
---@field bIsDimmed boolean
---@field bUseDimmedBG boolean
---@field DimmedOpacity float
---@field bIsHighLight boolean
---@field bIsSimpleAlert boolean
---@field ButtonHoverAnim FB1WidgetAnimationData
---@field ButtonClickAnim FB1WidgetAnimationData
---@field HeightOverride float
---@field MinDesiredWidth float
---@field MaxDesiredWidth float
---@field bUseIcon boolean
---@field IconBrush FSlateBrush
---@field IconColorAndOpacity FLinearColor
---@field TextSetting FB1CommonButtonTextSetting
---@field WidgetListToClose TArray<EB1UIType>
local UB1CommonButtonWidget = {}



---@class UB1CommonBuyPopupWidget : UB1PopupWidgetBase
---@field Canvas_Panel_donut UB1VerticalBox
---@field Size_Box_price UB1SizeBox
---@field Image_Icon UB1Image
---@field Text_name UB1TextBlock
---@field Image_coin UB1Image
---@field Text_price UB1TextBlock
---@field Text_description UB1TextBlock
---@field BW_HorizontalBox_Button UB1HorizontalBox
local UB1CommonBuyPopupWidget = {}



---@class UB1CommonCatAlertWidget : UB1UserWidgetBase
---@field BW_Panel_Tooltip UWidget
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Message UB1TextBlock
---@field BW_RichText_Title UB1RichTextBlock
---@field BW_RichText_Message UB1RichTextBlock
---@field BW_Button_Delete UB1Button
---@field BW_VerticalBox_Link UB1VerticalBox
---@field BW_Button_Link UB1Button
---@field BW_Text_Link UB1TextBlock
---@field BW_Tooltip_Arrow_Down UB1Image
---@field LinkUIType EB1UIType
local UB1CommonCatAlertWidget = {}



---@class UB1CommonCheckWidget : UB1UserWidgetBase
local UB1CommonCheckWidget = {}


---@class UB1CommonDreamBubbleWidget : UB1UserWidgetBase
---@field BW_CanvasPanel_DreamBubblePanel UB1CanvasPanel
---@field BW_Image_Icon_First UB1Image
---@field BW_Image_Icon_Second UB1Image
local UB1CommonDreamBubbleWidget = {}



---@class UB1CommonFilterClearAllButtonWidget : UB1UserWidgetBase
---@field BW_Button_ClearAll UB1Button
local UB1CommonFilterClearAllButtonWidget = {}



---@class UB1CommonFilterEntryData : UObject
---@field TagList TArray<UB1CommonTagEntryData>
local UB1CommonFilterEntryData = {}



---@class UB1CommonFilterListCheckBoxWidget : UB1UserListEntryWidgetBase2
---@field BW_WidgetSwitcher_CheckBox UB1WidgetSwitcher
---@field BW_CheckBox_Option_0 UB1CheckBox
---@field BW_CheckBox_Option_1 UB1CheckBox
---@field BW_WBP_Text_0 UB1CommonFilterListEntryTextWidget
---@field BW_WBP_Text_1 UB1CommonFilterListEntryTextWidget
local UB1CommonFilterListCheckBoxWidget = {}



---@class UB1CommonFilterListEntryTempWidget : UB1UserListEntryWidgetBase2
---@field BW_CheckBox UB1CheckBox
---@field BW_Text UB1TextBlock
---@field Text FText
local UB1CommonFilterListEntryTempWidget = {}



---@class UB1CommonFilterListEntryTextWidget : UB1UserListEntryWidgetBase
---@field BW_WidgetSwitcher_Text UB1WidgetSwitcher
---@field BW_Text_0 UB1TextBlock
---@field BW_Text_1 UB1TextBlock
---@field BW_Text_2 UB1TextBlock
---@field BW_Text_3 UB1TextBlock
local UB1CommonFilterListEntryTextWidget = {}



---@class UB1CommonFilterListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_CheckBox UB1CheckBox
---@field BW_Text UB1TextBlock
---@field Text FText
local UB1CommonFilterListEntryWidget = {}



---@class UB1CommonFilterListTitleWidget : UB1UserListEntryWidgetBase
---@field BW_Text_WhiteTitle UB1TextBlock
---@field BW_Text_BlackTitle UB1TextBlock
---@field BW_Button_Title UB1Button
---@field BW_WidgetSwitcher_Title UB1WidgetSwitcher
---@field BW_Image_WhiteArrow UB1Image
---@field BW_Image_BlackArrow UB1Image
local UB1CommonFilterListTitleWidget = {}



---@class UB1CommonFilterListWrapperWidget : UB1UserListEntryWidgetBase2
---@field BW_WBP_Title UB1CommonFilterListTitleWidget
---@field BW_ListView_CheckList UB1ListView
local UB1CommonFilterListWrapperWidget = {}



---@class UB1CommonFilterWidget : UB1UserWidgetBase
---@field ColorType EB1CommonFilterColorType
---@field WidthOverride float
---@field HeightOverride float
---@field MinDesiredWidth float
---@field MinDesiredHeight float
---@field MaxDesiredWidth float
---@field MaxDesiredHeight float
---@field MinAspectRatio float
---@field MaxAspectRatio float
---@field BW_WBP_ClearAll UB1CommonFilterClearAllButtonWidget
---@field BW_ListView_CheckList UB1ListView
---@field BW_WidgetSwitcher_BG UB1WidgetSwitcher
---@field BW_SizeBox UB1SizeBox
local UB1CommonFilterWidget = {}



---@class UB1CommonNameEditableText : UB1UserWidgetBase
---@field BW_WidgetSwitcher_TextMode UB1WidgetSwitcher
---@field BW_Text_name UB1TextBlock
---@field BW_Image_TagError UB1Image
---@field BW_Button_OK UB1Button
---@field BW_EditableText_Name UB1EditableText
---@field BW_Button_Edit UB1CommonButtonWidget
---@field BW_Text_Error_Over UB1TextBlock
---@field BW_Text_Error_SpecialCase UB1TextBlock
local UB1CommonNameEditableText = {}

---@param InText FText
---@param CommitMethod ETextCommit::Type
function UB1CommonNameEditableText:BW_EditableText_Name_OnTextEntered(InText, CommitMethod) end
---@param InText FText
function UB1CommonNameEditableText:BW_EditableText_Name_OnTextChanged(InText) end
function UB1CommonNameEditableText:BW_Button_Ok_OnClicked() end
function UB1CommonNameEditableText:BW_Button_Edit_OnClicked() end


---@class UB1CommonPopupWidget : UB1PopupWidgetBase
---@field BW_HorizontalBox_Button UB1HorizontalBox
---@field BW_Button_Optional_Close UB1Button
---@field BW_Image_Overlay UB1Image
local UB1CommonPopupWidget = {}



---@class UB1CommonSliderWidget : UB1UserWidgetBase
---@field BW_Slider_Value USlider
local UB1CommonSliderWidget = {}

---@param InValue float
function UB1CommonSliderWidget:OnSliderValueChanged(InValue) end


---@class UB1CommonSortOrderEntryData : UObject
local UB1CommonSortOrderEntryData = {}


---@class UB1CommonSortWidget : UB1UserWidgetBase
---@field ColorType EB1CommonFilterColorType
---@field WidthOverride float
---@field HeightOverride float
---@field MinDesiredWidth float
---@field MinDesiredHeight float
---@field MaxDesiredWidth float
---@field MaxDesiredHeight float
---@field MinAspectRatio float
---@field MaxAspectRatio float
---@field BW_ListView_CheckList UB1ListView
---@field BW_WidgetSwitcher_BG UB1WidgetSwitcher
---@field BW_SizeBox UB1SizeBox
local UB1CommonSortWidget = {}



---@class UB1CommonTagEntryData : UObject
local UB1CommonTagEntryData = {}


---@class UB1CommonTextColorPickerPopupWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Overlay_Reset UB1Overlay
---@field BW_Button_Reset UB1CommonButtonWidget
---@field BW_WBP_ColorPalette UB1ColorPaletteWidget
---@field BW_WBP_BuildCustomizeColorPalette UB1BuildCustomizeColorPalette
---@field BW_WBP_ColorPicker UB1ColorPickerWidget
---@field BW_CheckBox_MatchBodyHairColor UB1CheckBox
---@field BW_Panel_ColorPicker UWidget
---@field BW_Widget_Separator_0 UWidget
---@field BW_WidgetSwitcher_ColorChange UWidget
---@field ColorPickerPopupType EB1ColorPickerPopupType
---@field SliderSize FVector2D
local UB1CommonTextColorPickerPopupWidget = {}



---@class UB1CommonTextColorPickerWidget : UB1UserWidgetBase
---@field BW_Text_Label UB1TextBlock
---@field BW_Button_Color UB1Button
---@field BW_Image_Color UB1Image
---@field Label FText
local UB1CommonTextColorPickerWidget = {}



---@class UB1CommonTextSpinBoxWidget : UB1UserWidgetBase
---@field BW_Text_Label UB1TextBlock
---@field BW_Text_Value UB1TextBlock
---@field BW_Button_Prev UB1Button
---@field BW_Button_Next UB1Button
---@field Label FText
local UB1CommonTextSpinBoxWidget = {}



---@class UB1CommonTitleWidget : UB1UserWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Button_Back UB1Button
---@field TitleText FText
---@field WidgetListToClose TArray<EB1UIType>
---@field OnClickedButtonBack FB1CommonTitleWidgetOnClickedButtonBack
local UB1CommonTitleWidget = {}



---@class UB1CoopSelectUIHandler : UB1UIHandlerBase
---@field SelfEntityId FB1EntityId
local UB1CoopSelectUIHandler = {}



---@class UB1CoopUIHandler : UB1UIHandlerBase
local UB1CoopUIHandler = {}


---@class UB1CostumeEdit3DPrinterWidget : UB1UserWidgetBase
---@field BW_Button_Select UB1Button
local UB1CostumeEdit3DPrinterWidget = {}



---@class UB1CostumeEditListWidget : UB1UserWidgetBase
---@field BW_WBP_3DPrinter UB1CostumeEdit3DPrinterWidget
---@field BW_TileView_List UB1TileView
---@field BW_Button_Close UB1Button
---@field BW_Text_Title UB1TextBlock
local UB1CostumeEditListWidget = {}



---@class UB1CraftingCategoryListEntryData : UObject
local UB1CraftingCategoryListEntryData = {}


---@class UB1CraftingCategoryListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_name UB1TextBlock
---@field BW_Button_Category UB1Button
local UB1CraftingCategoryListEntryWidget = {}



---@class UB1CraftingIngredientListEntryData : UObject
local UB1CraftingIngredientListEntryData = {}


---@class UB1CraftingIngredientListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Object UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_Text_Stock UB1TextBlock
---@field BW_Text_Slash UB1TextBlock
---@field BW_Text_Need UB1TextBlock
local UB1CraftingIngredientListEntryWidget = {}



---@class UB1CraftingNamingWidget : UB1UserWidgetBase
---@field BW_Image_Thumbnail UB1Image
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Num_Title UB1TextBlock
---@field BW_EditableTextBox_Title UB1EditableTextBox
---@field BW_Image_TitleError UB1Image
---@field BW_Text_Content UB1TextBlock
---@field BW_MultiLineEditableTextBox_Content UB1MultiLineEditableTextBox
---@field BW_Text_Num_Content UB1TextBlock
---@field BW_Image_ContentError UB1Image
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Save UB1CommonButtonWidget
local UB1CraftingNamingWidget = {}

---@param InText FText
---@param InCommitMethod ETextCommit::Type
function UB1CraftingNamingWidget:OnTextCommitted_Title(InText, InCommitMethod) end
---@param InText FText
---@param InCommitMethod ETextCommit::Type
function UB1CraftingNamingWidget:OnTextCommitted_Content(InText, InCommitMethod) end
---@param InText FText
function UB1CraftingNamingWidget:OnTextChanged_Title(InText) end
---@param InText FText
function UB1CraftingNamingWidget:OnTextChanged_Content(InText) end


---@class UB1CraftingProgressBarWidget : UB1UserWidgetBase
---@field BW_Text_ProgressPercent UB1TextBlock
---@field BW_ProgressBar_Progress UB1ProgressBar
local UB1CraftingProgressBarWidget = {}



---@class UB1CraftingRecipeListEntryData : UObject
local UB1CraftingRecipeListEntryData = {}


---@class UB1CraftingRecipeListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Color_1 UB1Image
---@field BW_Image_Color_2 UB1Image
---@field BW_Image_BG_Hover UB1Image
---@field BW_Image_Thumbnail UB1Image
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_LvText UB1TextBlock
---@field BW_Text_LvNum UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Button_Hover UB1Button
---@field BW_CanvasPanel_Lock UB1Overlay
---@field BW_HorizontalBox_Lv UB1HorizontalBox
---@field BW_Overlay_New UB1Overlay
---@field BW_Overlay_Button UB1Overlay
---@field BW_WBP_ProgressBar UB1CraftingProgressBarWidget
---@field BW_Button_Delete UB1CommonButtonWidget
---@field BW_Button_Publish UB1CommonButtonWidget
---@field BW_Button_Continue UB1CommonButtonWidget
---@field BW_WidgetSwitcher_Bottom UB1WidgetSwitcher
local UB1CraftingRecipeListEntryWidget = {}



---@class UB1CraftingRecipeListWidget : UB1UserWidgetBase
---@field BW_HorizontalBox_Level UB1HorizontalBox
---@field BW_Text_LevelText UB1TextBlock
---@field BW_Text_LevelNum UB1TextBlock
---@field BW_TileView_RecipeList UB1TileView
local UB1CraftingRecipeListWidget = {}



---@class UB1CraftingUIHandler : UB1UIHandlerBase
---@field PrevClickedRecipeEntryWidget TWeakObjectPtr<UB1CraftingRecipeListEntryWidget>
---@field CraftingWidget UB1CraftingWidget
---@field CraftingNamingWidget UB1CraftingNamingWidget
local UB1CraftingUIHandler = {}



---@class UB1CraftingWidget : UB1UserWidgetBase
---@field BW_Text_CraftingTitle UB1TextBlock
---@field BW_Text_CraftingDesc UB1TextBlock
---@field BW_Button_Close UB1Button
---@field BW_ListView_Category UB1ListView
---@field BW_WBP_PlayerPortrait UB1PlayerPortraitWidget
---@field BW_Image_SkillIcon UB1Image
---@field BW_Text_SkillTitle UB1TextBlock
---@field BW_Text_Level UB1TextBlock
---@field BW_WBP_SkillProgressBar UB1SkillProgressBarWidget
---@field BW_Overlay_Currency UB1Overlay
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_DynamicEntryBox_RecipeList UB1DynamicEntryBox
local UB1CraftingWidget = {}



---@class UB1CurrencyChangeEffectWidget : UB1UserWidgetBase
---@field BW_CanvasPanelOverlay UB1CanvasPanel
---@field BW_WidgetSwitcher_GoldChange UB1WidgetSwitcher
---@field WBP_Common_PlayerPortrait UB1PlayerPortraitWidget
---@field BW_WBP_CurrencyAdd UB1CurrencyWidget
---@field BW_Image_Highlight_CurrencyAdd UB1Image
---@field BW_Text_Sign_CurrencyAdd UB1TextBlock
---@field BW_WBP_CurrencySubtract UB1CurrencyWidget
---@field BW_Image_Highlight_CurrencySubtract UB1Image
---@field BW_Text_Sign_CurrencySubtract UB1TextBlock
local UB1CurrencyChangeEffectWidget = {}

---@param InPosition FVector2D
function UB1CurrencyChangeEffectWidget:SpawnOnWidget(InPosition) end
---@param InTarget AActor
function UB1CurrencyChangeEffectWidget:SpawnOnTarget(InTarget) end
---@param InLocation FVector
function UB1CurrencyChangeEffectWidget:SpawnOnLocation(InLocation) end
---@param InCurrencyId FName
---@param InValue int32
---@param InOwnerId FB1EntityId
function UB1CurrencyChangeEffectWidget:SetData(InCurrencyId, InValue, InOwnerId) end
function UB1CurrencyChangeEffectWidget:PlayEffectAnimation() end
function UB1CurrencyChangeEffectWidget:ConfigUI() end


---@class UB1CurrencyUIHandler : UB1UIHandlerBase
---@field CurrencyChangeEffectWidgetClass TSubclassOf<UUserWidget>
local UB1CurrencyUIHandler = {}



---@class UB1CurrencyWidget : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Image_Infinite UB1Image
---@field BW_Text_Value UB1TextBlock
---@field BW_WidgetSwitcher_Currency UB1WidgetSwitcher
---@field Type EB1CurrencyWidgetType
---@field TintColor FSlateColor
---@field IconSize FVector2D
---@field Font FSlateFontInfo
---@field TextPadding FMargin
local UB1CurrencyWidget = {}



---@class UB1CursorActorInfoWidget : UB1UserWidgetBase
---@field BW_Widget_Root UWidget
---@field BW_Text_name UB1TextBlock
---@field BW_PriceHorizontal_Box UB1HorizontalBox
---@field BW_Currency UB1CurrencyWidget
---@field ActualCursorSize FVector2D
local UB1CursorActorInfoWidget = {}



---@class UB1CustomCharacterAnimInstance : UB1AnimInstance
---@field AnimSequenceAlpha UAnimSequence
---@field AnimSequenceBeta UAnimSequence
---@field BlendSwitch boolean
---@field LookAtSpeed float
---@field LookAtPitchLimit FVector2D
---@field LookAtYawLimit FVector2D
---@field bUseLookAt boolean
---@field HeadLookAt FVector2D
---@field bLiveLinkEnabled boolean
---@field LiveLinkSubjectName FLiveLinkSubjectName
---@field LiveLinkHeadRotation FRotator
---@field bNeedResetAnimSequenceAlphaTime boolean
---@field bNeedResetAnimSequenceBetaTime boolean
local UB1CustomCharacterAnimInstance = {}



---@class UB1CustomHeadAnimInstance : UB1AnimInstance
---@field bIsAnyMontagePlaying boolean
---@field FacePoseAnimSequenceAlpha TWeakObjectPtr<UAnimSequence>
---@field FacePoseAnimSequenceBeta TWeakObjectPtr<UAnimSequence>
---@field BlendAlpha float
---@field BlendSwitch boolean
---@field bLiveLinkEnabled boolean
---@field LiveLinkSubjectName FLiveLinkSubjectName
---@field LiveLinkHeadRotation FRotator
local UB1CustomHeadAnimInstance = {}



---@class UB1CustomShapeButton : UB1UserWidgetBase
---@field ButtonNormalImage UTexture2D
---@field ButtonNormalColor FLinearColor
---@field ButtonHoverImage UTexture2D
---@field ButtonHoverColor FLinearColor
---@field ButtonClickImage UTexture2D
---@field ButtonClickColor FLinearColor
---@field BW_CanvasPanel UB1CanvasPanel
---@field BW_ButtonImage UB1Image
local UB1CustomShapeButton = {}



---@class UB1CustomizeButtonTool : UB1UserWidgetBase
---@field BW_Button UB1Button
---@field Icon TSoftObjectPtr<UTexture2D>
local UB1CustomizeButtonTool = {}

---@param InSelected boolean
function UB1CustomizeButtonTool:OnSelectButton(InSelected) end


---@class UB1CustomizeDataManager : UB1ManagerBase
---@field CustomizeData UB1CustomizeSaveData
local UB1CustomizeDataManager = {}



---@class UB1CustomizeFaceEditTabWidget : UB1UserWidgetBase
---@field BW_Button_GroupEdit UB1Button
---@field BW_Button_DetailEdit UB1Button
local UB1CustomizeFaceEditTabWidget = {}



---@class UB1CustomizeListGarmentIdEntry : UObject
local UB1CustomizeListGarmentIdEntry = {}


---@class UB1CustomizeSaveData : USaveGame
---@field SlotName FString
---@field CustomHeads TMap<FString, FB1HeadDescription>
---@field CustomBodies TMap<FString, FB1BodyDescription>
---@field CustomGarments TMap<FString, FB1GarmentDescription>
---@field CustomPrintedAccessories TMap<FString, FB1PrintedAccessoryDescription>
---@field PaletteColors TArray<FLinearColor>
local UB1CustomizeSaveData = {}



---@class UB1DLDDataAsset : UB1DataAssetBase
---@field RecommendedVersion int32
---@field VideoMemoryLimit int64
---@field NotSupportedGPUs TArray<FName>
---@field DiffusionTextEncoderONNX TSoftObjectPtr<UObject>
---@field DiffusionTextEncoderONNXPath FFilePath
---@field DiffusionUnetONNX TSoftObjectPtr<UObject>
---@field DiffusionUnetONNXPath FFilePath
---@field DiffusionVaeDecoderONNX TSoftObjectPtr<UObject>
---@field DiffusionVaeDecoderONNXPath FFilePath
---@field DiffusionMobileNetONNX TSoftObjectPtr<UObject>
---@field DiffusionMobileNetONNXPath FFilePath
---@field DiffusionTokenizerBPEMerge TSoftObjectPtr<UDataTable>
---@field DiffusionTokenizerVocab TSoftObjectPtr<UDataTable>
---@field DiffusionTokenizerVocabBlacklist TSoftObjectPtr<UDataTable>
---@field TTSONNX TSoftObjectPtr<UObject>
---@field NSFWDetectorONNX TSoftObjectPtr<UObject>
---@field SafetyCheckONNX TSoftObjectPtr<UObject>
---@field TextEmbeddingONNX TSoftObjectPtr<UObject>
---@field TextEmbeddingSentencePiece TSoftObjectPtr<UObject>
---@field V2MBoneMapping TMap<FName, FName>
---@field Media2MotionPersonDetectorONNX TSoftObjectPtr<UObject>
---@field Media2MotionPersonDetectorONNXPath FFilePath
---@field Media2MotionPoseEstimatorONNX TSoftObjectPtr<UObject>
---@field Media2MotionPoseEstimatorONNXPath FFilePath
---@field HandSolverProgramFolderEditorPath FFilePath
---@field HandSolverProgramFolderPath FFilePath
---@field V2MBaseActorClassPath FSoftClassPath
---@field V2MRetargeter TSoftObjectPtr<UObject>
---@field EndMotionGenerationPopupId FName
---@field ChangeMotionGenerationModePopupId FName
---@field AIMotionTooltipButtonThumbnailTextId FString
---@field MaxGeneratedMotionNum int32
---@field TotalPlayLength float
---@field GroundHeightMargin float
---@field FailedGenerateMotionTextId FString
---@field CanceledGenerateMotionTextId FString
---@field Img2MeshU2NetONNX TSoftObjectPtr<UObject>
---@field Img2MeshU2NetONNXPath FFilePath
---@field Img2MeshEncoderONNX TSoftObjectPtr<UObject>
---@field Img2MeshEncoderONNXPath FFilePath
---@field Img2MeshQueryModelONNX TSoftObjectPtr<UObject>
---@field Img2MeshQueryModelONNXPath FFilePath
---@field PostProcessFolderEditorPath FFilePath
---@field PostProcessFolderPath FFilePath
local UB1DLDDataAsset = {}



---@class UB1DLDFileManager : UB1ManagerBase
local UB1DLDFileManager = {}


---@class UB1DLDImageTo3D : UObject
---@field ImageTo3DRequester UObject
---@field Img2MeshU2NetONNX UObject
---@field Img2MeshEncoderONNX UObject
---@field Img2MeshQueryModelONNX UObject
local UB1DLDImageTo3D = {}



---@class UB1DLDMediaToMotion : UObject
---@field Media2MotionRequester UObject
---@field Media2MotionPersonDetectorONNX UObject
---@field Media2MotionPoseEstimatorONNX UObject
local UB1DLDMediaToMotion = {}



---@class UB1DLDMeshSymmetry : UObject
---@field MeshSymmetryRequester UObject
local UB1DLDMeshSymmetry = {}



---@class UB1DLDNSFWDetector : UObject
---@field Requester UObject
---@field ONNX UObject
local UB1DLDNSFWDetector = {}



---@class UB1DLDRequestManager : UB1ManagerBase
---@field StableDiffusion UB1DLDStableDiffusion
---@field TTS UB1DLDTTS
---@field NSFWDetector UB1DLDNSFWDetector
---@field SafetyCheck UB1DLDSafetyCheck
---@field TextEmbeddingRequester UB1DLDTextEmbeddingRequester
---@field MediaToMotion UB1DLDMediaToMotion
---@field ImageTo3D UB1DLDImageTo3D
---@field MeshSymmetry UB1DLDMeshSymmetry
local UB1DLDRequestManager = {}



---@class UB1DLDSafetyCheck : UObject
---@field Requester UObject
---@field ONNX UObject
local UB1DLDSafetyCheck = {}



---@class UB1DLDStableDiffusion : UObject
---@field DiffusionRequester UObject
---@field DiffusionTextEncoderONNX UObject
---@field DiffusionUnetONNX UObject
---@field DiffusionVaeDecoderONNX UObject
---@field DiffusionMobileNetONNX UObject
---@field DiffusionTokenizerBPEMerge UDataTable
---@field DiffusionTokenizerVocab UDataTable
---@field DiffusionTokenizerVocabBlacklist UDataTable
local UB1DLDStableDiffusion = {}



---@class UB1DLDTTS : UObject
---@field TTSRequester UObject
---@field TTSONNX UObject
local UB1DLDTTS = {}



---@class UB1DLDTextEmbeddingRequester : UObject
---@field TextEmbeddingONNX UObject
---@field TextEmbeddingRequester UObject
local UB1DLDTextEmbeddingRequester = {}



---@class UB1DPICustomScalingRule : UDPICustomScalingRule
local UB1DPICustomScalingRule = {}


---@class UB1DataCacheManager : UB1ManagerBase
---@field StateVariationByObjectId TMap<FName, FB1StateVariationArray>
---@field CachedAssets TArray<TSoftObjectPtr<UObject>>
local UB1DataCacheManager = {}



---@class UB1DataLogManager : UB1ManagerBase
---@field WorldDailyLogList TMap<FName, FB1DailyLogList>
local UB1DataLogManager = {}



---@class UB1DayNightSilderWidget : UB1UserWidgetBase
---@field BW_Slider_DayNight UB1Slider
local UB1DayNightSilderWidget = {}



---@class UB1DebugConfig : UObject
local UB1DebugConfig = {}


---@class UB1DebugDrawStringComponent : UDebugDrawComponent
local UB1DebugDrawStringComponent = {}


---@class UB1DebugEntityEntryWidget : UB1UserWidgetBase
---@field BW_Image UB1Image
local UB1DebugEntityEntryWidget = {}



---@class UB1DebugEntityWidget : UB1UserWidgetBase
---@field BW_Canvas UB1CanvasPanel
---@field EntryWidgetClass TSubclassOf<UB1DebugEntityEntryWidget>
---@field EntityTypeToIconMap TMap<EB1DebugEntityType, TSoftObjectPtr<UTexture2D>>
local UB1DebugEntityWidget = {}



---@class UB1DebugMessageUIHandler : UB1UIHandlerBase
local UB1DebugMessageUIHandler = {}


---@class UB1DebugMessageWidget : UB1UserWidgetBase
---@field CanvasPanel UB1CanvasPanel
---@field TextBlock UB1TextBlock
local UB1DebugMessageWidget = {}



---@class UB1DebugOptions : UObject
---@field DebugMovement int32
---@field DebugUI int32
---@field DebugBuildMode int32
---@field DebugObject int32
---@field DebugLod int32
---@field DebugStatReward int32
---@field DebugStatReward2 int32
---@field DebugFollowViewWallCollision int32
---@field DebugEntity int32
---@field DebugSLM int32
---@field DebugMoveTickOptimize int32
---@field DebugMoveTick float
---@field DebugClothWeathering int32
---@field DebugHairCloth int32
---@field DebugIgnoreBuildModeBuyCondition int32
---@field DebugInteractionBagRatio int32
---@field DebugDisableSellEffect int32
---@field DebugCameraGameOptionPreset int32
---@field DebugTimeScale int32
---@field DebugOutfit int32
---@field DebugGarmentTag int32
local UB1DebugOptions = {}



---@class UB1DefaultBuildPresetManager : UB1MyGalleryManager
---@field LoadedDataAssetMap TMap<FString, UB1BuildDefaultPresetAssetBase>
local UB1DefaultBuildPresetManager = {}



---@class UB1DefaultToolTipWidget : UB1TooltipWidgetBase
---@field BW_RichText UB1RichTextBlock
local UB1DefaultToolTipWidget = {}



---@class UB1DisclaimerWidget : UB1UserWidgetBase
---@field BW_Widget_NvidiaRTX UWidget
---@field BW_Widget_NvidiaGeForceNow UWidget
local UB1DisclaimerWidget = {}



---@class UB1DlcSubsystem : UGameInstanceSubsystem
local UB1DlcSubsystem = {}


---@class UB1DoorPermissionUIHandler : UB1UIHandlerBase
---@field CurrentSelections TArray<UB1ObjectSelectionData>
local UB1DoorPermissionUIHandler = {}

---@param Object UObject
function UB1DoorPermissionUIHandler:OnListEntrySelected(Object) end


---@class UB1DragGuideWidget : UB1UserWidgetBase
---@field BW_Widget_CannotDragArea UWidget
local UB1DragGuideWidget = {}



---@class UB1DramaPopupInputFieldWidget : UB1UserWidgetBase
---@field BW_EditableTextBox UB1EditableTextBox
---@field BW_Image_ErrorBG UB1Image
---@field BW_Button_Random UB1CommonButtonWidget
local UB1DramaPopupInputFieldWidget = {}

---@param InText FText
---@param InCommitMethod ETextCommit::Type
function UB1DramaPopupInputFieldWidget:OnTextCommitted(InText, InCommitMethod) end
---@param InText FText
function UB1DramaPopupInputFieldWidget:OnTextChanged(InText) end
function UB1DramaPopupInputFieldWidget:OnRandomButtonClicked() end


---@class UB1DramaPopupNameEditWidget : UB1UserWidgetBase
---@field BW_Image_GenderIcon UB1Image
---@field BW_WBP_NameAreaLeft UB1DramaPopupInputFieldWidget
---@field BW_WBP_NameAreaRight UB1DramaPopupInputFieldWidget
---@field BW_Text_Error_Over UB1TextBlock
---@field BW_Text_Error_SpecialCase UB1TextBlock
local UB1DramaPopupNameEditWidget = {}

---@param InText FText
function UB1DramaPopupNameEditWidget:OnRightTextChanged(InText) end
function UB1DramaPopupNameEditWidget:OnRightRandomButtonClicked() end
---@param InText FText
function UB1DramaPopupNameEditWidget:OnLeftTextChanged(InText) end
function UB1DramaPopupNameEditWidget:OnLeftRandomButtonClicked() end


---@class UB1DramaPopupWidget : UB1PopupWidgetBase
---@field Button_TimeMachine UB1CommonButtonWidget
---@field Image_Icon UB1Image
---@field Image_Portrait UB1Image
---@field Image_PanelBG UB1Image
---@field GridPanel_Celebrate UB1GridPanel
---@field B1Vertical_ButtonBox UB1VerticalBox
---@field BW_WBP_NameEdit UB1DramaPopupNameEditWidget
local UB1DramaPopupWidget = {}

function UB1DramaPopupWidget:OnTimeMachineButtonClicked() end
---@param bIsSuccess boolean
function UB1DramaPopupWidget:OnNameValidationResult(bIsSuccess) end


---@class UB1DreamComponent : UActorComponent
local UB1DreamComponent = {}


---@class UB1DreamUIHandler : UB1UIHandlerBase
---@field TracingObjects TMap<FB1EntityId, FB1DreamBubbleData>
local UB1DreamUIHandler = {}



---@class UB1DrivableVehicleComponent : UActorComponent
---@field PassengerMap TMap<EB1VehicleSeat, FB1EntityId>
---@field SeatSlotComponentMap TMap<EB1VehicleSeat, UB1SlotComponent>
---@field InteractionSlotComponentMap TMap<EB1VehicleSeat, UB1SlotComponent>
---@field SteeringMesh UStaticMeshComponent
---@field SteeringWheelTransform FTransform
local UB1DrivableVehicleComponent = {}

---@param InMeshComponent UStaticMeshComponent
function UB1DrivableVehicleComponent:SetSteeringWheelMesh(InMeshComponent) end


---@class UB1DummySkeletalMeshComponent : USkeletalMeshComponent
local UB1DummySkeletalMeshComponent = {}


---@class UB1DustyComponent : UActorComponent
local UB1DustyComponent = {}


---@class UB1DynamicGroundComponent : UStaticMeshComponent
local UB1DynamicGroundComponent = {}


---@class UB1EmergencyExitWidget : UB1UserWidgetBase
local UB1EmergencyExitWidget = {}


---@class UB1EmotionComponent : UActorComponent
---@field CurrentEmotionInfo FB1EmotionInfo
---@field SecondEmotionInfo FB1EmotionInfo
---@field EmotionInfoMap TMap<FName, FB1EmotionInfo>
---@field JoyfulBoostingEmotionId FName
---@field AdmitBoostingEmotionId FName
local UB1EmotionComponent = {}



---@class UB1EnableLoopBlendMetaData : UAnimMetaData
local UB1EnableLoopBlendMetaData = {}


---@class UB1EntitlementComponent : UB1ManagerComponentBase
local UB1EntitlementComponent = {}


---@class UB1EntityDataCacheManager : UB1ManagerBase
---@field CharacterCacheData TArray<FB1CharacterCacheSaveData>
---@field CharacterDataCacheMap TMap<FB1EntityId, FB1CharacterDataCache>
local UB1EntityDataCacheManager = {}



---@class UB1EntityManager : UB1ManagerBase
---@field EntityMap TMap<FB1EntityId, FB1EntityInfo>
---@field CharacterMap TMap<FB1EntityId, AB1Character>
---@field GameObjectMap TMap<FB1EntityId, AB1GameObject>
---@field SiteAreaMap TMap<FB1EntityId, AB1SiteArea>
---@field VehicleMap TMap<FB1EntityId, AB1VehiclePawn>
---@field SpawnerMap TMap<FB1EntityId, AB1SpawnActorBase>
local UB1EntityManager = {}



---@class UB1EnvironmentColorChangeWidget : UB1UserWidgetBase
---@field BW_Button_Reset UB1CommonButtonWidget
---@field BW_Button_Close UB1Button
---@field BW_PartsButton_0 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_1 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_2 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_3 UB1CharacterCustomizationPartsButtonWidget
---@field BW_PartsButton_4 UB1CharacterCustomizationPartsButtonWidget
---@field BW_WBP_ColorPicker UB1ColorPickerWidget
local UB1EnvironmentColorChangeWidget = {}



---@class UB1EnvironmentEditCityBalanceSliderListEntryWidget : UB1UserWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Slider UB1TextBlock
---@field BW_Slider_Value USlider
---@field BW_Image_Info UB1Image
---@field Data FB1EnvironmentEditCityBalanceSliderListEntryData
local UB1EnvironmentEditCityBalanceSliderListEntryWidget = {}

---@param InValue float
function UB1EnvironmentEditCityBalanceSliderListEntryWidget:OnSliderValueChanged(InValue) end
function UB1EnvironmentEditCityBalanceSliderListEntryWidget:OnMouseCaptureEnd() end
function UB1EnvironmentEditCityBalanceSliderListEntryWidget:OnMouseCaptureBegin() end


---@class UB1EnvironmentEditCityBalanceWidget : UB1UserWidgetBase
---@field SliderSlotWidgetClass TSubclassOf<UUserWidget>
---@field ReportSlotWidgetClass TSubclassOf<UUserWidget>
---@field BW_WidgetSwitcher_Report UB1WidgetSwitcher
---@field BW_SliderVerticalBox UB1VerticalBox
---@field BW_VerticalBox_Report UB1VerticalBox
---@field BW_Text_Title UB1TextBlock
---@field BW_Image_Icon UB1Image
---@field BW_WBP_Graph0 UB1CityBalanceGraphWidget
---@field BW_WBP_Graph1 UB1CityBalanceGraphWidget
---@field BW_WBP_Graph2 UB1CityBalanceGraphWidget
---@field BW_WBP_Graph3 UB1CityBalanceGraphWidget
---@field BW_Button_More UB1Button
---@field BW_Button_Reset UB1Button
---@field EntrySliderWidgetList TArray<UB1EnvironmentEditCityBalanceSliderListEntryWidget>
---@field EntryReportWidgetList TArray<UB1CityBalanceReportListEntryWidget>
---@field GraphList TArray<UB1CityBalanceGraphWidget>
local UB1EnvironmentEditCityBalanceWidget = {}



---@class UB1EnvironmentEditListEntryWidget : UB1UserWidgetBase
---@field Data FB1EnvironmentEditEntryData
---@field Image_Thumbnail UB1Image
---@field Button_Select UB1Button
---@field Button_Delete UB1Button
---@field BW_Button_Color UB1Button
---@field BW_WidgetSwitcher_Check UB1WidgetSwitcher
---@field BW_Text_Num UB1TextBlock
local UB1EnvironmentEditListEntryWidget = {}



---@class UB1EnvironmentEditSliderWidget : UB1UserWidgetBase
---@field Slider_Value USlider
---@field Text_Left UB1TextBlock
---@field Text_Right UB1TextBlock
local UB1EnvironmentEditSliderWidget = {}

---@param InValue float
function UB1EnvironmentEditSliderWidget:OnSliderValueChanged(InValue) end


---@class UB1EnvironmentEditUIHandler : UB1UIHandlerBase
---@field EnvironmentEditWidget UB1EnvironmentEditWidget
---@field EnvironmentEditYoutubeLinkWidget UB1EnvironmentEditYoutubeLinkWidget
---@field EnvironmentColorChangeWidget UB1EnvironmentColorChangeWidget
---@field EnvironmentEditCityBalance UB1EnvironmentEditCityBalanceWidget
local UB1EnvironmentEditUIHandler = {}



---@class UB1EnvironmentEditWidget : UB1UserWidgetBase
---@field SlotWidgetClass TSubclassOf<UUserWidget>
---@field BW_Button_Reset UB1Button
---@field Image_Thumbnail UB1Image
---@field Text_Title UB1TextBlock
---@field Text_Desc UB1TextBlock
---@field BW_Selection_SizeBox UB1SizeBox
---@field BW_ScrollBox UB1ScrollBox
---@field BW_HorizontalBox_List UB1HorizontalBox
---@field VerticalBox_EditType UB1VerticalBox
---@field BW_WBP_EnvironmentEdit_Slider UB1EnvironmentEditSliderWidget
---@field WidgetSwitcher_State UB1WidgetSwitcher
---@field BW_Widget_TabRoot UB1Overlay
---@field BW_Button_Image UB1Button
---@field BW_Button_Video UB1Button
---@field Button_Upload UB1Button
---@field BW_Overlay_PageIndicator UB1Overlay
---@field BW_Image_Indicator0 UB1Image
---@field BW_Image_Indicator1 UB1Image
---@field BW_Image_Indicator2 UB1Image
---@field BW_Button_Prev UB1Button
---@field BW_Button_Next UB1Button
---@field BW_Overlay_Youtube UB1Overlay
---@field BW_WBP_EnvironmentEdit_ColorChange UB1EnvironmentColorChangeWidget
---@field EnvironmentEditCityBalance UB1EnvironmentEditCityBalanceWidget
---@field BW_VerticalBox_Select UB1VerticalBox
---@field BW_WBP_DayNight_Slider UB1DayNightSilderWidget
---@field EntryWidgetList TArray<UB1EnvironmentEditListEntryWidget>
local UB1EnvironmentEditWidget = {}



---@class UB1EnvironmentEditYoutubeLinkWidget : UB1UserWidgetBase
---@field YoutubeColor FName
---@field YoutubeErrorColor FName
---@field YoutubeURLValidErrorText FText
---@field YoutubeURLDuplicationErrorText FText
---@field EditableTextBox_Link UB1EditableTextBox
---@field Image_Youtube UB1Image
---@field Text_Error UB1TextBlock
---@field WBP_Common_Button_Cancel UB1CommonButtonWidget
---@field BW_WBP_Common_Button_Comfirm UB1CommonButtonWidget
local UB1EnvironmentEditYoutubeLinkWidget = {}

---@param InText FText
---@param InCommitInfo ETextCommit::Type
function UB1EnvironmentEditYoutubeLinkWidget:OnTextCommitted(InText, InCommitInfo) end
---@param InText FText
function UB1EnvironmentEditYoutubeLinkWidget:OnTextChanged(InText) end
function UB1EnvironmentEditYoutubeLinkWidget:OnClickConfirm() end
function UB1EnvironmentEditYoutubeLinkWidget:OnClickCancel() end


---@class UB1ExportSubsystem : UGameInstanceSubsystem
local UB1ExportSubsystem = {}

---@param SelectedActor AActor
---@param Filename FString
---@return boolean
function UB1ExportSubsystem:ExportToGLTF(SelectedActor, Filename) end
---@param Path FString
---@param SelectedActors TSet<AActor>
---@return boolean
function UB1ExportSubsystem:ExportGLTF(Path, SelectedActors) end


---@class UB1FXComponent : USceneComponent
---@field FXObject TSubclassOf<UB1FXObject>
---@field bAutoPlay boolean
---@field OnLoadCompletedDelegate FB1FXComponentOnLoadCompletedDelegate
local UB1FXComponent = {}

function UB1FXComponent:StopFXObject() end
---@param InFXObject TSubclassOf<UB1FXObject>
function UB1FXComponent:SetFXObject(InFXObject) end
function UB1FXComponent:PlayFXObject() end
---@param InNiagaraComponent UNiagaraComponent
function UB1FXComponent:OnFXLoadComplete__DelegateSignature(InNiagaraComponent) end


---@class UB1FXManager : UB1ManagerBase
local UB1FXManager = {}


---@class UB1FaceComponent : UActorComponent
local UB1FaceComponent = {}


---@class UB1FaceCustomizeExitDetailsWidget : UB1UserWidgetBase
---@field BW_Button_ExitDetails UB1Button
local UB1FaceCustomizeExitDetailsWidget = {}



---@class UB1FacialCaptureSubjectEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_SubjectName UB1TextBlock
local UB1FacialCaptureSubjectEntryWidget = {}



---@class UB1FacialCaptureSubjectView : UB1UserWidgetBase
---@field BW_ListView_SubjectEntries UB1ListView
---@field BW_Text_EntrySelectionPromotion UB1TextBlock
---@field BW_Text_NotFound UB1TextBlock
local UB1FacialCaptureSubjectView = {}



---@class UB1FacialCaptureUIHandler : UB1UIHandlerBase
---@field FacialCaptureWidget UB1FacialCaptureWidget
local UB1FacialCaptureUIHandler = {}

function UB1FacialCaptureUIHandler:Refresh() end


---@class UB1FacialCaptureWidget : UB1UserWidgetBase
---@field WBP_FacialCaptureSubjectView UB1FacialCaptureSubjectView
---@field BW_Button_Close UB1Button
---@field BW_WidgetSwitcher UB1WidgetSwitcher
---@field BW_WBP_Button_Left UB1CommonButtonWidget
---@field BW_WBP_Button_Right UB1CommonButtonWidget
---@field BW_Text_IPAddress UB1TextBlock
---@field BW_Button_IPAddress_Show UB1Button
---@field CloseText FText
---@field PreviousText FText
---@field ConnectText FText
---@field NextText FText
local UB1FacialCaptureWidget = {}

function UB1FacialCaptureWidget:OnClickedShowIPAddressButton() end
function UB1FacialCaptureWidget:OnClickedRightButton() end
function UB1FacialCaptureWidget:OnClickedLeftButton() end
function UB1FacialCaptureWidget:OnClickedCloseButton() end


---@class UB1FadeInOutUIHandler : UB1UIHandlerBase
---@field FadeInOutWidget UB1UserWidgetBase
local UB1FadeInOutUIHandler = {}



---@class UB1FadeInOutWidget : UB1UserWidgetBase
local UB1FadeInOutWidget = {}


---@class UB1FamilyCountWidget : UB1UserWidgetBase
---@field Text_Count UB1TextBlock
---@field Image_Num UB1Image
---@field DefaultColor FLinearColor
---@field MaxCountColor FLinearColor
local UB1FamilyCountWidget = {}



---@class UB1FamilyEditApprovalDocumentWidget : UB1UserWidgetBase
---@field BW_Image_Portrait UB1Image
---@field BW_Text_FamilyName UB1TextBlock
---@field BW_Text_FamilyMemberList UB1TextBlock
---@field BW_Text_Date UB1TextBlock
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Submit UB1CommonButtonWidget
local UB1FamilyEditApprovalDocumentWidget = {}



---@class UB1FamilyEditFamilyProfileWidget : UB1UserWidgetBase
---@field Button_NameEdit UB1Button
---@field Button_Confirm UB1CommonButtonWidget
---@field EditableText_FamilyName UB1EditableText
---@field Text_name UB1TextBlock
---@field BW_Text_Error_Over UB1TextBlock
---@field Anim_FamilyNameEdit UWidgetAnimation
---@field Anim_CitySelect UWidgetAnimation
local UB1FamilyEditFamilyProfileWidget = {}

---@param InText FText
---@return boolean
function UB1FamilyEditFamilyProfileWidget:ValidateFamilyName(InText) end
function UB1FamilyEditFamilyProfileWidget:OnFamilyNameEditButtonClicked() end
function UB1FamilyEditFamilyProfileWidget:OnFamilyNameConfirmButtonClicked() end
---@param InText FText
---@param CommitMethod ETextCommit::Type
function UB1FamilyEditFamilyProfileWidget:OnEditableTextEntered(InText, CommitMethod) end
---@param InText FText
function UB1FamilyEditFamilyProfileWidget:OnEditableTextChanged(InText) end


---@class UB1FamilyEditPopupCharacterSlot : UB1UserWidgetBase
---@field BW_Image_Profile UB1Image
---@field BW_Text_ZoiName UB1TextBlock
local UB1FamilyEditPopupCharacterSlot = {}



---@class UB1FamilyEditPopupFamilySlot : UB1UserWidgetBase
---@field BW_WidgetSwitcher_FamilyMode UB1WidgetSwitcher
---@field BW_WidgetSwitcher_FamilyName UB1WidgetSwitcher
---@field BW_WidgetSwitcher_Edit UB1WidgetSwitcher
---@field BW_WidgetSwitcher_LocationInfo UB1WidgetSwitcher
---@field BW_Text_FamilyName UB1TextBlock
---@field BW_EditableText_FamilyName UB1EditableText
---@field BW_Button_Edit UB1CommonButtonWidget
---@field BW_Button_OK UB1Button
---@field BW_Text_Location UB1TextBlock
---@field BW_VerticalBox_TextInfo UB1VerticalBox
---@field BW_Image_TagError UB1Image
---@field BW_Text_Error_Over UB1TextBlock
---@field BW_Image_Family UB1Image
local UB1FamilyEditPopupFamilySlot = {}

---@param InText FText
---@param CommitMethod ETextCommit::Type
function UB1FamilyEditPopupFamilySlot:BW_EditableText_Name_OnTextEntered(InText, CommitMethod) end
---@param InText FText
function UB1FamilyEditPopupFamilySlot:BW_EditableText_Name_OnTextChanged(InText) end
function UB1FamilyEditPopupFamilySlot:BW_Button_Ok_Clicked() end
function UB1FamilyEditPopupFamilySlot:BW_Button_Edit_Clicked() end


---@class UB1FamilyEditUIHandler : UB1UIHandlerBase
---@field FamilyEditWidget UB1FamilyEditWidget
---@field CurrentEditFamily FB1CustomizedFamily
---@field CurrentSelectSiteId FName
local UB1FamilyEditUIHandler = {}



---@class UB1FamilyEditWidget : UB1UserWidgetBase
---@field BW_Widget_Root UWidget
---@field CommonTitle_Back UB1CommonTitleWidget
---@field BW_WBP_FamilyTree UB1FamilyTreeViewerWidget
---@field BW_Button_AddFamilyMember UB1CommonButtonWidget
---@field WBP_FamilyCreate_FamilyProfile UB1FamilyEditFamilyProfileWidget
---@field BW_Button_UIReset UB1CommonButtonWidget
---@field Button_MakeFamily UB1CommonButtonWidget
---@field Button_ConfirmMake UB1CommonButtonWidget
---@field Button_CitySelect UB1CommonButtonWidget
---@field Button_CompleteEdit UB1CommonButtonWidget
---@field Anim_Init UWidgetAnimation
---@field Anim_CitySelect UWidgetAnimation
---@field BW_WBP_ApprovalDocument UB1FamilyEditApprovalDocumentWidget
---@field FamilyMemberInfo TArray<FB1InstancedCharacter>
---@field GameMapId FName
local UB1FamilyEditWidget = {}



---@class UB1FamilyInfoWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_Type UB1WidgetSwitcher
---@field BW_WBP_FamilyLove UB1RelationshipFamilyLoveWidget
---@field BW_Text_FamilyLove UB1TextBlock
---@field BW_WBP_SelectedPlayerInfo_Slider UB1CatOperatorSliderWidget
---@field BW_Text_Karma UB1TextBlock
---@field BW_Text_DirtyZOINumber UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
---@field CurrencyEffectWidgetClass TSubclassOf<UUserWidget>
local UB1FamilyInfoWidget = {}



---@class UB1FamilyListUIHandler : UB1UIHandlerBase
---@field FamilyListPopUpWidget UB1MapFamilyListPopUpWidget
---@field CachedEntryMap TMap<FB1EntityId, UB1FamilySelectEntryData>
local UB1FamilyListUIHandler = {}

---@param InEntityId FB1EntityId
function UB1FamilyListUIHandler:OnHouseholdInfoChanged(InEntityId) end
---@param InNewFamilyId FB1EntityId
function UB1FamilyListUIHandler:OnFinishMakeNewFamily(InNewFamilyId) end
---@param InFamilyMoveMode EB1HouseholdMoveMode
function UB1FamilyListUIHandler:OnFinishFamilyMove(InFamilyMoveMode) end


---@class UB1FamilyMonitoringAlertWidget : UB1UserWidgetBase
---@field AlertTime float
---@field BW_Tooltip_Arrow_Left UB1Image
---@field BW_Image_Icon UB1Image
---@field BW_Tooltip_Arrow_Right UB1Image
local UB1FamilyMonitoringAlertWidget = {}

function UB1FamilyMonitoringAlertWidget:OnTimerExpired() end


---@class UB1FamilyMonitoringNotificationListWidget : UB1UserWidgetBase
---@field BW_Image_BG_Emergency UB1Image
---@field BW_Image_Icon UB1Image
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Time UB1TextBlock
---@field BW_Text_Desc UB1TextBlock
local UB1FamilyMonitoringNotificationListWidget = {}



---@class UB1FamilyMonitoringUIHandler : UB1UIHandlerBase
---@field FamilyMonitoringWidget UB1FamilyMonitoringWidget
---@field PlayerChangeWidget UB1PlayerChangeWidget
local UB1FamilyMonitoringUIHandler = {}



---@class UB1FamilyMonitoringWidget : UB1UserWidgetBase
---@field SlotWidgetClass TSubclassOf<UUserWidget>
---@field BW_WidgetSwitcher_SiteIcon UB1WidgetSwitcher
---@field BW_Text_SiteName UB1TextBlock
---@field BW_Image_Site UB1Image
---@field BW_Text_FamilyName UB1TextBlock
---@field BW_CheckBox_Shoes UB1CheckBox
---@field BW_Button_FamilyEdit UB1Button
---@field BW_Button_GoHome UB1Button
---@field BW_WBP_FamilyLove UB1RelationshipFamilyLoveWidget
---@field BW_Text_FamilyLove UB1TextBlock
---@field BW_SizeBox_FamilyLove UB1SizeBox
---@field BW_WBP_Cleanliness UB1CleanlinessWidget
---@field BW_Text_DirtyZOINumber UB1TextBlock
---@field BW_Button_DeleteAll UB1Button
---@field BW_WidgetSwitcher_Alert UB1WidgetSwitcher
---@field BW_VerticalBox_Alert UB1VerticalBox
local UB1FamilyMonitoringWidget = {}



---@class UB1FamilyMoveEntryData : UObject
---@field Portrait UTexture
local UB1FamilyMoveEntryData = {}



---@class UB1FamilyMoveFamilyInfoWidget : UB1UserWidgetBase
---@field Image_BG_Color FLinearColor
---@field Image_Icon_Home_Color FLinearColor
---@field mage_Icon_NewHouse_Color FLinearColor
---@field Image_FamilyNameBG_Color FLinearColor
---@field Direction EB1FamilyDirection
---@field BW_CurrencyInputBox_Left UB1EditableText
---@field BW_CurrencyInputBox_Right UB1EditableText
---@field BW_Button_RightInputOpen UB1Button
---@field BW_Button_LeftInputOpen UB1Button
---@field BW_Button_Currency_MoveToRight UB1Button
---@field BW_Button_Currency_MoveToLeft UB1Button
---@field BW_Text_FamilyCurrency UB1TextBlock
---@field BW_Text_FamilyName UB1TextBlock
---@field BW_WBP_FamilyNameEdit UB1CommonNameEditableText
---@field BW_Text_SiteName UB1TextBlock
---@field BW_TileView_Family UB1TileView
---@field BW_FamilyCount UB1FamilyCountWidget
---@field BW_Overlay_FamilyName UB1Overlay
---@field BW_WidgetSwitcher_Bottom UB1WidgetSwitcher
---@field BW_WidgetSwitcher_HomeIcon UB1WidgetSwitcher
---@field BW_WidgetSwitcher_Zoi UB1WidgetSwitcher
---@field BW_Image_ErrorLine UB1Image
---@field BW_Image_Icon_Heart UB1Image
---@field BW_WBP_ZoiStuffSell UB1FamilyMoveSellOptionWidget
---@field BW_Image_BG_Color UB1Image
---@field BW_Image_Icon_Home UB1Image
---@field BW_Image_Icon_NewHouse UB1Image
---@field BW_Image_FamilyNameBG UB1Image
local UB1FamilyMoveFamilyInfoWidget = {}

---@param InText FText
function UB1FamilyMoveFamilyInfoWidget:OnCurrencyTextChanged(InText) end


---@class UB1FamilyMoveListEntryWidget : UB1UserListEntryWidgetBase
---@field CharacterName UB1TextBlock
---@field BW_Text_NotMove UB1TextBlock
---@field BW_WBP_Portrait UB1PlayerPortraitWidget
---@field BW_WidgetSwitcher_Icon UB1WidgetSwitcher
---@field GridPanel_Married UB1GridPanel
---@field BW_GridPanel_Broken UB1GridPanel
---@field BW_CanvasPanel_Lock UB1CanvasPanel
---@field BW_Overlay_Pregnant UB1Overlay
---@field EntryData UB1FamilyMoveEntryData
local UB1FamilyMoveListEntryWidget = {}

function UB1FamilyMoveListEntryWidget:OnPortraitClicked() end


---@class UB1FamilyMoveNewHouseWidget : UB1FamilyMoveWidgetBase
---@field BW_WBP_LeftFamilyInfo UB1FamilyMoveFamilyInfoWidget
---@field BW_WBP_RightFamilyInfo UB1FamilyMoveFamilyInfoWidget
---@field BW_WBP_CenterFamilyInfo UB1FamilyMoveFamilyInfoWidget
---@field Button_Family_MoveLeftToCenter UB1Button
---@field Button_Family_MoveCenterToLeft UB1Button
---@field Button_Family_MoveCenterToRight UB1Button
---@field Button_Family_MoveRightToCenter UB1Button
---@field B1VerticalBox_Right UB1VerticalBox
local UB1FamilyMoveNewHouseWidget = {}



---@class UB1FamilyMoveSellOptionWidget : UB1UserWidgetBase
---@field BW_CheckBox UB1CheckBox
---@field BW_WidgetSwitcher_Text UB1WidgetSwitcher
local UB1FamilyMoveSellOptionWidget = {}



---@class UB1FamilyMoveUIHandler : UB1UIHandlerBase
---@field FamilyMoveWidget UB1FamilyMoveWidget
---@field FamilyMoveNewHouseWidget UB1FamilyMoveNewHouseWidget
local UB1FamilyMoveUIHandler = {}

---@param InSiteId FName
function UB1FamilyMoveUIHandler:OnClickMarriageNewHouseComplete(InSiteId) end
function UB1FamilyMoveUIHandler:OnClickMarriageNewHouseCancel() end


---@class UB1FamilyMoveWidget : UB1FamilyMoveWidgetBase
---@field BW_WBP_LeftFamilyInfo UB1FamilyMoveFamilyInfoWidget
---@field BW_WBP_RightFamilyInfo UB1FamilyMoveFamilyInfoWidget
---@field Button_GetNewHouse UB1Button
---@field Button_Family_MoveToLeft UB1Button
---@field Button_Family_MoveToRight UB1Button
---@field BW_VerticalBox_Or UB1VerticalBox
---@field BW_Overlay_NewHouse UB1Overlay
---@field VerticalBox_Move UB1VerticalBox
---@field BW_WidgetSwitcher_TitleText UB1WidgetSwitcher
local UB1FamilyMoveWidget = {}

function UB1FamilyMoveWidget:OnClickedGetNewHouseButton() end


---@class UB1FamilyMoveWidgetBase : UB1UserWidgetBase
---@field Text_Desc UB1TextBlock
---@field BW_Button_Back UB1CommonButtonWidget
---@field BW_Button_Reset UB1CommonButtonWidget
---@field BW_Button_Confirm UB1CommonButtonWidget
local UB1FamilyMoveWidgetBase = {}

---@param InFromHousehold EB1BaseHousehold
---@param InToHousehold EB1BaseHousehold
function UB1FamilyMoveWidgetBase:OnClickedHouseholdMove(InFromHousehold, InToHousehold) end


---@class UB1FamilySelectEntryWidget : UB1UserListEntryWidgetBase
---@field Button_Family UB1Button
---@field Button_FamilyCreate UB1Button
---@field BW_CheckBox_Delete UB1CheckBox
---@field BW_Button_BlankFamily UB1Button
---@field WidgetSwitcher_Family UB1WidgetSwitcher
---@field Image_Family UB1Image
---@field Text_FamilyName UB1TextBlock
---@field Text_SiteName UB1TextBlock
---@field Text_FamilyNum UB1TextBlock
---@field BW_WidgetSwitcher_LocationInfo UB1WidgetSwitcher
---@field BW_WBP_Currency UB1CurrencyWidget
local UB1FamilySelectEntryWidget = {}

function UB1FamilySelectEntryWidget:OnFamilySelectButtonClicked() end


---@class UB1FamilyTreeItemRelationSelectEntryWidget : UB1UserWidgetBase
---@field BW_Text_name UB1TextBlock
---@field BW_Image_Portrait UB1Image
---@field BW_ComboBox UB1ComboBoxKey
local UB1FamilyTreeItemRelationSelectEntryWidget = {}

---@param InKey FName
---@param InSelectionType ESelectInfo::Type
function UB1FamilyTreeItemRelationSelectEntryWidget:OnSelectionChanged(InKey, InSelectionType) end


---@class UB1FamilyTreeItemRelationSelectWidget : UB1UserWidgetBase
---@field BW_DynamicEntryBox UB1DynamicEntryBox
local UB1FamilyTreeItemRelationSelectWidget = {}



---@class UB1FamilyTreeItemWidget : UB1UserWidgetBase
---@field BW_Button UB1Button
---@field BW_Text_CharacterName UB1TextBlock
---@field BW_Image_Portrait UB1Image
---@field BW_Button_Customize UB1CommonButtonWidget
---@field BW_Button_Relation UB1CommonButtonWidget
---@field BW_Button_Remove UB1CommonButtonWidget
---@field BW_WBP_RelationSelect UB1FamilyTreeItemRelationSelectWidget
local UB1FamilyTreeItemWidget = {}



---@class UB1FamilyTreeLineWidget : UB1UserWidgetBase
local UB1FamilyTreeLineWidget = {}


---@class UB1FamilyTreeTestWidget : UB1UserWidgetBase
---@field bCloseButtonVisible boolean
---@field BW_WBP_FamilyTreeViewer UB1FamilyTreeViewerWidget
---@field BW_Button_Close UB1Button
---@field BW_Text_JsonString UB1MultiLineEditableTextBox
---@field BW_Button_Make UB1Button
local UB1FamilyTreeTestWidget = {}



---@class UB1FamilyTreeViewerWidget : UB1UserWidgetBase
---@field BW_Canvas_Root UB1CanvasPanel
---@field BW_WBP_Line UB1FamilyTreeLineWidget
---@field BW_Canvas_Content UB1CanvasPanel
---@field ItemWidgetClass TSubclassOf<UB1FamilyTreeItemWidget>
local UB1FamilyTreeViewerWidget = {}



---@class UB1FloorComponent : USceneComponent
---@field GridMeshMaterial TSoftObjectPtr<UMaterialInterface>
---@field SelectedMeshMaterial TSoftObjectPtr<UMaterialInterface>
---@field ShadowMeshMaterial TSoftObjectPtr<UMaterialInterface>
---@field WaterSurfaceMaterial TSoftObjectPtr<UMaterialInterface>
---@field SelectedLineColor FLinearColor
---@field SelectedLineThickness float
---@field BrushSelectedLineColor FLinearColor
---@field BrushSelectedLineThickness float
---@field HoverSelectedLineColor FLinearColor
---@field HoverSelectedLineThickness float
---@field MaxDrawDistance float
local UB1FloorComponent = {}



---@class UB1FoundationComponent : USceneComponent
---@field SelectedLineColor FLinearColor
---@field SelectedLineThickness float
---@field BrushSelectedLineColor FLinearColor
---@field BrushSelectedLineThickness float
---@field HoverSelectedLineColor FLinearColor
---@field HoverSelectedLineThickness float
---@field MaxDrawDistance float
---@field BaseWallLineMeshAsset TSoftObjectPtr<UStaticMesh>
---@field BaseCBCornerMeshAsset TSoftObjectPtr<UStaticMesh>
---@field BaseD2CornerMeshAsset TSoftObjectPtr<UStaticMesh>
---@field BaseD3CornerMeshAsset TSoftObjectPtr<UStaticMesh>
---@field BaseTriangleMeshAsset TSoftObjectPtr<UStaticMesh>
---@field BaseTopCoverMeshAsset TSoftObjectPtr<UStaticMesh>
---@field TopCoverMaterial TSoftObjectPtr<UMaterialInterface>
---@field SideFaceMaterial TSoftObjectPtr<UMaterialInterface>
local UB1FoundationComponent = {}



---@class UB1FpsTelemetryComponent : UB1ManagerComponentBase
local UB1FpsTelemetryComponent = {}


---@class UB1FreeCameraWidget : UB1UserWidgetBase
---@field B1KeyImageMoveForward UB1KeyImage
---@field B1KeyImageMoveLeft UB1KeyImage
---@field B1KeyImageMoveRight UB1KeyImage
---@field B1KeyImageMoveBackward UB1KeyImage
---@field B1KeyImageMoveCameraUp UB1KeyImage
---@field B1KeyImageMoveCameraDown UB1KeyImage
local UB1FreeCameraWidget = {}



---@class UB1FullScreenVideoPlayerWidget : UB1UserWidgetBase
---@field BW_Image_VideoContentAreaBg UB1Image
---@field BW_WBP_VideoPlayer UB1VideoPlayerWidget
---@field BW_Button_Skip UB1Button
local UB1FullScreenVideoPlayerWidget = {}



---@class UB1FunctionLibrary : UBlueprintFunctionLibrary
local UB1FunctionLibrary = {}

---@param StaticMeshComponent UStaticMeshComponent
---@param DefaultStartDistance int32
---@param DefaultEndDistance int32
---@param IsReset boolean
---@return boolean
function UB1FunctionLibrary:SetB1CullDistance(StaticMeshComponent, DefaultStartDistance, DefaultEndDistance, IsReset) end
---@param Actor AActor
---@param IsPerInstance boolean
---@param IsReset boolean
---@return boolean
function UB1FunctionLibrary:SetActorB1CullDistance(Actor, IsPerInstance, IsReset) end
---@param Actor AActor
---@return boolean
function UB1FunctionLibrary:IsHLODActor(Actor) end
---@param Actor AActor
---@return boolean
function UB1FunctionLibrary:IsCollisionTypeMesh(Actor) end
---@param Actor AActor
---@param Tags TArray<FName>
function UB1FunctionLibrary:AddUniqueTags(Actor, Tags) end
---@param ActorComponent UActorComponent
---@param Tags TArray<FName>
function UB1FunctionLibrary:AddComponentUniqueTags(ActorComponent, Tags) end


---@class UB1GPPManager : UB1ManagerBase
---@field GameInstance UGameInstance
---@field AuthCode FString
---@field RefreshToken FString
---@field AccountId FString
---@field AccessToken FString
---@field EntitlementComponent UB1EntitlementComponent
local UB1GPPManager = {}



---@class UB1GPPTelemetryManager : UB1ManagerBase
---@field FpsTelemetryComponent UB1FpsTelemetryComponent
---@field PerformanceTelemetryComponent UB1PerformanceTelemetryComponent
local UB1GPPTelemetryManager = {}



---@class UB1GalleryAlertList : UB1UserWidgetBase
---@field BW_WidgetSwitcher_List UB1WidgetSwitcher
---@field BW_ListView_AlertList UB1ListView
---@field BW_Image_Profile UB1Image
---@field BW_Button_DeleteAll UB1Button
---@field BW_WidgetSwitcher_Alert UB1WidgetSwitcher
---@field BW_Button_AlertOff UB1Button
---@field BW_Button_AlertOn UB1Button
local UB1GalleryAlertList = {}



---@class UB1GalleryAlertListEntry : UB1UserListEntryWidgetBase2
---@field BW_Button_Alert UB1Button
---@field BW_Button_Delete UB1Button
---@field BW_WidgetSwitcher_Alert UB1WidgetSwitcher
---@field BW_WidgetSwitcher_Icon UB1WidgetSwitcher
---@field BW_Image_Profile_Like UB1Image
---@field BW_RichText_Like UB1RichTextBlock
---@field BW_Image_Thumbnail_Like UB1Image
---@field BW_RichText_Like_Milestone UB1RichTextBlock
---@field BW_Image_Thumbnail_LikeMilestone UB1Image
---@field BW_RichText_Download_Milestone UB1RichTextBlock
---@field BW_Image_Thumbnail_Download_Milestone UB1Image
---@field BW_RichText_Comment UB1RichTextBlock
---@field BW_Image_Profile_Comment UB1Image
---@field BW_Image_Thumbnail_Comment UB1Image
---@field BW_RichText_Like_Comment UB1RichTextBlock
---@field BW_Image_Profile_Like_Comment UB1Image
---@field BW_Image_Thumbnail_Like_Comment UB1Image
---@field BW_RichText_Download UB1RichTextBlock
---@field BW_Image_DownloadBG UB1Image
---@field BW_Image_Profile_Follow UB1Image
---@field BW_RichText_Follow UB1RichTextBlock
---@field BW_Image_Profile_Follow_Milestone UB1Image
---@field BW_RichText_Follow_Milestone UB1RichTextBlock
---@field BW_Image_Profile_Follow_New UB1Image
---@field BW_RichText_Follow_New UB1RichTextBlock
---@field BW_Image_Thumbnail_Follow_New UB1Image
---@field BW_Image_Profile_Grade UB1Image
---@field BW_RichText_Grade UB1RichTextBlock
---@field BW_Image_Profile_Verified UB1Image
---@field BW_RichText_Verified UB1RichTextBlock
---@field BW_RichText_Rank UB1RichTextBlock
---@field BW_Image_Thumbnail_Rank UB1Image
---@field BW_RichText_Rank_Repeat UB1RichTextBlock
---@field BW_Image_Thumbnail_Rank_Repeat UB1Image
---@field BW_RichText_Alteration UB1RichTextBlock
---@field BW_RichText_Restriction UB1RichTextBlock
---@field BW_RichText_Reward UB1RichTextBlock
---@field Anim_Generate UWidgetAnimation
---@field EntryData UB1GalleryAlertListEntryData
local UB1GalleryAlertListEntry = {}



---@class UB1GalleryAlertListEntryData : UObject
local UB1GalleryAlertListEntryData = {}


---@class UB1GalleryAlertListPopUp : UB1UserWidgetBase
---@field BW_ListView_AlertList UB1ListView
---@field BW_WidgetSwitcher_List UB1WidgetSwitcher
---@field BW_Button_DeleteAll UB1Button
---@field BW_Button_Close UB1Button
---@field BW_Image_Profile UB1Image
---@field BW_WidgetSwitcher_Alert UB1WidgetSwitcher
---@field BW_Button_AlertOff UB1Button
---@field BW_Button_AlertOn UB1Button
local UB1GalleryAlertListPopUp = {}



---@class UB1GalleryAlertOffPopUp : UB1UserWidgetBase
---@field BW_Button_15_Minutes UB1CommonButtonWidget
---@field BW_Button_30_Minutes UB1CommonButtonWidget
---@field BW_Button_1_Hour UB1CommonButtonWidget
---@field BW_Button_4_Hours UB1CommonButtonWidget
---@field BW_Image_Overlay UB1Image
---@field BW_RichText_Title UB1RichTextBlock
---@field BW_RichText_Desc UB1RichTextBlock
---@field BW_Button_Optional_Close UB1Button
---@field BW_VerticalBox UB1VerticalBox
local UB1GalleryAlertOffPopUp = {}



---@class UB1GalleryButton : UB1UserWidgetBase
---@field BW_Button_Gallery UB1Button
---@field OpenDelayTime float
local UB1GalleryButton = {}



---@class UB1GalleryCancelReservation : UObject
local UB1GalleryCancelReservation = {}


---@class UB1GalleryChipWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_Chip UB1WidgetSwitcher
---@field BW_Text_name UB1TextBlock
---@field BW_Button_Delete UB1Button
---@field BW_Image_Profile UB1Image
---@field ObjectData UObject
local UB1GalleryChipWidget = {}



---@class UB1GalleryConfigurationItemWidget : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Button_Select UB1Button
---@field BW_Image_ItemError UB1Image
---@field configurationType EB1AppearanceConfigurationType
local UB1GalleryConfigurationItemWidget = {}



---@class UB1GalleryConfigurationWidget : UB1UserWidgetBase
---@field ConfigurationIconMap TMap<EB1AppearanceConfigurationType, TSoftObjectPtr<UTexture>>
---@field ConfigurationItemMap TMap<EB1AppearanceConfigurationType, UB1Image>
---@field BW_WBP_Item_All UB1GalleryConfigurationItemWidget
---@field BW_WBP_Item_Costume UB1GalleryConfigurationItemWidget
---@field BW_WBP_Item_Face UB1GalleryConfigurationItemWidget
---@field BW_WrapBox_item UB1WrapBox
---@field BW_Text_Item UB1TextBlock
---@field ColorId FName
---@field ImageIconTemplate UB1Image
---@field ConfigurationTypeToWidgetMap TMap<EB1AppearanceConfigurationType, UB1GalleryConfigurationItemWidget>
local UB1GalleryConfigurationWidget = {}



---@class UB1GalleryContributorListEntry : UB1UserListEntryWidgetBase
---@field BW_Image_Profile UB1Image
---@field BW_RichText_Name UB1RichTextBlock
---@field BW_Image_Check UB1Image
---@field Anim_Selected UWidgetAnimation
local UB1GalleryContributorListEntry = {}



---@class UB1GalleryContributorWidget : UB1UserWidgetBase
---@field MaxContributors int32
---@field MaxString int32
---@field InputDelayInSeconds float
---@field UpdateDelayInSeconds float
---@field BW_Text_Num UB1TextBlock
---@field BW_Button_Add UB1Button
---@field BW_EditableTextBox_Contributor UB1EditableTextBox
---@field BW_Image_ContributorError UB1Image
---@field BW_CanvasPanel_AutoComplete UWidget
---@field BW_ListView_Contributor UB1ListView
---@field BW_Wrap_Box UB1WrapBox
---@field BW_WidgetSwitcher_List UB1WidgetSwitcher
---@field DesiredChipWidgetClass TSubclassOf<UB1GalleryChipWidget>
---@field DefaultIcon UTexture2D
---@field Anim_AutoComplete UWidgetAnimation
---@field ColorId FName
local UB1GalleryContributorWidget = {}

function UB1GalleryContributorWidget:HasAnimStarted() end
---@param Text FText
function UB1GalleryContributorWidget:BW_EditableTextBox_Contributor_OnTextChanged(Text) end


---@class UB1GalleryDeleteAllReservations : UObject
local UB1GalleryDeleteAllReservations = {}


---@class UB1GalleryDeleteNotification : UObject
local UB1GalleryDeleteNotification = {}


---@class UB1GalleryDownloadReservationList : UObject
local UB1GalleryDownloadReservationList = {}


---@class UB1GalleryGetAuthorName : UObject
local UB1GalleryGetAuthorName = {}


---@class UB1GalleryGetNotificationList : UObject
local UB1GalleryGetNotificationList = {}


---@class UB1GalleryGetReservationList : UObject
local UB1GalleryGetReservationList = {}


---@class UB1GalleryGetRestrictions : UObject
local UB1GalleryGetRestrictions = {}


---@class UB1GalleryGetUserInfo : UObject
local UB1GalleryGetUserInfo = {}


---@class UB1GalleryGppAuth : UObject
local UB1GalleryGppAuth = {}


---@class UB1GalleryItemDetailReqHandler : UObject
local UB1GalleryItemDetailReqHandler = {}


---@class UB1GalleryLogin : UObject
local UB1GalleryLogin = {}


---@class UB1GalleryPhotoButton : UB1UserWidgetBase
---@field BW_WidgetSwitcher_State UB1WidgetSwitcher
---@field BW_Button_Photo UB1Button
---@field BW_Button_Import UB1Button
---@field BW_Image_Photo UB1Image
---@field BW_Button_Select UB1Button
---@field BW_Button_Delete UB1Button
---@field BW_CheckBox_Delete UB1CheckBox
---@field BW_WidgetSwitcher_Thumbnail UB1WidgetSwitcher
---@field BW_Button_Thumbnail UB1Button
---@field BW_Button_ThumbnailOff UB1Button
---@field Anim_Select UWidgetAnimation
local UB1GalleryPhotoButton = {}



---@class UB1GalleryProfanityCheck : UObject
local UB1GalleryProfanityCheck = {}


---@class UB1GalleryReadNotification : UObject
local UB1GalleryReadNotification = {}


---@class UB1GalleryRequestManager : UB1ManagerBase
---@field Requests TArray<TScriptInterface<IB1GalleryRequestInterface>>
local UB1GalleryRequestManager = {}



---@class UB1GalleryRestrictCheck : UObject
local UB1GalleryRestrictCheck = {}


---@class UB1GalleryToastMessage : UB1UserWidgetBase
---@field BW_WBP_AlertListEntry UB1GalleryAlertListEntry
---@field BW_Image_Shadow UB1Image
---@field Anim_Open UWidgetAnimation
---@field Anim_Close UWidgetAnimation
---@field Anim_Finish UWidgetAnimation
---@field BW_WidgetSwitcher_Alert UB1WidgetSwitcher
---@field BW_Button_AlertOff UB1Button
---@field BW_Button_AlertOn UB1Button
local UB1GalleryToastMessage = {}



---@class UB1GalleryToastMessageHandler : UB1UIHandlerBase
---@field ToastWidget UB1GalleryToastMessage
---@field ToastQueue TArray<FB1GalleryToastMessageInfo>
local UB1GalleryToastMessageHandler = {}

function UB1GalleryToastMessageHandler:ProceedToTheNextMessage() end
function UB1GalleryToastMessageHandler:OnOpenAnimFinished() end


---@class UB1GalleryUpLoadWidget : UB1UserWidgetBase
---@field ColorName FB1TableRowName
---@field MaxTitleChar int32
---@field MinTitleChar int32
---@field MaxContentChar int32
---@field MinContentChar int32
---@field MaxHashTagTotalChar int32
---@field MaxHashTagChar int32
---@field MaxHashTag int32
---@field BW_EditableTextBox_Title UB1EditableTextBox
---@field BW_WidgetSwitcher_Error_Title UB1WidgetSwitcher
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Error_Title UB1TextBlock
---@field BW_Text_Error_Word_Title UB1TextBlock
---@field BW_Text_Num_Title UB1TextBlock
---@field BW_Image_TitleError UB1Image
---@field BW_MultiLineEditableTextBox_Content UB1MultiLineEditableTextBox
---@field BW_WidgetSwitcher_Error_Content UB1WidgetSwitcher
---@field BW_Text_Content UB1TextBlock
---@field BW_Text_Error_Content UB1TextBlock
---@field BW_Text_Error_Word_Content UB1TextBlock
---@field BW_Text_Num_Content UB1TextBlock
---@field BW_Image_ContentError UB1Image
---@field BW_Text_AuthorshipNickName UB1TextBlock
---@field BW_VerticalBox_Authorship UB1VerticalBox
---@field DesiredChipWidgetClass TSubclassOf<UUserWidget>
---@field BW_EditableTextBox_Tag UB1EditableTextBox
---@field BW_Text_Error_Word_Tag UB1TextBlock
---@field BW_Button_AddTag UB1Button
---@field BW_WrapBox_Tag UB1WrapBox
---@field BW_Text_Num_Tag UB1TextBlock
---@field BW_Text_CharNum_Tag UB1TextBlock
---@field BW_Image_TagError UB1Image
---@field BW_WBP_Gallery_Contributor UB1GalleryContributorWidget
---@field BW_WidgetSwitcher_DeleteMode UB1WidgetSwitcher
---@field BW_Button_Delete UB1Button
---@field BW_Button_DeleteModeCancel UB1Button
---@field BW_Button_DeleteModeComplete UB1Button
---@field BW_WidgetSwitcher_Photo UB1WidgetSwitcher
---@field BW_WidgetSwitcher_Preset UB1WidgetSwitcher
---@field BW_Image_ImageError UB1Image
---@field BW_Image_Preset_Build UB1Image
---@field BW_Image_Preset_Character UB1Image
---@field BW_Overlay_Thumbnail UB1Overlay
---@field BW_Image_Photo UB1Image
---@field BW_Text_Image UB1TextBlock
---@field BW_WBP_PhotoButton0 UB1GalleryPhotoButton
---@field BW_WBP_PhotoButton1 UB1GalleryPhotoButton
---@field BW_WBP_PhotoButton2 UB1GalleryPhotoButton
---@field BW_WBP_PhotoButton3 UB1GalleryPhotoButton
---@field BW_WBP_PhotoButton4 UB1GalleryPhotoButton
---@field BW_WBP_PhotoButton5 UB1GalleryPhotoButton
---@field BW_WBP_PhotoButton6 UB1GalleryPhotoButton
---@field BW_WidgetSwitcher_GalleryType UB1WidgetSwitcher
---@field BW_WBP_Gallery_Configuration UB1GalleryConfigurationWidget
---@field BW_WBP_Build_PresetSavePopup_Info UB1BuildSavePresetInfoWidget
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_GalleryUpload UB1CommonButtonWidget
---@field Anim_Open UWidgetAnimation
---@field SelectionList TSet<UB1GalleryPhotoButton>
local UB1GalleryUpLoadWidget = {}

function UB1GalleryUpLoadWidget:OnConfigurationChanged() end
---@param Text FText
---@param CommitMethod ETextCommit::Type
function UB1GalleryUpLoadWidget:BW_MultiLineEditableTextBox_Content_OnTextCommitted(Text, CommitMethod) end
---@param Text FText
function UB1GalleryUpLoadWidget:BW_MultiLineEditableTextBox_Content_OnTextChanged(Text) end
---@param Text FText
---@param CommitMethod ETextCommit::Type
function UB1GalleryUpLoadWidget:BW_EditableTextBox_Title_OnTextCommitted(Text, CommitMethod) end
---@param Text FText
function UB1GalleryUpLoadWidget:BW_EditableTextBox_Title_OnTextChanged(Text) end
---@param Text FText
---@param CommitMethod ETextCommit::Type
function UB1GalleryUpLoadWidget:BW_EditableTextBox_Tag_OnTextCommited(Text, CommitMethod) end
---@param Text FText
function UB1GalleryUpLoadWidget:BW_EditableTextBox_Tag_OnTextChanged(Text) end


---@class UB1GalleryUploadUIHandler : UB1UIHandlerBase
---@field ListItems TArray<FB1AutoSuggestedItem>
---@field ImageCache TMap<FString, UTexture2D>
---@field DefaultImageCache UTexture2D
local UB1GalleryUploadUIHandler = {}



---@class UB1GalleryWidget : UB1UserWidgetBase
---@field BW_Button_Home UB1Button
---@field BW_Button_Forward UB1Button
---@field BW_Button_Back UB1Button
---@field BW_Button_Close UB1Button
---@field BW_Button_EventTest UB1Button
---@field BW_EditableTextBox_URL UB1EditableTextBox
---@field BW_Button_Refresh UB1Button
---@field BW_Button_Alert UB1Button
---@field BW_WBP_Alert UB1MobileAppAlertIconWidget
---@field BW_WBP_AlertListPopup UB1GalleryAlertListPopUp
---@field BW_WebBrowser UB1WebBrowser
---@field BW_AlertButton UB1Button
---@field BW_Button_Steam UB1CommonButtonWidget
---@field BW_Button_Discord UB1CommonButtonWidget
---@field Anim_Downloading UWidgetAnimation
local UB1GalleryWidget = {}

function UB1GalleryWidget:ShouldLogout() end
---@param InText FText
---@param InCommitMethod ETextCommit::Type
function UB1GalleryWidget:OnURLTextCommitted(InText, InCommitMethod) end
---@param InText FText
function UB1GalleryWidget:OnUrlChanged(InText) end
function UB1GalleryWidget:OnLoginAvailable() end
---@param URL FString
function UB1GalleryWidget:OnLaunchExternalUrl(URL) end
function UB1GalleryWidget:OnGetDownloadList() end
function UB1GalleryWidget:OnFileSelect() end
---@param GalleryId FString
---@param ComponentTypes FString
---@param Meta FString
function UB1GalleryWidget:OnDownload(GalleryId, ComponentTypes, Meta) end
---@param InMessage FString
---@param InSource FString
---@param InLine int32
function UB1GalleryWidget:OnConsoleMessage(InMessage, InSource, InLine) end
---@param InURL FString
---@param InFrame FString
function UB1GalleryWidget:OnBeforePopup(InURL, InFrame) end
function UB1GalleryWidget:IsLobbyTablet() end


---@class UB1GameContentsSettings : UObject
---@field TopViewWheelSpeedMultiply float
---@field FollowViewWheelSpeedMultiply float
---@field FollowViewMouseSensitivityRate float
---@field MouseCursorEdgeScrollDisable int32
---@field AutonomyEnable int32
---@field Filter EB1FilterType
---@field RomanKeyboardLayoutValue int32
---@field VehicleManualDrivingActive boolean
local UB1GameContentsSettings = {}



---@class UB1GameInstance : UGameInstance
---@field MaterialInstance UMaterialInstanceConstant
---@field PreloadAssetList TArray<UObject>
local UB1GameInstance = {}



---@class UB1GameIntroRatingWidget : UB1UserWidgetBase
local UB1GameIntroRatingWidget = {}


---@class UB1GameMenuUIHandler : UB1UIHandlerBase
local UB1GameMenuUIHandler = {}


---@class UB1GameMenuWidget : UB1UserWidgetBase
---@field Button_Save UB1CommonButtonWidget
---@field Button_SaveAs UB1CommonButtonWidget
---@field Button_Load UB1CommonButtonWidget
---@field BW_Button_Guide UB1CommonButtonWidget
---@field Button_Gallery UB1CommonButtonWidget
---@field Button_Option UB1CommonButtonWidget
---@field BW_Button_UICustomizeReset UB1CommonButtonWidget
---@field Button_StartScreen UB1CommonButtonWidget
---@field BW_Text_Version UB1TextBlock
---@field Button_Quit UB1CommonButtonWidget
---@field OpenDelayTime float
local UB1GameMenuWidget = {}

function UB1GameMenuWidget:Refresh() end
function UB1GameMenuWidget:OnClicked_UICustomizeReset() end
function UB1GameMenuWidget:OnClicked_StartScreen() end
function UB1GameMenuWidget:OnClicked_SaveAs() end
function UB1GameMenuWidget:OnClicked_Save() end
function UB1GameMenuWidget:OnClicked_Quit() end
function UB1GameMenuWidget:OnClicked_PauseFacialCapture() end
function UB1GameMenuWidget:OnClicked_Optional_Close() end
function UB1GameMenuWidget:OnClicked_Option() end
function UB1GameMenuWidget:OnClicked_Load() end
function UB1GameMenuWidget:OnClicked_KeyGuide() end
function UB1GameMenuWidget:OnClicked_Gallery() end
function UB1GameMenuWidget:OnClicked_FacialCapture() end


---@class UB1GameObjectCustomizeComponent : UB1ObjectCustomizeComponent
local UB1GameObjectCustomizeComponent = {}


---@class UB1GameObjectUROComponent : UActorComponent
local UB1GameObjectUROComponent = {}


---@class UB1GameOptionComboBoxItemWidget : UB1UserWidgetBase
---@field BW_Text_Dropdown UB1TextBlock
---@field DimmedOpacity float
local UB1GameOptionComboBoxItemWidget = {}



---@class UB1GameOptionConfirm : UB1UserWidgetBase
---@field WBP_Button_Confirm UB1CommonButtonWidget
---@field BW_Button_Cancel UB1Button
---@field BW_Text_Time UB1TextBlock
---@field BW_Text_Desc UB1TextBlock
local UB1GameOptionConfirm = {}



---@class UB1GameOptionContentData : UObject
---@field ID FName
---@field Type EB1GameOption
---@field DisplayName FText
---@field bIsSubOption boolean
---@field UIType EB1GameOptionUIType
---@field MinSliderValue float
---@field MaxSliderValue float
---@field SliderUnit FText
---@field Selections TArray<FB1GameOptionSelectionData>
---@field IsOnValueChangedApply boolean
local UB1GameOptionContentData = {}



---@class UB1GameOptionContentListEntry : UB1UserListEntryWidgetBase
---@field ButtonAreaWidth float
---@field BW_Text_Option UB1TextBlock
---@field BW_Image_Line UB1Image
---@field BW_WidgetSwitcher_OptionType UB1WidgetSwitcher
---@field BW_Spacer_SubOption UB1Spacer
---@field BW_HorizontalBox_Select UB1HorizontalBox
---@field BW_Text_Select UB1TextBlock
---@field BW_Button_Previous UB1Button
---@field BW_Button_Next UB1Button
---@field BW_HorizontalBox_Slider UB1HorizontalBox
---@field BW_Text_Value UB1TextBlock
---@field BW_Text_Unit UB1TextBlock
---@field BW_Slider_Value UB1Slider
---@field BW_ProgressBar_Value UB1ProgressBar
---@field BW_HorizontalBox_Dropdown UB1HorizontalBox
---@field BW_ComboBoxKey_Dropdown UB1ComboBoxKey
---@field BW_CanvasPanel_Tab UB1CanvasPanel
---@field BW_HorizontalBox_Button UB1HorizontalBox
---@field BW_Button0 UB1Button
---@field BW_Button1 UB1Button
---@field BW_Button2 UB1Button
---@field BW_Button3 UB1Button
---@field BW_Button4 UB1Button
---@field BW_Button5 UB1Button
---@field BW_Text_Button0 UB1TextBlock
---@field BW_Text_Button1 UB1TextBlock
---@field BW_Text_Button2 UB1TextBlock
---@field BW_Text_Button3 UB1TextBlock
---@field BW_Text_Button4 UB1TextBlock
---@field BW_Text_Button5 UB1TextBlock
---@field BW_Image_Selected UB1Image
---@field BW_Image_Custom_BG UB1Image
---@field BW_CanvasPanel_CheckBox UB1CanvasPanel
---@field BW_CheckBox UB1CheckBox
---@field BW_CanvasPanel_Button_ClearPSOCache UB1CanvasPanel
---@field BW_Button_ClearPSOCache UB1Button
---@field BW_CanvasPanel_Button UWidget
---@field BW_Button_Benchmark UB1Button
---@field BW_CanvasPanel_Button_ModList UB1CanvasPanel
---@field BW_Button_ModList UB1Button
---@field BW_CanvasPanel_Button_ModKitList UB1CanvasPanel
---@field BW_Button_ModKitList UB1Button
---@field ContentData UB1GameOptionContentData
---@field BW_CanvasPanel_Button_KCN UB1CanvasPanel
---@field BW_Button_KCN UB1Button
---@field BW_CanvasPanel_Button_Licenses UB1CanvasPanel
---@field BW_Button_Licenses UB1Button
---@field BW_HorizontalBox_ButtonCopy UB1HorizontalBox
---@field BW_Text_Copy UB1TextBlock
---@field BW_Button_Copy UB1Button
local UB1GameOptionContentListEntry = {}

function UB1GameOptionContentListEntry:OnMouseCaptureEnd() end
---@param CreatedWidget UUserWidget
---@param ItemName FName
function UB1GameOptionContentListEntry:OnGenerateItemWidget(CreatedWidget, ItemName) end
---@param CreatedWidget UUserWidget
---@param ItemName FName
function UB1GameOptionContentListEntry:OnGenerateContentWidget(CreatedWidget, ItemName) end
---@param InName FName
---@param InSelectionType ESelectInfo::Type
function UB1GameOptionContentListEntry:OnDropdownSelectionChanged(InName, InSelectionType) end


---@class UB1GameOptionFunctionLibrary : UBlueprintFunctionLibrary
local UB1GameOptionFunctionLibrary = {}

---@param InOption int32
---@return boolean
function UB1GameOptionFunctionLibrary:IsLowOption(InOption) end


---@class UB1GameOptionGroupData : UObject
---@field ID FName
---@field DisplayName FText
---@field Description FText
---@field GameOptionIds TArray<FName>
local UB1GameOptionGroupData = {}



---@class UB1GameOptionGroupListEntry : UB1UserListEntryWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Description UB1TextBlock
---@field BW_ListView_Content UB1ListView
local UB1GameOptionGroupListEntry = {}



---@class UB1GameOptionMenuData : UObject
---@field ID FName
---@field DisplayName FText
---@field OptionGroupIds TArray<FName>
local UB1GameOptionMenuData = {}



---@class UB1GameOptionMenuListEntry : UB1UserListEntryWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field MenuData UB1GameOptionMenuData
local UB1GameOptionMenuListEntry = {}



---@class UB1GameOptionUIHandler : UB1UIHandlerBase
local UB1GameOptionUIHandler = {}


---@class UB1GameOptionWidget : UB1UserWidgetBase
---@field BW_Button_Reset UB1Button
---@field BW_ListView_Menu UB1ListView
---@field BW_ScrollBox_ContentGroup UB1ScrollBox
---@field BW_ListView_ContentGroup UB1ListView
---@field WBP_Common_Title UB1CommonTitleWidget
---@field WBP_GameOption_Confirm UB1GameOptionConfirm
---@field WBP_Button_Save UB1CommonButtonWidget
---@field WBP_Button_Load UB1CommonButtonWidget
---@field WBP_Button_Confirm UB1CommonButtonWidget
local UB1GameOptionWidget = {}



---@class UB1GameUserSettings : UGameUserSettings
---@field MassVehicleSpawnDensityMultiplier float
---@field MonitorID FString
---@field DisplayGamma float
---@field FOV float
---@field AnimationBudgetMs float
---@field SelectedResolutionSizeX uint32
---@field SelectedResolutionSizeY uint32
---@field SavedScreenPercentage float
---@field AutoScreenResolution boolean
---@field DynamicResolutionTargetFrame int32
---@field UpscalingMode EB1UpscalingMode
---@field DLSSValue uint8
---@field DLSSG boolean
---@field FSR3Value uint8
---@field FSR3FI boolean
---@field MetalFXValue uint8
---@field XeSSValue uint8
---@field AntiAliasingMethod int8
---@field ClothPhysics int8
---@field ClothPhysicsDistance int32
---@field MotionBlur int8
---@field NightExposureBias float
---@field DepthOfField int8
---@field DepthOfFieldQuality int8
---@field RayTracingQuality int32
---@field MeshQuality int32
---@field CharacterViewDistanceQuality int32
---@field LightViewDistanceQuality int32
---@field GameObjectCastShadows int32
---@field RayTracingNaniteQuality int32
---@field RayTracingNaniteMode int32
---@field GraphicPreset EB1GraphicsPreset
---@field bUseHardwareRaytracing boolean
---@field OcclusionMethod int32
---@field MasterSoundVolume float
---@field MusicSoundVolume float
---@field SFXSoundVolume float
---@field UISoundVolume float
---@field VoiceSoundVolume float
---@field CinematicsSoundVolume float
---@field CultureName FString
---@field UsePopupCloseCooltime boolean
---@field CharacterNameFormatOption EB1CharacterNameFormatOption
---@field bFirstRun boolean
---@field bDirectoryCheck boolean
---@field EnableAutoSave boolean
---@field AutoSaveInterval FTimespan
---@field bModEnable boolean
---@field RealTimeSecondsPerGameMinuteInDaytime int32
---@field GPULowStandardIndex int32
---@field MinResolutionWide int32
---@field SmartZoiActive int32
---@field SmartZoiAutonomyActive int32
---@field SmartZoiRangeInCity int32
---@field SmartZoiRangeInViewport int32
---@field SmartZoiWaitingCount int32
---@field Temperature EB1Temperature
---@field B1GameUserSettingsVersion int32
---@field MonitorIndex int32
local UB1GameUserSettings = {}



---@class UB1GameViewportClient : UGameViewportClient
local UB1GameViewportClient = {}


---@class UB1GaugeWidget : UB1UserWidgetBase
---@field BW_Image_Gauge UB1Image
---@field Anim_Gauge UWidgetAnimation
local UB1GaugeWidget = {}



---@class UB1GenerateMotionUIHandler : UB1UIHandlerBase
---@field Thumbnail UTexture2D
local UB1GenerateMotionUIHandler = {}



---@class UB1GenerateMotionWidget : UB1UserWidgetBase
---@field BW_Image_Tab UB1Image
---@field BW_Button_Video UB1Button
---@field BW_Button_Image UB1Button
---@field BW_Button_Text UB1Button
---@field BW_Text_Button_Video UB1TextBlock
---@field BW_Text_Button_Image UB1TextBlock
---@field BW_Text_Button_Text UB1TextBlock
---@field BW_WidgetSwitcher_GenerateMotion UB1WidgetSwitcher
---@field BW_Button_AddVideo UB1Button
---@field BW_Button_AddImage UB1Button
---@field BW_MultiLineEditableTextBox_Content UB1MultiLineEditableTextBox
---@field BW_WidgetSwitcher_Thumnail UB1WidgetSwitcher
---@field BW_Image_Thumbnail UB1Image
---@field BW_Button_Delete UB1Button
---@field BW_WidgetSwitcher_Desc UB1WidgetSwitcher
---@field BW_Button_Recreate UB1CommonButtonWidget
---@field BW_Button_Save UB1CommonButtonWidget
---@field BW_Button_Generate UB1CommonButtonWidget
---@field BW_Button_Thumbnail UB1CommonButtonWidget
---@field BW_WidgetSwitcher_ResultText UB1WidgetSwitcher
local UB1GenerateMotionWidget = {}



---@class UB1GeneratedMotionManager : UB1ManagerBase
---@field V2MRetargeter UIKRetargeter
---@field FreeV2MActors TArray<AActor>
---@field ActiveV2MActorMap TMap<TWeakObjectPtr<UObject>, AActor>
local UB1GeneratedMotionManager = {}



---@class UB1GoHomeAlertWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Button_GoBack UB1Button
local UB1GoHomeAlertWidget = {}



---@class UB1GppSettings : UDeveloperSettings
---@field Environment FName
local UB1GppSettings = {}

---@return FString
function UB1GppSettings:GetWebUrl() end
---@return FString
function UB1GppSettings:GetServiceUrl() end
---@return FName
function UB1GppSettings:GetEnvironment() end


---@class UB1GraphicsFunctionLibrary : UBlueprintFunctionLibrary
local UB1GraphicsFunctionLibrary = {}

---@param Comp UActorComponent
---@return boolean
function UB1GraphicsFunctionLibrary:UpdateCustomData(Comp) end
---@param StaticMeshComponent UStaticMeshComponent
---@param RayTracingGroupId int32
function UB1GraphicsFunctionLibrary:SetRayTracingGroupId(StaticMeshComponent, RayTracingGroupId) end
---@param ISMComp UInstancedStaticMeshComponent
---@param InstanceIndex int32
---@param alpha float
---@param bMarkRenderStateDirty boolean
---@return boolean
function UB1GraphicsFunctionLibrary:SetInstancedCustomDataAlpha(ISMComp, InstanceIndex, alpha, bMarkRenderStateDirty) end
---@param PrimComp UPrimitiveComponent
---@param alpha float
---@return boolean
function UB1GraphicsFunctionLibrary:SetCustomDataAlpha(PrimComp, alpha) end


---@class UB1GraphicsStatics : UDeveloperSettings
---@field DynamicPostProcessMaterials TMap<EB1Stencil, FSoftObjectPath>
local UB1GraphicsStatics = {}



---@class UB1HairAnimInstance : UB1AnimInstance
---@field bUseRigidBody boolean
---@field RigidBodyPhysicsAsset UPhysicsAsset
local UB1HairAnimInstance = {}



---@class UB1HeadAnimInstance : UB1AnimInstance
---@field bIsAnyMontagePlaying boolean
---@field bLiveLinkEnabled boolean
---@field LiveLinkSubjectName FLiveLinkSubjectName
---@field LiveLinkHeadRotation FRotator
---@field bEnableRigLogic boolean
---@field MaxLODToRigLogic int32
---@field FacePoseAnimSequenceAlpha TWeakObjectPtr<UAnimSequence>
---@field FacePoseAnimSequenceBeta TWeakObjectPtr<UAnimSequence>
---@field BlendAlpha float
---@field BlendSwitch boolean
---@field BlendTime float
---@field LowerFaceBlendDescription FB1CurveBlendDescription
---@field EyeLookAt FRotator
---@field EyeLookAtLimit FRotator
local UB1HeadAnimInstance = {}



---@class UB1HideScreenWidget : UB1UserWidgetBase
---@field Image_BG UB1Image
local UB1HideScreenWidget = {}



---@class UB1HomeButtonWidget : UB1UserWidgetBase
---@field BW_Button_Home UB1Button
local UB1HomeButtonWidget = {}



---@class UB1HopeChangeEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_Image_HopeIcon UB1Image
---@field BW_Text_DisplayName UB1TextBlock
---@field BW_Text_ReasonDesc UB1TextBlock
---@field BW_Text_Speechbubble UB1TextBlock
---@field BW_Text_CompleteEffectDesc UB1TextBlock
---@field BW_Button_Enable UB1Button
---@field BW_Button_Disable UB1Button
---@field BW_WidgetSwitcher_Check UB1WidgetSwitcher
local UB1HopeChangeEntryWidget = {}



---@class UB1HopeChangeUIHandler : UB1UIHandlerBase
local UB1HopeChangeUIHandler = {}


---@class UB1HopeChangeWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_ListView_Hope UB1ListView
local UB1HopeChangeWidget = {}



---@class UB1HopeIconWidget : UB1UserWidgetBase
---@field Button_Icon UB1Button
---@field Hope_Icon UB1Image
---@field BW_Image_Fx_BG UB1Image
---@field BW_Image_BuffIcon UB1Image
---@field BW_Image_BuffIconColor UB1Image
---@field BW_WBP_TImeGauge UB1HopeTimeGauge
---@field BW_Overlay_TimeOut UB1Overlay
local UB1HopeIconWidget = {}



---@class UB1HopeLifeListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_Image_SelectedHopeLife UB1Image
---@field BW_Text_HopeLife UB1TextBlock
local UB1HopeLifeListEntryWidget = {}



---@class UB1HopeLifeListItem : UObject
local UB1HopeLifeListItem = {}


---@class UB1HopeLifeUIHandler : UB1UIHandlerBase
local UB1HopeLifeUIHandler = {}


---@class UB1HopeLifeWidget : UB1UserWidgetBase
---@field BW_TileView_HopeLife UB1TileView
---@field BW_Text_HopeLife UB1TextBlock
---@field BW_Image_SelectedHopeLife UB1Image
---@field BW_RichText_HopeLifeDesc UB1RichTextBlock
---@field BW_RichText_HopeLifeInfo UB1RichTextBlock
---@field BW_Button_Complete UB1CommonButtonWidget
local UB1HopeLifeWidget = {}



---@class UB1HopeOverHeadAlertWidget : UB1UserWidgetBase
---@field CanvasPanel_OverHeadAlert UB1CanvasPanel
---@field Button_HopeOpen UB1Button
---@field Text_Title UB1TextBlock
---@field Image_Icon UB1Image
local UB1HopeOverHeadAlertWidget = {}

function UB1HopeOverHeadAlertWidget:OnClickedButtonHopeOpen() end


---@class UB1HopeTimeGauge : UB1UserWidgetBase
---@field BW_Image_Time UB1Image
---@field BW_ProgressBar_Time UB1ProgressBar
---@field NormalColor FLinearColor
---@field TimeCriticalColor FLinearColor
local UB1HopeTimeGauge = {}



---@class UB1HopeToolTipWidget : UB1TooltipWidgetBase
---@field Text_PinnedGuildText UB1TextBlock
---@field Text_DisplayName UB1TextBlock
---@field Text_ReasonDesc UB1TextBlock
---@field Text_Speechbubble UB1TextBlock
---@field Text_Desc UB1TextBlock
---@field Text_CompleteEffectDesc UB1TextBlock
---@field BW_Image_Hope UB1Image
local UB1HopeToolTipWidget = {}



---@class UB1HopeUIHandler : UB1HopeUIHandlerBase
local UB1HopeUIHandler = {}


---@class UB1HopeUIHandlerBase : UB1UIHandlerBase
local UB1HopeUIHandlerBase = {}


---@class UB1HopeWidget : UB1UserWidgetBase
---@field WBP_HUD_HopeIcon_1 UB1HopeIconWidget
---@field WBP_HUD_HopeIcon_2 UB1HopeIconWidget
---@field WBP_HUD_HopeIcon_3 UB1HopeIconWidget
---@field WBP_HUD_HopeIcon_4 UB1HopeIconWidget
---@field BW_Button_Close UB1Button
local UB1HopeWidget = {}



---@class UB1HouseholdManager : UB1ManagerBase
local UB1HouseholdManager = {}


---@class UB1HudHopeWidget : UB1HopeWidget
local UB1HudHopeWidget = {}


---@class UB1HudSkillWidget : UB1UserWidgetBase
---@field BW_WBP_Entry0 UB1SkillEntryWidget
---@field BW_WBP_Entry1 UB1SkillEntryWidget
---@field BW_WBP_Entry2 UB1SkillEntryWidget
---@field BW_WBP_Entry3 UB1SkillEntryWidget
local UB1HudSkillWidget = {}



---@class UB1HudWindow : UB1WindowBase
local UB1HudWindow = {}


---@class UB1IKComponent : USceneComponent
local UB1IKComponent = {}


---@class UB1ImageTo3DFileManager : UB1ManagerBase
---@field ImageTo3DFiles TMap<FString, FB1ImageTo3DFile>
local UB1ImageTo3DFileManager = {}



---@class UB1ImageTo3DUIHandler : UB1UIHandlerBase
local UB1ImageTo3DUIHandler = {}


---@class UB1IngameFirstStartFlowManager : UB1ManagerBase
local UB1IngameFirstStartFlowManager = {}


---@class UB1InputSettingManager : UB1ManagerBase
---@field InputMappingContextSetting UB1InputMappingContextDataAsset
---@field InputActionSetting UB1InputActionSettingDataAsset
local UB1InputSettingManager = {}



---@class UB1InteracteeComponent : UActorComponent
---@field InteractionMeshNames TArray<FName>
local UB1InteracteeComponent = {}

---@param InTouchedComponent UPrimitiveComponent
function UB1InteracteeComponent:OnComponentEndCursorOverForParent(InTouchedComponent) end
---@param InTouchedComponent UPrimitiveComponent
function UB1InteracteeComponent:OnComponentEndCursorOver(InTouchedComponent) end
---@param InTouchedComponent UPrimitiveComponent
function UB1InteracteeComponent:OnComponentBeginCursorOverForParent(InTouchedComponent) end
---@param InTouchedComponent UPrimitiveComponent
function UB1InteracteeComponent:OnComponentBeginCursorOver(InTouchedComponent) end


---@class UB1InteractionComponent : UActorComponent
local UB1InteractionComponent = {}

function UB1InteractionComponent:OnAnimInitialized() end


---@class UB1InteractionEmoticon : UB1UserWidgetBase
local UB1InteractionEmoticon = {}


---@class UB1InteractionExitButton : UB1UserWidgetBase
---@field BW_Button UB1Button
local UB1InteractionExitButton = {}



---@class UB1InteractionUIHandler : UB1UIHandlerBase
---@field CategorySelectionHolder TMap<FName, UB1ObjectSelectionData>
---@field InteractionSelectionHolder TMap<FName, UB1ObjectSelectionData>
local UB1InteractionUIHandler = {}

---@param Object UObject
function UB1InteractionUIHandler:OnListEntrySelected(Object) end
---@param Object UObject
function UB1InteractionUIHandler:OnListEntryHovered(Object) end


---@class UB1IntroWidget : UB1UserWidgetBase
---@field BW_WBP_VideoPlayer UB1VideoPlayerWidget
---@field MediaSource FSoftObjectPath
local UB1IntroWidget = {}



---@class UB1InventoryComponent : UActorComponent
local UB1InventoryComponent = {}


---@class UB1InventorySlotEntryData : UObject
---@field ObjectEntityId FB1EntityId
---@field ObjectDtId FName
---@field bHasProgress boolean
---@field progress float
---@field DisplayName FText
---@field DisplayDescription FText
local UB1InventorySlotEntryData = {}



---@class UB1InventorySlotWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Overlay_Pause UB1Overlay
---@field Data UB1InventorySlotEntryData
local UB1InventorySlotWidget = {}



---@class UB1InventoryUIHandler : UB1UIHandlerBase
---@field DataList TArray<UB1InventorySlotEntryData>
local UB1InventoryUIHandler = {}



---@class UB1InventoryWidget : UB1UserWidgetBase
---@field BW_TileView_Slot UB1TileView
---@field BW_Button_Close UB1Button
---@field BW_Text_name UB1TextBlock
---@field BW_Overlay_SlotButton UB1Overlay
---@field BW_Button_Delete UB1CommonButtonWidget
---@field BW_Button_PutDown UB1CommonButtonWidget
---@field BW_Button_Publish UB1CommonButtonWidget
---@field BW_Button_Continue UB1CommonButtonWidget
---@field BW_Button_Sell UB1CommonButtonWidget
local UB1InventoryWidget = {}



---@class UB1IssueReportWidget : UB1UserWidget
---@field BW_ReportText UB1MultiLineEditableText
---@field BW_TitleText UB1MultiLineEditableText
---@field BW_Category UB1ComboBoxString
---@field BW_Report UB1Button
---@field BW_Close UB1Button
local UB1IssueReportWidget = {}



---@class UB1JobInfoWidget : UB1UserWidgetBase
---@field WBP_Company UB1MyCompanyWidget
local UB1JobInfoWidget = {}



---@class UB1JobMissionButtonWidget : UB1UserWidgetBase
---@field Button_JobMission UB1Button
local UB1JobMissionButtonWidget = {}



---@class UB1JobMissionListEntryWidget : UB1UserWidgetBase
---@field ProgressBar_JobMission UB1ProgressBar
---@field Text_Mission UB1TextBlock
---@field Text_LeftTime UB1TextBlock
---@field Text_MissionCount UB1TextBlock
---@field Text_MissionCountMax UB1TextBlock
---@field Text_CompleteRewardPlus UB1TextBlock
---@field Text_CompleteRewardMinus UB1TextBlock
---@field Image_JobReward UB1Image
---@field Anim_Generate UWidgetAnimation
---@field bIsFinish boolean
---@field bIsSuccess boolean
local UB1JobMissionListEntryWidget = {}



---@class UB1JobMissionSubTitleListEntryWidget : UB1UserWidgetBase
---@field BW_Text_SubTitle UB1TextBlock
---@field BW_Image_ContractIcon UB1Image
local UB1JobMissionSubTitleListEntryWidget = {}



---@class UB1JobMissionTitleListEntryWidget : UB1UserWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Image_AppIcon UB1Image
---@field BW_Image_BG UB1Image
---@field BW_Button_Fold UB1Button
---@field BW_Button_Summit UB1CommonButtonWidget
---@field Anim_Fold UWidgetAnimation
---@field Anim_Summit UWidgetAnimation
---@field Anim_Generate UWidgetAnimation
---@field BW_WBP_SubTitleListEntry UB1JobMissionSubTitleListEntryWidget
---@field BW_VerticalBox_Mission UB1VerticalBox
---@field BW_MissionOverlay UB1Overlay
---@field SlotWidgetClass TSubclassOf<UUserWidget>
---@field MissionEntryWidgetList TArray<UB1JobMissionListEntryWidget>
local UB1JobMissionTitleListEntryWidget = {}



---@class UB1JobMissionWidget : UB1UserWidgetBase
---@field WBP_JobMissionEmpty_Text UB1TextBlock
---@field BW_ScrollBox_JobMission UB1ScrollBox
---@field BW_VerticalBox_JobMission UB1VerticalBox
---@field SlotWidgetClass TSubclassOf<UUserWidget>
---@field EntryWidgetMap TMap<FName, UB1JobMissionTitleListEntryWidget>
local UB1JobMissionWidget = {}



---@class UB1JobRequirementInfo : UObject
local UB1JobRequirementInfo = {}


---@class UB1JobSearchJobInfo : UObject
local UB1JobSearchJobInfo = {}


---@class UB1JobSearchJobPromotionInfo : UObject
local UB1JobSearchJobPromotionInfo = {}


---@class UB1JobSearchMainCategoryInfo : UObject
local UB1JobSearchMainCategoryInfo = {}


---@class UB1JobSearchSubCategoryInfo : UObject
local UB1JobSearchSubCategoryInfo = {}


---@class UB1JobSearchUIHandler : UB1UIHandlerBase
local UB1JobSearchUIHandler = {}


---@class UB1KCNInputPopUpWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_KCN UB1WidgetSwitcher
---@field BW_EditableTextBox_KCNCode UB1EditableTextBox
---@field BW_Button_Erase UB1Button
---@field BW_Button_RecentCode UB1Button
---@field BW_TextBlock_RecentCode UB1TextBlock
---@field BW_Image_UnderLine UB1Image
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Confirm UB1CommonButtonWidget
---@field BW_TextBlock_CurrentCode UB1TextBlock
---@field BW_Button_Edit UB1CommonButtonWidget
---@field BW_Button_Submit UB1CommonButtonWidget
---@field BW_Button_Edit_None UB1CommonButtonWidget
---@field BW_Button_Edit_AlreadyApplied UB1CommonButtonWidget
---@field BW_HorizontalBox_RecentCode UB1HorizontalBox
local UB1KCNInputPopUpWidget = {}

---@param InText FText
function UB1KCNInputPopUpWidget:OnCodeInputFieldChanged(InText) end
function UB1KCNInputPopUpWidget:NativeOnInitialized() end


---@class UB1KarmaReportActionWidget : UB1UserWidgetBase
local UB1KarmaReportActionWidget = {}


---@class UB1KarmaReportContentZoIListWidget : UB1UserWidgetBase
---@field ZoIListWidgetClass TSubclassOf<UUserWidget>
---@field BW_WidgetSwitcher_List UB1WidgetSwitcher
---@field BW_WBP_SearchBox_Zoi UB1KarmaReportSearchBoxWidget
---@field BW_VerticalBox_ZoiList UB1VerticalBox
---@field ZoIListWidgetList TArray<UB1KarmaReportZoIListWidget>
local UB1KarmaReportContentZoIListWidget = {}



---@class UB1KarmaReportDashBoardWidget : UB1UserWidgetBase
---@field WBP_KarmaReport_Danger UB1KarmaReportStateWidget
---@field WBP_KarmaReport_Warning UB1KarmaReportStateWidget
---@field WBP_KarmaReport_Normal UB1KarmaReportStateWidget
---@field WBP_KarmaReport_Good UB1KarmaReportStateWidget
---@field BW_ProgressBar_Graph_0 UB1ProgressBar
---@field BW_ProgressBar_Graph_1 UB1ProgressBar
---@field BW_ProgressBar_Graph_2 UB1ProgressBar
---@field BW_ProgressBar_Graph_3 UB1ProgressBar
---@field BW_ProgressBar_Graph_4 UB1ProgressBar
---@field BW_ProgressBar_Graph_5 UB1ProgressBar
---@field BW_ProgressBar_Graph_6 UB1ProgressBar
---@field BW_Text_GraphTitle_0 UB1TextBlock
---@field BW_Text_GraphTitle_1 UB1TextBlock
---@field BW_Text_GraphTitle_2 UB1TextBlock
---@field BW_Text_GraphTitle_3 UB1TextBlock
---@field BW_Text_GraphTitle_4 UB1TextBlock
---@field BW_Text_GraphTitle_5 UB1TextBlock
---@field BW_Text_GraphTitle_6 UB1TextBlock
---@field BW_ProgressBar_Zoi UB1ProgressBar
---@field BW_ProgressBar_Ghost UB1ProgressBar
---@field BW_SizeBox_ZoiGraph UB1SizeBox
---@field BW_Text_ZoiNum UB1TextBlock
---@field BW_Text_GhostNum UB1TextBlock
---@field GraphProgressBarList TArray<UB1ProgressBar>
---@field GraphTitleList TArray<UB1TextBlock>
---@field KarmaReportStateList TArray<UB1KarmaReportStateWidget>
local UB1KarmaReportDashBoardWidget = {}



---@class UB1KarmaReportHermanWidget : UB1UserWidgetBase
---@field BW_Button_OK UB1CommonButtonWidget
local UB1KarmaReportHermanWidget = {}



---@class UB1KarmaReportSearchBoxWidget : UB1UserWidgetBase
---@field BW_EditableTextBox_SearchBox UB1EditableTextBox
---@field BW_Button_Search UB1Button
---@field InputStr FString
local UB1KarmaReportSearchBoxWidget = {}

---@param InText FText
---@param InCommitInfo ETextCommit::Type
function UB1KarmaReportSearchBoxWidget:OnTextCommitted(InText, InCommitInfo) end
---@param InText FText
function UB1KarmaReportSearchBoxWidget:OnTextChanged(InText) end


---@class UB1KarmaReportStateWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_State UB1WidgetSwitcher
local UB1KarmaReportStateWidget = {}



---@class UB1KarmaReportTabWidget : UB1UserWidgetBase
---@field ID FName
---@field Type EB1KarmaReportMenuType
---@field BW_Image_Icon UB1Image
---@field BW_Text_Title UB1TextBlock
---@field BW_Button_Select UB1Button
---@field BW_WBP_Alert UB1MobileAppAlertIconWidget
local UB1KarmaReportTabWidget = {}



---@class UB1KarmaReportUIHandler : UB1UIHandlerBase
---@field KarmaReportWidget UB1KarmaReportWidget
---@field KarmaReportActionWidget UB1KarmaReportActionWidget
local UB1KarmaReportUIHandler = {}



---@class UB1KarmaReportWidget : UB1UserWidgetBase
---@field WBP_KarmaReport_State UB1KarmaReportStateWidget
---@field BW_WidgetSwitcher_Content UB1WidgetSwitcher
---@field BW_CanvasPanel_Alert UB1CanvasPanel
---@field WBP_KarmaReport_Tab UB1KarmaReportTabWidget
---@field WBP_KarmaReport_Tab_1 UB1KarmaReportTabWidget
---@field WBP_KarmaReport_Tab_2 UB1KarmaReportTabWidget
---@field WBP_KarmaReport_Tab_3 UB1KarmaReportTabWidget
---@field BW_WBP_Content_DashBoard UB1KarmaReportDashBoardWidget
---@field BW_WBP_Content_ZoiList UB1KarmaReportContentZoIListWidget
---@field WBP_KarmaReport_Content_Herman UB1KarmaReportHermanWidget
---@field KarmaReportTabWidgetList TArray<UB1KarmaReportTabWidget>
local UB1KarmaReportWidget = {}



---@class UB1KarmaReportZoIListEntryData : UObject
---@field OwnerId FB1EntityId
---@field Portrait TSoftObjectPtr<UTexture2D>
---@field FamilyName FText
---@field ZoIName FText
---@field SliderValue float
---@field KarmaText FText
---@field KarmaRangeTextColor FSlateColor
---@field CoolTimeText FText
---@field InvolvingText FText
---@field bIsCoolTime boolean
---@field bIsGhost boolean
---@field bIsAlarm boolean
---@field bIsDimmed boolean
local UB1KarmaReportZoIListEntryData = {}



---@class UB1KarmaReportZoIListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_WBP_Alert UB1MobileAppAlertIconWidget
---@field BW_Image_Portrait UB1Image
---@field BW_Image_Ghost UB1Image
---@field BW_Text_FamilyName UB1TextBlock
---@field BW_Text_name UB1TextBlock
---@field BW_WBP_Karma_Slider UB1CatOperatorSliderWidget
---@field BW_Text_Karma UB1TextBlock
---@field BW_Button_KarmaAction UB1Button
---@field BW_Overlay_CoolTime UB1Overlay
---@field BW_Text_CoolTime UB1TextBlock
---@field BW_Text_KarmaAction UB1TextBlock
---@field BW_Image_Dimmed UB1Image
local UB1KarmaReportZoIListEntryWidget = {}



---@class UB1KarmaReportZoIListWidget : UB1UserWidgetBase
---@field BW_Text_Step UB1TextBlock
---@field BW_Text_Num UB1TextBlock
---@field BW_ListView_ZoiList UB1ListView
local UB1KarmaReportZoIListWidget = {}



---@class UB1KeyGuidePopupWidget : UB1UserWidgetBase
---@field BW_Button_Optional_Close UB1Button
---@field BW_Image_Overlay UB1Image
local UB1KeyGuidePopupWidget = {}



---@class UB1LevelSequenceManager : UB1ManagerBase
---@field PlayerCinemaPlayerList TMap<EB1GenderType, AB1CinemaCharacter>
---@field TargetCinemaPlayerList TMap<EB1GenderType, AB1CinemaCharacter>
---@field GarmentDataHolder TArray<UObject>
local UB1LevelSequenceManager = {}



---@class UB1LiveLinkComponent : UActorComponent
local UB1LiveLinkComponent = {}

---@return boolean
function UB1LiveLinkComponent:IsEnabled() end
---@return boolean
function UB1LiveLinkComponent:IsConnected() end


---@class UB1LiveLinkSubjectData : UObject
local UB1LiveLinkSubjectData = {}


---@class UB1LoadingScreenAITextureWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_LoadingText UB1WidgetSwitcher
---@field BW_WBP_Title UB1CommonTitleWidget
local UB1LoadingScreenAITextureWidget = {}



---@class UB1LoadingScreenWidget : UB1UserWidgetBase
---@field BW_Text_Tip UB1TextBlock
local UB1LoadingScreenWidget = {}



---@class UB1LoadingUIHandler : UB1UIHandlerBase
local UB1LoadingUIHandler = {}


---@class UB1LobbyButtonCNWidget : UB1UserWidgetBase
---@field BW_Button_Event UB1CommonButtonWidget
---@field BW_Button_Redeem UB1CommonButtonWidget
local UB1LobbyButtonCNWidget = {}



---@class UB1LobbyButtonDiscordWidget : UB1UserWidgetBase
---@field BW_Button_Steam UB1CommonButtonWidget
---@field BW_Button_Discord UB1CommonButtonWidget
---@field BW_Button_News UB1CommonButtonWidget
local UB1LobbyButtonDiscordWidget = {}



---@class UB1LobbyButtonWidget : UB1UserWidgetBase
---@field BW_Button UB1Button
---@field BW_Text_Button UB1TextBlock
---@field BW_Overlay_Demo UB1Overlay
---@field DimmedOpacity float
---@field ButtonText FText
---@field bIsDemo boolean
local UB1LobbyButtonWidget = {}

---@param InText FText
function UB1LobbyButtonWidget:SetButtonText(InText) end
---@param bInDimmed boolean
function UB1LobbyButtonWidget:SetButtonDimmed(bInDimmed) end


---@class UB1LobbyGalleryUserProfileWidget : UB1UserWidgetBase
---@field BW_Image_Profile UB1Image
---@field BW_Text_UserNickname UB1TextBlock
---@field BW_Widget_VerifiedCreator UWidget
---@field BW_WidgetSwitcher_CreatorLevel UB1WidgetSwitcher
---@field BW_Text_Follower UB1TextBlock
---@field BW_Text_Following UB1TextBlock
---@field CreatorLevelToWidgetNameMap TMap<FName, FName>
---@field OriginalResourceObject UObject
local UB1LobbyGalleryUserProfileWidget = {}



---@class UB1LobbyGalleryWidget : UB1UserWidgetBase
---@field BW_WebBrowser UB1WebBrowser
local UB1LobbyGalleryWidget = {}

function UB1LobbyGalleryWidget:ShouldLogout() end
function UB1LobbyGalleryWidget:OnLoginAvailable() end
function UB1LobbyGalleryWidget:OnGetDownloadList() end
function UB1LobbyGalleryWidget:OnFileSelect() end
function UB1LobbyGalleryWidget:IsLobbyTablet() end
---@param InText FText
function UB1LobbyGalleryWidget:BW_WebBrowser_OnUrlChanged(InText) end


---@class UB1LookAtComponent : USceneComponent
---@field debug boolean
---@field Radius float
---@field Angle float
local UB1LookAtComponent = {}



---@class UB1MainMenuUIHandler : UB1UIHandlerBase
local UB1MainMenuUIHandler = {}


---@class UB1MainMenuWidget : UB1UserWidgetBase
---@field BW_WBP_Button_Continue UB1LobbyButtonWidget
---@field BW_WBP_Button_NewGame UB1LobbyButtonWidget
---@field BW_WBP_Button_Exit UB1LobbyButtonWidget
---@field BW_WBP_Button_Option UB1LobbyButtonWidget
---@field BW_WBP_Button_Mod UB1LobbyButtonWidget
---@field BW_WBP_Button_CharacterStudio UB1LobbyButtonWidget
---@field BW_WBP_Button_BuildWorld UB1LobbyButtonWidget
---@field BW_WBP_Button_CN UB1LobbyButtonCNWidget
---@field BW_Text_Version UB1TextBlock
local UB1MainMenuWidget = {}



---@class UB1ManagerBase : UObject
---@field Components TArray<UB1ManagerComponentBase>
local UB1ManagerBase = {}



---@class UB1ManagerComponentBase : UObject
local UB1ManagerComponentBase = {}


---@class UB1MapCompassWidget : UB1UserWidgetBase
local UB1MapCompassWidget = {}


---@class UB1MapContextMenuWidget : UB1UserWidgetBase
---@field VerticalBox_Menu UB1VerticalBox
---@field BW_VerticalBox_CommonMenu UB1VerticalBox
---@field Button_Move UB1Button
---@field Text_MoveButton UB1TextBlock
---@field Image_MoveButton UB1Image
---@field BW_Button_MoveTogether UB1Button
---@field BW_Button_AutoDrive UB1Button
---@field BW_Button_MoveHouse UB1Button
---@field BW_CanvasPanel_AutoDriveButton UB1CanvasPanel
---@field BW_CanvasPanel_MoveHouse UB1CanvasPanel
---@field Button_Play UB1CommonButtonWidget
---@field Button_StartPlay UB1CommonButtonWidget
---@field Button_FamilyCasting UB1CommonButtonWidget
local UB1MapContextMenuWidget = {}



---@class UB1MapFamilyListPopUpWidget : UB1UserWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_WidgetSwitcher_Toolbar UB1WidgetSwitcher
---@field BW_WidgetSwitcher_FamilyInfo UB1WidgetSwitcher
---@field BW_Button_ZoiChange UB1CommonButtonWidget
---@field BW_Button_DeleteMode UB1Button
---@field BW_Button_SortingMode UB1Button
---@field BW_Button_FilterMode UB1Button
---@field BW_Button_Close UB1Button
---@field BW_Button_Cancel UB1Button
---@field BW_Button_DeleteModeCancel UB1Button
---@field BW_Button_DeleteModeComplete UB1Button
---@field BW_Button_GalleryUpload UB1CommonButtonWidget
---@field BW_Button_FamilyEdit UB1CommonButtonWidget
---@field BW_Button_OK UB1CommonButtonWidget
---@field BW_TileView_FamilyList UB1TileView
---@field BW_SelectModeFamilySlot UB1FamilyEditPopupFamilySlot
---@field BW_FamilyMoveModeFamilySlot1 UB1FamilyEditPopupFamilySlot
---@field BW_FamilyMoveModeFamilySlot2 UB1FamilyEditPopupFamilySlot
---@field BW_Text_Desc UB1TextBlock
---@field BW_CharacterSlot1 UB1FamilyEditPopupCharacterSlot
---@field BW_CharacterSlot2 UB1FamilyEditPopupCharacterSlot
---@field BW_CharacterSlot3 UB1FamilyEditPopupCharacterSlot
---@field BW_CharacterSlot4 UB1FamilyEditPopupCharacterSlot
---@field BW_CharacterSlot5 UB1FamilyEditPopupCharacterSlot
---@field BW_CharacterSlot6 UB1FamilyEditPopupCharacterSlot
---@field BW_CharacterSlot7 UB1FamilyEditPopupCharacterSlot
---@field BW_CharacterSlot8 UB1FamilyEditPopupCharacterSlot
---@field BW_WBP_Currency UB1CurrencyWidget
---@field CharacterSlotList TArray<UB1FamilyEditPopupCharacterSlot>
local UB1MapFamilyListPopUpWidget = {}

function UB1MapFamilyListPopUpWidget:OnZoiChangeButtonClicked() end
function UB1MapFamilyListPopUpWidget:OnSortingModeButtonClicked() end
function UB1MapFamilyListPopUpWidget:OnOKButtonClicked() end
function UB1MapFamilyListPopUpWidget:OnGalleryUploadButtonClicked() end
---@param InNewFamilyId FB1EntityId
function UB1MapFamilyListPopUpWidget:OnFinishMakeNewFamily(InNewFamilyId) end
function UB1MapFamilyListPopUpWidget:OnFilterModeButtonClicked() end
function UB1MapFamilyListPopUpWidget:OnFamilyMoveModeCancelButtonClicked() end
---@param InSelectedEntry UObject
function UB1MapFamilyListPopUpWidget:OnFamilyListEntryClicked(InSelectedEntry) end
function UB1MapFamilyListPopUpWidget:OnFamilyEditButtonClicked() end
function UB1MapFamilyListPopUpWidget:OnDeleteModeCompleteButtonClicked() end
function UB1MapFamilyListPopUpWidget:OnDeleteModeCancelButtonClicked() end
function UB1MapFamilyListPopUpWidget:OnDeleteModeButtonClicked() end
function UB1MapFamilyListPopUpWidget:OnCloseButtonClicked() end


---@class UB1MapFamilyMoveInfoWidget : UB1UserWidgetBase
---@field BW_Text_FamilyName UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
local UB1MapFamilyMoveInfoWidget = {}



---@class UB1MapFamilyMoveOptionPopupWIdget : UB1UserWidgetBase
---@field FamilyMoveSlot0 UB1MapFamilyMoveSlotWidget
---@field FamilyMoveSlot1 UB1MapFamilyMoveSlotWidget
---@field Button_Back UB1CommonButtonWidget
---@field Button_Play UB1CommonButtonWidget
local UB1MapFamilyMoveOptionPopupWIdget = {}

---@param InOption int32
function UB1MapFamilyMoveOptionPopupWIdget:OnSiteOptionButtonClicked(InOption) end
function UB1MapFamilyMoveOptionPopupWIdget:OnPlayButtonClicked() end
---@param InOption int32
function UB1MapFamilyMoveOptionPopupWIdget:OnFamilyOptionButtonClicked(InOption) end
function UB1MapFamilyMoveOptionPopupWIdget:OnBackButtonClicked() end


---@class UB1MapFamilyMoveSlotOptionWidget : UB1UserWidgetBase
---@field BW_Button_Option UB1Button
---@field BW_Text_Option UB1TextBlock
---@field BW_CheckBox_Option UB1CheckBox
---@field BW_Image_Info UB1Image
local UB1MapFamilyMoveSlotOptionWidget = {}



---@class UB1MapFamilyMoveSlotWidget : UB1UserWidgetBase
---@field BW_Image_Family UB1Image
---@field Text_FamilyName UB1TextBlock
---@field BW_HorizontalBox_SiteName UB1HorizontalBox
---@field BW_Text_SiteName UB1TextBlock
---@field BW_Button_Info UB1Button
---@field BW_WidgetSwitcher_Desc UB1WidgetSwitcher
---@field BW_WBP_Option_0 UB1MapFamilyMoveSlotOptionWidget
---@field BW_WBP_Option_1 UB1MapFamilyMoveSlotOptionWidget
---@field BW_WBP_Option_2 UB1MapFamilyMoveSlotOptionWidget
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Text_Desc_Currency UB1TextBlock
local UB1MapFamilyMoveSlotWidget = {}

---@param InOptionIndex int32
function UB1MapFamilyMoveSlotWidget:OnOption_ButtonClicked(InOptionIndex) end


---@class UB1MapFamilySelectWidget : UB1UserWidgetBase
---@field Image_Select UB1Image
---@field Button_Tab_MyFamily UB1Button
---@field Text_Button_MyFamily UB1TextBlock
---@field Button_Tab_Gallery UB1Button
---@field Text_Button_Gallery UB1TextBlock
---@field TileView_FamilyList UB1TileView
---@field Button_Back UB1CommonButtonWidget
---@field Button_Confirm UB1CommonButtonWidget
local UB1MapFamilySelectWidget = {}

function UB1MapFamilySelectWidget:OnMyFamilyButtonClicked() end
function UB1MapFamilySelectWidget:OnGalleryButtonClicked() end
---@param InNewFamilyId FB1EntityId
function UB1MapFamilySelectWidget:OnFinishMakeNewFamily(InNewFamilyId) end
---@param InSelectedEntry UObject
function UB1MapFamilySelectWidget:OnFamilyListEntryClicked(InSelectedEntry) end
function UB1MapFamilySelectWidget:OnConfirmButtonClicked() end
function UB1MapFamilySelectWidget:OnBackButtonClicked() end


---@class UB1MapNavigatorSubMenuListWidget : UB1UserWidgetBase
---@field BW_DynamicEntryBox_SubMenu UB1DynamicEntryBox
local UB1MapNavigatorSubMenuListWidget = {}



---@class UB1MapNavigatorUIHandler : UB1UIHandlerBase
---@field NavigatorWidget UB1MapNavigatorWidget
local UB1MapNavigatorUIHandler = {}



---@class UB1MapNavigatorWidget : UB1UserWidgetBase
---@field BW_DynamicEntryBox_MainMenu UB1DynamicEntryBox
---@field BW_Panel_SubMenuArea UB1CanvasPanel
---@field ImageSelect UB1Image
---@field BW_Button_Back UB1Button
---@field SubMenuListWidgetClass TSubclassOf<UB1MapNavigatorSubMenuListWidget>
local UB1MapNavigatorWidget = {}



---@class UB1MapPinButtonWidget : UB1UserWidgetBase
---@field Image_Point UB1Image
---@field Anim_Point UWidgetAnimation
---@field Anim_Pinned UWidgetAnimation
---@field B1ScaleBox UB1ScaleBox
local UB1MapPinButtonWidget = {}



---@class UB1MapPlayerPortraitWidget : UB1UserWidgetBase
---@field B1ScaleBox UB1ScaleBox
---@field IMG_Portrait UB1Image
---@field IMG_ColorBorder UImage
---@field BW_Button_Portrait UB1Button
---@field BW_CharacterDirection UB1CanvasPanel
---@field DefaultPortrait TSoftObjectPtr<UTexture>
local UB1MapPlayerPortraitWidget = {}



---@class UB1MapSiteInfoWidget : UB1UserWidgetBase
---@field Text_SiteName UB1TextBlock
---@field Text_FamilyName UB1TextBlock
---@field Text_FamilyDescription UB1TextBlock
---@field Button_Close UB1Button
---@field Button_MoveOut UB1Button
---@field Image_Site UB1Image
---@field Image_SiteIcon UB1Image
---@field BW_Image_SiteIconBg UB1Image
---@field Text_SiteType UB1TextBlock
---@field BW_CheckBox_Shoes UB1CheckBox
---@field BW_Widget_Price UWidget
---@field BW_WBP_Currency UB1CurrencyWidget
---@field Text_SitePrice UB1TextBlock
---@field BW_Widget_Size UWidget
---@field Text_SiteSize UB1TextBlock
---@field BW_Widget_OperatingHours UWidget
---@field BW_Text_OperatingHours UB1TextBlock
---@field BW_Widget_SubInfo UWidget
---@field Button_GodBuild UB1CommonButtonWidget
---@field Button_StartPlay UB1CommonButtonWidget
---@field Button_FamilyEdit UB1CommonButtonWidget
---@field BW_Button_MoveHouse UB1CommonButtonWidget
---@field Text_CastingInProgress UB1TextBlock
---@field BW_Widget_FamilyLove UWidget
---@field BW_Text_FamilyLove UB1TextBlock
---@field BW_Slider_FamilyLove UB1Slider
---@field BW_Widget_Cleanliness UWidget
---@field BW_ProgressBar_CleanlinessNegative UB1ProgressBar
---@field BW_ProgressBar_CleanlinessPositive UB1ProgressBar
---@field BW_Text_ZOINumber UB1TextBlock
local UB1MapSiteInfoWidget = {}



---@class UB1MapSiteSelectMessageWidget : UB1UserWidgetBase
---@field Text_Title UB1TextBlock
---@field BW_Button_Cancel UB1Button
---@field Message FText
local UB1MapSiteSelectMessageWidget = {}



---@class UB1MapUIHandler : UB1UIHandlerBase
---@field MapWidget UB1MapWidget
---@field CachedPathPointActors TArray<AB1PathPoint>
local UB1MapUIHandler = {}



---@class UB1MapWidget : UB1UserWidgetBase
---@field BW_Panel_MapMarkerArea UB1CanvasPanel
---@field BW_VerticalBox_CityText UB1VerticalBox
---@field Text_City_Name UB1TextBlock
---@field Text_City_Desc UB1TextBlock
---@field Map_PlayerPortrait UB1MapPlayerPortraitWidget
---@field Map_ContextMenu UB1MapContextMenuWidget
---@field Map_PinButton UB1MapPinButtonWidget
---@field FamilyMoveOptionPopUp UB1MapFamilyMoveOptionPopupWIdget
---@field BW_WBP_FamilyMoveInfo UB1MapFamilyMoveInfoWidget
---@field Map_Compass_Widget UB1MapCompassWidget
---@field Map_SiteInfo_Widget UB1MapSiteInfoWidget
---@field Map_SiteSelectMessage UB1MapSiteSelectMessageWidget
---@field BW_WBP_FamilyListPopUp UB1MapFamilyListPopUpWidget
---@field BW_Button_FamilyList UB1CommonButtonWidget
---@field SiteInfoWidgets TMap<FName, UB1SiteInfoButtonWidget>
---@field SubwayInfoWidgets TMap<FName, UB1SiteInfoButtonWidget>
local UB1MapWidget = {}



---@class UB1MaterialParameterCollectionManager : UB1ManagerBase
---@field MaterialParameterCollectionTable TMap<FName, UMaterialParameterCollection>
local UB1MaterialParameterCollectionManager = {}



---@class UB1MaterialTooltipWidget : UB1TooltipWidgetBase
---@field BW_Image_Material UB1Image
---@field BW_Text_name UB1TextBlock
local UB1MaterialTooltipWidget = {}



---@class UB1MeshMatchDataAsset : UB1DataAssetBase
---@field SourceMesh TSoftObjectPtr<USkeletalMesh>
---@field TargetMeshes TArray<TSoftObjectPtr<USkeletalMesh>>
local UB1MeshMatchDataAsset = {}



---@class UB1MeshMatcher : UAssetUserData
local UB1MeshMatcher = {}


---@class UB1MissionEntryData : UObject
local UB1MissionEntryData = {}


---@class UB1MissionWidget : UB1UserListEntryWidgetBase
---@field Image_Complete UB1Image
---@field Image_Incomplete UB1Image
---@field Text_Index UB1TextBlock
---@field Text_MissionDesc UB1TextBlock
---@field Text_Count UB1TextBlock
---@field BW_Image_InProgress UB1Image
---@field BW_Image_Mark UB1Image
---@field EntryData UB1MissionEntryData
local UB1MissionWidget = {}



---@class UB1MobileAppAlertIconWidget : UB1UserWidgetBase
---@field Text_AlertNum UB1TextBlock
---@field Image_alertFX UB1Image
local UB1MobileAppAlertIconWidget = {}



---@class UB1MobileContactAppWidget : UB1SmartphoneAppWidgetBase
---@field WBP_Mobile_Contact UB1MobileContactWidget
local UB1MobileContactAppWidget = {}



---@class UB1MobileContactListEntry : UB1UserListEntryWidgetBase
---@field Image_Profile UB1Image
---@field Image_Dimmed UB1Image
---@field Text_name UB1TextBlock
---@field WBP_GiftButton UB1CommonButtonWidget
---@field WBP_GiftAlertIcon UB1MobileAppAlertIconWidget
local UB1MobileContactListEntry = {}

function UB1MobileContactListEntry:OnGiftButtonClick() end


---@class UB1MobileContactListEntryData : UObject
---@field OwnWidget UB1MobileContactListEntry
---@field Icon UTexture
local UB1MobileContactListEntryData = {}



---@class UB1MobileContactSendGiftWidget : UB1UserWidgetBase
---@field BW_Panel_Tooltip UWidget
---@field BW_WBP_SendGiftEntry_1 UB1MobileSendGiftEntryWidget
---@field BW_WBP_SendGiftEntry_2 UB1MobileSendGiftEntryWidget
---@field BW_WBP_SendGiftEntry_3 UB1MobileSendGiftEntryWidget
---@field BW_WBP_SendGiftEntry_4 UB1MobileSendGiftEntryWidget
---@field BW_WBP_SendGiftEntry_5 UB1MobileSendGiftEntryWidget
---@field BW_WBP_SendGiftEntry_6 UB1MobileSendGiftEntryWidget
---@field BW_WBP_SendGiftEntry_7 UB1MobileSendGiftEntryWidget
---@field BW_WBP_SendGiftEntry_8 UB1MobileSendGiftEntryWidget
---@field BW_WBP_SendGiftEntry_9 UB1MobileSendGiftEntryWidget
local UB1MobileContactSendGiftWidget = {}

---@param InTargetId FB1EntityId
---@param InGiftId FName
function UB1MobileContactSendGiftWidget:OnClickSendGiftEntry(InTargetId, InGiftId) end


---@class UB1MobileContactUIHandler : UB1UIHandlerBase
local UB1MobileContactUIHandler = {}

---@param InEntry UB1MobileContactListEntry
---@param InTarget FB1EntityId
---@param InGiftIdList TArray<FName>
function UB1MobileContactUIHandler:ShowRelationshipGiftWidget(InEntry, InTarget, InGiftIdList) end


---@class UB1MobileContactWidget : UB1UserWidgetBase
---@field Button_Close UB1Button
---@field TileView_ContactList UB1TileView
---@field CachedEntryMap TMap<FB1EntityId, UB1MobileContactListEntryData>
local UB1MobileContactWidget = {}

function UB1MobileContactWidget:OnClickClose() end
---@param InEntry UB1MobileContactListEntry
function UB1MobileContactWidget:HandleSelectEntry(InEntry) end


---@class UB1MobileMessageAppWidget : UB1SmartphoneAppWidgetBase
---@field WBP_Mobile_Message UB1MobileMessageListWidget
---@field WBP_Mobile_Message_Popup UB1MobileMessagePopupWidget
local UB1MobileMessageAppWidget = {}

function UB1MobileMessageAppWidget:OnClosePopup() end
---@param InObjectId FB1EntityId
---@param InSenderSystemId FName
function UB1MobileMessageAppWidget:OnClickMessage(InObjectId, InSenderSystemId) end


---@class UB1MobileMessageDialogChoiceWidget : UB1UserWidgetBase
---@field ID int32
---@field ChoiceText FText
---@field Text_Desc UB1TextBlock
---@field Button UB1Button
local UB1MobileMessageDialogChoiceWidget = {}

function UB1MobileMessageDialogChoiceWidget:OnClickButton() end


---@class UB1MobileMessageDialogWidget : UB1UserWidgetBase
---@field MessageText FText
---@field TimestampText FText
---@field RelationshipScoreText FText
---@field RelationshipId FName
---@field RelationshipPointVisible boolean
---@field bWaitMessage boolean
---@field Text_Message UB1TextBlock
---@field BW_Text_Message UB1RichTextBlock
---@field Text_Timestamp UB1TextBlock
---@field Text_RelationshipScore UB1TextBlock
---@field WBP_RelationshipIcon UB1RelationshipIconWidget
---@field WidgetSwitcher_Typing UB1WidgetSwitcher
local UB1MobileMessageDialogWidget = {}



---@class UB1MobileMessageListEntryData : UObject
---@field OwnWidget UB1MobileMessageListEntryWidget
---@field Icon UTexture
local UB1MobileMessageListEntryData = {}



---@class UB1MobileMessageListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Alert UB1Image
---@field BW_Image_Profile UB1Image
---@field BW_Image_Pressed UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_Text_Time UB1TextBlock
---@field BW_RichText_Description UB1RichTextBlock
---@field BW_Button UB1Button
---@field BW_Image_Dimmed UB1Image
---@field BW_Image_Psykhet UB1Image
---@field BW_WidgetSwitcher_Icon UB1WidgetSwitcher
local UB1MobileMessageListEntryWidget = {}



---@class UB1MobileMessageListWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field TileView_list UB1TileView
local UB1MobileMessageListWidget = {}

function UB1MobileMessageListWidget:OnClickClose() end
---@param InEntry UB1MobileMessageListEntryWidget
function UB1MobileMessageListWidget:HandleSelectEntry(InEntry) end


---@class UB1MobileMessageManager : UB1ManagerBase
local UB1MobileMessageManager = {}


---@class UB1MobileMessagePopupWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Image_Profile UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_ScrollBox_Dialog UB1ScrollBox
---@field BW_Choice_Slot0 UB1MobileMessageDialogChoiceWidget
---@field BW_Choice_Slot1 UB1MobileMessageDialogChoiceWidget
---@field BW_Choice_Slot2 UB1MobileMessageDialogChoiceWidget
---@field BW_WidgetSwitcher_Icon UB1WidgetSwitcher
---@field DefaultPortrait TSoftObjectPtr<UTexture>
local UB1MobileMessagePopupWidget = {}

function UB1MobileMessagePopupWidget:OnClickClose() end
---@param InId int32
function UB1MobileMessagePopupWidget:OnClickChoice(InId) end


---@class UB1MobileSendGiftEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Thumbnail UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_WBP_Relationship_Tag UB1RelationshipTagWidget
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Button_SendGift UB1Button
---@field BW_Image_Dimmed UB1Image
local UB1MobileSendGiftEntryWidget = {}

function UB1MobileSendGiftEntryWidget:OnClickButton() end


---@class UB1MobileToastMessageWidget : UB1UserWidgetBase
---@field BW_Text_Message UB1TextBlock
local UB1MobileToastMessageWidget = {}



---@class UB1ModKitAssetDownloadEntryWidget : UB1UserListEntryWidgetBase
---@field BW_WidgetSwitcher_Slot UB1WidgetSwitcher
---@field BW_Image_Thumbnail UB1Image
---@field BW_Image_Icon UB1Image
---@field EntryData UB1ModKitAssetListEntryData
local UB1ModKitAssetDownloadEntryWidget = {}



---@class UB1ModKitAssetDownloadPopUp : UB1UserWidgetBase
---@field BW_HorizontalBox_Button UB1HorizontalBox
---@field BW_WBP_CommonButton_Cancel UB1CommonButtonWidget
---@field BW_WBP_CommonButton_OK UB1CommonButtonWidget
---@field BW_WBP_CommonButton_Download UB1CommonButtonWidget
---@field BW_Text_Number UB1TextBlock
---@field BW_WidgetSwitcher_Desc UB1WidgetSwitcher
---@field BW_TreeView_AssetList UB1TreeView
---@field BW_DynamicEntryBox_AssetList UB1DynamicEntryBox
---@field WhiteListDataAssets TArray<UB1WhiteListDataAsset>
---@field AssetTreeMap TMap<UB1ModKitAssetListEntryData, FB1ModKitAssetWrapper>
---@field ModKitAssetMap TMap<EB1AssetCategory, FB1ModKitAssetDataWrapper>
---@field SelectedAssets TMap<UB1ModKitAssetListEntryData, UUserWidget>
local UB1ModKitAssetDownloadPopUp = {}

---@param Item UObject
---@param bExpanded boolean
function UB1ModKitAssetDownloadPopUp:OnItemExpansionChanged(Item, bExpanded) end
---@param Item UObject
---@param OutChildren TArray<UObject>
function UB1ModKitAssetDownloadPopUp:OnGetItemChildren(Item, OutChildren) end


---@class UB1ModKitAssetListEntryData : UObject
---@field AssetData FB1ModKitAssetData
local UB1ModKitAssetListEntryData = {}



---@class UB1ModKitAssetListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_WidgetSwitcher_Icon UB1WidgetSwitcher
---@field BW_Text_Desc UB1TextBlock
---@field BW_CheckBox_Option UB1CheckBox
---@field BW_Image_Icon UB1Image
---@field EntryData UB1ModKitAssetListEntryData
---@field PaddingOffsetValue int32
---@field TypeIconThumbnail TMap<EB1AssetCategory, UTexture2D>
local UB1ModKitAssetListEntryWidget = {}



---@class UB1ModKitAssetsDownload : UObject
local UB1ModKitAssetsDownload = {}


---@class UB1ModListEntryData : UObject
---@field mod UB1Mod
local UB1ModListEntryData = {}



---@class UB1ModListEntryWidget : UB1CommonFilterListEntryWidget
---@field EntryData UB1ModListEntryData
local UB1ModListEntryWidget = {}

---@param bCheck boolean
function UB1ModListEntryWidget:OnCheckStateChanged(bCheck) end


---@class UB1ModListPopUpWidget : UB1UserWidgetBase
---@field BW_Button_Back UB1CommonButtonWidget
---@field BW_Button_Confirm UB1CommonButtonWidget
---@field BW_WBP_FilterCheck_All UB1CommonFilterListEntryWidget
---@field BW_ListView_ModList UB1ListView
local UB1ModListPopUpWidget = {}

---@param bCheck boolean
function UB1ModListPopUpWidget:OnFilterCheckAllClicked(bCheck) end


---@class UB1ModSubsystem : UGameInstanceSubsystem
local UB1ModSubsystem = {}


---@class UB1ModUIHandler : UB1UIHandlerBase
---@field ModListPopUpWidget UB1ModListPopUpWidget
local UB1ModUIHandler = {}



---@class UB1ModalMessageBox : UB1ModalWindow
---@field Title UTextBlock
---@field Message UTextBlock
local UB1ModalMessageBox = {}

function UB1ModalMessageBox:OnConfirmButtonClicked() end
function UB1ModalMessageBox:OnCancelButtonClicked() end


---@class UB1ModalWindow : UB1WindowBase
local UB1ModalWindow = {}


---@class UB1MorphTargetUserData : UAssetUserData
---@field MorphTargetDatas TArray<FB1MorphTargetData>
local UB1MorphTargetUserData = {}



---@class UB1MoveTogetherButtonGroupWidget : UB1UserWidgetBase
---@field BW_Button_MoveTogether UB1CommonButtonWidget
---@field BW_Button_Cancel UB1Button
---@field BW_CancelButton_Overlay UB1Overlay
---@field BW_Button_MoveTogetherConfirm UB1Button
---@field BW_WidgetSwitcher_Button UB1WidgetSwitcher
---@field BW_RichText_MoveTogetherConfirm UB1RichTextBlock
local UB1MoveTogetherButtonGroupWidget = {}



---@class UB1MoveTogetherDialogWidget : UB1UserWidgetBase
---@field BW_Button_Cancel UB1CommonButtonWidget
local UB1MoveTogetherDialogWidget = {}



---@class UB1MoveTogetherListEntryWidget : UB1UserListEntryWidgetBase
---@field Portrait UB1Image
---@field CharacterName UB1TextBlock
---@field RelationshipName UB1TextBlock
---@field RelationshipGaugeEntry UB1DynamicEntryBox
local UB1MoveTogetherListEntryWidget = {}



---@class UB1MoveTogetherListWidget : UB1UserWidgetBase
---@field TileView UB1TileView
---@field SearchBox UB1EditableTextBox
---@field B1Button_Search UB1Button
---@field BW_Button_Close UB1Button
---@field BW_Button_Start UB1CommonButtonWidget
local UB1MoveTogetherListWidget = {}

function UB1MoveTogetherListWidget:ToggleWidget() end


---@class UB1MyCareerPathData : UObject
local UB1MyCareerPathData = {}


---@class UB1MyCompanyCareerPathEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_JobPosition UB1TextBlock
---@field BW_Text_Headcount UB1TextBlock
---@field BW_Text_WorkSummary UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Widget_MyPosition UWidget
---@field BW_Overlay_CareerLine UWidget
---@field BW_Image_CareerLine UB1Image
local UB1MyCompanyCareerPathEntryWidget = {}



---@class UB1MyCompanyCareerPathWidget : UB1UserWidgetBase
---@field BW_Image_CompanyIcon UB1Image
---@field BW_ListView UB1ListView
local UB1MyCompanyCareerPathWidget = {}



---@class UB1MyCompanyInfoWidget : UB1UserWidgetBase
---@field BW_WBP_WorkingConditions UB1SmartphoneJobSearchWorkingConditionsWidget
local UB1MyCompanyInfoWidget = {}



---@class UB1MyCompanyReputationBarWidget : UB1UserWidgetBase
---@field BW_Widget_Bar UWidget
---@field BW_Image_BG UB1Image
---@field BW_Image_Gradient UB1Image
---@field BW_Widget_Value UWidget
---@field BW_Text_Value UB1TextBlock
---@field FillType EB1MyCompanyReputationBarFillType
---@field GaugeBarMinHeight float
---@field TextPaddingTop float
---@field TextPaddingBottom float
---@field BgTintColor FSlateColor
---@field GradientTintColor FSlateColor
local UB1MyCompanyReputationBarWidget = {}



---@class UB1MyCompanyReputationChangeWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_ReputationChange UB1WidgetSwitcher
---@field BW_Text_AddNumber UB1TextBlock
---@field BW_Text_SubtractNumber UB1TextBlock
---@field Anim_Open UWidgetAnimation
local UB1MyCompanyReputationChangeWidget = {}



---@class UB1MyCompanyReputationWidget : UB1UserWidgetBase
---@field BW_Text_Promotion UB1TextBlock
---@field BW_Text_Demotion UB1TextBlock
---@field BW_Text_ProgressTitle UB1TextBlock
---@field BW_WBP_BarPositive UB1MyCompanyReputationBarWidget
---@field BW_WBP_BarNegative UB1MyCompanyReputationBarWidget
---@field BW_WBP_ReputationChange UB1MyCompanyReputationChangeWidget
---@field MaxLevelColor FSlateColor
---@field NormalLevelColor FSlateColor
local UB1MyCompanyReputationWidget = {}



---@class UB1MyCompanyUIHandler : UB1UIHandlerBase
local UB1MyCompanyUIHandler = {}


---@class UB1MyCompanyWidget : UB1UserWidgetBase
---@field BW_Text_CompanyName UB1TextBlock
---@field BW_Image_CompanyIcon UB1Image
---@field BW_Image_Profile UB1Image
---@field BW_WBP_Reputation UB1MyCompanyReputationWidget
---@field BW_Text_JobName UB1TextBlock
---@field BW_Text_JobPosition UB1TextBlock
---@field BW_Text_CharacterName UB1TextBlock
---@field BW_Button_Location UB1CommonButtonWidget
---@field BW_Button_Vacation UB1CommonButtonWidget
---@field BW_Button_Leave UB1CommonButtonWidget
---@field BW_Button_Info UB1CommonButtonWidget
---@field BW_Button_CareerPath UB1CommonButtonWidget
---@field BW_WBP_Info UB1MyCompanyInfoWidget
---@field BW_WBP_CareerPath UB1MyCompanyCareerPathWidget
---@field BW_Text_WorkDayCount UB1TextBlock
---@field BW_Text_DayOffCount UB1TextBlock
---@field BW_Text_AbsentDayCount UB1TextBlock
---@field BW_Image_AbsentDayCountBg UB1Image
---@field BW_Text_RankTitle UB1TextBlock
---@field BW_Text_JobRole UB1TextBlock
---@field BW_WBP_ChooseCareerLine UB1CommonButtonWidget
---@field BW_Text_WorkDay UB1TextBlock
---@field BW_Text_Vacation UB1TextBlock
---@field BW_Text_AbsentDay UB1TextBlock
---@field BW_Button_Close UB1Button
---@field BW_WBP_CloseButton UB1CommonButtonWidget
---@field BW_VerticalBox_Portrait UB1VerticalBox
---@field BW_WBP_Portrait UB1PlayerPortraitWidget
---@field BW_Text_InfoTilte UB1TextBlock
---@field BW_Image_Glow UB1Image
---@field BW_WBP_Top UB1SmartphoneHeaderWidget
---@field BW_Image_BottomBG UB1Image
local UB1MyCompanyWidget = {}



---@class UB1MyCompanyWorkStateWidget : UB1UserWidgetBase
---@field BW_WBP_WorkState UB1UserWidgetBase
---@field BW_Button_GoToWork UB1CommonButtonWidget
---@field BW_Widget_Late UWidget
---@field BW_Text_Late UB1TextBlock
local UB1MyCompanyWorkStateWidget = {}



---@class UB1MyGalleryManager : UB1ManagerBase
local UB1MyGalleryManager = {}


---@class UB1NetworkManager : UB1ManagerBase
local UB1NetworkManager = {}

function UB1NetworkManager:OnDisconnected() end
function UB1NetworkManager:OnConnectionFailed() end
function UB1NetworkManager:OnConnected() end
---@return boolean
function UB1NetworkManager:IsConnected() end
---@return FString
function UB1NetworkManager:GetServerTag() end
function UB1NetworkManager:Disconnect() end
---@return boolean
function UB1NetworkManager:ConnectToServer() end


---@class UB1NewGameSubsystem : UGameInstanceSubsystem
---@field bIsNewGame boolean
---@field CustomizedFamily TArray<FB1CustomizedFamily>
local UB1NewGameSubsystem = {}



---@class UB1NpcTalkWidget : UB1UserWidgetBase
---@field BW_Image_ScreenImageBg UB1Image
---@field BW_Image_ScreenImage UB1Image
---@field BW_Button_CallStart UB1Button
---@field BW_Button_CallEnd UB1Button
---@field BW_Widget_VoiceOn UWidget
---@field BW_ScrollBox_ChatArea UB1ScrollBox
---@field BW_WBP_ChatHistory UB1ChatHistoryWidget
---@field BW_Panel_AnswerButtonArea UPanelWidget
---@field AnswerButtonWidgetClass TSubclassOf<UB1CommonButtonWidget>
local UB1NpcTalkWidget = {}



---@class UB1NumericPopupWidget : UB1UserWidgetBase
---@field BW_Price_TextBlock UB1TextBlock
---@field BW_Price_Text_Box UB1EditableTextBox
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Confirm UB1CommonButtonWidget
---@field MinValue int64
---@field MaxValue int64
local UB1NumericPopupWidget = {}

---@param InText FText
---@param InCommitType ETextCommit::Type
function UB1NumericPopupWidget:OnTextCommited(InText, InCommitType) end
---@param InText FText
function UB1NumericPopupWidget:OnTextChanged(InText) end


---@class UB1ObjectAreaBoxComponent : UBoxComponent
---@field bUseMeshBoundsForAreaBox boolean
---@field bUseMeshCollisionBox boolean
---@field bIsCeil boolean
---@field AreaBoxSize FUintVector
---@field IgnoreComponentNames TArray<FName>
local UB1ObjectAreaBoxComponent = {}



---@class UB1ObjectCustomizeComponent : UActorComponent
---@field AuthorName FString
local UB1ObjectCustomizeComponent = {}



---@class UB1ObjectCustomizeUIHandler : UB1UIHandlerBase
---@field GizmoList TArray<AB1GizmoActor>
---@field WallCornerActors TArray<AB1WallCornerActor>
---@field DraggingWall AB1DraggingWall
---@field ElevatingWalls AB1ElevatingWalls
---@field TransformStairs AB1TransformStairs
---@field RoofExtend AB1RoofExtend
---@field PillarHeight AB1PillarHeight
---@field DraggingFence AB1DraggingFence
---@field ChangingFloorHeight AB1ChangingFloorHeight
---@field OriginalMesh AB1GameObject
local UB1ObjectCustomizeUIHandler = {}



---@class UB1ObjectEntryData : UObject
---@field ObjectTableId FName
---@field FilterCategory FName
---@field ConditionId FName
---@field Texture TSoftObjectPtr<UObject>
---@field PresetTableId FName
---@field Image_Preset UTexture
---@field AssetTable UDataTable
local UB1ObjectEntryData = {}



---@class UB1ObjectEntryListWidget : UB1UserListEntryWidgetBase
---@field Image_BG UB1Image
---@field BW_WidgetSwitcher_ImageType UB1WidgetSwitcher
---@field BW_Image_Thumbnail UB1Image
---@field BW_Image_Thumbnail_Jpg UB1Image
---@field BW_Button_Click UB1Button
---@field BW_Button_Delete UB1Button
---@field BW_Button_Gallery UB1Button
---@field BW_WBP_Currency UB1CurrencyWidget
---@field Image_Icon_Gold UB1Image
---@field BW_Text_Gold UB1TextBlock
---@field CheckIconPanel UB1CanvasPanel
---@field BW_Text_DEV UB1TextBlock
---@field BW_WidgetSwitcher_Loading UB1WidgetSwitcher
---@field BW_CanvasPanel_Download UB1CanvasPanel
---@field BW_CanvasPanel_LoadingThumbnail UB1CanvasPanel
---@field BW_Horizontal_Box UB1HorizontalBox
---@field BW_CheckBox_Delete UB1CheckBox
---@field BW_CanvasPanel_Lock UB1CanvasPanel
---@field BW_Image_BG_Locked UB1Image
---@field EntryData UB1ObjectEntryData
local UB1ObjectEntryListWidget = {}



---@class UB1ObjectEntryTooltipWidget : UB1TooltipWidgetBase
---@field BW_WidgetSwitcher_ImageType UB1WidgetSwitcher
---@field Image_Icon UB1Image
---@field BW_Image_Icon_Jpg UB1Image
---@field Text_Title UB1TextBlock
---@field Text_description UB1TextBlock
---@field Text_price UB1TextBlock
---@field Image_Currency UB1Image
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_ListView_Lock UB1ListView
---@field BW_Overlay_Ingredient UB1Overlay
---@field BW_Text_Title_Utensil UB1TextBlock
---@field BW_ListView_Utensil UB1ListView
---@field BW_Text_Title_Ingredient UB1TextBlock
---@field BW_ListView_Ingredient UB1ListView
---@field BW_Button_Gallery UB1Image
---@field BW_ListView_Info UB1ListView
---@field BW_HorizontalBox_NickName UB1HorizontalBox
---@field BW_Text_NickName UB1TextBlock
---@field BW_HorizontalBox_SellPrice UB1HorizontalBox
---@field BW_WBP_SellPrice UB1CurrencyWidget
---@field BW_WBP_ProgressBar UB1CraftingProgressBarWidget
local UB1ObjectEntryTooltipWidget = {}



---@class UB1ObjectInteractionListEntry : UB1UserListEntryWidgetBase
---@field Parent UCanvasPanel
---@field Child UCanvasPanel
---@field CategoryTab UOverlay
---@field CategoryTabText UTextBlock
---@field content UOverlay
---@field BW_Text_Content UTextBlock
---@field SizeBox_Tag UB1SizeBox
---@field Text_Tag UTextBlock
---@field Image_BG UB1Image
---@field BW_Image_Icon UB1Image
---@field WidgetSwitcher_Like UB1WidgetSwitcher
---@field BW_SizeBox_LeftMarker UB1SizeBox
---@field BW_Image_LeftMarkerBG UB1Image
---@field BW_Image_LeftMarkerIcon UB1Image
---@field BW_Text_LeftMarker UB1TextBlock
---@field BW_Image_CategoryOpen UB1Image
---@field BW_WBP_IconWithBG UB1RelationshipIconWidget
---@field BW_Overlay_Currency UB1Overlay
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Image_Karma UB1Image
---@field BW_Overlay_InProgressMarker UB1Overlay
---@field BW_Overlay_AddMotion UB1Overlay
---@field BW_Overlay_Thumnail UB1Overlay
---@field BW_WidgetSwitcher_Thumnail UB1WidgetSwitcher
---@field BW_Image_Thumbnail UB1Image
---@field BW_Overlay_MotionMarker UB1Overlay
---@field BW_CheckBox_Delete UB1CheckBox
---@field Data UB1ObjectSelectionData
local UB1ObjectInteractionListEntry = {}

---@param Ratio float
---@return float
function UB1ObjectInteractionListEntry:SetHorizontalTranslateRatio(Ratio) end
---@return UB1ObjectSelectionData
function UB1ObjectInteractionListEntry:GetData() end


---@class UB1ObjectInteractionPanel : UB1UserWidgetBase
---@field ListView UListView
---@field BW_ListView_Select UListView
---@field BW_SizeBox_List UB1SizeBox
---@field TitleText UTextBlock
---@field Text_FamilyName UTextBlock
---@field WidgetSwitcher UWidgetSwitcher
---@field BG_Scroll_Wheel_L UImage
---@field BG_Scroll_Wheel_R UImage
---@field InteractionCanvas UCanvasPanel
---@field BW_CanvasPanel_TwoDepth UCanvasPanel
---@field BW_WidgetSwitcher_Mode UB1WidgetSwitcher
---@field BW_Button_Delete UB1Button
---@field BW_Button_DeleteModeCancel UB1Button
---@field BW_Button_DeleteModeComplete UB1Button
---@field CurveFloat UCurveFloat
local UB1ObjectInteractionPanel = {}



---@class UB1ObjectListContainer : UB1UserWidgetBase
---@field TextTitle UB1TextBlock
---@field TextCount UB1TextBlock
---@field TileView_FurnitureList UB1TileView
---@field B1VerticalBox UB1VerticalBox
local UB1ObjectListContainer = {}



---@class UB1ObjectListTabButtonWidget : UB1UserWidgetBase
---@field Icon TSoftObjectPtr<UTexture2D>
local UB1ObjectListTabButtonWidget = {}

---@param InSelected boolean
function UB1ObjectListTabButtonWidget:Select(InSelected) end
---@param InSelected boolean
function UB1ObjectListTabButtonWidget:OnSelect(InSelected) end


---@class UB1ObjectListWidget : UB1UserWidgetBase
---@field WidgetSwitcher_Tab UB1WidgetSwitcher
---@field B1ScrollBox_ListScroll UB1ScrollBox
---@field ListContainerBox UB1VerticalBox
---@field WBP_Build_CeilingViewBtn UB1CeilingModeEnterButton
---@field WBP_Build_PresetList UB1PresetListContainer
---@field WBP_Build_Customize_List UB1ObjectListContainer
---@field Text_Title UB1TextBlock
---@field Text_Gold UB1TextBlock
---@field VerticalBox_Category UB1VerticalBox
---@field BW_HorizontalBox_Category UB1HorizontalBox
---@field Button_All UB1BuildCategoryButton
---@field BW_WBP_Default_CategoryButton UB1BuildCategoryWidget
---@field BW_Image_Currency UB1Image
---@field BW_WBP_Currency UB1CurrencyWidget
---@field WBP_Build_List_Preset UB1ObjectListTabButtonWidget
---@field WBP_Build_List_Furniture UB1ObjectListTabButtonWidget
---@field WBP_Build_List_Construct UB1ObjectListTabButtonWidget
---@field WBP_Build_List_Inven UB1ObjectListTabButtonWidget
---@field WBP_Build_List_Making UB1ObjectListTabButtonWidget
---@field BW_HorizontalBox_Making UB1HorizontalBox
---@field BW_WBP_BannerListEntry01 UB1BannerListEntryWidget
---@field BW_WBP_BannerListEntry02 UB1BannerListEntryWidget
---@field BW_ConstructBox UB1VerticalBox
---@field BW_WidgetSwitcher_Mode UB1WidgetSwitcher
---@field BW_CanvasPanel_Category UB1CanvasPanel
---@field BW_WBP_BuildCategory UB1BuildCategoryPanel
---@field BW_Button_DeleteMode UB1Button
---@field BW_Button_DeleteModeComplete UB1Button
---@field BW_Button_DeleteModeCancel UB1Button
---@field BW_Button_Sorting UB1Button
---@field BW_Button_Filter UB1Button
---@field BW_WBP_Filter UB1CheckListWidget
---@field BW_WBP_Filter_v2 UB1CommonFilterWidget
---@field BW_Button_Gallery UB1Button
---@field BW_Button_GalleryUploadComplete UB1Button
---@field BW_SizeBox_Category UB1SizeBox
---@field BW_CanvasPanel_CategoryTitle UB1CanvasPanel
---@field BW_CanvasPanel_Search UB1CanvasPanel
---@field BW_WBP_SearchBox UB1BuildSearchBox
---@field BW_Image_Blank UB1Image
---@field BW_Text_Stock UB1TextBlock
---@field SelectedList TSet<UB1UserListEntryWidgetBase>
---@field ShapeCustomizeIcon TSoftObjectPtr<UTexture2D>
---@field ShapeCustomizeDisplayNameTextId FString
---@field ShapeCustomizeDescriptionTextId FString
local UB1ObjectListWidget = {}

function UB1ObjectListWidget:OnEnterCeilMode() end
---@param InMode EB1ObjectListMode
---@param InBuildWorld boolean
function UB1ObjectListWidget:OnConstructChanged(InMode, InBuildWorld) end
---@param InWidget UB1ObjectListTabButtonWidget
---@param InSelected boolean
function UB1ObjectListWidget:OnChangeListTab(InWidget, InSelected) end


---@class UB1ObjectPathDataAsset : UB1DataAssetBase
---@field FollowCameraClass TSubclassOf<UB1CameraMode>
---@field FreeCameraClass TSubclassOf<UB1CameraMode>
---@field TopCameraClass TSubclassOf<UB1CameraMode>
---@field VehicleCameraClass TSubclassOf<UB1CameraMode>
---@field CloseUpClass TSubclassOf<UB1CameraMode>
---@field BuildModeClass TSubclassOf<UB1CameraMode>
---@field CCTVModeClass TSubclassOf<UB1CameraMode>
---@field MapModeClass TSubclassOf<UB1CameraMode>
---@field TraitModeClass TSubclassOf<UB1CameraMode>
---@field LevelSequenceClass TSubclassOf<UB1CameraMode>
---@field PhotoModeCameraClass TSubclassOf<UB1CameraMode>
---@field GenerateMotionClass TSubclassOf<UB1CameraMode>
---@field SceneConfigClass TSubclassOf<UB1SceneConfig>
---@field CharacterStartEffectClass TSubclassOf<AB1CharacterStartEffect>
---@field CharacterDestIndicatorClass TSubclassOf<AB1CharacterDestIndicator>
---@field CharacterDestIndicatorNotWalkableClass TSubclassOf<AB1CharacterDestIndicator>
---@field MyFixedDeskIndicator TSubclassOf<AB1CharacterDestIndicator>
---@field MoveTogetherDestIndicator TSubclassOf<AB1CharacterDestIndicator>
---@field MyCarIndicator TSubclassOf<AB1CharacterDestIndicator>
---@field StreamingSourceActor TSubclassOf<AB1StreamingSourceActor>
---@field CharacterClass TSubclassOf<AB1Character>
---@field SiteAreaClass TSubclassOf<AB1SiteArea>
---@field VehicleStationSpawnFXClass TSubclassOf<UB1FXObject>
---@field DustFloorActor TSubclassOf<AB1GameObject>
local UB1ObjectPathDataAsset = {}



---@class UB1ObjectPopUpDescriptionUIHandler : UB1UIHandlerBase
local UB1ObjectPopUpDescriptionUIHandler = {}


---@class UB1ObjectPopupDescriptionWidget : UB1UserWidgetBase
---@field BW_ObjectEntryTooltipWidget UB1ObjectEntryTooltipWidget
local UB1ObjectPopupDescriptionWidget = {}



---@class UB1ObjectSoundSubsystem : UGameInstanceSubsystem
---@field ObjectSoundCacheData TMap<FB1EntityId, FB1ObjectSoundCacheData>
local UB1ObjectSoundSubsystem = {}



---@class UB1ObjectWeatheringComponent : UActorComponent
local UB1ObjectWeatheringComponent = {}


---@class UB1OscReceiver : UObject
---@field Port int32
---@field LastUpdateTime FDateTime
local UB1OscReceiver = {}



---@class UB1OutfitCategoryEntryWidget : UB1UserWidgetBase
---@field OutfitCategory EB1OutfitCategory
---@field BW_Button_Outfit UB1Button
---@field BW_Image_Icon UB1Image
---@field ButtonImage TSoftObjectPtr<UTexture2D>
local UB1OutfitCategoryEntryWidget = {}



---@class UB1OverrideLowerFaceMetaData : UAnimMetaData
---@field alpha float
---@field CurveMap TMap<FName, float>
local UB1OverrideLowerFaceMetaData = {}



---@class UB1PackedLevelComponent : UB1PackedLevelComponentBase
---@field IsEnableInfo boolean
---@field B1CullDistance boolean
---@field IsSkipHLOD boolean
---@field IsCollisionMeshTypeCheck boolean
---@field IsPerInstanceDistance boolean
---@field bEnableAutoUpdate boolean
---@field bEnableAutoSave boolean
local UB1PackedLevelComponent = {}



---@class UB1PacketSystem : UB1PacketSystemBase
local UB1PacketSystem = {}


---@class UB1PerformanceStatSubSystem : UWorldSubsystem
local UB1PerformanceStatSubSystem = {}

---@param OutText FText
---@param OutColor FLinearColor
---@return boolean
function UB1PerformanceStatSubSystem:DisplayViewportMessage(OutText, OutColor) end


---@class UB1PerformanceTelemetryComponent : UB1ManagerComponentBase
local UB1PerformanceTelemetryComponent = {}


---@class UB1PerspectiveChangeWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field Text_PerspectiveNum UB1TextBlock
---@field BW_DynamicEntryBox_List UB1DynamicEntryBox
local UB1PerspectiveChangeWidget = {}



---@class UB1PerspectiveDetailInfoWidget : UB1CatOperatorChangeWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Text_GraphTitle_0 UB1TextBlock
---@field BW_Text_GraphTitle_1 UB1TextBlock
---@field BW_Text_GraphTitle_2 UB1TextBlock
---@field BW_Text_GraphTitle_3 UB1TextBlock
---@field BW_Text_GraphTitle_4 UB1TextBlock
---@field BW_Text_GraphTitle_5 UB1TextBlock
---@field BW_Text_GraphTitle_6 UB1TextBlock
---@field BW_Text_GraphTitle_7 UB1TextBlock
---@field BW_Text_GraphTitle_8 UB1TextBlock
---@field BW_Text_GraphTitle_9 UB1TextBlock
---@field BW_Image_TraitTooltip_0 UB1Image
---@field BW_Image_TraitTooltip_1 UB1Image
---@field BW_Image_TraitTooltip_2 UB1Image
---@field BW_Image_TraitTooltip_3 UB1Image
---@field BW_Image_TraitTooltip_4 UB1Image
---@field BW_Image_TraitTooltip_5 UB1Image
---@field BW_Image_TraitTooltip_6 UB1Image
---@field BW_Image_TraitTooltip_7 UB1Image
---@field BW_Image_TraitTooltip_8 UB1Image
---@field BW_Image_TraitTooltip_9 UB1Image
---@field BW_ProgressBar_0 UB1ProgressBar
---@field BW_ProgressBar_1 UB1ProgressBar
---@field BW_ProgressBar_2 UB1ProgressBar
---@field BW_ProgressBar_3 UB1ProgressBar
---@field BW_ProgressBar_4 UB1ProgressBar
---@field BW_ProgressBar_5 UB1ProgressBar
---@field BW_ProgressBar_6 UB1ProgressBar
---@field BW_ProgressBar_7 UB1ProgressBar
---@field BW_ProgressBar_8 UB1ProgressBar
---@field BW_ProgressBar_9 UB1ProgressBar
---@field Anim_ProgressBar UWidgetAnimation
---@field BW_HorizontalBox_GraphArea UB1HorizontalBox
local UB1PerspectiveDetailInfoWidget = {}



---@class UB1PerspectiveEntryWidget : UB1UserWidgetBase
---@field BW_Button UB1Button
---@field Text_PerspectiveEntry UB1TextBlock
local UB1PerspectiveEntryWidget = {}



---@class UB1PerspectiveGroupEntryWidget : UB1UserWidgetBase
---@field Text_PerspectiveCategory UB1TextBlock
---@field B1DynamicEntryBox UB1DynamicEntryBox
local UB1PerspectiveGroupEntryWidget = {}



---@class UB1PerspectivePopupWidget : UB1PopupWidgetBase
---@field BW_Text_Perspective UB1TextBlock
---@field BW_Text_PerspectiveDesc UB1TextBlock
---@field BW_WBP_Button_Confirm UB1CommonButtonWidget
local UB1PerspectivePopupWidget = {}



---@class UB1PerspectiveSelectUIHandler : UB1UIHandlerBase
local UB1PerspectiveSelectUIHandler = {}


---@class UB1PerspectiveWidget : UB1UserWidgetBase
---@field BW_Text_Perspective UB1TextBlock
---@field BW_Text_PerspectiveDesc UB1TextBlock
---@field BW_Button_Info UB1Button
---@field BW_WidgetSwitcher_Content UB1WidgetSwitcher
local UB1PerspectiveWidget = {}



---@class UB1PhotoModeCameraOptionListEntry : UB1UserWidgetBase
---@field BW_Text_Option UB1TextBlock
---@field BW_WidgetSwitcher_OptionType UB1WidgetSwitcher
---@field BW_HorizontalBox_Select UB1HorizontalBox
---@field BW_HorizontalBox_Slider UB1HorizontalBox
---@field BW_Slider_Value UB1Slider
---@field BW_ProgressBar_Value UB1ProgressBar
---@field BW_Text_Value UB1TextBlock
---@field BW_Text_Unit UB1TextBlock
---@field BW_Button_Previous UB1Button
---@field BW_Button_Next UB1Button
---@field BW_Text_Select UB1TextBlock
local UB1PhotoModeCameraOptionListEntry = {}



---@class UB1PhotoModeCameraOptionWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Button_CameraOption UB1Button
---@field BW_Button_Filter UB1Button
---@field BW_WidgetSwitcher_CameraOption UB1WidgetSwitcher
---@field BW_WrapBox_Filter UB1WrapBox
---@field BW_WBP_FOV UB1PhotoModeCameraOptionListEntry
---@field BW_WBP_DOF UB1PhotoModeCameraOptionListEntry
---@field BW_WBP_CustomDepthMask UB1PhotoModeCameraOptionListEntry
---@field FilterEntryWidgetClass TSubclassOf<UUserWidget>
---@field FilterTypeEntryWidgetMap TMap<EB1FilterType, UB1PhotoModeOptionListEntry>
local UB1PhotoModeCameraOptionWidget = {}



---@class UB1PhotoModeCharacterAnimInstance : UB1AnimInstance
---@field AnimSequenceAlpha UAnimSequence
---@field AnimSequenceBeta UAnimSequence
---@field BlendSwitch boolean
---@field bLiveLinkEnabled boolean
---@field LiveLinkSubjectName FLiveLinkSubjectName
---@field LiveLinkHeadRotation FRotator
---@field SavedPoseSnapshot FPoseSnapshot
---@field bEnablePoseSnapshot boolean
local UB1PhotoModeCharacterAnimInstance = {}

---@return FPoseSnapshot
function UB1PhotoModeCharacterAnimInstance:GetPoseSnapshot() end
---@return boolean
function UB1PhotoModeCharacterAnimInstance:GetEnablePoseSnapshot() end


---@class UB1PhotoModeHairAnimInstance : UB1HairAnimInstance
---@field SavedPoseSnapshot FPoseSnapshot
---@field bEnablePoseSnapshot boolean
local UB1PhotoModeHairAnimInstance = {}

---@return FPoseSnapshot
function UB1PhotoModeHairAnimInstance:GetPoseSnapshot() end
---@return boolean
function UB1PhotoModeHairAnimInstance:GetEnablePoseSnapshot() end


---@class UB1PhotoModeHeadAnimInstance : UB1CustomHeadAnimInstance
---@field SavedPoseSnapshot FPoseSnapshot
---@field bEnablePoseSnapshot boolean
local UB1PhotoModeHeadAnimInstance = {}

---@return FPoseSnapshot
function UB1PhotoModeHeadAnimInstance:GetPoseSnapshot() end
---@return boolean
function UB1PhotoModeHeadAnimInstance:GetEnablePoseSnapshot() end


---@class UB1PhotoModeKeyGuide : UB1UserWidgetBase
---@field B1KeyImageMoveForward UB1KeyImage
---@field B1KeyImageMoveLeft UB1KeyImage
---@field B1KeyImageMoveRight UB1KeyImage
---@field B1KeyImageMoveBackward UB1KeyImage
---@field B1KeyImageMoveCameraUp UB1KeyImage
---@field B1KeyImageMoveCameraDown UB1KeyImage
local UB1PhotoModeKeyGuide = {}



---@class UB1PhotoModeMotionItem : UObject
local UB1PhotoModeMotionItem = {}


---@class UB1PhotoModeMotionListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_WidgetSwitcher_ButtonType UB1WidgetSwitcher
---@field BW_Image_Thumbnail UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_Image_BG_AIMotion UB1Image
---@field BW_WidgetSwitcher_Thumnail UB1WidgetSwitcher
---@field BW_Overlay_MotionMarker UB1Overlay
---@field BW_CheckBox_Delete UB1CheckBox
---@field CanvasPanel_CreateMotion UB1CanvasPanel
local UB1PhotoModeMotionListEntryWidget = {}



---@class UB1PhotoModeMotionListWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Button_Pose UB1Button
---@field BW_Button_Facial UB1Button
---@field BW_TileView_Pose UB1TileView
---@field BW_TileView_Facial UB1TileView
---@field BW_WidgetSwitcher_List UB1WidgetSwitcher
---@field BW_EditableTextBox_SearchBox UB1EditableTextBox
---@field BW_Button_Search UB1Button
---@field BW_WidgetSwitcher_Mode UB1WidgetSwitcher
---@field BW_Button_DeleteMode UB1Button
---@field BW_Button_DeleteModeCancel UB1Button
---@field BW_Button_DeleteModeComplete UB1Button
local UB1PhotoModeMotionListWidget = {}



---@class UB1PhotoModeOptionListEntry : UB1UserWidgetBase
---@field BW_Button_Option UB1Button
---@field BW_Text_Option UB1TextBlock
local UB1PhotoModeOptionListEntry = {}



---@class UB1PhotoModePlayerWidget : UB1UserWidgetBase
---@field BW_Button_Pause UB1Button
---@field BW_Button_Play UB1Button
local UB1PhotoModePlayerWidget = {}



---@class UB1PhotoModeUIHandler : UB1UIHandlerBase
local UB1PhotoModeUIHandler = {}


---@class UB1PhotoModeWidget : UB1UserWidgetBase
---@field CropOptionEntryWidgetMap TMap<EB1PhotoModeCameraCropOption, UB1PhotoModeOptionListEntry>
---@field WBP_Common_Title UB1CommonTitleWidget
---@field BW_SizeBox_CropOption UB1SizeBox
---@field BW_Button_PortraitMode UB1Button
---@field BW_Button_LandscapeMode UB1Button
---@field BW_Button_Album UB1Button
---@field BW_WBP_Player UB1PhotoModePlayerWidget
---@field BW_Button_AI UB1Button
---@field BW_Button_FacialCapture UB1Button
---@field BW_Button_CameraOption UB1Button
---@field BW_Button_Crop UB1Button
---@field BW_Button_Photo UB1Button
---@field BW_Button_Video UB1Button
---@field BW_Button_PhotoShot UB1Button
---@field BW_Button_VideoShot UB1Button
---@field BW_WidgetSwitcher_ViewChange UB1WidgetSwitcher
---@field BW_Button_Character UB1Button
---@field BW_Button_TopView UB1Button
---@field BW_Image_Preview UB1Image
---@field BW_Image_CropResult UB1Image
---@field BW_DynamicEntryBox_CropOtion UB1DynamicEntryBox
---@field BW_WBP_CameraOption UB1PhotoModeCameraOptionWidget
---@field BW_WBP_MotionList UB1PhotoModeMotionListWidget
---@field BW_Button_Save UB1CommonButtonWidget
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Text_Guide_Export UB1TextBlock
---@field BW_Text_Guide UB1TextBlock
---@field BW_WBP_DayNight_Slider UB1DayNightSilderWidget
---@field BW_WBP_PhotoMode_KeyGuide UB1PhotoModeKeyGuide
local UB1PhotoModeWidget = {}



---@class UB1PlayLogManager : UB1ManagerBase
local UB1PlayLogManager = {}

---@return TArray<FB1PlayLog>
function UB1PlayLogManager:GetPlayLogs() end
---@return UB1PlayLogManager
function UB1PlayLogManager:Get() end


---@class UB1PlayerActionItemWidget : UB1UserWidgetBase
---@field BW_WBP_Gauge UB1GaugeWidget
---@field BW_Image_Icon UB1Image
---@field BW_Button_Delete UB1Button
local UB1PlayerActionItemWidget = {}



---@class UB1PlayerActionQueueRemoveAreaWidget : UB1UserWidgetBase
---@field BW_Panel_RemovingActionItems UB1DynamicEntryBox
---@field BW_Panel_Root UPanelWidget
---@field BW_Panel_TextArea UPanelWidget
---@field BW_Image_BG UImage
---@field Setting FB1PlayerActionQueueRemoveAreaWidget_Setting
---@field ActionItemsMap TMap<int32, UB1PlayerActionItemWidget>
local UB1PlayerActionQueueRemoveAreaWidget = {}



---@class UB1PlayerActionQueueWidget : UB1UserWidgetBase
---@field BW_ActionItemContainer UCanvasPanel
---@field BW_BG_Emotion UImage
---@field BW_WBP_RemoveArea UB1PlayerActionQueueRemoveAreaWidget
---@field Preview FB1PlayerActionQueueWidget_Preview
---@field Setting FB1PlayerActionQueueWidget_Setting
---@field UnusedItems TArray<UB1PlayerActionItemWidget>
---@field UsedItems TArray<UB1PlayerActionItemWidget>
---@field ActionItemsMap TMap<int64, UB1PlayerActionItemWidget>
local UB1PlayerActionQueueWidget = {}



---@class UB1PlayerBuffIconWidget : UB1UserListEntryWidgetBase
---@field BW_Button_Icon UButton
---@field BW_WidgetSwitcher UWidgetSwitcher
---@field BW_WidgetSwitcher_Icon UWidgetSwitcher
---@field BW_WidgetSwitcher_Gradient UWidgetSwitcher
---@field BW_Text_Buff UTextBlock
---@field BW_Text_Buff_Boost UTextBlock
---@field BW_Text_Label UTextBlock
---@field BW_Text_Reason UTextBlock
---@field BW_Text_Desc0 UTextBlock
---@field BW_Text_Desc1 UTextBlock
---@field BW_Text_LeftTime UTextBlock
---@field BW_Image_BuffIcon UB1Image
---@field BW_Image_BuffGradient UImage
---@field BW_Image_BuffGradient_Boost UImage
---@field BW_Image_BuffIconColor UImage
---@field BW_Image_BuffIconColor_Boost UImage
---@field BW_BG_Buff_Hover UImage
---@field BW_HorizontalBox_LeftTime UHorizontalBox
local UB1PlayerBuffIconWidget = {}

function UB1PlayerBuffIconWidget:OnUnHovered() end
function UB1PlayerBuffIconWidget:OnHovered() end


---@class UB1PlayerBuffListWidget : UB1UserWidgetBase
---@field BTN_Right UB1Button
---@field BTN_Left UB1Button
---@field BW_Page UHorizontalBox
---@field BW_WBP_BuffIcon_0 UB1PlayerBuffIconWidget
---@field BW_WBP_BuffIcon_1 UB1PlayerBuffIconWidget
---@field BW_WBP_BuffIcon_2 UB1PlayerBuffIconWidget
---@field BW_WBP_BuffIcon_3 UB1PlayerBuffIconWidget
---@field BW_WBP_BuffIcon_4 UB1PlayerBuffIconWidget
---@field BW_WBP_BuffIcon_5 UB1PlayerBuffIconWidget
---@field PageIndicatorClass TSubclassOf<UUserWidget>
---@field BuffIcons TArray<UB1PlayerBuffIconWidget>
---@field PageIndicators TArray<UUserWidget>
local UB1PlayerBuffListWidget = {}



---@class UB1PlayerBuffUIHandler : UB1UIHandlerBase
local UB1PlayerBuffUIHandler = {}


---@class UB1PlayerBuffWidget : UB1UserWidgetBase
---@field TXT_Emotion UB1TextBlock
---@field BW_Spacer_ForState UB1Spacer
---@field IMG_Emotion UImage
---@field IMG_EmotionColor UImage
---@field B1Image_Arrow UImage
---@field BTN_Emotion UB1Button
---@field BW_Image_Tooltip UB1Image
---@field BW_Overlay_State UB1Overlay
---@field BW_Image_StateIcon UB1Image
---@field BW_Image_EmotionIcon UB1Image
---@field BW_Image_EmotionIcon_next UB1Image
---@field IMG_Emotion_color UB1Image
---@field IMG_Fx UB1Image
---@field IMG_light UB1Image
---@field WBP_Niagara_System_001 UNiagaraSystemWidget
---@field EmotionInfo FB1EmotionInfo
---@field EmotionColorDelayTime float
local UB1PlayerBuffWidget = {}



---@class UB1PlayerChangePortraitEntry : UB1UserWidgetBase
---@field BW_Button_Portrait UB1Button
---@field BW_WBP_Portrait UB1PlayerPortraitWidget
---@field BW_Button_AutonomyToggle UB1Button
---@field BW_WBP_RabbitHoleButton UB1RabbitHoleButtonWidget
---@field BW_DynamicEntryBox_NowCondition UB1DynamicEntryBox
local UB1PlayerChangePortraitEntry = {}

function UB1PlayerChangePortraitEntry:OnPortraitUnhovered() end
function UB1PlayerChangePortraitEntry:OnPortraitHovered() end
function UB1PlayerChangePortraitEntry:OnPortraitClicked() end
function UB1PlayerChangePortraitEntry:OnAutonomyClicked() end


---@class UB1PlayerChangePortraitEntryState : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Image_ColorBG UB1Image
local UB1PlayerChangePortraitEntryState = {}



---@class UB1PlayerChangePortraitEntryTooltipWidget : UB1TooltipWidgetBase
---@field BW_Text_name UB1TextBlock
---@field BW_Text_Location UB1TextBlock
local UB1PlayerChangePortraitEntryTooltipWidget = {}



---@class UB1PlayerChangePortrait_ToolTip : UB1UserWidgetBase
---@field BW_Text_name UB1TextBlock
---@field BW_Text_Location UB1TextBlock
local UB1PlayerChangePortrait_ToolTip = {}



---@class UB1PlayerChangeUIHandler : UB1UIHandlerBase
local UB1PlayerChangeUIHandler = {}


---@class UB1PlayerChangeWidget : UB1UserWidgetBase
---@field FamilyMonitoringAlertWidgetClass TSubclassOf<UB1FamilyMonitoringAlertWidget>
---@field FamilyMonitoringAlertXThreshold float
---@field FamilyMonitoringAlertPosition FVector2D
---@field BW_WBP_PortraitEntry_0 UB1PlayerChangePortraitEntry
---@field BW_WBP_PortraitEntry_1 UB1PlayerChangePortraitEntry
---@field BW_WBP_PortraitEntry_2 UB1PlayerChangePortraitEntry
---@field BW_WBP_PortraitEntry_3 UB1PlayerChangePortraitEntry
---@field BW_WBP_PortraitEntry_4 UB1PlayerChangePortraitEntry
---@field BW_WBP_PortraitEntry_5 UB1PlayerChangePortraitEntry
---@field BW_WBP_PortraitEntry_6 UB1PlayerChangePortraitEntry
---@field BW_WBP_PortraitEntry_7 UB1PlayerChangePortraitEntry
---@field BW_VerticalBox UB1VerticalBox
---@field BW_WBP_InteractionRabbitHole UB1RabbitHoleInteractionWidget
---@field BW_WidgetSwitcher_Line UB1WidgetSwitcher
---@field BW_Button_HomeInfo UB1Button
---@field BW_Alert_Badge UB1MobileAppAlertIconWidget
---@field BW_SizeBox_HomeAlert UB1SizeBox
---@field BW_Overlay_HomeAlert UB1Overlay
local UB1PlayerChangeWidget = {}



---@class UB1PlayerDesireGaugeWidget : UB1UserWidgetBase
---@field BW_WBP_Gauge UB1GaugeWidget
---@field BW_Image_Warning UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_Image_Icon UB1Image
---@field Button_Desire UB1Button
---@field Anim_Default UWidgetAnimation
---@field Anim_Warning UWidgetAnimation
---@field Setting FB1PlayerDesireGaugeWidget_Setting
local UB1PlayerDesireGaugeWidget = {}



---@class UB1PlayerDesireListWidget : UB1UserWidgetBase
---@field BW_Panel_Gauge UB1DynamicEntryBox
---@field CheckBox_Autonomy UB1CheckBox
---@field DefaultButtonIcon UObject
local UB1PlayerDesireListWidget = {}

---@param IsChecked boolean
function UB1PlayerDesireListWidget:OnChanged_AutonomyCheckbox(IsChecked) end


---@class UB1PlayerDesireWidget : UB1UserWidgetBase
---@field BW_Button_Desire UB1Button
---@field BW_Button_AutonomyToggle UB1Button
---@field BW_Image_Color UB1Image
---@field BW_Image_Icon UB1Image
---@field BW_WidgetSwitcher_AutonomyToggle UB1WidgetSwitcher
---@field Setting FB1PlayerDesireWidget_Setting
---@field DefaultButtonIcon UObject
local UB1PlayerDesireWidget = {}



---@class UB1PlayerEmotionBuffAlertWidget : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
local UB1PlayerEmotionBuffAlertWidget = {}



---@class UB1PlayerEmotionBuffData : UObject
---@field BuffId FName
---@field Reason FText
---@field Buff FText
---@field LeftTime FText
---@field BuffName FText
---@field TagImage TSoftObjectPtr<UObject>
---@field IsInfinite boolean
---@field IsHighlight boolean
local UB1PlayerEmotionBuffData = {}



---@class UB1PlayerEmotionBuffEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_Reason UB1TextBlock
---@field BW_Text_Buff UTextBlock
---@field BW_Text_LeftTime UTextBlock
---@field BW_Text_BuffName UTextBlock
---@field BW_CanvasPanel_BuffAlert UB1CanvasPanel
---@field BW_Image_Icon_Reason UB1Image
local UB1PlayerEmotionBuffEntryWidget = {}



---@class UB1PlayerEmotionGaugeTooltipWidget : UB1TooltipWidgetBase
---@field BW_Text_Label UTextBlock
---@field BW_Text_Desc UTextBlock
---@field BW_Image_BuffIcon UB1Image
---@field BW_Image_BuffGradient UImage
---@field BW_Image_BuffGradient_Boost UImage
---@field BW_Image_BuffIconColor UImage
---@field BW_Image_BuffIconColor_Boost UImage
---@field BW_WidgetSwitcher_Icon UWidgetSwitcher
---@field BW_WidgetSwitcher_Gradient UWidgetSwitcher
---@field BW_ListView_Buff UB1ListView
local UB1PlayerEmotionGaugeTooltipWidget = {}



---@class UB1PlayerEmotionGaugeWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_Type UB1WidgetSwitcher
---@field BW_Image_Top_Positive UB1Image
---@field BW_ProgressBar_Positive UB1ProgressBar
---@field BW_BuffAlert_Positive UB1PlayerEmotionBuffAlertWidget
---@field BW_Image_Top_Neutral UB1Image
---@field BW_ProgressBar_Neutral UB1ProgressBar
---@field BW_BuffAlert_Neutral UB1PlayerEmotionBuffAlertWidget
---@field BW_Image_Top_Negative UB1Image
---@field BW_ProgressBar_Negative UB1ProgressBar
---@field BW_BuffAlert_Negative UB1PlayerEmotionBuffAlertWidget
---@field Anim_Gauge UWidgetAnimation
---@field MinPositiveGaugePercent float
---@field MinNeutralGaugePercent float
local UB1PlayerEmotionGaugeWidget = {}

function UB1PlayerEmotionGaugeWidget:OnGaugeAnimationFinished() end


---@class UB1PlayerEmotionListWidget : UB1UserWidgetBase
---@field BW_HorizontalBox_Emotion UB1HorizontalBox
---@field SlotWidgetClass TSubclassOf<UUserWidget>
local UB1PlayerEmotionListWidget = {}



---@class UB1PlayerEventButtonWidget : UB1UserWidgetBase
---@field BW_Button_Event UB1Button
---@field BW_Text_Event UB1TextBlock
local UB1PlayerEventButtonWidget = {}



---@class UB1PlayerInfoWidget : UB1UserWidgetBase
---@field BW_WBP_KarmaFX UB1UserWidgetBase
---@field BW_WBP_Portrait UB1PlayerPortraitWidget
---@field BW_HopeOverHeadAlert UB1HopeOverHeadAlertWidget
---@field BW_Button_SmartPhone UB1Button
---@field BW_Alert_Badge UB1MobileAppAlertIconWidget
---@field BW_Button_Bag UB1Button
---@field BW_WBP_HUD_Schedule_Button UB1ScheduleButtonWidget
---@field WBP_HUD_EventButton UB1PlayerEventButtonWidget
local UB1PlayerInfoWidget = {}



---@class UB1PlayerNaviDistanceWidget : UB1UserWidgetBase
---@field BW_Text_Distance UB1TextBlock
---@field BW_Image_Icon UB1Image
local UB1PlayerNaviDistanceWidget = {}



---@class UB1PlayerNaviLayerWidget : UB1UserWidgetBase
---@field BW_Layer_CanvasPanel UB1CanvasPanel
---@field PlayerNaviWidgetClass TSubclassOf<UUserWidget>
---@field PendingEntityData TMap<FB1EntityId, FVector>
local UB1PlayerNaviLayerWidget = {}



---@class UB1PlayerNaviWidget : UB1UserWidgetBase
---@field BW_CanvasPanel UB1CanvasPanel
---@field BW_Image_Arrow UB1Image
---@field WBP_Common_PlayerPortrait UB1PlayerPortraitWidget
---@field WBP_HUD_Player_Navi_Distance UB1PlayerNaviDistanceWidget
---@field DefaultActionIcon TSoftObjectPtr<UTexture>
local UB1PlayerNaviWidget = {}



---@class UB1PlayerPortraitWidget : UB1UserWidgetBase
---@field BW_Image_Portrait UB1Image
---@field BW_Image_Skeleton UImage
---@field BW_Image_ColorBorder UImage
---@field BW_Image_ColorBorder_add UImage
---@field BW_Image_Fx_BG UImage
---@field BW_Image_Fx0 UImage
---@field BW_Image_Fx1 UImage
---@field BW_Image_Fx2 UImage
---@field BW_Image_Fx3 UImage
---@field BW_Image_Fx4 UImage
---@field BW_Image_Fx5 UImage
---@field BW_Image_Fx6 UImage
---@field BW_Image_Fx7 UImage
---@field BW_Image_Fx8 UImage
---@field BW_Image_Fx9 UImage
---@field BW_Button_Image UB1Button
---@field BW_Overlay_Focus UB1Overlay
---@field BW_WidgetSwitcher_GuideText UB1WidgetSwitcher
---@field FxImageList TArray<UImage>
---@field DefaultPortrait TSoftObjectPtr<UTexture>
local UB1PlayerPortraitWidget = {}

---@param InFocusState EB1PortraitFocusState
function UB1PlayerPortraitWidget:SetFocusState(InFocusState) end
function UB1PlayerPortraitWidget:OnPortraitClicked() end


---@class UB1PlayerProfileButtonEntryWidget : UB1UserListEntryWidgetBase
---@field Button UB1Button
---@field Button_Disable UB1Button
---@field WidgetSwitcher_Button UB1WidgetSwitcher
---@field Image_Button UB1Image
---@field Text_Button UB1TextBlock
---@field BW_Alert_Badge UB1MobileAppAlertIconWidget
---@field Anim_BuildActive UWidgetAnimation
---@field bUseCustomButtonData boolean
---@field CustomButtonData FB1PlayerProfileData
local UB1PlayerProfileButtonEntryWidget = {}

function UB1PlayerProfileButtonEntryWidget:OnMenuButtonUnhovered() end
function UB1PlayerProfileButtonEntryWidget:OnMenuButtonHovered() end
function UB1PlayerProfileButtonEntryWidget:OnMenuButtonClick() end


---@class UB1PlayerProfileHopeAlertWidget : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
local UB1PlayerProfileHopeAlertWidget = {}



---@class UB1PlayerProfileWidget : UB1UserWidgetBase
---@field MenuEntryBox UB1DynamicEntryBox
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_WBP_HopeAlert UB1PlayerProfileHopeAlertWidget
---@field BW_WBP_NewMarker UB1UserWidgetBase
---@field GameplayTagToWidget TMap<FGameplayTag, UB1UserWidgetBase>
---@field EffectWidgetClass TSubclassOf<UUserWidget>
---@field AlarmQueue TArray<FB1AlertParam>
local UB1PlayerProfileWidget = {}



---@class UB1PlayerUIHandler : UB1UIHandlerBase
local UB1PlayerUIHandler = {}


---@class UB1PlayerWorkStateWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher UB1WidgetSwitcher
---@field BW_Image_CompanyIcon UB1Image
---@field BW_Button_Job UB1Button
local UB1PlayerWorkStateWidget = {}



---@class UB1PocketMarketPurchasedShoppingItemListEntryData : UObject
local UB1PocketMarketPurchasedShoppingItemListEntryData = {}


---@class UB1PocketMarketPurchasedShoppingItemListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Item UB1Image
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Text_ItemName UB1TextBlock
local UB1PocketMarketPurchasedShoppingItemListEntryWidget = {}



---@class UB1PocketMarketSellListEntryData : UObject
local UB1PocketMarketSellListEntryData = {}


---@class UB1PocketMarketSellListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Date UB1TextBlock
---@field BW_Text_State UB1TextBlock
---@field BW_Text_Like UB1TextBlock
---@field BW_Image_Item UB1Image
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_WidgetSwitcher_Button UB1WidgetSwitcher
---@field BW_Button_PriceDown UB1Button
local UB1PocketMarketSellListEntryWidget = {}



---@class UB1PocketMarketSellWidget : UB1UserWidgetBase
---@field BW_Text_ItemName UB1TextBlock
---@field BW_Button_Back UB1Button
---@field BW_Button_Sell UB1Button
---@field BW_Image_Item UB1Image
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_EditableTextBox_ItemName UB1EditableTextBox
---@field BW_Text_State UB1TextBlock
local UB1PocketMarketSellWidget = {}



---@class UB1PocketMarketShoppingCategoryListEntryData : UObject
local UB1PocketMarketShoppingCategoryListEntryData = {}


---@class UB1PocketMarketShoppingCategoryListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_Category UB1TextBlock
---@field BW_Image_Icon UB1Image
local UB1PocketMarketShoppingCategoryListEntryWidget = {}



---@class UB1PocketMarketShoppingItemListEntryData : UObject
local UB1PocketMarketShoppingItemListEntryData = {}


---@class UB1PocketMarketShoppingItemListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_ItemName UB1TextBlock
---@field BW_Text_SubTitle UB1TextBlock
---@field BW_Image_Item UB1Image
---@field BW_Overlay_Dimmed UB1Overlay
---@field BW_Overlay_Sale UB1Overlay
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_WBP_Currency_Sale UB1CurrencyWidget
---@field BW_Text_Sale_Percent UB1TextBlock
---@field BW_Button_Buy UB1Button
local UB1PocketMarketShoppingItemListEntryWidget = {}



---@class UB1PocketMarketTabWidget : UB1UserWidgetBase
---@field TabName FText
---@field Icon FSlateBrush
---@field BW_Button_Tab UB1Button
---@field BW_Text_name UB1TextBlock
---@field BW_Image_Icon UB1Image
local UB1PocketMarketTabWidget = {}



---@class UB1PocketMarketUIHandler : UB1UIHandlerBase
---@field SelfEntityId FB1EntityId
---@field TargetEntityId FB1EntityId
---@field Price int64
local UB1PocketMarketUIHandler = {}



---@class UB1PocketMarketWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Image_Portrait UB1Image
---@field BW_Image_Grade UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_Text_Follower UB1TextBlock
---@field BW_WBP_PocketMarket_Sell UB1PocketMarketSellWidget
---@field BW_ListView_Category UB1ListView
---@field BW_Text_SubTitle UB1TextBlock
---@field BW_WidgetSwitcher_Content UB1WidgetSwitcher
---@field BW_WidgetSwitcher_TopMenu UB1WidgetSwitcher
---@field BW_Text_Total UB1TextBlock
---@field BW_TileView_Shopping UB1TileView
---@field BW_ListView_Sell UB1ListView
---@field BW_ListView_Orders UB1ListView
---@field BW_ScrollBox UB1ScrollBox
---@field BW_WBP_Button_Shopping UB1PocketMarketTabWidget
---@field BW_WBP_Button_HomeService UB1PocketMarketTabWidget
---@field BW_WBP_Button_Sell UB1PocketMarketTabWidget
---@field BW_WBP_Button_Orders UB1PocketMarketTabWidget
---@field BW_WBP_ToastMessage UB1MobileToastMessageWidget
local UB1PocketMarketWidget = {}



---@class UB1PopupManager : UB1ManagerBase
local UB1PopupManager = {}


---@class UB1PopupWidgetBase : UB1UserWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Desc UB1TextBlock
---@field BW_RichText_Title UB1RichTextBlock
---@field BW_RichText_Desc UB1RichTextBlock
---@field BW_RichText_Timer UB1RichTextBlock
---@field BW_HorizontalBox_Timer UB1HorizontalBox
---@field DefaultTitleColor FLinearColor
---@field DefaultDescColor FLinearColor
---@field ButtonClass TSubclassOf<UUserWidget>
---@field OpenUISoundId FName
local UB1PopupWidgetBase = {}



---@class UB1PortraitComponent : UActorComponent
---@field Portrait UTexture
---@field ControlledPlayerEmotionPortrait UTexture
local UB1PortraitComponent = {}



---@class UB1PoseSearchMetaData : UAnimMetaData
---@field SamplingRange FFloatInterval
---@field NumSamples int32
---@field Bones TArray<FBoneReference>
---@field BoneIndices TArray<uint16>
---@field PoseDatas TArray<FB1SimplePoseData>
local UB1PoseSearchMetaData = {}



---@class UB1PostProcessComponent : UPostProcessComponent
---@field TargetType EB1PostProcessComponentTargetType
---@field DistanceLimit float
local UB1PostProcessComponent = {}



---@class UB1PreferenceChangeWidget : UB1CatOperatorChangeWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Text_Num UB1TextBlock
---@field BW_Text_LikeNum UB1TextBlock
---@field BW_Text_DislikeNum UB1TextBlock
---@field BW_DynamicEntryBox_List UB1DynamicEntryBox
local UB1PreferenceChangeWidget = {}



---@class UB1PreferenceComponent : UActorComponent
local UB1PreferenceComponent = {}


---@class UB1PreferenceEntryWidget : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Button UB1Button
---@field Anim_Normal_Hover UWidgetAnimation
---@field Anim_Preference_Hover UWidgetAnimation
local UB1PreferenceEntryWidget = {}



---@class UB1PreferenceGroupEntryWidget : UB1UserWidgetBase
---@field BW_Text_CategoryName UB1TextBlock
---@field BW_Text_LikeNum UB1TextBlock
---@field BW_Text_DislikeNum UB1TextBlock
---@field BW_DynamicEntryBox UB1DynamicEntryBox
local UB1PreferenceGroupEntryWidget = {}



---@class UB1PreferenceSelectUIHandler : UB1UIHandlerBase
local UB1PreferenceSelectUIHandler = {}


---@class UB1PreferenceWidget : UB1UserWidgetBase
---@field BW_Button_Change UB1CommonButtonWidget
---@field BW_Text_Num UB1TextBlock
---@field BW_TileView_Preference UB1TileView
local UB1PreferenceWidget = {}



---@class UB1PresetListContainer : UB1UserWidgetBase
---@field BW_VerticalBox_Site UB1VerticalBox
---@field TextTitlePreset UB1TextBlock
---@field BW_TileView_Site UB1TileView
---@field BW_VerticalBox_Room UB1VerticalBox
---@field TextTitleMyRooms UB1TextBlock
---@field BW_TileView_Room UB1TileView
---@field BW_Text_Title_Room UB1TextBlock
---@field BW_VerticalBox_Furniture UB1VerticalBox
---@field TextTitleMyRooms_1 UB1TextBlock
---@field BW_TileView_Furniture UB1TileView
---@field MyPresetDataList TArray<UB1BuildPresetListEntryData>
---@field MyAllSiteDataList TArray<UB1BuildPresetListEntryData>
---@field MyAllRoomDataList TArray<UB1BuildPresetListEntryData>
---@field MyAllObjectDataList TArray<UB1ObjectEntryData>
---@field MySiteDataList TArray<UB1BuildPresetListEntryData>
---@field MyRoomDataList TArray<UB1BuildPresetListEntryData>
---@field MyObjectDataList TArray<UB1ObjectEntryData>
local UB1PresetListContainer = {}



---@class UB1PsoWidget : UB1UserWidgetBase
---@field BW_Text_ProgressPercent UB1TextBlock
---@field BW_ProgressBar_Progress UB1ProgressBar
local UB1PsoWidget = {}



---@class UB1QuestUIHandler : UB1UIHandlerBase
local UB1QuestUIHandler = {}


---@class UB1RabbitHoleButtonWidget : UB1UserWidgetBase
---@field BW_Button_RabbitHole UB1Button
---@field BW_Image_Icon UB1Image
---@field PortraitIndex int32
local UB1RabbitHoleButtonWidget = {}

function UB1RabbitHoleButtonWidget:OnClickedButton() end


---@class UB1RabbitHoleInteractionUIHandler : UB1UIHandlerBase
---@field DebugMessageWidget TWeakObjectPtr<UB1DebugMessageWidget>
local UB1RabbitHoleInteractionUIHandler = {}



---@class UB1RabbitHoleInteractionWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_RabbitHoleInteraction UB1WidgetSwitcher
---@field BW_ListView_List_1 UB1ListView
---@field BW_ListView_List_2 UB1ListView
---@field BW_Text_name_1 UB1TextBlock
---@field BW_Text_name_2 UB1TextBlock
---@field BW_WBP_RabbitHoleInfoButton_1 UB1CommonButtonWidget
---@field BW_WBP_RabbitHoleInfoButton_2 UB1CommonButtonWidget
local UB1RabbitHoleInteractionWidget = {}



---@class UB1RandomTalkInteractionEmoticonWidget : UB1UserWidgetBase
---@field EmoticonCanvas UB1CanvasPanel
---@field WBP_Interaction_Emoticon UB1InteractionEmoticon
---@field BW_Button_Emoticon UB1Button
---@field EmotionSelectionData UB1ObjectSelectionData
local UB1RandomTalkInteractionEmoticonWidget = {}



---@class UB1RandomTalkInteractionListEntryTalkWidget : UB1TalkInteractionSubSelectionEntry
---@field BW_WidgetSwitcher UB1WidgetSwitcher
---@field BW_Widget_Default UWidget
---@field BW_WBP_Emoticon UB1RandomTalkInteractionEmoticonWidget
local UB1RandomTalkInteractionListEntryTalkWidget = {}



---@class UB1RegionInfoWidget : UB1UserWidgetBase
---@field BW_Text_Region UB1TextBlock
---@field BW_Text_Region_Next UB1TextBlock
local UB1RegionInfoWidget = {}



---@class UB1RegionMessageWidget : UB1UserWidgetBase
---@field BW_Text_Region UTextBlock
local UB1RegionMessageWidget = {}



---@class UB1RegionUIHandler : UB1UIHandlerBase
local UB1RegionUIHandler = {}


---@class UB1RelationStateFxComponent : UActorComponent
local UB1RelationStateFxComponent = {}

function UB1RelationStateFxComponent:OnWidgetEffectFinish() end


---@class UB1RelationshipEffectWidget : UB1UserWidgetBase
---@field RelationId FName
---@field B1CanvasPanelOverlay UCanvasPanel
---@field B1Overlay_RelationshipFocus UB1Overlay
---@field B1HorizontalBox_Value UB1HorizontalBox
---@field B1Text_Num UB1TextBlock
---@field B1Text_CurrentRelationship UB1TextBlock
---@field B1Text_PrevRelationship UB1TextBlock
---@field WBP_RelationshipIcon UB1RelationshipIconWidget
---@field BW_WidgetSwitcher_Emoticon UB1WidgetSwitcher
local UB1RelationshipEffectWidget = {}

---@param InTarget AActor
---@param InUpGradeLevel boolean
---@param InFocusSelectionFail boolean
function UB1RelationshipEffectWidget:Spawn(InTarget, InUpGradeLevel, InFocusSelectionFail) end
---@param InValue float
function UB1RelationshipEffectWidget:SetValue(InValue) end
---@param InCurrentLevel FText
---@param InPrevLevel FText
function UB1RelationshipEffectWidget:SetRelationFocusSelctionData(InCurrentLevel, InPrevLevel) end
---@param InRelationId FName
function UB1RelationshipEffectWidget:SetRelation(InRelationId) end


---@class UB1RelationshipEmoticonWidget : UB1UserWidgetBase
local UB1RelationshipEmoticonWidget = {}


---@class UB1RelationshipFamilyLoveWidget : UB1UserWidgetBase
---@field BW_Slider_FamilyLove UB1Slider
local UB1RelationshipFamilyLoveWidget = {}

---@param InAvgFamilyLove float
function UB1RelationshipFamilyLoveWidget:SetValue(InAvgFamilyLove) end


---@class UB1RelationshipGaugeTagWidget : UB1UserWidgetBase
---@field BW_Text_TagName UTextBlock
---@field BW_Image_Icon UB1Image
local UB1RelationshipGaugeTagWidget = {}

---@param InStatId FName
---@param InRelationshipId FName
---@param InIsDimmed boolean
function UB1RelationshipGaugeTagWidget:SetRelationship(InStatId, InRelationshipId, InIsDimmed) end


---@class UB1RelationshipGaugeWidget : UB1UserWidgetBase
---@field RelationId FName
---@field BW_ProgressBar_Negative UB1ProgressBar
---@field BW_ProgressBar_Positive UB1ProgressBar
---@field BW_Image_ProgressBar_BG UB1Image
local UB1RelationshipGaugeWidget = {}



---@class UB1RelationshipIconGaugeWidget : UB1RelationshipGaugeWidget
---@field BW_WBP_RelationshipIcon UB1RelationshipIconWidget
local UB1RelationshipIconGaugeWidget = {}



---@class UB1RelationshipIconWidget : UB1UserWidgetBase
---@field RelationshipStatId FName
---@field B1Image_BG UB1Image
---@field B1Image_BG_2 UB1Image
---@field B1Image_Icon UB1Image
---@field RelationshipIcons TMap<FName, TSoftObjectPtr<UObject>>
---@field RelationshipMaterialInterface TSoftObjectPtr<UMaterialInterface>
local UB1RelationshipIconWidget = {}

---@param InRelationshipStatId FName
function UB1RelationshipIconWidget:RefreshUI(InRelationshipStatId) end


---@class UB1RelationshipListEntryWidget : UB1UserListEntryWidgetBase
---@field Portrait UB1Image
---@field CharacterName UB1TextBlock
---@field RelationshipName UB1TextBlock
---@field BW_Text_SubName UB1TextBlock
---@field BW_Text_Number UB1TextBlock
---@field RelationshipGaugeEntry UB1DynamicEntryBox
---@field BW_WidgetSwitcher_Focus UB1WidgetSwitcher
---@field BW_WidgetSwitcher_SelectMode UB1WidgetSwitcher
---@field BW_WidgetSwitcher_Gauge UB1WidgetSwitcher
---@field BW_Overlay_Focus UB1Overlay
---@field BW_WBP_RelationshipIcon_Love UB1RelationshipIconWidget
---@field BW_WBP_RelationshipIcon_Business UB1RelationshipIconWidget
---@field BW_WBP_RelationshipIcon_Friend UB1RelationshipIconWidget
---@field BW_Alert_Badge UB1MobileAppAlertIconWidget
---@field BW_Button_ZoiProfile UB1Button
---@field EntryData UB1RelationshipEntryData
---@field RelationshipIconMap TMap<FName, UB1RelationshipIconWidget>
---@field DefaultPortrait TSoftObjectPtr<UTexture>
local UB1RelationshipListEntryWidget = {}



---@class UB1RelationshipListWidget : UB1UserWidgetBase
---@field BW_ScrollBox UB1ScrollBox
---@field TileView_Family UB1TileView
---@field TileView_Others UB1TileView
---@field Overlay_FamilyTab UB1Overlay
---@field Overlay_OthersTab UB1Overlay
---@field SearchBox UB1EditableTextBox
---@field B1Button_Search UB1Button
---@field BW_Button_Close UB1Button
---@field BW_Text_Num UB1TextBlock
---@field WBP_RelationshipIcon_Love UB1RelationshipIconWidget
---@field WBP_RelationshipIcon_Business UB1RelationshipIconWidget
---@field WBP_RelationshipIcon_Friend UB1RelationshipIconWidget
---@field WBP_RelationshipIcon_Family UB1RelationshipIconWidget
---@field WBP_Relationship_MoveTogetherButtonGroup UB1MoveTogetherButtonGroupWidget
---@field Text_FamilyLoveState UB1TextBlock
---@field BW_WidgetSwitcher_List UB1WidgetSwitcher
---@field WBP_Relationship_FamilyLove UB1RelationshipFamilyLoveWidget
local UB1RelationshipListWidget = {}

function UB1RelationshipListWidget:ToggleWidget() end
---@param InText FText
---@param InCommitMethod ETextCommit::Type
function UB1RelationshipListWidget:OnTextCommitted(InText, InCommitMethod) end


---@class UB1RelationshipProfileListWidget : UB1UserWidgetBase
---@field ProfileTitleTextId FString
---@field ProfileDimmedReasonTooltipId FString
---@field ProfileUnlockConditionTooltipId FString
---@field BW_HorizontalBox_Alert UB1HorizontalBox
---@field BW_Text_Title UB1TextBlock
---@field BW_WidgetSwitcher_Desc UB1WidgetSwitcher
---@field BW_Image_Age UB1Image
---@field BW_WidgetSwitcher_Icon UB1WidgetSwitcher
---@field BW_Image_JobIcon UB1Image
---@field BW_Image_TraitIcon UB1Image
---@field BW_Image_Lock UB1Image
---@field BW_Icon_QuestionMark UB1Image
---@field BW_Text_Desc_1 UB1TextBlock
---@field BW_WidgetSwitcher_Default UB1WidgetSwitcher
---@field BW_ListView_Preference UB1ListView
---@field BW_Text_Desc_0 UB1TextBlock
local UB1RelationshipProfileListWidget = {}



---@class UB1RelationshipProfileMemorySlotWidget : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
local UB1RelationshipProfileMemorySlotWidget = {}



---@class UB1RelationshipProfileMemoryWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_Memory UB1WidgetSwitcher
---@field BW_DynamicEntryBox_MemorySlot UB1DynamicEntryBox
local UB1RelationshipProfileMemoryWidget = {}



---@class UB1RelationshipProfilePerferenceListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_WidgetSwitcher_BG UB1WidgetSwitcher
---@field BW_WidgetSwitcher_Like UB1WidgetSwitcher
---@field BW_Image_PreferenceIcon UB1Image
local UB1RelationshipProfilePerferenceListEntryWidget = {}



---@class UB1RelationshipProfilePreferenceListEntryData : UObject
local UB1RelationshipProfilePreferenceListEntryData = {}


---@class UB1RelationshipProfileRecordListEntryData : UObject
local UB1RelationshipProfileRecordListEntryData = {}


---@class UB1RelationshipProfileRecordListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_WidgetSwitcher_Icon UB1WidgetSwitcher
---@field BW_RichTextBlock_Desc UB1RichTextBlock
local UB1RelationshipProfileRecordListEntryWidget = {}



---@class UB1RelationshipProfileRecordWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_RecordDesc UB1WidgetSwitcher
---@field BW_ListView_RecordDesc UB1ListView
local UB1RelationshipProfileRecordWidget = {}



---@class UB1RelationshipProfileToolTipListWidget : UB1UserWidgetBase
---@field ProfileTitleTextId FString
---@field ProfileDimmedReasonTooltipId FString
---@field ProfileUnlockConditionTooltipId FString
---@field BW_HorizontalBox_Alert UB1HorizontalBox
---@field BW_Text_Title UB1TextBlock
---@field BW_WidgetSwitcher_Icon UB1WidgetSwitcher
---@field BW_WidgetSwitcher_IconSmall UB1WidgetSwitcher
---@field BW_Image_Age UB1Image
---@field BW_Image_JobIcon UB1Image
---@field BW_Image_Lock UB1Image
---@field BW_Icon_QuestionMark UB1Image
---@field BW_Text_Desc UB1TextBlock
local UB1RelationshipProfileToolTipListWidget = {}



---@class UB1RelationshipProfileToolTipWidget : UB1TooltipWidgetBase
---@field BW_Text_name UB1TextBlock
---@field BW_WBP_MiniList_Gender UB1RelationshipProfileToolTipListWidget
---@field BW_WBP_MiniList_AgeGroup UB1RelationshipProfileToolTipListWidget
---@field BW_WBP_MiniList_Career UB1RelationshipProfileToolTipListWidget
---@field BW_WBP_MiniList_MaritalStatus UB1RelationshipProfileToolTipListWidget
local UB1RelationshipProfileToolTipWidget = {}



---@class UB1RelationshipProfileUIHandler : UB1UIHandlerBase
---@field ProfileWidget UB1RelationshipProfileWidget
---@field ProfileTooltipWidget UB1RelationshipProfileToolTipWidget
local UB1RelationshipProfileUIHandler = {}



---@class UB1RelationshipProfileWidget : UB1UserWidgetBase
---@field BW_Portrait UB1Image
---@field BW_Text_PortraitName UB1TextBlock
---@field BW_WBP_ZoiProfileList_Gender UB1RelationshipProfileListWidget
---@field BW_WBP_ZoiProfileList_AgeGroup UB1RelationshipProfileListWidget
---@field BW_WBP_ZoiProfileList_Career UB1RelationshipProfileListWidget
---@field BW_WBP_ZoiProfileList_MaritalStatus UB1RelationshipProfileListWidget
---@field BW_WBP_ZoiProfileList_Trait UB1RelationshipProfileListWidget
---@field BW_WBP_ZoiProfileList_Value UB1RelationshipProfileListWidget
---@field BW_WBP_ZoiProfileList_Preference UB1RelationshipProfileListWidget
---@field BW_WBP_ZoiProfileList_RomanticRelationship UB1RelationshipProfileListWidget
---@field BW_WBP_ZoiProfileList_AttractedTo UB1RelationshipProfileListWidget
---@field BW_WBP_ZoiProfile_Record UB1RelationshipProfileRecordWidget
---@field BW_WBP_ZoiProfile_Memory UB1RelationshipProfileMemoryWidget
---@field BW_Button_Close UB1Button
local UB1RelationshipProfileWidget = {}



---@class UB1RelationshipSelectZoiFilterButton : UB1UserWidgetBase
---@field BW_Image_BG_Selected UB1Image
---@field BW_Image_BG_Hover UB1Image
---@field BW_WidgetSwitcher_Icon UB1WidgetSwitcher
---@field BW_Button_Sort UB1Button
---@field FilterType EB1RelationshipListFilterType
local UB1RelationshipSelectZoiFilterButton = {}

function UB1RelationshipSelectZoiFilterButton:OnClickedFilterButton() end


---@class UB1RelationshipSelectZoiPortrait : UB1UserWidgetBase
---@field BW_WBP_Portrait UB1PlayerPortraitWidget
---@field Image_ColorBorder UB1Image
---@field B1GridPanel_0 UB1GridPanel
local UB1RelationshipSelectZoiPortrait = {}



---@class UB1RelationshipSelectZoiWidget : UB1UserWidgetBase
---@field BW_Image_TitleNumBG UB1Image
---@field BW_Text_TitleNum UB1TextBlock
---@field BW_Text_MainTitle UB1TextBlock
---@field BW_Text_SubTitle UB1TextBlock
---@field BW_Text_SubTitleNum UB1TextBlock
---@field BW_WBP_PlayerPortrait UB1RelationshipSelectZoiPortrait
---@field BW_WBPSortButton_All UB1RelationshipSelectZoiFilterButton
---@field BW_WBPSortButton_Home UB1RelationshipSelectZoiFilterButton
---@field BW_WBPSortButton_Family UB1RelationshipSelectZoiFilterButton
---@field BW_WBPSortButton_Love UB1RelationshipSelectZoiFilterButton
---@field BW_WBPSortButton_Business UB1RelationshipSelectZoiFilterButton
---@field BW_WBPSortButton_Friend UB1RelationshipSelectZoiFilterButton
---@field BW_TileView_Zoi UB1TileView
---@field BW_Button_Close UB1Button
---@field BW_WBP_ButtonOK UB1CommonButtonWidget
---@field BW_WidgetSwitcher_List UB1WidgetSwitcher
---@field BW_Horizontal_Box_SubTitle UB1HorizontalBox
---@field CachedEntryDataList TArray<UB1RelationshipEntryData>
local UB1RelationshipSelectZoiWidget = {}

---@param InFilterType EB1RelationshipListFilterType
function UB1RelationshipSelectZoiWidget:OnClickFilterButton(InFilterType) end
function UB1RelationshipSelectZoiWidget:OnClickedOK() end
---@param InEntry UObject
function UB1RelationshipSelectZoiWidget:OnClickedItemEntry(InEntry) end
function UB1RelationshipSelectZoiWidget:OnClickedClose() end


---@class UB1RelationshipTagGaugeWidget : UB1RelationshipGaugeWidget
---@field BW_WBP_Relationship_Tag UB1RelationshipTagWidget
local UB1RelationshipTagGaugeWidget = {}



---@class UB1RelationshipTagWidget : UB1UserWidgetBase
---@field BW_Text_TagName UB1TextBlock
---@field BW_Image_BG_Focus UB1Image
---@field BW_WBP_RelationshipIcon UB1RelationshipIconWidget
---@field BW_Button UB1Button
---@field BW_SizeBox_RelationshipFocus UB1SizeBox
---@field BW_BackgroundBlur UB1BackgroundBlur
---@field bSelected boolean
local UB1RelationshipTagWidget = {}



---@class UB1RelationshipTooltipWidget : UB1TooltipWidgetBase
---@field BW_Text_CurrentTag UTextBlock
---@field BW_Image_BG UImage
---@field BW_Image_Icon UB1Image
---@field BW_Text_name UTextBlock
---@field BW_Text_Description UTextBlock
---@field BW_HorizontalBox_Next UB1HorizontalBox
---@field BW_Image_NextIcon UB1Image
---@field BW_Text_NextName UTextBlock
---@field BW_WBP_FocusTag UB1UserWidget
---@field BW_WBP_GaugeWidget UB1RelationshipGaugeWidget
---@field BW_WBP_GaugeTag1 UB1RelationshipGaugeTagWidget
---@field BW_WBP_GaugeTag2 UB1RelationshipGaugeTagWidget
---@field BW_WBP_GaugeTag3 UB1RelationshipGaugeTagWidget
---@field BW_WBP_GaugeTag4 UB1RelationshipGaugeTagWidget
---@field BW_WBP_GaugeTag5 UB1RelationshipGaugeTagWidget
---@field BW_WBP_GaugeTag6 UB1RelationshipGaugeTagWidget
---@field BW_WBP_GaugeTag7 UB1RelationshipGaugeTagWidget
local UB1RelationshipTooltipWidget = {}



---@class UB1RelationshipUIHandler : UB1UIHandlerBase
---@field CurrentRelationshipWidget UB1RelationshipListWidget
---@field CachedEntryMap TMap<FB1EntityId, UB1RelationshipEntryData>
---@field MoveTogetherDestLocation FVector
local UB1RelationshipUIHandler = {}



---@class UB1RemoteInteractionButton : UB1UserWidgetBase
---@field BW_Text_Label UB1TextBlock
---@field BW_Image_Icon UB1Image
---@field BW_Button UB1Button
local UB1RemoteInteractionButton = {}



---@class UB1RemoteInteractionPanel : UB1UserWidgetBase
---@field BW_CategoryText UB1TextBlock
---@field BW_CanvasPanel UB1CanvasPanel
---@field BW_Button0 UB1RemoteInteractionButton
---@field BW_Button1 UB1RemoteInteractionButton
---@field BW_Button2 UB1RemoteInteractionButton
local UB1RemoteInteractionPanel = {}



---@class UB1RemoteInteractionUIHandler : UB1UIHandlerBase
local UB1RemoteInteractionUIHandler = {}


---@class UB1RoomDefaultPresetAsset : UB1BuildDefaultPresetAssetBase
---@field RoomData FB1RoomSerializeData
---@field ObjectsData FB1GalleryRoomObjectDatas
local UB1RoomDefaultPresetAsset = {}



---@class UB1RootWidget : UB1UserWidgetBase
local UB1RootWidget = {}


---@class UB1SDPropertyDropdownData : UObject
---@field ID FName
---@field DisplayName FText
---@field DescName FText
---@field Metalic float
---@field Roughness float
---@field Selected boolean
local UB1SDPropertyDropdownData = {}



---@class UB1SDPropertyDropdownEntryWidget : UB1UserListEntryWidgetBase
---@field Text_name UB1TextBlock
---@field bSelected boolean
local UB1SDPropertyDropdownEntryWidget = {}



---@class UB1SDPropertyDropdownWidget : UB1UserWidgetBase
---@field Button UB1Button
---@field Text_name UB1TextBlock
---@field Text_Category UB1TextBlock
---@field Tile_View_List UB1TileView
local UB1SDPropertyDropdownWidget = {}

---@param InItem UObject
function UB1SDPropertyDropdownWidget:OnListItemSelectionChanged(InItem) end
---@param InItem UObject
---@param bIsHovered boolean
function UB1SDPropertyDropdownWidget:OnListItemIsHoveredChanged(InItem, bIsHovered) end
function UB1SDPropertyDropdownWidget:OnDropdownButtonClicked() end


---@class UB1SDRequestWidget : UB1UserWidgetBase
---@field Button_Close UB1Button
---@field B1VerticalBox_Prompt UB1VerticalBox
---@field Text_Box_Prompt UB1MultiLineEditableTextBox
---@field WBP_Common_Button_Confirm UB1CommonButtonWidget
---@field WBP_Common_Button_Cancel UB1CommonButtonWidget
---@field image_loading UB1Image
local UB1SDRequestWidget = {}

---@param bInOpen boolean
function UB1SDRequestWidget:ShowRequestWidget(bInOpen) end
function UB1SDRequestWidget:OnConfirmButtonClicked() end
function UB1SDRequestWidget:OnCloseButtonClicked() end
function UB1SDRequestWidget:OnCancelButtonClicked() end


---@class UB1SDResultWidget : UB1UserWidgetBase
---@field Button_Close UB1Button
---@field Image_Texture UB1Image
---@field WBP_Common_Button_Back UB1CommonButtonWidget
---@field WBP_Common_Button_Confirm UB1CommonButtonWidget
local UB1SDResultWidget = {}

---@param bInOpen boolean
function UB1SDResultWidget:ShowResultWidget(bInOpen) end
function UB1SDResultWidget:OnConfirmButtonClicked() end
function UB1SDResultWidget:OnCloseButtonClicked() end
function UB1SDResultWidget:OnBackButtonClicked() end


---@class UB1SaveAsWidget : UB1UserWidgetBase
---@field SaveSlotNameBox UB1EditableTextBox
---@field BW_Image_TitleError UB1Image
---@field BW_Text_Num_Title UB1TextBlock
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Save UB1CommonButtonWidget
local UB1SaveAsWidget = {}

function UB1SaveAsWidget:ToggleWidget() end
---@param InText FText
function UB1SaveAsWidget:OnTextChanged(InText) end
function UB1SaveAsWidget:OnClicked_Save() end
function UB1SaveAsWidget:OnClicked_Cancel() end


---@class UB1SaveDataEtcManager : UB1ManagerBase
---@field CameraData FB1CameraSaveData
---@field WallMode int32
local UB1SaveDataEtcManager = {}



---@class UB1SaveLoadListEntryWidget : UB1UserListEntryWidgetBase
---@field Portrait UB1Image
---@field Text_AutoSaved UB1TextBlock
---@field SlotName UB1TextBlock
---@field CharacterName UB1TextBlock
---@field MapName UB1TextBlock
---@field SavedTime UB1TextBlock
---@field Button_Load UB1Button
---@field Button_Delete UB1Button
---@field EntryData UB1SaveLoadThumbnailData
local UB1SaveLoadListEntryWidget = {}

function UB1SaveLoadListEntryWidget:OnClicked_Load() end
function UB1SaveLoadListEntryWidget:OnClicked_Delete() end


---@class UB1SaveLoadListWidget : UB1UserWidgetBase
---@field ListView UB1ListView
local UB1SaveLoadListWidget = {}

function UB1SaveLoadListWidget:ToggleWidget() end
function UB1SaveLoadListWidget:OnClicked_Close() end


---@class UB1SaveLoadManager : UB1ManagerBase
---@field SlotData FB1SaveSlotData
---@field CurrentLoadGameState EB1LoadGameState
---@field LatestSaveFileName FString
---@field CachedSavedSlot TArray<UB1SaveLoadThumbnailData>
---@field CurrentSavedSlot UB1SaveLoadThumbnailData
---@field WaitSavePopup UB1PopupWidgetBase
local UB1SaveLoadManager = {}

---@return boolean
function UB1SaveLoadManager:IsExistSaveGame() end


---@class UB1SaveLoadThumbnailData : UObject
local UB1SaveLoadThumbnailData = {}


---@class UB1SavePresetTypeContentData : UObject
---@field Selections TArray<FB1SavePresetTypeSelectionData>
local UB1SavePresetTypeContentData = {}



---@class UB1SceneCaptureComponent2D : USceneCaptureComponent2D
---@field RenderTickCount int32
---@field CaptureFrameWeight float
local UB1SceneCaptureComponent2D = {}



---@class UB1SceneCaptureManager : UB1ManagerBase
local UB1SceneCaptureManager = {}


---@class UB1SceneConfig : UObject
---@field Scenes TArray<FB1SceneSetting>
---@field StartupScene int32
local UB1SceneConfig = {}



---@class UB1SceneManager : UB1ManagerBase
---@field SceneSetting TArray<FB1SceneSetting>
local UB1SceneManager = {}



---@class UB1ScheduleBarEntryBase : UB1UserListEntryWidgetBase
local UB1ScheduleBarEntryBase = {}


---@class UB1ScheduleBarWidgetPool : UObject
---@field ScheduleEditDayBarWidgetClass TSubclassOf<UB1ScheduleEditDayBarWidget>
---@field ScheduleCancelBarWidgetClass TSubclassOf<UB1ScheduleCancelEntryWidget>
---@field ScheduleEditWidget TWeakObjectPtr<UB1ScheduleEditWidget>
local UB1ScheduleBarWidgetPool = {}



---@class UB1ScheduleButtonWidget : UB1UserWidgetBase
---@field BW_Button_Schedule UB1Button
---@field BW_Text_Schedule UB1TextBlock
---@field BW_Image_BG UB1Image
---@field BW_Image_LongBG UB1Image
---@field BW_Image_Icon UB1Image
local UB1ScheduleButtonWidget = {}



---@class UB1ScheduleCancelEntryWidget : UB1ScheduleBarEntryBase
---@field BW_Button UB1Button
local UB1ScheduleCancelEntryWidget = {}



---@class UB1ScheduleControlBoxWidget : UB1UserWidgetBase
---@field BW_CloseButton UB1Button
---@field BW_AcceptScheduleButton UB1Button
---@field BW_Button_GoCar UB1Button
---@field BW_RejectScheduleButton UB1Button
---@field BW_Button_GoBack UB1Button
---@field BW_Button_ScheduleEdit UB1Button
---@field BW_SizeBox_Cancel UB1SizeBox
---@field BW_SizeBox_Proceed UB1SizeBox
---@field BW_SizeBox_GoBack UB1SizeBox
---@field BW_ScheduleDesc UB1TextBlock
---@field BW_Canvas_Panel UB1CanvasPanel
local UB1ScheduleControlBoxWidget = {}



---@class UB1ScheduleEditAddEventWidget : UB1UserWidgetBase
---@field BW_VerticalBox UB1VerticalBox
---@field BW_Button_SocialEvent UB1Button
---@field BW_Button_Schedule UB1Button
local UB1ScheduleEditAddEventWidget = {}

function UB1ScheduleEditAddEventWidget:OnClickedSocialEventButton() end
function UB1ScheduleEditAddEventWidget:OnClickedScheduleButton() end


---@class UB1ScheduleEditDayBarWidget : UB1ScheduleBarEntryBase
---@field BW_Text_ScheduleName UB1TextBlock
---@field BW_Image_BG UB1Image
---@field BW_Button_Schedule UB1Button
---@field BW_Button_Edit UB1Button
---@field BW_Button_Cancel UB1Button
---@field BW_Button_Delete UB1Button
---@field BW_Button_Edit_1 UB1Button
---@field BW_Button_Cancel_1 UB1Button
---@field BW_Button_Delete_1 UB1Button
---@field BW_Button_HandleLeft UB1Button
---@field BW_Button_HandleRight UB1Button
---@field BW_Image_SocialEvent UB1Image
---@field BW_Overlay_SmartZoi UB1Overlay
local UB1ScheduleEditDayBarWidget = {}



---@class UB1ScheduleEditDayEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Button UB1Button
---@field BW_Image_Error UB1Image
local UB1ScheduleEditDayEntryWidget = {}



---@class UB1ScheduleEditDayTimeLineWidget : UB1UserWidgetBase
---@field BW_Text_Day UB1TextBlock
---@field BW_Button_DayScheduleToggle UB1Button
---@field BW_WidgetSwitcher_DayScheduleToggle UB1WidgetSwitcher
---@field BW_DynamicEntryBox_Timeline UB1DynamicEntryBox
---@field BW_VerticalBox_TimeLine UB1VerticalBox
---@field BW_CanvasPanel_Timeline UB1CanvasPanel
---@field bDailyAllSchedulesButtonState boolean
local UB1ScheduleEditDayTimeLineWidget = {}



---@class UB1ScheduleEditTooltipWidget : UB1TooltipWidgetBase
local UB1ScheduleEditTooltipWidget = {}


---@class UB1ScheduleEditWidget : UB1UserWidgetBase
---@field BW_WBP_Common_PlayerPortrait UB1PlayerPortraitWidget
---@field BW_WBP_Cat_Operator_Family UB1CatOperatorFamilyWidget
---@field BW_Text_CharacterName UB1TextBlock
---@field BW_Text_Desc UB1TextBlock
---@field BW_Text_Day UB1TextBlock
---@field BW_Text_Time UB1TextBlock
---@field BW_CheckBox_ScheduleOff UB1CheckBox
---@field BW_WBP_Mon UB1ScheduleEditDayTimeLineWidget
---@field BW_WBP_Tue UB1ScheduleEditDayTimeLineWidget
---@field BW_WBP_Wed UB1ScheduleEditDayTimeLineWidget
---@field BW_WBP_Thu UB1ScheduleEditDayTimeLineWidget
---@field BW_WBP_Fri UB1ScheduleEditDayTimeLineWidget
---@field BW_WBP_Sat UB1ScheduleEditDayTimeLineWidget
---@field BW_WBP_Sun UB1ScheduleEditDayTimeLineWidget
---@field ScheduleEditDayBarWidgetClass TSubclassOf<UB1ScheduleEditDayBarWidget>
---@field ScheduleCancelBarWidgetClass TSubclassOf<UB1ScheduleCancelEntryWidget>
---@field bWeeklyAllSchedulesButtonState boolean
local UB1ScheduleEditWidget = {}



---@class UB1ScheduleSelectListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_SiteName UB1TextBlock
---@field BW_Image_Site UB1Image
---@field BW_Button UB1Button
---@field BW_SizeBox UB1SizeBox
---@field BW_WidgetSwitcher_Type UB1WidgetSwitcher
---@field DataVM UB1ChangableScheduleSiteVM
local UB1ScheduleSelectListEntryWidget = {}



---@class UB1ScheduleSelectWidget : UB1UserWidgetBase
---@field BW_TileView_ScheduleList UB1TileView
---@field BW_WidgetSwitcher_Desc UB1WidgetSwitcher
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Save UB1CommonButtonWidget
---@field BW_Image_Site UB1Image
---@field BW_Text_SiteName UB1TextBlock
---@field BW_Text_SiteDesc UB1TextBlock
local UB1ScheduleSelectWidget = {}



---@class UB1ScheduleTooltipWidget : UB1TooltipWidgetBase
---@field BW_Image UB1Image
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Desc UB1TextBlock
---@field BW_Text_EventPlace UB1TextBlock
---@field BW_HorizontalBox_SocialEvent UB1HorizontalBox
---@field BW_Text_HostName UB1TextBlock
---@field BW_Overlay_SmartZoi UB1Overlay
---@field BW_HorizontalBox_Editable UB1HorizontalBox
local UB1ScheduleTooltipWidget = {}



---@class UB1ScreenEffectWidget : UB1UserWidgetBase
local UB1ScreenEffectWidget = {}


---@class UB1SignificanceManager : USignificanceManager
local UB1SignificanceManager = {}


---@class UB1SimsTestWidget : UB1UserWidgetBase
---@field Text_Skill0 UTextBlock
---@field Text_Skill1 UTextBlock
---@field Text_Skill2 UTextBlock
---@field Text_Skill3 UTextBlock
---@field ProgressBar_Skill0 UProgressBar
---@field ProgressBar_Skill1 UProgressBar
---@field ProgressBar_Skill2 UProgressBar
---@field ProgressBar_Skill3 UProgressBar
local UB1SimsTestWidget = {}



---@class UB1SiteAreaComponent : UActorComponent
---@field AuthorName FString
---@field PresetAssets UDataTable
local UB1SiteAreaComponent = {}



---@class UB1SiteAreaPathFindingComponent : UActorComponent
---@field ReplacingOutlinePoints TArray<FVector>
---@field PortalPoints TArray<FB1PortalData>
---@field GiftBoxPoints TArray<FVector>
---@field bUseVehiclePoint boolean
---@field VehiclePoint FVector
---@field bOnlyReachableByWarp boolean
---@field XCollisionBitArrayMap TMap<int32, FB1PathFindGridBitArray>
---@field YCollisionBitArrayMap TMap<int32, FB1PathFindGridBitArray>
---@field ZoneGraphNodeArray TArray<FB1ZoneGraphNode>
---@field ZoneGraphZoneInfoMap TMap<int32, FB1ZoneGraphZoneInfo>
---@field SiteLocation FVector
---@field GridMaxX int32
---@field GridMaxY int32
---@field MinFloor int32
---@field MaxFloor int32
local UB1SiteAreaPathFindingComponent = {}



---@class UB1SiteAreaPathFindingDataAsset : UB1DataAssetBase
---@field SaveData FB1SiteAreaPathFindingSaveData
local UB1SiteAreaPathFindingDataAsset = {}



---@class UB1SiteContextMenuWidget : UB1UserWidgetBase
---@field BW_VerticalBox_Menu UB1VerticalBox
---@field BW_VerticalBox_SiteEditMenu UB1VerticalBox
---@field BW_Button_SiteEdit UB1Button
---@field BW_Button_SiteInfoEdit UB1Button
local UB1SiteContextMenuWidget = {}



---@class UB1SiteEditUIHandler : UB1UIHandlerBase
---@field SiteEditWidget UB1SiteEditWidget
---@field SiteInfoEditPopUpWidget UB1SiteInfoEditPopUpWidget
local UB1SiteEditUIHandler = {}



---@class UB1SiteEditWidget : UB1UserWidgetBase
---@field GuideCanvas UB1CanvasPanel
---@field BW_Map_SiteSelectMessage UB1MapSiteSelectMessageWidget
---@field BW_Site_ContextMenu UB1SiteContextMenuWidget
---@field BW_Map_Compass_Widget UB1MapCompassWidget
---@field BW_Map_SiteInfo_Widget UB1MapSiteInfoWidget
local UB1SiteEditWidget = {}



---@class UB1SiteInfoButtonV2Widget : UB1SiteInfoButtonWidget
---@field BW_Image_Icon UB1Image
---@field BW_Image_IconBg UB1Image
---@field BW_Image_IconGlow UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_Button UB1Button
---@field BW_WBP_PinButton UB1MapPinButtonWidget
---@field BW_Widget_FamilyLoveArrow UWidget
---@field BW_Image_pin UB1Image
---@field BW_Image_CleanlinessNegative UB1Image
---@field BW_Image_CleanlinessPositive UB1Image
---@field BW_Widget_FamilyLove UWidget
---@field BW_Text_FamilyLove UB1TextBlock
---@field BW_Slider_FamilyLove UB1Slider
---@field BW_Widget_Cleanliness UWidget
---@field BW_ProgressBar_CleanlinessNegative UB1ProgressBar
---@field BW_ProgressBar_CleanlinessPositive UB1ProgressBar
---@field BW_Text_ZOINumber UB1TextBlock
---@field WidgetSetting FB1SiteInfoButtonV2WidgetSetting
local UB1SiteInfoButtonV2Widget = {}



---@class UB1SiteInfoButtonWidget : UB1UserWidgetBase
---@field EmptyLandIcon TSoftObjectPtr<UObject>
---@field EmptySiteIcon TSoftObjectPtr<UObject>
local UB1SiteInfoButtonWidget = {}



---@class UB1SiteInfoEditPopUpWidget : UB1UserWidgetBase
---@field BW_Image_Site UB1Image
---@field BW_Image_TitleError UB1Image
---@field BW_Image_ContentError UB1Image
---@field BW_Button_ImageEdit UB1Button
---@field BW_Button_Reset UB1Button
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Save UB1CommonButtonWidget
---@field BW_EditableTextBox_SiteName UB1EditableTextBox
---@field BW_MultiLineEditableTextBox_SiteDesc UB1MultiLineEditableTextBox
---@field BW_Text_Num UB1TextBlock
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Num_Content UB1TextBlock
local UB1SiteInfoEditPopUpWidget = {}

---@param InText FText
function UB1SiteInfoEditPopUpWidget:OnSiteNameEditableTextBoxChanged(InText) end
---@param InText FText
function UB1SiteInfoEditPopUpWidget:OnSiteDescEditableTextBoxChanged(InText) end


---@class UB1SiteManager : UB1ManagerBase
---@field SiteAreas TArray<FB1SiteAreaSaveData>
---@field CurrentMapId FName
---@field SiteInfoMap TMap<FName, FB1SiteInfo>
local UB1SiteManager = {}



---@class UB1SkillChangeEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Text_LevelIcon UB1TextBlock
---@field BW_Text_name UB1TextBlock
---@field BW_Text_Level UB1TextBlock
---@field BW_Image_Icon UB1Image
---@field BW_Image_IconBg UB1Image
---@field BW_Image_Gauge UB1Image
local UB1SkillChangeEntryWidget = {}



---@class UB1SkillChangeWidget : UB1CatOperatorChangeWidgetBase
---@field BW_TileView_Skill UB1TileView
---@field BW_Button_Close UB1Button
local UB1SkillChangeWidget = {}



---@class UB1SkillEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Text_Level UB1TextBlock
---@field BW_Text_name UB1TextBlock
---@field BW_Image_Gauge UB1Image
---@field BW_Button UB1Button
---@field Data UB1CatOperatorPlayerSkillEntryVM
local UB1SkillEntryWidget = {}



---@class UB1SkillGaugeWidget : UB1UserWidgetBase
---@field BW_CanvasPanel UB1CanvasPanel
---@field BW_Text_Level UB1TextBlock
---@field BW_Image_Icon UB1Image
---@field BW_Image_Gauge UB1Image
---@field Anim_Open UWidgetAnimation
---@field Anim_Loop UWidgetAnimation
---@field MaxAngle float
local UB1SkillGaugeWidget = {}



---@class UB1SkillProgressBarWidget : UB1UserWidgetBase
---@field BW_ProgressBar_Level UB1ProgressBar
local UB1SkillProgressBarWidget = {}



---@class UB1SkillTooltipObjectEntryVM : UObject
local UB1SkillTooltipObjectEntryVM = {}


---@class UB1SkillTooltipObjectEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Object UB1Image
local UB1SkillTooltipObjectEntryWidget = {}



---@class UB1SkillTooltipWidget : UB1TooltipWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_Text_Description UB1TextBlock
---@field BW_Text_Level UB1TextBlock
---@field BW_TileView_Recommend UB1TileView
local UB1SkillTooltipWidget = {}



---@class UB1SkillUIHandler : UB1UIHandlerBase
local UB1SkillUIHandler = {}


---@class UB1SkillWidget : UB1UserWidgetBase
---@field BW_TileView UB1TileView
---@field BW_Button_TearOff UB1Button
---@field BW_WidgetSwitcher_Contents UB1WidgetSwitcher
local UB1SkillWidget = {}



---@class UB1SkinFeaturesWidget : UB1UserWidgetBase
---@field BW_DynamicEntryBox_SkinFeatures UB1DynamicEntryBox
---@field BW_Button_Reset UB1Button
---@field SliderSize FVector2D
local UB1SkinFeaturesWidget = {}



---@class UB1SlotComponent : USceneComponent
---@field OnLoadCompletedDelegate FB1SlotComponentOnLoadCompletedDelegate
---@field SlotType EB1SlotType
---@field LinkedSlotMap TMap<EB1SlotDirection, FName>
---@field InteractionSlot FB1InteractionSlotData
---@field FxSlot FB1FxSlotData
---@field ExtraRequireSpaceSlot FB1ExtraRequireSpaceSlotData
---@field ObjectSlotId FName
---@field ConnectedChairComponenetName FName
---@field ObjectSlot FB1ObjectSlotData
---@field PostureTags TMap<FName, FName>
local UB1SlotComponent = {}

---@param InNiagaraComponent UNiagaraComponent
function UB1SlotComponent:OnFXLoadComplete__DelegateSignature(InNiagaraComponent) end


---@class UB1SmartZoiPopupWidget : UB1UserWidgetBase
---@field BW_MultiLineEditableTextBox_SmartZoi UB1MultiLineEditableTextBox
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Confirm UB1CommonButtonWidget
---@field BW_Text_SaveDesc UB1TextBlock
local UB1SmartZoiPopupWidget = {}

function UB1SmartZoiPopupWidget:OnClickedConfirm() end
function UB1SmartZoiPopupWidget:OnClickedCancel() end
---@param InText FText
---@param InCommitMethod ETextCommit::Type
function UB1SmartZoiPopupWidget:HandleOnTextCommitted(InText, InCommitMethod) end
---@param InText FText
function UB1SmartZoiPopupWidget:HandleOnTextChanged(InText) end


---@class UB1SmartphoneAmbitionWidget : UB1UserWidgetBase
---@field BW_Image_Color UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_Text_Motto UB1TextBlock
---@field BW_Button UB1Button
local UB1SmartphoneAmbitionWidget = {}



---@class UB1SmartphoneAppIconWidget : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Button UB1Button
---@field WBP_Mobile_AppIcon_Alert UB1MobileAppAlertIconWidget
---@field Icon FSlateBrush
---@field WidgetListToOpen TArray<EB1UIType>
local UB1SmartphoneAppIconWidget = {}



---@class UB1SmartphoneAppWidgetBase : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
local UB1SmartphoneAppWidgetBase = {}



---@class UB1SmartphoneBaseWidget : UB1UserWidgetBase
---@field WBP_Mobile_AppIcon_Message UB1SmartphoneAppIconWidget
---@field WBP_Mobile_Utility_Bill UB1SmartphoneBillWidget
---@field WBP_Mobile_AppIcon_recruiting UB1SmartphoneAppIconWidget
local UB1SmartphoneBaseWidget = {}



---@class UB1SmartphoneBillWidget : UB1UserWidgetBase
---@field BW_WBP_CommonCurrency UB1CurrencyWidget
local UB1SmartphoneBillWidget = {}



---@class UB1SmartphoneCharacterSelectListEntryWidget : UB1UserWidgetBase
---@field BW_Button UB1Button
---@field BW_Image_Profile UB1Image
---@field BW_Text_name UB1TextBlock
---@field BW_RelationshipGaugeEntry UB1DynamicEntryBox
---@field WBP_Common_Check UB1CommonCheckWidget
---@field BW_WBP_Relationship_Focus_Tag UB1UserWidget
---@field BW_WBP_Relationship_Tag UB1RelationshipTagWidget
---@field DefaultPortrait TSoftObjectPtr<UTexture>
---@field DimmedOpacity float
local UB1SmartphoneCharacterSelectListEntryWidget = {}

function UB1SmartphoneCharacterSelectListEntryWidget:OnClickedButton() end


---@class UB1SmartphoneCharacterSelectWidget : UB1UserWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Button_Close UB1Button
---@field BW_VerticalBox_contactList UB1VerticalBox
---@field WBP_Common_Button_Start UB1CommonButtonWidget
---@field SlotWidgetClass TSubclassOf<UUserWidget>
local UB1SmartphoneCharacterSelectWidget = {}



---@class UB1SmartphoneHeaderWidget : UB1UserWidgetBase
---@field BW_Text_Time UB1TextBlock
---@field Color EB1SmartphoneHeaderWidgetColor
local UB1SmartphoneHeaderWidget = {}



---@class UB1SmartphoneJobSearchBannerListWidget : UB1UserWidgetBase
local UB1SmartphoneJobSearchBannerListWidget = {}


---@class UB1SmartphoneJobSearchDetailWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Text_JobName UB1TextBlock
---@field BW_Text_JobInfo UB1TextBlock
---@field BW_Image_Introduction UB1Image
---@field BW_Image_CompanyAppIcon UB1Image
---@field BW_Text_Description UB1TextBlock
---@field BW_WBP_WorkingConditions UB1SmartphoneJobSearchWorkingConditionsWidget
---@field BW_CommonButton_Apply UB1CommonButtonWidget
local UB1SmartphoneJobSearchDetailWidget = {}



---@class UB1SmartphoneJobSearchHomeWidget : UB1UserWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_DynamicEntryBox_CompanyList UB1DynamicEntryBox
---@field BW_Button_Close UB1Button
---@field BW_Button_Info UB1Button
---@field BW_Image_BG UB1Image
---@field BW_ListView_SubCategory UB1ListView
---@field BW_ListView_MainCategory UB1ListView
local UB1SmartphoneJobSearchHomeWidget = {}



---@class UB1SmartphoneJobSearchJobListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Main UB1Image
---@field BW_Text_JobPosition UB1TextBlock
---@field BW_Text_WorkConditions UB1TextBlock
---@field BW_Text_Location UB1TextBlock
---@field BW_Text_Rank UB1TextBlock
---@field BW_Text_Headcount UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Widget_HighestCareer UWidget
---@field BW_Button_Join UB1CommonButtonWidget
---@field BW_Widget_Pressed UWidget
---@field BW_Image_Num UB1Image
---@field EmptyHeadCountColor FLinearColor
---@field MaxHeadCountColor FLinearColor
local UB1SmartphoneJobSearchJobListEntryWidget = {}



---@class UB1SmartphoneJobSearchJobListWidget : UB1UserWidgetBase
---@field BW_CanvasPanel UB1CanvasPanel
---@field BW_Text_Title UB1TextBlock
---@field BW_WidgetSwitcher UB1WidgetSwitcher
---@field BW_TileView_JobList UB1TileView
---@field BW_Widget_NoCompany UWidget
local UB1SmartphoneJobSearchJobListWidget = {}



---@class UB1SmartphoneJobSearchJobPromotionListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Main UB1Image
---@field BW_Text_WorkConditions UB1TextBlock
---@field BW_Text_Rank UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
local UB1SmartphoneJobSearchJobPromotionListEntryWidget = {}



---@class UB1SmartphoneJobSearchJobPromotionWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Image_CompanyPic UB1Image
---@field BW_ListView_Slot UB1ListView
local UB1SmartphoneJobSearchJobPromotionWidget = {}



---@class UB1SmartphoneJobSearchMainCategoryListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Line UB1Image
---@field BW_Text_Category UB1TextBlock
---@field BW_Button_MainCategory UB1Button
local UB1SmartphoneJobSearchMainCategoryListEntryWidget = {}



---@class UB1SmartphoneJobSearchRequirementEntry : UB1UserListEntryWidgetBase
---@field Text_JobTitle UB1TextBlock
---@field BW_Text_JobDesc UB1TextBlock
---@field BW_DynamicEntry_GradeDetail UB1DynamicEntryBox
local UB1SmartphoneJobSearchRequirementEntry = {}



---@class UB1SmartphoneJobSearchRequirementGrade : UB1UserWidgetBase
---@field BW_Text_GradeName UB1TextBlock
---@field BW_Text_GradeCondition UB1TextBlock
---@field BW_Text_SkillCondition1 UB1TextBlock
---@field BW_Text_SkillCondition2 UB1TextBlock
local UB1SmartphoneJobSearchRequirementGrade = {}



---@class UB1SmartphoneJobSearchSubCategoryListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Image_Select UB1Image
---@field BW_Text_Category UB1TextBlock
---@field BW_Button_SubCategory UB1Button
local UB1SmartphoneJobSearchSubCategoryListEntryWidget = {}



---@class UB1SmartphoneJobSearchTabButton : UB1UserWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Text_BtnName UB1TextBlock
---@field BW_Button_Tab UB1Button
---@field BW_CanvasPanel UB1CanvasPanel
local UB1SmartphoneJobSearchTabButton = {}



---@class UB1SmartphoneJobSearchWidget : UB1SmartphoneAppWidgetBase
---@field BW_WBP_Home UB1SmartphoneJobSearchHomeWidget
---@field BW_WBP_Detail UB1SmartphoneJobSearchDetailWidget
---@field BW_WBP_CareerLine UB1SmartphoneJobSearchJobPromotionWidget
---@field BW_Mobile_Company UB1MyCompanyWidget
---@field BW_WBP_RecruitButton UB1SmartphoneJobSearchTabButton
---@field BW_WBP_MyInfoButton UB1SmartphoneJobSearchTabButton
---@field BW_WidgetSwitcher_Job UB1WidgetSwitcher
---@field BW_ListView_RequirementDetail UB1ListView
---@field BW_Button_Close_info UB1Button
---@field Anim_InfoOpen UWidgetAnimation
local UB1SmartphoneJobSearchWidget = {}



---@class UB1SmartphoneJobSearchWorkingConditionsWidget : UB1UserWidgetBase
---@field BW_Text_Workhour UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Text_Payday UB1TextBlock
---@field BW_Text_Location UB1TextBlock
---@field BW_Text_RequiredGrowthStep UB1TextBlock
---@field BW_WBP_WorkdayMon UB1UserWidgetBase
---@field BW_WBP_WorkdayTue UB1UserWidgetBase
---@field BW_WBP_WorkdayWed UB1UserWidgetBase
---@field BW_WBP_WorkdayThu UB1UserWidgetBase
---@field BW_WBP_WorkdayFri UB1UserWidgetBase
---@field BW_WBP_WorkdaySat UB1UserWidgetBase
---@field BW_WBP_WorkdaySun UB1UserWidgetBase
---@field BW_CanvasPanel_Salary UB1CanvasPanel
---@field BW_CanvasPanel_Location UB1CanvasPanel
---@field BW_Text_WorkTime UB1TextBlock
local UB1SmartphoneJobSearchWorkingConditionsWidget = {}



---@class UB1SmartphoneScheduleWidget : UB1UserWidgetBase
---@field BW_Button UB1Button
local UB1SmartphoneScheduleWidget = {}



---@class UB1SmartphoneUIHandler : UB1UIHandlerBase
local UB1SmartphoneUIHandler = {}


---@class UB1SmartphoneWidget : UB1UserWidgetBase
---@field WBP_Mobile UB1SmartphoneBaseWidget
local UB1SmartphoneWidget = {}



---@class UB1SocialEventActionListWidget : UB1UserWidgetBase
---@field BW_Text_EventName UB1TextBlock
---@field BW_WBP_TImeGauge UB1SocialEventTimeGaugeWidget
---@field BW_Button_PlayListReset UB1Button
---@field BW_NStyleButton_PlayListPlay UB1NStyleButton
---@field BW_Button_Close UB1Button
---@field BW_ListView_Action UB1ListView
---@field BW_ListView_NonPlaylistAction UB1ListView
---@field CacheScenarioActionEntryData TMap<FName, UB1SocialEventActionPlayEntryData>
---@field CacheNormalActionEntryData TMap<FName, UB1SocialEventActionPlayEntryData>
local UB1SocialEventActionListWidget = {}



---@class UB1SocialEventActionPlayEntryData : UObject
local UB1SocialEventActionPlayEntryData = {}


---@class UB1SocialEventActionPlayEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Icon UB1Image
---@field BW_Text_Role UB1TextBlock
---@field BW_Text_Action UB1TextBlock
---@field BW_Button_Action UB1Button
---@field BW_WidgetSwitcher_ActionToggle UB1WidgetSwitcher
---@field BW_Image_Dimmed UB1Image
---@field EntryData UB1SocialEventActionPlayEntryData
local UB1SocialEventActionPlayEntryWidget = {}



---@class UB1SocialEventActionTooltipWidget : UB1TooltipWidgetBase
---@field BW_ListView_Utensil UB1ListView
local UB1SocialEventActionTooltipWidget = {}



---@class UB1SocialEventActivityEntryData : UObject
local UB1SocialEventActivityEntryData = {}


---@class UB1SocialEventActivityEntryWidget : UB1UserWidgetBase
---@field BW_Icon_Action UB1Image
---@field BW_Button_Delete UB1Button
local UB1SocialEventActivityEntryWidget = {}

function UB1SocialEventActivityEntryWidget:OnClickedDelete() end


---@class UB1SocialEventActivityListWidget : UB1UserWidgetBase
---@field BW_Button_Add UB1Button
---@field BW_WBP_Action_0 UB1SocialEventActivityEntryWidget
---@field BW_WBP_Action_1 UB1SocialEventActivityEntryWidget
---@field BW_WBP_Action_2 UB1SocialEventActivityEntryWidget
---@field BW_WBP_Action_3 UB1SocialEventActivityEntryWidget
---@field BW_WBP_Action_4 UB1SocialEventActivityEntryWidget
---@field BW_WBP_Action_5 UB1SocialEventActivityEntryWidget
---@field BW_WBP_Action_6 UB1SocialEventActivityEntryWidget
local UB1SocialEventActivityListWidget = {}

---@param InTagName FName
function UB1SocialEventActivityListWidget:OnClickedDelete(InTagName) end
function UB1SocialEventActivityListWidget:OnClickedAdd() end


---@class UB1SocialEventActivitySelectEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Icon_Action UB1Image
---@field BW_Text_Action UB1TextBlock
---@field BW_Image_Dimmed UB1Image
---@field EntryData UB1SocialEventActivityEntryData
local UB1SocialEventActivitySelectEntryWidget = {}



---@class UB1SocialEventActivitySelectWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_ActionTitle UB1WidgetSwitcher
---@field BW_ComboBoxString_ActionCategory UB1ComboBoxString
---@field BW_ListView_Action UB1ListView
---@field BW_WBP_CloseButton UB1CommonButtonWidget
---@field CacheEntryData TMap<FName, UB1SocialEventActivityEntryData>
local UB1SocialEventActivitySelectWidget = {}

function UB1SocialEventActivitySelectWidget:OnClickCloseButton() end
function UB1SocialEventActivitySelectWidget:OnChangeActivityCategory() end


---@class UB1SocialEventButtonWidget : UB1UserWidgetBase
---@field BW_Button_SocialEvent UB1Button
local UB1SocialEventButtonWidget = {}



---@class UB1SocialEventMainWidget : UB1UserWidgetBase
---@field BW_WBP_CloseButton UB1CommonButtonWidget
---@field BW_Button_Back UB1CommonButtonWidget
---@field BW_Button_Next UB1CommonButtonWidget
---@field BW_Button_Complete UB1CommonButtonWidget
---@field BW_WidgetSwitcher_Content UB1WidgetSwitcher
---@field BW_WBP_SocialEventRolePage UB1SocialEventRolePageWidget
---@field BW_WBP_SocialEventPresetPage UB1SocialEventPresetPageWidget
---@field BW_WBP_SocialEventReadyPage UB1SocialEventReadyPageWidget
---@field BW_Overlay_ZoiSelect UB1Overlay
---@field BW_WBP_SocialEventSelectZoi UB1RelationshipSelectZoiWidget
local UB1SocialEventMainWidget = {}

function UB1SocialEventMainWidget:OnClickedNextButton() end
function UB1SocialEventMainWidget:OnClickedCompleteButton() end
function UB1SocialEventMainWidget:OnClickedCloseButton() end
function UB1SocialEventMainWidget:OnClickedBackButton() end


---@class UB1SocialEventObjectEntryData : UObject
local UB1SocialEventObjectEntryData = {}


---@class UB1SocialEventObjectEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Thumbnail UB1Image
---@field BW_WBP_Currency UB1CurrencyWidget
local UB1SocialEventObjectEntryWidget = {}



---@class UB1SocialEventPageBaseWidget : UB1UserWidgetBase
local UB1SocialEventPageBaseWidget = {}


---@class UB1SocialEventPopupWidget : UB1PopupWidgetBase
---@field BW_WidgetSwitcher_StartEnd UB1WidgetSwitcher
---@field BW_WBP_Button_Confirm UB1CommonButtonWidget
---@field BW_WBP_Button_Cancel UB1CommonButtonWidget
---@field BW_WBP_Button_Picture UB1CommonButtonWidget
---@field BW_Text_EventName_Start UB1TextBlock
---@field BW_Text_EventName_End UB1TextBlock
---@field BW_Text_EventTime UB1TextBlock
local UB1SocialEventPopupWidget = {}



---@class UB1SocialEventPresetEntryData : UObject
local UB1SocialEventPresetEntryData = {}


---@class UB1SocialEventPresetEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Icon_Event UB1Image
---@field BW_Text_EventPreset UB1TextBlock
---@field BW_Image_Dimmed UB1Image
---@field EntryData UB1SocialEventPresetEntryData
local UB1SocialEventPresetEntryWidget = {}



---@class UB1SocialEventPresetPageWidget : UB1SocialEventPageBaseWidget
---@field BW_TileView_EventPreset UB1TileView
---@field BW_Icon_Event UB1Image
---@field BW_Text_EventTitle UB1TextBlock
---@field BW_Image_Event UB1Image
---@field BW_Text_Title_1 UB1TextBlock
---@field BW_Text_Error_Title UB1TextBlock
---@field BW_Text_Num_Title UB1TextBlock
---@field BW_Text_EventDesc UB1TextBlock
---@field BW_EditableTextBox_Title UB1EditableTextBox
---@field BW_Image_TitleError UB1Image
---@field BW_ComboBoxString_EventTime UB1ComboBoxString
---@field BW_Text_StartTime UB1TextBlock
---@field BW_Button_EventPlace UB1Button
---@field BW_Text_EventPlace UB1TextBlock
---@field BW_Icon_Event_1 UB1Image
---@field CachedPresetEntryDatas TMap<FName, UB1SocialEventPresetEntryData>
local UB1SocialEventPresetPageWidget = {}

---@param Text FText
---@param CommitMethod ETextCommit::Type
function UB1SocialEventPresetPageWidget:OnTitleTextCommitted(Text, CommitMethod) end
---@param Text FText
function UB1SocialEventPresetPageWidget:OnTitleTextChanged(Text) end
function UB1SocialEventPresetPageWidget:OnClickEditEventSite() end
function UB1SocialEventPresetPageWidget:OnChangeEventTime() end


---@class UB1SocialEventReadyPageWidget : UB1SocialEventPageBaseWidget
---@field BW_TileView_ObjectList UB1TileView
---@field BW_Text_EventName_Desc UB1TextBlock
---@field BW_Text_EventPlace_Desc UB1TextBlock
---@field BW_Text_EventTime_Desc UB1TextBlock
---@field BW_Text_Object_Guide_Title UB1TextBlock
---@field BW_Text_Object_Guide_Desc UB1TextBlock
local UB1SocialEventReadyPageWidget = {}



---@class UB1SocialEventRoleEntryData : UObject
local UB1SocialEventRoleEntryData = {}


---@class UB1SocialEventRoleEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Icon_Role UB1Image
---@field BW_Text_Role UB1TextBlock
---@field BW_Text_Required UB1TextBlock
---@field BW_Image_Num UB1Image
---@field BW_Text_Headcount UB1TextBlock
---@field EntryData UB1SocialEventRoleEntryData
local UB1SocialEventRoleEntryWidget = {}



---@class UB1SocialEventRolePageWidget : UB1SocialEventPageBaseWidget
---@field BW_TileView_Role UB1TileView
---@field BW_Text_Role UB1TextBlock
---@field BW_Text_Required UB1TextBlock
---@field BW_Image_Icon UB1Image
---@field BW_Text_Headcount UB1TextBlock
---@field BW_Overlay_Add UB1Overlay
---@field BW_Image_Portrait_1 UB1Image
---@field BW_Text_AddCount UB1TextBlock
---@field BW_Image_Portrait UB1Image
---@field BW_Button_RoleEdit UB1Button
---@field BW_Image_Icon_1 UB1Image
---@field BW_ComboBoxString_OutfitCategory UB1ComboBoxString
---@field BW_CheckBox_OutfitColorTheme UB1CheckBox
---@field BW_Button_Color UB1Button
---@field BW_Image_Color UB1Image
---@field BW_WBP_ColorChangeTheme UB1CommonTextColorPickerPopupWidget
---@field BW_WBP_ActionList_Do UB1SocialEventActivityListWidget
---@field BW_WBP_ActionList_Dont UB1SocialEventActivityListWidget
---@field BW_WBP_ActionSelectList_Do UB1SocialEventActivitySelectWidget
---@field BW_WBP_ActionSelectList_Dont UB1SocialEventActivitySelectWidget
---@field CacheEntryData TMap<FName, UB1SocialEventRoleEntryData>
local UB1SocialEventRolePageWidget = {}

---@param InRecommendedActivity boolean
function UB1SocialEventRolePageWidget:OnToggleSelectActivityListWidget(InRecommendedActivity) end
---@param InTagName FName
function UB1SocialEventRolePageWidget:OnDeleteRoleActivity(InTagName) end
---@param InSelectEntityIds TArray<FB1EntityId>
function UB1SocialEventRolePageWidget:OnCompleteSelectZoi(InSelectEntityIds) end
function UB1SocialEventRolePageWidget:OnColorPickerPopupWidgetResetButtonClicked() end
---@param InColor FLinearColor
---@param InType EB1ColorPickerPopupType
function UB1SocialEventRolePageWidget:OnColorPickerPopupWidgetColorChanged(InColor, InType) end
---@param bIsChecked boolean
function UB1SocialEventRolePageWidget:OnColorCheckStateChanged(bIsChecked) end
function UB1SocialEventRolePageWidget:OnClickEditSelectZoi() end
function UB1SocialEventRolePageWidget:OnClickEditSelectColor() end
function UB1SocialEventRolePageWidget:OnChangeOutfitCategory() end
---@param InCategoryId FString
---@param InRecommendedActivity boolean
function UB1SocialEventRolePageWidget:OnChangeCategoryActivity(InCategoryId, InRecommendedActivity) end
function UB1SocialEventRolePageWidget:OnCancelSelectZoi() end
---@param InTagName FName
---@param InRecommendedActivity boolean
function UB1SocialEventRolePageWidget:OnAddRoleActivity(InTagName, InRecommendedActivity) end


---@class UB1SocialEventTimeGaugeWidget : UB1UserWidgetBase
---@field BW_ProgressBar_Time UB1ProgressBar
local UB1SocialEventTimeGaugeWidget = {}



---@class UB1SocialEventUIHandler : UB1UIHandlerBase
---@field CreateMainPopUpWidget UB1SocialEventMainWidget
---@field ActionListWidgetWidget UB1SocialEventActionListWidget
---@field ActionOpenButtonWidget UB1SocialEventButtonWidget
local UB1SocialEventUIHandler = {}



---@class UB1SpawnManager : UB1ManagerBase
local UB1SpawnManager = {}


---@class UB1SpeechBubbleCanvasWidget : UB1UserWidgetBase
---@field BW_Canvas UB1CanvasPanel
---@field SpeechBubbleWidgetClass TSubclassOf<UB1SpeechBubbleWidget>
local UB1SpeechBubbleCanvasWidget = {}



---@class UB1SpeechBubbleListen : UB1UserWidgetBase
---@field BW_Text_ListenTitle UB1TextBlock
---@field BW_Text_Desc UB1TextBlock
---@field BW_Button_Close UB1Button
---@field BW_Button_Order UB1Button
---@field BW_Button_Copy UB1Button
local UB1SpeechBubbleListen = {}



---@class UB1SpeechBubbleUIHandler : UB1UIHandlerBase
---@field WidgetPool TArray<UB1SpeechBubbleWidget>
---@field ActiveObjects TSet<FB1SpeechBubbleObjectData>
local UB1SpeechBubbleUIHandler = {}



---@class UB1SpeechBubbleWidget : UB1UserWidgetBase
---@field Text_Speech UB1TextBlock
---@field Image_Icon UB1Image
---@field BW_WidgetSwitcher_Type UB1WidgetSwitcher
---@field BW_Overlay_Listen UB1Overlay
---@field BW_Button_Listen UB1Button
---@field BW_WBP_Listen UB1SpeechBubbleListen
---@field BW_Image_New UB1Image
---@field BW_Image_Category UB1Image
local UB1SpeechBubbleWidget = {}

function UB1SpeechBubbleWidget:OnClickedSpeechBubbleListen() end
function UB1SpeechBubbleWidget:OnClickedListenButton() end


---@class UB1StableDiffusionManager : UB1ManagerBase
local UB1StableDiffusionManager = {}

---@param InSD UStableDiffusion
---@param bResult boolean
function UB1StableDiffusionManager:OnTextureReceived(InSD, bResult) end
---@param InRequestId uint32
---@param InTexture UTexture2D
function UB1StableDiffusionManager:OnDLDTextureReceived(InRequestId, InTexture) end


---@class UB1StatComponent : UActorComponent
local UB1StatComponent = {}


---@class UB1StateComponent : UActorComponent
local UB1StateComponent = {}


---@class UB1StaticMeshAnimPlayerComponent : UActorComponent
local UB1StaticMeshAnimPlayerComponent = {}


---@class UB1StaticMeshUserData : UAssetUserData
---@field SocketName FName
---@field LocalOffset FTransform
local UB1StaticMeshUserData = {}



---@class UB1SteamFunctionLibrary : UBlueprintFunctionLibrary
local UB1SteamFunctionLibrary = {}

---@return boolean
function UB1SteamFunctionLibrary:IsSteamRunning() end
---@return boolean
function UB1SteamFunctionLibrary:IsOssReady() end
---@return boolean
function UB1SteamFunctionLibrary:Initialize() end
---@return FString
function UB1SteamFunctionLibrary:GetLauncherLang() end
---@return FString
function UB1SteamFunctionLibrary:GetAppLang() end
---@return int32
function UB1SteamFunctionLibrary:GetAppId() end
function UB1SteamFunctionLibrary:Deinitialize() end


---@class UB1StudioCharacterSelectEntityViewModel : UObject
---@field Portrait TSoftObjectPtr<UTexture2D>
local UB1StudioCharacterSelectEntityViewModel = {}



---@class UB1StudioCharacterSelectListEntry : UB1UserListEntryWidgetBase
---@field BW_Text_FamilyName UB1TextBlock
---@field BW_Text_name UB1TextBlock
---@field BW_Image_Character UB1Image
---@field EntryData UB1StudioCharacterSelectEntityViewModel
local UB1StudioCharacterSelectListEntry = {}



---@class UB1StudioCharacterSelectWidget : UB1UserWidgetBase
---@field BW_EditableTextBox_Search UB1EditableTextBox
---@field BW_WidgetSwitcher_SearchButton UB1WidgetSwitcher
---@field BW_Button_Search UB1Button
---@field BW_Button_Remove UB1Button
---@field BW_TileView_FamilyList UB1TileView
---@field BW_TileView_CharacterList UB1TileView
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_Button_Confirm UB1CommonButtonWidget
local UB1StudioCharacterSelectWidget = {}



---@class UB1StudioCutSceneCardWidget : UB1UserWidgetBase
---@field BW_Button_Play UB1Button
---@field BW_Image_BG UB1Image
---@field BW_Text_name UB1TextBlock
---@field CardTitleText FText
local UB1StudioCutSceneCardWidget = {}



---@class UB1StudioCutSceneWidget : UB1UserWidgetBase
---@field BW_WBP_Card_Propose UB1StudioCutSceneCardWidget
---@field BW_WBP_Card_Wedding UB1StudioCutSceneCardWidget
local UB1StudioCutSceneWidget = {}



---@class UB1StudioPhotoWidget : UB1UserWidgetBase
---@field BW_Button_Go UB1CommonButtonWidget
---@field BW_WBP_Card_Guide UB1StudioCutSceneCardWidget
local UB1StudioPhotoWidget = {}



---@class UB1StudioVideoPlayerWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_WBP_VideoPlayer UB1VideoPlayerWidget
---@field BW_B1Image UB1Image
---@field BW_WBP_Player UB1PhotoModePlayerWidget
---@field BW_Text_CutSceneTitle UB1TextBlock
---@field BW_Button_CutSceneEdit UB1CommonButtonWidget
local UB1StudioVideoPlayerWidget = {}



---@class UB1StudioWidget : UB1UserWidgetBase
---@field WBP_Studio_Photo UB1StudioPhotoWidget
---@field WBP_Studio_CutScene UB1StudioCutSceneWidget
---@field WBP_Studio_Dance UB1UserWidgetBase
local UB1StudioWidget = {}



---@class UB1SubActionComponent : UActorComponent
local UB1SubActionComponent = {}


---@class UB1SubMaterialAssetUserData : UAssetUserData
---@field SubMaskedMaterials TMap<FName, UMaterialInterface>
---@field eCurrentSubMatType EB1SubMaterialType
---@field BaseSubMaterials FB1SubMaterials
local UB1SubMaterialAssetUserData = {}

---@param EBlendMode EBlendMode
---@param SMComp UStaticMeshComponent
---@param bForce boolean
---@return boolean
function UB1SubMaterialAssetUserData:SwitchMaterialsFromBlendMode(EBlendMode, SMComp, bForce) end
---@param eSubMatType EB1SubMaterialType
---@param SMComp UStaticMeshComponent
---@param bForce boolean
---@return boolean
function UB1SubMaterialAssetUserData:SwitchMaterials(eSubMatType, SMComp, bForce) end
---@param SMComp UStaticMeshComponent
function UB1SubMaterialAssetUserData:RestoreMaterials(SMComp) end
---@return boolean
function UB1SubMaterialAssetUserData:IsSubMaterial() end
---@return EB1SubMaterialType
function UB1SubMaterialAssetUserData:GetSubMaterialType() end


---@class UB1SubMaterialComponent : UActorComponent
---@field ObjectMeshInfos TArray<FB1ObjectMeshInfo>
---@field bSubMaterial boolean
---@field DefaultMaterialInfos TMap<UMeshComponent, FDefaultMaterialInfo>
---@field LastestAlpha float
---@field IsCameraCollision boolean
local UB1SubMaterialComponent = {}



---@class UB1SubMaterialInstanceUserData : UAssetUserData
---@field SubMaterialInstanceMap TMap<EBlendMode, UMaterialInterface>
local UB1SubMaterialInstanceUserData = {}

---@param BlendMode EBlendMode
---@param Material UMaterialInterface
function UB1SubMaterialInstanceUserData:SetSubMaterial(BlendMode, Material) end
---@param BlendMode EBlendMode
---@return UMaterialInterface
function UB1SubMaterialInstanceUserData:GetSubMaterial(BlendMode) end


---@class UB1SuggestedContributorItemData : UObject
local UB1SuggestedContributorItemData = {}


---@class UB1System : UGameInstanceSubsystem
---@field ManagerMap TMap<EB1ManagerType, UB1ManagerBase>
---@field ManagerList TArray<UB1ManagerBase>
---@field TickableManagerList TArray<UB1ManagerBase>
local UB1System = {}

---@param NavData ANavigationData
function UB1System:OnLoadedNavigation(NavData) end
---@param InitType EBlueClientInitType
function UB1System:InitializeBlueClient(InitType) end
---@return UB1TimeManager
function UB1System:GetTimeManager() end
---@return UB1SaveLoadManager
function UB1System:GetSaveLoadManager() end
---@return UB1NetworkManager
function UB1System:GetNetworkManager() end
---@return FString
function UB1System:GetFullVersionString() end
---@return UB1System
function UB1System:Get() end


---@class UB1TalkInteractionCategoryTabEntry : UB1TalkInteractionListEntry
---@field BW_ScaleBox_Dev UB1ScaleBox
local UB1TalkInteractionCategoryTabEntry = {}



---@class UB1TalkInteractionListEntry : UB1UserListEntryWidgetBase
---@field BW_CategoryText UB1TextBlock
---@field BW_Image_DropDownableIcon UB1Image
---@field BW_Button UB1Button
---@field BW_SizeBox_Tag UB1SizeBox
---@field BW_Image_BG UB1Image
---@field BW_Image_Icon UB1Image
---@field BW_Text_Tag UB1TextBlock
---@field BW_WBP_FocusTag UB1UserWidget
---@field BW_SizeBox_LeftMarker UB1SizeBox
---@field BW_Image_LeftMarkerBG UB1Image
---@field BW_Image_LeftMarkerIcon UB1Image
---@field BW_Text_LeftMarker UB1TextBlock
---@field BW_Image_Karma UB1Image
---@field Data UB1ObjectSelectionData
local UB1TalkInteractionListEntry = {}



---@class UB1TalkInteractionPanel : UB1UserWidgetBase
---@field BW_ListView_Select UB1ListView
---@field BW_SizeBox_List UB1SizeBox
---@field BW_CanvasPanel UB1CanvasPanel
---@field Text_FamilyName UB1TextBlock
---@field Text_Category UB1TextBlock
---@field Button_Play UB1CommonButtonWidget
---@field BW_Button_ZoiProfile UB1Button
---@field BW_InteractionCanvas UB1CanvasPanel
---@field BW_WBP_Interaction_Button_Back UB1InteractionExitButton
---@field BW_Text_DEV UB1TextBlock
---@field BW_VerticalBox_Category UB1VerticalBox
---@field BW_ScrollBox_Category UB1ScrollBox
---@field BW_Image_ArrowUp UB1Image
---@field BW_Image_ArrowDown UB1Image
---@field SlotWidgetClass TSubclassOf<UUserWidget>
---@field CategoryInterval double
---@field BW_Panel_Random UWidget
---@field BW_WrapBox_Random_A UB1WrapBox
---@field BW_WrapBox_Random_C UB1WrapBox
---@field BW_Button_Refresh UB1InteractionExitButton
---@field BW_Button_Exit UB1InteractionExitButton
---@field EntryWidgetTalkClass TSubclassOf<UB1RandomTalkInteractionListEntryTalkWidget>
---@field EntryItems TArray<UB1ObjectSelectionData>
local UB1TalkInteractionPanel = {}

---@param InDataArray TArray<UB1ObjectSelectionData>
function UB1TalkInteractionPanel:SetupSubCategory(InDataArray) end
---@param InDataArray TArray<UB1ObjectSelectionData>
function UB1TalkInteractionPanel:SetupData(InDataArray) end
---@param InVisibility ESlateVisibility
function UB1TalkInteractionPanel:OnVisibilityChanged(InVisibility) end
function UB1TalkInteractionPanel:OnPlayButtonClicked() end
---@param InWidget UB1UserWidgetBase
function UB1TalkInteractionPanel:OnClickedButton(InWidget) end
---@param InScrollOffset float
function UB1TalkInteractionPanel:OnCategoryBoxScrolled(InScrollOffset) end
function UB1TalkInteractionPanel:CloseSubCategory() end


---@class UB1TalkInteractionSubSelectionEntry : UB1TalkInteractionListEntry
---@field BW_WBP_RelationshipIcon UB1RelationshipIconWidget
---@field BW_WBP_IconWithBG UB1RelationshipIconWidget
---@field BW_WidgetSwitcher_Focus UB1WidgetSwitcher
---@field BW_SizeBox_UpDown UB1SizeBox
---@field BW_WidgetSwitcher_UpDown UB1WidgetSwitcher
---@field BW_Overlay_Currency UB1Overlay
---@field BW_WBP_Currency UB1CurrencyWidget
local UB1TalkInteractionSubSelectionEntry = {}



---@class UB1TalkInteractionUIHandler : UB1UIHandlerBase
---@field SelectionObjectHolder TMap<FName, UB1ObjectSelectionData>
local UB1TalkInteractionUIHandler = {}

function UB1TalkInteractionUIHandler:OnPlayButtonClicekd() end
---@param Object UB1ObjectSelectionData
function UB1TalkInteractionUIHandler:OnListEntrySelected(Object) end


---@class UB1TalkSoundSubsystem : UWorldSubsystem
local UB1TalkSoundSubsystem = {}


---@class UB1TemporaryFileManager : UB1ManagerBase
local UB1TemporaryFileManager = {}


---@class UB1TimeControlAlertWidget : UB1UserWidgetBase
local UB1TimeControlAlertWidget = {}


---@class UB1TimeControllerWeatherEditWidget : UB1UserWidgetBase
---@field Image_WeatherEdit UB1Image
---@field B1Button_OpenWeatherEdit UB1Button
local UB1TimeControllerWeatherEditWidget = {}



---@class UB1TimeControllerWidget : UB1UserWidgetBase
---@field Setting FB1TimeControllerWidget_Setting
---@field BW_Button_Rollback UB1Button
---@field BW_Button_Pause UB1Button
---@field BW_Button_Speed1 UB1Button
---@field BW_Button_Speed2 UB1Button
---@field BW_Button_Speed3 UB1Button
---@field BW_Button_Speed4 UB1Button
---@field BW_Widget_ButtonBg UWidget
---@field BW_Slider_Value UB1Slider
---@field BW_ProgressBar_Value UB1ProgressBar
---@field BW_Text_TimeScale UTextBlock
local UB1TimeControllerWidget = {}

---@param InTimeScale float
function UB1TimeControllerWidget:TimeScaleSlider_OnValueChanged(InTimeScale) end
function UB1TimeControllerWidget:TimeScaleSlider_OnReleased() end


---@class UB1TimeDisplayWidget : UB1UserWidgetBase
---@field BW_Text_Day UTextBlock
---@field BW_Text_Date UTextBlock
---@field BW_Text_Time UTextBlock
---@field BW_Text_AmPm UTextBlock
local UB1TimeDisplayWidget = {}



---@class UB1TimeManager : UB1ManagerBase
---@field NightWindowMPC UMaterialParameterCollection
---@field TimeMPC UMaterialParameterCollection
local UB1TimeManager = {}

---@return float
function UB1TimeManager:GetTimeScale() end
---@return FDateTime
function UB1TimeManager:GetCurrentDateTime() end


---@class UB1TimeScaleComponent : UActorComponent
---@field bPlayInLevelSequence boolean
---@field OnTimeScaleChangedEvent FB1TimeScaleComponentOnTimeScaleChangedEvent
local UB1TimeScaleComponent = {}

---@param NewTimeScale float
function UB1TimeScaleComponent:OnTimeScaleChangedEvent__DelegateSignature(NewTimeScale) end
---@return float
function UB1TimeScaleComponent:GetTimeScale() end


---@class UB1TimelineComponent : UActorComponent
---@field OverrideTimelines TArray<FB1Timeline>
---@field BaseTimelines TArray<FB1Timeline>
---@field CurrentScheduleId FB1ScheduleId
local UB1TimelineComponent = {}



---@class UB1TimelineUIHandler : UB1UIHandlerBase
---@field ScheduleEditWidget UB1ScheduleEditWidget
---@field ScheduleControlBoxWidget UB1ScheduleControlBoxWidget
---@field HomeButtonWidget UB1HomeButtonWidget
---@field GoHomeAlertWidget UB1GoHomeAlertWidget
local UB1TimelineUIHandler = {}



---@class UB1TitleBarWidget : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field ExternalCloseButton UB1Button
local UB1TitleBarWidget = {}



---@class UB1ToastMessageUIHandler : UB1UIHandlerBase
---@field ToastWidget UB1ToastMessageWidget
local UB1ToastMessageUIHandler = {}



---@class UB1ToastMessageWidget : UB1UserWidgetBase
---@field BW_RichText_Message UB1RichTextBlock
local UB1ToastMessageWidget = {}



---@class UB1ToggleWireframeWidget : UB1UserWidgetBase
---@field WidgetSwitcher_Toggle UB1WidgetSwitcher
---@field Button_Wall0 UB1Button
---@field Button_Wall1 UB1Button
---@field Button_Wall2 UB1Button
local UB1ToggleWireframeWidget = {}



---@class UB1ToolTipWidget : UB1UserWidgetBase
---@field BW_Panel_Root UB1CanvasPanel
---@field BW_Panel_Tooltip UWidget
---@field BW_Panel_TooltipContent UB1CanvasPanel
---@field BW_Panel_CustomTooltipRoot UB1CanvasPanel
---@field BW_Widget_TailTop UWidget
---@field BW_Widget_TailBottom UWidget
---@field BW_Widget_TailLeft UWidget
---@field BW_Widget_TailRight UWidget
local UB1ToolTipWidget = {}



---@class UB1TooltipWidgetBase : UB1UserWidgetBase
---@field BW_Widget_TailTop UWidget
---@field BW_Widget_TailBottom UWidget
---@field BW_Widget_TailLeft UWidget
---@field BW_Widget_TailRight UWidget
---@field TooltipWidgetContentType EB1TooltipWidgetContentType
local UB1TooltipWidgetBase = {}



---@class UB1TopMenuWidget : UB1UserWidgetBase
---@field BW_Button_Wall UB1Button
---@field BW_Button_CameraMode UB1Button
---@field BW_Button_Filter UB1Button
---@field WidgetSwitcher_UpStairs UB1WidgetSwitcher
---@field BW_Button_UpStairs UB1Button
---@field BW_Button_UpStairsDimmed UB1Button
---@field WidgetSwitcher_DownStairs UB1WidgetSwitcher
---@field BW_Button_DownStairs UB1Button
---@field BW_Button_DownStairsDimmed UB1Button
---@field BW_Button_Bag UB1Button
---@field BW_Button_More UB1Button
---@field BW_Button_Realistic UB1Button
---@field BW_Button_Cartoon UB1Button
---@field BW_Button_TiltedShift UB1Button
---@field BW_Button_Screentone UB1Button
---@field BW_Button_Pixel UB1Button
---@field BW_Button_FishEye UB1Button
---@field BW_Button_Note UB1Button
---@field BW_Button_Posterize UB1Button
---@field BW_Button_Dust UB1Button
---@field Ani_FilterOpen UWidgetAnimation
---@field Ani_FilterClose UWidgetAnimation
---@field Ani_Button_A UWidgetAnimation
---@field Ani_Button_B UWidgetAnimation
---@field Ani_Button_C UWidgetAnimation
---@field Ani_Button_D UWidgetAnimation
---@field Ani_Button_E UWidgetAnimation
---@field Ani_Button_F UWidgetAnimation
---@field Ani_Button_G UWidgetAnimation
---@field Ani_Button_H UWidgetAnimation
---@field Ani_Button_I UWidgetAnimation
---@field WidgetSwitcher_WallButton UB1WidgetSwitcher
---@field BW_Button_Wall0 UB1Button
---@field BW_Button_Wall1 UB1Button
---@field BW_Button_Wall2 UB1Button
---@field BW_Button_FreeCamera UB1Button
---@field BW_Button_ViewMode UB1Button
---@field BW_Button_PhotoMode UB1Button
---@field BW_Button_FacialCapture UB1Button
---@field BW_Button_BodyTracking UB1Button
---@field Setting FB1TopMenuWidget_Setting
local UB1TopMenuWidget = {}



---@class UB1TrafficLightVisualizeManager : UB1ManagerBase
---@field TrafficLightActor AB1TrafficLightActor
local UB1TrafficLightVisualizeManager = {}



---@class UB1TraitComponent : UActorComponent
local UB1TraitComponent = {}


---@class UB1TraitDetailInfoFeatureListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_Text_Feautre UB1TextBlock
local UB1TraitDetailInfoFeatureListEntryWidget = {}



---@class UB1TraitDetailInfoWidgetBase : UB1UserWidgetBase
---@field BW_Button_Close UB1Button
---@field BW_Image_Trait UB1Image
---@field BW_Text_TraitCategory UB1TextBlock
---@field BW_Text_Trait UB1TextBlock
---@field BW_Text_Perspective UB1TextBlock
---@field BW_Text_Keyword UB1TextBlock
---@field BW_Text_Desc UB1TextBlock
---@field BW_ListView_Feature UB1ListView
local UB1TraitDetailInfoWidgetBase = {}



---@class UB1TraitSelectCategoryButtonWidget : UB1UserWidgetBase
---@field BW_Button UB1Button
---@field BW_Text_CategoryName UB1TextBlock
---@field BW_WBP_Trait_1 UB1TraitSelectCategoryTraitButtonWidget
---@field BW_WBP_Trait_2 UB1TraitSelectCategoryTraitButtonWidget
local UB1TraitSelectCategoryButtonWidget = {}



---@class UB1TraitSelectCategoryTraitButtonWidget : UB1UserWidgetBase
---@field BW_Button UB1Button
---@field BW_Text UB1TextBlock
local UB1TraitSelectCategoryTraitButtonWidget = {}



---@class UB1TraitSelectFloatingText : UB1UserWidgetBase
---@field ContentText UTextBlock
local UB1TraitSelectFloatingText = {}

---@param bInFilled boolean
function UB1TraitSelectFloatingText:SetFilled(bInFilled) end
---@param bInDimmed boolean
function UB1TraitSelectFloatingText:SetDimmed(bInDimmed) end


---@class UB1TraitSelectTraitDetailInfoWidget : UB1TraitDetailInfoWidgetBase
local UB1TraitSelectTraitDetailInfoWidget = {}


---@class UB1TraitSelectTraitDetailInfoWidgetFeatureListItem : UObject
local UB1TraitSelectTraitDetailInfoWidgetFeatureListItem = {}


---@class UB1TraitSelectTraitSimpleInfoKeywordWidget : UB1UserWidgetBase
---@field BW_Text_Keyword UB1TextBlock
local UB1TraitSelectTraitSimpleInfoKeywordWidget = {}



---@class UB1TraitSelectTraitSimpleInfoWidget : UB1UserWidgetBase
---@field BW_Image_Symbol UB1Image
---@field BW_Text_Type UB1TextBlock
---@field BW_Text_Trait UB1TextBlock
---@field BW_DynamicEntryBox_Keyword UB1DynamicEntryBox
---@field BW_Button_Close UB1Button
---@field BW_Button_Detail UB1Button
---@field BW_Button_TraitSelectDone UB1CommonButtonWidget
local UB1TraitSelectTraitSimpleInfoWidget = {}



---@class UB1TraitSelectUIHandler : UB1UIHandlerBase
local UB1TraitSelectUIHandler = {}


---@class UB1TraitSelectWidget : UB1UserWidgetBase
---@field TraitSelectionCategoryClass TSubclassOf<UUserWidget>
---@field TraitSelectFloatingTextClass TSubclassOf<UUserWidget>
---@field OnChangeSelect FB1TraitSelectWidgetOnChangeSelect
---@field MainCanvas UB1CanvasPanel
---@field SubCanvas UB1CanvasPanel
---@field DimmedPanel UB1CanvasPanel
---@field TraitSelectInfoList TMap<FName, FB1TraitSelectCategoryInfo>
local UB1TraitSelectWidget = {}

function UB1TraitSelectWidget:UpdateList() end
---@param InKey FName
function UB1TraitSelectWidget:OnButtonClick(InKey) end
---@return boolean
function UB1TraitSelectWidget:IsSelectFinish() end


---@class UB1TraitSelectWidget3 : UB1UserWidgetBase
---@field BW_Button_TraitSelectMode UB1Button
---@field BW_Button_CustomizeMode UB1Button
---@field BW_WidgetSwitcher_TraitButton UB1WidgetSwitcher
---@field BW_Text_TraitCategory UB1TextBlock
---@field BW_Text_Trait UB1TextBlock
---@field BW_Image_Trait UB1Image
---@field BW_DynamicEntryBox_Keyword UB1DynamicEntryBox
---@field BW_WBP_CategoryButton_1 UB1TraitSelectCategoryButtonWidget
---@field BW_WBP_CategoryButton_2 UB1TraitSelectCategoryButtonWidget
---@field BW_WBP_CategoryButton_3 UB1TraitSelectCategoryButtonWidget
---@field BW_WBP_CategoryButton_4 UB1TraitSelectCategoryButtonWidget
---@field BW_WBP_CategoryButton_5 UB1TraitSelectCategoryButtonWidget
---@field BW_WBP_CategoryButton_6 UB1TraitSelectCategoryButtonWidget
---@field BW_WBP_CategoryButton_7 UB1TraitSelectCategoryButtonWidget
---@field BW_WBP_CategoryButton_8 UB1TraitSelectCategoryButtonWidget
---@field BW_WBP_CategoryButton_9 UB1TraitSelectCategoryButtonWidget
---@field BW_WBP_TraitInfo UB1TraitSelectTraitSimpleInfoWidget
local UB1TraitSelectWidget3 = {}



---@class UB1TraitSelectionDimmedWidget : UB1UserWidgetBase
---@field WidthLeftKey FName
---@field WidthRightKey FName
---@field HeightTopKey FName
---@field HeightBottomKey FName
---@field SizeScale float
---@field Text_AgeGuide UB1TextBlock
local UB1TraitSelectionDimmedWidget = {}



---@class UB1TraitSelectionManager : UB1ManagerBase
local UB1TraitSelectionManager = {}


---@class UB1TraitTextEntry : UB1UserWidgetBase
---@field Text_TraitCategory UB1TextBlock
---@field Text_Trait UB1TextBlock
---@field Text_Trait_Desc UB1TextBlock
---@field Text_TraitAge UB1TextBlock
local UB1TraitTextEntry = {}



---@class UB1TraitWidget : UB1UserWidgetBase
---@field BW_Text_Trait UB1TextBlock
---@field BW_Text_TraitCategory UB1TextBlock
---@field BW_Image_Trait UB1Image
---@field BW_Button_Info UB1Button
local UB1TraitWidget = {}



---@class UB1TutorialDescriptionListEntry : UB1UserListEntryWidgetBase2
---@field BW_Image_Profile UB1Image
---@field BW_RichText_Message UB1RichTextBlock
---@field BW_WBP_Button UB1CommonButtonWidget
local UB1TutorialDescriptionListEntry = {}



---@class UB1TutorialDescriptionListItem : UObject
local UB1TutorialDescriptionListItem = {}


---@class UB1UIBlockWidget : UB1UserWidgetBase
local UB1UIBlockWidget = {}


---@class UB1UIHandlerBase : UObject
local UB1UIHandlerBase = {}


---@class UB1UIManager : UB1ManagerBase
---@field RootWidget UB1RootWidget
---@field CachedWindowMap TMap<EB1UIType, UB1UserWidgetBase>
---@field WidgetClassToUITypeMap TMap<UClass, EB1UIType>
---@field UIHandlerMap TMap<TSubclassOf<UB1UIHandlerBase>, UB1UIHandlerBase>
---@field CurrentHoveredWidgets TSet<UB1UserWidgetBase>
local UB1UIManager = {}



---@class UB1UserAccountManager : UB1ManagerBase
---@field ProfileName FString
---@field ProfileDesc FString
---@field ProfileFrameId int64
---@field ProfileURL FString
---@field ProfileFollowerCnt FString
---@field ProfileFollowingCnt FString
---@field ProfileItemUploadCnt FString
---@field ProfileItemDownloadCnt FString
---@field CommentAllow boolean
---@field Point int64
---@field CreatorLevel FString
---@field bIsVerifiedCreator boolean
local UB1UserAccountManager = {}



---@class UB1UserCustomizedDataManager : UB1ManagerBase
---@field UserCustomizedDataManager FB1UserCustomizedData
local UB1UserCustomizedDataManager = {}



---@class UB1UserListEntryWidgetBase : UB1UserWidgetBase
local UB1UserListEntryWidgetBase = {}


---@class UB1UserListEntryWidgetBase2 : UB1UserListEntryWidgetBase
local UB1UserListEntryWidgetBase2 = {}


---@class UB1UserWidgetBase : UB1CommonUserWidget
---@field WidgetCustomizationSetting FB1WidgetCustomizationSetting
---@field UIType EB1UIType
---@field WidgetAnimationSetting FB1WidgetAnimationSetting
---@field BindAnimations TMap<FName, UWidgetAnimation>
local UB1UserWidgetBase = {}



---@class UB1V2MAnimInstance : UAnimInstance
---@field bIsV2MPlaying boolean
local UB1V2MAnimInstance = {}



---@class UB1VariantListEntryWidget : UB1UserListEntryWidgetBase2
---@field BW_Button_ColorPreset UB1Button
---@field BW_Image_Preset UB1Image
---@field ItemData FB1VariantListItemData
local UB1VariantListEntryWidget = {}



---@class UB1VehicleColorPaletteWidget : UB1UserWidgetBase
---@field BW_Image_Color UB1Image
---@field BW_Button UB1Button
local UB1VehicleColorPaletteWidget = {}



---@class UB1VehicleColorPickerWidget : UB1UserWidgetBase
---@field Text_ColorName UB1TextBlock
---@field BW_HorizontalBox_Colors UB1HorizontalBox
---@field ColorPaletteWidgetClass TSubclassOf<UUserWidget>
---@field PaletteList TArray<UB1VehicleColorPaletteWidget>
---@field MappedColorName TArray<FName>
---@field SelectedColorId FName
local UB1VehicleColorPickerWidget = {}



---@class UB1VehicleDetailWidget : UB1UserWidgetBase
---@field BW_Image_Car UB1Image
---@field BW_Text_CarName UB1TextBlock
---@field BW_WidgetSwitcher_Content UB1WidgetSwitcher
---@field BW_Text_CarContent UB1TextBlock
---@field BW_WBP_CarColorPicker_Detail UB1VehicleColorPickerWidget
---@field BW_WBP_CarColorPicker_PartsModify UB1VehicleColorPickerWidget
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Button_Buy UB1CommonButtonWidget
---@field BW_TileView_Parts UB1TileView
---@field BW_Button_Back UB1Button
---@field SelectedVehicleDtId FName
local UB1VehicleDetailWidget = {}



---@class UB1VehicleEntryData : UObject
local UB1VehicleEntryData = {}


---@class UB1VehicleEntryData_DEPRECATED : UObject
local UB1VehicleEntryData_DEPRECATED = {}


---@class UB1VehicleEntryWidget_DEPRECATED : UB1UserListEntryWidgetBase
---@field DtId FName
---@field BW_Text_name UB1TextBlock
---@field BW_Text_Desc UB1TextBlock
---@field BW_Image UB1Image
---@field BW_Image_BG UB1Image
local UB1VehicleEntryWidget_DEPRECATED = {}



---@class UB1VehicleInteractionEntryData : UObject
local UB1VehicleInteractionEntryData = {}


---@class UB1VehicleInteractionEntryWidget : UB1UserListEntryWidgetBase
---@field BW_ContentText UB1TextBlock
local UB1VehicleInteractionEntryWidget = {}



---@class UB1VehicleInteractionUIHandler : UB1UIHandlerBase
local UB1VehicleInteractionUIHandler = {}


---@class UB1VehicleInteractionWidget : UB1UserWidgetBase
---@field BW_ListView UB1ListView
local UB1VehicleInteractionWidget = {}



---@class UB1VehicleListEntryWidget : UB1UserListEntryWidgetBase
---@field EntityID FB1EntityId
---@field DtId FName
---@field BW_Image_Car UB1Image
---@field BW_Image_Color UB1Image
---@field BW_Text_CarName UB1TextBlock
---@field BW_WBP_Currency UB1CurrencyWidget
---@field BW_Button_Common UB1CommonButtonWidget
---@field BW_HorizontalBox_Colors UB1HorizontalBox
---@field ColorPaletteWidgetClass TSubclassOf<UUserWidget>
local UB1VehicleListEntryWidget = {}



---@class UB1VehicleManagementTabButtonWidget : UB1UserWidgetBase
---@field CategoryType EB1VehicleManagementCategory
---@field BW_Image_Icon UB1Image
---@field BW_Text_BtnName UB1TextBlock
---@field BW_Button_Car UB1Button
local UB1VehicleManagementTabButtonWidget = {}



---@class UB1VehicleManagementUIHandler : UB1UIHandlerBase
---@field VehicleManagementWidget UB1VehicleManagementWidget
---@field CurrentCategory EB1VehicleManagementCategory
local UB1VehicleManagementUIHandler = {}



---@class UB1VehicleManagementWidget : UB1UserWidgetBase
---@field BW_Image_CarIcon UB1Image
---@field BW_Text_SubTitle UB1TextBlock
---@field BW_WidgetSwitcher_Content UB1WidgetSwitcher
---@field BW_TileView_CarSlot UB1TileView
---@field BW_WBP_CarButton_Buy UB1VehicleManagementTabButtonWidget
---@field BW_WBP_CarButton_Sell UB1VehicleManagementTabButtonWidget
---@field BW_WBP_CarButton_Setting UB1VehicleManagementTabButtonWidget
---@field BW_Button_Close UB1Button
---@field WBP_Mobile_Car_Detail UB1VehicleDetailWidget
---@field MainCategory EB1VehicleManagementCategory
---@field CategorySetting TMap<EB1VehicleManagementCategory, FB1VehicleManagementUICategoryData>
local UB1VehicleManagementWidget = {}



---@class UB1VehicleMovementComponent : UPawnMovementComponent
---@field MovementSetting FB1VehicleMovementSetting
local UB1VehicleMovementComponent = {}

---@param InLeftAxis USceneComponent
---@param InRightAxis USceneComponent
function UB1VehicleMovementComponent:SetAxisPivot(InLeftAxis, InRightAxis) end


---@class UB1VehicleNavigationDialogWidget : UB1UserWidgetBase
---@field BW_Button_Skip UB1CommonButtonWidget
---@field BW_Button_Cancel UB1CommonButtonWidget
---@field BW_ScaleBox_Loading UB1ScaleBox
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Menu UB1RichTextBlock
---@field VehicleId FB1EntityId
local UB1VehicleNavigationDialogWidget = {}



---@class UB1VehicleNavigationUIHandler : UB1UIHandlerBase
---@field NavigationDialogWidget UB1VehicleNavigationDialogWidget
local UB1VehicleNavigationUIHandler = {}



---@class UB1VehiclePartEntryData : UObject
local UB1VehiclePartEntryData = {}


---@class UB1VehiclePartListEntryWidget : UB1UserListEntryWidgetBase
---@field BW_Image_Selected UB1Image
---@field BW_CanvasPanel_SelectedNumber UB1CanvasPanel
---@field BW_Text_Num UB1TextBlock
---@field BW_Button_Select UB1Button
local UB1VehiclePartListEntryWidget = {}



---@class UB1VehiclePurchaseUIHandler : UB1UIHandlerBase
local UB1VehiclePurchaseUIHandler = {}


---@class UB1VehiclePurchaseWidget : UB1UserWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Button_Purchase UB1CommonButtonWidget
---@field BW_Button_Close UB1CommonButtonWidget
---@field BW_VehicleEntryList UB1TileView
local UB1VehiclePurchaseWidget = {}



---@class UB1VehicleRepresentationComponent : UActorComponent
---@field Vehicle AB1VehiclePawn
---@field BoundsRadius float
---@field PreviousDistance float
---@field HighResolutionRepresentationDistance float
---@field MediumResolutionRepresentationDistance float
---@field LowResolutionRepresentationDistance float
---@field RepresentationType EB1VehicleRepresentationType
local UB1VehicleRepresentationComponent = {}



---@class UB1VehicleRepresentationManager : UB1ManagerBase
---@field VehicleVisualizer AB1VehicleVisualizeActor
local UB1VehicleRepresentationManager = {}



---@class UB1VehicleStationManager : UB1ManagerBase
local UB1VehicleStationManager = {}


---@class UB1VehicleWheelComponent : UActorComponent
---@field WheelComponents TArray<USceneComponent>
---@field WheelOffsets TArray<FTransform>
---@field VehiclePawn AB1VehiclePawn
---@field WheelRadius float
---@field MaximumSteeringAngle float
---@field SteeringAngle float
---@field Pitch float
local UB1VehicleWheelComponent = {}



---@class UB1VideoPlayerUIHandler : UB1UIHandlerBase
local UB1VideoPlayerUIHandler = {}


---@class UB1VideoPlayerWidget : UB1UserWidgetBase
---@field BW_Image_Video UB1Image
---@field MediaPlayer UMediaPlayer
---@field MediaTexture UMediaTexture
---@field VideoMaterial UMaterialInterface
local UB1VideoPlayerWidget = {}



---@class UB1VisibilityManager : UB1ManagerBase
local UB1VisibilityManager = {}


---@class UB1VmcBlueprintFunctionLibrary : UBlueprintFunctionLibrary
local UB1VmcBlueprintFunctionLibrary = {}

---@param Seconds float
function UB1VmcBlueprintFunctionLibrary:RefreshConnection(Seconds) end


---@class UB1VmcOscManager : UObject
---@field StreamingSkeletalMeshTransformMap TMap<int32, UB1VmcStreamingSkeletalMeshTransform>
---@field OscReceivers TArray<UB1OscReceiver>
---@field ConnectedActor TArray<TWeakObjectPtr<UAnimInstance>>
---@field SpawnedActor AActor
---@field VrmBaseClassPath FSoftClassPath
---@field VRMRetargeterPath FSoftObjectPath
---@field VRMRetargeter UIKRetargeter
local UB1VmcOscManager = {}



---@class UB1VmcStreamingSkeletalMeshTransform : UObject
local UB1VmcStreamingSkeletalMeshTransform = {}

---@param address FName
---@param Data TArray<FB1OscElement>
---@param SenderIp FString
function UB1VmcStreamingSkeletalMeshTransform:OnReceived(address, Data, SenderIp) end


---@class UB1VmcVrmMapping : UObject
---@field VrmMapping FB1VmcVrmMappingData
local UB1VmcVrmMapping = {}



---@class UB1WallPresentComponent : USceneComponent
---@field BaseWallUnitWidth float
---@field BaseWallUnitHeight float
---@field WireBottomWallHeight float
---@field SelectedLineColor FLinearColor
---@field SelectedLineThickness float
---@field BrushSelectedLineColor FLinearColor
---@field BrushSelectedLineThickness float
---@field HoverSelectedLineColor FLinearColor
---@field HoverSelectedLineThickness float
---@field ShadowMeshMaterial TSoftObjectPtr<UMaterialInterface>
---@field MaxDrawDistance float
local UB1WallPresentComponent = {}



---@class UB1WeatherDisplayWidget : UB1UserWidgetBase
---@field Setting FB1WeatherDisplayWidget_Setting
---@field BW_Button_OpenWeatherEdit UB1Button
---@field WidgetSwitcher_Weather UB1WidgetSwitcher
---@field BW_Image_WeatherIconBg UB1Image
---@field BW_Image_WeatherIconCurrent UB1Image
---@field BW_Image_WeatherIconNext UB1Image
---@field BW_Text_Temperature UTextBlock
---@field BW_Text_TemperatureUnit UTextBlock
---@field BW_Text_Season UTextBlock
---@field WBP_TimeControllerWeatherEdit UB1TimeControllerWeatherEditWidget
local UB1WeatherDisplayWidget = {}



---@class UB1WeatherEditUIHandler : UB1UIHandlerBase
---@field WeatherEditWidget UB1WeatherEditWidget
local UB1WeatherEditUIHandler = {}

---@param InWeather FString
---@param InStep int32
function UB1WeatherEditUIHandler:OverrideWeather(InWeather, InStep) end


---@class UB1WeatherEditWidget : UB1UserWidgetBase
---@field Image_CurrentWeather UB1Image
---@field Text_CurrentTemperature UB1TextBlock
---@field Text_CurrentWeather UB1TextBlock
---@field Text_CurrentStep UB1TextBlock
---@field CanvasPanel_Step UB1CanvasPanel
---@field Text_Step UB1TextBlock
---@field Button_Step UB1Button
---@field Button_Reset UB1Button
---@field Button_Sun UB1Button
---@field VerticalBox_Sun UB1VerticalBox
---@field Image_Sun UB1Image
---@field Overlay_Sun UB1Overlay
---@field Button_Cloud UB1Button
---@field VerticalBox_Cloud UB1VerticalBox
---@field Image_Cloud UB1Image
---@field Overlay_Cloud UB1Overlay
---@field Button_Rain UB1Button
---@field VerticalBox_Rain UB1VerticalBox
---@field Image_Rain UB1Image
---@field Overlay_Rain UB1Overlay
---@field Button_Snow UB1Button
---@field VerticalBox_Snow UB1VerticalBox
---@field Image_Snow UB1Image
---@field Overlay_Snow UB1Overlay
---@field Anim_Open UWidgetAnimation
---@field Anim_Step UWidgetAnimation
local UB1WeatherEditWidget = {}



---@class UB1WeatherManager : UB1ManagerBase
---@field WeatherControlActor AB1UltraDynamicWeatherControl
---@field WeatherResourceData UB1WeatherResourceData
local UB1WeatherManager = {}



---@class UB1WeatherResourceData : UObject
---@field MaterialData TArray<FB1WeatherMaterialData>
local UB1WeatherResourceData = {}



---@class UB1WebGalleryFileManager : UB1MyGalleryManager
local UB1WebGalleryFileManager = {}


---@class UB1WebGalleryUIHandler : UB1UIHandlerBase
local UB1WebGalleryUIHandler = {}


---@class UB1WebSocketManager : UB1ManagerBase
---@field ServiceUrl FString
---@field WebUrl FString
local UB1WebSocketManager = {}



---@class UB1WhiteListDataAsset : UPrimaryDataAsset
---@field SkeletalMeshWhiteList TArray<FB1GarmentWhiteSkeletalMesh>
---@field StaticMeshWhiteList TArray<FB1GarmentWhiteStaticMesh>
---@field ObjectWhiteList TArray<FB1ObjectWhiteListData>
---@field AssetCategoryMap TMap<EB1AssetCategory, FAssetCategorySet>
---@field AssetSizeMap TMap<FString, uint64>
---@field DlcInfo FB1DlcInfoTableRow
---@field Version FString
---@field GameName FString
local UB1WhiteListDataAsset = {}



---@class UB1WhiteListDownloadManager : UB1ManagerBase
local UB1WhiteListDownloadManager = {}


---@class UB1WidgetCustomizationManager : UB1ManagerBase
local UB1WidgetCustomizationManager = {}


---@class UB1WindowBase : UB1UserWidgetBase
---@field Stack TArray<UUserWidget>
local UB1WindowBase = {}



---@class UB1WorldManager : UB1ManagerBase
---@field WorldSaveData FB1WorldSaveData
---@field WorldMeshReplaceMap TMap<FName, FB1WorldMesh>
---@field WorldMaterialTextureReplaceMap TMap<FName, FB1WorldMaterialTextureReplaceInfo>
---@field CurrentSelectionIdList TMap<FName, FB1MeshReplaceSelectionList>
---@field YoutubeSelect TMap<FName, FString>
---@field WorldYoutubeList TArray<FB1YoutubeInfo>
---@field OriginMaterialMap TMap<FName, FB1WorldMeshReplaceMaterialDataList>
---@field SignMaterialInterfaceMap TMap<int32, UMaterialInstanceDynamic>
---@field WorldDecorationSpawnCountValue TMap<FName, FB1WorldDecorationSpawnCountDataList>
---@field ProbSpawnCount TMap<FName, int32>
---@field ProbSpawnList TMap<FName, FB1ProbActorList>
---@field PendingProbSpawnList TMap<FName, FB1ProbSpawnInfoList>
---@field WorldProbSpawnSelectionList TMap<FName, FB1StabilitySelectionList>
---@field WorldPartsColorDataList TMap<FName, FB1PartsColorDataList>
---@field PartsMaterialInterfaceDynamicMap TMap<uint32, UMaterialInstanceDynamic>
---@field SignWebBrowser AB1WebBrowserActor
---@field WorldStabilitySelectionList TMap<FName, FB1StabilitySelectionList>
---@field YoutubeDetailList TMap<FString, FB1YoutubeDetailInfo>
---@field MeshChangeRequestList TMap<TSoftObjectPtr<UStaticMesh>, TSoftObjectPtr<UStaticMesh>>
---@field MeshColorChangeRequestList TMap<TSoftObjectPtr<UStaticMesh>, FB1WorldMeshColorChangeRequestList>
---@field WorldSeasonOverrideMeshMap TMap<TSoftObjectPtr<UStaticMesh>, FB1SeasonOverrideMeshInfo>
---@field WorldDataLayerRuntimeStateList TMap<FName, EDataLayerRuntimeState>
local UB1WorldManager = {}



---@class UB1WorldSubsystem : UWorldSubsystem
---@field PPBySituationMap TMap<FName, UMaterialInstanceDynamic>
local UB1WorldSubsystem = {}



---@class UB1ZoiInformationAllMode : UObject
local UB1ZoiInformationAllMode = {}


---@class UB1ZoiInformationIconSlotWidget : UB1UserWidgetBase
---@field BW_WidgetSwitcher_Icon UB1WidgetSwitcher
---@field BW_WidgetSwitcher_Default UB1WidgetSwitcher
---@field BW_Image_Age UB1Image
---@field BW_Image_JobIcon UB1Image
---@field BW_Image_TraitIcon UB1Image
---@field BW_Text_Desc UB1TextBlock
---@field BW_DynamicEntryBox_Preference UB1DynamicEntryBox
local UB1ZoiInformationIconSlotWidget = {}



---@class UB1ZoiInformationIntervalMode : UObject
local UB1ZoiInformationIntervalMode = {}


---@class UB1ZoiInformationRecordWidget : UB1UserWidgetBase
---@field BW_Text_Desc UB1TextBlock
local UB1ZoiInformationRecordWidget = {}



---@class UB1ZoiInformationUIHandler : UB1UIHandlerBase
---@field WidgetItemArray TArray<FB1ZoiInformationWidgetItem>
local UB1ZoiInformationUIHandler = {}



---@class UB1ZoiInformationWidget : UB1UserWidgetBase
---@field BW_Text_Title UB1TextBlock
---@field BW_Text_Sub UB1TextBlock
---@field BW_DynamicEntryBox_RelationshipGaugeEntry UB1DynamicEntryBox
---@field BW_DynamicEntryBox_Icon UB1DynamicEntryBox
---@field BW_WBP_RelationRecord UB1ZoiInformationRecordWidget
local UB1ZoiInformationWidget = {}



---@class UBlueTestControllerAutoTest : UBlueTestControllerBase
local UBlueTestControllerAutoTest = {}

function UBlueTestControllerAutoTest:OnWorldBeginPlay() end
function UBlueTestControllerAutoTest:OnSoakTimeChanged() end
function UBlueTestControllerAutoTest:OnSandboxTestSequenceFinished() end
function UBlueTestControllerAutoTest:OnSandboxIntroStarted() end
function UBlueTestControllerAutoTest:OnSandboxIntroFinished() end
---@param GameStateBase AGameStateBase
function UBlueTestControllerAutoTest:OnGameStateSet(GameStateBase) end


---@class UBlueTestControllerBase : UGauntletTestController
local UBlueTestControllerBase = {}

---@param World UWorld
function UBlueTestControllerBase:TryEarlyExec(World) end
function UBlueTestControllerBase:OnMemReportTimerExpired() end
function UBlueTestControllerBase:OnMemReportIntervalChanged() end


---@class UBlueTestControllerDataAutomation : UGauntletTestController
local UBlueTestControllerDataAutomation = {}


---@class UBlueTestControllerSmokeTest : UGauntletTestController
local UBlueTestControllerSmokeTest = {}


---@class UBlueToastMessageWidget : UB1UserWidgetBase
---@field Message UTextBlock
local UBlueToastMessageWidget = {}



---@class UDEPRECATED_B1ModdingDataManager : UB1ManagerBase
local UDEPRECATED_B1ModdingDataManager = {}


---@class UHoverDroneMovementComponent : USpectatorPawnMovement
---@field MaxAllowedSpeedIndex int32
---@field MaxAllowedSpeedUpdated FHoverDroneMovementComponentMaxAllowedSpeedUpdated
---@field DirectRotationInputYawScale float
---@field DirectRotationInputPitchScale float
---@field DirectRotationInputInterpSpeed float
---@field bUseFOVScaling boolean
---@field CameraFovRange FVector2D
---@field InputFovScaleRange FVector2D
---@field RotAcceleration float
---@field RotDeceleration float
---@field MaxPitchRotSpeed float
---@field MaxYawRotSpeed float
---@field FullAirFrictionVelocity float
---@field MovementAccelFactor FVector
---@field DroneSpeedParameters TArray<FDroneSpeedParameters>
---@field MinAirFriction float
---@field DroneSpeedParamIndex int32
---@field MinSpeedHeight float
---@field MaxSpeedHeight float
---@field MaxSpeedHeightMultiplier float
---@field MinPitch float
---@field MaxPitch float
---@field DroneMaxAltitude float
---@field MinHoverHeight float
---@field MaintainHoverHeightTolerance float
---@field MaintainHoverHeightPredictionTime float
---@field ForceFacingInterpInTime float
---@field bSimulateRotation boolean
---@field FollowedActorPositionInterpSpeed float
local UHoverDroneMovementComponent = {}

---@param NewFOV float
function UHoverDroneMovementComponent:SetCurrentFOV(NewFOV) end


---@class UHoverDroneVolumeManager : UGameInstanceSubsystem
---@field SpeedLimitBoxes TSet<AHoverDroneSpeedLimitBox>
---@field BlockingVolumes TSet<ABlockingVolume>
local UHoverDroneVolumeManager = {}



---@class ULocalServerManagerComponent : UB1ManagerComponentBase
local ULocalServerManagerComponent = {}


---@class UTickableGameInstanceSubsystem : UGameInstanceSubsystem
local UTickableGameInstanceSubsystem = {}


