---@meta

---@class FKeyDescription
---@field Keys TMap<FKey, UPaperSprite>
local FKeyDescription = {}



---@class IB1TooltipWidgetInterface : IInterface
local IB1TooltipWidgetInterface = {}


---@class IB1UserWidgetInterface : IInterface
local IB1UserWidgetInterface = {}


---@class UB1BackgroundBlur : UBackgroundBlur
local UB1BackgroundBlur = {}


---@class UB1BackgroundBlurSlot : UBackgroundBlurSlot
local UB1BackgroundBlurSlot = {}


---@class UB1Border : UBorder
local UB1Border = {}


---@class UB1BorderSlot : UBorderSlot
local UB1BorderSlot = {}


---@class UB1Button : UButton
---@field B1TooltipText FText
---@field TooltipPosition EB1TooltipPosition
---@field ClickEventPlayAudioId FName
---@field HoverEventPlayAudioId FName
local UB1Button = {}



---@class UB1ButtonSlot : UButtonSlot
local UB1ButtonSlot = {}


---@class UB1CanvasPanel : UCanvasPanel
local UB1CanvasPanel = {}


---@class UB1CanvasPanelSlot : UCanvasPanelSlot
local UB1CanvasPanelSlot = {}


---@class UB1CheckBox : UCheckBox
---@field ClickEventPlayAudioId FName
---@field HoverEventPlayAudioId FName
local UB1CheckBox = {}

---@param InGeometry FGeometry
---@param InEvent FPointerEvent
function UB1CheckBox:OnMouseEnter(InGeometry, InEvent) end
---@param bInChecked boolean
function UB1CheckBox:HandleOnCheckStateChanged(bInChecked) end


---@class UB1CircularThrobber : UCircularThrobber
local UB1CircularThrobber = {}


---@class UB1ComboBox : UComboBox
local UB1ComboBox = {}


---@class UB1ComboBoxKey : UComboBoxKey
---@field ContentWidgetClass TSubclassOf<UUserWidget>
---@field ItemWidgetClass TSubclassOf<UUserWidget>
---@field HoverAuiodId FName
---@field ClickAuiodId FName
local UB1ComboBoxKey = {}

---@param InName FName
---@param InSelectionType ESelectInfo::Type
function UB1ComboBoxKey:OnSelectionChangedHandler(InName, InSelectionType) end
function UB1ComboBoxKey:OnOpeningHandler() end
---@param InName FName
---@return UWidget
function UB1ComboBoxKey:OnGenerateItemWidgetHandler(InName) end
---@param InName FName
---@return UWidget
function UB1ComboBoxKey:OnGenerateContentWidgetHandler(InName) end


---@class UB1ComboBoxString : UComboBoxString
local UB1ComboBoxString = {}


---@class UB1DynamicEntryBox : UDynamicEntryBox
local UB1DynamicEntryBox = {}


---@class UB1EditableText : UEditableText
local UB1EditableText = {}


---@class UB1EditableTextBox : UEditableTextBox
local UB1EditableTextBox = {}


---@class UB1ExpandableArea : UExpandableArea
local UB1ExpandableArea = {}


---@class UB1GridPanel : UGridPanel
local UB1GridPanel = {}


---@class UB1GridSlot : UGridSlot
local UB1GridSlot = {}


---@class UB1HorizontalBox : UHorizontalBox
local UB1HorizontalBox = {}


---@class UB1HorizontalBoxSlot : UHorizontalBoxSlot
local UB1HorizontalBoxSlot = {}


---@class UB1Image : UImage
---@field bAutoImageSize boolean
---@field B1TooltipText FText
---@field TooltipPosition EB1TooltipPosition
---@field DownloadTask UAsyncTaskDownloadImage
local UB1Image = {}

---@param InColor FSlateColor
function UB1Image:SetBrushOutlineColor(InColor) end
---@param InSoftResourceObject TSoftObjectPtr<UObject>
---@param bInMatchSize boolean
function UB1Image:SetBrushFromSoftResourceObject(InSoftResourceObject, bInMatchSize) end
---@param InTexture UTexture2DDynamic
function UB1Image:DownloadTask_OnSuccess(InTexture) end
---@param InTexture UTexture2DDynamic
function UB1Image:DownloadTask_OnFail(InTexture) end
function UB1Image:ClearTexture() end


---@class UB1InputKeySelector : UInputKeySelector
local UB1InputKeySelector = {}


---@class UB1InvalidationBox : UInvalidationBox
local UB1InvalidationBox = {}


---@class UB1KeyImage : UImage
---@field bUpdateKeyCultureChanged boolean
---@field ImageSize FVector2D
---@field CurrentKey FKey
local UB1KeyImage = {}



---@class UB1Line : UWidget
---@field LineType EB1LineType
local UB1Line = {}



---@class UB1ListView : UListView
---@field ClickEventPlayAudioId FName
---@field HoverEventPlayAudioId FName
local UB1ListView = {}



---@class UB1MenuAnchor : UMenuAnchor
local UB1MenuAnchor = {}


---@class UB1MultiLineEditableText : UMultiLineEditableText
local UB1MultiLineEditableText = {}


---@class UB1MultiLineEditableTextBox : UMultiLineEditableTextBox
local UB1MultiLineEditableTextBox = {}


---@class UB1NStyleButton : UB1Button
---@field Styles TMap<FName, FButtonStyle>
local UB1NStyleButton = {}

---@param InName FName
function UB1NStyleButton:SetNStyle(InName) end


---@class UB1NamedSlot : UNamedSlot
local UB1NamedSlot = {}


---@class UB1NativeWidgetHost : UNativeWidgetHost
local UB1NativeWidgetHost = {}


---@class UB1Overlay : UOverlay
local UB1Overlay = {}


---@class UB1OverlaySlot : UOverlaySlot
local UB1OverlaySlot = {}


---@class UB1PanelSlot : UPanelSlot
local UB1PanelSlot = {}


---@class UB1ProgressBar : UProgressBar
local UB1ProgressBar = {}


---@class UB1RetainerBox : URetainerBox
local UB1RetainerBox = {}


---@class UB1RichTextBlock : URichTextBlock
local UB1RichTextBlock = {}


---@class UB1SafeZone : USafeZone
local UB1SafeZone = {}


---@class UB1SafeZoneSlot : USafeZoneSlot
local UB1SafeZoneSlot = {}


---@class UB1ScaleBox : UScaleBox
local UB1ScaleBox = {}


---@class UB1ScaleBoxSlot : UScaleBoxSlot
local UB1ScaleBoxSlot = {}


---@class UB1ScrollBox : UScrollBox
local UB1ScrollBox = {}


---@class UB1ScrollBoxSlot : UScrollBoxSlot
local UB1ScrollBoxSlot = {}


---@class UB1SizeBox : USizeBox
local UB1SizeBox = {}


---@class UB1SizeBoxSlot : USizeBoxSlot
local UB1SizeBoxSlot = {}


---@class UB1Slider : USlider
---@field MouseCaptureBeginPlayAudioId FName
---@field ValueChangedPlayAudioId FName
local UB1Slider = {}



---@class UB1Spacer : USpacer
local UB1Spacer = {}


---@class UB1SpinBox : USpinBox
local UB1SpinBox = {}


---@class UB1StackBox : UStackBox
local UB1StackBox = {}


---@class UB1StackBoxSlot : UStackBoxSlot
local UB1StackBoxSlot = {}


---@class UB1TextBlock : UTextBlock
---@field B1TooltipText FText
---@field TooltipPosition EB1TooltipPosition
local UB1TextBlock = {}



---@class UB1Throbber : UThrobber
local UB1Throbber = {}


---@class UB1TileView : UTileView
---@field ClickEventPlayAudioId FName
---@field HoverEventPlayAudioId FName
local UB1TileView = {}



---@class UB1TreeView : UTreeView
---@field ClickEventPlayAudioId FName
---@field HoverEventPlayAudioId FName
local UB1TreeView = {}



---@class UB1UniformGridPanel : UUniformGridPanel
local UB1UniformGridPanel = {}


---@class UB1UniformGridSlot : UUniformGridSlot
local UB1UniformGridSlot = {}


---@class UB1UserWidget : UUserWidget
local UB1UserWidget = {}


---@class UB1VerticalBox : UVerticalBox
local UB1VerticalBox = {}


---@class UB1VerticalBoxSlot : UVerticalBoxSlot
local UB1VerticalBoxSlot = {}


---@class UB1WidgetSwitcher : UWidgetSwitcher
local UB1WidgetSwitcher = {}


---@class UB1WidgetSwitcherSlot : UWidgetSwitcherSlot
local UB1WidgetSwitcherSlot = {}


---@class UB1WindowTitleBarArea : UWindowTitleBarArea
local UB1WindowTitleBarArea = {}


---@class UB1WindowTitleBarAreaSlot : UWindowTitleBarAreaSlot
local UB1WindowTitleBarAreaSlot = {}


---@class UB1WrapBox : UWrapBox
local UB1WrapBox = {}


---@class UB1WrapBoxSlot : UWrapBoxSlot
local UB1WrapBoxSlot = {}


---@class UBlueUMGSettings : UDeveloperSettings
---@field Description TMap<FName, FKeyDescription>
local UBlueUMGSettings = {}



