---@meta

---@class FB1AccessoryAiTextureInfo
---@field AccessoryTextureInfos TMap<FName, FString>
local FB1AccessoryAiTextureInfo = {}



---@class FB1AccessoryDescription
---@field AccessoryType FName
---@field AccessoryId FName
---@field AccessoryMeshId FName
---@field SocketNames TArray<FName>
---@field SocketOffsetTable TMap<FName, FVector>
---@field ScalarParameters TMap<int32, FB1AccessoryScalarParamterInfo>
---@field VectorParameters TMap<FName, FLinearColor>
---@field AiTextureParameters TMap<int32, FB1AccessoryAiTextureInfo>
local FB1AccessoryDescription = {}



---@class FB1AccessoryDescriptionMap
---@field AccessoryDescriptions TMap<FName, FB1AccessoryDescription>
local FB1AccessoryDescriptionMap = {}



---@class FB1AccessoryMaterialSectionGroup
---@field ListKey FString
---@field MaterialSection int32
---@field MaterialType EB1AccessoryMaterialType
---@field NumColorChannels int32
---@field ChannelDatas TArray<FB1AttachedAccessoryChannelData>
local FB1AccessoryMaterialSectionGroup = {}



---@class FB1AccessoryScalarParamterInfo
---@field AccessoryScalarParameterInfos TMap<FName, float>
local FB1AccessoryScalarParamterInfo = {}



---@class FB1ActionInfo
---@field Conditions TArray<FB1Condition>
---@field duration float
---@field IsForceCancelable boolean
---@field IsWaitFinishAction boolean
---@field FinishPrev boolean
---@field BaseObject EB1BaseObject
---@field Command EB1ActionType
---@field S1 FName
---@field S2 FName
---@field F1 float
---@field F2 float
---@field StartScriptIdList TArray<FName>
---@field TickScriptIdList TArray<FName>
---@field TickInterval float
---@field FinishScriptIdList TArray<FName>
---@field CancelScriptIdList TArray<FName>
---@field NotifyScriptIds TArray<FName>
---@field ConsumeCurrencyId FName
---@field ConsumeCurrencyValue int64
local FB1ActionInfo = {}



---@class FB1ActionTableRow : FB1TableRowBase
---@field ID FName
---@field Actions TArray<FB1ActionInfo>
---@field ActionTags TArray<FName>
local FB1ActionTableRow = {}



---@class FB1ActionTimeData
---@field StartTime int64
---@field FinishTime int64
local FB1ActionTimeData = {}



---@class FB1AddDesireInteraction
---@field InteractionBagId FName
---@field AddDesire int32
local FB1AddDesireInteraction = {}



---@class FB1AddOnScreenDebugMessageParam
---@field Key uint64
---@field TimeToDisplay float
---@field DisplayColor FColor
---@field DebugMessage FString
---@field bNewerOnTop boolean
---@field TextScale FVector2D
local FB1AddOnScreenDebugMessageParam = {}



---@class FB1AddRelationshipContext
---@field InteractorId FB1EntityId
---@field InteracteeId FB1EntityId
---@field InteractorPrevData FB1RelationshipData
---@field InteracteePrevData FB1RelationshipData
local FB1AddRelationshipContext = {}



---@class FB1AdditiveBoneData
---@field BoneName FName
---@field Transform FTransform
---@field Depth int32
local FB1AdditiveBoneData = {}



---@class FB1AdmitDesireBoostData
---@field From float
---@field To float
---@field Tendency EB1EmotionTendency
---@field Level int32
local FB1AdmitDesireBoostData = {}



---@class FB1AdmitDesireBuffLevelData
---@field Level int32
---@field BuffId FName
local FB1AdmitDesireBuffLevelData = {}



---@class FB1AgeAffectInfo
---@field GrowthStep EB1GrowthStep
---@field MiscParam1 int32
---@field MiscParam2 int32
local FB1AgeAffectInfo = {}



---@class FB1AgeAffectRangeTableRow : FB1TableRowBase
---@field ID FName
---@field AffectInfos TArray<FB1AgeAffectInfo>
local FB1AgeAffectRangeTableRow = {}



---@class FB1AgingTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayTextId FString
---@field DescTextId FString
---@field TimeToNextAge int32
---@field StatMax float
---@field StatMin float
---@field NPCStatMin float
---@field ContentAvailableSlot TMap<FString, int32>
---@field AppearancePreset TMap<EB1GenderType, FName>
---@field StandardWeight TMap<EB1GenderType, float>
---@field TaxPerPerson int32
local FB1AgingTableRow = {}



---@class FB1AlertMessageTableRow : FB1TableRowBase
---@field ID FName
---@field Title FString
---@field Desc FString
local FB1AlertMessageTableRow = {}



---@class FB1AmbitionConditionTableRow : FB1TableRowBase
---@field Conditions TArray<FB1Condition>
local FB1AmbitionConditionTableRow = {}



---@class FB1AmbitionItemTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayTextId FString
---@field DescTextId FString
---@field ConditionId FName
---@field AgeAvailable TArray<EB1GrowthStep>
---@field ChangeByGrowthStep TArray<FB1GrowthChangeData>
---@field AmbitionSteps TArray<FB1AmbitionStepDefine>
local FB1AmbitionItemTableRow = {}



---@class FB1AmbitionState
---@field CurrentStep int32
---@field StepMissionIds TArray<FB1MissionId>
local FB1AmbitionState = {}



---@class FB1AmbitionStepDefine
---@field Step int32
---@field StepCompleteScriptId FName
---@field StepMissions TArray<FB1AmbitionStepMissionDefine>
local FB1AmbitionStepDefine = {}



---@class FB1AmbitionStepMissionDefine
---@field MissionId FName
---@field MissionCompleteScriptId FName
local FB1AmbitionStepMissionDefine = {}



---@class FB1AmbitionTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayTextId FString
---@field DescTextId FString
---@field MottoTextId FString
---@field JoyCardPopupTextId FString
---@field CompletePopupTextId FString
---@field Icon TSoftObjectPtr<UTexture2D>
---@field BG TSoftObjectPtr<UTexture2D>
---@field ColorId FName
---@field CompleteLinkTraitId FName
---@field AmbitionItemIds TArray<FName>
local FB1AmbitionTableRow = {}



---@class FB1AnimNotifyEvent
local FB1AnimNotifyEvent = {}


---@class FB1AnimNotifyEventData_Base
---@field Type EB1NotyfyType
---@field TriggerTime float
---@field duration float
local FB1AnimNotifyEventData_Base = {}



---@class FB1AnimNotifyEventData_ChangeState : FB1AnimNotifyEventData_Base
---@field Target EB1BaseObject
---@field ChangedStateGroupName FName
---@field ChangeStateName FName
local FB1AnimNotifyEventData_ChangeState = {}



---@class FB1AnimNotifyEventData_EnterVehicle : FB1AnimNotifyEventData_Base
---@field VehicleSeat FName
local FB1AnimNotifyEventData_EnterVehicle = {}



---@class FB1AnimNotifyEventData_ExitVehicle : FB1AnimNotifyEventData_Base
---@field VehicleSeat FName
local FB1AnimNotifyEventData_ExitVehicle = {}



---@class FB1AnimNotifyEventData_LadderRightStep : FB1AnimNotifyEventData_Base
local FB1AnimNotifyEventData_LadderRightStep = {}


---@class FB1AnimNotifyEventData_LoopEnd : FB1AnimNotifyEventData_Base
local FB1AnimNotifyEventData_LoopEnd = {}


---@class FB1AnimNotifyEventData_PlayAnim : FB1AnimNotifyEventData_Base
---@field BeginAnimInfo FB1PlayAnimInfo
---@field EndAnimInfo FB1PlayAnimInfo
local FB1AnimNotifyEventData_PlayAnim = {}



---@class FB1AnimNotifyEventData_PlayStaticMeshAnim : FB1AnimNotifyEventData_Base
---@field Info FB1PlayStaticAnimInfo
local FB1AnimNotifyEventData_PlayStaticMeshAnim = {}



---@class FB1AnimNotifyEventData_RunScript : FB1AnimNotifyEventData_Base
local FB1AnimNotifyEventData_RunScript = {}


---@class FB1AnimNotifyEventData_XXX : FB1AnimNotifyEventData_Base
local FB1AnimNotifyEventData_XXX = {}


---@class FB1AnimReferenceInfo
---@field AnimReferenceName FString
---@field bEnableRootMotion boolean
---@field bForceRootLock boolean
---@field ModifiersNum int32
local FB1AnimReferenceInfo = {}



---@class FB1AnimSection
---@field Name FName
---@field NextSectionName FName
---@field Time float
---@field IsLoop boolean
local FB1AnimSection = {}



---@class FB1AnimSequenceInfo
---@field Gender EB1GenderType
---@field BodyAge EB1BodyAgeType
---@field Animation TSoftObjectPtr<UAnimSequence>
local FB1AnimSequenceInfo = {}



---@class FB1AnimTrack
---@field SlotName FName
---@field AnimSegments TArray<FB1AnimReferenceInfo>
local FB1AnimTrack = {}



---@class FB1AnimationInfo
---@field Gender EB1GenderType
---@field AnimGrowthStep EB1AnimGrowthStep
---@field Animation TSoftObjectPtr<UAnimMontage>
---@field TotalPlayLength float
---@field LoopPlayLength float
---@field RateScale float
---@field RandomLoopAnims TArray<FB1RandomAnimationInfo>
local FB1AnimationInfo = {}



---@class FB1AppearanceBeardTableRow : FB1AppearanceFacehairMeshTableRow
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1AppearanceBeardTableRow = {}



---@class FB1AppearanceBodyShapeTableRow : FB1TableRowBase
---@field ID FName
---@field Thumbnail TSoftObjectPtr<UTexture2D>
---@field DescTextId FString
---@field HiddenFromUI boolean
---@field MuscleDefinition float
---@field BodyMassRatio float
---@field BodyModifierParameters FString
---@field GenderType EB1GenderType
---@field BodyAgeType EB1BodyAgeType
---@field ChestHairIntensity float
---@field ArmHairIntensity float
---@field LegHairIntensity float
---@field BodyHairColor FString
local FB1AppearanceBodyShapeTableRow = {}



---@class FB1AppearanceEyebrowTableRow : FB1AppearanceFacehairMeshTableRow
---@field MaskTexture TSoftObjectPtr<UTexture>
---@field TextureParameterName FName
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1AppearanceEyebrowTableRow = {}



---@class FB1AppearanceEyelashTableRow : FB1AppearanceFacehairMeshTableRow
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1AppearanceEyelashTableRow = {}



---@class FB1AppearanceFacePresetTableRow : FB1AppearanceTableRow
---@field HiddenFromUI boolean
---@field Tags TArray<FName>
local FB1AppearanceFacePresetTableRow = {}



---@class FB1AppearanceFacehairMeshTableRow : FB1AppearanceMeshTableRow
---@field bHiddenFromUI boolean
---@field PartsId FName
local FB1AppearanceFacehairMeshTableRow = {}



---@class FB1AppearanceFrecklesTableRow : FB1AppearanceSkinFeaturesTableRow
local FB1AppearanceFrecklesTableRow = {}


---@class FB1AppearanceGroupedMeshTableRow : FB1AppearanceMeshTableRow
---@field GroupId FName
local FB1AppearanceGroupedMeshTableRow = {}



---@class FB1AppearanceHairMeshTableRow : FB1AppearanceGroupedMeshTableRow
---@field OverrideMaterials TArray<TSoftObjectPtr<UMaterialInterface>>
---@field HatTypeMesh TMap<EB1HatType, TSoftObjectPtr<USkeletalMesh>>
---@field bEnableHairCutHeight boolean
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1AppearanceHairMeshTableRow = {}



---@class FB1AppearanceHairTableRow : FB1AppearanceTableRow
---@field PartsId FName
---@field HairType EB1HairType
---@field HiddenFromUI boolean
---@field Tags TArray<FName>
---@field Variants TArray<FName>
---@field SocketOffsetTable TMap<FName, FString>
local FB1AppearanceHairTableRow = {}



---@class FB1AppearanceHeadTableRow : FB1AppearanceMeshTableRow
---@field FaceSkinColorId FName
---@field EyebrowId FName
---@field EyelashId FName
---@field DefaultHairId FName
---@field SocketOffsetTable TMap<FName, FString>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
---@field HiddenFromUI boolean
local FB1AppearanceHeadTableRow = {}



---@class FB1AppearanceIrisPresetTableRow : FB1TableRowBase
---@field ID FName
---@field Thumbnail TSoftObjectPtr<UTexture2D>
---@field DescTextId FString
---@field PartsId FName
---@field IrisMasks TSoftObjectPtr<UMaterialInterface>
local FB1AppearanceIrisPresetTableRow = {}



---@class FB1AppearanceMakeupParameterValue
---@field MaskChannel EB1MakeupChannel
---@field ColorValues TArray<FString>
---@field ScalarValues TArray<float>
local FB1AppearanceMakeupParameterValue = {}



---@class FB1AppearanceMakeupPartsTableRow : FB1TableRowBase
---@field ID FName
---@field DescTextId FString
---@field Thumbnail TSoftObjectPtr<UTexture2D>
---@field TextureParameterName FName
---@field AppearanceParts EB1AppearanceParts
---@field DataTableName FName
---@field ChannelData TArray<FB1MakeupChannelInfo>
local FB1AppearanceMakeupPartsTableRow = {}



---@class FB1AppearanceMakeupTableRow : FB1TableRowBase
---@field ID FName
---@field DescTextId FString
---@field Thumbnail TSoftObjectPtr<UTexture2D>
---@field DisabledChannels TArray<EB1MakeupChannel>
---@field MakeupPartsId FName
---@field MaskTexture TSoftObjectPtr<UTexture>
---@field MatchingFaceHairId FName
---@field DefaultValues TArray<FB1AppearanceMakeupParameterValue>
---@field SubCategories TArray<FName>
local FB1AppearanceMakeupTableRow = {}



---@class FB1AppearanceMeshTableRow : FB1AppearanceTableRow
---@field Mesh TSoftObjectPtr<USkeletalMesh>
local FB1AppearanceMeshTableRow = {}



---@class FB1AppearanceMoleTableRow : FB1AppearanceSkinFeaturesTableRow
---@field DefaultMoleColor FString
local FB1AppearanceMoleTableRow = {}



---@class FB1AppearanceMustacheTableRow : FB1AppearanceFacehairMeshTableRow
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1AppearanceMustacheTableRow = {}



---@class FB1AppearanceOutfitPresetTableRow : FB1TableRowBase
---@field ID FName
---@field GenderType EB1GenderType
---@field Age int32
---@field FullId FName
---@field TopId FName
---@field BottomId FName
---@field JacketId FName
---@field SocksId FName
---@field ShoesId FName
---@field HatId FName
---@field InnerUnderId FName
---@field InnerTopId FName
---@field Accessories TMap<FName, FName>
---@field AgingConditionFlags int32
---@field CityTags TArray<EB1DiversityCity>
---@field bFilterCrowdRandomPick boolean
---@field OutfitCategoryTags TArray<EB1OutfitCategory>
local FB1AppearanceOutfitPresetTableRow = {}



---@class FB1AppearanceOutfitPresetValidiationKey
local FB1AppearanceOutfitPresetValidiationKey = {}


---@class FB1AppearancePartsColorParameterInfo
---@field ListKey FString
---@field ParameterName FName
---@field ParameterDescTextId FString
---@field MaterialSectionIndices TArray<int32>
local FB1AppearancePartsColorParameterInfo = {}



---@class FB1AppearancePartsInfo
---@field ListKey FString
---@field PartsName FName
---@field PartsDescTextId FString
---@field ColorParameter FB1AppearancePartsColorParameterInfo
---@field ScalarParameters TArray<FB1AppearancePartsScalarParameterInfo>
local FB1AppearancePartsInfo = {}



---@class FB1AppearancePartsScalarParameterInfo
---@field ListKey FString
---@field ParameterName FName
---@field ParameterDescTextId FString
---@field DefaultValue float
---@field MinValue float
---@field MaxValue float
---@field MaterialSectionIndices TArray<int32>
local FB1AppearancePartsScalarParameterInfo = {}



---@class FB1AppearancePartsTableRow : FB1TableRowBase
---@field ID FName
---@field PartsInfos TArray<FB1AppearancePartsInfo>
local FB1AppearancePartsTableRow = {}



---@class FB1AppearancePresetTableRow : FB1TableRowBase
---@field ID FName
---@field SubCategories TArray<FName>
---@field GenderType EB1GenderType
---@field Age int32
---@field BodySkinColorId FName
---@field BodyShapeId FName
---@field HeadId FName
---@field EyebrowId FName
---@field EyebrowColor FString
---@field EyelashId FName
---@field EyelashColor FString
---@field MustacheId FName
---@field BeardId FName
---@field FaceHairColor FString
---@field HairId FName
---@field HairColor FString
---@field FullId FName
---@field TopId FName
---@field BottomId FName
---@field JacketId FName
---@field SocksId FName
---@field ShoesId FName
---@field HatId FName
---@field InnerUnderId FName
---@field InnerTopId FName
---@field Accessories TMap<FName, FName>
---@field Tags TArray<FName>
---@field AgingConditionFlags int32
---@field RaceTags TArray<EB1DiversityRace>
---@field Thumbnail TSoftObjectPtr<UTexture2D>
---@field HiddenFromUI boolean
---@field bFilterCrowdRandomPick boolean
---@field OutfitCategoryTags TArray<EB1OutfitCategory>
local FB1AppearancePresetTableRow = {}



---@class FB1AppearanceScarTableRow : FB1AppearanceSkinFeaturesTableRow
---@field ColorTexture TSoftObjectPtr<UTexture>
---@field DefaultScarRoughness float
---@field DefaultScarMetalRoughness float
---@field IsTopmostScar float
---@field GenderType EB1GenderType
---@field BodyAgeType EB1BodyAgeType
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1AppearanceScarTableRow = {}



---@class FB1AppearanceSetting
---@field Gender EB1GenderType
---@field Head FB1HeadDescription
---@field Body FB1BodyDescription
---@field Outfit FB1CharacterOutfit
---@field AuthorName FString
---@field AppearanceAge int32
---@field GrowthStep EB1GrowthStep
---@field BodyAgeType EB1BodyAgeType
---@field GrowthRatio float
local FB1AppearanceSetting = {}



---@class FB1AppearanceSkinColorTableRow : FB1TableRowBase
---@field ID FName
---@field DescTextId FString
---@field PalleteColor FString
---@field SkinTone FString
local FB1AppearanceSkinColorTableRow = {}



---@class FB1AppearanceSkinFeaturesTableRow : FB1TableRowBase
---@field ID FName
---@field DescTextId FString
---@field Thumbnail TSoftObjectPtr<UTexture2D>
---@field MaskTexture TSoftObjectPtr<UTexture>
---@field PartsNum int32
---@field HiddenFromUI boolean
local FB1AppearanceSkinFeaturesTableRow = {}



---@class FB1AppearanceSkinTableRow : FB1AppearanceTableRow
---@field HeadOverrideMaterial TArray<TSoftObjectPtr<UMaterialInterface>>
---@field BodyOverrideMaterial TSoftObjectPtr<UMaterialInterface>
---@field DefaultSkinColorId FName
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
---@field HiddenFromUI boolean
---@field ShowColorChangeButton boolean
local FB1AppearanceSkinTableRow = {}



---@class FB1AppearanceTableRow : FB1TableRowBase
---@field ID FName
---@field Thumbnail TSoftObjectPtr<UTexture2D>
---@field DescTextId FString
---@field GenderType EB1GenderType
---@field BodyAgeType EB1BodyAgeType
---@field SubCategories TArray<FName>
local FB1AppearanceTableRow = {}



---@class FB1AppearanceTattooTableRow : FB1AppearanceSkinFeaturesTableRow
---@field DefaultTattooColor1 FString
---@field DefaultTattooColor2 FString
---@field DefaultTattooColor3 FString
---@field DefaultTattooColor4 FString
---@field GenderType EB1GenderType
---@field BodyAgeType EB1BodyAgeType
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1AppearanceTattooTableRow = {}



---@class FB1AsyncLoadAnimInfo
---@field EntityID FB1EntityId
---@field OwnerEntityId FB1EntityId
---@field AnimId FName
local FB1AsyncLoadAnimInfo = {}



---@class FB1AsyncLoadId
---@field Value int64
local FB1AsyncLoadId = {}



---@class FB1AttachMeshInfo
---@field Gender EB1GenderType
---@field AnimGrowthStep EB1AnimGrowthStep
---@field SkeletalMeshAsset TSoftObjectPtr<USkeletalMesh>
local FB1AttachMeshInfo = {}



---@class FB1AttachMeshTableRow : FB1TableRowBase
---@field ID FName
---@field GroupId FName
---@field MeshList TArray<FB1AttachMeshInfo>
local FB1AttachMeshTableRow = {}



---@class FB1AttachedAccessoryChannelData
---@field ListKey FString
---@field AITexture boolean
---@field DescTextId FString
local FB1AttachedAccessoryChannelData = {}



---@class FB1AttachedAccessoryMeshTableRow : FB1AppearanceTableRow
---@field AccessoryType FName
---@field OverrideMaterial TArray<TSoftObjectPtr<UMaterialInterface>>
---@field SocketByMesh TMap<FName, TSoftObjectPtr<UStaticMesh>>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1AttachedAccessoryMeshTableRow = {}



---@class FB1AttachedAccessoryTableRow : FB1AppearanceTableRow
---@field AccessoryType FName
---@field HiddenFromUI boolean
---@field Variants TArray<FName>
---@field MaterialSectionGroups TArray<FB1AccessoryMaterialSectionGroup>
---@field OutfitCategoryTags TArray<EB1OutfitCategory>
---@field OutfitBuffList TArray<FName>
local FB1AttachedAccessoryTableRow = {}



---@class FB1AudioResourcesTableRow : FB1TableRowBase
---@field ID FName
---@field MetaSoundResource TSoftObjectPtr<UMetaSoundSource>
local FB1AudioResourcesTableRow = {}



---@class FB1AutoFindTargetInfo
---@field AutoFindTargetType EB1AutoFindTargetType
---@field AutoFindId FName
---@field ExcuteInteractionId FName
local FB1AutoFindTargetInfo = {}



---@class FB1AutoOpenDesireWidgetData
---@field CheckDesireIdList TArray<FName>
---@field OpenTriggerCount int32
local FB1AutoOpenDesireWidgetData = {}



---@class FB1AvailableInteractionBagData
local FB1AvailableInteractionBagData = {}


---@class FB1BGMAudioTableRow : FB1TableRowBase
---@field ID FName
---@field GroupId FName
---@field MetaSoundResource UMetaSoundSource
---@field CanSavePlayTime boolean
local FB1BGMAudioTableRow = {}



---@class FB1BGMTransitionData
---@field CurveFadeIn UCurveFloat
---@field FadeInOffset float
---@field FadeInTime float
---@field CurveFadeOut UCurveFloat
---@field FadeOutOffset float
---@field FadeOutTime float
---@field BGMTransitionType EB1BGMTransitionType
local FB1BGMTransitionData = {}



---@class FB1BGMTransitionTableRow : FB1TableRowBase
---@field ID FName
---@field TransitionMap TMap<FName, FB1BGMTransitionData>
local FB1BGMTransitionTableRow = {}



---@class FB1BabyCharacterSpawnData
---@field Gender EB1GenderType
---@field BornAge int32
---@field AppearancePresetId FName
---@field AppearanceOutfitPresetId FName
---@field AppearanceSetting FB1AppearanceSetting
---@field CategorizedOutfits TMap<EB1OutfitCategory, FB1OutfitSetting>
---@field DiversityInfo FB1DiversityInfo
local FB1BabyCharacterSpawnData = {}



---@class FB1BabySafetyInfo
---@field ServiceId FName
---@field IntervalTimePerGameMinute int32
---@field IntervalTimePerDelta float
---@field BabyNeglectWarningMessageId FName
---@field CallMessageId FName
---@field CancelMessageId FName
---@field BabyReturnToHomePopupId FName
---@field BabysittersGroupId FName
local FB1BabySafetyInfo = {}



---@class FB1BaseTimelineData
local FB1BaseTimelineData = {}


---@class FB1BlackListTableRow : FB1TableRowBase
---@field ID FName
local FB1BlackListTableRow = {}



---@class FB1BodyAnimInfo
---@field BodyAnimId FName
---@field VoiceId FName
local FB1BodyAnimInfo = {}



---@class FB1BodyDescription
---@field BodyData FB1CharacterBodyInfo
---@field FootMesh FSoftObjectPath
---@field BodyMassRatio float
---@field MuscleDefinition float
---@field MuscleMass float
---@field BodyShapeParameters TArray<float>
---@field BodyHairColor FLinearColor
---@field BodyHairScalarParameters TMap<FName, float>
---@field AuthorName FString
---@field OverrideBodyMassRatio float
---@field OverrideMuscleMass float
local FB1BodyDescription = {}



---@class FB1BodyGizmoGroup
---@field GroupName FName
---@field DetectorBones TArray<FName>
---@field HighlightTexture TMap<EB1AppearanceParts, TSoftObjectPtr<UTexture2D>>
---@field GizmoBone FName
---@field GizmoTransform FTransform
---@field ReverseGizmoAxises TArray<EB1GizmoAxisType>
---@field bUseTransformGroupGizmoOffset boolean
---@field GizmoLocationMin TMap<EB1GizmoAxisType, FVector>
---@field GizmoLocationMax TMap<EB1GizmoAxisType, FVector>
---@field bUseTransformGroupGizmoScale boolean
---@field UsedTransformGroupIndexForGizmoScale int32
---@field GizmoScaleMin float
---@field GizmoScaleMax float
---@field DotScale FVector
---@field TransformGroups TArray<FName>
---@field TransformGroupsIndices TArray<int32>
local FB1BodyGizmoGroup = {}



---@class FB1BodyGroupTransformData : FB1FaceGroupTransformData
---@field AdditiveData_BodyPositive TArray<FB1AdditiveBoneData>
---@field AdditiveData_BodyNegative TArray<FB1AdditiveBoneData>
---@field ShapeValueDeltaFromZeroOfBodyMass float
---@field ShapeValueDeltaFromZeroOfMuscleMass float
---@field ShapeValueDeltaFromZeroOfGizmo float
local FB1BodyGroupTransformData = {}



---@class FB1BodyShapeCustomizeData
---@field GizmoGroups TArray<FB1BodyGizmoGroup>
---@field CustomizeGroups TArray<FB1BodyGroupTransformData>
---@field MuscleLimitGroup int32
---@field BoneToGizmoGroupIndexTable TMap<FName, int32>
local FB1BodyShapeCustomizeData = {}



---@class FB1BookState
---@field BookDtId FName
---@field AccumulateReadTickTime double
---@field ReadCount int32
local FB1BookState = {}



---@class FB1BookTableRow : FB1TableRowBase
---@field ID FName
---@field ObjectId FName
---@field InteractionTags TArray<FName>
---@field TotalReadTime int32
---@field SkillId FName
---@field RequireSkillLevel int32
---@field TotalSkillExp int32
---@field StartScriptId FName
---@field TickScriptId FName
---@field FinishScriptId FName
local FB1BookTableRow = {}



---@class FB1BorderSaveData
---@field Outer FB1Polygon2SaveData
---@field bOuterIsCW boolean
---@field Holes TArray<FB1Polygon2SaveData>
local FB1BorderSaveData = {}



---@class FB1Buff
---@field ID FName
---@field duration int64
---@field StartTime int64
---@field AccInterval float
---@field ShouldRemove boolean
---@field HiddenFromUI boolean
---@field IsInfinite boolean
---@field ScriptInterval float
---@field EmotionId FName
---@field EmotionValue int32
---@field DesireBoostEmotionId FName
local FB1Buff = {}



---@class FB1BuffBasicInfo
---@field IsEssential boolean
---@field duration float
---@field TickInterval float
---@field ScriptInterval float
---@field EmotionId FName
---@field EmotionValue int32
---@field Tags TArray<FName>
---@field TagIconId FName
local FB1BuffBasicInfo = {}



---@class FB1BuffDisplayInfo
---@field DisplayTextId FString
---@field ReasonTextId FString
---@field IconId FName
---@field EmotionColorId1 FName
---@field EmotionColorId2 FName
---@field HiddenFromUI boolean
---@field AlarmIconMaterialId FName
---@field IsHighlight boolean
local FB1BuffDisplayInfo = {}



---@class FB1BuffTableRow : FB1TableRowBase
---@field ID FName
---@field BuffBasicInfo FB1BuffBasicInfo
---@field BuffDisplayInfo FB1BuffDisplayInfo
---@field AddScriptIdList TArray<FName>
---@field CancelScriptIdList TArray<FName>
---@field FinishScriptIdList TArray<FName>
---@field TickScriptIdList TArray<FName>
---@field IntervalScriptIdList TArray<FName>
local FB1BuffTableRow = {}



---@class FB1BuildModeGameObjectData
---@field ObjectDataTableId FName
---@field EntityID FB1EntityId
---@field ParentEntityId FB1EntityId
---@field ParentSlotName FName
---@field Transform FTransform
---@field FloorLevel int32
---@field IsDevLocked boolean
---@field CustomizeData TArray<FB1ObjectCustomizeSaveData>
---@field PrintedMeshId FString
---@field PrintedMeshOffset FVector
---@field ObjectMetaSaveData FB1GameObjectMetaSaveData
---@field AuthorName FString
---@field GalleryPathKey FString
---@field AssembledAssetHash int64
local FB1BuildModeGameObjectData = {}



---@class FB1BuildModePresetCategoryFilterTableRow : FB1TableRowBase
---@field ID FName
---@field Category FName
---@field Tags TArray<FName>
local FB1BuildModePresetCategoryFilterTableRow = {}



---@class FB1BuildPresetRow : FB1TableRowBase
---@field ID FName
---@field DisplayNameTextId FString
---@field DescriptionTextId FString
---@field PresetAsset TSoftObjectPtr<UDataTable>
---@field Icon TSoftObjectPtr<UObject>
---@field BedNum int32
---@field ToiletNum int32
local FB1BuildPresetRow = {}



---@class FB1CameraGameOptionPreset
---@field AdditionalShadowQuality int32
---@field FOV float
local FB1CameraGameOptionPreset = {}



---@class FB1CameraGameOptionPresetSetting
---@field DefaultPresetMap TMap<EB1CameraModeType, FB1CameraGameOptionPreset>
---@field TopViewMinFOV float
---@field TopViewMaxFOV float
---@field TopViewShadowQualitySettingArray TArray<FB1TopViewCameraShadowQualitySetting>
---@field TopViewDynamicSkyPostProcessSetting FB1TopViewCameraDynamicSkyPostProcessSetting
local FB1CameraGameOptionPresetSetting = {}



---@class FB1CameraModeContainer
local FB1CameraModeContainer = {}


---@class FB1CameraModeData
---@field bDoCollisionTest boolean
---@field FOV float
---@field BaseZoomLength float
---@field ZoomLengthMin float
---@field ZoomLengthMax float
---@field ZoomInterpSpeed float
---@field ZoomSensitivity float
---@field ViewTargetOffsetLocation FVector
---@field RotationYawRate float
---@field RotationPitchRate float
---@field ViewPitchMin float
---@field ViewPitchMax float
---@field ViewYawMin float
---@field ViewYawMax float
---@field ViewRollMin float
---@field ViewRollMax float
---@field QuaterViewMoveSpeedRate float
---@field QuaterViewRotateSpeedRate float
local FB1CameraModeData = {}



---@class FB1CameraModeVolume
local FB1CameraModeVolume = {}


---@class FB1CanvasAges
---@field ages TArray<uint8>
local FB1CanvasAges = {}



---@class FB1CareerInfo
---@field CompanyId FName
---@field Department FB1DepartmentKey
---@field LeftCompanyTicks int64
local FB1CareerInfo = {}



---@class FB1CarriableObjectDustyValueRange
---@field RangeMin int32
---@field RangeMax int32
---@field score float
local FB1CarriableObjectDustyValueRange = {}



---@class FB1CatShopTableRow : FB1TableRowBase
---@field ID FName
---@field NameTextId FString
---@field DescTextId FString
---@field EffectTextId FString
---@field Icon FName
---@field Price int64
---@field ScriptId FName
local FB1CatShopTableRow = {}



---@class FB1CatTalkMenuUITableRow : FB1TableRowBase
---@field ID FName
---@field GroupNameTextId FString
---@field bIsBuildWorldData boolean
---@field ChatbotIdList TArray<FB1ChatbotId>
local FB1CatTalkMenuUITableRow = {}



---@class FB1CatTalkTop3Suggestions
---@field FirstTextId FString
---@field SuggestionTextId FString
---@field LastTextId FString
local FB1CatTalkTop3Suggestions = {}



---@class FB1CatTalkTutorialTableRow : FB1ChatbotTableRowBase
---@field content TArray<FB1DescriptionId>
---@field SubTopicList TArray<FB1TutorialContent>
local FB1CatTalkTutorialTableRow = {}



---@class FB1CategoryVisibilityByGarmentType
---@field CategoryVisibilityByMainCategoryId TMap<FName, boolean>
local FB1CategoryVisibilityByGarmentType = {}



---@class FB1ChainBone
---@field FKBone FBoneReference
---@field IKBone FBoneReference
local FB1ChainBone = {}



---@class FB1ChangeCostumeFxParameters
---@field CylinderHeight float
---@field CylinderRadius float
---@field SpawnCount int32
---@field SpawnRate float
local FB1ChangeCostumeFxParameters = {}



---@class FB1ChangeMaterialInfo
---@field ChangeMaterial TSoftObjectPtr<UMaterialInterface>
---@field SlotNameList TArray<FName>
local FB1ChangeMaterialInfo = {}



---@class FB1ChangeMeshInfo
---@field SeasonType EB1SeasonType
---@field ChangeMesh TSoftObjectPtr<UStaticMesh>
---@field ChangeMaterialInfo TArray<FB1ChangeMaterialInfo>
local FB1ChangeMeshInfo = {}



---@class FB1CharacterAnimTableRow : FB1TableRowBase
---@field ID FName
---@field PlayingComponentName FName
---@field StopOtherComponentOnFinish boolean
---@field AnimInfoList TArray<FB1AnimationInfo>
local FB1CharacterAnimTableRow = {}



---@class FB1CharacterAttribute
---@field AttributeId FName
---@field Gender EB1GenderType
---@field BornAge int32
---@field DeadAge int32
---@field CharacterFirstNameKey FString
---@field CharacterFamilyNameKey FString
---@field FamilyRelationships TArray<FB1FamilyRelationshipInfo>
---@field Personality FName
---@field SkillMap TMap<FName, FB1CharacterAttributeSkillInfo>
---@field AmbitionInfo FB1CharacterAttributeAmbitionInfo
---@field PreferenceMap TMap<FName, FB1CharacterAttributePreferenceInfo>
---@field JobInfo FB1CharacterAttributeJobInfo
---@field AppearancePresetId FName
---@field AppearanceOutfitPresetId FName
---@field AppearanceSetting FB1AppearanceSetting
---@field CategorizedOutfitPresetMap TMap<EB1OutfitCategory, FB1CharacterAttributeAppearancePresetInfo>
---@field CategorizedOutfits TMap<EB1OutfitCategory, FB1OutfitSetting>
---@field CharacterFirstName FString
---@field CharacterFamilyName FString
---@field VoiceId FName
---@field BornStatMap TMap<FName, FB1CharacterBornStatInfo>
---@field Role EB1CharacterRole
---@field DiversityInfo FB1DiversityInfo
---@field HopeLifeId FName
---@field GenderIdentitySetting FB1GenderIdentitySetting
---@field EducationInfo FB1CharacterAttributeEducationInfo
local FB1CharacterAttribute = {}



---@class FB1CharacterAttributeAmbitionInfo
---@field ID FName
---@field Step int32
local FB1CharacterAttributeAmbitionInfo = {}



---@class FB1CharacterAttributeAppearancePresetInfo
---@field PresetId FName
---@field OutfitPresetId FName
local FB1CharacterAttributeAppearancePresetInfo = {}



---@class FB1CharacterAttributeEducationInfo
---@field EducationJobInfo TArray<FB1JobInfo>
---@field HighestEducationData FB1HighestEducationData
local FB1CharacterAttributeEducationInfo = {}



---@class FB1CharacterAttributeJobInfo
---@field CareerList TArray<FB1CareerInfo>
---@field JobInfoMap TMap<FName, FB1JobInfo>
---@field CurrentCompanyId FB1EntityId
local FB1CharacterAttributeJobInfo = {}



---@class FB1CharacterAttributePreferenceInfo
---@field ID FName
---@field bIsLike boolean
local FB1CharacterAttributePreferenceInfo = {}



---@class FB1CharacterAttributeSkillInfo
---@field ID FName
---@field Level int32
local FB1CharacterAttributeSkillInfo = {}



---@class FB1CharacterAttributeTableRow : FB1TableRowBase
---@field ID FName
---@field CharacterAttribute FB1CharacterAttribute
local FB1CharacterAttributeTableRow = {}



---@class FB1CharacterBodyCollisionConfig
---@field CollisionHeights TMap<EB1GenderType, float>
local FB1CharacterBodyCollisionConfig = {}



---@class FB1CharacterBodyInfo
---@field BodyMesh FSoftObjectPath
---@field bMergeBodyMesh boolean
---@field AnimInstance TSubclassOf<UAnimInstance>
---@field AppearancePresetId FName
---@field FootTypeMesh TMap<EB1FootType, FSoftObjectPath>
local FB1CharacterBodyInfo = {}



---@class FB1CharacterBornStatInfo
---@field ID FName
---@field Value int32
local FB1CharacterBornStatInfo = {}



---@class FB1CharacterCollisionPresetConfig
---@field BodyCollisionConfigs TMap<EB1BodyAgeType, FB1CharacterBodyCollisionConfig>
local FB1CharacterCollisionPresetConfig = {}



---@class FB1CharacterCustomizationUIListCategoryCondition
---@field GenderType EB1GenderType
---@field BodyAgeType EB1BodyAgeType
local FB1CharacterCustomizationUIListCategoryCondition = {}



---@class FB1CharacterCustomizationUIListCategoryGroupInfo
---@field MenuType EB1CharacterCustomizationUIMenuType
---@field CategoryInfos TArray<FB1CharacterCustomizationUIListCategoryInfo>
local FB1CharacterCustomizationUIListCategoryGroupInfo = {}



---@class FB1CharacterCustomizationUIListCategoryInfo
---@field CategoryId FName
---@field Name FString
---@field Icon TSoftObjectPtr<UObject>
---@field CategoryType EB1CharacterCustomizationUIListCategoryType
---@field DataTableNames TArray<FName>
local FB1CharacterCustomizationUIListCategoryInfo = {}



---@class FB1CharacterCustomizeStudioBGListEntryInfo
---@field Thumbnail TSoftObjectPtr<UTexture2D>
---@field StudioActorTag FName
---@field BGTag FName
---@field LightDatas TArray<FB1CharacterCustomizeStudioLightData>
local FB1CharacterCustomizeStudioBGListEntryInfo = {}



---@class FB1CharacterCustomizeStudioLightData
---@field LightTag FName
---@field MinYaw float
---@field MaxYaw float
---@field MinPitch float
---@field MaxPitch float
local FB1CharacterCustomizeStudioLightData = {}



---@class FB1CharacterCustomizeUICategoryMenu
---@field CategoryId FName
---@field Name FString
---@field Icon TSoftObjectPtr<UObject>
---@field CategoryType EB1CharacterCustomizationUIListCategoryType
---@field GarmentListType EB1CharacterCustomizeUIGarmentListType
---@field GarmentTypeList TArray<FName>
---@field AccessoryTypeList TArray<FName>
local FB1CharacterCustomizeUICategoryMenu = {}



---@class FB1CharacterCustomizeUIListEntryMaterialParameters
---@field TexScale float
---@field YPosition float
---@field Color1 FLinearColor
---@field Color2 FLinearColor
local FB1CharacterCustomizeUIListEntryMaterialParameters = {}



---@class FB1CharacterDataCache
---@field Portrait UTexture
local FB1CharacterDataCache = {}



---@class FB1CharacterDataCache_Base
local FB1CharacterDataCache_Base = {}


---@class FB1CharacterDataCache_Bio
local FB1CharacterDataCache_Bio = {}


---@class FB1CharacterDataCache_Buff
local FB1CharacterDataCache_Buff = {}


---@class FB1CharacterDataCache_Compact
local FB1CharacterDataCache_Compact = {}


---@class FB1CharacterDataCache_CompactTick
local FB1CharacterDataCache_CompactTick = {}


---@class FB1CharacterDataCache_Job
local FB1CharacterDataCache_Job = {}


---@class FB1CharacterDataCache_Personality
local FB1CharacterDataCache_Personality = {}


---@class FB1CharacterDataCache_PossessHousehold
local FB1CharacterDataCache_PossessHousehold = {}


---@class FB1CharacterDataCache_PossessRelationship
local FB1CharacterDataCache_PossessRelationship = {}


---@class FB1CharacterDataCache_PossessTick
local FB1CharacterDataCache_PossessTick = {}


---@class FB1CharacterDataCache_Relationship
local FB1CharacterDataCache_Relationship = {}


---@class FB1CharacterDataCache_Stat
local FB1CharacterDataCache_Stat = {}


---@class FB1CharacterDataCache_Timeline
local FB1CharacterDataCache_Timeline = {}


---@class FB1CharacterGeneticData
---@field EntityID FB1EntityId
---@field AppearanceSetting FB1AppearanceSetting
---@field DiversityInfo FB1DiversityInfo
---@field FamilyNameData FB1DisplayNameData
---@field TraitId FName
local FB1CharacterGeneticData = {}



---@class FB1CharacterOutfit
---@field AuthorName FString
---@field BaseOutfit FB1OutfitSetting
---@field ActiveOutfitList TArray<FB1OutfitSetting>
---@field FinalOutfit FB1OutfitSetting
---@field CategorizedOutfits TMap<EB1OutfitCategory, FB1OutfitSetting>
---@field BaseOutfitCategory EB1OutfitCategory
local FB1CharacterOutfit = {}



---@class FB1CharacterSpawnInfo
---@field EntityID FB1EntityId
---@field WorldLocation FVector
---@field WorldRotation FRotator
---@field HouseholdEntityId FB1EntityId
---@field VehicleOwnershipData FB1VehicleOwnershipData
---@field PocketMarketGradeInfo FB1PocketMarketGradeInfo
---@field Compact FB1CharacterDataCache_Compact
local FB1CharacterSpawnInfo = {}



---@class FB1ChatbotId
---@field ChatbotType EB1ChatbotType
---@field ChatbotId FName
local FB1ChatbotId = {}



---@class FB1ChatbotTableRowBase : FB1TableRowBase
---@field ID FName
---@field ChatbotNameTextId FString
---@field ChatbotProfileImage TSoftObjectPtr<UTexture2D>
---@field ChatbotProfileMessageTextId FString
---@field WebLinkMap TMap<FName, FString>
---@field bUseCatTranslator boolean
local FB1ChatbotTableRowBase = {}



---@class FB1CheatData
local FB1CheatData = {}


---@class FB1ChemistryInfo
---@field TraitSelectId FName
---@field ChemistryInfo EB1RelationshipChemistry
local FB1ChemistryInfo = {}



---@class FB1ChoiceCard
---@field ChoiceCardId FName
---@field Ratio int32
local FB1ChoiceCard = {}



---@class FB1ChoiceCardAnswer
---@field ListKey FString
---@field AnswerId FName
---@field TitleStrId FString
---@field ResultStrId FString
---@field AnswerStrId FString
---@field ConditionId FName
---@field FinishScriptIds TArray<FName>
---@field Ratio int32
---@field ColorId FName
local FB1ChoiceCardAnswer = {}



---@class FB1ChoiceCardConditionTableRow : FB1TableRowBase
---@field ID FName
---@field Conditions TArray<FB1Condition>
local FB1ChoiceCardConditionTableRow = {}



---@class FB1ChoiceCardGroupTableRow : FB1TableRowBase
---@field ID FName
---@field ChoiceCards TArray<FB1ChoiceCard>
local FB1ChoiceCardGroupTableRow = {}



---@class FB1ChoiceCardTableRow : FB1TableRowBase
---@field ID FName
---@field ConditionId FName
---@field TitleStrId FString
---@field MessageStrId FString
---@field ColorId FName
---@field AudioId FName
---@field PositiveAnswerStrId FString
---@field PositiveChoiceCardAnswers TArray<FB1ChoiceCardAnswer>
---@field NegativeTitleStrId FString
---@field NegativeChoiceCardAnswers TArray<FB1ChoiceCardAnswer>
local FB1ChoiceCardTableRow = {}



---@class FB1ChoiceCardTimeInfo
---@field OpenTick int64
---@field ChoiceCardGroupId FName
local FB1ChoiceCardTimeInfo = {}



---@class FB1CityAudioResourcesTableRow : FB1TableRowBase
---@field ID FName
---@field SoundResourceMap TMap<EB1CityAudioResourceType, FName>
local FB1CityAudioResourcesTableRow = {}



---@class FB1CityEditChangeList
---@field OriginMesh TSoftObjectPtr<UStaticMesh>
---@field ChangeMeshInfoBySeason TArray<FB1ChangeMeshInfo>
local FB1CityEditChangeList = {}



---@class FB1CityEditChangeListInfo
---@field ID FName
---@field ListKey FString
---@field CategoryType FName
---@field DecorationId FName
---@field DisplayNameTextId FString
---@field TooltipTextId FString
---@field IconTexture TSoftObjectPtr<UTexture2D>
---@field ChangeList TArray<FB1CityEditChangeList>
---@field PartsList TArray<FB1CityEditPartsList>
---@field bResetMaterial boolean
---@field bUseMaterial boolean
---@field bSpawnCountIsolrate boolean
---@field SpriteTexture TSoftObjectPtr<UTexture2D>
---@field URL FString
local FB1CityEditChangeListInfo = {}



---@class FB1CityEditMenu
---@field CategoryType FName
---@field DisplayNameTextId FString
---@field DescriptionTextId FString
---@field SubTabList TArray<FB1CityEditMenuSubTab>
local FB1CityEditMenu = {}



---@class FB1CityEditMenuSubTab
---@field ID FName
---@field GroupId FName
---@field IsSliderType boolean
---@field SliderDefaultValue float
---@field DefaultMinRate float
---@field DefaultMaxRate float
---@field bMPCType boolean
---@field MPCParamName FName
---@field SliderStepSize int32
---@field IsListType boolean
---@field IsMultiSelectable boolean
---@field IsColorPaletteType boolean
---@field IsUserImportableType boolean
---@field SliderLeftTextId FString
---@field SliderRightTextId FString
---@field BlendStartPos FVector
---@field BlendEndPos FVector
---@field BlendStartRot FRotator
---@field BlendEndRot FRotator
---@field BlendStartDistance float
---@field BlendEndDistance float
---@field BlendTime float
local FB1CityEditMenuSubTab = {}



---@class FB1CityEditMenuTableRow : FB1TableRowBase
---@field ID FName
---@field CityMenuList TArray<FB1CityEditMenu>
local FB1CityEditMenuTableRow = {}



---@class FB1CityEditObjectPositionTypeSpawnInfo
---@field VATAssetList TMap<FName, FB1CityEditObjectTypeSpawnAssetInfo>
---@field TransformList TArray<FTransform>
local FB1CityEditObjectPositionTypeSpawnInfo = {}



---@class FB1CityEditObjectSpawnAssetInfo
---@field SpawnRate float
---@field ObjectId FName
---@field FXObject UClass
local FB1CityEditObjectSpawnAssetInfo = {}



---@class FB1CityEditObjectTypeSpawnAssetInfo
---@field VATAssetList TArray<FB1CityEditObjectSpawnAssetInfo>
local FB1CityEditObjectTypeSpawnAssetInfo = {}



---@class FB1CityEditObjectWorldSpawnInfoList
---@field VATSpawnInfoList TMap<FName, FB1CityEditObjectPositionTypeSpawnInfo>
local FB1CityEditObjectWorldSpawnInfoList = {}



---@class FB1CityEditPartsList
---@field ListKey FString
---@field PartsType FName
---@field ApplyColorParameterName FName
---@field DisplayNameTextId FString
---@field BaseColorString FString
---@field InitialColorStringBySeason TMap<EB1SeasonType, FString>
---@field MaterialSlotNameList TArray<FName>
local FB1CityEditPartsList = {}



---@class FB1CityEditReportSubList
---@field ID FName
---@field ListKey FString
---@field DescriptionTextId FString
local FB1CityEditReportSubList = {}



---@class FB1CityEditReportTableRow : FB1TableRowBase
---@field ID FName
---@field TitleTextId FString
---@field Icon TSoftObjectPtr<UTexture2D>
---@field SubList TArray<FB1CityEditReportSubList>
local FB1CityEditReportTableRow = {}



---@class FB1CityEditStabilityModifierInfo
---@field ID FName
---@field ListKey FString
---@field MinRate float
---@field MaxRate float
---@field CenterRate float
local FB1CityEditStabilityModifierInfo = {}



---@class FB1CityEditStabilityProbPositionTypeSpawnInfo
---@field ProbAssetList TMap<FName, FB1CityEditStabilityProbTypeSpawnAssetInfo>
---@field TransformList TArray<FTransform>
local FB1CityEditStabilityProbPositionTypeSpawnInfo = {}



---@class FB1CityEditStabilityProbSpawnAssetInfo
---@field SpawnRate float
---@field SpawnBluePrint TSoftClassPtr<AActor>
local FB1CityEditStabilityProbSpawnAssetInfo = {}



---@class FB1CityEditStabilityProbTypeSpawnAssetInfo
---@field ProbAssetList TArray<FB1CityEditStabilityProbSpawnAssetInfo>
local FB1CityEditStabilityProbTypeSpawnAssetInfo = {}



---@class FB1CityEditStabilityTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayTextId FString
---@field DescriptionTextId FString
---@field ModifierInfos TArray<FB1CityEditStabilityModifierInfo>
---@field DefaultMinRate float
---@field DefaultMaxRate float
---@field DefaultSliderValue float
---@field bMPCType boolean
---@field MPCParamName FName
local FB1CityEditStabilityTableRow = {}



---@class FB1CityEditTableRow : FB1TableRowBase
---@field ID FName
---@field CityEditList TArray<FB1CityEditChangeListInfo>
local FB1CityEditTableRow = {}



---@class FB1CityEditWorldStabilityProbSpawnInfoList
---@field ProbSpawnInfoList TMap<FName, FB1CityEditStabilityProbPositionTypeSpawnInfo>
local FB1CityEditWorldStabilityProbSpawnInfoList = {}



---@class FB1CityGraphDetailPoint : FB1CityGraphPoint
---@field Forward FVector
---@field Right FVector
---@field Up FVector
---@field AdvancedDistance float
local FB1CityGraphDetailPoint = {}



---@class FB1CityGraphIntersection
---@field Index int32
---@field Junctions TArray<int32>
---@field Schedules TArray<FB1CityGraphIntersectionSchedule>
local FB1CityGraphIntersection = {}



---@class FB1CityGraphIntersectionSchedule
---@field duration float
---@field SoftCloseDuration float
---@field LaneIndices TArray<int32>
local FB1CityGraphIntersectionSchedule = {}



---@class FB1CityGraphLane
---@field Index int32
---@field LocalIndex int32
---@field RoadIndex int32
---@field BeginPointIndex int32
---@field EndPointIndex int32
---@field Flags EB1CityGraphLaneFlags
---@field Width float
---@field links TArray<FB1CityGraphLaneLink>
---@field UID FName
local FB1CityGraphLane = {}



---@class FB1CityGraphLaneKey
---@field RoadIndex int32
---@field LaneIndex int32
---@field bReverse boolean
local FB1CityGraphLaneKey = {}



---@class FB1CityGraphLaneLink
---@field LaneIndex int32
---@field Type EB1CityGraphLaneLinkType
---@field Direction EB1CityGraphLaneLinkDirection
local FB1CityGraphLaneLink = {}



---@class FB1CityGraphLanePoint
---@field Index int32
---@field LaneIndex int32
---@field Position FVector
---@field Forward FVector
---@field Right FVector
---@field Up FVector
---@field Tangent FVector
---@field RemainingDistance float
---@field Flags uint32
local FB1CityGraphLanePoint = {}



---@class FB1CityGraphNode
---@field Index int32
---@field Category EB1CityGraphCategory
---@field Position FVector
---@field links TArray<FB1CityGraphNodeLink>
---@field UID FName
local FB1CityGraphNode = {}



---@class FB1CityGraphNodeLink
---@field RoadIndex int32
---@field Reverse boolean
local FB1CityGraphNodeLink = {}



---@class FB1CityGraphPath
---@field From FB1CityGraphPoint
---@field To FB1CityGraphPoint
---@field Keys TArray<FB1CityGraphLaneKey>
---@field bLanePathFilled boolean
---@field TotalCost float
local FB1CityGraphPath = {}



---@class FB1CityGraphPoint
---@field bValid boolean
---@field Position FVector
---@field RoadIndex int32
---@field LaneIndex int32
---@field PointIndex int32
---@field RemainingDistance float
local FB1CityGraphPoint = {}



---@class FB1CityGraphPointQuery
---@field City FName
---@field CityId FB1EntityId
---@field Position FVector
---@field Range FVector
---@field Category EB1CityGraphCategory
---@field bExcludePeriodic boolean
---@field ExcludeLaneFlags EB1CityGraphLaneFlags
local FB1CityGraphPointQuery = {}



---@class FB1CityGraphRoad
---@field Index int32
---@field Category EB1CityGraphCategory
---@field bBidirectional boolean
---@field Length float
---@field FromNodeIndex int32
---@field ToNodeIndex int32
---@field BeginLaneIndex int32
---@field EndLaneIndex int32
---@field UID FName
local FB1CityGraphRoad = {}



---@class FB1CityGraphTafficLight
---@field LaneIndex int32
---@field Position FVector
---@field Yaw float
---@field PresetIndex int32
local FB1CityGraphTafficLight = {}



---@class FB1CityLocation
---@field CityLocation TMap<FName, FVector>
---@field bMustSetToAllMap boolean
local FB1CityLocation = {}



---@class FB1CityPathFindGroup
---@field PathFindGroups TArray<FB1PathFindGroup>
---@field SiteAreaPathGroupIndex TMap<FName, int32>
local FB1CityPathFindGroup = {}



---@class FB1CitySeasonWeatherTableRow : FB1TableRowBase
---@field ID FName
---@field StartFirstTemperature int32
---@field Seasons TArray<FB1SeasonConfig>
local FB1CitySeasonWeatherTableRow = {}



---@class FB1CityTrafficLights
---@field TrafficLightAssets TArray<FB1TrafficLightAsset>
local FB1CityTrafficLights = {}



---@class FB1CityTrafficPedestrianPolicy
---@field bRightHandTraffic boolean
---@field HorizontalTranslationRange FVector2D
local FB1CityTrafficPedestrianPolicy = {}



---@class FB1CityTrafficPolicy
---@field PedestrianPolicy FB1CityTrafficPedestrianPolicy
---@field VehicleQuantity int32
---@field VehicleSpawnRatio TArray<float>
local FB1CityTrafficPolicy = {}



---@class FB1CleanlinessLevel
---@field DisplayText FText
---@field ConditionType EB1CleanlinessLevelConditionType
---@field RangeBeginCompareType EB1CompareType
---@field RangeBeginCompareValue float
---@field RangeEndCompareType EB1CompareType
---@field RangeEndCompareValue float
---@field SingleCompareType EB1CompareType
---@field SingleCompareValue float
local FB1CleanlinessLevel = {}



---@class FB1CleanlinessWidgetSettings
---@field UIAutoRefreshIntervalSec float
---@field CleanlinessMinValue float
---@field CleanlinessMaxValue float
---@field CleanlinessLevels TArray<FB1CleanlinessLevel>
local FB1CleanlinessWidgetSettings = {}



---@class FB1ColorTableRow : FB1TableRowBase
---@field ID FName
---@field ColorString FString
---@field VisibleColor FLinearColor
local FB1ColorTableRow = {}



---@class FB1CommonButtonData
---@field ButtonType EB1ButtonType
---@field Text FText
---@field bIsDimmed boolean
---@field ScriptId FName
---@field MinDesiredWidth float
---@field MaxDesiredWidth float
---@field Height float
local FB1CommonButtonData = {}



---@class FB1CommonButtonDesignData
---@field ButtonStyle FButtonStyle
---@field TextColor FSlateColor
local FB1CommonButtonDesignData = {}



---@class FB1CompanyConditionTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayName FString
---@field Conditions TArray<FB1Condition>
local FB1CompanyConditionTableRow = {}



---@class FB1CompanyCustomMobileMessageInfo
---@field JobPromotionId FName
---@field JobRankUpId FName
---@field JobRankDownId FName
---@field JoinCompanyId FName
---@field LeaveCompanyIds TArray<FB1LeaveCompanyCustomMobileMessageInfo>
local FB1CompanyCustomMobileMessageInfo = {}



---@class FB1CompanyInfo
---@field CompanyDtId FName
---@field SiteId FName
---@field DepartmentInfoMap TMap<FB1DepartmentKey, FB1DepartmentInfo>
---@field RootDepartmentInfoMap TMap<FB1DepartmentKey, FB1RootDepartmentInfo>
---@field Employees TMap<FB1EntityId, FB1EmployeeInfo>
---@field SeatObjectDepartmentMap TMap<FB1EntityId, FB1DepartmentKey>
local FB1CompanyInfo = {}



---@class FB1CompanyTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayName FString
---@field Desc FString
---@field SalaryCurrencyId FName
---@field RankTitleTextId FString
---@field ProgressBarTitleTextId FString
---@field Organizations TArray<FB1OrganizationInfo>
local FB1CompanyTableRow = {}



---@class FB1Condition
---@field BaseObject EB1BaseObject
---@field Command EB1ConditionType
---@field CompareType EB1CompareType
---@field S1 FName
---@field S2 FName
---@field F1 float
---@field F2 float
local FB1Condition = {}



---@class FB1ConstantsPostureRow
local FB1ConstantsPostureRow = {}


---@class FB1CoopStartInfo
---@field CoopId FName
---@field CoopType EB1CoopType
local FB1CoopStartInfo = {}



---@class FB1CoopTableRow : FB1TableRowBase
---@field ID FName
---@field TaskInfos TArray<FB1TaskInfo>
---@field RoleInfos TArray<FB1RoleInfo>
---@field StartScriptIds TArray<FName>
---@field FinishScriptIds TArray<FName>
---@field TimeOutDuration int32
local FB1CoopTableRow = {}



---@class FB1CoopTalkInfo
---@field bOneTime boolean
---@field bFixedStand boolean
---@field bCancelCurrentInteraction boolean
---@field TargetInteractionBagId FName
---@field HostAnimInfo TArray<FB1RandomAnimInfo>
---@field HostUpperBodyAnimInfo TArray<FB1RandomAnimInfo>
---@field HostFaceAnimInfo TArray<FB1RandomAnimInfo>
---@field TargetAnimInfo TArray<FB1RandomAnimInfo>
---@field TargetUpperBodyAnimInfo TArray<FB1RandomAnimInfo>
---@field TargetFaceAnimInfo TArray<FB1RandomAnimInfo>
---@field StartScriptIds TArray<FName>
---@field FinishScriptIds TArray<FName>
local FB1CoopTalkInfo = {}



---@class FB1CoopTalkTableRow : FB1TableRowBase
---@field ID FName
---@field CoopTalkInfo FB1CoopTalkInfo
local FB1CoopTalkTableRow = {}



---@class FB1CostumeEditPartsTableRow : FB1TableRowBase
---@field ID FName
---@field PartsNameTextId FString
local FB1CostumeEditPartsTableRow = {}



---@class FB1CostumeInfo
---@field GenderType EB1GenderType
---@field BodyAgeType EB1BodyAgeType
---@field Outfit TMap<FName, FName>
---@field Accessories TMap<FName, FName>
local FB1CostumeInfo = {}



---@class FB1CostumeTableRow : FB1TableRowBase
---@field ID FName
---@field CostumeTags TArray<FName>
---@field CostumeInfo TArray<FB1CostumeInfo>
local FB1CostumeTableRow = {}



---@class FB1CraftingCategory
---@field Category FName
---@field TitleTextId FString
---@field RecipeGroupIds TArray<FName>
---@field RecipeIds TArray<FName>
local FB1CraftingCategory = {}



---@class FB1CraftingIngredient
---@field ObjectId FName
---@field Count int32
---@field SearchType EB1CraftingIngredientSearchType
---@field TargetFilterInteractionId FName
local FB1CraftingIngredient = {}



---@class FB1CraftingObjectData
---@field CraftingId FName
---@field RecipeId FName
---@field CraftingStep int32
---@field CustomName FText
---@field CustomDescription FText
local FB1CraftingObjectData = {}



---@class FB1CraftingObjectSpawnData
---@field SpawnObjectId FName
---@field SpawnPoint EB1CraftObjectSpawnPoint
---@field TargetFilterInteractionId FName
---@field bIsCarriable boolean
local FB1CraftingObjectSpawnData = {}



---@class FB1CraftingRecipeVM
local FB1CraftingRecipeVM = {}


---@class FB1CraftingRecipeVMs
local FB1CraftingRecipeVMs = {}


---@class FB1CraftingStep
---@field InteractionBagId FName
---@field bResultFailContinue boolean
---@field SpawnData FB1CraftingObjectSpawnData
local FB1CraftingStep = {}



---@class FB1CraftingTableRow : FB1TableRowBase
---@field ID FName
---@field TitleTextId FString
---@field DescTextId FString
---@field SkillId FName
---@field RecipeListEntryColorId FName
---@field bHasCost boolean
---@field Categories TArray<FB1CraftingCategory>
---@field CraftingFinishTextId FString
---@field bNeedWorkbench boolean
---@field MoveToWorkbenchInteractionBagId FName
---@field FindWorkbenchInteractionId FName
---@field PublishingId FName
---@field PublishingNamingTextId FString
---@field PublishingExportTextId FString
local FB1CraftingTableRow = {}



---@class FB1CrowdGrabObjectTableRow : FB1TableRowBase
---@field ID FName
---@field GrowthStep EB1GrowthStep
---@field GenderType EB1GenderType
---@field CrowdObjectWeightList TArray<FB1CrowdGrabObjectWeight>
local FB1CrowdGrabObjectTableRow = {}



---@class FB1CrowdGrabObjectWeight
---@field CrowdGrabObjectId FName
---@field Weight int32
local FB1CrowdGrabObjectWeight = {}



---@class FB1CurrencyColor
---@field TextColor FB1CurrencyColorBySign
---@field IconColor FB1CurrencyColorBySign
---@field HighlightImageColor FB1CurrencyColorBySign
local FB1CurrencyColor = {}



---@class FB1CurrencyColorBySign
---@field Add FString
---@field Subtract FString
local FB1CurrencyColorBySign = {}



---@class FB1CurrencyDefaultData
---@field CurrencyId FName
---@field Value int32
local FB1CurrencyDefaultData = {}



---@class FB1CurrencyExchangeTableRow : FB1TableRowBase
---@field ID FName
---@field Value double
---@field DisplayDecimalPlace int32
---@field ExchangeRoundType EB1RoundType
---@field ExchangeRoundDigits int32
local FB1CurrencyExchangeTableRow = {}



---@class FB1CurrencyInfo
---@field NameTextId FString
---@field DescTextId FString
---@field Icon FName
---@field bPrivateData boolean
---@field bExchangable boolean
---@field bShopPoint boolean
local FB1CurrencyInfo = {}



---@class FB1CurrencyTableRow : FB1TableRowBase
---@field ID FName
---@field CurrencyInfo FB1CurrencyInfo
---@field CurrencyColor FB1CurrencyColor
local FB1CurrencyTableRow = {}



---@class FB1CustomMobileMessageTableRow : FB1TableRowBase
---@field ID FName
---@field RelationshipStatId FName
---@field PositiveAnswerButtonStrId FString
---@field NormalAnswerButtonStrId FString
---@field NegativeAnswerButtonStrId FString
---@field OpenMessageScript FName
---@field PositiveAnswerScriptId FName
---@field NormalAnswerScriptId FName
---@field NegativeAnswerScriptId FName
---@field MessageData FB1MobileMessageData
---@field ResponseTimeout int32
---@field CooltimeMinute int64
---@field MobileMessagePartiesId FName
---@field UseDelayMessage boolean
---@field DelayInfo FB1MobileMessageDelayInfo
local FB1CustomMobileMessageTableRow = {}



---@class FB1CustomizedCharacterInfo
---@field AppearanceSetting FB1AppearanceSetting
---@field Personality FName
---@field FirstName FText
---@field LastName FText
---@field VoiceId FName
---@field HopeLifeId FName
---@field GenderIdentitySetting FB1GenderIdentitySetting
---@field CategorizedOutfits TMap<EB1OutfitCategory, FB1OutfitSetting>
local FB1CustomizedCharacterInfo = {}



---@class FB1CustomizedHouseholdInfo
---@field HouseholdName FName
---@field HouseholdMemberCustomizedInfo TArray<FB1CustomizedCharacterInfo>
---@field CurrencyMap TMap<FName, int64>
---@field ResidingSiteId FName
local FB1CustomizedHouseholdInfo = {}



---@class FB1DailyLog
---@field LogList TMap<FName, int32>
local FB1DailyLog = {}



---@class FB1DailyLogList
---@field DailyLogList TMap<int32, FB1DailyLog>
local FB1DailyLogList = {}



---@class FB1DataAssetValidateReport
---@field ErrorLogs TArray<FString>
---@field WarningLogs TArray<FString>
local FB1DataAssetValidateReport = {}



---@class FB1DataAssetWrapper
---@field Entries TMap<FName, UDataAsset>
local FB1DataAssetWrapper = {}



---@class FB1DataFilterInfo
---@field TitleName FName
---@field TitleNameTextId FString
---@field TagList TArray<FB1DataFilterTagInfo>
local FB1DataFilterInfo = {}



---@class FB1DataFilterTableRow : FB1TableRowBase
---@field ID FName
---@field FilterList TArray<FB1DataFilterInfo>
local FB1DataFilterTableRow = {}



---@class FB1DataFilterTagInfo
---@field TagName FName
---@field TagTextId FString
local FB1DataFilterTagInfo = {}



---@class FB1DataSortOrderInfo
---@field OrderName FName
---@field OrderTextId FString
local FB1DataSortOrderInfo = {}



---@class FB1DataSortTableRow : FB1TableRowBase
---@field ID FName
---@field OrderList TArray<FB1DataSortOrderInfo>
local FB1DataSortTableRow = {}



---@class FB1DataTableWrapper
---@field CompositeTable UDataTable
---@field Entries TMap<FName, UDataTable>
local FB1DataTableWrapper = {}



---@class FB1DayScheduleInfo
---@field BeginTime int32
---@field EndTime int32
---@field StartScriptId FName
---@field FinishScriptId FName
---@field MissionInfo FB1ScheduleMissionInfo
local FB1DayScheduleInfo = {}



---@class FB1DeadAgeWeightInfo
---@field MinAge int32
---@field MaxAge int32
---@field Weight float
local FB1DeadAgeWeightInfo = {}



---@class FB1DebugCharacterInfo
---@field EntityID FB1EntityId
---@field DebugStringMap TMap<EB1DebugCharacter, FString>
local FB1DebugCharacterInfo = {}



---@class FB1DebugGameObjectInfo
---@field EntityID FB1EntityId
---@field DebugStringMap TMap<EB1DebugGameObject, FString>
local FB1DebugGameObjectInfo = {}



---@class FB1DecorationSpawnInfo
---@field ID FName
---@field ObjectId FName
---@field FXObject UClass
---@field SpawnTransform FTransform
local FB1DecorationSpawnInfo = {}



---@class FB1DecorationSpawnInfoList
---@field DecorationSpawnInfoList TArray<FB1DecorationSpawnInfo>
local FB1DecorationSpawnInfoList = {}



---@class FB1DefaultAssetCustomData
---@field Index int32
---@field Int32Map TMap<FName, int32>
---@field Int64Map TMap<FName, int64>
---@field FloatMap TMap<FName, float>
---@field ColorMap TMap<FName, FLinearColor>
---@field StringMap TMap<FName, FString>
local FB1DefaultAssetCustomData = {}



---@class FB1Delinquency
---@field Day int32
---@field CutOffTaxType EB1ServiceType
---@field MessageId FName
---@field Execution boolean
---@field Interest float
local FB1Delinquency = {}



---@class FB1DepartmentInfo
---@field EmptyHeadcount int32
---@field RootDepartmentKey FB1DepartmentKey
local FB1DepartmentInfo = {}



---@class FB1DepartmentKey
---@field JobId FName
---@field Rank int32
---@field ShiftIndex int32
local FB1DepartmentKey = {}



---@class FB1DepthOfFieldSettingData
---@field bOverride_DepthOfFieldSensorWidth boolean
---@field DepthOfFieldSensorWidth float
---@field bOverride_DepthOfFieldSqueezeFactor boolean
---@field DepthOfFieldSqueezeFactor float
---@field bOverride_DepthOfFieldFocalDistance boolean
---@field DepthOfFieldFocalDistance float
---@field bOverride_DepthOfFieldDepthBlurAmount boolean
---@field DepthOfFieldDepthBlurAmount float
---@field bOverride_DepthOfFieldDepthBlurRadius boolean
---@field DepthOfFieldDepthBlurRadius float
local FB1DepthOfFieldSettingData = {}



---@class FB1DescriptionId
---@field DescId FName
---@field DescTextId FString
---@field DescWebLinkMap TMap<FName, FString>
local FB1DescriptionId = {}



---@class FB1DisableSlotCondition
---@field OccupyingObjectCategories TArray<FName>
local FB1DisableSlotCondition = {}



---@class FB1DisplayNameData
---@field NameTextId FString
---@field CustomName FString
local FB1DisplayNameData = {}



---@class FB1DiversityInfo
---@field City EB1DiversityCity
---@field culture EB1DiversityCulture
---@field Race EB1DiversityRace
local FB1DiversityInfo = {}



---@class FB1DiversityPopulationInfo
---@field DiversityInfoRatios TMap<FB1DiversityInfo, float>
---@field DiversityPopulationCount TMap<FB1DiversityInfo, int32>
---@field TotalPopulationCount int32
local FB1DiversityPopulationInfo = {}



---@class FB1DlcInfoTableRow
---@field B1DlcId FString
---@field DlcName FName
---@field DlcType FString
---@field Description FString
---@field Dependency TArray<FName>
---@field AllowedPlatform TArray<FName>
---@field AvailableVersion int32
---@field bRelease boolean
---@field SteamId int32
local FB1DlcInfoTableRow = {}



---@class FB1DoorCondition
---@field Conditions TArray<FB1Condition>
local FB1DoorCondition = {}



---@class FB1DoorConditionTableRow : FB1TableRowBase
---@field ID FName
---@field OpenConditions TArray<FB1Condition>
local FB1DoorConditionTableRow = {}



---@class FB1DoorMessageTableRow : FB1TableRowBase
---@field ID FName
---@field NoPermissionMessage FString
local FB1DoorMessageTableRow = {}



---@class FB1DoorObjectSaveData
---@field OwnerId int64
---@field DoorPermissionMode EB1DoorPermissionMode
---@field AccessiblePermissionGroup EB1DoorPermissionGroup
---@field DoorPermissionPresetIds TArray<FName>
---@field bIsDisabledDoor boolean
local FB1DoorObjectSaveData = {}



---@class FB1DoorPermissionData
---@field PermissionText FString
---@field AllowedSiteTypeInPackage TArray<EB1SiteType>
---@field AllowedBuildMode boolean
---@field NoPermissionToastMessage FString
local FB1DoorPermissionData = {}



---@class FB1DoorTemplateSetting
---@field DoorAnimationType EB1DoorAnimationType
---@field DoorOpenAudioId FName
---@field DoorCloseAudioId FName
---@field bDoorAnimUse boolean
---@field bDoorLockNotUse boolean
---@field DoorMeshName FName
---@field MaxDoorOpeningAngle float
---@field DoorLocationCurve UCurveVector
---@field DoorRotationCurve UCurveVector
---@field DoorOpeningTime float
---@field DoorClosingTime float
---@field DoorOpenAnimId1 FName
---@field DoorOpenAnimId2 FName
local FB1DoorTemplateSetting = {}



---@class FB1DrawDebugBoxParam
---@field Center FVector
---@field Extent FVector
---@field Rotation FQuat
---@field Color FColor
---@field bPersistentLines boolean
---@field LifeTime float
---@field DepthPriority uint8
---@field Thickness float
local FB1DrawDebugBoxParam = {}



---@class FB1DrawDebugCapsuleParam
---@field Center FVector
---@field HalfHeight float
---@field Radius float
---@field Rotation FQuat
---@field Color FColor
---@field bPersistentLines boolean
---@field LifeTime float
---@field DepthPriority uint8
---@field Thickness float
local FB1DrawDebugCapsuleParam = {}



---@class FB1DrawDebugCircleArcParam
---@field Center FVector
---@field Radius float
---@field Direction FVector
---@field AngleWidth float
---@field Segments int32
---@field Color FColor
---@field bPersistentLines boolean
---@field LifeTime float
---@field DepthPriority uint8
---@field Thickness float
local FB1DrawDebugCircleArcParam = {}



---@class FB1DrawDebugCircleParam
---@field TransformMatrix FMatrix
---@field Radius float
---@field Segments int32
---@field Color FColor
---@field bPersistentLines boolean
---@field LifeTime float
---@field DepthPriority uint8
---@field Thickness float
---@field bDrawAxis boolean
local FB1DrawDebugCircleParam = {}



---@class FB1DrawDebugCoordinateSystemParam
---@field AxisLoc FVector
---@field AxisRot FRotator
---@field Scale float
---@field bPersistentLines boolean
---@field LifeTime float
---@field DepthPriority uint8
---@field Thickness float
local FB1DrawDebugCoordinateSystemParam = {}



---@class FB1DrawDebugDirectionalArrowParam
---@field LineStart FVector
---@field LineEnd FVector
---@field ArrowSize float
---@field Color FColor
---@field bPersistentLines boolean
---@field LifeTime float
---@field DepthPriority uint8
---@field Thickness float
local FB1DrawDebugDirectionalArrowParam = {}



---@class FB1DrawDebugLineParam
---@field LineStart FVector
---@field LineEnd FVector
---@field Color FColor
---@field bPersistentLines boolean
---@field LifeTime float
---@field DepthPriority uint8
---@field Thickness float
local FB1DrawDebugLineParam = {}



---@class FB1DrawDebugPointParam
---@field Position FVector
---@field Size float
---@field PointColor FColor
---@field bPersistentLines boolean
---@field LifeTime float
---@field DepthPriority uint8
local FB1DrawDebugPointParam = {}



---@class FB1DrawDebugSphereParam
---@field Center FVector
---@field Radius float
---@field Segments int32
---@field Color FColor
---@field bPersistentLines boolean
---@field LifeTime float
---@field DepthPriority uint8
---@field Thickness float
local FB1DrawDebugSphereParam = {}



---@class FB1DrawDebugStringParam
---@field TextLocation FVector
---@field Text FString
---@field TextColor FColor
---@field duration float
---@field bDrawShadow boolean
---@field FontScale float
local FB1DrawDebugStringParam = {}



---@class FB1DreamAnimInfo
---@field PostureId FName
---@field AnimId FName
---@field FaceAnimId FName
local FB1DreamAnimInfo = {}



---@class FB1DreamAnimTableRow : FB1TableRowBase
---@field ID FName
---@field DreamAnimInfos TArray<FB1DreamAnimInfo>
local FB1DreamAnimTableRow = {}



---@class FB1DreamInfo
---@field PoolSelections TArray<FB1DreamPoolSelection>
local FB1DreamInfo = {}



---@class FB1DreamPoolSelection
---@field Weight float
---@field DreamPoolId FName
local FB1DreamPoolSelection = {}



---@class FB1DreamPoolTableRow : FB1TableRowBase
---@field ID FName
---@field SleepwalkingPoolId FName
---@field DreamSequenceIds TArray<FName>
local FB1DreamPoolTableRow = {}



---@class FB1DreamSequenceTableRow : FB1TableRowBase
---@field ID FName
---@field AwakeScriptId FName
---@field AwakeBuffId FName
---@field DreamAnimId FName
---@field VoiceResourceId FName
---@field REMStartScriptId FName
---@field Images TArray<TSoftObjectPtr<UObject>>
local FB1DreamSequenceTableRow = {}



---@class FB1DreamTableRow : FB1TableRowBase
---@field ID FName
---@field AgingConditionFlags int32
---@field DreamInfo FB1DreamInfo
local FB1DreamTableRow = {}



---@class FB1EducationTableData
---@field EducationType EB1EducationType
---@field GrowthStep EB1GrowthStep
---@field JobIdList TArray<FName>
local FB1EducationTableData = {}



---@class FB1EducationTableRow : FB1TableRowBase
---@field ID FName
---@field EducationDataList TArray<FB1EducationTableData>
local FB1EducationTableRow = {}



---@class FB1EffectsInfo
---@field HowlingEffectId FName
local FB1EffectsInfo = {}



---@class FB1EmotionAudioTableRow : FB1TableRowBase
---@field EmotionType EB1EmotionType
---@field MetaSoundResource UMetaSoundSource
local FB1EmotionAudioTableRow = {}



---@class FB1EmotionInfo
---@field ListKey FString
---@field EmotionId FName
---@field Level int32
---@field Value int32
---@field StartTime float
local FB1EmotionInfo = {}



---@class FB1EmotionLevelData
---@field Level int32
---@field DisplayTextId FString
---@field DescTextId FString
---@field ValueGreaterThan int32
---@field ModifierId FName
---@field ApplyScriptId FName
---@field EmotionColorId1 FName
---@field EmotionColorId2 FName
---@field PortraitColorId1 FName
---@field PortraitColorId2 FName
---@field FacialExpressionId FName
---@field PlayMFXId FName
---@field DescTooltipTextId FString
---@field DisableTooltipTextId FString
---@field DisableInteractionBagTags TArray<FName>
local FB1EmotionLevelData = {}



---@class FB1EmotionRandomAnimationInfo
---@field Animation TSoftObjectPtr<UAnimSequenceBase>
---@field EmotionId FName
---@field EmotionLevel int32
---@field ChanceToPlay float
local FB1EmotionRandomAnimationInfo = {}



---@class FB1EmotionReward
---@field EmotionId FName
---@field LevelFrom int32
---@field LevelTo int32
---@field Bonus int32
local FB1EmotionReward = {}



---@class FB1EmotionTableRow : FB1TableRowBase
---@field ID FName
---@field Type EB1EmotionType
---@field Tendency EB1EmotionTendency
---@field ActivateValue int32
---@field UIOrder int32
---@field Icon TSoftObjectPtr<UObject>
---@field EmotionLevelDatas TArray<FB1EmotionLevelData>
---@field AdmitDesireBuffLevelDatas TArray<FB1AdmitDesireBuffLevelData>
local FB1EmotionTableRow = {}



---@class FB1EmployeeInfo
---@field Department FB1DepartmentKey
---@field LastPaydayTicks int64
---@field JoinedTicks int64
---@field JoinedDay int32
---@field PromotionedTicks int64
---@field AbsenceDay int32
---@field AttendanceDay int32
local FB1EmployeeInfo = {}



---@class FB1EnqueueConditionTableRow : FB1TableRowBase
---@field ID FName
---@field EnqueueConditions TArray<FB1Condition>
local FB1EnqueueConditionTableRow = {}



---@class FB1EntityId
---@field Value int64
local FB1EntityId = {}



---@class FB1EntityIdArray
local FB1EntityIdArray = {}


---@class FB1EntitySLODInfo
---@field EntityType EB2EntityType
---@field CurrLevel EB1SimulationLevel
local FB1EntitySLODInfo = {}



---@class FB1EntitySLODInfoMap
---@field SLODInfoMap TMap<FB1EntityId, FB1EntitySLODInfo>
local FB1EntitySLODInfoMap = {}



---@class FB1EnvironmentPartsKey
---@field GroupId FName
---@field CategotyId FName
---@field PartsIndex int32
local FB1EnvironmentPartsKey = {}



---@class FB1EssentialOrder
---@field Schedule FB1Schedule
---@field Order FB1Order
local FB1EssentialOrder = {}



---@class FB1Execute
---@field BaseObject EB1BaseObject
---@field Command EB1ExecuteType
---@field S1 FName
---@field S2 FName
---@field F1 float
---@field F2 float
---@field Prob float
local FB1Execute = {}



---@class FB1ExecuteQuest
---@field QuestInfo FB1ReserveQuest
---@field MissionId FB1MissionId
local FB1ExecuteQuest = {}



---@class FB1ExportInteraction
local FB1ExportInteraction = {}


---@class FB1ExtraRequireSpaceSlotData
---@field RequireSpace boolean
local FB1ExtraRequireSpaceSlotData = {}



---@class FB1FaceGizmoGroup
---@field GroupName FName
---@field DetectorBones TArray<FName>
---@field HighlightTexture TSoftObjectPtr<UTexture2D>
---@field SymmetryHighlightTexture TSoftObjectPtr<UTexture2D>
---@field bIncludeEye boolean
---@field GizmoBone FName
---@field DotScale FVector
---@field GizmoTransformYoung FTransform
---@field GizmoTransformOld FTransform
---@field ReverseGizmoAxises TArray<EB1GizmoAxisType>
---@field bUseTransformGroupGizmoOffset boolean
---@field GizmoLocationYoungMin TMap<EB1GizmoAxisType, FVector>
---@field GizmoLocationYoungMax TMap<EB1GizmoAxisType, FVector>
---@field GizmoLocationOldMin TMap<EB1GizmoAxisType, FVector>
---@field GizmoLocationOldMax TMap<EB1GizmoAxisType, FVector>
---@field TransformGroups TArray<FName>
---@field MirrorGroup FName
---@field TransformGroupsIndices TArray<int32>
---@field ChildGizmoGroupIndices TArray<int32>
---@field ParentIndex int32
---@field MirrorIndex int32
---@field bIsParent boolean
local FB1FaceGizmoGroup = {}



---@class FB1FaceGroupTransformData
---@field AdditiveData_FacePositive TArray<FB1AdditiveBoneData>
---@field AdditiveData_FaceNegative TArray<FB1AdditiveBoneData>
---@field GizmoAxis EB1GizmoAxisType
---@field GizmoType EB1GizmoTransformType
---@field GroupName FName
---@field ShapeValueCurve UCurveFloat
local FB1FaceGroupTransformData = {}



---@class FB1FaceHairDescription
---@field FaceHairType EB1FaceHairType
---@field FaceHairId FName
---@field VectorParameters TMap<FName, FLinearColor>
---@field ScalarParameters TMap<FName, float>
---@field TextureParameters TMap<FName, UTexture>
---@field SectionIndex TArray<int16>
local FB1FaceHairDescription = {}



---@class FB1FacePresetItem
---@field FacePresetId FName
---@field FaceData FB1HeadDescription
local FB1FacePresetItem = {}



---@class FB1FaceShapeCustomizeData
---@field GizmoGroups TArray<FB1FaceGizmoGroup>
---@field CustomizeGroups TArray<FB1FaceGroupTransformData>
---@field BoneToGizmoGroupIndexTable TMap<FName, int32>
local FB1FaceShapeCustomizeData = {}



---@class FB1FacialExpressionTableRow : FB1TableRowBase
---@field ID FName
---@field AnimInfoList TArray<FB1AnimSequenceInfo>
---@field BlendAlpha float
local FB1FacialExpressionTableRow = {}



---@class FB1FakeCompanyInfo
---@field FakeCompanyId FName
---@field FakeSiteId FName
---@field AutoJoinFakeJobIds TArray<FName>
local FB1FakeCompanyInfo = {}



---@class FB1FakeCompanyTableRow : FB1TableRowBase
---@field ID FName
---@field FakeCompanies TArray<FB1FakeCompanyInfo>
local FB1FakeCompanyTableRow = {}



---@class FB1FamilyCreateOperation
---@field RelationshipTargetId FName
---@field RelationshipType EB1FamilyRelationshipType
---@field GenderControllType EB1FamilyCreateGenderControllType
---@field ToRelationshipTargetIdList TArray<FName>
local FB1FamilyCreateOperation = {}



---@class FB1FamilyCreateTemplateData
local FB1FamilyCreateTemplateData = {}


---@class FB1FamilyCreateTemplateTableRow : FB1TableRowBase
---@field ID FName
---@field Ratio int32
---@field FamilyMemberCount int32
---@field FamilyCreateOperations TArray<FB1FamilyCreateOperation>
local FB1FamilyCreateTemplateTableRow = {}



---@class FB1FamilyDivorceUIInfo
local FB1FamilyDivorceUIInfo = {}


---@class FB1FamilyMonitoringNotificationTableRow : FB1TableRowBase
---@field ID FName
---@field TitleTextId FString
---@field DescTextId FString
---@field Icon TSoftObjectPtr<UObject>
---@field bIsImportantAlert boolean
local FB1FamilyMonitoringNotificationTableRow = {}



---@class FB1FamilyNamePoolTableRow : FB1TableRowBase
---@field ID FName
---@field culture EB1DiversityCulture
---@field Names TArray<FB1NameData>
local FB1FamilyNamePoolTableRow = {}



---@class FB1FamilyRelationshipInfo
---@field ID FName
---@field EntityID FB1EntityId
---@field RelationshipType EB1FamilyRelationshipType
local FB1FamilyRelationshipInfo = {}



---@class FB1FamilyRelationshipNameTableRow : FB1TableRowBase
---@field ID FName
---@field DefaultTextId FString
---@field MaleToMaleTextId FString
---@field FemaleToMaleTextId FString
---@field MaleToFemaleTextId FString
---@field FemaleToFemaleTextId FString
local FB1FamilyRelationshipNameTableRow = {}



---@class FB1FamilyTableRow : FB1TableRowBase
---@field ID FName
---@field MapId FName
---@field FamilyNameTextId FString
---@field DescriptionTextId FString
---@field TextureId FName
---@field CurrencyDatas TArray<FB1CurrencyDefaultData>
---@field FamilyMemberAttributeIdList TArray<FName>
---@field IsRandomGenerate boolean
local FB1FamilyTableRow = {}



---@class FB1FamilyTreeLineStyle
---@field Color FLinearColor
---@field Thickness float
local FB1FamilyTreeLineStyle = {}



---@class FB1FamilyTreeLineStyles
---@field Default FB1FamilyTreeLineStyle
---@field MarriedCouple FB1FamilyTreeLineStyle
local FB1FamilyTreeLineStyles = {}



---@class FB1FamilyTreeMemberData
---@field ID FB1FamilyTreeMemberId
---@field ParentA FB1FamilyTreeMemberId
---@field ParentB FB1FamilyTreeMemberId
---@field Children TArray<FB1FamilyTreeMemberId>
---@field Spouse FB1FamilyTreeMemberId
local FB1FamilyTreeMemberData = {}



---@class FB1FamilyTreeMemberId
---@field ID FName
---@field EntityID FB1EntityId
local FB1FamilyTreeMemberId = {}



---@class FB1FamilyTreeTextId
---@field CannotChangeGrowthStep_Spouse FString
---@field CannotChangeGrowthStep_Parent FString
---@field CannotChangeGrowthStep_Child FString
---@field CannotChangeRelation_ExistingFamily FString
---@field CannotChangeRelation_Housemate_HasChild FString
---@field CannotChangeRelation_GrowthStep_Spouse FString
---@field CannotChangeRelation_GrowthStep_Parent FString
---@field CannotChangeRelation_GrowthStep_Child FString
---@field CannotChangeRelation_OtherRelation_Spouse FString
---@field CannotChangeRelation_OtherRelation_Parent FString
---@field CannotChangeRelation_OtherRelation_Child FString
local FB1FamilyTreeTextId = {}



---@class FB1FenceNodeSaveData
---@field Key int32
---@field Directions TArray<uint8>
---@field Edges TArray<int32>
local FB1FenceNodeSaveData = {}



---@class FB1FenceObjectSaveData
---@field Nodes TArray<FB1FenceNodeSaveData>
---@field FloorHeight float
---@field FenceHeight float
---@field CutFenceObjectId TArray<FB1EntityId>
local FB1FenceObjectSaveData = {}



---@class FB1Filter_AreaBox
---@field WidthAndDepth float
---@field Height float
local FB1Filter_AreaBox = {}



---@class FB1Filter_AreaCircle
---@field Radius float
---@field InnerRadius float
local FB1Filter_AreaCircle = {}



---@class FB1Filter_AreaCylinder
---@field Radius float
---@field InnerRadius float
---@field Height float
local FB1Filter_AreaCylinder = {}



---@class FB1Filter_Facing
---@field Length float
---@field Angle float
local FB1Filter_Facing = {}



---@class FB1Filter_LineTrace
---@field Length float
---@field StartOffset FVector
local FB1Filter_LineTrace = {}



---@class FB1Filter_ObjectTag
---@field ObjectTags TArray<FName>
local FB1Filter_ObjectTag = {}



---@class FB1FireExtinguishInfo
---@field TargetStateGroupId FName
---@field TargetStateId FName
---@field ChangeStateGroupId FName
---@field ChangeStateId FName
---@field ConditionStateGroupId FName
---@field ConditionStateId FName
---@field ConditionStatId FName
---@field ConditionCompareType EB1CompareType
---@field ConditionStatValue float
---@field Radius float
local FB1FireExtinguishInfo = {}



---@class FB1FireId
---@field Value int64
local FB1FireId = {}



---@class FB1FirstNamePoolTableRow : FB1TableRowBase
---@field ID FName
---@field culture EB1DiversityCulture
---@field Names TArray<FB1NameData>
local FB1FirstNamePoolTableRow = {}



---@class FB1FloatCurve
---@field Name FName
---@field Keys TArray<FB1FloatCurveKey>
local FB1FloatCurve = {}



---@class FB1FloatCurveKey
---@field Time float
---@field Value float
local FB1FloatCurveKey = {}



---@class FB1FloorPathFindGrid
---@field PathFindGridData TArray<FB1PathFindGridData>
local FB1FloorPathFindGrid = {}



---@class FB1FoodDisplayInfo
---@field Name FName
---@field Value int32
local FB1FoodDisplayInfo = {}



---@class FB1FoodTableRow : FB1TableRowBase
---@field ID FName
---@field FoodType EB1FoodType
---@field ObjectId FName
---@field InteractionTags TArray<FName>
---@field TimeToEat int32
---@field NumServings int8
---@field ServedFoodDtId FName
---@field DisplayInfos TArray<FB1FoodDisplayInfo>
---@field StartScriptIds TArray<FName>
---@field TickScriptIds TArray<FName>
---@field FinishScriptIds TArray<FName>
---@field StandEatAnimId FName
---@field SitHandFoodEatAnimId FName
---@field SitTableFoodEatAnimId FName
---@field SitBarTableFoodEatAnimId FName
local FB1FoodTableRow = {}



---@class FB1FootStepsAudioData
---@field LocalFootStepSound TSoftObjectPtr<UMetaSoundSource>
---@field RemoteFootStepSound TSoftObjectPtr<UMetaSoundSource>
local FB1FootStepsAudioData = {}



---@class FB1FootStepsAudioMap
---@field FootStepAudioMap TMap<FName, FB1FootStepsAudioData>
local FB1FootStepsAudioMap = {}



---@class FB1FootStepsAudioTableRow : FB1TableRowBase
---@field FootStepsAudioResources TMap<EB1ShoesType, FB1FootStepsAudioMap>
local FB1FootStepsAudioTableRow = {}



---@class FB1FreeChatbotDTInfo
---@field Language FName
---@field ChatbotDT_FAQ FSoftObjectPath
---@field ChatbotDT_Casual FSoftObjectPath
---@field ChatbotDT_Embed FSoftObjectPath
local FB1FreeChatbotDTInfo = {}



---@class FB1FreeChatbotTableRow : FB1ChatbotTableRowBase
---@field ChatbotDTInfoList TArray<FB1FreeChatbotDTInfo>
local FB1FreeChatbotTableRow = {}



---@class FB1FrequencyInfo
---@field Type EB1HowlingFrequencyType
---@field bAllowMultiple boolean
---@field CooldownTime float
---@field duration float
local FB1FrequencyInfo = {}



---@class FB1FxSlotData
---@field FXType EB1SloFXEffectType
---@field NiagaraFXObject TSubclassOf<UB1FXNiagaraObject>
---@field NiagaraSystem TSoftObjectPtr<UNiagaraSystem>
---@field ParticleSystem TSoftObjectPtr<UParticleSystem>
---@field CullDistance float
local FB1FxSlotData = {}



---@class FB1FxTableRow : FB1TableRowBase
---@field ID FName
---@field FXObject TSoftClassPtr<UObject>
local FB1FxTableRow = {}



---@class FB1GameConfigBasicSetting
---@field CustomizeMap TSoftObjectPtr<UWorld>
local FB1GameConfigBasicSetting = {}



---@class FB1GameConfigDateTime
---@field Day int32
---@field Hour int32
---@field Minute int32
local FB1GameConfigDateTime = {}



---@class FB1GameConfigTime
---@field RealTimeToGameTimeRatio float
---@field RealTimeSecondToInGameMinuteRatio float
---@field RealTimeSecondsPerGameMinuteInDaytime float
---@field GameSpeedAccelerationHourBegin int32
---@field GameSpeedAccelerationHourEnd int32
---@field MaxTimeScale float
---@field TimeScaleNormal float
---@field TimeScaleFast float
---@field TimeScaleVeryFast float
---@field TimeScaleNightSleep float
---@field ApplyNightSleepEnd_AM_Hour int32
---@field ApplyNightSleepStart_PM_Hour int32
---@field TimeScaleStep float
---@field ManualControlMaxTimeScale float
---@field TimeScaleVeryFastAndSpecialBehavior float
local FB1GameConfigTime = {}



---@class FB1GameConfigWidgetCustomization
---@field ScreenSize FIntPoint
---@field ScreenPadding FMargin
---@field GridSize FIntPoint
---@field GridSpacing FVector2D
---@field GridNum FIntPoint
---@field GridCalculationInfo FString
---@field bUseMovableGridArea boolean
---@field MovableGridArea FB1IntMargin
---@field bShowGrid boolean
---@field bShowDragIndicator boolean
---@field DragStartDelayWhenMouseDownSec float
---@field bUseWidgetMoveAnimationWhenDragging boolean
---@field WidgetMoveAnimationTimeSec float
---@field WidgetScaleWhenDragging float
---@field WidgetScaleAnimationTimeSec float
---@field CombinedSubWidgetOpacityWhenDraggingWidget float
---@field DragIndicatorWidget TSubclassOf<UUserWidget>
---@field SaveFilePath FString
local FB1GameConfigWidgetCustomization = {}



---@class FB1GameObjectAnimTableRow : FB1TableRowBase
---@field ID FName
---@field PlayingComponentName FName
---@field AnimInfoList TArray<FB1AnimationInfo>
local FB1GameObjectAnimTableRow = {}



---@class FB1GameObjectChangeMaterialParam
---@field ListKey FString
---@field MaterialName FName
---@field Icon TSoftObjectPtr<UObject>
---@field Material TSoftObjectPtr<UMaterialInterface>
---@field OverrideParam boolean
---@field ParamUsageId FName
---@field OverrideTransparency boolean
---@field OverrideParts boolean
---@field Parts TArray<FB1ObjectPartsOverride>
local FB1GameObjectChangeMaterialParam = {}



---@class FB1GameObjectChangeMeshParam
---@field ListKey FString
---@field Mesh TSoftObjectPtr<UStaticMesh>
---@field MeshName FName
local FB1GameObjectChangeMeshParam = {}



---@class FB1GameObjectDespawnInfo
---@field EntityID int64
---@field OwnerEntityId int64
local FB1GameObjectDespawnInfo = {}



---@class FB1GameObjectMaterialLayerParam
---@field ListKey FString
---@field MaterialName FName
---@field Icon TSoftObjectPtr<UObject>
---@field Albedo TSoftObjectPtr<UTexture>
---@field Normal TSoftObjectPtr<UTexture>
---@field Packed TSoftObjectPtr<UTexture>
---@field Emissive TSoftObjectPtr<UTexture>
---@field ParamUsageId FName
---@field SelectedAudioId FName
local FB1GameObjectMaterialLayerParam = {}



---@class FB1GameObjectMetaSaveData
---@field DoorObjectData FB1DoorObjectSaveData
---@field StairsObjectData FB1StairsObjectSaveData
---@field RoofObjectData FB1RoofObjectSaveData
---@field PillarObjectData FB1PillarObjectSaveData
---@field FenceObjectData FB1FenceObjectSaveData
---@field LadderObjectData FB1LadderObjectSaveData
---@field PrintedObjectData FB1PrintedObjectSaveData
---@field StudioMannequinObjectData FB1StudioMannequinObjectSaveData
local FB1GameObjectMetaSaveData = {}



---@class FB1GameObjectSoundTableRow : FB1TableRowBase
---@field ID FName
---@field SoundNotifyMap TMap<FName, TSoftObjectPtr<UMetaSoundSource>>
local FB1GameObjectSoundTableRow = {}



---@class FB1GameObjectSpawnInfo
---@field EntityID FB1EntityId
---@field ObjectDtId FName
---@field CarriableObjectDtId FName
---@field WorldLocation FVector
---@field WorldRotation FRotator
---@field Scale FVector
---@field LocatedSiteEntityId FB1EntityId
---@field ParentEntityId FB1EntityId
---@field SlotName FName
---@field CustomizedData TArray<FB1ObjectCustomizeSaveData>
---@field FloorLevel int32
---@field IsDevLocked boolean
---@field AuthorName FString
---@field PrintedMeshId FString
---@field PrintedMeshOffset FVector
---@field Quality EB1Quality
---@field Price int64
---@field CustomName FText
---@field GalleryPathKey FString
---@field AssembledAssetHash int64
---@field CanPopUpDescription boolean
---@field ObjectMetaData FB1GameObjectMetaSaveData
local FB1GameObjectSpawnInfo = {}



---@class FB1GameObjectSpawnParameter
local FB1GameObjectSpawnParameter = {}


---@class FB1GameOptionCategoryTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayName FString
---@field OptionGroups TArray<FB1GameOptionGroup>
local FB1GameOptionCategoryTableRow = {}



---@class FB1GameOptionGPUPresetTableRow : FB1TableRowBase
---@field ID FName
---@field GPU FString
---@field Preset EB1GraphicsPreset
---@field ResolutionSizeX uint32
---@field ResolutionSizeY uint32
---@field UpscalingQuality EB1UpscalingMode
local FB1GameOptionGPUPresetTableRow = {}



---@class FB1GameOptionGroup
---@field ID FName
---@field ListKey FString
---@field DisplayName FString
---@field DescriptionStrId FString
---@field GameOptionIds TArray<FName>
local FB1GameOptionGroup = {}



---@class FB1GameOptionPresetInfo
---@field OptionId FName
---@field OptionValue FName
local FB1GameOptionPresetInfo = {}



---@class FB1GameOptionPresetTableRow : FB1TableRowBase
---@field ID FName
---@field PresetInfos TArray<FB1GameOptionPresetInfo>
local FB1GameOptionPresetTableRow = {}



---@class FB1GameOptionSelection
---@field ListKey FString
---@field DisplayName FString
---@field OptionValue FName
local FB1GameOptionSelection = {}



---@class FB1GameOptionTableRow : FB1TableRowBase
---@field ID FName
---@field Type EB1GameOption
---@field DisplayName FString
---@field DefaultFormat FString
---@field UIType EB1GameOptionUIType
---@field bIsSubOption boolean
---@field MinSliderValue float
---@field MaxSliderValue float
---@field SliderUnit FText
---@field bNeedCountdown boolean
---@field DefaultValue FName
---@field Selections TArray<FB1GameOptionSelection>
---@field IsOnValueChangedApply boolean
---@field bShouldRestart boolean
local FB1GameOptionTableRow = {}



---@class FB1GarmentBottomMeshTableRow : FB1GarmentMeshTableRow
---@field DeformedMesh TSoftObjectPtr<USkeletalMesh>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentBottomMeshTableRow = {}



---@class FB1GarmentBottomPartsTableRow : FB1GarmentPartsTableRow
---@field DeformedMesh TSoftObjectPtr<USkeletalMesh>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentBottomPartsTableRow = {}



---@class FB1GarmentBottomTableRow : FB1GarmentTableRow
local FB1GarmentBottomTableRow = {}


---@class FB1GarmentDescription
---@field GarmentType FName
---@field MeshId FName
---@field GarmentId FName
---@field CustomGarmentName FName
---@field GarmentParts TArray<FName>
---@field OverrideMaterial TArray<TSoftObjectPtr<UMaterialInterface>>
---@field ScalarParameters TMap<FName, float>
---@field VectorParameters TMap<FName, FLinearColor>
---@field AiTextureParameter TMap<FName, FString>
---@field CoveredFlags int32
---@field BodyFlags int32
---@field SkinningTarget EB1MeshSkinningTarget
local FB1GarmentDescription = {}



---@class FB1GarmentFullMeshTableRow : FB1GarmentUpperMeshTableRow
---@field bDeformingHead boolean
---@field DeformedMesh TSoftObjectPtr<USkeletalMesh>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentFullMeshTableRow = {}



---@class FB1GarmentFullPartsTableRow : FB1GarmentPartsTableRow
---@field DeformedMesh TSoftObjectPtr<USkeletalMesh>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentFullPartsTableRow = {}



---@class FB1GarmentFullTableRow : FB1GarmentTableRow
local FB1GarmentFullTableRow = {}


---@class FB1GarmentHatMeshTableRow : FB1GarmentMeshTableRow
---@field HatType EB1HatType
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentHatMeshTableRow = {}



---@class FB1GarmentHatTableRow : FB1GarmentTableRow
---@field HatType EB1HatType
local FB1GarmentHatTableRow = {}



---@class FB1GarmentInnerTopMeshTableRow : FB1GarmentMeshTableRow
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentInnerTopMeshTableRow = {}



---@class FB1GarmentInnerTopTableRow : FB1GarmentTableRow
local FB1GarmentInnerTopTableRow = {}


---@class FB1GarmentInnerUnderMeshTableRow : FB1GarmentMeshTableRow
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentInnerUnderMeshTableRow = {}



---@class FB1GarmentInnerUnderTableRow : FB1GarmentTableRow
local FB1GarmentInnerUnderTableRow = {}


---@class FB1GarmentJacketMeshTableRow : FB1GarmentUpperMeshTableRow
---@field bDeformingTop boolean
---@field bDeformingBottom boolean
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentJacketMeshTableRow = {}



---@class FB1GarmentJacketPartsTableRow : FB1GarmentPartsTableRow
---@field bDeformingTop boolean
---@field bDeformingBottom boolean
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentJacketPartsTableRow = {}



---@class FB1GarmentJacketTableRow : FB1GarmentTableRow
local FB1GarmentJacketTableRow = {}


---@class FB1GarmentMeshTableRow : FB1AppearanceGroupedMeshTableRow
---@field OverrideMaterial TArray<TSoftObjectPtr<UMaterialInterface>>
---@field bRequireCustomParts boolean
---@field SkinningTarget EB1MeshSkinningTarget
---@field LayerPriority int32
---@field DrawingRegions TArray<EB1GarmentCoveringRegion>
---@field CoveringRegions TArray<EB1GarmentCoveringRegion>
---@field BodyRegions TArray<EB1BodyRegion>
---@field Tags TArray<FName>
local FB1GarmentMeshTableRow = {}



---@class FB1GarmentPartsGroup
---@field GroupName FName
---@field GroupDescTextId FString
---@field GroupThumbnail TSoftObjectPtr<UTexture>
---@field PartsInfo TArray<FB1GarmentPartsInfo>
local FB1GarmentPartsGroup = {}



---@class FB1GarmentPartsInfo
---@field PartsId FName
---@field PositionBone FName
---@field ForceVariantSuffix FString
local FB1GarmentPartsInfo = {}



---@class FB1GarmentPartsTableRow : FB1GarmentMeshTableRow
---@field bVirtualParts boolean
local FB1GarmentPartsTableRow = {}



---@class FB1GarmentShoesMeshTableRow : FB1GarmentMeshTableRow
---@field FootType EB1FootType
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentShoesMeshTableRow = {}



---@class FB1GarmentShoesPartsTableRow : FB1GarmentPartsTableRow
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentShoesPartsTableRow = {}



---@class FB1GarmentShoesTableRow : FB1GarmentTableRow
---@field ShoesType EB1ShoesType
local FB1GarmentShoesTableRow = {}



---@class FB1GarmentSocksMeshTableRow : FB1GarmentMeshTableRow
---@field FootType EB1FootType
---@field FootTypeMesh TMap<EB1FootType, TSoftObjectPtr<USkeletalMesh>>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentSocksMeshTableRow = {}



---@class FB1GarmentSocksTableRow : FB1GarmentTableRow
local FB1GarmentSocksTableRow = {}


---@class FB1GarmentSubCategoryTableRow : FB1TableRowBase
---@field ID FName
---@field NameTextId FString
---@field ParentCategory FName
---@field Thumbnail TSoftObjectPtr<UTexture2D>
local FB1GarmentSubCategoryTableRow = {}



---@class FB1GarmentTableRow : FB1AppearanceTableRow
---@field bCustomizable boolean
---@field NumColorChannels int32
---@field AITextureChannels int32
---@field Variants TArray<FName>
---@field HiddenFromUI boolean
---@field VariantGroups TArray<FB1GarmentVariantGroup>
---@field PartsGroup TArray<FB1GarmentPartsGroup>
---@field OutfitCategoryTags TArray<EB1OutfitCategory>
---@field OutfitBuffList TArray<FName>
local FB1GarmentTableRow = {}



---@class FB1GarmentTopMeshTableRow : FB1GarmentUpperMeshTableRow
---@field bDeformingBottom boolean
---@field bDeformingHead boolean
---@field bDeformingNecklace boolean
---@field DeformedMesh TSoftObjectPtr<USkeletalMesh>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentTopMeshTableRow = {}



---@class FB1GarmentTopPartsTableRow : FB1GarmentPartsTableRow
---@field bDeformingBottom boolean
---@field DeformedMesh TSoftObjectPtr<USkeletalMesh>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1GarmentTopPartsTableRow = {}



---@class FB1GarmentTopTableRow : FB1GarmentTableRow
local FB1GarmentTopTableRow = {}


---@class FB1GarmentUpperMeshTableRow : FB1GarmentMeshTableRow
---@field HairCutHeight float
local FB1GarmentUpperMeshTableRow = {}



---@class FB1GarmentVariantGroup
---@field GroupName FName
---@field GroupDescTextId FString
---@field GroupThumbnail TSoftObjectPtr<UTexture>
---@field VariantInfo TArray<FB1GarmentVariantInfo>
local FB1GarmentVariantGroup = {}



---@class FB1GarmentVariantInfo
---@field VariantName FName
---@field VariantDescTextId FString
---@field VariantThumbnail TSoftObjectPtr<UTexture>
---@field PositionBone FName
local FB1GarmentVariantInfo = {}



---@class FB1GenderIdentitySetting
---@field GenderIdentity EB1GenderIdentity
---@field bRomanticOrientation boolean
---@field RomanceTargetList TSet<EB1GenderIdentity>
local FB1GenderIdentitySetting = {}



---@class FB1GenderVoiceSelectionTableRow : FB1TableRowBase
---@field ID FName
---@field VoiceIdList TArray<FName>
local FB1GenderVoiceSelectionTableRow = {}



---@class FB1GeneratedMotionSlotData
---@field FileKey FString
---@field PlayLength float
local FB1GeneratedMotionSlotData = {}



---@class FB1GizmoColorSet
---@field HoveredColor FLinearColor
---@field FreeMoveColor FLinearColor
---@field AxisXColor FLinearColor
---@field AxisYColor FLinearColor
---@field AxisZColor FLinearColor
local FB1GizmoColorSet = {}



---@class FB1GizmoGroupNode
---@field ChildGizmoGroups TArray<FName>
local FB1GizmoGroupNode = {}



---@class FB1GizmoTransformActive
---@field LocationAxis uint8
---@field RotationAxis uint8
---@field ScaleAxis uint8
---@field OverridingColorName FName
local FB1GizmoTransformActive = {}



---@class FB1GrabState
---@field EntityID FB1EntityId
---@field GrabId FName
local FB1GrabState = {}



---@class FB1GrabTableRow : FB1TableRowBase
---@field ID FName
---@field PickUpAnimations TArray<FB1GrabTransition>
---@field LoopAnimId FName
---@field PutDownAnimations TArray<FB1GrabTransition>
local FB1GrabTableRow = {}



---@class FB1GrabTransition
---@field HeightMin float
---@field HeightMax float
---@field AnimId FName
local FB1GrabTransition = {}



---@class FB1GroupedChildObjectInfo
---@field ID FName
---@field AttachSlotName FName
local FB1GroupedChildObjectInfo = {}



---@class FB1GroupedObjectTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayNameTextId FString
---@field DescriptionTextId FString
---@field ObjectCategory FName
---@field FilterCategory FName
---@field Icon TSoftObjectPtr<UObject>
---@field ParentObjectId FName
---@field ChildrenInfos TArray<FB1GroupedChildObjectInfo>
---@field ConditionId FName
local FB1GroupedObjectTableRow = {}



---@class FB1GrowthChangeData
---@field ID FName
---@field Probability float
local FB1GrowthChangeData = {}



---@class FB1GrowthRandomAnimationInfo
---@field Animation TSoftObjectPtr<UAnimSequenceBase>
---@field GrowthStep EB1GrowthStep
---@field ChanceToPlay float
local FB1GrowthRandomAnimationInfo = {}



---@class FB1GrowthStepUpFxParameters
---@field CylinderHeight float
---@field CylinderRadius float
---@field SpawnCount int32
---@field SpawnRate float
local FB1GrowthStepUpFxParameters = {}



---@class FB1HairDescription
---@field BaseHairId FName
---@field MeshId FName
---@field ScalarParameters TMap<FName, float>
---@field VectorParameters TMap<FName, FLinearColor>
---@field OverrideVectorParameters TMap<FName, FLinearColor>
local FB1HairDescription = {}



---@class FB1HairLengthProbability
---@field MaleProbability float
---@field FemaleProbability float
local FB1HairLengthProbability = {}



---@class FB1HairRigidBodyInfo
---@field Mesh TSoftObjectPtr<USkeletalMesh>
---@field OverridePhysicsAsset TSoftObjectPtr<UPhysicsAsset>
local FB1HairRigidBodyInfo = {}



---@class FB1HardwareCursorSet
---@field HardwareCursors TMap<EMouseCursor::Type, FHardwareCursorReference>
local FB1HardwareCursorSet = {}



---@class FB1HeadDescription
---@field BaseHeadId FName
---@field Hair FB1HairDescription
---@field bIsSkinToneSetWithColorId boolean
---@field SkinColorApplyMode EB1SkinColorApplyMode
---@field FaceSkinColorId FName
---@field SkinScalarParameters TMap<FName, float>
---@field SkinTone FLinearColor
---@field MoleId FName
---@field FrecklesId FName
---@field ScarId FName
---@field TattooId FName
---@field SkinFeaturesTextureParameters TMap<FName, TWeakObjectPtr<UTexture>>
---@field SkinFeaturesVectorParameters TMap<FName, FLinearColor>
---@field SkinFeaturesScalarParameters TMap<FName, float>
---@field FaceHairs TMap<EB1FaceHairType, FB1FaceHairDescription>
---@field Makeup TMap<FName, FB1MakeupDescription>
---@field FaceShapeParameters TArray<float>
---@field FaceSkinnyRatio float
---@field FaceMakeupTextureParameters TMap<FName, TWeakObjectPtr<UTexture>>
---@field IrisPresetId FName
---@field IrisScalarParameters TMap<FName, float>
---@field IrisVectorParameters TMap<FName, FLinearColor>
---@field IrisTextureParameters TMap<FName, TWeakObjectPtr<UTexture>>
---@field SkinId FName
---@field AuthorName FString
---@field LastPresetId FName
---@field OverrideSkinTone TSet<FName>
local FB1HeadDescription = {}



---@class FB1HighestEducationData
---@field HighestEducationLevel EB1EducationType
---@field AchievementLevel int32
---@field JobId FName
local FB1HighestEducationData = {}



---@class FB1HopeConditionTableRow : FB1TableRowBase
---@field Conditions TArray<FB1Condition>
local FB1HopeConditionTableRow = {}



---@class FB1HopeLifeTableRow : FB1TableRowBase
---@field ID FName
---@field Image TSoftObjectPtr<UObject>
---@field TitleTextId FString
---@field DescriptionTextId FString
---@field InfoTextId FString
---@field LinkedTraitId FName
local FB1HopeLifeTableRow = {}



---@class FB1HopeSlotDefine
---@field HopeSlotName FName
---@field UsingHopeCategories TArray<FName>
---@field EmptySlotIconId FName
---@field ChildLockSlotIconId FName
local FB1HopeSlotDefine = {}



---@class FB1HopeTableRow : FB1TableRowBase
---@field ID FName
---@field HopeCategory FName
---@field SelectConditionId FName
---@field DisplayTextId FString
---@field ReasonDescTextId FString
---@field DescTextId FString
---@field CompleteEffectDescTextId FString
---@field SpeechBubbleId FName
---@field Icon TSoftObjectPtr<UTexture2D>
---@field MissionId FName
---@field StartScriptId FName
---@field CompleteScriptId FName
---@field EmotionId FName
local FB1HopeTableRow = {}



---@class FB1HouseholdInfo
---@field HouseholdNameData FB1DisplayNameData
---@field HouseholdDescriptionTextId FString
---@field HouseholdId FB1EntityId
---@field HouseholdMemberIds TArray<FB1EntityId>
---@field CurrencyMap TMap<FName, int64>
---@field ResidingSiteId FName
---@field bCanMoveIn boolean
---@field HouseholdTextureId FName
---@field bGiveBonusCurrency boolean
local FB1HouseholdInfo = {}



---@class FB1HouseholdMonitoringNotificationData
---@field NotifiedTime int64
---@field HouseholdMonitoringNotificationId FName
---@field SelfEntityId FB1EntityId
---@field SelfEntityNameBackup FText
---@field TargetEntityId FB1EntityId
---@field TargetEntityNameBackup FText
local FB1HouseholdMonitoringNotificationData = {}



---@class FB1HouseholdMoveInfo
---@field HouseholdInfo FB1HouseholdInfo
---@field bIsSellObjects boolean
local FB1HouseholdMoveInfo = {}



---@class FB1HowlingEffect
---@field WeightInfo FB1HowlingWeightInfo
---@field bCancelCurrentInteraction boolean
---@field InteractionEffect FB1HowlingEffect_Interaction
---@field ScriptEffect FB1HowlingEffect_Script
local FB1HowlingEffect = {}



---@class FB1HowlingEffectTableRow : FB1TableRowBase
---@field ID FName
---@field Cooltime float
---@field Effects TArray<FB1HowlingEffect>
---@field bOnlyForGhost boolean
local FB1HowlingEffectTableRow = {}



---@class FB1HowlingEffect_Interaction
---@field InteractionBagIdList TArray<FName>
local FB1HowlingEffect_Interaction = {}



---@class FB1HowlingEffect_Script
---@field StartScriptId FName
---@field TargetBaseObject EB1BaseObject
local FB1HowlingEffect_Script = {}



---@class FB1HowlingModifierSetting
---@field ModifierType EB1ModifierType
---@field ModifierKey FName
local FB1HowlingModifierSetting = {}



---@class FB1HowlingTableRow : FB1TableRowBase
---@field ID FName
---@field bAllowObject boolean
---@field bAllowCharacter boolean
---@field bImmediate boolean
---@field bFilterSameSite boolean
---@field FiltersInfo FB1TargetFilters
---@field EffectsInfo FB1EffectsInfo
---@field FrequencyInfo FB1FrequencyInfo
local FB1HowlingTableRow = {}



---@class FB1HowlingWeightInfo
---@field BaseWeight float
---@field ModifierSettings TArray<FB1HowlingModifierSetting>
local FB1HowlingWeightInfo = {}



---@class FB1IconWithBGInfo
---@field IconId FName
---@field BGColor1Id FName
---@field BGColor2Id FName
local FB1IconWithBGInfo = {}



---@class FB1InheritedSkill
---@field SkillLevel int32
---@field InheritedSkillMap TMap<FName, int32>
local FB1InheritedSkill = {}



---@class FB1InheritedSkillInfo
---@field SkillId FName
---@field InheritedSkills TArray<FB1InheritedSkill>
local FB1InheritedSkillInfo = {}



---@class FB1InstinctTableRow : FB1TableRowBase
---@field ID FName
---@field AgeAvailable TArray<EB1GrowthStep>
---@field AddScriptId FName
---@field RemoveScriptId FName
---@field InstinctScripts TArray<FB1TraitScript>
local FB1InstinctTableRow = {}



---@class FB1IntMargin
---@field Left int32
---@field Top int32
---@field Right int32
---@field Bottom int32
local FB1IntMargin = {}



---@class FB1InteractionBagGroupTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayStringTextId FString
---@field LeftMarkerId FName
---@field PanelIconId FName
local FB1InteractionBagGroupTableRow = {}



---@class FB1InteractionBagTableRow : FB1TableRowBase
---@field ID FName
---@field InteractionRewards TArray<FB1InteractionReward>
---@field PreferenceRewards TArray<FB1InteractionPreferenceReward>
---@field InteractionBagTags TArray<FName>
---@field GroupId FName
---@field InteractionBagCategory FName
---@field EnqueueConditionId FName
---@field InteractionConditionId FName
---@field AgingConditionFlags int32
---@field InteractionSequence TArray<FB1InteractionSequenceInfo>
---@field DisplayInfo FB1InteractionDisplayInfo
---@field bRejectable boolean
---@field bUniqueInQueue boolean
---@field bForFixedDesk boolean
---@field bNonCancelable boolean
---@field SelectedScriptId FName
---@field ConsumeCurrencyId FName
---@field ConsumeCurrencyValue int64
---@field bIgnoreConsumeCurrencyCheck boolean
---@field bGhostAvailable boolean
---@field bAlwaysExposeToSLM boolean
---@field AutonomySLMCooltimeMin int32
---@field ActionsPerformedInThePastHourText FName
---@field ActionHintText FName
---@field CurrentStateHintText FName
---@field ActionHintTextForSLM FName
---@field ActionHintTextList FName
local FB1InteractionBagTableRow = {}



---@class FB1InteractionBagWhitelistBuff : FB1TableRowBase
---@field ID FName
---@field BuffTag FName
---@field InteractionBagIds TArray<FName>
local FB1InteractionBagWhitelistBuff = {}



---@class FB1InteractionBasicInfo
---@field TickTimeout float
---@field IsCancelable boolean
local FB1InteractionBasicInfo = {}



---@class FB1InteractionCategoryTableRow : FB1TableRowBase
---@field ID FName
---@field NameTextId FString
---@field Icon TSoftObjectPtr<UTexture2D>
---@field InteractionTagInfos TArray<FB1InteractionTagInfo>
local FB1InteractionCategoryTableRow = {}



---@class FB1InteractionConditionTableRow : FB1TableRowBase
---@field ID FName
---@field VisibleConditions TArray<FB1Condition>
---@field EnableConditions TArray<FB1Condition>
local FB1InteractionConditionTableRow = {}



---@class FB1InteractionDesire
---@field InteractionBagId FName
---@field Desire int32
local FB1InteractionDesire = {}



---@class FB1InteractionDisplayInfo
---@field DisplayCategoryTextId FString
---@field DisplayTextId FString
---@field OverrideQueueTextId FString
---@field Icon TSoftObjectPtr<UObject>
---@field InteractionQueueIcon TSoftObjectPtr<UObject>
---@field PanelIcon TSoftObjectPtr<UObject>
---@field PanelIconId FName
---@field PanelIconColorId FName
---@field LeftMarkerId FName
---@field PanelIconWithBG FB1IconWithBGInfo
---@field bHideUI boolean
local FB1InteractionDisplayInfo = {}



---@class FB1InteractionInfo
---@field InteractionId FName
---@field Label FName
---@field SuccessNextLabel FName
---@field FailNextLabel FName
---@field bIsOptional boolean
local FB1InteractionInfo = {}



---@class FB1InteractionPreferenceReward
---@field TraitRewards TArray<FB1TraitReward>
---@field PreferenceRewards TArray<FB1PreferenceReward>
---@field EmotionRewards TArray<FB1EmotionReward>
---@field RelationshipRewards TArray<FB1RelationshipReward>
local FB1InteractionPreferenceReward = {}



---@class FB1InteractionQueueUIData
---@field InteractionBagDtId FName
---@field InteractionQueueId int64
---@field PickedEntityId FB1EntityId
---@field bIsCanceled boolean
---@field StringFormatParameters TMap<FName, FB1InteractionQueueUIStringParameter>
---@field bInsertFront boolean
---@field Reason FString
local FB1InteractionQueueUIData = {}



---@class FB1InteractionQueueUIStringParameter
---@field Name FName
---@field Text FText
local FB1InteractionQueueUIStringParameter = {}



---@class FB1InteractionRepeatInfoTableRow : FB1TableRowBase
---@field ID FName
---@field RepeatLimitCount int64
---@field ResetLimitTime float
---@field BuffId FName
local FB1InteractionRepeatInfoTableRow = {}



---@class FB1InteractionReward
---@field StatId FName
---@field Reward int32
---@field Tier EB1StatServiceTier
local FB1InteractionReward = {}



---@class FB1InteractionSequenceInfo
---@field ID FName
---@field Probability float
---@field bSequencial boolean
---@field EnableConditionId FName
---@field SequenceStartInfos TArray<FB1SequenceStartInfo>
---@field MainInteractionId FName
---@field InteractionInfos TArray<FB1InteractionInfo>
---@field CoopId FName
---@field bIsTalk boolean
---@field NextInteractionBagId FName
local FB1InteractionSequenceInfo = {}



---@class FB1InteractionSlotData
---@field SlotGroupId FName
---@field BodyAge EB1BodyAgeType
---@field RequireSpace boolean
---@field ShowRequireSpace EB1ShowRequireSpaceType
---@field ShowDisabledSlot boolean
---@field EnableOnlyInteractionTags TArray<FName>
---@field SlotOwnershipTag FName
local FB1InteractionSlotData = {}



---@class FB1InteractionTableRow : FB1TableRowBase
---@field ID FName
---@field InteractionTags TArray<FName>
---@field ConditionId FName
---@field InteractionSlotUsage EB1SlotUsageType
---@field EnableSlotTags TArray<FName>
---@field ObjectSlotUsage EB1SlotUsageType
---@field ActionIdList TArray<FName>
---@field InteractionRepeatInfoId FName
---@field FeedbackInteractionBagId FName
---@field FeedbackTarget EB1FeedbackTarget
---@field AutoFindTargetType EB1AutoFindTargetType
---@field AutoFindId FName
---@field AutoFindTargetInfoList TArray<FB1AutoFindTargetInfo>
---@field TargetFilterInfoList TArray<FB1TargetFilterInfo>
---@field TargetFilterFindAll boolean
---@field NoneTargetPlayable boolean
---@field CheckSlotToEntity boolean
---@field EnableOnlyConnectedChairObjectSlot boolean
---@field StartScriptIdList TArray<FName>
---@field CancelScriptIdList TArray<FName>
---@field FinishScriptIdList TArray<FName>
---@field ConsumeCurrencyId FName
---@field ConsumeCurrencyValue int64
local FB1InteractionTableRow = {}



---@class FB1InteractionTagInfo
---@field ListKey FString
---@field TagName FName
---@field NameTextId FString
---@field Icon TSoftObjectPtr<UTexture2D>
local FB1InteractionTagInfo = {}



---@class FB1InventoryEntityInfo
---@field EntityID FB1EntityId
---@field ObjectDtId FName
---@field bHasProgress boolean
---@field progress float
---@field OverrideName FText
---@field OverrideDescription FText
local FB1InventoryEntityInfo = {}



---@class FB1InventoryInfo
---@field InventoryDtId FName
---@field EntityID FB1EntityId
---@field OwnerEntityId FB1EntityId
---@field OwnedEntities TArray<FB1InventoryEntityInfo>
local FB1InventoryInfo = {}



---@class FB1InventoryTableRow : FB1TableRowBase
---@field ID FName
---@field InventoryType EB1InventoryType
---@field MaxCount int32
---@field DisplayName FString
---@field ObjectConditions TArray<FB1Condition>
local FB1InventoryTableRow = {}



---@class FB1JobInfo
---@field JobId FName
---@field Level int32
---@field exp int32
---@field JobType EB1JobType
local FB1JobInfo = {}



---@class FB1JobLevel
---@field Level int32
---@field exp int32
---@field EnterLevelConditions TArray<FB1Condition>
local FB1JobLevel = {}



---@class FB1JobSearchJobData
---@field CompanyDtKey FName
---@field CompanyId FB1EntityId
---@field DepartmentKey FB1DepartmentKey
---@field State EB1ShowRecruitInfoState
local FB1JobSearchJobData = {}



---@class FB1JobTableRow : FB1TableRowBase
---@field ID FName
---@field JobType EB1JobType
---@field DisplayNameTextId FString
---@field RetirementTextId FString
---@field EnterScriptId FName
---@field LeaveScriptId FName
---@field JobPromotions TArray<FName>
---@field Levels TArray<FB1JobLevel>
local FB1JobTableRow = {}



---@class FB1JoyfulDesireBoostData
---@field From float
---@field To float
---@field Value int32
local FB1JoyfulDesireBoostData = {}



---@class FB1KarmaReportInvolvingInfo
---@field BuffId FName
---@field Step int32
---@field CompareType EB1CompareType
---@field InvolvingTextId FString
local FB1KarmaReportInvolvingInfo = {}



---@class FB1KarmaReportMenuTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayNameTextId FString
---@field Icon TSoftObjectPtr<UTexture2D>
---@field MainTabType EB1KarmaReportMenuType
local FB1KarmaReportMenuTableRow = {}



---@class FB1KarmaReportStepAlertTableRow : FB1TableRowBase
---@field ID FName
---@field Step int32
---@field StepCompareType EB1CompareType
---@field CompareType EB1CompareType
---@field Rate float
---@field bNeedAlertMessage boolean
local FB1KarmaReportStepAlertTableRow = {}



---@class FB1KarmaReportZoIInfo
---@field EntityID FB1EntityId
---@field KarmaValue float
---@field bIsGhost boolean
local FB1KarmaReportZoIInfo = {}



---@class FB1KarmaReportZoIInfoList
---@field ZoIInfoList TArray<FB1KarmaReportZoIInfo>
local FB1KarmaReportZoIInfoList = {}



---@class FB1L10NTableRow : FB1TableRowBase
---@field ID FName
---@field CultureNameUnreal FString
---@field CultureNameSteam FString
---@field DiversityCultureList TArray<EB1DiversityCulture>
local FB1L10NTableRow = {}



---@class FB1LadderContext
local FB1LadderContext = {}


---@class FB1LadderObjectSaveData
---@field LadderHeight float
---@field LinkedFloorLevels TArray<int32>
---@field bIsLinkedUpLadder boolean
---@field bIsLinkedDownLadder boolean
---@field SnapFloorLevel int32
---@field SnapPlatformWall int64
---@field AttachedFloor int32
---@field AttachedWall int64
---@field AttachType EB1LadderAttach
---@field DownLadderEntityId FB1EntityId
---@field UpLadderEntityId FB1EntityId
local FB1LadderObjectSaveData = {}



---@class FB1LeaveCompanyCustomMobileMessageInfo
---@field Reason EB1LeaveCompanyReason
---@field LeaveCompanyId FName
local FB1LeaveCompanyCustomMobileMessageInfo = {}



---@class FB1LevelQualityTableRow : FB1TableRowBase
---@field ID FName
---@field QualityWeights TArray<FB1QualityWeight>
local FB1LevelQualityTableRow = {}



---@class FB1LevelSequenceInfo
---@field PlayerGenderType EB1GenderType
---@field TargetGenderType EB1GenderType
---@field LevelSequence FSoftObjectPath
---@field DataLayerPath FName
---@field bCopyOutFit boolean
---@field MaxCinemaCharNum int32
---@field PresetIdList TArray<FName>
---@field StreamingSourceHandleMethod EB1StreamingSourceHandleMethod
---@field bCouldStopWhilePlaying boolean
local FB1LevelSequenceInfo = {}



---@class FB1LevelSequenceInfoList
---@field LevelSequenceInfoList TArray<FB1LevelSequenceInfo>
local FB1LevelSequenceInfoList = {}



---@class FB1LevelUpDisplayInfo
---@field TitleTextId FString
---@field DescTextId FString
local FB1LevelUpDisplayInfo = {}



---@class FB1LifeConditionTableRow : FB1TableRowBase
---@field Conditions TArray<FB1Condition>
local FB1LifeConditionTableRow = {}



---@class FB1LifeScheduleInfo
---@field BeginAge int32
---@field EndAge int32
---@field DayScheduleIdList TArray<FName>
---@field EnterScriptIdList TArray<FName>
local FB1LifeScheduleInfo = {}



---@class FB1LifeScheduleTableRow : FB1TableRowBase
---@field ID FName
---@field ScheduleList TArray<FB1LifeScheduleInfo>
local FB1LifeScheduleTableRow = {}



---@class FB1LifeTriggerDetailData
---@field TriggerStep EB1LifeTriggerStep
---@field TriggerTime int64
local FB1LifeTriggerDetailData = {}



---@class FB1LifeTriggerInfo
---@field AgingConditionFlags int32
---@field AlertPopupId FName
---@field EndPopupId FName
---@field AlertDelayTime float
---@field FromAlertTimeToEnd float
---@field IsDeathTrigger boolean
---@field TriggerInteractionId FName
---@field TriggerScriptId FName
---@field OnDeathScriptId FName
---@field OnDeathSiteActionId FName
local FB1LifeTriggerInfo = {}



---@class FB1LifeTriggerTableRow : FB1TableRowBase
---@field ID FName
---@field LabelTextId FString
---@field TriggerList TArray<FB1LifeTriggerInfo>
local FB1LifeTriggerTableRow = {}



---@class FB1LineCullingTagEntry
---@field Tag FName
---@field Direction FVector2D
---@field Offset FVector2D
local FB1LineCullingTagEntry = {}



---@class FB1LocomotionTableRow : FB1TableRowBase
---@field ID FName
---@field Gender EB1GenderType
---@field AnimGrowthStep EB1AnimGrowthStep
---@field IdleRandomAnims TArray<FB1EmotionRandomAnimationInfo>
---@field WalkStartAnims TMap<EB1Anim_Direction, TSoftObjectPtr<UAnimSequenceBase>>
---@field WalkAnim TSoftObjectPtr<UAnimSequenceBase>
---@field WalkRandomAnims TArray<FB1GrowthRandomAnimationInfo>
---@field WalkSlopeAnims TMap<EB1Anim_Slope, TSoftObjectPtr<UAnimSequenceBase>>
---@field MinWalkLoopCount int32
---@field MaxWalkLoopCount int32
---@field WalkStop_Block TSoftObjectPtr<UAnimSequenceBase>
---@field WalkStop_LF TSoftObjectPtr<UAnimSequenceBase>
---@field WalkStop_RF TSoftObjectPtr<UAnimSequenceBase>
---@field WalkToJog_LF TSoftObjectPtr<UAnimSequenceBase>
---@field WalkToJog_RF TSoftObjectPtr<UAnimSequenceBase>
---@field WalkTurn_LF TMap<EB1Anim_Direction, TSoftObjectPtr<UAnimSequenceBase>>
---@field WalkTurn_RF TMap<EB1Anim_Direction, TSoftObjectPtr<UAnimSequenceBase>>
---@field JogAnim TSoftObjectPtr<UAnimSequenceBase>
---@field JogStartAnims TMap<EB1Anim_Direction, TSoftObjectPtr<UAnimSequenceBase>>
---@field JogStop_Block TSoftObjectPtr<UAnimSequenceBase>
---@field JogStop TSoftObjectPtr<UAnimSequenceBase>
---@field JogToWalk_LF TSoftObjectPtr<UAnimSequenceBase>
---@field JogToWalk_RF TSoftObjectPtr<UAnimSequenceBase>
---@field JogTurn_LF TMap<EB1Anim_Direction, TSoftObjectPtr<UAnimSequenceBase>>
---@field JogTurn_RF TMap<EB1Anim_Direction, TSoftObjectPtr<UAnimSequenceBase>>
---@field TurnStops TMap<EB1Anim_TurnStop, TSoftObjectPtr<UAnimMontage>>
---@field TurnInPlaces TMap<EB1Anim_TurnStop, TSoftObjectPtr<UAnimMontage>>
---@field OneSteps TMap<EB1Anim_OneStep, TSoftObjectPtr<UAnimMontage>>
local FB1LocomotionTableRow = {}



---@class FB1MainRelationshipAutonomyRate
---@field FamilyRate int32
---@field FriendshipRate int32
---@field BusinessRate int32
---@field RomanceRate int32
local FB1MainRelationshipAutonomyRate = {}



---@class FB1MainRelationshipTableRow : FB1TableRowBase
---@field ID FName
---@field bRefresh boolean
---@field FriendshipRate int32
---@field BusinessRate int32
---@field RomanceRate int32
local FB1MainRelationshipTableRow = {}



---@class FB1MakeupChannelDesciption
---@field ColorValues TMap<FName, FLinearColor>
---@field ScalarValues TMap<FName, float>
local FB1MakeupChannelDesciption = {}



---@class FB1MakeupChannelInfo
---@field ListKey FString
---@field MaskChannel EB1MakeupChannel
---@field DescTextId FString
---@field ColorParameters TArray<FB1AppearancePartsColorParameterInfo>
---@field ScalarParameters TArray<FB1AppearancePartsScalarParameterInfo>
local FB1MakeupChannelInfo = {}



---@class FB1MakeupDescription
---@field MakeupId FName
---@field MaskData TMap<EB1MakeupChannel, FB1MakeupChannelDesciption>
---@field MaskTexture UTexture
local FB1MakeupDescription = {}



---@class FB1MapNavigatorMainMenuInfoTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayNameTextId FString
---@field SubMenuList TArray<FB1MapNavigatorSubMenuInfo>
local FB1MapNavigatorMainMenuInfoTableRow = {}



---@class FB1MapNavigatorSubMenuInfo
---@field ListKey FString
---@field MenuType EB1MapNavigatorMenuType
---@field DisplayNameTextId FString
local FB1MapNavigatorSubMenuInfo = {}



---@class FB1MapTableRow : FB1TableRowBase
---@field ID FName
---@field LevelName FName
---@field NameTextId FString
---@field DescriptionTextId FString
---@field CharacterNameFormat EB1CharacterNameFormatType
---@field CurrencyId FName
---@field MapImg TSoftObjectPtr<UObject>
---@field bRelease boolean
---@field EducationDtId FName
---@field bBuildWorld boolean
local FB1MapTableRow = {}



---@class FB1MarketSellingTableRow : FB1TableRowBase
---@field ID FName
---@field StartSellTime int32
---@field EndSellTime int32
---@field SellTimeCount int32
---@field InitialSellPercentage float
---@field SellPercentageToAdd float
local FB1MarketSellingTableRow = {}



---@class FB1MaskObjectTableRow : FB1TableRowBase
---@field ID FName
---@field MaskTexture TSoftObjectPtr<UTexture>
local FB1MaskObjectTableRow = {}



---@class FB1MaterialParamMappingTableRow : FB1TableRowBase
---@field ID FName
---@field ParamType EB1MaterialParamType
---@field MeshName FName
---@field LayerIndex float
---@field ParamName FName
---@field ValueString FString
local FB1MaterialParamMappingTableRow = {}



---@class FB1MaterialTableRow : FB1TableRowBase
---@field ID FName
---@field MaterialInterface TSoftObjectPtr<UMaterialInterface>
local FB1MaterialTableRow = {}



---@class FB1MeetingRuleData
---@field Conditions TArray<FB1Condition>
---@field RandomApplySiteTags TArray<FName>
---@field ApplyHostTimelineId FName
---@field ApplyGuestTimelineId FName
---@field ApplyScriptId FName
local FB1MeetingRuleData = {}



---@class FB1MeetingTableRow : FB1TableRowBase
---@field ID FName
---@field AgingConditionFlags int32
---@field MeetingRules TArray<FB1MeetingRuleData>
local FB1MeetingTableRow = {}



---@class FB1MeshReplaceSelectionData
---@field GroupId FName
---@field ID FName
---@field MyGalleryPathKey FString
---@field DecorationId FName
---@field bIsMultiSelectable boolean
local FB1MeshReplaceSelectionData = {}



---@class FB1MeshReplaceSelectionDataList
---@field SelectionDataList TArray<FB1MeshReplaceSelectionData>
local FB1MeshReplaceSelectionDataList = {}



---@class FB1MeshReplaceSelectionList
---@field MeshReplaceSelectionList TMap<FName, FB1MeshReplaceSelectionDataList>
local FB1MeshReplaceSelectionList = {}



---@class FB1MeshSpawnDescription
---@field ReservedMeshPath FSoftObjectPath
---@field Rotate float
---@field Extent FVector
---@field Offset FVector
local FB1MeshSpawnDescription = {}



---@class FB1MeshSpawnTagTableRow : FB1TableRowBase
---@field ID FName
---@field DefaultMeshId FName
---@field MeshDescriptionIds TMap<FName, FName>
local FB1MeshSpawnTagTableRow = {}



---@class FB1MessageSetting
---@field Theme FName
---@field IconR UTexture2D
---@field IconL UTexture2D
---@field IconCaution UTexture2D
---@field bIsCaution boolean
---@field LinkUI EB1UIType
---@field Title FString
---@field Desc FString
---@field Link FString
local FB1MessageSetting = {}



---@class FB1MetricCategory
---@field Category FName
---@field SubCategory FName
local FB1MetricCategory = {}



---@class FB1MetricInfo
---@field MetricCategory FB1MetricCategory
local FB1MetricInfo = {}



---@class FB1MetricMap
---@field Map TMap<FB1MetricCategory, FB1MetricInfo>
local FB1MetricMap = {}



---@class FB1MissionConditionData
---@field ConditionType EB1MissionCondition
---@field GoalCount int32
---@field ConditionId1 FName
---@field ConditionId2 FName
---@field ConditionInt int32
---@field DescTextId FString
local FB1MissionConditionData = {}



---@class FB1MissionConditionState
---@field ConditionType EB1MissionCondition
---@field CurrentCount int64
---@field GoalCount int64
local FB1MissionConditionState = {}



---@class FB1MissionConditionTrigger
---@field bIsAdd boolean
---@field MissionId FB1MissionId
---@field Count int64
---@field CondData FB1MissionConditionData
local FB1MissionConditionTrigger = {}



---@class FB1MissionCountMap
---@field MissionCountMap TMap<FB1MissionId, int32>
local FB1MissionCountMap = {}



---@class FB1MissionId
---@field Value int64
local FB1MissionId = {}



---@class FB1MissionRecorder
---@field MissionTable TMap<FB1MissionConditionData, int64>
local FB1MissionRecorder = {}



---@class FB1MissionState
---@field MissionType EB1MissionType
---@field MissionTypeId FName
---@field MissionDtId FName
---@field ConditionStates TArray<FB1MissionConditionState>
---@field bIsActive boolean
---@field bIsFinished boolean
local FB1MissionState = {}



---@class FB1MissionTableRow : FB1TableRowBase
---@field ID FName
---@field Conditions TArray<FB1MissionConditionData>
local FB1MissionTableRow = {}



---@class FB1MobileMessage
---@field MessageId FString
---@field MessageText FText
---@field bIsSend boolean
---@field bNeedResponse boolean
---@field bNeedResponseReply boolean
---@field bIsRead boolean
---@field bIsPlainText boolean
---@field bIsWait boolean
---@field WaitScriptId FName
---@field DelayTime float
---@field RelationshipStatId FName
---@field RelationShipPoint float
---@field Timestamp FDateTime
---@field ResponseTimeout int32
---@field OpenScriptId FName
---@field PoolId FName
---@field CustomResponse FB1MobileMessageCustomResponse
---@field bIsNeedConvertMessage boolean
local FB1MobileMessage = {}



---@class FB1MobileMessageConditionTableRow : FB1TableRowBase
---@field Conditions TArray<FB1Condition>
local FB1MobileMessageConditionTableRow = {}



---@class FB1MobileMessageCooltimeMap
---@field MobileMessageCooltimeMap TMap<FName, int64>
local FB1MobileMessageCooltimeMap = {}



---@class FB1MobileMessageCustomResponse
---@field DtId FName
---@field PositiveAnswerStrId FString
---@field NormalAnswerStrId FString
---@field NegativeAnswerStrId FString
---@field PositiveReplyStrId FString
---@field NormalReplyStrId FString
---@field NegativeReplyStrId FString
---@field OpenScriptId FName
---@field RelationshipStatId FName
---@field bHasOverrideSchedule boolean
---@field bSyncTimelineStartTimeWithResponseTime boolean
---@field OverrideTimeline FB1Timeline
---@field ResponseTimeout int32
---@field bIsNeedConvertMessage boolean
local FB1MobileMessageCustomResponse = {}



---@class FB1MobileMessageData
---@field ListKey FString
---@field MessageStrId FString
---@field PositiveAnswerStrId FString
---@field NormalAnswerStrId FString
---@field NegativeAnswerStrId FString
---@field PositiveAnswerReplyStrId FString
---@field NormalAnswerReplyStrId FString
---@field NegativeAnswerReplyStrId FString
---@field bIsNeedConvertMessage boolean
local FB1MobileMessageData = {}



---@class FB1MobileMessageDelayInfo
---@field DelayProbability float
---@field IsWeekday boolean
---@field IsWeekend boolean
---@field DayOfWeek EB1DayOfWeek
---@field DelayDate int32
---@field StartTime int32
---@field AddOffsetTime int32
---@field EndTime int32
local FB1MobileMessageDelayInfo = {}



---@class FB1MobileMessageList
---@field MobileMessageList TArray<FB1MobileMessage>
---@field LastMessagePoolId FName
---@field CustomResponse FB1MobileMessageCustomResponse
local FB1MobileMessageList = {}



---@class FB1MobileMessageListBySystemMap
---@field MobileMessageListMap TMap<FName, FB1MobileMessageList>
local FB1MobileMessageListBySystemMap = {}



---@class FB1MobileMessageListMap
---@field MobileMessageListMap TMap<FB1EntityId, FB1MobileMessageList>
local FB1MobileMessageListMap = {}



---@class FB1MobileMessagePartiesData
---@field BaseObject EB1MobileMessageBaseObject
---@field Conditions TArray<FB1Condition>
local FB1MobileMessagePartiesData = {}



---@class FB1MobileMessagePartiesResult
---@field SenderSystemId FName
---@field SenderId FB1EntityId
---@field ReceiverId FB1EntityId
local FB1MobileMessagePartiesResult = {}



---@class FB1MobileMessagePartiesTableRow : FB1TableRowBase
---@field ID FName
---@field Sender FB1MobileMessagePartiesData
---@field Receiver FB1MobileMessagePartiesData
local FB1MobileMessagePartiesTableRow = {}



---@class FB1MobileMessageRewardTableRow : FB1TableRowBase
---@field ID FName
---@field PositivePoint float
---@field NormalPoint float
---@field NegativePoint float
local FB1MobileMessageRewardTableRow = {}



---@class FB1MobileMessageSystemData
---@field ListKey FString
---@field MapId FName
---@field DisplayNameTextId FString
---@field IconTexture TSoftObjectPtr<UTexture2D>
local FB1MobileMessageSystemData = {}



---@class FB1MobileMessageSystemTableRow : FB1TableRowBase
---@field ID FName
---@field Systems TArray<FB1MobileMessageSystemData>
local FB1MobileMessageSystemTableRow = {}



---@class FB1MobileMessageTableRow : FB1TableRowBase
---@field ID FName
---@field RelationshipStatId FName
---@field ConditionId FName
---@field PositiveAnswerButtonStrId FString
---@field NormalAnswerButtonStrId FString
---@field NegativeAnswerButtonStrId FString
---@field OpenMessageScript FName
---@field PositiveAnswerScriptId FName
---@field NormalAnswerScriptId FName
---@field NegativeAnswerScriptId FName
---@field MessageStrIdList TArray<FB1MobileMessageData>
local FB1MobileMessageTableRow = {}



---@class FB1ModifierSettingData
---@field ModifierType EB1ModifierType
---@field ModifierKey FName
---@field ModifierCalcType EB1ModifierOperationType
---@field Value float
local FB1ModifierSettingData = {}



---@class FB1ModifierTableRow : FB1TableRowBase
---@field ID FName
---@field ModifierList TArray<FB1ModifierSettingData>
local FB1ModifierTableRow = {}



---@class FB1MontageTableRow : FB1TableRowBase
---@field ID FName
---@field GroupName FName
---@field TotalPlayLength float
---@field LoopPlayLength float
---@field RateScale float
---@field BlendOutTime float
---@field bHasRootAnim boolean
---@field Sections TArray<FB1AnimSection>
---@field AnimTracks TArray<FB1AnimTrack>
local FB1MontageTableRow = {}



---@class FB1MouseCursorConfig
---@field CursorEdgeScrollAreaSizeX float
---@field CursorEdgeScrollAreaSizeY float
---@field CursorEdgeScrollSpeed float
local FB1MouseCursorConfig = {}



---@class FB1MoveTogetherVM
local FB1MoveTogetherVM = {}


---@class FB1NameData
---@field ListKey FString
---@field Gender EB1GenderType
---@field DisplayNameTextId FString
local FB1NameData = {}



---@class FB1NavigationNode
---@field Point FVector
---@field Forward FVector
---@field Right FVector
---@field Type EB1NavigationNodeType
---@field HorizontalOffset float
---@field LaneKey FB1CityGraphLaneKey
---@field TargetEntityId FB1EntityId
local FB1NavigationNode = {}



---@class FB1ObjectBPComponentData
---@field ComponentName FName
---@field ComponentClassName FName
---@field AttachParentName FName
---@field AttachSocketName FName
---@field PropertyMetaDatas TMap<FName, FString>
local FB1ObjectBPComponentData = {}



---@class FB1ObjectBpSlotData
---@field ComponentName FName
---@field SlotName FName
---@field Location FVector
---@field Rotation FRotator
---@field SlotComponentData FB1SlotComponentData
local FB1ObjectBpSlotData = {}



---@class FB1ObjectBpTableRow : FB1TableRowBase
---@field ID FName
---@field ParentClass FName
---@field BoxOriginOffset FVector
---@field Size FVector
---@field SlotComponents TArray<FB1ObjectBpSlotData>
---@field ComponentDatas TArray<FB1ObjectBPComponentData>
---@field DetailType EB2GameObjectDetailType
---@field EntranceTransform FTransform
---@field ExitTransform FTransform
local FB1ObjectBpTableRow = {}



---@class FB1ObjectCategoryEntry
---@field ListKey FString
---@field Category FName
---@field CategoryName FText
---@field Icon TSoftObjectPtr<UObject>
---@field TooltipTexture TSoftObjectPtr<UObject>
---@field DevOnly boolean
---@field VisibleButton boolean
---@field WidgetIndex int32
---@field MiddleCategories TArray<FB1ObjectMiddleCategoryEntry>
local FB1ObjectCategoryEntry = {}



---@class FB1ObjectCategoryTableRow : FB1TableRowBase
---@field ID FName
---@field Mode FName
---@field Categories TArray<FB1ObjectCategoryEntry>
local FB1ObjectCategoryTableRow = {}



---@class FB1ObjectChangeActorGroupParam : FB1TableRowBase
---@field ActorName FName
---@field ActorIcon TSoftObjectPtr<UObject>
local FB1ObjectChangeActorGroupParam = {}



---@class FB1ObjectChangeActorGroupRow : FB1TableRowBase
---@field ID FName
---@field Actors TArray<FB1ObjectChangeActorGroupParam>
local FB1ObjectChangeActorGroupRow = {}



---@class FB1ObjectChangeMaterialGroupRow : FB1TableRowBase
---@field GroupName FName
---@field ChangeParam TArray<FB1GameObjectChangeMaterialParam>
local FB1ObjectChangeMaterialGroupRow = {}



---@class FB1ObjectChangeMeshGroupRow : FB1TableRowBase
---@field GroupName FName
---@field DisplayName FName
---@field Icon TSoftObjectPtr<UObject>
---@field OverrideParam boolean
---@field ParamUsageId FName
---@field ChangeParam TArray<FB1GameObjectChangeMeshParam>
local FB1ObjectChangeMeshGroupRow = {}



---@class FB1ObjectConditionTableRow : FB1TableRowBase
---@field ID FName
---@field EnableConditions TArray<FB1Condition>
local FB1ObjectConditionTableRow = {}



---@class FB1ObjectCustomizeMaterialGroupRow : FB1TableRowBase
---@field GroupName FName
---@field LayerParam TArray<FB1GameObjectMaterialLayerParam>
local FB1ObjectCustomizeMaterialGroupRow = {}



---@class FB1ObjectCustomizeMaterialPartsRow : FB1TableRowBase
---@field Parts TArray<FB1ObjectPartsDefinition>
---@field ChangeActorId FName
local FB1ObjectCustomizeMaterialPartsRow = {}



---@class FB1ObjectCustomizeSaveData
---@field Index int32
---@field Int32Map TMap<FName, int32>
---@field Int64Map TMap<FName, int64>
---@field FloatMap TMap<FName, float>
---@field ColorMap TMap<FName, FLinearColor>
---@field StringMap TMap<FName, FString>
local FB1ObjectCustomizeSaveData = {}



---@class FB1ObjectCustomizeShapeParts
---@field PartsId FName
---@field Asset TSoftObjectPtr<UStaticMesh>
---@field Icon TSoftObjectPtr<UObject>
local FB1ObjectCustomizeShapeParts = {}



---@class FB1ObjectCustomizeShapeTemplatesRow : FB1TableRowBase
---@field TemplateName FName
---@field Icon TSoftObjectPtr<UObject>
---@field OffsetX float
---@field OffsetY float
---@field OffsetZ float
---@field RotationZ float
---@field CamDistance float
---@field Template TSoftObjectPtr<UBlueprint>
---@field PartsName00 FName
---@field PartsTag00 FName
---@field Parts00 TArray<FB1ObjectCustomizeShapeParts>
---@field PartsName01 FName
---@field PartsTag01 FName
---@field Parts01 TArray<FB1ObjectCustomizeShapeParts>
---@field PartsName02 FName
---@field PartsTag02 FName
---@field Parts02 TArray<FB1ObjectCustomizeShapeParts>
local FB1ObjectCustomizeShapeTemplatesRow = {}



---@class FB1ObjectDataFilterRow : FB1TableRowBase
---@field ID FName
---@field Tags TArray<FName>
local FB1ObjectDataFilterRow = {}



---@class FB1ObjectDepreciationInfo
---@field StateGroupId FName
---@field Rate float
local FB1ObjectDepreciationInfo = {}



---@class FB1ObjectFilterCategoryEntry
---@field ListKey FString
---@field Category FName
---@field CategoryName FText
---@field SubCategories TArray<FB1ObjectSubCategoryEntry>
local FB1ObjectFilterCategoryEntry = {}



---@class FB1ObjectFilterCategoryTableRow : FB1TableRowBase
---@field ID FName
---@field Mode FName
---@field Categories TArray<FB1ObjectFilterCategoryEntry>
local FB1ObjectFilterCategoryTableRow = {}



---@class FB1ObjectMiddleCategoryEntry
---@field ListKey FString
---@field WBPName FName
---@field CategoryName FText
---@field CanvasKey FString
---@field SubCategories TArray<FB1ObjectSubCategoryEntry>
local FB1ObjectMiddleCategoryEntry = {}



---@class FB1ObjectPartsCustomUsageRow : FB1TableRowBase
---@field UsableAITexture boolean
---@field UsableImportedTexture boolean
---@field MeshGroups TArray<FName>
---@field MaterialChangeGroups TArray<FName>
---@field MaterialGroups TArray<FName>
local FB1ObjectPartsCustomUsageRow = {}



---@class FB1ObjectPartsDefinition
---@field ListKey FString
---@field PartsCategory FName
---@field PartsName FName
---@field Description TArray<FB1ObjectPartsDescription>
---@field ParamUsageId FName
---@field CustomUsageId FName
local FB1ObjectPartsDefinition = {}



---@class FB1ObjectPartsDescription
---@field MeshName FString
---@field MaterialSlot int32
---@field LayerIndex int32
local FB1ObjectPartsDescription = {}



---@class FB1ObjectPartsOverride
---@field ListKey FString
---@field PartsName FName
---@field PartsCategory FName
---@field Description TArray<FB1ObjectPartsDescription>
---@field ParamUsageId FName
local FB1ObjectPartsOverride = {}



---@class FB1ObjectPartsParamUsageRow : FB1TableRowBase
---@field UseAlbedoColor boolean
---@field AlbedoColor FString
---@field UseEmisColor boolean
---@field EmisColor FString
---@field UseRoughness boolean
---@field RoughnessMin float
---@field Roughness float
---@field RoughnessMax float
---@field UseEmissiveMulti boolean
---@field EmissiveMultiMin float
---@field EmissiveMulti float
---@field EmissiveMultiMax float
---@field UseSpecular boolean
---@field SpecularMin float
---@field Specular float
---@field SpecularMax float
---@field UseMetallic boolean
---@field MetallicMin float
---@field Metallic float
---@field MetallicMax float
---@field UseOpacity boolean
---@field Opacity float
---@field UseScale boolean
---@field ScaleMin float
---@field ScaleMax float
---@field UseOffsetX boolean
---@field UseOffsetY boolean
---@field UseMirrorUV boolean
local FB1ObjectPartsParamUsageRow = {}



---@class FB1ObjectPopUpDescriptionTableRow : FB1TableRowBase
---@field ID FName
---@field ShowState boolean
---@field ShowTimeToChange boolean
---@field ShowTimeToChangeStatName FName
local FB1ObjectPopUpDescriptionTableRow = {}



---@class FB1ObjectSelectionSetTableRow : FB1TableRowBase
---@field ID FName
---@field SelectionSets TArray<FB1SelectionSet>
---@field IsDisplayObjectString boolean
local FB1ObjectSelectionSetTableRow = {}



---@class FB1ObjectSlotData
---@field HideParentMesh boolean
---@field UseMaskedParentMesh boolean
---@field MaskParameterName FName
---@field BasicTexture UTexture
local FB1ObjectSlotData = {}



---@class FB1ObjectSlotTableRow : FB1TableRowBase
---@field ID FName
---@field EnableObjectCategories TArray<FName>
---@field DisableCondition FB1DisableSlotCondition
---@field StartOccupyScriptId FName
---@field EndOccupyScriptId FName
---@field AllowOverlap boolean
---@field OccupiableOverlap boolean
local FB1ObjectSlotTableRow = {}



---@class FB1ObjectSubCategoryEntry
---@field ListKey FString
---@field Category FName
---@field CategoryName FText
---@field CanvasKey FString
---@field Icon TSoftObjectPtr<UTexture2D>
---@field DevOnly boolean
---@field StudioOnly boolean
local FB1ObjectSubCategoryEntry = {}



---@class FB1ObjectTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayNameTextId FString
---@field DescriptionTextId FString
---@field StateVariationId FName
---@field ObjectTemplateId FName
---@field ObjectCategory FName
---@field FilterCategory FName
---@field Asset TSoftObjectPtr<UBlueprint>
---@field AssetTableId FName
---@field DevOnly boolean
---@field Icon TSoftObjectPtr<UObject>
---@field ObjectFilterTags TArray<FName>
---@field ObjectTags TArray<FName>
---@field InitialStatId TArray<FName>
---@field AvailableStatId TArray<FName>
---@field ConditionId FName
---@field MaskObjectId FName
---@field Quality int32
---@field Weight int32
---@field InventoryCount uint8
---@field ObjectSoundNotifyId FName
---@field GrabDtId FName
---@field TaxId FName
---@field ObjectWeatheringGroupId FName
---@field PopUpDescriptionId FName
---@field Price int64
local FB1ObjectTableRow = {}



---@class FB1ObjectTemplateTableRow : FB1TableRowBase
---@field ID FName
---@field Asset TSoftObjectPtr<UBlueprint>
---@field ObjectSelectionSetId FName
---@field ObjectWeatheringGroupId FName
---@field IsWettable boolean
---@field CustomizeType EB1ObjectCustomizeType
---@field IsCarriable boolean
---@field AttachScriptId FName
---@field DetachScriptId FName
---@field PlacementFlags int32
---@field FollowSlotRotation boolean
---@field IsDerived boolean
---@field ObjectTags TArray<FName>
---@field PlacementGuideTextId FString
---@field OwnershipCategory FName
---@field bDisableTakeOutOfInventory boolean
---@field bCanInteractInInventory boolean
---@field IgnoreSlotToEntityCheck boolean
---@field InventroyInteractionBagId FName
local FB1ObjectTemplateTableRow = {}



---@class FB1ObjectWeatheringInfo
---@field Grade int32
---@field WeatheringIntensity float
---@field NextGradeDay int32
---@field NextGradeDayRandomOffset int32
---@field PriceDepreciation float
---@field ModifierObjectWeatheringId FName
local FB1ObjectWeatheringInfo = {}



---@class FB1ObjectWeatheringTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayNameTextId FString
---@field WeatheringInfos TArray<FB1ObjectWeatheringInfo>
local FB1ObjectWeatheringTableRow = {}



---@class FB1OneTimePostureAnimTableRow : FB1TableRowBase
---@field ID FName
---@field PostureAnimList TArray<FB1OverridePostureAnim>
local FB1OneTimePostureAnimTableRow = {}



---@class FB1Order : FB1TimelineRange
---@field InteractionBagId FName
---@field StatId FName
---@field TargetStatInteractionId FName
---@field TargetSiteId FName
---@field Type EB1OrderType
---@field bIsTimeFlexible boolean
---@field RandomOrderInteraction TArray<FB1RandomOrderInteraction>
---@field RandomInteractionPickIndex int32
local FB1Order = {}



---@class FB1OrganizationInfo
---@field ListKey FString
---@field JobId FName
---@field DisplayName FString
---@field IsFixedDesk boolean
---@field RetireAgeStep EB1GrowthStep
---@field RandomRetireProbability float
---@field CompanyProfile TSoftObjectPtr<UTexture2D>
---@field IntroductionImage TSoftObjectPtr<UTexture2D>
---@field Icon TSoftObjectPtr<UTexture2D>
---@field CustomMobileMessages FB1CompanyCustomMobileMessageInfo
---@field bRabbitHoleWork boolean
---@field RankList TArray<FB1OrganizationRank>
local FB1OrganizationInfo = {}



---@class FB1OrganizationRank
---@field ListKey FString
---@field Rank int32
---@field JobLevel int32
---@field RankName FString
---@field RankDesc FString
---@field HiddenFromUI boolean
---@field RankConditionId FName
---@field RankModifierId FName
---@field EmploymentForm EB1EmploymentForm
---@field SeatGroupObjectCategories TArray<FName>
---@field shift TArray<FB1WorkShift>
local FB1OrganizationRank = {}



---@class FB1OutfitSetting
---@field CostumeId FName
---@field Garments TMap<FName, FB1GarmentDescription>
---@field Accessories TMap<FName, FB1AccessoryDescription>
---@field PrintedAccessories TArray<FB1PrintedAccessoryDescription>
---@field OutfitCategory EB1OutfitCategory
---@field Reason EB1ChangeOutfitReason
local FB1OutfitSetting = {}



---@class FB1OverrideBaseObjectTableRow : FB1TableRowBase
---@field ID FName
---@field BaseObject EB1OverrideBaseObject
---@field Conditions TArray<FB1Condition>
local FB1OverrideBaseObjectTableRow = {}



---@class FB1OverridePostureAnim
---@field PrevPosture FB1OverridePostureState
---@field NextPosture FB1OverridePostureState
---@field OverrideAnimInfo FB1OverridePostureAnimInfo
local FB1OverridePostureAnim = {}



---@class FB1OverridePostureAnimInfo
---@field AnimId FName
---@field SectionName FName
local FB1OverridePostureAnimInfo = {}



---@class FB1OverridePostureState
---@field PostureId FName
---@field SlotDirection EB1SlotDirection
local FB1OverridePostureState = {}



---@class FB1PacketInitSiteInfo
---@field EntityID FB1EntityId
---@field OwnerHouseholdEntityId FB1EntityId
---@field BuiltData FB1SiteAreaBuiltSaveData
---@field WorldLocation FVector
---@field WorldRotation FRotator
---@field Scale FVector
---@field PathFindingData FB1SiteAreaPathFindingSaveData
local FB1PacketInitSiteInfo = {}



---@class FB1PathFindGridBitArray
---@field CollisionBitArray TArray<uint64>
---@field BitsWidths int32
---@field WordWidths int32
---@field Width int32
---@field Depth int32
local FB1PathFindGridBitArray = {}



---@class FB1PathFindGridData
---@field State EB1GridState
---@field FloorHeight float
---@field CeilHeight float
---@field ZoneIndex int32
---@field SafetySquareSpace int32
---@field bIsChangeableAtSimulation boolean
---@field bIsWall boolean
local FB1PathFindGridData = {}



---@class FB1PathFindGroup
---@field Sites TSet<FName>
local FB1PathFindGroup = {}



---@class FB1PathFindNode
local FB1PathFindNode = {}


---@class FB1Perspective
---@field Value float
---@field CoolTimePerReason TMap<FName, FDateTime>
---@field UpdateTime FDateTime
local FB1Perspective = {}



---@class FB1PerspectiveCategory : FB1TableRowBase
---@field ID FName
---@field Probability float
---@field Cooltime float
local FB1PerspectiveCategory = {}



---@class FB1PerspectiveDisplayInfo
---@field PerspectiveId FName
---@field TraitValueNameTextId FString
---@field JoyCardDescTextId FString
---@field MainPopUpDescTextId FString
---@field InfoTooltipDescTextId FString
local FB1PerspectiveDisplayInfo = {}



---@class FB1PerspectiveDisplayInfoGroupTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayInfo TArray<FB1PerspectiveDisplayInfo>
local FB1PerspectiveDisplayInfoGroupTableRow = {}



---@class FB1PerspectiveDisplayInfoMappingTableRow : FB1TableRowBase
---@field ID FName
---@field PerspectiveDisplayInfoGroupId FName
local FB1PerspectiveDisplayInfoMappingTableRow = {}



---@class FB1PhotoModeCameraOptionSetting
---@field OptionType EB1PhotoModeCameraOptionSettingType
---@field UIType EB1GameOptionUIType
---@field Name FString
---@field SliderUnitText FText
---@field InitSliderValue int32
---@field MaxSliderValue int32
---@field MinSliderValue int32
local FB1PhotoModeCameraOptionSetting = {}



---@class FB1PhotoModeCropOptionSetting
---@field Name FString
---@field CropOptionType EB1PhotoModeCameraCropOption
---@field ImageSize FVector2D
local FB1PhotoModeCropOptionSetting = {}



---@class FB1PillarObjectSaveData
---@field PillarHeight float
local FB1PillarObjectSaveData = {}



---@class FB1PlayAnimCondition
---@field Type EB1PlayAnimConditionType
---@field Var FString
---@field GameObjectAnimId FName
local FB1PlayAnimCondition = {}



---@class FB1PlayAnimInfo
---@field GameObjectAnimId FName
---@field TargetGameObjectType EB1TargetObjectType
---@field AnimStartSection EB1LoopAnimSection
---@field CharacterAnimId FName
---@field bForcePlayAnim boolean
---@field Conditions TArray<FB1PlayAnimCondition>
local FB1PlayAnimInfo = {}



---@class FB1PlayStaticAnimInfo
---@field StaticMeshAnimId FName
local FB1PlayStaticAnimInfo = {}



---@class FB1PlayerProfileData
---@field UIType EB1UIType
---@field Image_Button TSoftObjectPtr<UTexture2D>
---@field ButtonTextId FString
---@field TooltipStringId FString
---@field AnimationNameWhenHovered FName
---@field CatAlertTitleTextId FString
---@field CatAlertContentTextId FString
---@field CatAlertLifeTimeSec float
---@field LinkTextStringId FString
---@field LinkUIType EB1UIType
---@field UnableToolTipTextIdList TMap<FName, FString>
local FB1PlayerProfileData = {}



---@class FB1PlayerSpawnParameter
local FB1PlayerSpawnParameter = {}


---@class FB1PocketMarketGradeData
---@field FollowerCut int32
---@field SellCountToAdd int32
---@field GradeUpRewardScriptId FName
---@field GradeIcon TSoftObjectPtr<UObject>
local FB1PocketMarketGradeData = {}



---@class FB1PocketMarketGradeInfo
---@field Followers int32
---@field Grade EB1PocketMarketGrade
local FB1PocketMarketGradeInfo = {}



---@class FB1PocketMarketPurchasedShoppingItem
---@field Icon TSoftObjectPtr<UObject>
local FB1PocketMarketPurchasedShoppingItem = {}



---@class FB1PocketMarketPurchasedShoppingItemVM
---@field Icon TSoftObjectPtr<UObject>
local FB1PocketMarketPurchasedShoppingItemVM = {}



---@class FB1PocketMarketQualityPriceRatioRange
---@field Min float
---@field Max float
local FB1PocketMarketQualityPriceRatioRange = {}



---@class FB1PocketMarketSellItem
local FB1PocketMarketSellItem = {}


---@class FB1PocketMarketSellItemVM
local FB1PocketMarketSellItemVM = {}


---@class FB1PocketMarketSellWidgetVM
---@field Icon TSoftObjectPtr<UObject>
local FB1PocketMarketSellWidgetVM = {}



---@class FB1PocketMarketShoppingCategoryTableRow : FB1TableRowBase
---@field ID FName
---@field DiscountId FName
---@field TitleTextId FString
---@field SubTitleTextId FString
---@field ItemSubTitleTextId FString
---@field Icon TSoftObjectPtr<UObject>
---@field TabType EB1PocketMarketTabType
---@field ItemDatas TArray<FB1PocketMarketShoppingItemData>
local FB1PocketMarketShoppingCategoryTableRow = {}



---@class FB1PocketMarketShoppingDiscountData
---@field Count int32
---@field DiscountPercentage float
local FB1PocketMarketShoppingDiscountData = {}



---@class FB1PocketMarketShoppingDiscountTableRow : FB1TableRowBase
---@field ID FName
---@field ConditionId FName
---@field Discounts TArray<FB1PocketMarketShoppingDiscountData>
local FB1PocketMarketShoppingDiscountTableRow = {}



---@class FB1PocketMarketShoppingItem
local FB1PocketMarketShoppingItem = {}


---@class FB1PocketMarketShoppingItemData
---@field ID FName
---@field bIsService boolean
---@field CarriableObjectType EB1CarriableObjectType
---@field ServicePrice int64
---@field GiftBoxObjectId FName
---@field ConditionId FName
---@field OverrideTextId FString
---@field OverrideIcon TSoftObjectPtr<UObject>
---@field Count int32
local FB1PocketMarketShoppingItemData = {}



---@class FB1PocketMarketShoppingItemVM
---@field Icon TSoftObjectPtr<UObject>
local FB1PocketMarketShoppingItemVM = {}



---@class FB1PocketMarketShoppingItemsWrapper
local FB1PocketMarketShoppingItemsWrapper = {}


---@class FB1Polygon2SaveData
---@field Vertices TArray<FVector2D>
local FB1Polygon2SaveData = {}



---@class FB1PopupButtonDetail
---@field ListKey FString
---@field ButtonText FString
---@field ButtonType FName
---@field ScriptId FName
---@field MinDesiredWidth float
---@field MaxDesiredWidth float
---@field Height float
local FB1PopupButtonDetail = {}



---@class FB1PopupConstructData
---@field Icon TSoftObjectPtr<UObject>
---@field Portrait TSoftObjectPtr<UObject>
---@field PanelBackground TSoftObjectPtr<UObject>
---@field bUseConfettiAnim boolean
---@field TitleTextColor FLinearColor
---@field DescTextColor FLinearColor
---@field bGameTimePausedWhileActive boolean
local FB1PopupConstructData = {}



---@class FB1PopupTableRow : FB1TableRowBase
---@field ID FName
---@field PopupType EB1PopupType
---@field DetailType FName
---@field Title FString
---@field Desc FString
---@field OpenPlayAudioId FName
---@field bUseLoadButton boolean
---@field bDisableAutoCloseTimer boolean
---@field ButtonDetail TArray<FB1PopupButtonDetail>
local FB1PopupTableRow = {}



---@class FB1PortalData
---@field SitePortalLocation FVector
---@field SitePortalRotation FRotator
---@field OtherPortalLocation FVector
---@field OtherPortalRotation FRotator
local FB1PortalData = {}



---@class FB1PoseAnimationInfo
---@field CapturePoseAnims TMap<FName, TSoftObjectPtr<UAnimationAsset>>
local FB1PoseAnimationInfo = {}



---@class FB1PostProcessMaterialDefine
---@field CustomPostProcessMaterialInst TSoftObjectPtr<UMaterialInstance>
---@field CustomPPCurve UCurveFloat
local FB1PostProcessMaterialDefine = {}



---@class FB1PostSpawnParameter
---@field PostNames TArray<FName>
---@field PostFloats TArray<float>
---@field PostInt64s TArray<int64>
local FB1PostSpawnParameter = {}



---@class FB1PostSpawnParameter_AddFamilyByCheat
local FB1PostSpawnParameter_AddFamilyByCheat = {}


---@class FB1PostSpawnParameter_Baby
local FB1PostSpawnParameter_Baby = {}


---@class FB1PostSpawnParameter_CompanyRoleNpc
local FB1PostSpawnParameter_CompanyRoleNpc = {}


---@class FB1PostSpawnParameter_Household
local FB1PostSpawnParameter_Household = {}


---@class FB1PostSpawnParameter_Schedule
local FB1PostSpawnParameter_Schedule = {}


---@class FB1PostureAnimInfo
---@field PostureType FName
---@field DirectionInfos TArray<FB1PostureDirectionInfo>
local FB1PostureAnimInfo = {}



---@class FB1PostureDirectionInfo
---@field Direction EB1SlotDirection
---@field PostureAnimId FName
local FB1PostureDirectionInfo = {}



---@class FB1PostureState
---@field PostureId FName
---@field PostureType EB1PostureType
---@field Direction EB1SlotDirection
---@field PostureTargetEntityId FB1EntityId
---@field OccupyingSlot FName
local FB1PostureState = {}



---@class FB1PostureTableRow : FB1TableRowBase
---@field ID FName
---@field PostureType EB1PostureType
---@field DirectionInfos TArray<FB1PostureDirectionInfo>
---@field StartScriptId FName
---@field EndScriptId FName
local FB1PostureTableRow = {}



---@class FB1PostureTransition
---@field FromPostureId FName
---@field SlotDirection EB1SlotDirection
---@field TransitionInAnimation TSoftObjectPtr<UAnimMontage>
local FB1PostureTransition = {}



---@class FB1PreferenceBuffData
---@field BuffId FName
---@field bLike boolean
---@field InteractingFacialExpressionId FName
local FB1PreferenceBuffData = {}



---@class FB1PreferenceDisplayInfo
---@field DisplayCategoryTextId FString
---@field DisplayNameTextId FString
---@field Icon TSoftObjectPtr<UObject>
local FB1PreferenceDisplayInfo = {}



---@class FB1PreferenceRelatedTraitTableRow : FB1TableRowBase
---@field ID FName
---@field MaxSelectCount int32
---@field PreferenceList TArray<FB1PreferenceSelectData>
local FB1PreferenceRelatedTraitTableRow = {}



---@class FB1PreferenceReward
---@field PreferenceId FName
---@field IsLike boolean
---@field Bonus int32
local FB1PreferenceReward = {}



---@class FB1PreferenceSelectData
---@field PreferenceId FName
---@field Like boolean
---@field Ratio float
local FB1PreferenceSelectData = {}



---@class FB1PreferenceSettingData
---@field CurrentEmotionId FName
---@field Like boolean
---@field AlertMessageId FName
local FB1PreferenceSettingData = {}



---@class FB1PreferenceTableRow : FB1TableRowBase
---@field ID FName
---@field Category FName
---@field DisplayInfo FB1PreferenceDisplayInfo
---@field AgeAvailable TArray<EB1GrowthStep>
---@field ChangeByGrowthStep TArray<FB1GrowthChangeData>
---@field LikePassiveModifierId FName
---@field DislikePassiveModifierId FName
---@field LinkedInteractionTag FName
---@field LikeInteractingBuffId FName
---@field DislikeInteractingDebuffId FName
---@field PreferenceSettingMissionId FName
---@field PreferenceSettingDataList TArray<FB1PreferenceSettingData>
---@field LikeInteractingFacialExpressionId FName
---@field DisLikeInteractingFacialExpressionId FName
local FB1PreferenceTableRow = {}



---@class FB1PrintedAccessoryData
---@field AttachedBoneName FName
---@field PrintedAccessoryId FName
---@field SaveData TOptional<FB1PrintedObjectSaveData>
local FB1PrintedAccessoryData = {}



---@class FB1PrintedAccessoryDescription
---@field PrintedAccessoryName FName
---@field PrintedAccessoryData TMap<FName, FB1PrintedAccessoryData>
local FB1PrintedAccessoryDescription = {}



---@class FB1PrintedObjectSaveData
---@field ImageTo3DName FString
---@field PivotLocation FVector
---@field PivotRotation FVector
---@field PrintedMeshExtent FVector
---@field Title FString
---@field Description FString
---@field FunctionalId FName
local FB1PrintedObjectSaveData = {}



---@class FB1PsycatTalkEndMessageSetting
---@field MaxResponseCount int32
---@field EndMessageTextIdList TArray<FString>
local FB1PsycatTalkEndMessageSetting = {}



---@class FB1PublishableCraftingData
---@field DefaultCategories TArray<FB1CraftingCategory>
local FB1PublishableCraftingData = {}



---@class FB1QualityData
---@field Quality EB1Quality
---@field StateGroupId FName
---@field StateId FName
---@field PlaySuccessAnimationWeight float
---@field PlayIdleAnimationWeight float
---@field Price float
local FB1QualityData = {}



---@class FB1QualityTableRow : FB1TableRowBase
---@field ID FName
---@field MarketSellingDataId FName
---@field NonMaxLevelQualityId FName
---@field MaxLevelQualityId FName
---@field QualityDatas TArray<FB1QualityData>
local FB1QualityTableRow = {}



---@class FB1QualityTextData
---@field TitleTextId FString
---@field ColorId FName
local FB1QualityTextData = {}



---@class FB1QualityWeight
---@field LevelDifference int32
---@field Bad float
---@field Fair float
---@field Good float
---@field High float
---@field Superb float
local FB1QualityWeight = {}



---@class FB1QuestCategoryTableRow : FB1TableRowBase
---@field ID FName
---@field MainDisplayTextId FString
---@field MainCategoryIcon TSoftObjectPtr<UTexture2D>
---@field SubDisplayTextId FString
---@field SubCategoryIcon TSoftObjectPtr<UTexture2D>
---@field CategoryColorId FName
---@field MissionToolTipId FString
local FB1QuestCategoryTableRow = {}



---@class FB1QuestConditionData
---@field CurrentCount int64
---@field GoalCount int64
---@field ConditionType EB1MissionCondition
local FB1QuestConditionData = {}



---@class FB1QuestHistoryData
---@field Priority int64
---@field HistoryElementMap TMap<FName, FB1QuestHistoryElement>
---@field IsLazyCompleted boolean
local FB1QuestHistoryData = {}



---@class FB1QuestHistoryElement
---@field IsSuccess boolean
---@field IsFail boolean
---@field IsActive boolean
---@field EndTick int64
---@field ConditionDatas TArray<FB1QuestConditionData>
local FB1QuestHistoryElement = {}



---@class FB1QuestInfo
---@field StartTime int32
---@field EndTime int32
---@field ExpireTime int32
---@field QuestTask TArray<FB1QuestTask>
---@field Conditions TArray<FB1Condition>
local FB1QuestInfo = {}



---@class FB1QuestTableRow : FB1TableRowBase
---@field ID FName
---@field IsLazyComplete boolean
---@field QuestCategoryId FName
---@field QuestList TArray<FB1QuestInfo>
local FB1QuestTableRow = {}



---@class FB1QuestTask
---@field MissionDtId FName
---@field SuccessScriptId FName
---@field FailScriptId FName
local FB1QuestTask = {}



---@class FB1RabbitHoleChoiceCardInfo
---@field ID FName
---@field Ratio float
---@field MinTime int32
---@field MaxTime int32
local FB1RabbitHoleChoiceCardInfo = {}



---@class FB1RabbitHoleData
local FB1RabbitHoleData = {}


---@class FB1RabbitHoleInteraction
---@field ID FName
---@field Ratio int32
---@field DisplayTextId FString
---@field TooltipTextId FString
---@field InteractionConditionId FName
---@field StartScriptIdList TArray<FName>
---@field CancelScriptIdList TArray<FName>
---@field FinishScriptIdList TArray<FName>
local FB1RabbitHoleInteraction = {}



---@class FB1RabbitHoleTableRow : FB1TableRowBase
---@field ID FName
---@field IconTexture TSoftObjectPtr<UObject>
---@field MainTextId FString
---@field TooltipTextId FString
---@field ToastMessageTextId FString
---@field OverrideScheduleInfoId FName
---@field StartScriptId FName
---@field CancelScriptId FName
---@field FinishScriptId FName
---@field Tags TArray<FName>
---@field RabbitHoleInteractionList TArray<FB1RabbitHoleInteraction>
---@field ChoiceCardList TArray<FB1RabbitHoleChoiceCardInfo>
local FB1RabbitHoleTableRow = {}



---@class FB1RadiusRange
---@field MinRadius float
---@field MaxRadius float
local FB1RadiusRange = {}



---@class FB1RandomAnimInfo
---@field AnimId FName
---@field VoiceId FName
---@field Weight float
local FB1RandomAnimInfo = {}



---@class FB1RandomAnimationInfo
---@field Animation TSoftObjectPtr<UAnimSequenceBase>
---@field EmotionId FName
---@field ChanceToPlay float
local FB1RandomAnimationInfo = {}



---@class FB1RandomBuffPoolEntryData
---@field ID FName
---@field Prob int32
local FB1RandomBuffPoolEntryData = {}



---@class FB1RandomBuffPoolTableRow : FB1TableRowBase
---@field ID FName
---@field RandomBuffPoolData TArray<FB1RandomBuffPoolEntryData>
---@field TotalProb int32
local FB1RandomBuffPoolTableRow = {}



---@class FB1RandomOrderInteraction
---@field InteractionBagId FName
---@field Probability float
local FB1RandomOrderInteraction = {}



---@class FB1RandomTalkEmoticonData
---@field ListKey FString
---@field Emoticon FSoftObjectPath
---@field Text FString
local FB1RandomTalkEmoticonData = {}



---@class FB1RandomTalkEmoticonTableRow : FB1TableRowBase
---@field RandomTalkEmoticonList TArray<FB1RandomTalkRelationshipData>
local FB1RandomTalkEmoticonTableRow = {}



---@class FB1RandomTalkRelationshipData
---@field ListKey FString
---@field RelationshipLevel int32
---@field PositiveList TArray<FB1RandomTalkEmoticonData>
---@field NegativeList TArray<FB1RandomTalkEmoticonData>
local FB1RandomTalkRelationshipData = {}



---@class FB1ReactionAnimInfo
---@field SelfAnimId FName
---@field TargetAnimId FName
---@field NeedStop boolean
local FB1ReactionAnimInfo = {}



---@class FB1ReactionRelationshipInfo
---@field MinRange float
---@field MaxRange float
---@field ReactionAnimInfo FB1ReactionAnimInfo
local FB1ReactionRelationshipInfo = {}



---@class FB1ReactionTableRow : FB1TableRowBase
---@field ID FName
---@field Priority int32
---@field Conditions TArray<FB1Condition>
---@field ReactionAnimInfo FB1ReactionAnimInfo
---@field StartScriptIds TArray<FName>
local FB1ReactionTableRow = {}



---@class FB1RecipeGroupTableRow : FB1TableRowBase
---@field ID FName
---@field TitleTextId FString
---@field DescTextId FString
---@field CraftingCost int32
---@field SkillLevel int32
---@field ConditionId FName
---@field Thumbnail TSoftObjectPtr<UObject>
---@field RecipeIds TArray<FName>
local FB1RecipeGroupTableRow = {}



---@class FB1RecipeNamingPoolTableRow : FB1TableRowBase
---@field ID FName
---@field Datas TArray<FB1RecipeTitleDescriptionData>
local FB1RecipeNamingPoolTableRow = {}



---@class FB1RecipeTableRow : FB1TableRowBase
---@field ID FName
---@field CraftingId FName
---@field SkillLevel int32
---@field QualityId FName
---@field CraftingCost int32
---@field FinalObjectType EB1CraftingFinalObjectType
---@field FinalObjectId FName
---@field FinishScriptIds TArray<FName>
---@field Ingredients TArray<FB1CraftingIngredient>
---@field CraftingSteps TArray<FB1CraftingStep>
---@field TotalProgressTime float
---@field ProgressTimeModifierId FName
local FB1RecipeTableRow = {}



---@class FB1RecipeTitleDescriptionData
---@field TitleTextId FString
---@field DescTextId FString
local FB1RecipeTitleDescriptionData = {}



---@class FB1RelationshipAdditionalStatData
local FB1RelationshipAdditionalStatData = {}


---@class FB1RelationshipAutoSelectionData
---@field SuccessProb float
---@field SuccessAddStatValue float
---@field FailProb float
---@field FailAddStatValue float
local FB1RelationshipAutoSelectionData = {}



---@class FB1RelationshipBonusMultiplyData
---@field DiffLevelFrom int32
---@field DiffLevelTo int32
---@field BonusMultiplyFrom float
---@field BonusMultiplyTo float
local FB1RelationshipBonusMultiplyData = {}



---@class FB1RelationshipCategoryTableRow : FB1TableRowBase
---@field ID FName
---@field IsUniqueInCategory boolean
---@field IsDeleteByDecay boolean
---@field DescTextId FString
local FB1RelationshipCategoryTableRow = {}



---@class FB1RelationshipCondition
---@field RelationshipStatId FName
---@field CompareList TArray<FB1RelationshipConditionCompare>
local FB1RelationshipCondition = {}



---@class FB1RelationshipConditionCompare
---@field FromValue float
---@field ToValue float
---@field Level int8
---@field LinkRelationshipId FName
---@field FocusSelectionData FB1RelationshipFocusSelectionData
local FB1RelationshipConditionCompare = {}



---@class FB1RelationshipConditionTableRow : FB1TableRowBase
---@field ID FName
---@field RelationshipConditions TArray<FB1RelationshipCondition>
local FB1RelationshipConditionTableRow = {}



---@class FB1RelationshipData
---@field StatData TMap<FName, FB1RelationshipStatData>
---@field RelationshipInfoList TArray<FB1RelationshipInfo>
---@field bIsFamilyRelationship boolean
---@field bIsHouseholdRelationship boolean
---@field MinGrowthStep EB1GrowthStep
---@field MainRelationship EB1RelationshipStatPriorityType
---@field PositiveLevelList TMap<EB1RelationshipStatPriorityType, int32>
---@field LatestInteractionTick int64
---@field RelationshipRecordDataMap TMap<FB1EntityId, FB1RelationshipRecordData>
---@field ProfileUnlockedDataMap TMap<FB1EntityId, FB1RelationshipProfileUnlockedData>
local FB1RelationshipData = {}



---@class FB1RelationshipDecayData
---@field From float
---@field To float
---@field DecayValuePerSec float
local FB1RelationshipDecayData = {}



---@class FB1RelationshipEffectDisplaySetting
---@field ValueFrom float
---@field ValueTo float
---@field DisplayStringTextId FString
local FB1RelationshipEffectDisplaySetting = {}



---@class FB1RelationshipEventData
---@field EventId FName
---@field TargetEntityId FB1EntityId
---@field TriggerTime int64
local FB1RelationshipEventData = {}



---@class FB1RelationshipEventDataList
---@field RelationshipEventDatas TArray<FB1RelationshipEventData>
local FB1RelationshipEventDataList = {}



---@class FB1RelationshipEventTableRow : FB1TableRowBase
---@field ID FName
---@field TriggerData FB1RelationshipEventTriggerData
---@field EventConditions TArray<FB1Condition>
---@field EventExecutes TArray<FB1Execute>
local FB1RelationshipEventTableRow = {}



---@class FB1RelationshipEventTriggerData
---@field StatName FName
---@field Self FB1RelationshipEventTriggerTargetData
---@field Target FB1RelationshipEventTriggerTargetData
---@field Level int32
---@field TimeDay int32
local FB1RelationshipEventTriggerData = {}



---@class FB1RelationshipEventTriggerTargetData
---@field Type EB1FamilyRelationshipType
---@field Gender EB1GenderType
---@field Probability float
local FB1RelationshipEventTriggerTargetData = {}



---@class FB1RelationshipFocusSelectionData
---@field IsEnable boolean
---@field AutoSelectionData FB1RelationshipAutoSelectionData
local FB1RelationshipFocusSelectionData = {}



---@class FB1RelationshipFxSet
---@field StartFxAsset TSoftObjectPtr<UNiagaraSystem>
---@field EndFxAsset TSoftObjectPtr<UNiagaraSystem>
local FB1RelationshipFxSet = {}



---@class FB1RelationshipGiftConditionData
---@field RelationshipStat FName
---@field FromLevel int32
---@field ToLevel int32
local FB1RelationshipGiftConditionData = {}



---@class FB1RelationshipGiftData
---@field GiftEntityId FB1EntityId
---@field FromEntityId FB1EntityId
---@field ToEntityId FB1EntityId
---@field ObjectData FB1RelationshipGiftObjectData
---@field RewardData FB1RelationshipGiftRewardData
---@field GiftSendTime int64
---@field GiftType EB1GiftType
local FB1RelationshipGiftData = {}



---@class FB1RelationshipGiftObjectData
---@field ObjectType EB1CarriableObjectType
---@field ID FName
---@field Count int32
local FB1RelationshipGiftObjectData = {}



---@class FB1RelationshipGiftRewardData
---@field RelationshipStat FName
---@field Value int32
local FB1RelationshipGiftRewardData = {}



---@class FB1RelationshipGiftTableRow : FB1TableRowBase
---@field ID FName
---@field GiftBoxObjectIds TArray<FName>
---@field ObjectData FB1RelationshipGiftObjectData
---@field ConditionData FB1RelationshipGiftConditionData
---@field RewardData FB1RelationshipGiftRewardData
local FB1RelationshipGiftTableRow = {}



---@class FB1RelationshipImageRecordData
---@field RecordId FName
---@field RecordTime FDateTime
local FB1RelationshipImageRecordData = {}



---@class FB1RelationshipInfo
---@field ID FName
---@field Category FName
---@field bIsUniqueInCategory boolean
local FB1RelationshipInfo = {}



---@class FB1RelationshipProfileUnlockedData
---@field ProfileTypeUnlockList TSet<EB1RelationshipProfileType>
---@field ProfileTypeUnlockHistoryList TSet<EB1RelationshipProfileType>
local FB1RelationshipProfileUnlockedData = {}



---@class FB1RelationshipRecordBundleData
---@field ListKey FString
---@field DescTextId FString
local FB1RelationshipRecordBundleData = {}



---@class FB1RelationshipRecordData
---@field NormalTextRecordDataArray TArray<FB1RelationshipTextRecordData>
---@field ImportantTextRecordDataArray TArray<FB1RelationshipTextRecordData>
---@field ImportantImageRecordDataArray TArray<FB1RelationshipImageRecordData>
local FB1RelationshipRecordData = {}



---@class FB1RelationshipRecordTableRow : FB1TableRowBase
---@field ID FName
---@field bIsImportant boolean
---@field Icon TSoftObjectPtr<UObject>
---@field TooltipTextId FString
---@field DataList TArray<FB1RelationshipRecordBundleData>
local FB1RelationshipRecordTableRow = {}



---@class FB1RelationshipReward
---@field Target EB1BaseObject
---@field RelationshipStatId FName
---@field LevelFrom int32
---@field LevelTo int32
---@field Bonus int32
local FB1RelationshipReward = {}



---@class FB1RelationshipStatData
---@field Value float
---@field CurrentLevel int32
---@field CurrentRelationshipId FName
---@field IsFocusSelection boolean
---@field LastFocusSelectionTime int64
local FB1RelationshipStatData = {}



---@class FB1RelationshipStatTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayNameTextId FString
---@field DefaultDecayValuePerSec float
---@field GrowthStep EB1GrowthStep
---@field DecayDataList TArray<FB1RelationshipDecayData>
---@field PositiveAsset TSoftObjectPtr<UObject>
---@field NegativeAsset TSoftObjectPtr<UObject>
---@field BackgroundAsset TSoftObjectPtr<UObject>
local FB1RelationshipStatTableRow = {}



---@class FB1RelationshipTableRow : FB1TableRowBase
---@field ID FName
---@field IconId FName
---@field CategoryId FName
---@field DisplayNameTextId FString
---@field DescTextId FString
---@field ColorId1 FName
---@field ColorId2 FName
---@field RelationshipFx FB1RelationshipFxSet
local FB1RelationshipTableRow = {}



---@class FB1RelationshipTextRecordData
---@field RecordId FName
---@field RecordTime FDateTime
---@field RecordTextKey FString
local FB1RelationshipTextRecordData = {}



---@class FB1RemoteSelection
---@field InteractionId FName
---@field IsEnable boolean
local FB1RemoteSelection = {}



---@class FB1RemoveQuest
---@field RemoveTick int64
---@field QuestId FName
local FB1RemoveQuest = {}



---@class FB1RequestAsyncLoad
---@field AsyncLoadId FB1AsyncLoadId
---@field AsyncLoadAnimList TArray<FB1AsyncLoadAnimInfo>
local FB1RequestAsyncLoad = {}



---@class FB1ReserveQuest
---@field StartTick int64
---@field EndTick int64
---@field QuestTask FB1QuestTask
---@field MissionType EB1MissionType
---@field QuestId FName
local FB1ReserveQuest = {}



---@class FB1ResponseReplyRequest
---@field SenderSystemId FName
---@field Sender FB1EntityId
---@field Receiver FB1EntityId
---@field Type EB1MobileMessageResponseType
---@field MessageResponseScriptId FName
local FB1ResponseReplyRequest = {}



---@class FB1RestrictCrowdPreset
---@field PresetId FName
---@field Role EB1CharacterRole
---@field City EB1DiversityCity
local FB1RestrictCrowdPreset = {}



---@class FB1RoleInfo
---@field ID FName
---@field bIsEssencial boolean
---@field RoleConditions TArray<FB1Condition>
local FB1RoleInfo = {}



---@class FB1RolePlayingInfo
---@field RoleId FName
---@field ScenarioInfos TArray<FB1ScenarioInfo>
---@field TimeOffset int64
---@field RoleTargetFilterIds TArray<FName>
local FB1RolePlayingInfo = {}



---@class FB1RoofObjectSaveData
---@field RoofSize FVector
---@field ExtendedSlopeWidth float
---@field ExtendedSlopeWidthEx float
---@field ExtendedSlopeHeight float
---@field ExtendedSlopeHeightEx float
---@field Radius float
---@field AccessorySetName FString
local FB1RoofObjectSaveData = {}



---@class FB1RootDepartmentInfo
---@field SeatPool TMap<FB1EntityId, boolean>
---@field EmployeeSeatMap TMap<FB1EntityId, FB1EntityId>
---@field IsFixedDesk boolean
---@field EmptyHeadcount int32
---@field TotalHeadcount int32
local FB1RootDepartmentInfo = {}



---@class FB1RumorEventTableRow : FB1TableRowBase
---@field ID FName
---@field Type EB1RumorEventType
---@field TargetInt int32
---@field CustomMessageId FName
local FB1RumorEventTableRow = {}



---@class FB1RumorId
---@field Value int64
local FB1RumorId = {}



---@class FB1RumorParam
---@field RumorId FB1RumorId
---@field RumorDtId FName
---@field RumorMongerEntityId FB1EntityId
---@field RumorStartTime int64
---@field RumorLimitTime int64
---@field PositiveCount int32
---@field NegativeCount int32
---@field EntitiesKnownTheRumor int32
local FB1RumorParam = {}



---@class FB1RumorTableRow : FB1TableRowBase
---@field ID FName
---@field DescTextId FString
---@field IsTransferByTalk boolean
---@field duration float
---@field Strength int32
---@field PositiveRatio float
---@field NegativeRatio float
---@field ScriptIds TArray<FName>
---@field RumorEventIds TArray<FName>
local FB1RumorTableRow = {}



---@class FB1SafetyBox
---@field Center FVector
---@field HorizontalHalf FVector
---@field VerticalHalf FVector
local FB1SafetyBox = {}



---@class FB1SameZoneConnectEdgeInfo
---@field bFromZoneIndex1 boolean
---@field bToZoneIndex1 boolean
local FB1SameZoneConnectEdgeInfo = {}



---@class FB1SaveLoadConfig
---@field AutoSaveTime FTimespan
---@field MaxAutoSaveCount int32
---@field ShowAutoSaveFilesCountInLobby int32
---@field AutoSaveOnFinishBuildMode boolean
local FB1SaveLoadConfig = {}



---@class FB1SavePresetSelection
---@field ListKey FString
---@field TypeStrId FString
local FB1SavePresetSelection = {}



---@class FB1SavePresetTableRow : FB1TableRowBase
---@field ID FName
---@field Selections TArray<FB1SavePresetSelection>
local FB1SavePresetTableRow = {}



---@class FB1ScenarioInfo
---@field InteractionBagId FName
---@field ActingType EB1ActingType
---@field ForceCurrentInteractionCancel boolean
local FB1ScenarioInfo = {}



---@class FB1Schedule
---@field ID FB1ScheduleId
---@field ScheduleType EB1ScheduleType
---@field TimelineName FName
---@field Detail FB1ScheduleDetail
---@field SiteEventId FB1SiteEventId
---@field SiteEventHostEnttiyId FB1EntityId
---@field AssoicateEntityId FB1EntityId
---@field ControlState EB1ScheduleControlState
---@field NotifyTime uint32
local FB1Schedule = {}



---@class FB1ScheduleDetail : FB1TimelineRange
---@field Site FName
---@field SiteTags TArray<FName>
---@field Orders TArray<FB1Order>
---@field ScheduleName FName
---@field StartScriptIdList TArray<FName>
---@field FinishScriptIdList TArray<FName>
---@field ArrivedScriptIdList TArray<FName>
---@field CancelScriptIdList TArray<FName>
---@field SearchedScriptIdList TArray<FName>
---@field LeavedSiteScriptIdList TArray<FName>
---@field SearchTargetFilterIds TArray<FName>
---@field SearchTargetConditions TArray<FB1Condition>
---@field bIsWorkingSchedule boolean
---@field bHasFlexibleOrder boolean
local FB1ScheduleDetail = {}



---@class FB1ScheduleId
---@field Value int64
local FB1ScheduleId = {}



---@class FB1ScheduleInfoTableRow : FB1TableRowBase
---@field ID FName
---@field Icon TSoftObjectPtr<UTexture2D>
---@field TitleText FString
---@field DescText FString
---@field OverideScheduleImage TSoftObjectPtr<UTexture2D>
---@field bIsNeedConvertTitleText boolean
---@field bIsNeedConvertDescText boolean
local FB1ScheduleInfoTableRow = {}



---@class FB1ScheduleMissionInfo
---@field MissionDtId FName
---@field SuccessScriptId FName
---@field FailScriptId FName
---@field SuccessJobExp int32
---@field FailJobExp int32
---@field AddDesireInteractions TArray<FB1AddDesireInteraction>
---@field Modifiers TArray<FName>
local FB1ScheduleMissionInfo = {}



---@class FB1SchoolInfo
---@field CompanyId FB1EntityId
---@field DepartmentKey FB1DepartmentKey
---@field EducationType EB1EducationType
local FB1SchoolInfo = {}



---@class FB1Script
---@field Conditions TArray<FB1Condition>
---@field Executes TArray<FB1Execute>
local FB1Script = {}



---@class FB1ScriptTableRow : FB1TableRowBase
---@field Scripts TArray<FB1Script>
local FB1ScriptTableRow = {}



---@class FB1SeasonConfig
---@field Season EB1SeasonType
---@field DurationMultiplier int32
---@field TemperatureDayDelta int32
---@field Temperatures TArray<FB1TemperatureConfig>
local FB1SeasonConfig = {}



---@class FB1SeasonTableRow : FB1TableRowBase
---@field ID FName
---@field SeasonTextId FString
local FB1SeasonTableRow = {}



---@class FB1Seizure
---@field InterestRate float
---@field SeizureStartMessageId FName
---@field SeizureEndMessageId FName
---@field SeizureFailMessageId FName
local FB1Seizure = {}



---@class FB1SelectionSet
---@field StateGroupId FName
---@field SelectionType EB1SelectionType
---@field InteractionBagList TArray<FName>
local FB1SelectionSet = {}



---@class FB1SequenceStartInfo
---@field ConditionId FName
---@field StartLabel FName
local FB1SequenceStartInfo = {}



---@class FB1ServiceContextId
---@field Value int64
local FB1ServiceContextId = {}



---@class FB1ServiceExecuteContext
---@field ServiceId FName
---@field TriggerEntityId FB1EntityId
---@field SiteEntityId FB1EntityId
---@field ExecutingEntityIds TArray<FB1EntityId>
---@field ContextID FB1ServiceContextId
---@field TimeOutTicks int64
---@field bPendingFinish boolean
local FB1ServiceExecuteContext = {}



---@class FB1ServiceRoleInfo
---@field ServiceRoleId FName
---@field TimelineId FName
---@field CompanyId FB1TableRowName
---@field JobId FB1TableRowName
local FB1ServiceRoleInfo = {}



---@class FB1ServiceSelectContext
---@field ServiceId FName
---@field TriggerEntityId FB1EntityId
---@field SiteEntityId FB1EntityId
---@field ContextID FB1ServiceContextId
local FB1ServiceSelectContext = {}



---@class FB1ServiceSelectExecuteConnection
---@field ServiceId FName
---@field SelectContextId FB1ServiceContextId
---@field ExecuteContextId FB1ServiceContextId
local FB1ServiceSelectExecuteConnection = {}



---@class FB1ServiceTableRow : FB1TableRowBase
---@field ID FName
---@field ServiceRoleInfos TArray<FB1ServiceRoleInfo>
---@field VisitType EB1ServiceVisitType
---@field GroupId FName
---@field bKeepPushingSchedule boolean
---@field PersistentScheduleFinishConditions TArray<FB1Condition>
---@field VehicleMeshDescriptionTagId FName
---@field PendingPopupTextId FString
---@field AddingPopupTextId FString
---@field SuccessPopupTextId FString
---@field FailurePopupTextId FString
---@field TimeOutPopupTextId FString
---@field FinishPopupTextId FString
local FB1ServiceTableRow = {}



---@class FB1ServiceVehicleDescriptionInfo
---@field CityVehicleDescription TMap<FName, FName>
local FB1ServiceVehicleDescriptionInfo = {}



---@class FB1ShowRecruitInfo
---@field CompanyId FB1EntityId
---@field CompanyDtId FName
---@field Department FB1DepartmentKey
---@field State EB1ShowRecruitInfoState
---@field EmptyHeadcount int32
---@field bHighestCareer boolean
---@field JobType EB1JobType
local FB1ShowRecruitInfo = {}



---@class FB1SignMeshInfo
---@field SignMeshList TArray<TSoftObjectPtr<UStaticMesh>>
local FB1SignMeshInfo = {}



---@class FB1SimulationDriverData
---@field MeshPath TMap<FName, TSoftObjectPtr<UStaticMesh>>
local FB1SimulationDriverData = {}



---@class FB1SimulationLODConfig
---@field BaseType EB1SimulationLODBase
---@field TickInterval float
---@field SimulationLODArray TArray<FB1SimulationLODDistance>
---@field DistanceMinimumDiff float
local FB1SimulationLODConfig = {}



---@class FB1SimulationLODDistance
---@field LoadDistance float
---@field UnloadDistance float
local FB1SimulationLODDistance = {}



---@class FB1SiteAction
---@field Command EB1SiteActionType
---@field Target EB1SiteActionTarget
---@field S1 FName
---@field S2 FName
---@field F1 float
---@field F2 float
local FB1SiteAction = {}



---@class FB1SiteActionTableRow : FB1TableRowBase
---@field ID FName
---@field SiteActions TArray<FB1SiteAction>
local FB1SiteActionTableRow = {}



---@class FB1SiteActionTrigger
---@field Conditions TArray<FB1Condition>
---@field TimeHHMM int32
---@field SiteActionId FName
local FB1SiteActionTrigger = {}



---@class FB1SiteAreaBuiltSaveData
---@field GroundFloors TArray<FB1SiteAreaLayerSaveData>
---@field Basements TArray<FB1SiteAreaLayerSaveData>
---@field DoorPermissionGroup EB1DoorPermissionGroup
---@field DevlopersDoorPermissionIds TArray<FName>
---@field DevelopersPermissionsMessageId FName
---@field bSetBuiltAreaSize boolean
---@field BuiltAreaSize FVector
---@field BuiltAreaCenter FVector
---@field SavedSiteId FName
---@field AuthorName FString
local FB1SiteAreaBuiltSaveData = {}



---@class FB1SiteAreaCustomBottomFloorSaveData
---@field NodeKey int32
---@field MaterialValue FB1ObjectCustomizeSaveData
---@field SideMaterialValue FB1ObjectCustomizeSaveData
---@field RoomBorder TArray<int32>
---@field bIsHide boolean
---@field bIsPool boolean
---@field FloorHeight float
local FB1SiteAreaCustomBottomFloorSaveData = {}



---@class FB1SiteAreaCustomWallDecoSaveData
---@field WallKey int64
---@field DecoName FString
---@field MaterialValues TArray<FB1ObjectCustomizeSaveData>
local FB1SiteAreaCustomWallDecoSaveData = {}



---@class FB1SiteAreaCustomWallLockSaveData
---@field LeftNode int32
---@field RightNode int32
local FB1SiteAreaCustomWallLockSaveData = {}



---@class FB1SiteAreaCustomWallSaveData
---@field WallKey int64
---@field NodeFrom int32
---@field MaterialValues FB1ObjectCustomizeSaveData
---@field CutWalls TArray<FB1SiteAreaCutWallSaveData>
---@field MaskWalls TArray<FB1SiteAreaMaskWallSaveData>
---@field HideWalls TArray<FB1SiteAreaHideWallSaveData>
---@field HalfWalls TArray<FB1SiteAreaHalfWallSaveData>
---@field PaintedWalls FB1SiteAreaPaintedWallSaveData
local FB1SiteAreaCustomWallSaveData = {}



---@class FB1SiteAreaCutWallSaveData
---@field EntityID int64
---@field NodeFrom int32
---@field Start float
---@field End float
---@field Size FVector2D
local FB1SiteAreaCutWallSaveData = {}



---@class FB1SiteAreaHalfWallSaveData
---@field NodeFrom int32
---@field Start float
---@field End float
---@field Height float
---@field CoverName FString
local FB1SiteAreaHalfWallSaveData = {}



---@class FB1SiteAreaHideWallSaveData
---@field NodeFrom int32
---@field Start float
---@field End float
---@field bIsHide boolean
local FB1SiteAreaHideWallSaveData = {}



---@class FB1SiteAreaLayerSaveData
---@field Graphs TArray<FB1SiteAreaWallGraphSaveData>
---@field CustomWalls TArray<FB1SiteAreaCustomWallSaveData>
---@field CustomWallDecos TArray<FB1SiteAreaCustomWallDecoSaveData>
---@field CustomRoomBottomFloor TArray<FB1SiteAreaCustomBottomFloorSaveData>
---@field CustomBottomFloor TArray<FB1SiteAreaCustomBottomFloorSaveData>
---@field CustomRoomCeilFloor TArray<FB1SiteAreaCustomBottomFloorSaveData>
---@field CustomCeilFloor TArray<FB1SiteAreaCustomBottomFloorSaveData>
---@field CustomWallLock TArray<FB1SiteAreaCustomWallLockSaveData>
---@field GroundSpaces TArray<FB1SiteAreaSpaceStructureSaveData>
---@field CeilingSpaces TArray<FB1SiteAreaSpaceStructureSaveData>
---@field RoofSpaces TArray<FB1SiteAreaSpaceStructureSaveData>
---@field SpaceStructureArray TArray<FB1SiteAreaSpaceStructureSaveData>
local FB1SiteAreaLayerSaveData = {}



---@class FB1SiteAreaLockedWallNodeSaveData
---@field Key int32
---@field Directions TArray<uint8>
local FB1SiteAreaLockedWallNodeSaveData = {}



---@class FB1SiteAreaMaskWallSaveData
---@field EntityID int64
---@field NodeFrom int32
---@field Start float
---@field End float
---@field Size FVector
---@field Location FVector
local FB1SiteAreaMaskWallSaveData = {}



---@class FB1SiteAreaPaintedSegmentSaveData
---@field Start float
---@field End float
---@field MaterialValues FB1ObjectCustomizeSaveData
local FB1SiteAreaPaintedSegmentSaveData = {}



---@class FB1SiteAreaPaintedWallSaveData
---@field NodeFrom int32
---@field Segments TArray<FB1SiteAreaPaintedSegmentSaveData>
local FB1SiteAreaPaintedWallSaveData = {}



---@class FB1SiteAreaPathFindingSaveData
---@field PathfindingGrid2 TMap<int32, FB1FloorPathFindGrid>
---@field ZoneGraphNodeArray TArray<FB1ZoneGraphNode>
---@field ZoneGraphZoneInfoMap TMap<int32, FB1ZoneGraphZoneInfo>
---@field xColiisionBitArrayMap TMap<int32, FB1PathFindGridBitArray>
---@field yColiisionBitArrayMap TMap<int32, FB1PathFindGridBitArray>
---@field MinFloor int32
---@field MaxFloor int32
---@field GridMaxX int32
---@field GridMaxY int32
---@field SiteLocation FVector
local FB1SiteAreaPathFindingSaveData = {}



---@class FB1SiteAreaRoofSaveData
---@field RoofId int64
---@field DataId FName
---@field Location FVector
---@field RelativeLocation FVector
---@field Dir float
---@field Size FVector
---@field IsDevLocked boolean
---@field FloorLevel int32
local FB1SiteAreaRoofSaveData = {}



---@class FB1SiteAreaRoomBorderSaveData
---@field EdgeKeys TArray<int32>
local FB1SiteAreaRoomBorderSaveData = {}



---@class FB1SiteAreaSpaceStructureSaveData
---@field InternalIndex int32
---@field InnerSpacesInternalIndexArray TArray<int32>
---@field Border FB1BorderSaveData
---@field OpenEdges TArray<int64>
---@field SpaceAttribute uint32
local FB1SiteAreaSpaceStructureSaveData = {}



---@class FB1SiteAreaWallGraphSaveData
---@field Nodes TArray<FB1SiteAreaWallNodeSaveData>
---@field LockedEdges TArray<int64>
---@field LockedNodes TArray<FB1SiteAreaLockedWallNodeSaveData>
---@field BaseHeight float
---@field WallHeight float
---@field FloorHeight float
---@field BaseTypeName FString
---@field BaseDecoName FString
---@field BaseCustomize TArray<FB1ObjectCustomizeSaveData>
local FB1SiteAreaWallGraphSaveData = {}



---@class FB1SiteAreaWallNodeSaveData
---@field Key int32
---@field Directions TArray<uint8>
---@field Edges TArray<int32>
local FB1SiteAreaWallNodeSaveData = {}



---@class FB1SiteBuildPresetInfoRow : FB1TableRowBase
---@field ID FName
---@field BuildPresetIds TArray<FName>
local FB1SiteBuildPresetInfoRow = {}



---@class FB1SiteDefaultAsset
---@field BuiltData FB1SiteAreaBuiltSaveData
---@field ChildGameObjects TArray<FB1SiteDefaultAssetGameObject>
---@field SiteSnapshotJsonString FString
local FB1SiteDefaultAsset = {}



---@class FB1SiteDefaultAssetGameObject
---@field InternalIndexId FName
---@field ForConstruct boolean
---@field ObjectTableId FName
---@field Location FVector
---@field Rotation FRotator
---@field Scale FVector
---@field FloorLevel int32
---@field IsDevLocked boolean
---@field ParentID FName
---@field SlotName FName
---@field BuiltData FB1SiteAreaBuiltSaveData
---@field CustomizedData TArray<FB1DefaultAssetCustomData>
---@field ObjectMetaData FB1GameObjectMetaSaveData
---@field AuthorName FString
---@field ZoneGraphNodeIndex int32
local FB1SiteDefaultAssetGameObject = {}



---@class FB1SiteDefaultAssetRow : FB1TableRowBase
---@field InternalIndexId FName
---@field ForConstruct boolean
---@field ObjectTableId FName
---@field Location FVector
---@field Rotation FRotator
---@field Scale FVector
---@field FloorLevel int32
---@field IsDevLocked boolean
---@field ParentID FName
---@field SlotName FName
---@field BuiltData FB1SiteAreaBuiltSaveData
---@field CustomData TArray<FB1DefaultAssetCustomData>
---@field StairsData FB1StairsObjectSaveData
---@field RoofObjectData FB1RoofObjectSaveData
---@field AuthorName FString
---@field PillarObjectData FB1PillarObjectSaveData
---@field FenceData FB1FenceObjectSaveData
---@field LadderData FB1LadderObjectSaveData
---@field PrintedObjectData FB1PrintedObjectSaveData
---@field DoorObjectData FB1DoorObjectSaveData
---@field ZoneGraphNodeIndex int32
---@field ObjectBoundCenter FVector
---@field ObjectBoundExtends FVector
---@field PrintedMeshId FString
---@field PrintedMeshOffset FVector
local FB1SiteDefaultAssetRow = {}



---@class FB1SiteDefaultInfo
---@field NameTextId FString
---@field SiteType EB1SiteType
---@field SiteSubType EB1SiteSubType
---@field Tags TArray<FName>
---@field OverrideIconId FName
---@field DisplayType_TextId FString
---@field DescriptionTextId FString
---@field OperatingHoursTextId FString
---@field SiteImage TSoftObjectPtr<UObject>
---@field Price int64
---@field Size FVector2D
---@field StandardizedSize FString
---@field StreamingDistance float
---@field StreamingDistanceMargin float
---@field Lod0Distance float
---@field Lod1Distance float
---@field Lod2Distance float
---@field Lod0DistanceMargin float
---@field Lod1DistanceMargin float
---@field Lod2DistanceMargin float
---@field Lod3DistanceMargin float
---@field bTakeOffShoes boolean
---@field bIsEnableWeathering boolean
---@field SiteDetailInfoId FName
---@field bDisabled boolean
---@field bDevOnly boolean
local FB1SiteDefaultInfo = {}



---@class FB1SiteDetailInfoTableRow : FB1TableRowBase
---@field ID FName
---@field ResidentMaxCount int32
---@field ResidentMinCount int32
---@field RequiredObjects TArray<FB1SiteRequiredObjectInfo>
local FB1SiteDetailInfoTableRow = {}



---@class FB1SiteEventActivityAutonomyData
---@field TalkRewardData FB1SiteEventAutonomyStatRewardData
---@field ObjectRewardData FB1SiteEventAutonomyStatRewardData
local FB1SiteEventActivityAutonomyData = {}



---@class FB1SiteEventAutonomyStatRewardData
---@field StatRewardDataMap TMap<FName, int64>
---@field TotalReward int64
local FB1SiteEventAutonomyStatRewardData = {}



---@class FB1SiteEventConditionInfo
---@field Conditions TArray<FB1Condition>
---@field DimmedToolTipTextId FString
local FB1SiteEventConditionInfo = {}



---@class FB1SiteEventDisplayInfo
---@field NameTextId FString
---@field DescTextId FString
---@field Icon TSoftObjectPtr<UTexture2D>
---@field Thumbnail TSoftObjectPtr<UTexture2D>
local FB1SiteEventDisplayInfo = {}



---@class FB1SiteEventDressCodeInfo
---@field DressCodeType EB1OutfitCategory
---@field ColorCode FString
local FB1SiteEventDressCodeInfo = {}



---@class FB1SiteEventId
---@field Value int64
local FB1SiteEventId = {}



---@class FB1SiteEventRoleActivityInfo
---@field AutonomyPickRatio float
---@field RecommendedActivitys TArray<FName>
---@field BannedActivitys TArray<FName>
---@field DressCodeInfo FB1SiteEventDressCodeInfo
local FB1SiteEventRoleActivityInfo = {}



---@class FB1SiteEventRoleAutonomyData
---@field ActivityTagRewardDataMap TMap<FName, FB1SiteEventActivityAutonomyData>
local FB1SiteEventRoleAutonomyData = {}



---@class FB1SiteEventRoleInfo
---@field ListKey FString
---@field RoleId FName
---@field NameTextId FString
---@field RoleDescTextId FString
---@field TeleportWaitMinute int32
---@field RequiredRole boolean
---@field IsFixedRole boolean
---@field MinRoleNum int32
---@field MaxRoleNum int32
---@field IsHostRole boolean
---@field RoleConditions TArray<FB1Condition>
---@field ActivityInfo FB1SiteEventRoleActivityInfo
---@field CreateScriptInfos TArray<FB1SiteEventScriptInfo>
---@field StartScriptInfos TArray<FB1SiteEventScriptInfo>
---@field CancelScriptInfos TArray<FB1SiteEventScriptInfo>
---@field FinishScriptInfos TArray<FB1SiteEventScriptInfo>
local FB1SiteEventRoleInfo = {}



---@class FB1SiteEventScriptInfo
---@field ScriptId FName
---@field ScriptTargetRoleId FName
local FB1SiteEventScriptInfo = {}



---@class FB1SiteEventSettingParam
---@field CustomEventName FString
---@field SiteEventTemplateId FName
---@field HostEntityId FB1EntityId
---@field EventStartTime int64
---@field EventEndTime int64
---@field SiteId FName
---@field ScheduleInfoId FName
---@field StageRoleDatas TArray<FB1SiteEventStageRoleData>
local FB1SiteEventSettingParam = {}



---@class FB1SiteEventStageRoleData
---@field MemberIds TArray<FB1EntityId>
---@field StageRoleInfo FB1SiteEventRoleInfo
local FB1SiteEventStageRoleData = {}



---@class FB1SiteEventTableRow : FB1TableRowBase
---@field ID FName
---@field EventType EB1SiteEventType
---@field EventCategory FName
---@field DisplayInfo FB1SiteEventDisplayInfo
---@field ConditionInfo FB1SiteEventConditionInfo
---@field DurationHour int32
---@field ScheduleInfoId FName
---@field RoleInfos TArray<FB1SiteEventRoleInfo>
local FB1SiteEventTableRow = {}



---@class FB1SiteEventTargetInfo
---@field RoleId FName
---@field TargetType EB1SiteEventTargetType
---@field TargetRoleOption EB1SiteEventTargetRoleOption
---@field ActionPlayCount int32
---@field FinishOption EB1SocialEventActionFinishOption
local FB1SiteEventTargetInfo = {}



---@class FB1SiteRequiredObjectInfo
---@field Count int32
---@field ObjectSelectionSetIds TArray<FName>
local FB1SiteRequiredObjectInfo = {}



---@class FB1SiteSchedule
---@field ID FName
---@field TimelineName FName
---@field WorkConditions TArray<FB1Condition>
---@field CharacterAttributeIdList TArray<FName>
---@field CompanyId FName
---@field DepartmentKey FB1DepartmentKey
---@field SiteId FName
local FB1SiteSchedule = {}



---@class FB1SiteTableRow : FB1TableRowBase
---@field ID FName
---@field DefaultInfo FB1SiteDefaultInfo
---@field SiteHint FName
---@field SiteActionTriggers TArray<FB1SiteActionTrigger>
local FB1SiteTableRow = {}



---@class FB1SiteTimelineTableRow : FB1TableRowBase
---@field ID FName
---@field SiteNpcEvent TArray<FB1SiteSchedule>
---@field SiteEnterScriptIdList TArray<FName>
---@field SiteLeaveScriptIdList TArray<FName>
local FB1SiteTimelineTableRow = {}



---@class FB1SiteTypeUIInfo
---@field SiteState EB1SiteState
---@field Icon TSoftObjectPtr<UObject>
---@field IconColorId FName
---@field BgColorId FName
---@field NameOverrideTextId FString
local FB1SiteTypeUIInfo = {}



---@class FB1SiteTypeUIInfoTableRow : FB1TableRowBase
---@field ID FName
---@field SiteType EB1SiteType
---@field Infos TArray<FB1SiteTypeUIInfo>
local FB1SiteTypeUIInfoTableRow = {}



---@class FB1Skill
---@field ID FName
---@field Level int32
---@field Experience float
---@field bIsLevelUpAtCurrentFrame boolean
---@field UpdateExpTime FDateTime
---@field GrowthStep EB1GrowthStep
local FB1Skill = {}



---@class FB1SkillDisplayInfo
---@field DisplayNameTextId FString
---@field DescTextId FString
---@field Icon TSoftObjectPtr<UObject>
local FB1SkillDisplayInfo = {}



---@class FB1SkillEntryWidgetGaugeColorInfo
---@field MinValue int32
---@field MaxValue int32
---@field ColorKey FB1TableRowName
---@field AdditiveColorKey FB1TableRowName
local FB1SkillEntryWidgetGaugeColorInfo = {}



---@class FB1SkillInheritTableRow : FB1TableRowBase
---@field ID FName
---@field EndGrowthStep EB1GrowthStep
---@field InheritedSkillInfo TArray<FB1InheritedSkillInfo>
local FB1SkillInheritTableRow = {}



---@class FB1SkillLevelInfo
---@field ListKey FString
---@field Level int32
---@field RequiredExp float
---@field StepStartScriptId FName
---@field StepCompleteScriptId FName
---@field DescTextId FString
---@field LevelUpDisplayInfo FB1LevelUpDisplayInfo
local FB1SkillLevelInfo = {}



---@class FB1SkillTableRow : FB1TableRowBase
---@field ID FName
---@field SkillDisplayInfo FB1SkillDisplayInfo
---@field SkillObjectIds TArray<FName>
---@field GrowthStep EB1GrowthStep
---@field SkillLevelInfo TArray<FB1SkillLevelInfo>
local FB1SkillTableRow = {}



---@class FB1SkinnedAccessoryMeshTableRow : FB1GarmentMeshTableRow
---@field AccessoryType FName
---@field DeformedMesh TSoftObjectPtr<USkeletalMesh>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1SkinnedAccessoryMeshTableRow = {}



---@class FB1SkinnedAccessoryPartsTableRow : FB1GarmentPartsTableRow
---@field DeformedMesh TSoftObjectPtr<USkeletalMesh>
---@field MatchingGenderId TMap<EB1GenderType, FName>
---@field MatchingBodyAgeId TMap<EB1BodyAgeType, FName>
local FB1SkinnedAccessoryPartsTableRow = {}



---@class FB1SkinnedAccessoryTableRow : FB1GarmentTableRow
---@field AccessoryType FName
local FB1SkinnedAccessoryTableRow = {}



---@class FB1SkuTableRow : FB1TableRowBase
---@field ID FName
---@field DescriptionTextId FString
---@field ItemIds TArray<FName>
---@field Categories TArray<FString>
---@field GenderType TArray<FString>
---@field BodyType TArray<FString>
---@field GrowthStep TArray<FString>
local FB1SkuTableRow = {}



---@class FB1SleepwalkingPoolTableRow : FB1TableRowBase
---@field ID FName
---@field InteractionBagIds TArray<FName>
local FB1SleepwalkingPoolTableRow = {}



---@class FB1SlotComponentData
---@field SlotType EB1SlotType
---@field LinkedSlotMap TMap<EB1SlotDirection, FName>
---@field InteractionSlot FB1InteractionSlotData
---@field FxSlot FB1FxSlotData
---@field ExtraRequireSpaceSlot FB1ExtraRequireSpaceSlotData
---@field ObjectSlotId FName
---@field ConnectedChairComponenetName FName
---@field ObjectSlot FB1ObjectSlotData
---@field PostureTags TMap<FName, FName>
local FB1SlotComponentData = {}



---@class FB1SocialEventActionCondition
---@field RoleId FName
---@field GenderType EB1GenderType
---@field Count int32
local FB1SocialEventActionCondition = {}



---@class FB1SocialEventActionInfo
---@field ActionId FName
---@field VisibleConditions TArray<FB1SocialEventActionCondition>
---@field InteractionBagId FName
---@field InteractionTargetInfo FB1SocialEventInteractionTargetInfo
---@field bCanPlayAll boolean
---@field EvnetTargetInfo FB1SiteEventTargetInfo
---@field ActionDelayMinute int32
local FB1SocialEventActionInfo = {}



---@class FB1SocialEventActionStateData
---@field ActionId FName
---@field InteractionBagId FName
---@field State EB1SocialEventActionState
---@field NeedPlaceObjectDtId FName
---@field AntionRoleText FText
local FB1SocialEventActionStateData = {}



---@class FB1SocialEventInteractionTargetInfo
---@field TargetType EB1SocialEventActionTargetType
---@field TargetId FName
local FB1SocialEventInteractionTargetInfo = {}



---@class FB1SocialEventRecommendSiteInfo
---@field MapName FName
---@field SiteIds TArray<FName>
local FB1SocialEventRecommendSiteInfo = {}



---@class FB1SocialEventStateData
---@field SocialEventDtId FName
---@field CustomEventName FString
---@field SiteId FName
---@field EventStartTime int64
---@field EventEndTime int64
---@field IsScenarioFlag boolean
---@field ScenarioActionStateDatas TMap<FName, FB1SocialEventActionStateData>
---@field NormalActionStateDatas TMap<FName, FB1SocialEventActionStateData>
local FB1SocialEventStateData = {}



---@class FB1SocialEventTemplateTableRow : FB1SiteEventTableRow
---@field PresetObjectCategory FName
---@field GuideMainTextId FString
---@field GuideSubTextId FString
---@field ActionInfos TArray<FB1SocialEventActionInfo>
---@field RecommendSiteInfos TArray<FB1SocialEventRecommendSiteInfo>
local FB1SocialEventTemplateTableRow = {}



---@class FB1SpawnerSpawnInfo
---@field EntityID FB1EntityId
---@field SpawnerType EB1SpawnerType
---@field WorldLocation FVector
---@field WorldRotation FRotator
---@field DefaultMeshIdList TArray<FName>
---@field OverrideMeshIdList TArray<FName>
local FB1SpawnerSpawnInfo = {}



---@class FB1SpeechBubbleData
---@field ListKey FString
---@field MessageTextId FString
---@field Icon TSoftObjectPtr<UTexture2D>
---@field SpeechBubbleOption EB1SpeechBubbleOption
---@field IntervalSec float
---@field LifeTime float
---@field bOverride boolean
---@field Probability float
local FB1SpeechBubbleData = {}



---@class FB1SpeechBubbleTableRow : FB1TableRowBase
---@field ID FName
---@field SpeechBubbleData TArray<FB1SpeechBubbleData>
local FB1SpeechBubbleTableRow = {}



---@class FB1StabilitySelectionList
---@field StabilitySelectionList TMap<FName, float>
local FB1StabilitySelectionList = {}



---@class FB1StableDiffusionMaterialInfo
---@field ID FName
---@field DesplayNameStrId FString
---@field DescStrId FString
---@field Roughness float
---@field Metallic float
local FB1StableDiffusionMaterialInfo = {}



---@class FB1StairsFlight : FB1StairsFlightDef
---@field FlightTransform FTransform
---@field FlightBounds FBox
---@field LandingTransform FTransform
---@field LandingBounds FBox
---@field BottomTransform FTransform
local FB1StairsFlight = {}



---@class FB1StairsFlightDef
---@field LandingType EB1StairsLanding
---@field Left int32
---@field Right int32
---@field Steps int32
local FB1StairsFlightDef = {}



---@class FB1StairsObjectSaveData
---@field Version int32
---@field StairsRise float
---@field StairsSpaceHeight float
---@field StepUnitWidth int32
---@field StepUnitGoing float
---@field StepUnitRise float
---@field StepHeight float
---@field StringerHeight float
---@field LandingDepth int32
---@field LandingFloorHeight float
---@field LandingSlabHeight float
---@field TopLandingDepth int32
---@field Design TArray<FB1StairsFlightDef>
---@field AttachedFloor int32
---@field AttachedWall int64
---@field AttachType EB1StairsAttach
---@field AttachDirection EB1StairsAttachDirection
---@field EnterCheckBoxDisallowVertices TArray<FVector>
local FB1StairsObjectSaveData = {}



---@class FB1Stat
---@field Value float
---@field ProbabilityRatio float
---@field StatMax float
---@field StatMin float
---@field NPCStatMin float
local FB1Stat = {}



---@class FB1StatAutoMotiveSet
---@field Time float
---@field Desire float
local FB1StatAutoMotiveSet = {}



---@class FB1StatBasicInfo
---@field StatType EB1StatType
---@field IsDesire boolean
---@field StateType EB1StateType
---@field MinValue float
---@field MaxValue float
---@field InitialValue float
local FB1StatBasicInfo = {}



---@class FB1StatDecayInfo
---@field Goal float
---@field Value float
---@field GoalScriptId FName
local FB1StatDecayInfo = {}



---@class FB1StatDesireAgingVariationInfo
---@field Infant float
---@field Toddler float
---@field Child float
---@field LowTeen float
---@field HighTeen float
---@field Youth float
---@field Adult float
---@field Old float
---@field Elderly float
local FB1StatDesireAgingVariationInfo = {}



---@class FB1StatDesireInfo
---@field PriorityLevel int32
---@field PriorityValue float
---@field StatDesireGraph TArray<FB1StatToDesireGraph>
local FB1StatDesireInfo = {}



---@class FB1StatDisplayInfo
---@field DisplayNameTextId FString
---@field DescTextId FString
---@field Icon TSoftObjectPtr<UObject>
---@field RangeDisplayInfoList TArray<FB1StatRangeDisplayInfo>
local FB1StatDisplayInfo = {}



---@class FB1StatEditorLog
---@field ID FName
---@field DateTime FDateTime
---@field DiffValue float
---@field ResultValue float
---@field Reason EB1ScriptReason
local FB1StatEditorLog = {}



---@class FB1StatEventTableRow : FB1TableRowBase
---@field ID FName
---@field TriggerData FB1StatEventTriggerData
---@field EventConditions TArray<FB1Condition>
---@field EventExecutes TArray<FB1Execute>
local FB1StatEventTableRow = {}



---@class FB1StatEventTriggerData
---@field StatName FName
---@field MinStat int32
---@field MaxStat int32
---@field Probability float
---@field EventTime int32
local FB1StatEventTriggerData = {}



---@class FB1StatInitial
---@field ID FName
---@field Value float
local FB1StatInitial = {}



---@class FB1StatLocomotionAnimInfo
---@field StatId FName
---@field StatValue float
---@field IdleRandomAnims TArray<FB1RandomAnimationInfo>
---@field StatWalkAnim TSoftObjectPtr<UAnimSequenceBase>
---@field MinNormalWalkTime float
---@field MaxNormalWalkTime float
---@field bDisableJog boolean
local FB1StatLocomotionAnimInfo = {}



---@class FB1StatLocomotionTableRow : FB1TableRowBase
---@field ID FName
---@field Gender EB1GenderType
---@field AnimGrowthStep EB1AnimGrowthStep
---@field StatLocomotions TArray<FB1StatLocomotionAnimInfo>
local FB1StatLocomotionTableRow = {}



---@class FB1StatOnRangeChangedScript
---@field From float
---@field To float
---@field EnterScriptId FName
---@field ExitScriptId FName
local FB1StatOnRangeChangedScript = {}



---@class FB1StatRangeDisplayInfo
---@field ListKey FString
---@field Step int32
---@field MinValue int32
---@field MaxValue int32
---@field DisplayNameTextId FString
---@field DisplayNameTextColorId FName
local FB1StatRangeDisplayInfo = {}



---@class FB1StatTableRow : FB1TableRowBase
---@field ID FName
---@field StatBasicInfo FB1StatBasicInfo
---@field StatDisplayInfo FB1StatDisplayInfo
---@field StatDecayInfo FB1StatDecayInfo
---@field StatDesireInfo FB1StatDesireInfo
---@field AutoMotiveTimeOffset float
---@field AutoMotiveSet TArray<FB1StatAutoMotiveSet>
---@field StatOnRangeChangedScripts TArray<FB1StatOnRangeChangedScript>
local FB1StatTableRow = {}



---@class FB1StatToDesireGraph
---@field DesireValue float
---@field Tier EB1StatServiceTier
---@field AgingVariation FB1StatDesireAgingVariationInfo
local FB1StatToDesireGraph = {}



---@class FB1State
---@field StateGroupId FName
---@field StateId FName
---@field FXHandleId int64
local FB1State = {}



---@class FB1StateGroupInfo
---@field StateGroupId FName
---@field StateInfo TArray<FB1StateInfo>
local FB1StateGroupInfo = {}



---@class FB1StateInfo
---@field StateName FName
---@field StartScriptId FName
---@field EndScriptId FName
---@field StateVariations TArray<FB1StateVariationInfo>
---@field bNeedTickUpdate boolean
local FB1StateInfo = {}



---@class FB1StatePlayFXData
---@field statePlayFXVariationData TMap<FName, FB1StatePlayFXVariationData>
local FB1StatePlayFXData = {}



---@class FB1StatePlayFXVariationData
---@field FXAssetList TMap<int32, UClass>
local FB1StatePlayFXVariationData = {}



---@class FB1StatePriorityTableRow : FB1TableRowBase
---@field ID FName
---@field StateType FName
---@field Priority int32
local FB1StatePriorityTableRow = {}



---@class FB1StateUIData
local FB1StateUIData = {}


---@class FB1StateVariation
---@field VariationType EB1StateVariationType
---@field S1 FName
---@field F1 float
---@field StaticMeshAsset TSoftObjectPtr<UStaticMesh>
---@field FXAsset UClass
---@field AnimId FName
---@field TextureAsset TSoftObjectPtr<UTexture>
---@field SoundAsset UMetaSoundSource
---@field VisibilityComponentName FName
local FB1StateVariation = {}



---@class FB1StateVariationInfo
---@field StateVariationType EB1StateVariationType
---@field AssetPath FString
---@field S1 FName
---@field F1 float
local FB1StateVariationInfo = {}



---@class FB1StateVariationTableRow : FB1TableRowBase
---@field ID FName
---@field StateGroupInfo TArray<FB1StateGroupInfo>
local FB1StateVariationTableRow = {}



---@class FB1StaticMeshAnimData
---@field MeshName FName
---@field Location UCurveVector
---@field Rotation UCurveVector
---@field Scale UCurveVector
---@field bReversePlay boolean
---@field bLoop boolean
---@field bPendingFinishOnStop boolean
local FB1StaticMeshAnimData = {}



---@class FB1StaticMeshAnimDataList
---@field Data TArray<FB1StaticMeshAnimData>
local FB1StaticMeshAnimDataList = {}



---@class FB1StoreConditionTableRow : FB1TableRowBase
---@field ID FName
---@field EnableConditions TArray<FB1Condition>
local FB1StoreConditionTableRow = {}



---@class FB1StringTableHandle
---@field StringTable UStringTable
---@field NameSpace FName
---@field Key FString
local FB1StringTableHandle = {}



---@class FB1StudioMannequinObjectSaveData
---@field CharacterEntityId FB1EntityId
---@field bIsSelectedAppearance boolean
---@field CopyAppearanceSetting FB1AppearanceSetting
---@field BodyPoseItemName FString
---@field FacePoseItemName FString
local FB1StudioMannequinObjectSaveData = {}



---@class FB1StudioPoseData
---@field GrowthStep EB1GrowthStep
---@field AnimPoseList TArray<FB1StudioPoseItem>
local FB1StudioPoseData = {}



---@class FB1StudioPoseItem
---@field Name FString
---@field Icon TSoftObjectPtr<UObject>
---@field IsMovingMotion boolean
---@field AnimPose TSoftObjectPtr<UAnimSequence>
---@field PoseType EB1PoseType
local FB1StudioPoseItem = {}



---@class FB1SubActionAnimData
---@field bRotateToTargetWithAnimation boolean
---@field bRotateToTargetInstantly boolean
---@field AnimIds TArray<FName>
local FB1SubActionAnimData = {}



---@class FB1SubActionParam
local FB1SubActionParam = {}


---@class FB1SyncAnimInfo
---@field OwnerEntityId FB1EntityId
---@field Position float
---@field Tag FName
local FB1SyncAnimInfo = {}



---@class FB1TableRowBase : FTableRowBase
local FB1TableRowBase = {}


---@class FB1TableRowName
---@field RowName FName
local FB1TableRowName = {}



---@class FB1TableRowValidateReport
---@field ErrorLogs TArray<FString>
---@field WarningLogs TArray<FString>
local FB1TableRowValidateReport = {}



---@class FB1TalkFixedPositionConditionTableRow : FB1TableRowBase
---@field ID FName
---@field Conditions TArray<FB1Condition>
local FB1TalkFixedPositionConditionTableRow = {}



---@class FB1TalkInstanceId
---@field Value int64
local FB1TalkInstanceId = {}



---@class FB1TalkInteractionStartTalk
---@field RandomPickInteractionBagTagList TArray<FName>
---@field RandomPickTalkNatureList TArray<EB1TalkNature>
---@field PickAllTalkNatureList TArray<EB1TalkNature>
---@field PickAllTalkNatureListMaxCount int32
local FB1TalkInteractionStartTalk = {}



---@class FB1TalkRandomPoolTableRow : FB1TableRowBase
---@field ID FName
---@field SpeakerPool FB1TalkRolePool
---@field ListenerPool FB1TalkRolePool
---@field FinishScriptPool TArray<FName>
local FB1TalkRandomPoolTableRow = {}



---@class FB1TalkRefuseConditionTableRow : FB1TableRowBase
---@field ID FName
---@field RefuseConditions TArray<FB1Condition>
local FB1TalkRefuseConditionTableRow = {}



---@class FB1TalkRolePool
---@field FullBodyAnimPool TArray<FB1BodyAnimInfo>
---@field UpperBodyAnimPool TArray<FB1BodyAnimInfo>
---@field FaceAnimPool TArray<FName>
local FB1TalkRolePool = {}



---@class FB1TalkSelectionRelationshipData
---@field RelationshipStatId FName
---@field RelationshipDtId FName
---@field StatData FB1RelationshipStatData
local FB1TalkSelectionRelationshipData = {}



---@class FB1TalkSelectionTableRow : FB1TableRowBase
---@field ID FName
---@field TalkType FName
---@field DisplayStringTextId FString
---@field ConditionId FName
---@field DisplayIcon TSoftObjectPtr<UObject>
---@field DisplayIconColorId FName
---@field InteractionBagList TArray<FName>
---@field LeftMarkerId FName
local FB1TalkSelectionTableRow = {}



---@class FB1TargetFilterInfo
---@field TargetFilterId FName
---@field ExcuteInteractionId FName
local FB1TargetFilterInfo = {}



---@class FB1TargetFilterTableRow : FB1TableRowBase
---@field ID FName
---@field FilterType EB1TargetFilterType
---@field ResultType EB1FilterResultType
---@field S1 FName
---@field S2 FName
---@field F1 float
---@field F2 float
---@field SearchRange float
local FB1TargetFilterTableRow = {}



---@class FB1TargetFilters
---@field FilterCircle FB1Filter_AreaCircle
---@field FilterCylinder FB1Filter_AreaCylinder
---@field FilterBox FB1Filter_AreaBox
---@field FilterLineTrace FB1Filter_LineTrace
---@field FilterObjectTag FB1Filter_ObjectTag
---@field FilterFacing FB1Filter_Facing
---@field Prob float
---@field Conditions TArray<FB1Condition>
local FB1TargetFilters = {}



---@class FB1TargetSlotParam
local FB1TargetSlotParam = {}


---@class FB1TaskInfo
---@field Step int32
---@field StepTargetFilterIds TArray<FName>
---@field RolePlayingInfos TArray<FB1RolePlayingInfo>
local FB1TaskInfo = {}



---@class FB1Tax
---@field DefaultFee float
---@field UsageFee float
local FB1Tax = {}



---@class FB1TemperatureConfig
---@field MinTemperature int32
---@field MaxTemperature int32
---@field Ratio float
---@field Weathers TArray<FB1WeatherConfig>
local FB1TemperatureConfig = {}



---@class FB1TemperatureRangeConfig
---@field TemperatureRange EB1TemperatureRange
---@field MinTemperature int32
---@field MaxTemperature int32
local FB1TemperatureRangeConfig = {}



---@class FB1TextTableRow : FB1TableRowBase
---@field ID FName
---@field Text FString
local FB1TextTableRow = {}



---@class FB1Texture2DTableRow : FB1TableRowBase
---@field ID FName
---@field Texture2D TSoftObjectPtr<UObject>
local FB1Texture2DTableRow = {}



---@class FB1ThemeColorInfo
---@field WidgetSwitcherIndex int32
---@field TitleColor FLinearColor
---@field DescColor FLinearColor
---@field LinkColor FLinearColor
---@field TimeColor FLinearColor
local FB1ThemeColorInfo = {}



---@class FB1ThumbnailCameraSetting
---@field Offset FVector
---@field Rotate FRotator
---@field CaemraFOV float
local FB1ThumbnailCameraSetting = {}



---@class FB1ThumbnailFilter
---@field FilterNames TArray<FName>
---@field FilterAccNames TArray<FName>
local FB1ThumbnailFilter = {}



---@class FB1TimeTaskId
---@field Value int64
local FB1TimeTaskId = {}



---@class FB1Timeline
---@field Name FName
---@field Priority int32
---@field Conditions TArray<FB1Condition>
---@field Schedules TArray<FB1Schedule>
---@field CompanyId FName
---@field AvaliableDayOfWeeksBitFlags uint8
local FB1Timeline = {}



---@class FB1TimelineRange
---@field StartTime uint32
---@field EndTime uint32
local FB1TimelineRange = {}



---@class FB1TimelineTableRow : FB1TableRowBase
---@field ID FName
---@field IsAutoBuildSchedule boolean
---@field Priority int32
---@field AvaliableDayOfWeeks TArray<EB1DayOfWeek>
---@field CompanyId FName
---@field CityId FName
---@field Conditions TArray<FB1Condition>
---@field Schedules TArray<FB1ScheduleDetail>
---@field AvaliableDayOfWeeksBitFlags uint8
local FB1TimelineTableRow = {}



---@class FB1TimerData
local FB1TimerData = {}


---@class FB1TimerHandle
---@field Handle uint64
local FB1TimerHandle = {}



---@class FB1TopViewCameraDynamicSkyPostProcessSetting
---@field TargetFindTag FName
---@field MinAOIntensity float
---@field MaxAOIntensity float
---@field AOIntensityCurve UCurveFloat
---@field MinAORadius float
---@field MaxAORadius float
---@field AORadiusCurve UCurveFloat
local FB1TopViewCameraDynamicSkyPostProcessSetting = {}



---@class FB1TopViewCameraShadowQualitySetting
---@field MinValue float
---@field MaxValue float
---@field AdditionalShadowQuality int32
local FB1TopViewCameraShadowQualitySetting = {}



---@class FB1TrafficLightAsset
---@field StaticMesh UStaticMesh
---@field Offset FTransform
---@field EndCullDistance int32
local FB1TrafficLightAsset = {}



---@class FB1TraitChemistryList
---@field TraitSelectId FName
---@field ChemistryInfo TArray<FB1ChemistryInfo>
local FB1TraitChemistryList = {}



---@class FB1TraitChemistryRewardTableRow : FB1TableRowBase
---@field ID FName
---@field TextId FString
---@field From int32
---@field To int32
local FB1TraitChemistryRewardTableRow = {}



---@class FB1TraitChemistryTableRow : FB1TableRowBase
---@field ID FName
---@field TraitChemistryList TArray<FB1TraitChemistryList>
local FB1TraitChemistryTableRow = {}



---@class FB1TraitEventData
---@field TriggerType EB1TraitEventTriggerType
---@field F1 float
---@field F2 float
local FB1TraitEventData = {}



---@class FB1TraitEventTrigger
---@field TriggerType EB1TraitEventTriggerType
---@field S1 FName
---@field S2 FName
---@field F1 float
---@field F2 float
local FB1TraitEventTrigger = {}



---@class FB1TraitFeatureInfo
---@field ListKey FString
---@field FeatureTextId FString
local FB1TraitFeatureInfo = {}



---@class FB1TraitHopeLifeTableRow : FB1TableRowBase
---@field ID FName
---@field Category EB1TraitCategoryType
---@field AgeAvailable TArray<EB1GrowthStep>
---@field AddScriptId FName
---@field RemoveScriptId FName
---@field TraitScripts TArray<FB1TraitScript>
local FB1TraitHopeLifeTableRow = {}



---@class FB1TraitIdData
---@field TraitId FName
---@field bIsHopeLifeTrait boolean
local FB1TraitIdData = {}



---@class FB1TraitKeywordInfo
---@field ListKey FString
---@field KeywordTextId FString
local FB1TraitKeywordInfo = {}



---@class FB1TraitRelationship
---@field ID FName
---@field ListKey FString
---@field TraitA FName
---@field TraitB FName
---@field PositiveLevel int32
local FB1TraitRelationship = {}



---@class FB1TraitRelationshipTableRow : FB1TableRowBase
---@field ID FName
---@field TraitRelationshipList TArray<FB1TraitRelationship>
local FB1TraitRelationshipTableRow = {}



---@class FB1TraitReward
---@field TraitId FName
---@field Bonus int32
local FB1TraitReward = {}



---@class FB1TraitScript
---@field TraitEntryType EB1TraitEntryType
---@field CheckInterval float
---@field NeedCharacterCount int32
---@field CircleConstraintSquared float
---@field EventTriggers TArray<FB1TraitEventTrigger>
---@field Conditions TArray<FB1Condition>
---@field Executes TArray<FB1Execute>
local FB1TraitScript = {}



---@class FB1TraitSelect3TableRow : FB1TableRowBase
---@field ID FName
---@field TraitCategoryTextId FString
---@field TraitIds TArray<FName>
local FB1TraitSelect3TableRow = {}



---@class FB1TraitSelectInfo
---@field TraitId FName
---@field OppositeTraitId FName
---@field OwnerActorTagName FName
local FB1TraitSelectInfo = {}



---@class FB1TraitTableRow : FB1TableRowBase
---@field ID FName
---@field Category EB1TraitCategoryType
---@field TraitNameTextId FString
---@field TraitDescTextId FString
---@field SymbolIcon TSoftObjectPtr<UTexture2D>
---@field TraitValuePointId FName
---@field PerspectiveIdList TArray<FName>
---@field KeywordInfoList TArray<FB1TraitKeywordInfo>
---@field FeatureInfoList TArray<FB1TraitFeatureInfo>
---@field AgeAvailable TArray<EB1GrowthStep>
---@field ChangeByGrowthStep TArray<FB1GrowthChangeData>
---@field AddTraitScriptId FName
---@field RemoveTraitScriptId FName
---@field RelatedPreferenceId FName
---@field TraitScripts TArray<FB1TraitScript>
local FB1TraitTableRow = {}



---@class FB1TraitValuePointInfo
---@field TraitValueId FName
---@field Min float
---@field Max float
local FB1TraitValuePointInfo = {}



---@class FB1TraitValuePointTableRow : FB1TableRowBase
---@field ID FName
---@field TraitValuePointInfoList TArray<FB1TraitValuePointInfo>
local FB1TraitValuePointTableRow = {}



---@class FB1TraitValueTableRow : FB1TableRowBase
---@field ID FName
local FB1TraitValueTableRow = {}



---@class FB1TranslationPostureState
local FB1TranslationPostureState = {}


---@class FB1TutorialContent
---@field SubTopicId FName
---@field SubTitleTextId FString
---@field DescTextIdList TArray<FB1DescriptionId>
local FB1TutorialContent = {}



---@class FB1UILayerTableRow : FB1TableRowBase
---@field ID FName
---@field ZOrder int32
---@field bMouseEnabled boolean
---@field HideLayers TArray<FName>
local FB1UILayerTableRow = {}



---@class FB1UIOpenGroup
---@field GroupName FName
---@field CloseWidgetListWhenOpen TArray<EB1UIType>
---@field OpenWidgetListWhenClose TArray<EB1UIType>
---@field CloseWidgetListWhenClose TArray<EB1UIType>
local FB1UIOpenGroup = {}



---@class FB1UITableRow : FB1TableRowBase
---@field ID EB1UIType
---@field Widget TSoftClassPtr<UUserWidget>
---@field ZOrder int32
---@field bIsShowWhenCreated boolean
---@field LayerName FB1TableRowName
---@field CreationType EB1WidgetCreationType
---@field CustomCursorSetName FName
---@field bAlwaysShowCursor boolean
---@field bDisableDLSSFG boolean
---@field UIOpenGroup FB1UIOpenGroup
local FB1UITableRow = {}



---@class FB1UITooltipTableRow : FB1TableRowBase
---@field ID EB1TooltipWidgetType
---@field Widget TSoftClassPtr<UUserWidget>
local FB1UITooltipTableRow = {}



---@class FB1UpdateQuest
---@field QuestId FName
---@field MissionDtId FName
---@field IsRemoveQuest boolean
---@field HistoryElement FB1QuestHistoryElement
local FB1UpdateQuest = {}



---@class FB1VehicleAssetDescription
---@field Length float
---@field Width float
---@field Height float
---@field FrontAxle float
---@field RearAxle float
---@field MaxSeatNum int32
local FB1VehicleAssetDescription = {}



---@class FB1VehicleColorData
---@field ColorId FName
---@field UIHexColor FString
---@field IngameColor float
local FB1VehicleColorData = {}



---@class FB1VehicleDefaultSetting
---@field SeatData TMap<EB1VehicleSeat, FB1VehicleSeatDefaultSetting>
local FB1VehicleDefaultSetting = {}



---@class FB1VehicleDynamicData
---@field bValid boolean
---@field Speed float
---@field SteeringAngle float
local FB1VehicleDynamicData = {}



---@class FB1VehicleMapIconSetting
---@field DisplayName FString
---@field Icon TSoftObjectPtr<UObject>
---@field IconColor FLinearColor
---@field IconBgColor FLinearColor
local FB1VehicleMapIconSetting = {}



---@class FB1VehicleMovementSetting
---@field MaxWheelAngle float
---@field MaxForwardVelocity float
---@field MaxReverseVelocity float
---@field MaxWheelRotateTime float
---@field MaxWheelReturnRotateTime float
---@field SteeringRestoreSpeed float
---@field SteeringDecelerationRate float
---@field SteeringDecelerationTime float
---@field MaxAccelerationTime float
---@field AccelerationRestoreSpeed float
---@field MaxReverseAccelerationTime float
---@field ReverseAccelerationRestoreSpeed float
---@field HandBrakeDeaccelerationRate float
---@field HandBrakeDeaccelerationTime float
local FB1VehicleMovementSetting = {}



---@class FB1VehicleOwnershipData
---@field MainVehicleIndex int32
---@field RidingVehicleEntityId FB1EntityId
---@field LastRideVehicleEntityId FB1EntityId
---@field OwnedVehicleEntityIdList TArray<FB1EntityId>
local FB1VehicleOwnershipData = {}



---@class FB1VehiclePart
---@field PartType EB1VehiclePartType
---@field DefaultState FName
---@field MeshName TArray<FName>
---@field StateSettings TArray<FB1VehiclePartState>
local FB1VehiclePart = {}



---@class FB1VehiclePartCache
---@field DefaultState FName
---@field MeshName TArray<FName>
---@field StateSettings TMap<FName, FB1VehiclePartState>
local FB1VehiclePartCache = {}



---@class FB1VehiclePartData
---@field MeshName TArray<FName>
---@field State FName
---@field StateSettings TMap<FName, FB1VehiclePartState>
local FB1VehiclePartData = {}



---@class FB1VehiclePartState
---@field State FName
---@field Type EB1VehiclePartActionType
---@field S1 FName
local FB1VehiclePartState = {}



---@class FB1VehiclePrimitiveCustomData
---@field RandomFraction float
---@field bFrontLeftRunningLights boolean
---@field bFrontRightRunningLights boolean
---@field bRearLeftRunningLights boolean
---@field bRearRightRunningLights boolean
---@field bLeftBrakeLights boolean
---@field bRightBrakeLights boolean
---@field bLeftTurnSignalLights boolean
---@field bRightTurnSignalLights boolean
---@field bLeftHeadlight boolean
---@field bRightHeadlight boolean
---@field bReversingLights boolean
---@field bAccessoryLights boolean
local FB1VehiclePrimitiveCustomData = {}



---@class FB1VehicleSeatDefaultSetting
---@field InteractionSlotName FName
---@field SeatSlotCompName FName
local FB1VehicleSeatDefaultSetting = {}



---@class FB1VehicleSetting
---@field MetaSoundData FB1VehicleSoundSetting
local FB1VehicleSetting = {}



---@class FB1VehicleSoundSetting
---@field MainSound TSoftObjectPtr<UMetaSoundSource>
---@field SpawnSound TSoftObjectPtr<UMetaSoundSource>
---@field DespawnSound TSoftObjectPtr<UMetaSoundSource>
local FB1VehicleSoundSetting = {}



---@class FB1VehicleSpawnInfo
---@field EntityID FB1EntityId
---@field OwnerEntityId int64
---@field VehicleDtId FName
---@field WorldLocation FVector
---@field WorldRotation FRotator
---@field ControlSubject EB1VehicleControlSubject
---@field ColorId FName
---@field ColorLookUp float
---@field SimulationDriverMeshId FName
---@field LightFlag EB1VehicleLight
local FB1VehicleSpawnInfo = {}



---@class FB1VehicleTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayNameTextId FString
---@field DescriptionTextId FString
---@field VehicleTemplateId FName
---@field Asset TSoftObjectPtr<UBlueprint>
---@field StaticMeshAsset TSoftObjectPtr<UStaticMesh>
---@field SimulationDriverMeshSetId FName
---@field Icon TSoftObjectPtr<UObject>
---@field bPurchaseable boolean
---@field SimulationSpawnableLevel TArray<FName>
---@field Price int32
---@field bDisableSimulationRandomVehicleColor boolean
---@field Color TArray<FB1VehicleColorData>
---@field MovementSetting FB1VehicleMovementSetting
local FB1VehicleTableRow = {}



---@class FB1VehicleTemplateTableRow : FB1TableRowBase
---@field ID FName
---@field ObjectSelectionId FName
---@field Asset TSoftObjectPtr<UBlueprint>
---@field PartList TArray<FB1VehiclePart>
---@field AssetDescription FB1VehicleAssetDescription
---@field PartMap TMap<EB1VehiclePartType, FB1VehiclePartCache>
local FB1VehicleTemplateTableRow = {}



---@class FB1VideoChatbotTableRow : FB1ChatbotTableRowBase
---@field ScreenImage TSoftObjectPtr<UTexture2D>
---@field VoiceIndex int32
---@field ChatbotDTMap TMap<FName, FSoftObjectPath>
local FB1VideoChatbotTableRow = {}



---@class FB1VideoPlayerInfo
---@field MediaSource FSoftObjectPath
---@field FadeOutSec float
---@field WidgetAnimationName FName
local FB1VideoPlayerInfo = {}



---@class FB1VoiceResourcesTableRow : FB1TableRowBase
---@field ID FName
---@field VoiceSelectMap TMap<FName, TSoftObjectPtr<UMetaSoundSource>>
local FB1VoiceResourcesTableRow = {}



---@class FB1VoiceTableRow : FB1TableRowBase
---@field ID FName
---@field InfantId FName
---@field ToddlerId FName
---@field ChildId FName
---@field LowTeenId FName
---@field HighTeenId FName
---@field YouthId FName
---@field AdultId FName
---@field OldId FName
---@field ElderlyId FName
local FB1VoiceTableRow = {}



---@class FB1WallEntry
---@field WallIcon TSoftObjectPtr<UObject>
---@field WallHeight float
---@field WallPrice int64
---@field DisplayNameTextId FString
---@field DescriptionTextId FString
---@field HalfIcon TSoftObjectPtr<UObject>
---@field HalfHeight FVector2D
---@field HalfDisplayNameTextId FString
---@field HalfDescriptionTextId FString
local FB1WallEntry = {}



---@class FB1WeatherConfig
---@field Weather EB1WeatherType
---@field Ratio float
---@field Step1_Ratio float
---@field Step2_Ratio float
---@field Step3_Ratio float
local FB1WeatherConfig = {}



---@class FB1WeatherDetail
---@field WeatherAssetName FString
---@field Temperature FString
---@field DayIcon TSoftObjectPtr<UObject>
---@field NightIcon TSoftObjectPtr<UObject>
---@field EditIcon TSoftObjectPtr<UObject>
local FB1WeatherDetail = {}



---@class FB1WeatherDetailSetting
---@field MaterialParameterCollection TSoftObjectPtr<UMaterialParameterCollection>
---@field MaterialControlCurves TMap<FName, TSoftObjectPtr<UCurveFloat>>
local FB1WeatherDetailSetting = {}



---@class FB1WeatherInfo
---@field Weather FString
---@field Step int32
---@field Temperature int32
---@field StartTime int32
---@field EndTime int32
local FB1WeatherInfo = {}



---@class FB1WeatherSetting
---@field TransitionTime float
---@field DetailSettings TArray<FB1WeatherDetailSetting>
local FB1WeatherSetting = {}



---@class FB1WeatherTableRow : FB1TableRowBase
---@field WeatherTextId FString
---@field WeatherSteps TArray<FB1WeatherDetail>
---@field OnStartConditions TArray<FB1Condition>
---@field OnStartScripts TArray<FB1Execute>
---@field OnEndConditions TArray<FB1Condition>
---@field OnEndScripts TArray<FB1Execute>
local FB1WeatherTableRow = {}



---@class FB1WeatherTriggerTableRow : FB1TableRowBase
---@field ID FName
---@field MapId FName
---@field TriggerType EB1WeatherTriggerType
---@field SubId FName
---@field ScriptIds TArray<FName>
local FB1WeatherTriggerTableRow = {}



---@class FB1WidgetMarkerTableRow : FB1TableRowBase
---@field ID FName
---@field DisplayNameTextId FString
---@field ColorId FName
---@field IconId FName
---@field bIsKarmaIcon boolean
local FB1WidgetMarkerTableRow = {}



---@class FB1WorkMissionHistoryData
---@field MissionConditionStates TMap<int32, FB1MissionConditionState>
local FB1WorkMissionHistoryData = {}



---@class FB1WorkShift
---@field Index int32
---@field PrepareStatId FName
---@field SalaryPerDay int32
---@field Headcount int32
---@field StartingEmployeeCount int32
---@field StartingSelectGender EB1GenderType
---@field StartingSelectGenderCount int32
---@field MinGrowthStep EB1GrowthStep
---@field MaxGrowthStep EB1GrowthStep
---@field bRecruitable boolean
---@field WorkSchedule TArray<FB1WorkTimeSchedule>
local FB1WorkShift = {}



---@class FB1WorkTimeSchedule
---@field DayOfWeek EB1DayOfWeek
---@field StartTime int32
---@field EndTime int32
---@field MaxExtraWorkMinute int32
---@field WorkMissionId FName
local FB1WorkTimeSchedule = {}



---@class FB1WorldDecorationSpawnCountDataList
---@field DecorationSpawnCountData TMap<FName, float>
local FB1WorldDecorationSpawnCountDataList = {}



---@class FB1WorldLevelSequenceInfoList
---@field LevelSequenceInfoList TMap<FName, FB1LevelSequenceInfoList>
---@field bCanInputMouse boolean
local FB1WorldLevelSequenceInfoList = {}



---@class FB1WorldMapCameraBlendSetting
---@field BlendDistance float
---@field BlendTime float
---@field EaseFunc EEasingFunc::Type
local FB1WorldMapCameraBlendSetting = {}



---@class FB1WorldMapCameraSetting
---@field LevelName FName
---@field CameraLocation FVector
---@field CameraRotation FRotator
---@field CameraDistance float
---@field CameraMoveSpeed float
---@field MapModeMinMaxX FVector2D
---@field MapModeMinMaxY FVector2D
---@field PostProcessSetting FB1WorldMapPostProcessSetting
---@field PrevCameraBlendOut FB1WorldMapCameraBlendSetting
---@field CurrentCameraBlendIn FB1WorldMapCameraBlendSetting
---@field CurrentCameraBlendOut FB1WorldMapCameraBlendSetting
---@field PrevCameraBlendIn FB1WorldMapCameraBlendSetting
---@field HideMapModeDataLayerPath FString
---@field ShowMapModeDataLayerPath FString
---@field OceanLayerPath FString
local FB1WorldMapCameraSetting = {}



---@class FB1WorldMapPostProcessSetting
---@field PostProcessCurve UCurveFloat
---@field PostProcessCenterLocation FVector
---@field SoundId FName
local FB1WorldMapPostProcessSetting = {}



---@class FB1WorldMissionChecker
---@field MissionId FB1MissionId
---@field MissionDtId FName
---@field bIsRepeat boolean
---@field RepeatCount int32
---@field CheckType EB1WorldMissionCheckType
---@field MissionConditions TArray<FB1WorldMissionConditionChecker>
local FB1WorldMissionChecker = {}



---@class FB1WorldMissionConditionChecker
---@field Condition FB1MissionConditionData
---@field CurrentCount int32
---@field CompareType EB1CompareType
local FB1WorldMissionConditionChecker = {}



---@class FB1WorldMissionTableRow : FB1TableRowBase
---@field ID FName
---@field CheckType EB1WorldMissionCheckType
---@field bIsRepeat boolean
---@field RepeatCount int32
---@field Conditions TArray<FB1MissionConditionData>
---@field CompleteMissionId FName
---@field PlayingNotOldestFamilySystemMessageId FString
local FB1WorldMissionTableRow = {}



---@class FB1ZoiInformationProfileData
---@field MaxIconCount int32
---@field IconDisplayPriorityArray TArray<EB1RelationshipProfileType>
---@field WidgetPositionOffset FVector
---@field VisibleIconForUnlockedProfileArray TArray<EB1RelationshipProfileType>
---@field DisplayRadius float
---@field bDisplayRelatedZoi boolean
---@field DisplayEnabledTime float
---@field DisplayInterval float
---@field CandidateCheckInterval float
---@field UpdateIntervalOnDisplayAllMode float
---@field ToggleModeInterval float
---@field bCheckVisibilityWithLineTrace boolean
local FB1ZoiInformationProfileData = {}



---@class FB1ZoneGraphEdge
---@field ZoneIndex int32
---@field bRelateSameZoneConnectNode boolean
---@field SameZoneConnectInfo FB1SameZoneConnectEdgeInfo
---@field Cost int32
---@field ConnectedNodeIndex int32
---@field CachedPath TArray<FB1NavigationNode>
local FB1ZoneGraphEdge = {}



---@class FB1ZoneGraphNode
---@field ZoneIndex1 int32
---@field ZoneIndex1EnterLocation FVector
---@field ZoneIndex1ExitLocation FVector
---@field ZoneIndex2 int32
---@field ZoneIndex2EnterLocation FVector
---@field ZoneIndex2ExitLocation FVector
---@field ActorEntityId FB1EntityId
---@field ConnectedEdges TArray<FB1ZoneGraphEdge>
---@field NodeType EB1ZoneGrpahNodeType
---@field DoorIndexes TSet<int32>
---@field StairPathZone1ToZone2 TArray<FB1NavigationNode>
---@field StairPathZone1ToZone2Cost float
---@field StairPathZone2ToZone1 TArray<FB1NavigationNode>
---@field StairPathZone2ToZone1Cost float
---@field LadderHeight float
---@field LadderForwardVector FVector
local FB1ZoneGraphNode = {}



---@class FB1ZoneGraphZoneInfo
---@field ConnectedNodeIndex TArray<int32>
---@field ZoneFloorLevel int32
local FB1ZoneGraphZoneInfo = {}



---@class FB1ZoneIndexGraph
---@field ZoneIndex1 int32
---@field ZoneIndex2 int32
---@field DoorObjectIds TArray<int64>
local FB1ZoneIndexGraph = {}



---@class FB2HopeSlotInfo
---@field HopeId FName
---@field NextUpdateTime int64
---@field bFixedHope boolean
---@field bNew boolean
---@field MissionId FB1MissionId
local FB2HopeSlotInfo = {}



---@class FB2SiteCheckAvailableFirePosParam
---@field SiteId FName
---@field ObjectDtId FName
---@field FireId FB1FireId
---@field RequestPos FVector
---@field RequestRot FRotator
---@field PlacementFlag EB1PlacementFlag
local FB2SiteCheckAvailableFirePosParam = {}



---@class FB2SiteEntireSaveData
---@field EntityID FB1EntityId
---@field SiteId FName
---@field BuiltData FB1SiteAreaBuiltSaveData
---@field PathFindingData FB1SiteAreaPathFindingSaveData
---@field ObjectList TArray<FB1BuildModeGameObjectData>
local FB2SiteEntireSaveData = {}



---@class FGameObjectDecayInfo
---@field EntityID FB1EntityId
---@field Price int64
---@field WeatheringValue float
local FGameObjectDecayInfo = {}



---@class UB1AgingDataAsset : UB1DataAssetBase
---@field CharactersMaxAge int32
---@field GrowthStepChangeAges TArray<int32>
---@field GrowingStepToChangeContentElement EB1GrowthStep
---@field MaleDeadAgeWeightInfos TArray<FB1DeadAgeWeightInfo>
---@field FemaleDeadAgeWeightInfos TArray<FB1DeadAgeWeightInfo>
---@field ChangeGrowthStepMainPopupId FName
---@field ChangeGrowthStepMainPopupPerspectiveInheritanceMessageTextId FString
---@field ChangeGrowthStepMainPopupPerspectiveInheritanceMessageJoinTextId FString
---@field PreDespawnedCharactersAgingDeathScriptId FName
---@field PostDespawnedCharactersAgingDeathScriptId FName
local UB1AgingDataAsset = {}



---@class UB1AlertMessageDataAsset : UB1DataAssetBase
---@field ThemeColorMap TMap<FName, FB1ThemeColorInfo>
---@field MessageSettingMap TMap<EB1AlertType, FB1MessageSetting>
---@field TimerSettingMap TMap<EB1AlertType, float>
---@field DeleteTime float
local UB1AlertMessageDataAsset = {}



---@class UB1AmbitionDataAsset : UB1DataAssetBase
---@field PlayableGrowthStep EB1GrowthStep
---@field EmptyAmbitionIconId FName
---@field EmptyAmbitionText FString
---@field CompleteTextId FString
---@field UnplayableGrowthStepTextId FString
---@field CatOperatorUnableAmbitionTooltipTextId FString
---@field CatOperatorChangeAmbitionTooltipTextId FString
local UB1AmbitionDataAsset = {}



---@class UB1AnimationConfigDataAsset : UB1DataAssetBase
---@field RotationSpeed float
---@field RotationSpeedForBaby float
---@field MinTurnMoveAngle float
---@field MaxTurnMoveAngle float
---@field WalkLeanCurve UCurveFloat
---@field JogLeanCurve UCurveFloat
---@field BlendTimeWithMotionWarping float
---@field EnableUpperBodyLookAt FName
---@field EnableEyeLookAt FName
---@field LookAtLimit FRotator
---@field EyeLookAtLimit FRotator
---@field MaxObjectLookAtDist float
---@field MaxCharacterLookAtDist float
---@field MaxEyeLookAtDist float
---@field LookAtSpeedCurve UCurveFloat
---@field EyeLookAtSpeed float
---@field LookAtSocketName FName
---@field LookAtDestHeadWeight float
---@field LookAtDestUpperBodyWeight float
---@field LookAtDestSpeed float
---@field LookAtTargetInterval float
---@field LookAtTargetTime float
---@field LookAtTargetDistance float
---@field LookAtTargetPickRate float
---@field ChainBones TMap<EB1ChainBoneType, FB1ChainBone>
---@field bEnableBudget boolean
---@field BudgetInMs float
---@field SignificanceMaxDistance float
---@field MinFullTickWorkUnits int32
---@field AlwaysTickFalloffAggression float
---@field bAlwaysInterpolation boolean
---@field InterpolatedComponents int32
---@field MaxTickRate int32
---@field FrameRatesWithGameObjectLODs TArray<int32>
---@field AnimCachePathList TArray<FSoftObjectPath>
local UB1AnimationConfigDataAsset = {}



---@class UB1AppearanceFacePresetDataAsset : UB1DataAssetBase
---@field FacePresetList TMap<FName, FB1HeadDescription>
---@field FacePresetData TArray<FB1FacePresetItem>
---@field FacePresetIdForMakeupPreset TArray<FName>
---@field SkinSliderInitValueList TMap<FName, float>
---@field StringTableIdbySkinScalarParameterId TMap<FName, FString>
local UB1AppearanceFacePresetDataAsset = {}



---@class UB1AudioConfigDataAsset : UB1DataAssetBase
---@field CameraLocationInterpolationEndTime float
---@field bShoulderViewCameraAttachHead boolean
---@field CameraLocationInterpolationCurve UCurveFloat
---@field ShoulderViewListerLocationOffset FVector
---@field TopViewOffsetZValue float
---@field TopViewOffsetZCurve UCurveFloat
---@field BGMAudioBusAssetArray TArray<UAudioBus>
---@field MasterBGMMetaSound UMetaSoundSource
---@field AnyBGMTransitionData FB1BGMTransitionData
---@field ReadyNewPlaySound UMetaSoundSource
---@field TalkSoundMap TMap<EB1TalkSoundType, UMetaSoundSource>
---@field PositiveRelationshipSound UMetaSoundSource
---@field NegativeRelationshipSound UMetaSoundSource
---@field RelationshipChangedCommonAudioId FName
---@field RelationshipChangedPositiveAudioId FName
---@field RelationshipChangedNegativeAudioId FName
---@field RelationshipChangedPositiveLevel int32
---@field RelationshipChangedNegativeLevel int32
---@field EnvironmentSoundVolumeFramePerDelta float
---@field WeatherEachOtherTransitionTIme float
---@field MapModeEscapeWeatherFadeOutTIme float
---@field DuckingSoundControlBusMix USoundControlBusMix
---@field TimeOfDaySoundControlBusMix USoundControlBusMix
---@field PitchSoundControlBusMix USoundControlBusMix
---@field PauseAndResumeControlBusMix USoundControlBusMix
---@field VolumeSoundControlBusMixMap TMap<EB1AudioGroupType, USoundControlBusMix>
---@field BGMChannelSoundControlMixes TArray<USoundControlBusMix>
---@field RoomValueControlBusMix USoundControlBusMix
---@field LobbyControlBusMix USoundControlBusMix
---@field FovValueControlBusMix USoundControlBusMix
---@field VerticalDistanceValueControlBusMix USoundControlBusMix
---@field PauseSubmixes TArray<USoundSubmix>
---@field AccumulateProgressSoundTime float
---@field DopplerIntensity float
---@field DopplerSmoothingInterpSpeed float
---@field VehicleSoundFadeInOutTime float
---@field TransportAudioMap TMap<EB1TransportAudioResourceType, FName>
---@field TransportFadeOutTime float
local UB1AudioConfigDataAsset = {}



---@class UB1BodyShapeCustomizeDataAsset : UB1DataAssetBase
---@field FemaleBodyData TMap<EB1BodyAgeType, FB1BodyShapeCustomizeData>
---@field MaleBodyData TMap<EB1BodyAgeType, FB1BodyShapeCustomizeData>
---@field ShapeValueDeltaFromZeroForBodyMassCalibration float
local UB1BodyShapeCustomizeDataAsset = {}



---@class UB1BuffDataAsset : UB1DataAssetBase
---@field AllowedBuffIds TSet<FName>
local UB1BuffDataAsset = {}



---@class UB1BuildCommonDataAsset : UB1DataAssetBase
---@field BoxMesh TSoftObjectPtr<UStaticMesh>
---@field BoxMaterial TSoftObjectPtr<UMaterialInterface>
---@field BoxGuageMaterial TSoftObjectPtr<UMaterialInterface>
---@field ArrowMesh TSoftObjectPtr<UStaticMesh>
---@field BuildAreaMesh TSoftObjectPtr<UStaticMesh>
---@field BuildStartPointMesh TSoftObjectPtr<UStaticMesh>
---@field BuildStartPointMaterial TSoftObjectPtr<UMaterialInterface>
---@field BuildStartPointScale FVector
---@field BuildFinishFXClass TSubclassOf<UB1FXNiagaraObject>
---@field SlotDisableMesh TSoftObjectPtr<UStaticMesh>
---@field BuildAlpha float
---@field BuildEnableColor FLinearColor
---@field BuildDisableColor FLinearColor
---@field BuildWallOverlappedObjectColor FLinearColor
---@field WallEntries TArray<FB1WallEntry>
---@field WallElevatingOutlineColor FLinearColor
---@field WallElevatingOutlineThickness float
---@field WallElevatingColor FLinearColor
---@field WallElevatingThickness float
---@field WallElevatingDraggingUnit float
---@field DefaulHalfWallCover FName
---@field DefaulHalfWallRailing FName
---@field DefaulFoundationMold FName
---@field RequireSpaceOffsetRadius float
---@field RoofMaxHeight float
---@field RoofMinHeight float
---@field RoofMaxEavesHeight float
---@field MagnetToEdgeDist float
---@field AllowedFloorDistance float
---@field BuildAreaArrowDistance float
---@field FreeLocationSiteIds TArray<FName>
---@field NonPlaceableSiteIds TArray<FName>
---@field Shape3DScaleSlider TMap<FName, float>
---@field Shape3DOffsetSlider TMap<FName, float>
---@field SystemObjectFilters TArray<FName>
---@field BedObjectFilters TArray<FName>
---@field ToiletObjectFilters TArray<FName>
---@field CurtainObjectFilters TArray<FName>
local UB1BuildCommonDataAsset = {}



---@class UB1CameraJsonDataAsset : UB1DataAssetBase
---@field HiddenInTopViewTags TArray<FName>
---@field OuterWallTransparentViewTag FName
---@field InnerWallTransparentViewTag FName
---@field WindowActorTag FName
---@field DistantViewTag FName
---@field LineCullingTags TArray<FB1LineCullingTagEntry>
---@field DefaultCameraZoomDistance float
---@field CameraFloorHeightOffset float
---@field CameraFollowSpeed float
---@field WASDCameraMoveSpeed float
---@field LeftDragCameraMoveSpeed float
---@field RightDragCameraRotateSpeed float
---@field WheelCameraMoveAccelation float
---@field WheelCameraMoveDamping float
---@field WheelCameraMoveSpeedLimit FVector2D
---@field RoomCheckHeightOffset float
---@field PivotHeight float
---@field PivotHeightCheckDistance float
---@field CeilingObjectViewDistance float
---@field FovMin float
---@field FovMax float
---@field GameOptionPresetSetting FB1CameraGameOptionPresetSetting
local UB1CameraJsonDataAsset = {}



---@class UB1CaptureDataAsset : UB1DataAssetBase
---@field PortraitOffset FVector
---@field FemalePoseAnims TMap<EB1BodyAgeType, FB1PoseAnimationInfo>
---@field MalePoseAnims TMap<EB1BodyAgeType, FB1PoseAnimationInfo>
---@field PortraitRenderTargetSize int32
---@field EmotionPortraitRenderTargetSize int32
---@field ThumbnailBaseHeadId TMap<EB1GenderType, FName>
---@field FemaleDefalutGarmentId TMap<EB1GarmentType, FName>
---@field MaleDefalutGarmentId TMap<EB1GarmentType, FName>
local UB1CaptureDataAsset = {}



---@class UB1CatShopDataAsset : UB1DataAssetBase
---@field CatShopBuyPopupId FName
---@field CatShopBuyClickOverPriceStringId FString
---@field EnablePriceColor FLinearColor
---@field DisablePriceColor FLinearColor
local UB1CatShopDataAsset = {}



---@class UB1CatTalkDataAsset : UB1DataAssetBase
---@field SupportWebLink FString
---@field VideoWebLinkMap TMap<FName, FString>
---@field DefaultShowingMenuDepth int32
---@field BuildWorldDefaultShowingMenuDepth int32
---@field Threshold float
---@field Gap float
---@field Top3Suggestions FB1CatTalkTop3Suggestions
---@field FallbackTextIdListWhenNoResponse TArray<FString>
---@field PsycatTalkEndMessageSetting FB1PsycatTalkEndMessageSetting
local UB1CatTalkDataAsset = {}



---@class UB1CharacterAttributeDataAsset : UB1DataAssetBase
---@field MaxRelationShipSize int32
---@field MaxPersonalitySize int32
---@field GrowthStepMaxPerspectiveMap TMap<EB1GrowthStep, int32>
---@field MaxSkillSize int32
---@field MaxPreferenceSize int32
---@field MinPreferenceSize int32
---@field MaxJobSize int32
---@field CanMarryAgeMin int32
---@field CanBirthChildAgeTermMin int32
---@field CanBirthChildAgeTermMax int32
---@field SiblingAgeOffsetMin int32
---@field SiblingAgeOffsetMax int32
---@field SpouseAgeOffsetMin int32
---@field SpouseAgeOffsetMax int32
---@field CanEditGenderIdentityGrowthStep EB1GrowthStep
local UB1CharacterAttributeDataAsset = {}



---@class UB1CharacterCustomizeDataAsset : UB1DataAssetBase
---@field BodyAgeTypeByGrowthStep TMap<EB1GrowthStep, EB1BodyAgeType>
---@field FemaleBody TMap<EB1BodyAgeType, FB1CharacterBodyInfo>
---@field MaleBody TMap<EB1BodyAgeType, FB1CharacterBodyInfo>
---@field CustomizePresetId TMap<EB1GenderType, FName>
---@field DefaultPresetId TMap<EB1GenderType, FName>
---@field MakeUpBakingMaterials TMap<FName, TSoftObjectPtr<UMaterialInterface>>
---@field MakeUpBakedMaterial TSoftObjectPtr<UMaterialInterface>
---@field FemaleUndressedPreset TMap<EB1BodyAgeType, FName>
---@field MaleUndressedPreset TMap<EB1BodyAgeType, FName>
---@field FemaleHeadHeights TMap<EB1BodyAgeType, float>
---@field MaleHeadHeights TMap<EB1BodyAgeType, float>
---@field GarmentCategoryMenus TArray<FB1CharacterCustomizeUICategoryMenu>
---@field AccessoryCategoryMenus TArray<FB1CharacterCustomizeUICategoryMenu>
---@field GarmentTypeIdToGarmentMenuId TMap<FName, FName>
---@field AccessoryTypeIdToAccessoryMenuId TMap<FName, FName>
---@field AccesoriesHandledAsGarment TArray<FName>
---@field CategoryGroupInfos TArray<FB1CharacterCustomizationUIListCategoryGroupInfo>
---@field AgeMin int32
---@field AgeMax int32
---@field IrisUVRadiusMin float
---@field IrisUVRadiusMax float
---@field PupilScaleMin float
---@field PupilScaleMax float
---@field CharacterRotationAngle float
---@field CharacterRotationRepeatIntervalSec float
---@field CharacterRotationRepeatDelaySec float
---@field ListEntryMaterialParamsDefault FB1CharacterCustomizeUIListEntryMaterialParameters
---@field ListEntryMaterialParamsPreset FB1CharacterCustomizeUIListEntryMaterialParameters
---@field ListEntryMaterialParamsGarmentPreset FB1CharacterCustomizeUIListEntryMaterialParameters
---@field ListEntryMaterialParamsDefaultCreation FB1CharacterCustomizeUIListEntryMaterialParameters
---@field ListEntryMaterialParamsPresetCreation FB1CharacterCustomizeUIListEntryMaterialParameters
---@field ListEntryMaterialParamsGarmentPresetCreation FB1CharacterCustomizeUIListEntryMaterialParameters
---@field StudioBGListEntryInfos TArray<FB1CharacterCustomizeStudioBGListEntryInfo>
---@field DefaultStudioActorTag FName
---@field bReturnToDefaultStudioOnTraitExit boolean
---@field HeadAnimInstance TSubclassOf<UAnimInstance>
---@field HairAnimInstance TSubclassOf<UAnimInstance>
---@field RemoveAllMakeupExcludedMakeupParts TArray<FName>
---@field FemaleGarmentCategoryVisibility TMap<EB1BodyAgeType, FB1CategoryVisibilityByGarmentType>
---@field MaleGarmentCategoryVisibility TMap<EB1BodyAgeType, FB1CategoryVisibilityByGarmentType>
---@field FemaleCategoryVisibility TMap<EB1BodyAgeType, FB1CategoryVisibilityByGarmentType>
---@field MaleCategoryVisibility TMap<EB1BodyAgeType, FB1CategoryVisibilityByGarmentType>
---@field headPitch float
---@field headYaw float
---@field headRoll float
---@field HideBodyWeightCategoryBodyAgeTypes TArray<EB1BodyAgeType>
local UB1CharacterCustomizeDataAsset = {}



---@class UB1CharacterRescueDataAsset : UB1DataAssetBase
---@field RescueCharacterInfantTextId FString
---@field RescueCharacterDyingTextId FString
---@field SafeControlCoolTimeMinutes int32
local UB1CharacterRescueDataAsset = {}



---@class UB1CharacterSpawnControllerDataAsset : UB1DataAssetBase
---@field SpawnTimeIntervalMin float
---@field SpawnTimeIntervalMax float
---@field SpawnerSearchRadius float
---@field MaxSpawnCount int32
---@field RetryInteractionTime float
---@field LifeTimeWhenNotVisible float
---@field RelatedCharacterSpawnRatio float
---@field AffectRelationshipStat TArray<FName>
---@field SpawnStartBornAge int32
---@field SpawnEndBornAge int32
---@field IsRestrictRandomPreset boolean
---@field RestrictCrowdPreset TArray<FB1RestrictCrowdPreset>
---@field SpawnAbleRadius float
---@field DespawnAbleRadius float
---@field RetryLowAOI FB1RadiusRange
---@field RetryHighAOI FB1RadiusRange
---@field RetryRequestPathSnap int32
---@field MoveSameGroupSpawnerRate float
---@field RelationshipCrowdRespawnStatValue float
---@field DefaultCurrencyAmount int64
---@field DefaultStatRange FVector2D
---@field SharedServiceDistance float
local UB1CharacterSpawnControllerDataAsset = {}



---@class UB1CityEditDataAsset : UB1DataAssetBase
---@field SignWebBrowser TSoftClassPtr<AActor>
---@field SignWebBrowserSpawnLocationList TMap<FName, FVector>
---@field SignWebBrowserSpawnRotationList TMap<FName, FRotator>
---@field SignWebBrowserSpawnScaleList TMap<FName, FVector>
---@field SignMeshList TMap<FName, FB1SignMeshInfo>
---@field SignMaterialList TMap<int32, TSoftObjectPtr<UMaterialInterface>>
---@field MaxMultiSelectNum int32
---@field Sign_Video_Icon TSoftObjectPtr<UTexture2D>
---@field CityBalance_Icon TSoftObjectPtr<UTexture2D>
---@field WorldVATSpawnInfoList TMap<FName, FB1CityEditObjectWorldSpawnInfoList>
---@field SliderStepNameIdList TArray<FString>
---@field MaterialParameterCollection UMaterialParameterCollection
---@field WorldStabilityProbSpawnInfoList TMap<FName, FB1CityEditWorldStabilityProbSpawnInfoList>
---@field SubTabChangeHideDistance float
local UB1CityEditDataAsset = {}



---@class UB1CityTrafficControlDataAsset : UB1DataAssetBase
---@field SpawnTrialCount int32
---@field LaneSearchIteration int32
---@field MaximumSpawnRange float
---@field MinimumSpawnRange float
---@field NearbySearchSteps int32
---@field MaxInstancesNearby int32
---@field SpawnInterval float
---@field GreenLightExtraTime int32
---@field GreenLightAdditionalTimeRatio float
---@field AdjustVehiclesMaxRate float
local UB1CityTrafficControlDataAsset = {}



---@class UB1CleanlinessDataAsset : UB1DataAssetBase
---@field CleanlinessWidgetSettings FB1CleanlinessWidgetSettings
local UB1CleanlinessDataAsset = {}



---@class UB1CompanyDataAsset : UB1DataAssetBase
---@field AddStatDesireForGoHome float
---@field InteractionBagIdForGoCompany FName
---@field LeaveCompanyAbsenceDay int32
---@field AlertCompanyAbsenceDay int32
---@field AutoJoinCompanyRatio float
---@field JobInducementDay int32
local UB1CompanyDataAsset = {}



---@class UB1CoopJsonDataAsset : UB1DataAssetBase
---@field CoopTimeOutDuration int64
---@field CoopMaxTimeOutDuration int64
---@field MoveTogetherTimeOutDuration int64
---@field TalkTimeOutDuration int64
---@field CoopTargetAOIRadius int32
---@field CoopTargetDistanceRadius float
---@field MoveTogetherMaxSelectableCount int32
---@field MoveTogetherTargetRadius float
---@field MoveTogetherInvokeTeleportRadius float
---@field MoveTogetherTeleportTargetRadius float
---@field NonCancelableCoopInteractionBagWhiteList TArray<FName>
local UB1CoopJsonDataAsset = {}



---@class UB1CostumeEditDataAsset : UB1DataAssetBase
---@field CharacterCustomizeStudioLocation TMap<FName, FVector>
---@field FemaleGarmentIdByCostumeEditCategory TMap<EB1CharacterCustomizeCostumeEditCategoryType, FName>
---@field MaleGarmentIdByCostumeEditCategory TMap<EB1CharacterCustomizeCostumeEditCategoryType, FName>
---@field GarmentCategoryIdByCostumeEditCategory TMap<EB1CharacterCustomizeCostumeEditCategoryType, FName>
---@field CategoryIdByGarmentType TMap<FName, EB1CharacterCustomizationCategory>
---@field Attachment3DHeadBones TArray<FName>
---@field Attachment3DBodyBones TArray<FName>
---@field TitleIdByAttachedBoneNames TMap<FName, FName>
---@field GizmoScale float
---@field ScaleGizmoOffset float
---@field ScaleGizmoActorScale float
---@field RotationFactor float
---@field ScaleFactor float
---@field LocationFactor float
---@field DefaultMeshRotation FRotator
---@field DefaultMeshScale FVector
---@field DefaultMeshLocation FVector
---@field MinScale float
---@field MaxScale float
---@field MinLocation float
---@field MaxLocation float
---@field DefaultGarmentIdForMale TMap<FName, FName>
---@field DefaultGarmentIdForFemale TMap<FName, FName>
local UB1CostumeEditDataAsset = {}



---@class UB1CraftingDataAsset : UB1DataAssetBase
---@field Crafting_NotFoundTarget FString
---@field Crafting_NotEnoughMoney FString
---@field Crafting_NotEnoughIngredients FString
---@field Crafting_NotEnoughSkillLevel FString
---@field Crafting_HasReservedStartCraftContext FString
---@field Crafting_CannotThrowAway FString
---@field Crafting_SellPublishable FString
---@field QualityTextDatas TMap<EB1Quality, FB1QualityTextData>
---@field DecayWarningValue float
---@field DecayWarningColorId FName
---@field PublishableCraftingData FB1PublishableCraftingData
---@field MaxTitleLength int32
---@field MaxContentLength int32
local UB1CraftingDataAsset = {}



---@class UB1CurrencyDataAsset : UB1DataAssetBase
---@field MaxAmount int64
---@field MinAmount int64
---@field CatTalkCheatAmount int64
---@field MainCurrencyId FName
---@field CurrecyTooltipFormatTextId FString
---@field AddCurrencyEffectDuration float
local UB1CurrencyDataAsset = {}



---@class UB1CustomGarment : UObject
---@field GarmentData FB1GarmentDescription
local UB1CustomGarment = {}



---@class UB1CutSceneStudioDataAsset : UB1DataAssetBase
---@field CityBySiteId TMap<FName, FName>
---@field LevelSequenceIdMap TMap<EB1StudioCardType, FName>
---@field Texture2dMap TMap<EB1StudioCardType, FName>
local UB1CutSceneStudioDataAsset = {}



---@class UB1DNDAutonomyConfigDataAsset : UB1DataAssetBase
---@field RetryCount int32
---@field ResponseTimeoutSec int32
---@field CollectAOILevel int32
---@field RequestTimelineRetryCount int32
---@field DLDSLMDataAsset TSoftObjectPtr<UDataAsset>
---@field MaxSmartZoiPenLength int32
---@field SmartZoiOptionChagnedOnPopupName FName
---@field SmartZoiOptionChagnedOffPopupName FName
local UB1DNDAutonomyConfigDataAsset = {}



---@class UB1DataAssetBase : UDataAsset
local UB1DataAssetBase = {}


---@class UB1DataLoader : UObject
---@field AnimCaches TMap<FString, UAnimationAsset>
---@field DataTableMap TMap<FName, FB1DataTableWrapper>
---@field FileNames TSet<FString>
---@field DataAssets TMap<FName, FB1DataAssetWrapper>
---@field JsonDataTableName TSet<FName>
---@field AddToRootCount int32
local UB1DataLoader = {}



---@class UB1DataLogDataAsset : UB1DataAssetBase
---@field MaxLogCount int32
---@field AnimalInteractionIdList TSet<FName>
---@field FireAccidentStateName FName
---@field BreakupRelationshipId FName
---@field CoupleRelationshipId FName
---@field EngagementRelationshipId FName
---@field MarriageInteractionIdList TSet<FName>
---@field PregnancyBuffId FName
local UB1DataLogDataAsset = {}



---@class UB1DiversityDataAsset : UB1DataAssetBase
---@field DiversityInfoRatioMap TMap<FB1DiversityInfo, float>
local UB1DiversityDataAsset = {}



---@class UB1DoorDataAsset : UB1DataAssetBase
---@field DoorTitleText FString
---@field DoorTemplate TMap<FName, FB1DoorTemplateSetting>
---@field OwnerlessResidenceDoorToastMessage FString
---@field DoorPermissionData TMap<EB1DoorPermissionGroup, FB1DoorPermissionData>
---@field LockIconId FName
---@field DoorOwnerAlreadyExistMessageText FString
---@field DoorPermissionSetByBuildModeMessageText FString
---@field DoorObjectPermissionDeniedMessageText FString
local UB1DoorDataAsset = {}



---@class UB1DreamDataAsset : UB1DataAssetBase
---@field DreamProbability float
---@field InitialDuration int32
---@field REMDuration int32
---@field NonREMDuration int32
---@field AwakeDreamInterval int32
---@field AwakeDreamProbability float
---@field DreamBuffTag FName
---@field DreamBuffTooltipTag FName
---@field SleepwalkingBuffId FName
---@field SleepwalkingCanceledScriptId FName
local UB1DreamDataAsset = {}



---@class UB1ElevatorDataAsset : UB1DataAssetBase
---@field AcceptanceRadius float
---@field ElevatorInteractionBagId FName
local UB1ElevatorDataAsset = {}



---@class UB1EmotionDataAsset : UB1DataAssetBase
---@field AdmitDesireBoostDatas TArray<FB1AdmitDesireBoostData>
---@field JoyfulDesireBoostDatas TArray<FB1JoyfulDesireBoostData>
---@field EmotionGaugeUIMaxValue int32
---@field EmotionToolTipOpenTime float
local UB1EmotionDataAsset = {}



---@class UB1EventCrowdDataAsset : UB1DataAssetBase
---@field DefaultSpawnPoolSize int32
---@field SpawnPoolSize TMap<FName, int32>
---@field SpawnStartBornAge int32
---@field SpawnEndBornAge int32
---@field RestrictAppearancePreset TArray<FName>
local UB1EventCrowdDataAsset = {}



---@class UB1FXDataAsset : UB1DataAssetBase
---@field FxActorClass TSubclassOf<AActor>
---@field ChangeCostumeParameters TMap<EB1BodyAgeType, FB1ChangeCostumeFxParameters>
---@field GrowthStepUpParameters TMap<EB1BodyAgeType, FB1GrowthStepUpFxParameters>
local UB1FXDataAsset = {}



---@class UB1FXNiagaraObject : UB1FXObject
---@field NiagaraSystem TSoftObjectPtr<UNiagaraSystem>
---@field bRandomize boolean
---@field RandomizeNiagaraSystem TArray<TSoftObjectPtr<UNiagaraSystem>>
---@field RandomIndex int32
local UB1FXNiagaraObject = {}



---@class UB1FXObject : UObject
---@field FXTransform FTransform
---@field IsFollowFX boolean
---@field bUseTimeScale boolean
---@field FXSocket FName
---@field SoundId FName
local UB1FXObject = {}



---@class UB1FaceShapeCustomizeDataAsset : UB1DataAssetBase
---@field FemaleFaceData TMap<EB1BodyAgeType, FB1FaceShapeCustomizeData>
---@field MaleFaceData TMap<EB1BodyAgeType, FB1FaceShapeCustomizeData>
local UB1FaceShapeCustomizeDataAsset = {}



---@class UB1FamilyEditDataAsset : UB1DataAssetBase
---@field FamilyCreateChildUnableTextId FString
---@field FamilyCreateChildUnableSingleTextId FString
---@field FamilyCreateChildUnableChildOnlyTextId FString
---@field MarriedCopuleTextId FString
---@field HouseMateTextId FString
---@field ParentChildTextId FString
---@field DocumentCreationDateTextId FString
---@field DefaultHouseholdTextureId FName
local UB1FamilyEditDataAsset = {}



---@class UB1FamilySelectEntryData : UObject
---@field FamilyMemberPortraits TArray<UTexture>
local UB1FamilySelectEntryData = {}



---@class UB1FamilyTreeDataAsset : UB1DataAssetBase
---@field ZoomMin float
---@field ZoomMax float
---@field ZoomStep float
---@field ItemWidgetSize FVector2D
---@field ItemWidgetSpacing FVector2D
---@field LineOffset FVector2D
---@field LineStyles FB1FamilyTreeLineStyles
---@field TextId FB1FamilyTreeTextId
local UB1FamilyTreeDataAsset = {}



---@class UB1GalleryDataAsset : UB1DataAssetBase
---@field GalleryWebURL FString
---@field LiveGalleryWebURL FString
---@field GalleryServiceURL FString
---@field LiveGalleryServiceURL FString
---@field CharacterThumbnailStudioLevel FSoftObjectPath
---@field CaptureFilterMap TMap<FName, FB1ThumbnailFilter>
---@field SceneCaptureMaterial FSoftObjectPath
---@field GenderTypeToCanvasGenders TMap<EB1GenderType, uint8>
---@field GrowthStepToCanvasAges TMap<EB1GrowthStep, FB1CanvasAges>
local UB1GalleryDataAsset = {}



---@class UB1GallerySettings : UObject
---@field MaleCameraSetting TMap<FName, FB1ThumbnailCameraSetting>
---@field FemaleCameraSetting TMap<FName, FB1ThumbnailCameraSetting>
---@field YouthCameraSetting TMap<FName, FB1ThumbnailCameraSetting>
---@field CustomGarmentsIcon TSoftObjectPtr<UTexture2D>
local UB1GallerySettings = {}



---@class UB1GameConfigDataAsset : UB1DataAssetBase
---@field BasicSetting FB1GameConfigBasicSetting
---@field bUseDefaultPawnAtEditor boolean
---@field Time FB1GameConfigTime
---@field StartTime FB1GameConfigDateTime
---@field TimeMPC UMaterialParameterCollection
---@field SaveLoad FB1SaveLoadConfig
---@field CheatFilePath FString
---@field WorldTriggerJsonFilePath FString
---@field BuildProgressTime double
---@field BuildKeyGuideUIXOffset float
---@field MouseCursor FB1MouseCursorConfig
---@field HorizontalTranslationRange FVector2D
---@field SprintProbability float
---@field GameOptionConfirmCountdownTime float
---@field SimulationLOD FB1SimulationLODConfig
---@field DefaultMaxDrawDistance float
---@field CharacterCollisionPreset FB1CharacterCollisionPresetConfig
---@field DisclaimerMaintainingTime float
---@field LicensesURL FString
---@field ReportWidgetClass TSubclassOf<UUserWidget>
---@field DataCachePathList TArray<FSoftObjectPath>
---@field BuildWorldEnableInteractionBagIds TSet<FName>
local UB1GameConfigDataAsset = {}



---@class UB1GameObjectDustyJsonDataAsset : UB1DataAssetBase
---@field DustyUpdateIntervalMinute int32
---@field DustyUpdateValue float
---@field DustFloorSpawnIntervalMinute int32
---@field DustyObjectCountPerUnitSize float
---@field DurtyZoiTestValue float
---@field DustyObjectWeight float
---@field GameObjectWeight float
---@field CarriableObjectWeight float
---@field CarriableObjectDustyValueRange TArray<FB1CarriableObjectDustyValueRange>
---@field ExcludedFilterCategories TArray<FName>
local UB1GameObjectDustyJsonDataAsset = {}



---@class UB1GenerateMotionDataAsset : UB1DataAssetBase
---@field DimmedToolTipTextId FString
---@field DefaultTotalPlayLength float
---@field MaxGeneratedMotionNum int32
---@field DimmedRenderOpacity float
local UB1GenerateMotionDataAsset = {}



---@class UB1GeneticAppearanceDataAsset : UB1DataAssetBase
---@field NoiseValue float
---@field BlackSkinBaseValue float
---@field BlackSkinThreshold float
---@field SkinColorProbabilities TArray<float>
---@field SkinColorWeightOptions TArray<float>
---@field BodyMassThreshold float
---@field HairLengthProbabilitiesByGender TMap<FString, FB1HairLengthProbability>
---@field DefaultAdultHairIdByGender TMap<EB1GenderType, FName>
local UB1GeneticAppearanceDataAsset = {}



---@class UB1GhostDataAsset : UB1DataAssetBase
---@field GhostConditionId FName
---@field BodyMaterials TArray<TSoftObjectPtr<UMaterialInterface>>
---@field HeadMaterials TArray<TSoftObjectPtr<UMaterialInterface>>
---@field EyeMaterials TArray<TSoftObjectPtr<UMaterialInterface>>
---@field HairMaterials TArray<TSoftObjectPtr<UMaterialInterface>>
---@field HeadEtcMaterials TArray<TSoftObjectPtr<UMaterialInterface>>
---@field GarmentMaterials TArray<TSoftObjectPtr<UMaterialInterface>>
---@field GhostPostProcessMaterial TSoftObjectPtr<UMaterial>
---@field AscensionCheckConditionStats TArray<FName>
---@field AscensionCheckConditionValues TArray<float>
---@field GhostNoticePopupId FName
---@field OnGhostPlayPopupId FName
---@field OnAscensionPopupId FName
---@field PlayPopupTexture TSoftObjectPtr<UObject>
---@field PregnancyThresholdGhostCount int64
---@field CanPlayGhost boolean
local UB1GhostDataAsset = {}



---@class UB1GizmoRuleDataAsset : UB1DataAssetBase
---@field GizmoTransformActiveFlag TMap<uint8, FB1GizmoTransformActive>
---@field GizmoTransformActiveCategory TMap<FName, FB1GizmoTransformActive>
---@field GizmoTransformActiveManual TMap<FName, FB1GizmoTransformActive>
---@field OverridingColorSetMap TMap<FName, FB1GizmoColorSet>
local UB1GizmoRuleDataAsset = {}



---@class UB1HairRigidBodyDataAsset : UB1DataAssetBase
---@field HairRigidBodyInfos TArray<FB1HairRigidBodyInfo>
local UB1HairRigidBodyDataAsset = {}



---@class UB1HopeChangeEntryInfo : UObject
local UB1HopeChangeEntryInfo = {}


---@class UB1HopeDataAsset : UB1DataAssetBase
---@field HopeSlots TArray<FB1HopeSlotDefine>
---@field MaxHopeSize int32
---@field RandomSelectCooltime float
---@field RandomSelectRangeSec float
---@field ReSelectCoolTime float
---@field DeSelectCoolTime float
local UB1HopeDataAsset = {}



---@class UB1HouseholdDataAsset : UB1DataAssetBase
---@field MaxHouseholdMemberCount int32
---@field CreateHouseholdCurrencyDatasBySimulate TArray<FB1CurrencyDefaultData>
---@field HouseholdCreateBaseCharacterMinAge int32
---@field HouseholdCreateBaseCharacterMaxAge int32
---@field HouseholdDefaultRelationshipId FName
---@field CurrencyId FName
---@field PerPersonCurrencyAmount int32
---@field BonusSeedMoneyBySimulate int32
---@field MaxHouseholdMonitoringNotificationCount int32
---@field GoHomeInteractionBagId FName
---@field GiveBirthScriptId FName
---@field BabySafetyInfo FB1BabySafetyInfo
local UB1HouseholdDataAsset = {}



---@class UB1HowlingJsonDataAsset : UB1DataAssetBase
---@field TargetAOIRadius int32
---@field TargetDistanceRadius float
---@field HowlingCannotCancelInteractionBagTag FName
local UB1HowlingJsonDataAsset = {}



---@class UB1InputActionSettingDataAsset : UB1DataAssetBase
---@field InputActions TMap<EB1InputCommandType, TSoftObjectPtr<UInputAction>>
local UB1InputActionSettingDataAsset = {}



---@class UB1InputMappingContextDataAsset : UB1DataAssetBase
---@field InputMappingContext TMap<EB1InputMappingContextType, TSoftObjectPtr<UInputMappingContext>>
local UB1InputMappingContextDataAsset = {}



---@class UB1InteractionDataAsset : UB1DataAssetBase
---@field MaxInteractionQueueCount int32
---@field MaxInteractionRange float
---@field MaxInteractionWaitTime float
---@field TraitTagColor1 FLinearColor
---@field TraitTagColor2 FLinearColor
---@field StoryTagStringId FString
---@field StoryTagColor1 FLinearColor
---@field StoryTagColor2 FLinearColor
---@field AutonomyFailedInteractionBagId FName
---@field AutonomyFailedInteractionBagIdOnSit FName
---@field AutonomyFailedInteractionCooltimeSecMin float
---@field AutonomyFailedInteractionCooltimeSecMax float
---@field AutonomyRewardModifierPerObjectTemplateCount UCurveFloat
---@field SelfMoveInteractionBagId FName
---@field WalkToScheduleSiteInteractionBagId FName
---@field NeverInterruptInteractionBagId TArray<FName>
---@field BookReadCancelInteractionBagId FName
---@field AutoFindPutDownInteractionBagId FName
---@field PutDownInteractionBagId FName
---@field PutDownToFloorMinDistance float
---@field PutDownToFloorMaxDistance float
---@field MinBoxVolumeForCollisionEnable float
---@field MinBoxHeightForCollisionEnable float
---@field SitInteractionBagCategory TArray<FName>
---@field WatchingInteractionBagIds TArray<FName>
---@field bAddExecutingActionForTarget boolean
---@field ActionTimeResetDelay int64
---@field CharacterSelfSelectionId FName
---@field PassengerSelectionId FName
---@field ClickSelectionId FName
---@field ClickInteractionBagCategory FName
---@field ClickableObjectInteractionRange float
---@field AvailableObjectInteractionUIRange float
---@field ClickableTalkInteractionRange float
---@field AvailableTalkInteractionUIRange float
---@field WalkToNearbyPathRatioMin float
---@field WalkToNearbyPathRatioMax float
---@field InterationUIClickCheckTime double
---@field TalkSpanTime float
---@field VerifySlotRange float
---@field TalkInteractionVerifySlotRange float
---@field MoveOverRange float
---@field FinalCheckRange float
---@field AcceptanceRadiusCalibrationRange float
---@field MoveOverCoolTime float
---@field WalkToFinish_CharacterOverlapRange float
---@field WalkToFinish_AddInteractionBagId FName
---@field WalkToNearbyInvalidSiteMinDistance float
---@field WalkToNearbyInvalidSiteMaxDistance float
---@field AutonomyIntervalMin float
---@field AutonomyIntervalMax float
---@field AutonomyIntervalForPC float
---@field AutonomyInteractionFail_IntervalMin float
---@field AutonomyInteractionFail_IntervalMax float
---@field AutonomyTalkFinished_IntervalMin float
---@field AutonomyTalkFinished_IntervalMax float
---@field Autonomy_RealtimeIntervalMin float
---@field Autonomy_RealtimeIntervalMax float
---@field TransientDesireInteractionCountMax int32
---@field TransientDesireInputWaitTime double
---@field AutonomyMaxTalkDistance float
---@field DistFromFire float
---@field WalkAroundLocationFindPathRetryCount int32
---@field MustIsHomeConditionObjectIds TArray<FName>
---@field PositiveInteractionBagTags TArray<FName>
---@field NegativeInteractionBagTags TArray<FName>
---@field NormalInteractionBagTags TArray<FName>
---@field AddAllTalkInteractionCategoryTags TArray<FName>
---@field InteractionRandomTalkEmotionIconMap TMap<FName, FName>
---@field InteractionPanelSlotATags TArray<FName>
---@field InteractionPanelSlotAMaxCount int32
---@field InteractionPanelSlotBTags TArray<FName>
---@field InteractionPanelRandomTalkEmotionPositiveTags TArray<FName>
---@field InteractionPanelRandomTalkEmotionNegativeTags TArray<FName>
---@field InteractionPanelSlotBMaxCount int32
---@field InteractionPanelSlotCMaxCount int32
---@field TalkInteractionStartTalk FB1TalkInteractionStartTalk
---@field InteractionBagHistoryAlertCount int32
---@field InteractionBagHistoryCheckInterval int32
---@field SelectRandomEmoticonRetryCount int32
---@field WalkToDirtyPlaceOffsetDistance float
---@field GrabBabyInteractionBagWhiteList TArray<FName>
local UB1InteractionDataAsset = {}



---@class UB1InteractionMessageDataAsset : UB1DataAssetBase
---@field InteractionFailMessageId_Default FString
---@field InteractionFailMessageId_WalkTo FString
---@field InteractionFailMessageId_NotEnoughCurrency FString
---@field InteractionFailMessageId_NotFoundSlot FString
---@field InteractionFailMessageId_HasWhitelistBuff FString
---@field InteractionFailMessageId_InteractionQueueIsMax FString
---@field InteractionFailMessageId_ExecutingInteractionIsImmutable FString
---@field InteractionFailMessageId_NotMyCompany FString
---@field InteractionFailMessageId_NotMyJobRankSeat FString
---@field InteractionFailMessageId_NotMyFixedSeat FString
---@field InteractionFailMessageId_NotHavePermission FString
---@field InteractionFailMessageId_CoopCommon FString
---@field InteractionFailMessageId_PlayingCoop FString
---@field InteractionFailMessageId_MoveTogetherFailHost FString
---@field InteractionFailMessageId_MoveTogetherFailPlayerTarget FString
---@field InteractionFailMessageId_MoveTogetherFailTarget FString
---@field InteractionFailMessageId_TargetSleepwalking FString
---@field InteractionFailMessageId_TargetSleeping FString
---@field InteractionFailMessageId_GrabBaby FString
---@field InteractionCancelMessageId_NonCancelableInteraction FString
---@field InteractionCancelMessageId_CannotCancelSleepwalkingInteraction FString
---@field InteractionCancelUnablePutdownInInventoryObject FString
---@field InteractionCancelVehicleExitPositionInvalid FString
---@field InteractionMoveMessageId_CannotMoveCutInLineInteraction FString
local UB1InteractionMessageDataAsset = {}



---@class UB1InventoryDataAsset : UB1DataAssetBase
---@field DefaultCharacterInventoryId FB1TableRowName
---@field DefaultSiteInventoryId FB1TableRowName
---@field PocketPutDownInteractionBagId FB1TableRowName
local UB1InventoryDataAsset = {}



---@class UB1JobDataAsset : UB1DataAssetBase
---@field JobMissionRemainTimeStrId FString
---@field JobMissionRewardTooltipStrId FString
---@field JobAdditionalCurrencyRewardTooltipStrId FString
---@field JobRandomGoHomeTimeMinute int32
---@field WorkPrepareHour int32
---@field CrowdJobAcquireRatio float
---@field JobMissionCompleteAudioId FName
---@field JobMissionFailAudioId FName
local UB1JobDataAsset = {}



---@class UB1KarmaReportDataAsset : UB1DataAssetBase
---@field InvolvingCooltime float
---@field InvolvingCameraBlendTime float
---@field InvolvingCameraDistance float
---@field InvolvingCameraMinDistance float
---@field InvolvingCameraZOffset float
---@field InvolvingCameraDuration float
---@field InvolvingInfoList TArray<FB1KarmaReportInvolvingInfo>
local UB1KarmaReportDataAsset = {}



---@class UB1LevelSequenceDataAsset : UB1DataAssetBase
---@field LevelSequenceList TMap<FName, FB1WorldLevelSequenceInfoList>
local UB1LevelSequenceDataAsset = {}



---@class UB1LifeDataAsset : UB1DataAssetBase
---@field MarriageOrConditionIds TArray<FName>
---@field WeddingCarAssetPath FSoftObjectPath
---@field WeddingCarObjectId FName
---@field WeddingCarStayTime float
---@field MarriageInteractionTagName FName
---@field PregnancyBuffNames TArray<FName>
---@field PregnancyOrConditionIds TArray<FName>
---@field DefaultCradleObjectId FName
---@field BabyAttachSlotName FName
---@field ChildInitPostureId FName
---@field IsEnableFamilyAlertMessage boolean
---@field PostMarriageMovePopupId FName
---@field TriggeredVehicleVelocity float
---@field TriggerResetCooltime float
---@field TrafficAccidentProbability float
local UB1LifeDataAsset = {}



---@class UB1LoadingScreenDataAsset : UB1DataAssetBase
---@field TipText TArray<FText>
local UB1LoadingScreenDataAsset = {}



---@class UB1LobbyDataAsset : UB1DataAssetBase
---@field LobbyIntroPlayType EB1LobbyIntroPlayType
---@field LobbyIntroSkipWaitTimeSec float
---@field SteamStoreUrl FString
---@field DiscordUrl FString
---@field EventUrlCN FString
---@field RedeemUrlCN FString
---@field NewsUrl FString
---@field EventCNStartDate FString
---@field EventCNEndDate FString
local UB1LobbyDataAsset = {}



---@class UB1MapNavigatorDataAsset : UB1DataAssetBase
---@field NavigatorImageMoveBlendTime float
---@field NavigatorImageMoveEaseFunc EEasingFunc::Type
local UB1MapNavigatorDataAsset = {}



---@class UB1MapPositionDataAsset : UB1DataAssetBase
---@field Position TMap<FName, FB1CityLocation>
local UB1MapPositionDataAsset = {}



---@class UB1MaterialParameterCollectionDataAsset : UB1DataAssetBase
---@field MaterialParameterCollections TArray<TSoftObjectPtr<UMaterialParameterCollection>>
local UB1MaterialParameterCollectionDataAsset = {}



---@class UB1MeetingDataAsset : UB1DataAssetBase
---@field MeetingRequestPossessHouseHoldTime int32
---@field MeetingOverrideTimelineStartTime int32
---@field MeetingOverrideTimelineEndTime int32
local UB1MeetingDataAsset = {}



---@class UB1MetricManager : UObject
---@field PersistentMetric FB1MetricMap
---@field SessionMetric FB1MetricMap
---@field RunMetric FB1MetricMap
---@field LastUpdatedPlayTime FDateTime
---@field SessionPlayStartTime FDateTime
local UB1MetricManager = {}



---@class UB1MobileMessageDataAsset : UB1DataAssetBase
---@field MessageDialogWidgetForSelf TSubclassOf<UUserWidget>
---@field MessageDialogWidgetForOther TSubclassOf<UUserWidget>
local UB1MobileMessageDataAsset = {}



---@class UB1MobileMessageJsonDataAsset : UB1DataAssetBase
---@field MaxMessageNum int32
---@field SendMessageStartHour int32
---@field SendMessageEndHour int32
---@field MessageDelayTime float
---@field OperatorIconId FName
---@field OperatorNameId FString
---@field SendMessageMinDistance float
local UB1MobileMessageJsonDataAsset = {}



---@class UB1MouseDataAsset : UB1DataAssetBase
---@field HardwareCursors TMap<EB1MouseCursorType, FHardwareCursorReference>
---@field HardwareCursorSetMap TMap<FName, FB1HardwareCursorSet>
local UB1MouseDataAsset = {}



---@class UB1NameRuleDataAsset : UB1DataAssetBase
---@field NameLimitByteSize int32
---@field SocialEventNameMinNum int32
---@field SocialEventNameMaxNum int32
local UB1NameRuleDataAsset = {}



---@class UB1ObjectBadgeJsonDataAsset : UB1DataAssetBase
---@field ObjectBadge TMap<EB1ObjectBadgeIconType, FName>
local UB1ObjectBadgeJsonDataAsset = {}



---@class UB1ObjectDepreciationDataAsset : UB1DataAssetBase
---@field ObjectDepreciationInfos TArray<FB1ObjectDepreciationInfo>
local UB1ObjectDepreciationDataAsset = {}



---@class UB1ObjectSelectionData : UObject
---@field InteractionBagId FName
---@field InteractionGroupID FName
---@field IsCategoryTab boolean
---@field CategoryTabString FText
---@field CategoryRootTabString FText
---@field ObjectDisplayString FText
---@field DisplayString FText
---@field DisplayTooltip FText
---@field TalkType FName
---@field TalkNature EB1TalkNature
---@field RelationshipFocusType FName
---@field IsPositiveTalk boolean
---@field TagName FText
---@field PerspectiveId FName
---@field TagColor1 FLinearColor
---@field TagColor2 FLinearColor
---@field PreferenceType EB1PreferencePanelType
---@field PanelIcon TSoftObjectPtr<UObject>
---@field PanelIconColor FLinearColor
---@field PermissionType FName
---@field IsDimmed boolean
---@field DimmedToolTipTextId FString
---@field IsShowDevText boolean
---@field IsShowLeftTag boolean
---@field LeftTagString FText
---@field LeftTagColor FLinearColor
---@field LeftTagIcon TSoftObjectPtr<UObject>
---@field IsKarmaIcon boolean
---@field IsProgressIcon boolean
---@field ConsumeCurrencyId FName
---@field ConsumeCurrencyValue int64
---@field IsAddMotionIcon boolean
---@field GeneratedMotionFileKey FString
---@field IsChecked boolean
local UB1ObjectSelectionData = {}



---@class UB1PathFindConfig : UB1DataAssetBase
---@field IgnoreDifferentBlockDistance float
---@field StairSlotOffset float
---@field CityGraphKeepRightHandDistance float
---@field CityPathFindGroup TMap<FName, FB1CityPathFindGroup>
local UB1PathFindConfig = {}



---@class UB1PerspectiveDataAsset : UB1DataAssetBase
---@field InheritanceGrowthStepBefore EB1GrowthStep
---@field InheritanceGrowthStepAfter EB1GrowthStep
---@field LockPerspectiveGrowthStep EB1GrowthStep
---@field InheritanceMaxPerspectiveValue float
local UB1PerspectiveDataAsset = {}



---@class UB1PhotoModeDataAsset : UB1DataAssetBase
---@field DefaultBodyAnimClass TSubclassOf<UAnimInstance>
---@field DefaultFaceAnimClass TSubclassOf<UAnimInstance>
---@field TimeStopGuideText FString
---@field FolderName FString
---@field UserUniqueKey FString
---@field CustomDepthMaterial TSoftObjectPtr<UMaterial>
---@field CropOptions TArray<FB1PhotoModeCropOptionSetting>
---@field FilterOptions TMap<FString, EB1FilterType>
---@field CameraOptions TArray<FB1PhotoModeCameraOptionSetting>
local UB1PhotoModeDataAsset = {}



---@class UB1PhotoStudioDataAsset : UB1DataAssetBase
---@field CityBySiteId TMap<FName, FName>
---@field StudioByPostProcessName TMap<FName, FName>
---@field StudioItemTags TArray<FString>
---@field DefaultMannequinBodyPose TMap<EB1GrowthStep, TSoftObjectPtr<UAnimSequence>>
---@field BuildModeDefaultGuideText FString
---@field BuildModeStudioGuideText FString
local UB1PhotoStudioDataAsset = {}



---@class UB1PocketMarketDataAsset : UB1DataAssetBase
---@field DiscountPricePercentageToSubtract float
---@field DiscountSellPercentageToAdd float
---@field MinPrice int64
---@field QualityPriceRanges TMap<EB1Quality, FB1PocketMarketQualityPriceRatioRange>
---@field RandomLikesToAddRange int32
---@field RandomFollwersToAddRange int32
---@field MaxPocketMarketFollowerCount uint32
---@field GradeDatas TMap<EB1PocketMarketGrade, FB1PocketMarketGradeData>
---@field MaxSoldItemCount int32
---@field MaxPurchasedShoppingItemCount int32
---@field PocketMarket_TotalSellItemCount FString
---@field PocketMarket_FollowerCount FString
---@field PocketMarket_DaysPassed FString
---@field PocketMarket_PurchaseSuccess FString
---@field PocketMarket_PurchaseSuccessService FString
---@field PocketMarket_PurchaseServiceFailed FString
---@field PocketMarketSubTitles TMap<EB1PocketMarketTabType, FString>
---@field PocketMarket_PurchaseFailedNotEnoughMoney FString
---@field PocketMarket_BuyShoppingItemFaliledNotFoundLocationMessageId FString
---@field DoNotSpawnFakeObjectTag FName
local UB1PocketMarketDataAsset = {}



---@class UB1PopulationDataAsset : UB1DataAssetBase
---@field SpawnCrowdMaxAge int32
---@field DestroyCrowdAge int32
---@field DestroyCrowdPercentage float
---@field RemoveCameraDistance int32
local UB1PopulationDataAsset = {}



---@class UB1PopupDataAsset : UB1DataAssetBase
---@field PopupConstructMap TMap<FName, FB1PopupConstructData>
---@field PopupCloseTime float
---@field ChoiceCardPopupAutoSelectTime float
---@field PositiveAudioId FName
---@field NegativeAudioId FName
local UB1PopupDataAsset = {}



---@class UB1PostProcessMaterialDataAsset : UB1DataAssetBase
---@field DefaultOutlineMaterial TSoftObjectPtr<UMaterial>
---@field RescueOutlineMaterial TSoftObjectPtr<UMaterial>
---@field CustomPostProcessMIDefine TMap<FName, FB1PostProcessMaterialDefine>
---@field ClearPPCameraModeTypeList TArray<EB1CameraModeType>
local UB1PostProcessMaterialDataAsset = {}



---@class UB1PreferenceDataAsset : UB1DataAssetBase
---@field LikeFXObject UClass
---@field UnLikeFXObject UClass
local UB1PreferenceDataAsset = {}



---@class UB1ReactionDataAsset : UB1DataAssetBase
---@field Angle float
---@field Radius float
---@field ResetRadius float
---@field ReactionRate float
---@field ReactionCoolTime float
---@field MinRelationshipAbsoluteValue float
local UB1ReactionDataAsset = {}



---@class UB1RelationshipDataAsset : UB1DataAssetBase
---@field ShowRelationshipFxDistance float
---@field FocusSelectionFx FB1RelationshipFxSet
---@field StoryFx FB1RelationshipFxSet
---@field FXAsset TSoftObjectPtr<UNiagaraSystem>
---@field RomanceFrontColor FLinearColor
---@field RomanceBackColor FLinearColor
---@field FriendshipFrontColor FLinearColor
---@field FriendshipBackColor FLinearColor
---@field BusinessFrontColor FLinearColor
---@field BusinessBackColor FLinearColor
---@field FamilyFrontColor FLinearColor
---@field FamilyBackColor FLinearColor
---@field RomanceFxTexture TSoftObjectPtr<UTexture2D>
---@field FriendshipFxTexture TSoftObjectPtr<UTexture2D>
---@field BusinessFxTexture TSoftObjectPtr<UTexture2D>
---@field FamilyFxTexture TSoftObjectPtr<UTexture2D>
---@field HeightAnim_CurveFloat UCurveFloat
---@field OpacityAnim_CurveFloat UCurveFloat
---@field FxPositive3_ProgressValue float
---@field FxPositive2_ProgressValue float
---@field FxNegative2_ProgressValue float
---@field FxNegative3_ProgressValue float
---@field ToolTipWidgetClass TSubclassOf<UUserWidget>
---@field FamilyLoveTextId FString
---@field FamilyLoveWorstStepTextId FString
---@field FamilyLoveBadStepTwoTextId FString
---@field FamilyLoveGoodStepTextId FString
---@field FamilyLoveBestStepTextId FString
---@field FamilyLoveTypeColor TMap<EB1RelationshipFamilyLoveType, FName>
---@field RelationStateFxEmoticonValue TArray<int32>
---@field MobileSendGiftNoHomeTextId FString
---@field MobileSendGiftNoGiftTextId FString
---@field MobileMessageSendGiftTextId FString
---@field GiftOpenFailMessageTextId FString
---@field HouseMateTextId FString
---@field GiftCommonCustomMobileMessageDtId FName
---@field MoveTogeterConfirmButtonTextId FString
---@field MoveTogetherMaxSelectableCount int32
local UB1RelationshipDataAsset = {}



---@class UB1RelationshipEntryData : UObject
---@field Portrait UTexture
local UB1RelationshipEntryData = {}



---@class UB1RelationshipJsonDataAsset : UB1DataAssetBase
---@field MinRelationshipStat float
---@field MaxRelationshipStat float
---@field RelationshipDeleteWaitTime double
---@field RelationshipDecayCheckInterval float
---@field RelationshipBonusMultiplyTable TArray<FB1RelationshipBonusMultiplyData>
---@field bShowNumbersTogether boolean
---@field RelationshipEffectDisplaySetting TArray<FB1RelationshipEffectDisplaySetting>
---@field FamilyLoveSpouseModifier float
---@field RomanceId FName
---@field BusinessId FName
---@field FriendshipId FName
---@field FamilyId FName
---@field AutoDestroyGiftBoxDay int32
---@field AutoSendGiftBoxDay int32
---@field AutoSendGiftBoxRandonHourMin int32
---@field AutoSendGiftBoxRandonHourMax int32
---@field InvalidZoiToastMessageByDeath FName
---@field InvalidZoiToastMessageByLeaveCity FName
---@field GiftBoxRandomRoationYaw float
---@field TraitRelationshipMainRate float
---@field MainRelationshipAutonomyRate TMap<EB1RelationshipStatPriorityType, FB1MainRelationshipAutonomyRate>
---@field AutoSelectionMinuteTime int32
---@field TraitRelationshipMainRateList TMap<int32, float>
---@field CompletelyRandomTalkStatRate float
local UB1RelationshipJsonDataAsset = {}



---@class UB1RelationshipProfileDataAsset : UB1DataAssetBase
---@field ZoiInformationProfileData FB1ZoiInformationProfileData
---@field MaxImportantRecordSlotNum int32
---@field MaxProfileRecordNum int32
---@field HighlightRecordTextStyle FString
---@field GenderIconMap TMap<EB1GenderType, TSoftObjectPtr<UTexture2D>>
---@field GrowthStepIconMap TMap<EB1GrowthStep, TSoftObjectPtr<UTexture2D>>
local UB1RelationshipProfileDataAsset = {}



---@class UB1RumorDataAsset : UB1DataAssetBase
---@field MaxCount int32
---@field TransferRate float
---@field TransferScriptId FName
local UB1RumorDataAsset = {}



---@class UB1SaveLoadDataAsset : UB1DataAssetBase
---@field SaveHourList TArray<int32>
local UB1SaveLoadDataAsset = {}



---@class UB1ScriptValidationDataAsset : UB1DataAssetBase
---@field TickScriptCommands TArray<FName>
local UB1ScriptValidationDataAsset = {}



---@class UB1SeasonWeatherDataAsset : UB1DataAssetBase
---@field DefaultSeasonDays int32
---@field TemperatureRanges TArray<FB1TemperatureRangeConfig>
local UB1SeasonWeatherDataAsset = {}



---@class UB1ServiceDataAsset : UB1DataAssetBase
---@field MaximumServiceCountPerUniqueService int32
---@field TimeOutCheckIntervalMinute int32
---@field ServiceSpawnerCount int32
local UB1ServiceDataAsset = {}



---@class UB1SimulationConfigDataAsset : UB1DataAssetBase
---@field PIE_OverrideLevelNameWhenSimulationLevel FSoftObjectPath
---@field bExtractAndPlay_PIE boolean
---@field bLoadAlreadyExistNewGameJson boolean
---@field SiteDataSkipOption uint8
local UB1SimulationConfigDataAsset = {}



---@class UB1SiteConfigDataAsset : UB1DataAssetBase
---@field UpdateAndSaveSiteAreaGridInfoInterval float
---@field GoBackHomeGuideLimitTime float
---@field QEGuideTextKey FString
---@field MailboxTag FName
---@field MinMailboxSpawnDistance float
---@field MaxMailboxSpawnDistance float
---@field MailboxSpawnPointCount int32
local UB1SiteConfigDataAsset = {}



---@class UB1SiteEditConditionDataAsset : UB1DataAssetBase
---@field ShowSiteEditDefault boolean
---@field ShowSiteEditBySiteType TMap<EB1SiteType, boolean>
---@field ShowSiteEditBySubType TMap<EB1SiteSubType, boolean>
---@field ShowSiteEditBySiteIds TMap<FName, boolean>
---@field ShowSiteInfoDefault boolean
---@field ShowSiteInfoBySiteType TMap<EB1SiteType, boolean>
---@field ShowSiteInfoBySubType TMap<EB1SiteSubType, boolean>
---@field ShowSiteSaveDefault boolean
---@field ShowSiteSaveBySiteType TMap<EB1SiteType, boolean>
---@field ShowSiteSaveBySubType TMap<EB1SiteSubType, boolean>
local UB1SiteEditConditionDataAsset = {}



---@class UB1SkillDataAsset : UB1DataAssetBase
---@field SkillLevelUpMessage FString
---@field SkillLevelUpMessageLifeTime float
---@field SkillGaugeWidgetZOffset float
---@field SkillEntryWidgetMaxGaugeColorKey FB1TableRowName
---@field SkillEntryWidgetMaxGaugeAdditiveColorKey FB1TableRowName
---@field SkillEntryWidgetGaugeColorInfoArray TArray<FB1SkillEntryWidgetGaugeColorInfo>
---@field HudSkillCount uint8
local UB1SkillDataAsset = {}



---@class UB1SleepCurve : UB1DataAssetBase
---@field Curve TMap<int32, double>
local UB1SleepCurve = {}



---@class UB1SocialEventDataAsset : UB1DataAssetBase
---@field MembersTeleportWaitMinute int32
---@field AutonomyPreferredScoreAdd float
---@field AutonomyPreferredScoreMultiplier float
---@field AutonomyAvoidScoreAdd float
---@field AutonomyAvoidScoreMultiplier float
---@field MaxRoleActivityCount int32
---@field AutonomyMaxTotalReward int64
---@field SocialEventPopupId FName
local UB1SocialEventDataAsset = {}



---@class UB1SocketDataAsset : UB1DataAssetBase
---@field LeftGrabSocket FName
---@field RightGrabSocket FName
local UB1SocketDataAsset = {}



---@class UB1SpawnerDataAsset : UB1DataAssetBase
---@field SpawnerActorPath TMap<EB1SpawnerType, TSoftObjectPtr<UObject>>
---@field MeshDescription TMap<FName, FB1MeshSpawnDescription>
---@field MaxSpawnIndex int32
---@field MeshSpawnerVisibilityDelay int32
local UB1SpawnerDataAsset = {}



---@class UB1StableDiffusionDataAsset : UB1DataAssetBase
---@field AITextureMaxCount int32
---@field StableDiffusionMaterialInfos TArray<FB1StableDiffusionMaterialInfo>
local UB1StableDiffusionDataAsset = {}



---@class UB1StatDataAsset : UB1DataAssetBase
---@field StatAlramDuration float
---@field KarmaMinimumValue float
---@field StatAdditionalPriorityInteractionRate TMap<FName, float>
---@field StatIconId FName
---@field StatDangerValue float
---@field StatWarningValue float
---@field StatDangerColorId FName
---@field StatWarningColorId FName
---@field StatDangerTooltipText FString
---@field StatWarningTooltipText FString
---@field InitHouseHoldStats TMap<FName, float>
local UB1StatDataAsset = {}



---@class UB1StateDataAsset : UB1DataAssetBase
---@field GlobalStateGroupInfo TArray<FB1StateGroupInfo>
---@field GlobalSelectionSetInfo TArray<FB1SelectionSet>
---@field FireSpreadMaxRadius float
---@field FireSpreadTime float
---@field FireSpreadRate TMap<int32, float>
---@field FXAssetOverrideList TMap<FName, FB1StatePlayFXData>
---@field SootGameObjectId FName
---@field WallSootGameObjectId FName
---@field FireExtinguishInfo TMap<FName, FB1FireExtinguishInfo>
---@field CleanDespawnSootStateGroupId FName
---@field CleanDespawnSootStateId FName
---@field SootStatId FName
---@field GlobalAvailableStatList TArray<FName>
---@field FireResistanceObjectTag FName
---@field SiteActionIdOnFireStart FName
---@field SiteActionIdOnFireEnd FName
---@field ScriptIdOnFireStart FName
---@field CollectElectricityTax FName
---@field ElectricityDecactivation FName
---@field ElectricityActivation FName
---@field WaterDecactivation FName
---@field WaterAcativation FName
---@field SeizureInEffect FName
---@field SeizureReleased FName
---@field Liquidation FName
---@field SaleableStateId FName
---@field SoldoutStateId FName
---@field PriceValueMinRate float
---@field PriceValueMaxRate float
---@field RepairObjectBroken FName
local UB1StateDataAsset = {}



---@class UB1StaticMeshAnimDataAsset : UB1DataAssetBase
---@field AnimData TMap<FName, FB1StaticMeshAnimDataList>
local UB1StaticMeshAnimDataAsset = {}



---@class UB1StringLoader : UObject
local UB1StringLoader = {}


---@class UB1StuckDataAsset : UB1DataAssetBase
---@field CheckCoolTime_Alert int32
---@field CheckCoolTime_CantAction int32
---@field Thresholds_AutonomyTime int32
---@field Thresholds_NotEnoughStatCount int32
---@field Thresholds_CurrencySalvation int32
---@field Thresholds_FamilyRelationship float
---@field Thresholds_HomeDustyValue float
---@field CurrencySalvationMissionDtId FName
---@field AlertMessage_AutonomyTime FString
---@field AlertMessage_NotEnoughStat FString
---@field AlertMessage_HomeFire FString
---@field AlertMessage_HomeDustyValue FString
---@field AlertMessage_FamilyRelationship FString
---@field AlertMessage_CurrencySalvation FString
---@field AlertMessage_NotEnoughBed FString
local UB1StuckDataAsset = {}



---@class UB1StudioPoseDataAsset : UB1DataAssetBase
---@field FemaleFacialPoseList TArray<FB1StudioPoseData>
---@field FemaleBodyPoseList TArray<FB1StudioPoseData>
---@field MaleFacialPoseList TArray<FB1StudioPoseData>
---@field MaleBodyPoseList TArray<FB1StudioPoseData>
local UB1StudioPoseDataAsset = {}



---@class UB1SubActionDataAsset : UB1DataAssetBase
---@field TakeOffShoesAnimId FName
---@field TakeOffShoesOutfitId FName
---@field TakeOffShoesScriptIds TArray<FName>
---@field PutOnShoesScriptIds TArray<FName>
---@field GreetingRadius float
---@field GreetingAngle float
---@field GreetingRate float
---@field GreetingCoolTime float
---@field GreetingAnimIds TArray<FName>
---@field PlayAnimMap TMap<FName, FB1SubActionAnimData>
---@field AvoidanceRadius float
---@field AvoidanceFacingAngle float
---@field AvoidanceAnimIds TMap<EB1AvoidanceType, FName>
---@field AvoidanceReactionAnimIds TArray<FName>
---@field AvoidanceVehicleReactionAnimIds TArray<FName>
---@field TalkRadius float
---@field TalkAngle float
---@field TalkRate float
---@field UnrelatedTargetTalkRate float
---@field TalkCoolTime float
---@field TalkInteractionBagIds TMap<FName, float>
local UB1SubActionDataAsset = {}



---@class UB1TalkDataAsset : UB1DataAssetBase
---@field FixedTargetTalkSpace_MaxAngle float
---@field FixedTargetTalkSpace_MaxDistance float
---@field FixedTargetTalkSpace_DistanceInterval float
---@field FixedTargetTalkSpace_ArcLengthInterval float
---@field RemainTalkCount int32
---@field TalkCannotCancelInteractionBagTag FName
---@field ChitchatRelationshipProbability_OneToOne float
---@field ChitchatRelationshipProbability_OneToMany float
---@field ChitchatRelationshipStat_Min float
---@field ChitchatRelationshipStat_Max float
---@field TalkIndividualDropRate float
---@field TalkIndividualDropCount int32
---@field InteractionBagTagPositive FName
---@field InteractionBagTagNegative FName
---@field InteractionBagTagRelationshipFocus FName
---@field InteractionBagTagEssential FName
local UB1TalkDataAsset = {}



---@class UB1TaxDataAsset : UB1DataAssetBase
---@field ChargeDay EB1DayOfWeek
---@field ChargeTime FString
---@field MessageId FName
---@field MessageIdForPossessCharacter FName
---@field MessageIdForCancelCharged FName
---@field PlayingNotOldestCharacterMessageId FString
---@field DescTextId FString
---@field PropertyTaxRate float
---@field ElectricityTax FB1Tax
---@field WaterTax FB1Tax
---@field DelinquencyList TArray<FB1Delinquency>
---@field SeizureOnDay int32
---@field Seizure FB1Seizure
---@field WhitelistInteractionBagIds TSet<FName>
---@field WhitelistObjectFilterCategoryIds TSet<FName>
---@field ElectricityTaxAlert FName
---@field ElectricityTaxMinThreshold float
---@field ElectricityTaxIncreasePercentageForAlert float
---@field WaterTaxAlert FName
---@field WaterTaxMinThreshold float
---@field WaterTaxIncreasePercentageForAlert float
local UB1TaxDataAsset = {}



---@class UB1TemporaryMeshDataAsset : UB1DataAssetBase
---@field TemporaryMeshInfos TMap<FName, TSoftObjectPtr<UStaticMesh>>
local UB1TemporaryMeshDataAsset = {}



---@class UB1TestFramework : UObject
local UB1TestFramework = {}


---@class UB1TimelineDataAsset : UB1DataAssetBase
---@field FriendVisitWaitBuffName FName
---@field AutoCloseHourAfter uint32
---@field SiteExitRemainMinute int32
---@field ScheduleTooltipDefaultImage TSoftObjectPtr<UTexture2D>
---@field NoneTalkableTimeline TArray<FName>
---@field GoHomeInteractionBagId FName
---@field GoHomeWithVehicleInteractionBagId FName
---@field ScheduleMoveSprintExceedTime int32
---@field MinRandomAutonomyForCrowd int32
---@field MaxRandomAutonomyForCrowd int32
---@field RetryAutonomyForCrowd int32
---@field SpawnerOverlapDistance float
---@field StartWoringGap uint32
---@field MinStepStartWorking int32
---@field MaxStepStartWorking int32
---@field ScheduleEdit_MinTimeUnsatisfied_Message FString
---@field ScheduleEdit_WorkingScheduleMinTimeUnsatisfied_Message FString
---@field ScheduleEdit_EditLockedByJob_Message FString
---@field ScheduleEdit_EditLockedByScheduleIntersection_Message FString
---@field ScheduleEditTooltip_EditLockedByAge_Message FString
---@field ScheduleEditTooltip_MinTimeUnsatisfied FString
---@field CrowdDecreaseHour int32
---@field CrowdIncreaseHour int32
local UB1TimelineDataAsset = {}



---@class UB1TooltipJsonDataAsset : UB1DataAssetBase
---@field TooltipShowDelay float
---@field TooltipScreenPadding float
local UB1TooltipJsonDataAsset = {}



---@class UB1TrafficLightDataAsset : UB1DataAssetBase
---@field CityTrafficLights TMap<FName, FB1CityTrafficLights>
local UB1TrafficLightDataAsset = {}



---@class UB1TraitDataAsset : UB1DataAssetBase
---@field BaseCameraDist float
---@field WidgetSizeRate float
---@field TraitCategory TMap<FName, FString>
---@field CatOperatorUnablePerspectiveTextId FString
---@field CatOperatorChangePerspectiveTooltipId FString
---@field TraitIdGeneticProbability float
---@field TraitCategoryGeneticProbability float
local UB1TraitDataAsset = {}



---@class UB1Utils : UObject
local UB1Utils = {}


---@class UB1UtilsSetting : UObject
---@field bEnableAutomationTest boolean
local UB1UtilsSetting = {}



---@class UB1VehicleDataAsset : UB1DataAssetBase
---@field VehicleSetting TMap<FName, FB1VehicleSetting>
---@field DefaultSetting FB1VehicleDefaultSetting
---@field OtherPassengerHaveNotEnteredMessage FString
---@field NonOwnerInDriverSeatMessage FString
---@field VehicleUnavailableMessage FString
---@field MoveWithVehicleFailedMessage FString
---@field MoveWithVehicleArriveMessage FString
---@field MoveWithVehicleCancelMessage FString
---@field VehicleSpawnFailedMessage FString
---@field VehicleTowingMessage FString
---@field CommonReturnToParkingPlaceMessage FString
---@field VehiclePurchaseFailureMessage FString
---@field VehicleSellSuccessMessage FString
---@field VehicleSellFailureMessage FString
---@field VehicleDisableSellMessage FString
---@field GroundClickMessage FString
---@field OtherPassengerHaveNotEnteredTooltip FString
---@field SitDriversSeatDriveVehicleMessage FString
---@field VehiclePurchaseSuccessPopupId FName
---@field VehiclePurchaseFailedPopupId FName
---@field MovableFloorHeight float
---@field MoveWithVehicleRatioForSchedule float
---@field TowingDecisionTime float
---@field TowingDecisionDistance float
---@field SimulationDriverSlotAdjLocation FVector
---@field SimulationDriverMesh TMap<FName, FB1SimulationDriverData>
---@field LeftSteeringMotion TSoftObjectPtr<UAnimMontage>
---@field RightSteeringMotion TSoftObjectPtr<UAnimMontage>
---@field ReturnToParkingPlaceExecutionScripts TArray<FName>
---@field ParkingPlaceVisibilityDelay int32
---@field HeadLightsAutoTurnOnTimeRange FIntVector2
---@field HighResolutionRepresentationDistance float
---@field MediumResolutionRepresentationDistance float
---@field LowResolutionRepresentationDistance float
---@field VerticalImpulseHitByVehicle float
---@field VehicleAccidentTriggerSpeed float
---@field VehicleAccidentOverlapMinimumSpeed float
---@field VehicleAccidentMinimumCameraDistance float
---@field VehicleAccidentMinimumObjectDistance float
---@field VehicleMapIconSetting FB1VehicleMapIconSetting
---@field DespawnTargetSpeed float
---@field DespawnTargetHoldTime float
---@field DeviationCheckInterval float
---@field DeviationAlertTime float
---@field DeviationRecoveryTime float
---@field DeviationThreshold FVector
---@field bAutoDrivePopupEnable boolean
---@field AutoDrivingSkipMinute int64
---@field MoveWithVehicleInteractionBagIdList TArray<FName>
local UB1VehicleDataAsset = {}



---@class UB1VideoPlayerDataAsset : UB1DataAssetBase
---@field VideoPlayerInfoList TMap<EB1VideoPlayerId, FB1VideoPlayerInfo>
local UB1VideoPlayerDataAsset = {}



---@class UB1WeatherDataAsset : UB1DataAssetBase
---@field DefaultWeatherSetting FSoftObjectPath
---@field WeatherSettings TMap<FSoftObjectPath, FB1WeatherSetting>
local UB1WeatherDataAsset = {}



---@class UB1WeatherJsonDataAsset : UB1DataAssetBase
---@field CharacterRainDrySpeed float
---@field CharacterRainWetSpeed float
local UB1WeatherJsonDataAsset = {}



---@class UB1WeatheringDataAsset : UB1DataAssetBase
---@field WeatheringMaterial TSoftObjectPtr<UMaterialInterface>
---@field DefaultClothWeatheringId FName
---@field ClothWeatheringStatId FName
---@field ExcludedObjectFilterCategories TArray<FName>
local UB1WeatheringDataAsset = {}



---@class UB1WeatheringModifierDataAsset : UB1DataAssetBase
---@field ModifierKeys TArray<FName>
local UB1WeatheringModifierDataAsset = {}



---@class UB1WidgetCustomizationDataAsset : UB1DataAssetBase
---@field bUseWidgetCustomization boolean
---@field bDebugMode boolean
---@field WidgetCustomization FB1GameConfigWidgetCustomization
local UB1WidgetCustomizationDataAsset = {}



---@class UB1WidgetDataAsset : UB1DataAssetBase
---@field PlayerProfileDataList TArray<FB1PlayerProfileData>
---@field SiteEditTooltipStringId FString
---@field ButtonDesign TMap<EB1ButtonType, FB1CommonButtonDesignData>
---@field DefaultCommonButtonClass TSubclassOf<UUserWidget>
---@field GhostToggleButtons TSet<EB1UIType>
---@field AddESCWidgetList TArray<EB1UIType>
---@field MinValue int64
---@field MaxValue int64
local UB1WidgetDataAsset = {}



---@class UB1WidgetJsonDataAsset : UB1DataAssetBase
---@field CharacterMenuWidgetZOffset float
---@field InteractionMenuZOffset float
---@field RelationshipPointEffectZOffset float
---@field CurrencyEffectZOffset float
---@field SpeechBubbleZOffsetForCharacter float
---@field BuildCustomizeMenuZOffset float
---@field PlayerNaviZOffset float
---@field DreamBubbleZOffset float
---@field DreamBubbleImageChangeDuration float
---@field DynamicUIVisibleDistanceSquared float
---@field AutoOpenDesireWidgetData FB1AutoOpenDesireWidgetData
---@field ListEntryFallbackIconId FName
---@field GuideToChangeShoulderViewTextId FString
---@field GuideToChangeTopViewTextId FString
---@field DisplayWidgetDuration float
local UB1WidgetJsonDataAsset = {}



---@class UB1WorldManagerConfigDataAsset : UB1DataAssetBase
---@field ResidacneRequestDay int32
---@field MaxPopulationInWorld int32
---@field PopulationAdjustmentRate float
---@field FemaleGenderRate float
---@field GrowthStepPopulationRates TMap<EB1GrowthStep, float>
local UB1WorldManagerConfigDataAsset = {}



---@class UB1WorldMapConfigDataAsset : UB1DataAssetBase
---@field LeftClickThreshold float
---@field WorldMapCameraSetting TArray<FB1WorldMapCameraSetting>
---@field FamilyMoveImpossibleReasons TMap<EB1WorldMapFamilyMoveImpossibleReason, FString>
---@field SiteNameLimitSize int32
---@field SiteDescLimitSize int32
local UB1WorldMapConfigDataAsset = {}



---@class UB2Utils : UObject
local UB2Utils = {}


