---@meta

---@class FConcertAdmin_ArchiveSessionRequest : FConcertRequestData
---@field SessionId FGuid
---@field ArchiveNameOverride FString
---@field username FString
---@field DeviceName FString
---@field SessionFilter FConcertSessionFilter
local FConcertAdmin_ArchiveSessionRequest = {}



---@class FConcertAdmin_ArchiveSessionResponse : FConcertResponseData
---@field SessionId FGuid
---@field SessionName FString
---@field ArchiveId FGuid
---@field ArchiveName FString
local FConcertAdmin_ArchiveSessionResponse = {}



---@class FConcertAdmin_BatchDeleteSessionRequest : FConcertRequestData
---@field SessionIds TSet<FGuid>
---@field Flags EBatchSessionDeletionFlags
---@field username FString
---@field DeviceName FString
local FConcertAdmin_BatchDeleteSessionRequest = {}



---@class FConcertAdmin_BatchDeleteSessionResponse : FConcertResponseData
---@field DeletedItems TArray<FDeletedSessionInfo>
---@field NotOwnedByClient TArray<FDeletedSessionInfo>
local FConcertAdmin_BatchDeleteSessionResponse = {}



---@class FConcertAdmin_CopySessionRequest : FConcertRequestData
---@field SessionId FGuid
---@field SessionName FString
---@field OwnerClientInfo FConcertClientInfo
---@field SessionSettings FConcertSessionSettings
---@field VersionInfo FConcertSessionVersionInfo
---@field SessionFilter FConcertSessionFilter
local FConcertAdmin_CopySessionRequest = {}



---@class FConcertAdmin_CreateSessionRequest : FConcertRequestData
---@field SessionName FString
---@field OwnerClientInfo FConcertClientInfo
---@field SessionSettings FConcertSessionSettings
---@field VersionInfo FConcertSessionVersionInfo
local FConcertAdmin_CreateSessionRequest = {}



---@class FConcertAdmin_DeleteSessionRequest : FConcertRequestData
---@field SessionId FGuid
---@field username FString
---@field DeviceName FString
local FConcertAdmin_DeleteSessionRequest = {}



---@class FConcertAdmin_DeleteSessionResponse : FConcertResponseData
---@field SessionId FGuid
---@field SessionName FString
local FConcertAdmin_DeleteSessionResponse = {}



---@class FConcertAdmin_DiscoverServersEvent : FConcertEndpointDiscoveryEvent
---@field RequiredRole FString
---@field RequiredVersion FString
---@field ClientAuthenticationKey FString
local FConcertAdmin_DiscoverServersEvent = {}



---@class FConcertAdmin_DropSessionRepositoriesRequest : FConcertRequestData
---@field RepositoryIds TArray<FGuid>
local FConcertAdmin_DropSessionRepositoriesRequest = {}



---@class FConcertAdmin_DropSessionRepositoriesResponse : FConcertResponseData
---@field DroppedRepositoryIds TArray<FGuid>
local FConcertAdmin_DropSessionRepositoriesResponse = {}



---@class FConcertAdmin_FindSessionRequest : FConcertRequestData
---@field SessionId FGuid
---@field OwnerClientInfo FConcertClientInfo
---@field SessionSettings FConcertSessionSettings
---@field VersionInfo FConcertSessionVersionInfo
local FConcertAdmin_FindSessionRequest = {}



---@class FConcertAdmin_GetAllSessionsRequest : FConcertRequestData
local FConcertAdmin_GetAllSessionsRequest = {}


---@class FConcertAdmin_GetAllSessionsResponse : FConcertResponseData
---@field LiveSessions TArray<FConcertSessionInfo>
---@field ArchivedSessions TArray<FConcertSessionInfo>
local FConcertAdmin_GetAllSessionsResponse = {}



---@class FConcertAdmin_GetArchivedSessionsRequest : FConcertRequestData
local FConcertAdmin_GetArchivedSessionsRequest = {}


---@class FConcertAdmin_GetLiveSessionsRequest : FConcertRequestData
local FConcertAdmin_GetLiveSessionsRequest = {}


---@class FConcertAdmin_GetSessionActivitiesRequest : FConcertRequestData
---@field SessionId FGuid
---@field FromActivityId int64
---@field ActivityCount int64
---@field bIncludeDetails boolean
local FConcertAdmin_GetSessionActivitiesRequest = {}



---@class FConcertAdmin_GetSessionActivitiesResponse : FConcertResponseData
---@field Activities TArray<FConcertSessionSerializedPayload>
---@field EndpointClientInfoMap TMap<FGuid, FConcertClientInfo>
local FConcertAdmin_GetSessionActivitiesResponse = {}



---@class FConcertAdmin_GetSessionClientsRequest : FConcertRequestData
---@field SessionId FGuid
local FConcertAdmin_GetSessionClientsRequest = {}



---@class FConcertAdmin_GetSessionClientsResponse : FConcertResponseData
---@field SessionClients TArray<FConcertSessionClientInfo>
local FConcertAdmin_GetSessionClientsResponse = {}



---@class FConcertAdmin_GetSessionRepositoriesRequest : FConcertRequestData
local FConcertAdmin_GetSessionRepositoriesRequest = {}


---@class FConcertAdmin_GetSessionRepositoriesResponse : FConcertResponseData
---@field SessionRepositories TArray<FConcertSessionRepositoryInfo>
local FConcertAdmin_GetSessionRepositoriesResponse = {}



---@class FConcertAdmin_GetSessionsResponse : FConcertResponseData
---@field Sessions TArray<FConcertSessionInfo>
local FConcertAdmin_GetSessionsResponse = {}



---@class FConcertAdmin_MountSessionRepositoryRequest : FConcertRequestData
---@field RepositoryId FGuid
---@field RepositoryRootDir FString
---@field bAsServerDefault boolean
---@field bCreateIfNotExist boolean
local FConcertAdmin_MountSessionRepositoryRequest = {}



---@class FConcertAdmin_MountSessionRepositoryResponse : FConcertResponseData
---@field MountStatus EConcertSessionRepositoryMountResponseCode
local FConcertAdmin_MountSessionRepositoryResponse = {}



---@class FConcertAdmin_RenameSessionRequest : FConcertRequestData
---@field SessionId FGuid
---@field NewName FString
---@field username FString
---@field DeviceName FString
local FConcertAdmin_RenameSessionRequest = {}



---@class FConcertAdmin_RenameSessionResponse : FConcertResponseData
---@field SessionId FGuid
---@field OldName FString
local FConcertAdmin_RenameSessionResponse = {}



---@class FConcertAdmin_ServerDiscoveredEvent : FConcertEndpointDiscoveryEvent
---@field serverName FString
---@field InstanceInfo FConcertInstanceInfo
---@field ServerFlags EConcertServerFlags
local FConcertAdmin_ServerDiscoveredEvent = {}



---@class FConcertAdmin_SessionInfoResponse : FConcertResponseData
---@field SessionInfo FConcertSessionInfo
local FConcertAdmin_SessionInfoResponse = {}



---@class FConcertByteArray
---@field Bytes TArray<uint8>
local FConcertByteArray = {}



---@class FConcertClientInfo
---@field InstanceInfo FConcertInstanceInfo
---@field DeviceName FString
---@field PlatformName FString
---@field username FString
---@field DisplayName FString
---@field AvatarColor FLinearColor
---@field DesktopAvatarActorClass FString
---@field VRAvatarActorClass FString
---@field Tags TArray<FName>
---@field bHasEditorData boolean
---@field bRequiresCookedData boolean
local FConcertClientInfo = {}



---@class FConcertCustomVersionInfo
---@field FriendlyName FName
---@field Key FGuid
---@field Version int32
local FConcertCustomVersionInfo = {}



---@class FConcertEngineVersionInfo
---@field Major uint16
---@field Minor uint16
---@field Patch uint16
---@field ChangeList uint32
local FConcertEngineVersionInfo = {}



---@class FConcertFileVersionInfo
---@field FileVersion int32
---@field FileVersionUE5 int32
---@field FileVersionLicensee int32
local FConcertFileVersionInfo = {}



---@class FConcertInstanceInfo
---@field InstanceId FGuid
---@field InstanceName FString
---@field InstanceType FString
local FConcertInstanceInfo = {}



---@class FConcertLog
---@field Frame uint64
---@field MessageId FGuid
---@field MessageOrderIndex uint16
---@field ChannelId uint16
---@field Timestamp FDateTime
---@field MessageAction EConcertLogMessageAction
---@field MessageTypeName FName
---@field OriginEndpointId FGuid
---@field DestinationEndpointId FGuid
---@field CustomPayloadTypename FName
---@field CustomPayloadUncompressedByteSize int32
---@field StringPayload FString
---@field SerializedPayload FConcertSessionSerializedPayload
local FConcertLog = {}



---@class FConcertServerInfo
---@field AdminEndpointId FGuid
---@field serverName FString
---@field InstanceInfo FConcertInstanceInfo
---@field ServerFlags EConcertServerFlags
local FConcertServerInfo = {}



---@class FConcertSessionClientInfo
---@field ClientEndpointId FGuid
---@field ClientInfo FConcertClientInfo
local FConcertSessionClientInfo = {}



---@class FConcertSessionFilter
---@field ActivityIdLowerBound int64
---@field ActivityIdUpperBound int64
---@field ActivityIdsToExclude TArray<int64>
---@field ActivityIdsToInclude TArray<int64>
---@field bOnlyLiveData boolean
---@field bMetaDataOnly boolean
---@field bIncludeIgnoredActivities boolean
local FConcertSessionFilter = {}



---@class FConcertSessionInfo
---@field ServerInstanceId FGuid
---@field ServerEndpointId FGuid
---@field OwnerInstanceId FGuid
---@field SessionId FGuid
---@field SessionName FString
---@field OwnerUserName FString
---@field OwnerDeviceName FString
---@field Settings FConcertSessionSettings
---@field VersionInfos TArray<FConcertSessionVersionInfo>
---@field State EConcertSessionState
---@field LastModifiedTicks int64
local FConcertSessionInfo = {}



---@class FConcertSessionRepositoryInfo
---@field RepositoryId FGuid
---@field bMounted boolean
local FConcertSessionRepositoryInfo = {}



---@class FConcertSessionSerializedPayload
---@field PayloadTypeName FName
---@field SerializationMethod EConcertPayloadSerializationMethod
---@field PayloadCompressionDetails EConcertCompressionDetails
---@field PayloadSize int32
---@field PayloadBytes FConcertByteArray
local FConcertSessionSerializedPayload = {}



---@class FConcertSessionSettings
---@field ProjectName FString
---@field BaseRevision uint32
---@field ArchiveNameOverride FString
local FConcertSessionSettings = {}



---@class FConcertSessionVersionInfo
---@field FileVersion FConcertFileVersionInfo
---@field EngineVersion FConcertEngineVersionInfo
---@field CustomVersions TArray<FConcertCustomVersionInfo>
local FConcertSessionVersionInfo = {}



---@class FConcertSession_ClientListUpdatedEvent : FConcertEventData
---@field SessionClients TArray<FConcertSessionClientInfo>
local FConcertSession_ClientListUpdatedEvent = {}



---@class FConcertSession_CustomEvent : FConcertEventData
---@field SourceEndpointId FGuid
---@field DestinationEndpointIds TArray<FGuid>
---@field SerializedPayload FConcertSessionSerializedPayload
local FConcertSession_CustomEvent = {}



---@class FConcertSession_CustomRequest : FConcertRequestData
---@field SourceEndpointId FGuid
---@field DestinationEndpointId FGuid
---@field SerializedPayload FConcertSessionSerializedPayload
local FConcertSession_CustomRequest = {}



---@class FConcertSession_CustomResponse : FConcertResponseData
---@field SerializedPayload FConcertSessionSerializedPayload
local FConcertSession_CustomResponse = {}



---@class FConcertSession_DiscoverAndJoinSessionEvent : FConcertEndpointDiscoveryEvent
---@field SessionServerEndpointId FGuid
---@field ClientInfo FConcertClientInfo
local FConcertSession_DiscoverAndJoinSessionEvent = {}



---@class FConcertSession_JoinSessionResultEvent : FConcertEndpointDiscoveryEvent
---@field SessionServerEndpointId FGuid
---@field ConnectionResult EConcertConnectionResult
---@field SessionClients TArray<FConcertSessionClientInfo>
local FConcertSession_JoinSessionResultEvent = {}



---@class FConcertSession_LeaveSessionEvent : FConcertEventData
---@field SessionServerEndpointId FGuid
local FConcertSession_LeaveSessionEvent = {}



---@class FConcertSession_SessionRenamedEvent : FConcertEventData
---@field NewName FString
local FConcertSession_SessionRenamedEvent = {}



---@class FConcertSession_UpdateClientInfoEvent : FConcertEventData
---@field SessionClient FConcertSessionClientInfo
local FConcertSession_UpdateClientInfoEvent = {}



---@class FDeletedSessionInfo
---@field SessionId FGuid
---@field SessionName FString
local FDeletedSessionInfo = {}



