---@meta

---@class FConcertClientSettings
---@field DisplayName FString
---@field AvatarColor FLinearColor
---@field DesktopAvatarActorClass FSoftClassPath
---@field VRAvatarActorClass FSoftClassPath
---@field ServerPort uint16
---@field DiscoveryTimeoutSeconds int32
---@field SessionTickFrequencySeconds int32
---@field LatencyCompensationMs float
---@field bReflectLevelEditorInGame boolean
---@field bSupportMixedBuildTypes boolean
---@field Tags TArray<FName>
---@field ClientAuthenticationKey FString
local FConcertClientSettings = {}



---@class FConcertSourceControlSettings
---@field ValidationMode EConcertSourceValidationMode
local FConcertSourceControlSettings = {}



---@class UConcertClientConfig : UObject
---@field bIsHeadless boolean
---@field bInstallEditorToolbarButton boolean
---@field bAutoConnect boolean
---@field bRetryAutoConnectOnError boolean
---@field ServerType EConcertServerType
---@field DefaultServerURL FString
---@field DefaultSessionName FString
---@field DefaultSessionToRestore FString
---@field DefaultSaveSessionAs FString
---@field ReadOnlyAssignment FGameplayTagContainer
---@field SendOnlyAssignment FGameplayTagContainer
---@field bShouldPromptForHotReloadOnLevel boolean
---@field ClientSettings FConcertClientSettings
---@field SourceControlSettings FConcertSourceControlSettings
---@field EndpointSettings FConcertEndpointSettings
local UConcertClientConfig = {}



