---@meta

---@class FConcertAckData : FConcertMessageData
---@field AckSendTimeTicks int64
---@field SourceMessageId FGuid
local FConcertAckData = {}



---@class FConcertEndpointClosedData : FConcertMessageData
local FConcertEndpointClosedData = {}


---@class FConcertEndpointDiscoveryEvent : FConcertEventData
---@field ConcertProtocolVersion EConcertMessageVersion
local FConcertEndpointDiscoveryEvent = {}



---@class FConcertEndpointSettings
---@field bEnableLogging boolean
---@field PurgeProcessedMessageDelaySeconds int32
---@field RemoteEndpointTimeoutSeconds int32
local FConcertEndpointSettings = {}



---@class FConcertEventData : FConcertMessageData
local FConcertEventData = {}


---@class FConcertKeepAlive : FConcertMessageData
local FConcertKeepAlive = {}


---@class FConcertLocalIdentifierState
---@field MappedNames TArray<FString>
local FConcertLocalIdentifierState = {}



---@class FConcertMessageData
---@field ConcertEndpointId FGuid
---@field MessageId FGuid
---@field MessageOrderIndex uint16
---@field ChannelId uint16
local FConcertMessageData = {}



---@class FConcertReliableHandshakeData : FConcertEndpointDiscoveryEvent
---@field HandshakeState EConcertReliableHandshakeState
---@field ReliableChannelId uint16
---@field NextMessageIndex uint16
---@field EndpointTimeoutTick int64
local FConcertReliableHandshakeData = {}



---@class FConcertRequestData : FConcertMessageData
local FConcertRequestData = {}


---@class FConcertResponseData : FConcertMessageData
---@field RequestMessageId FGuid
---@field ResponseCode EConcertResponseCode
---@field Reason FText
local FConcertResponseData = {}



---@class FConcertSendResendPending
local FConcertSendResendPending = {}


---@class UConcertEndpointConfig : UObject
---@field EndpointSettings FConcertEndpointSettings
local UConcertEndpointConfig = {}



