---@meta

---@class FAnimNode_MotionMatching : FAnimNode_BlendStack_Standalone
---@field Database UPoseSearchDatabase
---@field BlendTime float
---@field BlendProfile UBlendProfile
---@field BlendOption EAlphaBlendOption
---@field PoseJumpThresholdTime FFloatInterval
---@field PoseReselectHistory float
---@field SearchThrottleTime float
---@field PlayRate FFloatInterval
---@field bUseInertialBlend boolean
---@field bResetOnBecomingRelevant boolean
---@field bShouldSearch boolean
---@field bShouldUseCachedChannelData boolean
---@field DatabasesToSearch TArray<UPoseSearchDatabase>
local FAnimNode_MotionMatching = {}



---@class FAnimNode_PoseSearchComponentSpaceHistoryCollector : FAnimNode_PoseSearchHistoryCollector_Base
---@field Source FComponentSpacePoseLink
local FAnimNode_PoseSearchComponentSpaceHistoryCollector = {}



---@class FAnimNode_PoseSearchHistoryCollector : FAnimNode_PoseSearchHistoryCollector_Base
---@field Source FPoseLink
local FAnimNode_PoseSearchHistoryCollector = {}



---@class FAnimNode_PoseSearchHistoryCollector_Base : FAnimNode_Base
---@field PoseCount int32
---@field SamplingInterval float
---@field CollectedBones TArray<FBoneReference>
---@field bInitializeWithRefPose boolean
---@field bResetOnBecomingRelevant boolean
---@field bStoreScales boolean
---@field RootBoneRecoveryTime float
---@field bGenerateTrajectory boolean
---@field Trajectory FPoseSearchQueryTrajectory
---@field TrajectorySpeedMultiplier float
---@field TrajectoryHistoryCount int32
---@field TrajectoryPredictionCount int32
---@field PredictionSamplingInterval float
---@field TrajectoryData FPoseSearchTrajectoryData
local FAnimNode_PoseSearchHistoryCollector_Base = {}



---@class FMotionMatchingAnimNodeReference : FAnimNodeReference
local FMotionMatchingAnimNodeReference = {}


---@class FPoseSearchBlueprintResult
---@field SelectedAnimation UObject
---@field SelectedTime float
---@field WantedPlayRate float
---@field bLoop boolean
---@field bIsMirrored boolean
---@field BlendParameters FVector
---@field SelectedDatabase TWeakObjectPtr<UPoseSearchDatabase>
---@field SearchCost float
local FPoseSearchBlueprintResult = {}



---@class FPoseSearchBone
---@field Reference FBoneReference
---@field Flags int32
local FPoseSearchBone = {}



---@class FPoseSearchCost
---@field TotalCost float
local FPoseSearchCost = {}



---@class FPoseSearchDatabaseAnimComposite : FPoseSearchDatabaseAnimationAssetBase
---@field AnimComposite UAnimComposite
local FPoseSearchDatabaseAnimComposite = {}



---@class FPoseSearchDatabaseAnimMontage : FPoseSearchDatabaseAnimationAssetBase
---@field AnimMontage UAnimMontage
local FPoseSearchDatabaseAnimMontage = {}



---@class FPoseSearchDatabaseAnimationAssetBase
local FPoseSearchDatabaseAnimationAssetBase = {}


---@class FPoseSearchDatabaseBlendSpace : FPoseSearchDatabaseAnimationAssetBase
---@field BlendSpace UBlendSpace
local FPoseSearchDatabaseBlendSpace = {}



---@class FPoseSearchDatabaseMultiSequence : FPoseSearchDatabaseAnimationAssetBase
---@field MultiSequence UPoseSearchMultiSequence
local FPoseSearchDatabaseMultiSequence = {}



---@class FPoseSearchDatabaseSequence : FPoseSearchDatabaseAnimationAssetBase
---@field Sequence UAnimSequence
local FPoseSearchDatabaseSequence = {}



---@class FPoseSearchFutureProperties
---@field Animation UObject
---@field AnimationTime float
---@field IntervalTime float
local FPoseSearchFutureProperties = {}



---@class FPoseSearchHistoryCollectorAnimNodeReference : FAnimNodeReference
local FPoseSearchHistoryCollectorAnimNodeReference = {}


---@class FPoseSearchMultiSequenceItem
---@field Sequence UAnimSequenceBase
---@field Role FName
---@field Origin FTransform
local FPoseSearchMultiSequenceItem = {}



---@class FPoseSearchQueryTrajectory
---@field Samples TArray<FPoseSearchQueryTrajectorySample>
local FPoseSearchQueryTrajectory = {}



---@class FPoseSearchQueryTrajectorySample
---@field Facing FQuat
---@field Position FVector
---@field AccumulatedSeconds float
local FPoseSearchQueryTrajectorySample = {}



---@class FPoseSearchRoledSkeleton
---@field Skeleton USkeleton
---@field MirrorDataTable UMirrorDataTable
---@field Role FName
---@field BoneReferences TArray<FBoneReference>
---@field BoneIndicesWithParents TArray<uint16>
local FPoseSearchRoledSkeleton = {}



---@class FPoseSearchTrajectoryData
---@field RotateTowardsMovementSpeed float
---@field MaxControllerYawRate float
---@field BendVelocityTowardsAcceleration float
---@field bUseSpeedRemappingCurve boolean
---@field SpeedRemappingCurve FRuntimeFloatCurve
---@field bUseAccelerationRemappingCurve boolean
---@field AccelerationRemappingCurve FRuntimeFloatCurve
local FPoseSearchTrajectoryData = {}



---@class FPoseSearchTrajectorySample
---@field Offset float
---@field Flags int32
local FPoseSearchTrajectorySample = {}



---@class FPoseSearchTrajectory_WorldCollisionResults
---@field TimeToLand float
---@field LandSpeed float
local FPoseSearchTrajectory_WorldCollisionResults = {}



---@class UAnimNotifyState_PoseSearchBase : UAnimNotifyState
local UAnimNotifyState_PoseSearchBase = {}


---@class UAnimNotifyState_PoseSearchBlockTransition : UAnimNotifyState_PoseSearchBase
local UAnimNotifyState_PoseSearchBlockTransition = {}


---@class UAnimNotifyState_PoseSearchBranchIn : UAnimNotifyState_PoseSearchBase
---@field Database UPoseSearchDatabase
local UAnimNotifyState_PoseSearchBranchIn = {}



---@class UAnimNotifyState_PoseSearchExcludeFromDatabase : UAnimNotifyState_PoseSearchBase
local UAnimNotifyState_PoseSearchExcludeFromDatabase = {}


---@class UAnimNotifyState_PoseSearchModifyCost : UAnimNotifyState_PoseSearchBase
---@field CostAddend float
local UAnimNotifyState_PoseSearchModifyCost = {}



---@class UAnimNotifyState_PoseSearchOverrideContinuingPoseCostBias : UAnimNotifyState_PoseSearchBase
---@field CostAddend float
local UAnimNotifyState_PoseSearchOverrideContinuingPoseCostBias = {}



---@class UAnimNotifyState_PoseSearchSamplingAttribute : UAnimNotifyState_PoseSearchSamplingEvent
local UAnimNotifyState_PoseSearchSamplingAttribute = {}


---@class UAnimNotifyState_PoseSearchSamplingEvent : UAnimNotifyState_PoseSearchBase
local UAnimNotifyState_PoseSearchSamplingEvent = {}


---@class UMotionMatchingAnimNodeLibrary : UBlueprintFunctionLibrary
local UMotionMatchingAnimNodeLibrary = {}

---@param MotionMatchingNode FMotionMatchingAnimNodeReference
---@param InterruptMode EPoseSearchInterruptMode
function UMotionMatchingAnimNodeLibrary:SetInterruptMode(MotionMatchingNode, InterruptMode) end
---@param MotionMatchingNode FMotionMatchingAnimNodeReference
---@param Database UPoseSearchDatabase
---@param InterruptMode EPoseSearchInterruptMode
function UMotionMatchingAnimNodeLibrary:SetDatabaseToSearch(MotionMatchingNode, Database, InterruptMode) end
---@param MotionMatchingNode FMotionMatchingAnimNodeReference
---@param Databases TArray<UPoseSearchDatabase>
---@param InterruptMode EPoseSearchInterruptMode
function UMotionMatchingAnimNodeLibrary:SetDatabasesToSearch(MotionMatchingNode, Databases, InterruptMode) end
---@param MotionMatchingNode FMotionMatchingAnimNodeReference
---@param InterruptMode EPoseSearchInterruptMode
function UMotionMatchingAnimNodeLibrary:ResetDatabasesToSearch(MotionMatchingNode, InterruptMode) end
---@param MotionMatchingNode FMotionMatchingAnimNodeReference
---@param Result FPoseSearchBlueprintResult
---@param bIsResultValid boolean
function UMotionMatchingAnimNodeLibrary:GetMotionMatchingSearchResult(MotionMatchingNode, Result, bIsResultValid) end
---@param Node FAnimNodeReference
---@param MotionMatchingNode FMotionMatchingAnimNodeReference
---@param Result boolean
function UMotionMatchingAnimNodeLibrary:ConvertToMotionMatchingNodePure(Node, MotionMatchingNode, Result) end
---@param Node FAnimNodeReference
---@param Result EAnimNodeReferenceConversionResult
---@return FMotionMatchingAnimNodeReference
function UMotionMatchingAnimNodeLibrary:ConvertToMotionMatchingNode(Node, Result) end


---@class UPoseSearchDatabase : UDataAsset
---@field Schema UPoseSearchSchema
---@field ContinuingPoseCostBias float
---@field BaseCostBias float
---@field LoopingCostBias float
---@field AnimationAssets TArray<FInstancedStruct>
---@field Tags TArray<FName>
---@field PoseSearchMode EPoseSearchMode
---@field KDTreeQueryNumNeighbors int32
---@field KDTreeQueryNumNeighborsWithDuplicates int32
local UPoseSearchDatabase = {}



---@class UPoseSearchFeatureChannel : UObject
---@field ChannelDataOffset int32
---@field ChannelCardinality int32
local UPoseSearchFeatureChannel = {}



---@class UPoseSearchFeatureChannel_FilterCrashingLegs : UPoseSearchFeatureChannel
---@field LeftThigh FBoneReference
---@field RightThigh FBoneReference
---@field LeftFoot FBoneReference
---@field RightFoot FBoneReference
---@field SampleRole FName
---@field Weight float
---@field LeftThighIdx int8
---@field RightThighIdx int8
---@field LeftFootIdx int8
---@field RightFootIdx int8
---@field InputQueryPose EInputQueryPose
---@field AllowedTolerance float
local UPoseSearchFeatureChannel_FilterCrashingLegs = {}



---@class UPoseSearchFeatureChannel_Group : UPoseSearchFeatureChannel_GroupBase
---@field SubChannels TArray<UPoseSearchFeatureChannel>
local UPoseSearchFeatureChannel_Group = {}



---@class UPoseSearchFeatureChannel_GroupBase : UPoseSearchFeatureChannel
---@field SampleRole FName
local UPoseSearchFeatureChannel_GroupBase = {}



---@class UPoseSearchFeatureChannel_Heading : UPoseSearchFeatureChannel
---@field bone FBoneReference
---@field SampleRole FName
---@field OriginBone FBoneReference
---@field OriginRole FName
---@field SamplingAttributeId int32
---@field SampleTimeOffset float
---@field OriginTimeOffset float
---@field HeadingAxis EHeadingAxis
---@field SchemaBoneIdx int8
---@field SchemaOriginBoneIdx int8
---@field InputQueryPose EInputQueryPose
---@field ComponentStripping EComponentStrippingVector
---@field PermutationTimeType EPermutationTimeType
local UPoseSearchFeatureChannel_Heading = {}

---@param AnimInstance UAnimInstance
---@return FQuat
function UPoseSearchFeatureChannel_Heading:BP_GetWorldRotation(AnimInstance) end


---@class UPoseSearchFeatureChannel_Padding : UPoseSearchFeatureChannel
---@field PaddingSize int32
local UPoseSearchFeatureChannel_Padding = {}



---@class UPoseSearchFeatureChannel_PermutationTime : UPoseSearchFeatureChannel
local UPoseSearchFeatureChannel_PermutationTime = {}


---@class UPoseSearchFeatureChannel_Phase : UPoseSearchFeatureChannel
---@field bone FBoneReference
---@field SampleRole FName
---@field SchemaBoneIdx int8
---@field InputQueryPose EInputQueryPose
local UPoseSearchFeatureChannel_Phase = {}



---@class UPoseSearchFeatureChannel_Pose : UPoseSearchFeatureChannel_GroupBase
---@field SampledBones TArray<FPoseSearchBone>
---@field SchemaBoneIdx TArray<int8>
---@field InputQueryPose EInputQueryPose
---@field bUseCharacterSpaceVelocities boolean
---@field SubChannels TArray<UPoseSearchFeatureChannel>
local UPoseSearchFeatureChannel_Pose = {}



---@class UPoseSearchFeatureChannel_Position : UPoseSearchFeatureChannel
---@field bone FBoneReference
---@field SampleRole FName
---@field OriginBone FBoneReference
---@field OriginRole FName
---@field SamplingAttributeId int32
---@field SampleTimeOffset float
---@field OriginTimeOffset float
---@field SchemaBoneIdx int8
---@field SchemaOriginBoneIdx int8
---@field InputQueryPose EInputQueryPose
---@field ComponentStripping EComponentStrippingVector
---@field PermutationTimeType EPermutationTimeType
local UPoseSearchFeatureChannel_Position = {}

---@param AnimInstance UAnimInstance
---@return FVector
function UPoseSearchFeatureChannel_Position:BP_GetWorldPosition(AnimInstance) end


---@class UPoseSearchFeatureChannel_SamplingTime : UPoseSearchFeatureChannel
---@field Weight float
---@field TimeToMatch float
local UPoseSearchFeatureChannel_SamplingTime = {}



---@class UPoseSearchFeatureChannel_TimeToEvent : UPoseSearchFeatureChannel
---@field Weight float
---@field SamplingAttributeId int32
local UPoseSearchFeatureChannel_TimeToEvent = {}

---@param AnimInstance UAnimInstance
---@return float
function UPoseSearchFeatureChannel_TimeToEvent:BP_GetTimeToEvent(AnimInstance) end


---@class UPoseSearchFeatureChannel_Trajectory : UPoseSearchFeatureChannel_GroupBase
---@field Samples TArray<FPoseSearchTrajectorySample>
---@field SubChannels TArray<UPoseSearchFeatureChannel>
local UPoseSearchFeatureChannel_Trajectory = {}



---@class UPoseSearchFeatureChannel_Velocity : UPoseSearchFeatureChannel
---@field bone FBoneReference
---@field SampleRole FName
---@field OriginBone FBoneReference
---@field OriginRole FName
---@field SamplingAttributeId int32
---@field SampleTimeOffset float
---@field OriginTimeOffset float
---@field SchemaBoneIdx int8
---@field SchemaOriginBoneIdx int8
---@field InputQueryPose EInputQueryPose
---@field bUseCharacterSpaceVelocities boolean
---@field bNormalize boolean
---@field ComponentStripping EComponentStrippingVector
---@field PermutationTimeType EPermutationTimeType
local UPoseSearchFeatureChannel_Velocity = {}

---@param AnimInstance UAnimInstance
---@return FVector
function UPoseSearchFeatureChannel_Velocity:BP_GetWorldVelocity(AnimInstance) end


---@class UPoseSearchHistoryCollectorAnimNodeLibrary : UBlueprintFunctionLibrary
local UPoseSearchHistoryCollectorAnimNodeLibrary = {}

---@param PoseSearchHistoryCollectorNode FPoseSearchHistoryCollectorAnimNodeReference
---@param Trajectory FPoseSearchQueryTrajectory
function UPoseSearchHistoryCollectorAnimNodeLibrary:SetPoseHistoryNodeTrajectory(PoseSearchHistoryCollectorNode, Trajectory) end
---@param PoseSearchHistoryCollectorNode FPoseSearchHistoryCollectorAnimNodeReference
---@param Trajectory FPoseSearchQueryTrajectory
function UPoseSearchHistoryCollectorAnimNodeLibrary:GetPoseHistoryNodeTrajectory(PoseSearchHistoryCollectorNode, Trajectory) end
---@param Node FAnimNodeReference
---@param PoseSearchHistoryCollectorNode FPoseSearchHistoryCollectorAnimNodeReference
---@param Result boolean
function UPoseSearchHistoryCollectorAnimNodeLibrary:ConvertToPoseHistoryNodePure(Node, PoseSearchHistoryCollectorNode, Result) end
---@param Node FAnimNodeReference
---@param Result EAnimNodeReferenceConversionResult
---@return FPoseSearchHistoryCollectorAnimNodeReference
function UPoseSearchHistoryCollectorAnimNodeLibrary:ConvertToPoseHistoryNode(Node, Result) end


---@class UPoseSearchLibrary : UBlueprintFunctionLibrary
local UPoseSearchLibrary = {}

---@param AnimInstances TArray<ACharacter>
---@param Roles TArray<FName>
---@param AssetsToSearch TArray<UObject>
---@param PoseHistoryName FName
---@param Result FPoseSearchBlueprintResult
---@param DebugSessionUniqueIdentifier int32
function UPoseSearchLibrary:MotionMatchMulti(AnimInstances, Roles, AssetsToSearch, PoseHistoryName, Result, DebugSessionUniqueIdentifier) end
---@param AnimInstance UAnimInstance
---@param AssetsToSearch TArray<UObject>
---@param PoseHistoryName FName
---@param Future FPoseSearchFutureProperties
---@param Result FPoseSearchBlueprintResult
---@param DebugSessionUniqueIdentifier int32
function UPoseSearchLibrary:MotionMatch(AnimInstance, AssetsToSearch, PoseHistoryName, Future, Result, DebugSessionUniqueIdentifier) end


---@class UPoseSearchMultiSequence : UDataAsset
---@field Items TArray<FPoseSearchMultiSequenceItem>
local UPoseSearchMultiSequence = {}

---@param Role FName
---@return UAnimSequenceBase
function UPoseSearchMultiSequence:GetSequence(Role) end


---@class UPoseSearchNormalizationSet : UDataAsset
---@field Databases TArray<UPoseSearchDatabase>
local UPoseSearchNormalizationSet = {}



---@class UPoseSearchSchema : UDataAsset
---@field Skeleton USkeleton
---@field SampleRate int32
---@field Skeletons TArray<FPoseSearchRoledSkeleton>
---@field Channels TArray<UPoseSearchFeatureChannel>
---@field FinalizedChannels TArray<UPoseSearchFeatureChannel>
---@field MirrorDataTable UMirrorDataTable
---@field SchemaCardinality int32
---@field bAddDataPadding boolean
---@field bInjectAdditionalDebugChannels boolean
local UPoseSearchSchema = {}



---@class UPoseSearchTrajectoryLibrary : UBlueprintFunctionLibrary
local UPoseSearchTrajectoryLibrary = {}

---@param InAnimInstance UAnimInstance
---@param InTrajectoryData FPoseSearchTrajectoryData
---@param InDeltaTime float
---@param InOutTrajectory FPoseSearchQueryTrajectory
---@param InOutDesiredControllerYawLastUpdate float
---@param OutTrajectory FPoseSearchQueryTrajectory
---@param InHistorySamplingInterval float
---@param InTrajectoryHistoryCount int32
---@param InPredictionSamplingInterval float
---@param InTrajectoryPredictionCount int32
function UPoseSearchTrajectoryLibrary:PoseSearchGenerateTrajectory(InAnimInstance, InTrajectoryData, InDeltaTime, InOutTrajectory, InOutDesiredControllerYawLastUpdate, OutTrajectory, InHistorySamplingInterval, InTrajectoryHistoryCount, InPredictionSamplingInterval, InTrajectoryPredictionCount) end
---@param WorldContextObject UObject
---@param AnimInstance UAnimInstance
---@param InTrajectory FPoseSearchQueryTrajectory
---@param bApplyGravity boolean
---@param FloorCollisionsOffset float
---@param OutTrajectory FPoseSearchQueryTrajectory
---@param CollisionResult FPoseSearchTrajectory_WorldCollisionResults
---@param TraceChannel ETraceTypeQuery
---@param bTraceComplex boolean
---@param ActorsToIgnore TArray<AActor>
---@param DrawDebugType EDrawDebugTrace::Type
---@param bIgnoreSelf boolean
---@param MaxObstacleHeight float
---@param TraceColor FLinearColor
---@param TraceHitColor FLinearColor
---@param DrawTime float
function UPoseSearchTrajectoryLibrary:HandleTrajectoryWorldCollisions(WorldContextObject, AnimInstance, InTrajectory, bApplyGravity, FloorCollisionsOffset, OutTrajectory, CollisionResult, TraceChannel, bTraceComplex, ActorsToIgnore, DrawDebugType, bIgnoreSelf, MaxObstacleHeight, TraceColor, TraceHitColor, DrawTime) end
---@param InTrajectory FPoseSearchQueryTrajectory
---@param Time float
---@param OutTrajectorySample FPoseSearchQueryTrajectorySample
---@param bExtrapolate boolean
function UPoseSearchTrajectoryLibrary:GetTrajectorySampleAtTime(InTrajectory, Time, OutTrajectorySample, bExtrapolate) end


