---@meta

---@class FControlNetStruct
---@field Enabled boolean
---@field Module FString
---@field Model FString
---@field Weight float
---@field Image FString
---@field control_mode EControlMode
---@field resize_mode int32
---@field low_vram boolean
---@field processor_res int32
---@field threshold_a int32
---@field threshold_b int32
---@field guidance_start float
---@field guidance_end float
---@field pixel_perfect boolean
local FControlNetStruct = {}



---@class FControlNetUIStruct
---@field Enabled boolean
---@field Module FString
---@field Model FString
---@field Weight float
---@field Image FString
---@field control_mode EControlMode
local FControlNetUIStruct = {}



---@class FI2IStruct
---@field prompt FString
---@field negative_prompt FString
---@field Seed int64
---@field cfg_scale int32
---@field Tiling boolean
---@field sampler_name FString
---@field init_images TArray<FString>
---@field resize_mode EResizeMode
---@field mask_blur int32
---@field inpaint_full_res EInpaintFullRes
---@field inpaint_full_res_padding int32
---@field denoising_strength float
---@field Mask FString
---@field inpainting_fill int32
---@field batch_size int32
---@field n_iter int32
---@field Step int32
---@field Width int32
---@field Height int32
---@field restore_faces boolean
local FI2IStruct = {}



---@class FT2IStruct
---@field prompt FString
---@field negative_prompt FString
---@field Seed int64
---@field cfg_scale int32
---@field Tiling boolean
---@field sampler_name FString
---@field enable_hr boolean
---@field denoising_strength float
---@field batch_size int32
---@field n_iter int32
---@field Step int32
---@field Width int32
---@field Height int32
---@field restore_faces boolean
local FT2IStruct = {}



---@class FUIStruct
---@field checkpoint FString
---@field prompt FString
---@field negative_prompt FString
---@field Seed int64
---@field cfg_scale int32
---@field Tiling boolean
---@field sampler_name FString
---@field init_images FString
---@field resize_mode EResizeMode
---@field mask_blur int32
---@field inpaint_full_res EInpaintFullRes
---@field inpaint_full_res_padding int32
---@field denoising_strength float
---@field Mask FString
---@field controlnet FControlNetUIStruct
---@field bImageReceived boolean
---@field generation_data FString
---@field generated_seed int64
local FUIStruct = {}



---@class UStableDiffusion : UObject
local UStableDiffusion = {}

---@param SD UStableDiffusion
---@param Result boolean
function UStableDiffusion:OnTextureReceivedDelegate__DelegateSignature(SD, Result) end
---@param InSD UStableDiffusion
---@param bResult boolean
function UStableDiffusion:OnTextureReceived(InSD, bResult) end


