---@meta

---@class FVPBookmarkCreationContext
---@field ConcertCreator FString
---@field CategoryName FName
---@field DisplayName FString
local FVPBookmarkCreationContext = {}



---@class FVPBookmarkJumpToSettings : FBookmarkBaseJumpToSettings
local FVPBookmarkJumpToSettings = {}


---@class FVPBookmarkViewportData
---@field JumpToOffsetLocation FVector
---@field LookRotation FRotator
---@field OrthoZoom float
---@field bFlattenRotation boolean
local FVPBookmarkViewportData = {}



---@class IVPBookmarkProvider : IInterface
local IVPBookmarkProvider = {}

function IVPBookmarkProvider:UpdateBookmarkSplineMeshIndicator() end
---@param BookMark UVPBookmark
function IVPBookmarkProvider:OnBookmarkChanged(BookMark) end
---@param BookMark UVPBookmark
---@param bActivate boolean
function IVPBookmarkProvider:OnBookmarkActivation(BookMark, bActivate) end
function IVPBookmarkProvider:HideBookmarkSplineMeshIndicator() end
function IVPBookmarkProvider:GenerateBookmarkName() end


---@class UVPBookmark : UBookmarkBase
---@field bIsActive boolean
---@field OwnedActor TLazyObjectPtr<AActor>
---@field CreationContext FVPBookmarkCreationContext
---@field CachedViewportData FVPBookmarkViewportData
local UVPBookmark = {}

---@return boolean
function UVPBookmark:IsActive() end
---@return FText
function UVPBookmark:GetDisplayName() end
---@return int32
function UVPBookmark:GetBookmarkIndex() end
---@return AActor
function UVPBookmark:GetAssociatedBookmarkActor() end


---@class UVPBookmarkBlueprintLibrary : UBlueprintFunctionLibrary
local UVPBookmarkBlueprintLibrary = {}

---@param WorldContextObject UObject
---@param OutActors TArray<AActor>
function UVPBookmarkBlueprintLibrary:GetAllVPBookmarkActors(WorldContextObject, OutActors) end
---@param WorldContextObject UObject
---@param OutBookmarks TArray<UVPBookmark>
function UVPBookmarkBlueprintLibrary:GetAllVPBookmark(WorldContextObject, OutBookmarks) end
---@param Actor AActor
---@return UVPBookmark
function UVPBookmarkBlueprintLibrary:FindVPBookmark(Actor) end
---@param BookMark AActor
---@param FormatString FString
---@param GeneratedNumber FString
---@param GeneratedLetter FString
---@return boolean
function UVPBookmarkBlueprintLibrary:CreateVPBookmarkName(BookMark, FormatString, GeneratedNumber, GeneratedLetter) end


