---@meta

---@class AFullScreenUserWidgetActor : AInfo
---@field ScreenUserWidget UVPFullScreenUserWidget
local AFullScreenUserWidgetActor = {}

---@return UUserWidget
function AFullScreenUserWidgetActor:GetUserWidget() end


---@class AVPBookmarkActor : AVPViewportTickableActorBase
---@field BookmarkMeshComponent UStaticMeshComponent
---@field NameTextRenderComponent UTextRenderComponent
---@field SplineMeshComponent USplineMeshComponent
---@field CameraComponent UCineCameraComponent
---@field BookmarkColor FLinearColor
---@field BookmarkObject UVPBookmark
---@field IsHome boolean
---@field SnapshotTexture UTexture2D
---@field DynamicMaterial UMaterialInstanceDynamic
---@field BookmarkMaterial UMaterialInterface
---@field BookmarkStaticMesh UStaticMesh
---@field TextMaterial UMaterial
---@field SplineStaticMesh UStaticMesh
---@field SplineMaterial UMaterialInterface
---@field SplineMaterialInstance UMaterialInterface
---@field LabelMaterialInstance UMaterialInterface
local AVPBookmarkActor = {}

function AVPBookmarkActor:UpdateBookmarkSplineMeshIndicator_Implementation() end
---@param Color FLinearColor
function AVPBookmarkActor:UpdateBookmarkColor(Color) end
---@param BookMark UVPBookmark
function AVPBookmarkActor:OnBookmarkChanged_Implementation(BookMark) end
---@param BookMark UVPBookmark
---@param bActivate boolean
function AVPBookmarkActor:OnBookmarkActivation_Implementation(BookMark, bActivate) end
function AVPBookmarkActor:OnActorSelectedForTransform_Implementation() end
function AVPBookmarkActor:OnActorDroppedFromTransform_Implementation() end
function AVPBookmarkActor:OnActorDroppedFromCarry_Implementation() end
function AVPBookmarkActor:HideBookmarkSplineMeshIndicator_Implementation() end
function AVPBookmarkActor:GenerateBookmarkName_Implementation() end


---@class AVPGameMode : AGameMode
---@field RootActor AVPRootActor
local AVPGameMode = {}

---@return AVPRootActor
function AVPGameMode:GetRootActor() end


---@class AVPPassthroughPostProcessVolume : APostProcessVolume
local AVPPassthroughPostProcessVolume = {}


---@class AVPRootActor : AActor
---@field RealWorldSceneRepresentation UMeshComponent
---@field CinematicCamera ACineCameraActor
---@field bAreComponentsVisible boolean
local AVPRootActor = {}

---@return ACineCameraActor
function AVPRootActor:GetCineCameraActor() end


---@class AVPViewportTickableActorBase : AActor
---@field ViewportTickType EVPViewportTickableFlags
local AVPViewportTickableActorBase = {}

---@param DeltaSeconds float
function AVPViewportTickableActorBase:EditorTick(DeltaSeconds) end
---@param bSetLockLocation boolean
function AVPViewportTickableActorBase:EditorLockLocation(bSetLockLocation) end
function AVPViewportTickableActorBase:EditorDestroyed() end


---@class FVPCameraRigSpawnParams
---@field bUseWorldSpace boolean
---@field bUseFirstPointAsSpawnLocation boolean
---@field LinearApproximationMode EVPCameraRigSpawnLinearApproximationMode
---@field LinearApproximationParam float
local FVPCameraRigSpawnParams = {}



---@class FVPFullScreenUserWidget_PostProcess : FVPFullScreenUserWidget_PostProcessBase
---@field ComposureLayerTargets TArray<ACompositingElement>
---@field PostProcessComponent UPostProcessComponent
---@field PostProcessMaterialInstance UMaterialInstanceDynamic
local FVPFullScreenUserWidget_PostProcess = {}



---@class FVPFullScreenUserWidget_PostProcessBase
---@field PostProcessMaterial UMaterialInterface
---@field PostProcessTintColorAndOpacity FLinearColor
---@field PostProcessOpacityFromTexture float
---@field bUseWidgetDrawSize boolean
---@field WidgetDrawSize FIntPoint
---@field bWindowFocusable boolean
---@field WindowVisibility EWindowVisibility
---@field bReceiveHardwareInput boolean
---@field RenderTargetBackgroundColor FLinearColor
---@field RenderTargetBlendMode EWidgetBlendMode
---@field WidgetRenderTarget UTextureRenderTarget2D
local FVPFullScreenUserWidget_PostProcessBase = {}



---@class FVPFullScreenUserWidget_PostProcessWithSVE : FVPFullScreenUserWidget_PostProcessBase
local FVPFullScreenUserWidget_PostProcessWithSVE = {}


---@class FVPFullScreenUserWidget_Viewport
local FVPFullScreenUserWidget_Viewport = {}


---@class IVPContextMenuProvider : IInterface
local IVPContextMenuProvider = {}

function IVPContextMenuProvider:OnCreateContextMenu() end


---@class IVPInteraction : IInterface
local IVPInteraction = {}

function IVPInteraction:OnActorSelectedForTransform() end
function IVPInteraction:OnActorDroppedFromTransform() end
function IVPInteraction:OnActorDroppedFromCarry() end


---@class UVPAssetThumbnailWrapperWidget : UWidget
---@field FallbackBrush FSlateBrush
local UVPAssetThumbnailWrapperWidget = {}

---@param NewFallbackBrush FSlateBrush
function UVPAssetThumbnailWrapperWidget:SetFallbackBrush(NewFallbackBrush) end
---@param NewResolution FIntPoint
function UVPAssetThumbnailWrapperWidget:SetEditorThumbnailResolution(NewResolution) end
---@param Mode EAssetThumbnailDisplayMode
function UVPAssetThumbnailWrapperWidget:SetDisplayMode(Mode) end
---@param Object UObject
function UVPAssetThumbnailWrapperWidget:SetAssetByObject(Object) end
---@param AssetData FAssetData
function UVPAssetThumbnailWrapperWidget:SetAsset(AssetData) end
---@return FSlateBrush
function UVPAssetThumbnailWrapperWidget:GetFallbackBrush() end
---@return FIntPoint
function UVPAssetThumbnailWrapperWidget:GetEditorThumbnailResolution() end
---@return UObject
function UVPAssetThumbnailWrapperWidget:GetEditorAssetWidget() end


---@class UVPBlueprintLibrary : UBlueprintFunctionLibrary
local UVPBlueprintLibrary = {}

---@param SplineMesh USplineMeshComponent
function UVPBlueprintLibrary:VPBookmarkSplineMeshIndicatorSetStartAndEnd(SplineMesh) end
---@param SplineMesh USplineMeshComponent
function UVPBlueprintLibrary:VPBookmarkSplineMeshIndicatorDisable(SplineMesh) end
---@param ContextObject UObject
---@param ActorClass TSubclassOf<AVPViewportTickableActorBase>
---@param Location FVector
---@param Rotation FRotator
---@return AVPViewportTickableActorBase
function UVPBlueprintLibrary:SpawnVPTickableActor(ContextObject, ActorClass, Location, Rotation) end
---@param ActorClass TSubclassOf<AActor>
---@param CreationContext FVPBookmarkCreationContext
---@param Offset FVector
---@param bFlattenRotation boolean
---@return AActor
function UVPBlueprintLibrary:SpawnBookmarkAtCurrentLevelEditorPosition(ActorClass, CreationContext, Offset, bFlattenRotation) end
---@param Speed float
function UVPBlueprintLibrary:SetGrabSpeed(Speed) end
function UVPBlueprintLibrary:Refresh3DEditorViewport() end
---@param BookMark UVPBookmark
---@return boolean
function UVPBlueprintLibrary:JumpToBookmarkInLevelEditor(BookMark) end
---@return boolean
function UVPBlueprintLibrary:IsVREditorModeActive() end
---@return FVector
function UVPBlueprintLibrary:GetVREditorLaserHoverLocation() end
---@return FGameplayTagContainer
function UVPBlueprintLibrary:GetVirtualProductionRole() end
---@return FVector
function UVPBlueprintLibrary:GetLeftInteractorLocation() end
---@return UWorld
function UVPBlueprintLibrary:GetEditorWorld() end
---@return FTransform
function UVPBlueprintLibrary:GetEditorVRRoomTransform() end
---@return FTransform
function UVPBlueprintLibrary:GetEditorVRHeadTransform() end
---@return FTransform
function UVPBlueprintLibrary:GetEditorViewportTransform() end
---@return boolean
function UVPBlueprintLibrary:EditorUndo() end
---@return boolean
function UVPBlueprintLibrary:EditorRedo() end
---@return boolean
function UVPBlueprintLibrary:EditorDuplicate() end
---@return boolean
function UVPBlueprintLibrary:EditorDeleteSelectedObjects() end


---@class UVPBookmarkSettings : UObject
---@field BookmarkMeshPath FSoftObjectPath
---@field BookmarkMaterialPath FSoftObjectPath
---@field BookmarkSplineMeshPath FSoftObjectPath
---@field BookmarkSplineMeshMaterialPath FSoftObjectPath
---@field BookmarkLabelMaterialPath FSoftObjectPath
local UVPBookmarkSettings = {}



---@class UVPCameraBlueprintLibrary : UBlueprintFunctionLibrary
local UVPCameraBlueprintLibrary = {}

---@param WorldContextObject UObject
---@param Points TArray<FTransform>
---@param InterpType ESplinePointType::Type
---@return ACameraRig_Rail
function UVPCameraBlueprintLibrary:SpawnDollyTrackFromPointsSmooth(WorldContextObject, Points, InterpType) end
---@param WorldContextObject UObject
---@param Points TArray<FTransform>
---@param InterpType ESplinePointType::Type
---@return ACameraRig_Rail
function UVPCameraBlueprintLibrary:SpawnDollyTrackFromPoints(WorldContextObject, Points, InterpType) end
---@param WorldContextObject UObject
---@param RigTransform FTransform
---@param Params FVPCameraRigSpawnParams
---@return ACameraRig_Rail
function UVPCameraBlueprintLibrary:SpawnCameraRigFromSelectedActors(WorldContextObject, RigTransform, Params) end
---@param WorldContextObject UObject
---@param RigTransform FTransform
---@param Points TArray<FVector>
---@param Params FVPCameraRigSpawnParams
---@return ACameraRig_Rail
function UVPCameraBlueprintLibrary:SpawnCameraRigFromPoints(WorldContextObject, RigTransform, Points, Params) end
---@param WorldContextObject UObject
---@param RigTransform FTransform
---@param Actors TArray<AActor>
---@param Params FVPCameraRigSpawnParams
---@return ACameraRig_Rail
function UVPCameraBlueprintLibrary:SpawnCameraRigFromActors(WorldContextObject, RigTransform, Actors, Params) end


---@class UVPFullScreenUserWidget : UObject
---@field WidgetClass TSubclassOf<UUserWidget>
---@field EditorDisplayType EVPWidgetDisplayType
---@field GameDisplayType EVPWidgetDisplayType
---@field PIEDisplayType EVPWidgetDisplayType
---@field ViewportDisplayType FVPFullScreenUserWidget_Viewport
---@field PostProcessDisplayTypeWithBlendMaterial FVPFullScreenUserWidget_PostProcess
---@field PostProcessWithSceneViewExtensions FVPFullScreenUserWidget_PostProcessWithSVE
---@field Widget UUserWidget
---@field World TWeakObjectPtr<UWorld>
---@field CurrentDisplayType EVPWidgetDisplayType
local UVPFullScreenUserWidget = {}



---@class UVPRenderingBlueprintLibrary : UBlueprintFunctionLibrary
local UVPRenderingBlueprintLibrary = {}

---@param OutIsActiveFunction FSceneViewExtensionIsActiveFunctor
---@param bPIE boolean
---@param bSIE boolean
---@param bEditorActive boolean
---@param bGamePrimary boolean
function UVPRenderingBlueprintLibrary:GenerateSceneViewExtensionIsActiveFunctorForViewportType(OutIsActiveFunction, bPIE, bSIE, bEditorActive, bGamePrimary) end


---@class UVPTimecodeCustomTimeStep : UFixedFrameRateCustomTimeStep
---@field bErrorIfFrameAreNotConsecutive boolean
---@field bErrorIfTimecodeProviderChanged boolean
---@field MaxDeltaTime float
local UVPTimecodeCustomTimeStep = {}



---@class UVPWorldAssetUserData : UAssetUserData
---@field LastSelectedRootActor TLazyObjectPtr<AVPRootActor>
local UVPWorldAssetUserData = {}



