-- Coding by Yoco or Yocodream

local _C = nil
local _cS, _cR = pcall(require, "config")

-- Contrôle pour éviter répétitions
local _timeScaleAlreadySet = false

-- Fonction pour obtenir la largeur de la console
local function getConsoleWidth()
    local handle = io.popen("tput cols 2>/dev/null")
    local result = handle:read("*a")
    handle:close()
    return tonumber(result) or 80
end

-- Génère un séparateur sur toute la largeur
local function generateSeparator(char)
    local width = getConsoleWidth()
    char = char or "="
    return string.rep(char, width)
end

-- Fonction pour couper le texte automatiquement
local function wrapText(text, width)
    local lines = {}
    local currentLine = ""

    for word in text:gmatch("%S+") do
        if #currentLine + #word + 1 > width then
            table.insert(lines, currentLine)
            currentLine = word
        else
            if currentLine == "" then
                currentLine = word
            else
                currentLine = currentLine .. " " .. word
            end
        end
    end

    if currentLine ~= "" then
        table.insert(lines, currentLine)
    end

    return lines
end

-- Format d'heure
local function now()
    return os.date("%H:%M:%S")
end

-- Fonction pour colorer certains mots
local function colorizeMessage(text)
    text = text:gsub("([Ss]ucc[eè]s?)", "\27[32m%1\27[0m")
    text = text:gsub("([Ee]rreur[s]?|[Ee]chec[s]?|[Ff]ail[ed]?)", "\27[31m%1\27[0m")
    return text
end

-- Logs INFORMATIONS
local function logInfo(msg)
    local width = getConsoleWidth()
    local wrappedLines = wrapText(msg, width)
    for _, line in ipairs(wrappedLines) do
        local coloredLine = colorizeMessage(line)
        print(string.format("\27[32m[Lua] [%s] INFORMATIONS: %s\27[0m", now(), coloredLine) .. "\n")
    end
end

-- Logs avertissement
local function logWarning(msg)
    local width = getConsoleWidth()
    local wrappedLines = wrapText(msg, width)
    for _, line in ipairs(wrappedLines) do
        print(string.format("\27[33m[Lua] [%s] ATTENTION: %s\27[0m", now(), line) .. "\n")
    end
end

-- Logs erreur
local function logError(msg)
    local width = getConsoleWidth()
    local wrappedLines = wrapText(msg, width)
    for _, line in ipairs(wrappedLines) do
        print(string.format("\27[31m[Lua] [%s] ERREUR: %s\27[0m", now(), line) .. "\n")
    end
end

-- Fonction pour centrer le texte
local function centerText(text)
    local width = getConsoleWidth()
    local padding = math.floor((width - #text) / 2)
    return string.rep(" ", padding) .. text
end

-- Affichage du header
local function printHeader()
    print("\27[33m[Lua] " .. centerText("===============================================================") .. "\27[0m\n")
    print("\27[33m[Lua] " .. centerText("[ MOD Yoco_Only_x500_Speed_Time_v1 | Dev by Yocodream ]") .. "\27[0m\n")
    print("\27[33m[Lua] " .. centerText("===============================================================") .. "\27[0m\n")
    print("\n")
    logInfo("Fichier config.lua charge avec succes.")
    print("\n")
end

-- Application de la coloration sur les messages statiques
if _cS then
    _C = _cR
    print("\n")
else
    print("\27[31m[Lua] [" .. now() .. "] INFORMATIONS: Echec du chargement de config.lua: " .. tostring(_cR) .. "\27[0m\n")
    print("\27[33m[Lua] [" .. now() .. "] INFORMATIONS: Utilisation des parametres internes par defaut.\27[0m\n")
    _C = { 
        EnableDebugLogging = false, 
        ModifyTimeConfig = true, 
        TargetTimeScaleFast = 20.0, 
        TargetTimeScaleVeryFast = 50.0, 
        TargetMaxTimeScale = 500.0 
    }
end

-- Fonction principale pour modifier les parametres temporels
local function modifyTimeScale()
    if _timeScaleAlreadySet then
        return
    end

    local _lCS, _lC = pcall(function()
        return StaticFindObject("/Game/Data/DataAsset/DA_GameConfig.DA_GameConfig")
    end)

    if _lCS and _lC and _lC:IsValid() and _lC:IsA("/Script/BlueUtils.B1GameConfigDataAsset") then
        logInfo("Chargement de DA_GameConfig avec succes.")
        local _gTS, _tS = pcall(function()
            return _lC.Time
        end)

        if _gTS and _tS then
            local _nFS = _C.TargetTimeScaleFast
            local _nVFS = _C.TargetTimeScaleVeryFast
            local _nMS = _C.TargetMaxTimeScale

            local _setFS = pcall(function() _tS.TimeScaleFast = _nFS end)
            local _setVFS = pcall(function() _tS.TimeScaleVeryFast = _nVFS end)
            local _setMS = pcall(function() _tS.MaxTimeScale = _nMS end)

            if _setFS and _setVFS and _setMS then
                logInfo(string.format("Defini TimeScaleFast a: %s (Succes)", tostring(_nFS)))
                logInfo(string.format("Defini TimeScaleVeryFast a: %s (Succes)", tostring(_nVFS)))
                logInfo(string.format("Defini MaxTimeScale a: %s (Succes)", tostring(_nMS)))
                _timeScaleAlreadySet = true
            else
                logWarning("Un ou plusieurs parametres temporels n'ont pas pu etre modifies.")
            end
        else
            logWarning("Echec de l'acces a la structure Time dans DA_GameConfig.")
        end
    else
        logWarning("Echec du chargement de DA_GameConfig.")
    end
end

-- Monitoring des objets dynamiques
local function setupMonitoring()
    if NotifyOnNewObject then
        NotifyOnNewObject("/Script/BlueClient.B1AgingComponent", function(_cp)
            if _cp and _cp:IsValid() then
                modifyTimeScale()
            end
        end)
        logInfo("Enregistrement de NotifyOnNewObject reussi.")
    else
        logError("NotifyOnNewObject n'est pas disponible.")
    end
end

-- Enregistrement des hooks
local function registerHooks()
    local setupTriggerFunctions = {
        '/Script/Engine.PlayerController:ClientRestart',
        '/Script/Engine.PlayerController:RestartLevel'
    }

    if RegisterHook then
        local allHooksRegistered = true
        logInfo("Enregistrement des hooks de declenchement...")
        print("\n")
        for _, hookPath in ipairs(setupTriggerFunctions) do
            local success = RegisterHook(hookPath, function(_pc)
                setupMonitoring()
            end)

            if not success then
                logWarning(string.format("Echec de l'enregistrement du hook de declenchement pour %s.", hookPath))
                print("\n")
                allHooksRegistered = false
            end
        end

        if allHooksRegistered then
            logInfo("Tous les hooks de declenchement ont ete enregistres avec succes.")
            print("\n")
        else
            logWarning("Certains hooks de declenchement n'ont pas pu etre enregistres.")
            print("\n")
        end
    else
        logError("RegisterHook n'est pas disponible.")
        print("\n")
    end
end

-- Initialisation du script
printHeader()
registerHooks()
modifyTimeScale()
logInfo("Execution du script terminee.")
print("\n")
print("\n")
print("\n")
print("\n" .. generateSeparator("-") .. "\n")
print("\n")
